/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.message.soap;

import com.sun.xml.messaging.saaj.packaging.mime.internet.ContentType;
import jakarta.xml.soap.MimeHeaders;
import jakarta.xml.soap.SOAPEnvelope;
import jakarta.xml.soap.SOAPHeader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.exception.MessageException;
import org.openspcoop2.message.soap.AbstractOpenSPCoop2Message_soap_impl;
import org.openspcoop2.message.soap.OpenSPCoop2Message_saaj_12_impl;
import org.openspcoop2.message.soap.SoapUtils;
import org.openspcoop2.message.soap.reader.OpenSPCoop2MessageSoapStreamReader;
import org.openspcoop2.utils.io.DumpByteArrayOutputStream;
import org.openspcoop2.utils.transport.http.ContentTypeUtilities;

public class OpenSPCoop2Message_soap12_impl
extends AbstractOpenSPCoop2Message_soap_impl<OpenSPCoop2Message_saaj_12_impl> {
    public OpenSPCoop2Message_soap12_impl(OpenSPCoop2MessageFactory messageFactory, MimeHeaders mhs, InputStream is, long overhead, OpenSPCoop2MessageSoapStreamReader soapStreamReader) throws MessageException {
        super(messageFactory, mhs, is, overhead, soapStreamReader);
    }

    @Override
    protected OpenSPCoop2Message_saaj_12_impl buildContent() throws MessageException {
        try {
            OpenSPCoop2Message_saaj_12_impl openSPCoop2Message_saaj_12_impl = this.buildContent(this._getInputStream());
            return openSPCoop2Message_saaj_12_impl;
        }
        finally {
            try {
                this._getInputStream().close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected OpenSPCoop2Message_saaj_12_impl buildContent(DumpByteArrayOutputStream contentBuffer) throws MessageException {
        try {
            if (contentBuffer.isSerializedOnFileSystem()) {
                try (FileInputStream is = new FileInputStream(contentBuffer.getSerializedFile());){
                    OpenSPCoop2Message_saaj_12_impl openSPCoop2Message_saaj_12_impl = this.buildContent(is);
                    return openSPCoop2Message_saaj_12_impl;
                }
            }
            try (ByteArrayInputStream is = new ByteArrayInputStream(contentBuffer.toByteArray());){
                OpenSPCoop2Message_saaj_12_impl openSPCoop2Message_saaj_12_impl = this.buildContent(is);
                return openSPCoop2Message_saaj_12_impl;
            }
        }
        catch (MessageException me) {
            throw me;
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    protected OpenSPCoop2Message_saaj_12_impl buildContent(InputStream is) throws MessageException {
        try {
            OpenSPCoop2Message_saaj_12_impl msg = new OpenSPCoop2Message_saaj_12_impl(this.messageFactory, this.mhs, is);
            msg.initialize(this.overhead);
            msg.copyResourceFrom(this.soapCore);
            msg.setMessageRole(this.messageRole);
            msg.setMessageType(this.messageType);
            SOAPHeader hdr = msg.getSOAPHeader();
            SOAPEnvelope envelope = msg.getSOAPPart().getEnvelope();
            msg.countAttachments();
            this.addSoapHeaderModifiedIntoSoapReader(hdr, envelope);
            return msg;
        }
        catch (Throwable t) {
            throw SoapUtils.buildMessageException("Unable to create envelope from given source: ", t);
        }
    }

    @Override
    protected String _getContentType() {
        String ct = super._getContentType();
        try {
            ContentType cType = new ContentType(ct);
            String soapActionValue = this.getSoapAction();
            if (soapActionValue != null && StringUtils.isNotEmpty((CharSequence)soapActionValue)) {
                String pSoapAction = cType.getParameter("action");
                if (soapActionValue.equals(pSoapAction)) {
                    return ct;
                }
                if (soapActionValue.startsWith("\"") && soapActionValue.length() > 1) {
                    soapActionValue = soapActionValue.substring(1);
                }
                if (soapActionValue.endsWith("\"") && soapActionValue.length() > 1) {
                    soapActionValue = soapActionValue.substring(0, soapActionValue.length() - 1);
                }
                if (StringUtils.isEmpty((CharSequence)soapActionValue)) {
                    return ct;
                }
                if (pSoapAction != null) {
                    cType.getParameterList().remove("action");
                }
                if (this.contentTypeParamaters != null) {
                    if (this.contentTypeParamaters.containsKey("action")) {
                        this.contentTypeParamaters.remove("action");
                    }
                    this.contentTypeParamaters.put("action", soapActionValue);
                }
                return ContentTypeUtilities.buildContentType((String)cType.toString(), (Map)this.contentTypeParamaters);
            }
            return ct;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return ct;
        }
    }
}

