/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.message.utils;

import java.util.List;
import java.util.Map;
import org.openspcoop2.message.ForwardConfig;
import org.openspcoop2.message.OpenSPCoop2MessageProperties;
import org.openspcoop2.message.constants.MessageRole;
import org.openspcoop2.message.exception.MessageException;

public class TransportUtilities {
    public static void initializeTransportHeaders(OpenSPCoop2MessageProperties op2MessageProperties, MessageRole messageRole, Map<String, List<String>> transportHeaders, ForwardConfig forwardConfig) throws MessageException {
        TransportUtilities.initializeHeaders(true, op2MessageProperties, messageRole, transportHeaders, forwardConfig);
    }

    public static void initializeForwardUrlParameters(OpenSPCoop2MessageProperties op2MessageProperties, MessageRole messageRole, Map<String, List<String>> forwardUrlParameters, ForwardConfig forwardConfig) throws MessageException {
        TransportUtilities.initializeHeaders(false, op2MessageProperties, messageRole, forwardUrlParameters, forwardConfig);
    }

    private static boolean match(String tipoOp, String key, List<String> listParam) {
        String keyLowerCase = key.toLowerCase();
        return listParam.stream().map(String::toLowerCase).anyMatch(p -> p.equals(keyLowerCase) || p.equals("*") || p.endsWith("*") && keyLowerCase.startsWith(p.substring(0, p.length() - 1)));
    }

    private static void initializeHeaders(boolean trasporto, OpenSPCoop2MessageProperties op2MessageProperties, MessageRole messageRole, Map<String, List<String>> applicativeInfo, ForwardConfig forwardConfig) throws MessageException {
        try {
            if (applicativeInfo != null && applicativeInfo.size() > 0) {
                applicativeInfo.forEach((key, values) -> {
                    if (!MessageRole.REQUEST.equals(messageRole) && trasporto && "ReturnCode".equalsIgnoreCase((String)key)) {
                        return;
                    }
                    boolean add = true;
                    boolean white = false;
                    if (forwardConfig.getWhiteList() != null && forwardConfig.getWhiteList().size() > 0) {
                        white = TransportUtilities.match("whiteList", key, forwardConfig.getWhiteList());
                    }
                    if (!white && forwardConfig.getBlackList() != null && forwardConfig.getBlackList().size() > 0 && TransportUtilities.match("blackList", key, forwardConfig.getBlackList())) {
                        add = false;
                    }
                    if (add) {
                        op2MessageProperties.setProperty((String)key, (List<String>)values);
                    }
                });
            }
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }
}

