/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.renderkit.html;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.html.HtmlForm;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.FacesEvent;
import org.ajax4jsf.component.UIAjaxForm;
import org.ajax4jsf.event.AjaxEvent;
import org.ajax4jsf.javascript.JSFunction;
import org.ajax4jsf.javascript.ScriptUtils;
import org.ajax4jsf.renderkit.AjaxComponentRendererBase;
import org.ajax4jsf.renderkit.AjaxRendererUtils;
import org.ajax4jsf.renderkit.RendererUtils;
import org.ajax4jsf.resource.InternetResource;

public class AjaxFormRenderer
extends AjaxComponentRendererBase {
    public static final String FORM_SUBMIT_FUNCTION_NAME = "_JSFFormSubmit";
    public static final String FORM_CLEAR_FUNCTION_NAME = "_clearJSFFormParameters";
    private static final String FORM_HAS_COMMAND_LINK_ATTR = "com.sun.faces.FORM_HAS_COMMAND_LINK_ATTR";
    private static final String NO_COMMAND_LINK_FOUND_VALUE = "com.sun.faces.NO_COMMAND_LINK_FOUND";
    public static final String CONTENT_TYPE_IS_XHTML = "com.sun.facesContentTypeIsXHTML";
    public static final String HIDDEN_FIELD_SUFFIX = ":j_idcl";
    private static final String HIDDEN_COMMAND_INPUTS_SET_ATTR = UIForm.class.getName() + ".org.apache.myfaces.HIDDEN_COMMAND_INPUTS_SET";
    private static final String MYFACES_HIDDEN_FIELD_SUFFIX = ":_link_hidden_";
    private InternetResource[] _scripts = new InternetResource[]{this.getResource("/org/ajax4jsf/javascript/scripts/form.js")};
    private static final String[] exclusions = new String[]{"onsubmit"};
    public static final String AJAX_FORM_FUNCTION_NAME = "A4J.AJAX.SubmitForm";

    protected void doDecode(FacesContext context, UIComponent component) {
        UIForm form = (UIForm)component;
        boolean submitted = context.getExternalContext().getRequestParameterMap().containsKey(component.getClientId(context));
        form.setSubmitted(submitted);
        if (component instanceof UIAjaxForm) {
            UIAjaxForm ajaxForm = (UIAjaxForm)component;
            if (submitted && ajaxForm.isAjaxSubmit()) {
                component.queueEvent((FacesEvent)new AjaxEvent(component));
            }
        }
    }

    protected InternetResource[] getAdditionalScripts() {
        return this._scripts;
    }

    protected void doEncodeBegin(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        String clientId = component.getClientId(context);
        writer.startElement("form", component);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("name", (Object)clientId, null);
        writer.writeAttribute("method", (Object)"post", null);
        this.getUtils().encodeAttribute(context, component, "style");
        this.getUtils().encodeAttribute(context, component, "class");
        this.getUtils().encodePassThru(context, component);
        context.getExternalContext().getRequestMap().put(FORM_HAS_COMMAND_LINK_ATTR, clientId);
        if (component instanceof UIAjaxForm) {
            UIAjaxForm form = (UIAjaxForm)component;
            if (form.isAjaxSubmit()) {
                StringBuffer onSubmit = new StringBuffer("javascript:");
                JSFunction ajaxFunction = AjaxRendererUtils.buildAjaxFunction((UIComponent)component, (FacesContext)context, (String)AJAX_FORM_FUNCTION_NAME);
                ajaxFunction.addParameter((Object)AjaxRendererUtils.buildEventOptions((FacesContext)context, (UIComponent)component, (boolean)false));
                ajaxFunction.appendScript(onSubmit);
                writer.writeURIAttribute("action", (Object)onSubmit, "action");
            } else {
                this.encodeSubmitAction(writer, context);
            }
        } else {
            this.encodeSubmitAction(writer, context);
        }
    }

    private void encodeSubmitAction(ResponseWriter writer, FacesContext context) throws IOException {
        String actionURL = this.getUtils().getActionUrl(context);
        String encodedActionURL = context.getExternalContext().encodeActionURL(actionURL);
        writer.writeURIAttribute("action", (Object)encodedActionURL, "action");
    }

    protected void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        UIAjaxForm form;
        String clientId = component.getClientId(context);
        this.renderHiddenInputField(writer, clientId, clientId);
        this.renderHiddenInputField(writer, "autoScroll", null);
        HashSet<String> hiddenFields = new HashSet<String>();
        hiddenFields.add(clientId + HIDDEN_FIELD_SUFFIX);
        hiddenFields.add(clientId + MYFACES_HIDDEN_FIELD_SUFFIX);
        Set set = (Set)component.getAttributes().get(HIDDEN_COMMAND_INPUTS_SET_ATTR);
        if (set != null) {
            hiddenFields.addAll(set);
        }
        if ((set = (Set)context.getExternalContext().getRequestMap().get(AjaxFormRenderer.getHiddenCommandInputsSetName(context, component))) != null) {
            hiddenFields.addAll(set);
        }
        this.renderHiddenCommandFormParams(writer, hiddenFields);
        String target = component instanceof HtmlForm ? ((HtmlForm)component).getTarget() : (String)component.getAttributes().get("target");
        this.renderClearHiddenCommandFormParamsFunction(context, writer, clientId, hiddenFields, target);
        if (component instanceof UIAjaxForm && (form = (UIAjaxForm)component).isAjaxSubmit()) {
            this.renderAjaxFormSetupScript(context, writer, clientId);
        }
        this.getUtils().encodeEndForm(context, writer);
        context.getExternalContext().getRequestMap().put(FORM_HAS_COMMAND_LINK_ATTR, NO_COMMAND_LINK_FOUND_VALUE);
    }

    private static String getHiddenCommandInputsSetName(FacesContext facesContext, UIComponent form) {
        StringBuffer buf = new StringBuffer();
        buf.append(HIDDEN_COMMAND_INPUTS_SET_ATTR);
        buf.append("_");
        buf.append(form.getClientId(facesContext));
        return buf.toString();
    }

    protected Class getComponentClass() {
        return UIForm.class;
    }

    public void renderHiddenCommandFormParams(ResponseWriter writer, Set formParams) throws IOException {
        for (Object name : formParams) {
            this.renderHiddenInputField(writer, name, "");
        }
    }

    public void renderHiddenInputField(ResponseWriter writer, Object name, Object value) throws IOException {
        writer.startElement("input", null);
        writer.writeAttribute("type", RendererUtils.HTML.INPUT_TYPE_HIDDEN, null);
        writer.writeAttribute("autocomplete", (Object)"off", null);
        writer.writeAttribute("name", name, null);
        writer.writeAttribute("value", value != null ? value : "", null);
        writer.endElement("input");
    }

    public void renderAjaxFormSetupScript(FacesContext context, ResponseWriter writer, String formName) throws IOException {
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        String cspValue = RendererUtils.getCspNonceValue((FacesContext)context);
        if (cspValue != null) {
            writer.writeAttribute("nonce", (Object)cspValue, null);
        }
        writer.writeText((Object)("A4J.setupForm('" + formName + "');"), null);
        writer.endElement("script");
    }

    public void renderClearHiddenCommandFormParamsFunction(FacesContext context, ResponseWriter writer, String formName, Set dummyFormParams, String formTarget) throws IOException {
        String functionName = this.getClearHiddenCommandFormParamsFunctionName(formName);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        String cspValue = RendererUtils.getCspNonceValue((FacesContext)context);
        if (cspValue != null) {
            writer.writeAttribute("nonce", (Object)cspValue, null);
        }
        StringBuffer script = new StringBuffer();
        script.append("function ");
        script.append(functionName);
        script.append("() {\n");
        script.append(FORM_CLEAR_FUNCTION_NAME);
        script.append("('");
        script.append(formName);
        script.append("','");
        if (formTarget != null && formTarget.length() > 0) {
            script.append(formTarget);
        }
        script.append("'");
        if (dummyFormParams != null) {
            script.append(",[");
            Iterator it = dummyFormParams.iterator();
            while (it.hasNext()) {
                script.append('\'');
                script.append((String)it.next());
                script.append('\'');
                if (!it.hasNext()) continue;
                script.append(',');
            }
            script.append("]");
        }
        script.append(");");
        script.append("\n}");
        script.append("\n");
        script.append("function ").append("clearFormHiddenParams_").append(ScriptUtils.getValidJavascriptName((String)formName));
        script.append("(){").append(functionName).append("();}\n");
        StringBuffer formNameReplaceBuffer = new StringBuffer(formName.length());
        int idx = -1;
        int idxA = 0;
        while ((idx = formName.indexOf(45, idxA)) != -1) {
            formNameReplaceBuffer.append(formName.substring(idxA, idx));
            formNameReplaceBuffer.append("$_");
            idxA = idx + 1;
        }
        formNameReplaceBuffer.append(formName.substring(idxA));
        script.append("function ").append("clearFormHiddenParams_").append(formNameReplaceBuffer.toString().replace(':', '_'));
        script.append("(){").append(functionName).append("();}\n");
        script.append(functionName);
        script.append("();");
        writer.writeText((Object)script.toString(), null);
        writer.endElement("script");
    }

    public String getClearHiddenCommandFormParamsFunctionName(String formName) {
        return "clear_" + ScriptUtils.getValidJavascriptName((String)formName);
    }
}

