/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.renderkit.html;

import java.io.IOException;
import java.util.UUID;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.component.UIAjaxStatus;
import org.ajax4jsf.javascript.JSFunctionDefinition;
import org.ajax4jsf.renderkit.RendererBase;
import org.ajax4jsf.renderkit.RendererUtils;

public class AjaxStatusRenderer
extends RendererBase {
    public static final String RENDERER_TYPE = "org.ajax4jsf.components.AjaxStatusRenderer";
    public static final String START_STYLE = "display: none";
    private String uuid;

    public String getUuid() {
        if (this.uuid == null) {
            this.uuid = UUID.randomUUID().toString().replace("-", "");
        }
        return this.uuid;
    }

    public void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        String statusId = component.getClientId(context);
        String tag = this.getTag(component);
        writer.startElement(tag, component);
        writer.writeAttribute("id", (Object)statusId, null);
        this.encodeSpan(writer, context, component, statusId, "start", tag);
        this.encodeSpan(writer, context, component, statusId, "stop", tag);
        writer.endElement(tag);
    }

    protected void encodeSpan(ResponseWriter writer, FacesContext context, UIComponent component, String id, String state, String tag) throws IOException {
        Object eventHandler;
        String styleClass;
        writer.startElement(tag, component);
        String spanId = id + "." + state;
        writer.writeAttribute("id", (Object)spanId, null);
        String style = this.getNamedAttribute(component, "Style", state);
        String statusCssClass = "rich-status-display";
        if ("start".equals(state)) {
            statusCssClass = "rich-status-display-none";
        }
        StringBuffer sb = new StringBuffer();
        if (null != style) {
            sb.append("css-status-" + this.getUuid());
        }
        if (null != (styleClass = this.getNamedAttribute(component, "StyleClass", state))) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(styleClass);
        }
        if (null != statusCssClass) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(statusCssClass);
        }
        if (sb.length() > 0) {
            writer.writeAttribute("class", (Object)sb.toString(), null);
        }
        this.getUtils().encodePassThru(context, component);
        UIComponent facet = component.getFacet(state);
        if (null != facet) {
            this.renderChild(context, facet);
        } else {
            String namedAttribute = this.getNamedAttribute(component, "Text", state);
            if (null != namedAttribute) {
                writer.writeText((Object)namedAttribute, "text");
            }
        }
        writer.endElement(tag);
        if (null != style) {
            writer.startElement("style", component);
            writer.writeAttribute("type", (Object)"text/css", null);
            String cspValue = RendererUtils.getCspNonceValue((FacesContext)context);
            if (cspValue != null) {
                writer.writeAttribute("nonce", (Object)cspValue, null);
            }
            StringBuilder sbStyle = new StringBuilder();
            sbStyle.append(".").append("css-status-").append(this.getUuid()).append(" {\n").append(style).append("}\n");
            writer.writeText((Object)sbStyle.toString(), null);
            writer.endElement("style");
        }
        if (null != (eventHandler = component.getAttributes().get("on" + state))) {
            StringBuffer script = new StringBuffer("\n");
            script.append("window.document.getElementById('").append(spanId).append("').on").append(state).append("=");
            JSFunctionDefinition function = new JSFunctionDefinition(new Object[0]);
            function.addToBody(eventHandler).addToBody((Object)";").appendScript(script);
            script.append(";\n");
            this.getUtils().writeScript(context, component, (Object)script);
        }
    }

    protected String getNamedAttribute(UIComponent component, String name, String state) {
        String fullName = new StringBuffer(state).append(name).toString();
        return (String)component.getAttributes().get(fullName);
    }

    protected Class getComponentClass() {
        return UIAjaxStatus.class;
    }

    private String getTag(UIComponent status) {
        return "block".equals(status.getAttributes().get("layout")) ? "div" : "span";
    }

    public boolean getRendersChildren() {
        return true;
    }
}

