/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import jakarta.el.Expression;
import jakarta.el.ValueExpression;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import org.ajax4jsf.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.richfaces.component.UIDatascroller;
import org.richfaces.component.util.MessageUtil;
import org.richfaces.event.RenderPhaseComponentVisitor;

public class RenderPhaseDataScrollerVisitor
implements RenderPhaseComponentVisitor {
    private static final Log log = LogFactory.getLog(RenderPhaseDataScrollerVisitor.class);

    public Object beforeRoot(PhaseEvent event) {
        return new State(new LinkedList(), new ComponentConnections());
    }

    public void beforeComponent(UIComponent component, PhaseEvent event, Object object) {
        State state = (State)object;
        state.components.addLast(component);
        if (component instanceof UIDatascroller && RenderPhaseDataScrollerVisitor.isRendered(state.components)) {
            UIDatascroller datascroller = (UIDatascroller)component;
            UIData dataTable = datascroller.getDataTable();
            state.connections.addConnection(dataTable, datascroller);
        }
    }

    public void afterComponent(UIComponent component, PhaseEvent event, Object object) {
        State state = (State)object;
        state.components.removeLast();
    }

    public void afterRoot(PhaseEvent event, Object object) {
        State state = (State)object;
        FacesContext facesContext = event.getFacesContext();
        Iterator<Map.Entry<UIData, List<UIDatascroller>>> entries = state.connections.iterator();
        while (entries.hasNext()) {
            Map.Entry<UIData, List<UIDatascroller>> entry = entries.next();
            List<UIDatascroller> scrollers = entry.getValue();
            if (scrollers.isEmpty()) continue;
            ArrayList<Integer> values = new ArrayList<Integer>(scrollers.size());
            UIData data = entry.getKey();
            UIDatascroller activeComponent = null;
            Map attributes = data.getAttributes();
            Object pageValue = attributes.get("org.richfaces.Datascroller:page");
            if (pageValue == null) {
                boolean valid = true;
                for (UIDatascroller datascroller : scrollers) {
                    Integer nextPageValue = null;
                    if (datascroller.isLocalPageSet()) {
                        nextPageValue = datascroller.getPage();
                        attributes.put("org.richfaces.Datascroller:page", nextPageValue);
                        datascroller.resetLocalPage();
                    } else {
                        nextPageValue = datascroller.getValueExpression("page");
                    }
                    if (!values.isEmpty() && !RenderPhaseDataScrollerVisitor.same(values.get(values.size() - 1), nextPageValue)) {
                        valid = false;
                    }
                    values.add(nextPageValue);
                    if (nextPageValue == null) continue;
                    activeComponent = datascroller;
                    pageValue = nextPageValue;
                }
                if (!valid) {
                    StringBuilder builder = new StringBuilder("\n[");
                    Iterator<UIDatascroller> scrollerItr = scrollers.iterator();
                    Iterator valueItr = values.iterator();
                    while (scrollerItr.hasNext()) {
                        UIDatascroller next = scrollerItr.next();
                        builder.append(MessageUtil.getLabel((FacesContext)facesContext, (UIComponent)next));
                        builder.append(": ");
                        Object value = valueItr.next();
                        if (value instanceof Expression) {
                            builder.append(((Expression)value).getExpressionString());
                        } else {
                            builder.append(value);
                        }
                        builder.append(scrollerItr.hasNext() ? ",\n" : "]");
                    }
                    String formattedMessage = Messages.getMessage((String)"DATASCROLLER_PAGES_DIFFERENT", (Object[])new Object[]{MessageUtil.getLabel((FacesContext)facesContext, (UIComponent)data), builder});
                    log.error((Object)formattedMessage);
                }
            }
            if (activeComponent == null) {
                activeComponent = scrollers.get(scrollers.size() - 1);
            }
            if (pageValue == null) continue;
            activeComponent.setupFirstRowValue();
        }
    }

    private static boolean isRendered(List<UIComponent> components) {
        for (UIComponent component : components) {
            boolean rendered;
            block3: {
                rendered = false;
                try {
                    rendered = component.isRendered();
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            if (rendered) continue;
            return false;
        }
        return true;
    }

    private static boolean same(Object o1, Object o2) {
        if (o1 instanceof ValueExpression && o2 instanceof ValueExpression) {
            ValueExpression ve1 = (ValueExpression)o1;
            ValueExpression ve2 = (ValueExpression)o2;
            if (RenderPhaseDataScrollerVisitor.same(ve1.getExpressionString(), ve2.getExpressionString()) && RenderPhaseDataScrollerVisitor.same(ve1.getExpectedType(), ve2.getExpectedType())) {
                return true;
            }
        }
        return o1 != null && o1.equals(o2) || o1 == null && o2 == null;
    }

    private class State {
        private ComponentConnections connections;
        private LinkedList<UIComponent> components;

        private State(LinkedList<UIComponent> components, ComponentConnections connections) {
            this.components = components;
            this.connections = connections;
        }
    }

    private static final class ComponentConnections {
        private final Map<UIData, List<UIDatascroller>> map = new HashMap<UIData, List<UIDatascroller>>();

        private ComponentConnections() {
        }

        public void addConnection(UIData one, UIDatascroller multi) {
            List<UIDatascroller> list = this.map.get(one);
            if (list == null) {
                list = new ArrayList<UIDatascroller>(1);
                this.map.put(one, list);
            }
            list.add(multi);
        }

        public Iterator<Map.Entry<UIData, List<UIDatascroller>>> iterator() {
            return this.map.entrySet().iterator();
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + this.map;
        }
    }
}

