/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import jakarta.el.MethodExpression;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import javax.faces.event.PhaseId;
import org.ajax4jsf.component.AjaxComponent;
import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.event.AjaxEvent;
import org.ajax4jsf.event.AjaxListener;
import org.ajax4jsf.event.AjaxSource;
import org.ajax4jsf.renderkit.AjaxRendererUtils;
import org.richfaces.component.SelectSuggestionEvent;

public abstract class UISuggestionBox
extends UIData
implements AjaxComponent,
AjaxSource,
ValueHolder {
    public static final String COMPONENT_TYPE = "org.richfaces.SuggestionBox";
    public static final String COMPONENT_FAMILY = "org.richfaces.SuggestionBox";
    private transient boolean submitted = false;
    private int rowNumber = -1;

    public abstract Object getSubmitedValue();

    public abstract void setSubmitedValue(Object var1);

    public void setSubmitedValue(Object suggestionValue, String[] requestedValues) {
        this.setSubmitedValue(new SubmittedValue(suggestionValue, requestedValues));
    }

    public abstract String getFor();

    public abstract void setFor(String var1);

    public abstract MethodExpression getSuggestionAction();

    public abstract void setSuggestionAction(MethodExpression var1);

    public abstract Converter getConverter();

    public abstract void setConverter(Converter var1);

    public abstract String getRowClasses();

    public abstract void setRowClasses(String var1);

    public abstract String getSelectValueClass();

    public abstract void setSelectValueClass(String var1);

    public abstract String getBorder();

    public abstract void setBorder(String var1);

    public abstract String getCellpadding();

    public abstract void setCellpadding(String var1);

    public abstract boolean isImmediate();

    public abstract void setImmediate(boolean var1);

    public abstract boolean isSelfRendered();

    public abstract void setSelfRendered(boolean var1);

    public abstract String getEntryClass();

    public abstract void setEntryClass(String var1);

    public boolean isSubmitted() {
        return this.submitted;
    }

    public void setSubmitted(boolean s) {
        this.submitted = s;
    }

    public abstract int getZindex();

    public abstract void setZindex(int var1);

    public abstract String getNothingLabel();

    public abstract void setNothingLabel(String var1);

    public abstract Object getFetchValue();

    public abstract void setFetchValue(Object var1);

    private Object getModelValuesData() {
        int first = this.getFirst();
        int rows = this.getRows();
        int rowIndex = this.getRowIndex();
        this.setFirst(0);
        this.setRows(0);
        this.setRowIndex(-1);
        ArrayList<Object> results = new ArrayList<Object>();
        int j = 0;
        boolean stop = false;
        while (!stop) {
            this.setRowIndex(j++);
            if (this.isRowAvailable()) {
                results.add(this.getRowData());
                continue;
            }
            stop = true;
        }
        this.setFirst(first);
        this.setRows(rows);
        this.setRowIndex(rowIndex);
        return results;
    }

    private Object getRequestedValuesData() {
        MethodExpression suggestingAction;
        String[] requestedValues;
        SubmittedValue valueHolder = (SubmittedValue)this.getSubmitedValue();
        FacesContext context = this.getFacesContext();
        if (valueHolder != null && (requestedValues = valueHolder.getRequestedValues()) != null && (suggestingAction = this.getSuggestionAction()) != null) {
            int first = this.getFirst();
            int rows = this.getRows();
            int rowIndex = this.getRowIndex();
            Object value = this.getValue();
            this.setFirst(0);
            this.setRows(0);
            HashMap<String, Object> results = new HashMap<String, Object>();
            for (int i = 0; i < requestedValues.length; ++i) {
                String requestedValue = requestedValues[i];
                if (requestedValue == null) continue;
                this.setValue(suggestingAction.invoke(context.getELContext(), new Object[]{requestedValue}));
                this.setRowIndex(-1);
                int j = 0;
                boolean stop = false;
                while (!stop) {
                    this.setRowIndex(j++);
                    if (this.isRowAvailable()) {
                        Object fetchValue = this.getFetchValue();
                        if (fetchValue == null || !requestedValue.equalsIgnoreCase(fetchValue.toString())) continue;
                        results.put(requestedValue, this.getRowData());
                        stop = true;
                        continue;
                    }
                    stop = true;
                }
            }
            this.setFirst(first);
            this.setRows(rows);
            this.setRowIndex(rowIndex);
            this.setValue(value);
            return results;
        }
        return null;
    }

    public int getRowNumber() {
        return this.rowNumber;
    }

    public void setRowNumber(int rowNumber) {
        this.rowNumber = rowNumber;
    }

    public final void broadcast(FacesEvent event) throws AbortProcessingException {
        super.broadcast(event);
        if (event instanceof AjaxEvent) {
            FacesContext context = this.getFacesContext();
            this.setupValue(context);
            AjaxContext ajaxContext = AjaxContext.getCurrentInstance((FacesContext)context);
            if (this.isUsingSuggestObjects()) {
                Object modelValues = this.getModelValuesData();
                Object requestedData = this.getRequestedValuesData();
                if (null != modelValues || null != requestedData) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("suggestionObjects", modelValues);
                    if (requestedData != null) {
                        map.put("requestedObjects", requestedData);
                    }
                    ajaxContext.setResponseData(map);
                }
            }
            AjaxRendererUtils.addRegionsFromComponent((UIComponent)this, (FacesContext)context);
            AjaxRendererUtils.addRegionByName((FacesContext)context, (UIComponent)this, (String)this.getId());
            if (this.isSelfRendered()) {
                ajaxContext.setSelfRender(true);
            }
        } else if (event instanceof SelectSuggestionEvent) {
            this.setValue(null);
        }
    }

    public void queueEvent(FacesEvent event) {
        if (event instanceof SelectSuggestionEvent) {
            event.setPhaseId(PhaseId.RENDER_RESPONSE);
            super.queueEvent(event);
        } else if (event.getComponent() != this && this.rowNumber != -1) {
            int prevIndex = this.getRowIndex();
            this.setRowIndex(this.rowNumber);
            super.queueEvent(event);
            this.setRowIndex(prevIndex);
        } else {
            super.queueEvent(event);
        }
    }

    public void processDecodes(FacesContext context) {
        String clientId;
        if (!this.isRendered()) {
            return;
        }
        Map requestParameterMap = context.getExternalContext().getRequestParameterMap();
        String rowValue = (String)requestParameterMap.get((clientId = this.getClientId(context)) + "_selection");
        if (rowValue != null && rowValue.length() != 0) {
            this.setRowNumber(Integer.parseInt(rowValue) + this.getFirst());
            this.setupValue(context);
            this.queueEvent(new SelectSuggestionEvent((UIComponent)this));
        } else {
            this.setRowNumber(-1);
        }
        super.processDecodes(context);
    }

    public void setupValue(FacesContext context) {
        SubmittedValue valueHolder = (SubmittedValue)this.getSubmitedValue();
        Object submittedValue = valueHolder != null ? valueHolder.getSuggestionValue() : null;
        MethodExpression suggestingAction = this.getSuggestionAction();
        if (null != suggestingAction) {
            this.setValue(suggestingAction.invoke(context.getELContext(), new Object[]{submittedValue}));
        }
    }

    public void addAjaxListener(AjaxListener listener) {
        this.addFacesListener((FacesListener)listener);
    }

    public AjaxListener[] getAjaxListeners() {
        return (AjaxListener[])this.getFacesListeners(AjaxListener.class);
    }

    public void removeAjaxListener(AjaxListener listener) {
        this.removeFacesListener((FacesListener)listener);
    }

    public Object getLocalValue() {
        return null;
    }

    public abstract String getStyleClass();

    public abstract void setStyleClass(String var1);

    public abstract String getPopupClass();

    public abstract void setPopupClass(String var1);

    public abstract String getStyle();

    public abstract void setStyle(String var1);

    public abstract String getPopupStyle();

    public abstract void setPopupStyle(String var1);

    public abstract boolean isUsingSuggestObjects();

    public abstract void setUsingSuggestObjects(boolean var1);

    private static final class SubmittedValue
    implements Serializable {
        private static final long serialVersionUID = 2032953038329023808L;
        private Object suggestionValue;
        private String[] requestedValues;

        public SubmittedValue() {
        }

        public SubmittedValue(Object suggestionValue, String[] requestedValues) {
            this.suggestionValue = suggestionValue;
            this.requestedValues = requestedValues;
        }

        public Object getSuggestionValue() {
            return this.suggestionValue;
        }

        public String[] getRequestedValues() {
            return this.requestedValues;
        }
    }
}

