/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.javascript.JSFunction;
import org.ajax4jsf.javascript.ScriptUtils;
import org.ajax4jsf.renderkit.AjaxRendererUtils;
import org.ajax4jsf.renderkit.HeaderResourcesRendererBase;
import org.ajax4jsf.renderkit.RendererUtils;
import org.richfaces.component.UITab;
import org.richfaces.component.UITabPanel;
import org.richfaces.component.util.HtmlUtil;
import org.richfaces.renderkit.TabPanelRendererBase;

public class TabHeaderRendererBase
extends HeaderResourcesRendererBase {
    private static final String LABEL_SUFFIX = "_lbl";
    private static final String ONMOUSEOVER = "RichFaces.overTab(this);";
    private static final String ONMOUSEOUT = "RichFaces.outTab(this);";

    protected Class<? extends UIComponent> getComponentClass() {
        return UITab.class;
    }

    public List<String> encodeParams(FacesContext context, UITab component) throws IOException {
        UITab menuItem = component;
        ArrayList<String> params = new ArrayList<String>();
        StringBuffer buff = new StringBuffer();
        List children = menuItem.getChildren();
        for (UIComponent child : children) {
            UIParameter param;
            String name;
            if (!(child instanceof UIParameter) || (name = (param = (UIParameter)child).getName()) == null) continue;
            Object value = param.getValue();
            buff.append("_params[");
            buff.append(ScriptUtils.toScript((Object)name));
            buff.append("] = ");
            buff.append(ScriptUtils.toScript((Object)value));
            buff.append(";");
            params.add(buff.toString());
            buff.setLength(0);
        }
        return params;
    }

    public void encodeTabLabel(FacesContext context, UITab tab) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String label = tab.getLabel();
        if (label == null) {
            label = "";
        }
        String clientId = tab.getClientId(context);
        String cssId = RendererUtils.getCssId((String)clientId);
        String cssClassName = cssId + "-shifted-style";
        writer.writeAttribute("class", (Object)cssClassName, null);
    }

    public String getOnClickEventHandler(FacesContext context, UITab tab) throws IOException {
        String script = "";
        boolean disabled = tab.isDisabled();
        UITabPanel pane = tab.getPane();
        String method = tab.getSwitchTypeOrDefault();
        boolean ajax = "ajax".equals(method);
        boolean clientSide = "client".equals(method);
        String clientId = tab.getClientId(context);
        if (!disabled) {
            StringBuffer sb = new StringBuffer();
            if (clientSide) {
                sb.append("if (RichFaces.onTabChange(event, '");
                sb.append(pane.getClientId(context));
                sb.append("','");
                sb.append(clientId);
                sb.append("')) RichFaces.switchTab('");
                sb.append(pane.getClientId(context));
                sb.append("','");
                sb.append(clientId);
                sb.append("','");
                sb.append(this.getUtils().formatValue(context, (UIComponent)pane, tab.getName()));
                sb.append("');");
            } else {
                String activeCheck = "if (RichFaces.isTabActive('" + clientId + LABEL_SUFFIX + "')) return false;";
                String eventCheck = " if (!RichFaces.onTabChange(event, '" + pane.getClientId(context) + "','" + clientId + "')) return false;";
                if (ajax) {
                    JSFunction function = AjaxRendererUtils.buildAjaxFunction((UIComponent)tab, (FacesContext)context);
                    Map eventOptions = AjaxRendererUtils.buildEventOptions((FacesContext)context, (UIComponent)tab, (boolean)true);
                    function.addParameter((Object)eventOptions);
                    sb.append(activeCheck);
                    sb.append(eventCheck);
                    function.appendScript(sb);
                    sb.append("; return false; this.onclick = null;");
                } else {
                    sb.append(activeCheck);
                    sb.append(eventCheck);
                    sb.append("var _formName = A4J.findForm(this).id; var _paramName = '" + clientId + "_server_submit'; var _params = new Object(); _params[_paramName] = _paramName; ");
                    List<String> params = this.encodeParams(context, tab);
                    Iterator<String> iterator = params.iterator();
                    while (iterator.hasNext()) {
                        sb.append(iterator.next());
                    }
                    sb.append("_JSFFormSubmit('");
                    sb.append(clientId);
                    sb.append("', _formName, null, _params);");
                    sb.append("this.onclick = null; _clearJSFFormParameters(_formName, null, [_paramName]);");
                }
            }
            script = sb.toString();
        }
        return script;
    }

    public void encodeTabLabelClass(FacesContext context, UITab tab) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = tab.getClientId(context);
        String defShift = tab.isActive() ? "position:relative; top:1px;" : "position:relative;";
        String componentStyle = (String)tab.getAttributes().get("style");
        String style = defShift + (componentStyle != null ? componentStyle : "");
        String width = tab.getLabelWidth();
        style = style + ";height : 100%; ";
        if (width != null) {
            style = style + " width: " + this.getUtils().encodePctOrPx(width) + ";";
        }
        String cssId = RendererUtils.getCssId((String)clientId);
        String cssClassName = cssId + "-shifted-style";
        String finalClass = "." + cssClassName + " {" + style + "}";
        writer.writeText((Object)finalClass, null);
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeCellClasses(FacesContext context, UITab tab) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String labelClass = tab.isDisabled() ? "rich-tabhdr-cell-disabled" : (tab.isActive() ? "rich-tabhdr-cell-active" : "rich-tabhdr-cell-inactive");
        String clientId = tab.getClientId(context);
        String cssId = RendererUtils.getCssId((String)clientId);
        labelClass = labelClass + " " + cssId + "-tab-cell-td-style";
        writer.writeAttribute("class", (Object)labelClass, null);
    }

    public void writeLabel(FacesContext context, UITab tab) throws IOException {
        UIComponent facet;
        ResponseWriter writer = context.getResponseWriter();
        String labelClass = "";
        labelClass = tab.isDisabled() ? TabPanelRendererBase.getDisabledTabClass(tab) : (tab.isActive() ? TabPanelRendererBase.getActiveTabClass(tab) : TabPanelRendererBase.getInactiveTabClass(tab));
        writer.writeAttribute("class", (Object)labelClass, "tabClass");
        String title = tab.getTitle();
        if (title != null && title.length() != 0) {
            writer.writeAttribute("title", (Object)title, null);
        }
        if ((facet = tab.getFacet("label")) != null && facet.isRendered()) {
            this.renderChild(context, facet);
        } else {
            String label = tab.getLabel();
            if (label == null || label.length() == 0) {
                label = "&#160;";
                writer.write(label);
            } else {
                writer.writeText((Object)label, null);
            }
        }
    }

    public String getLabelEventsHandler(FacesContext context, UITab tab) throws IOException {
        StringBuffer sb = new StringBuffer();
        String tag = "td";
        String clientId = tab.getClientId(context) + LABEL_SUFFIX;
        sb.append("jQuery(\"" + tag + "[id$='" + clientId + "']\").mouseover(function() {");
        sb.append(ONMOUSEOVER);
        sb.append("});");
        sb.append("jQuery(\"" + tag + "[id$='" + clientId + "']\").mouseout(function() {");
        sb.append(ONMOUSEOUT);
        sb.append("});");
        this.addEvent(tab, sb, tag, clientId, "onlabelclick", "click");
        this.addEvent(tab, sb, tag, clientId, "onlabelkeypress", "keypress");
        this.addEvent(tab, sb, tag, clientId, "onlabeldblclick", "dblclick");
        this.addEvent(tab, sb, tag, clientId, "onlabelkeyup", "keyup");
        this.addEvent(tab, sb, tag, clientId, "onlabelkeydown", "keydown");
        this.addEvent(tab, sb, tag, clientId, "onlabelmousedown", "mousedown");
        this.addEvent(tab, sb, tag, clientId, "onlabelmouseup", "mouseup");
        this.addEvent(tab, sb, tag, clientId, "onlabelmousemove", "mousemove");
        return sb.toString();
    }

    private void addEvent(UITab tab, StringBuffer sb, String tag, String clientId, String attribute, String jQueryEvent) {
        Object event = tab.getAttributes().get(attribute);
        if (null != event) {
            sb.append("jQuery(\"" + tag + "[id$='" + clientId + "']\")." + jQueryEvent + "(function() {");
            sb.append(event);
            sb.append("});");
        }
    }

    protected String encodeTabLabelWidth(FacesContext context, UITab tab) {
        String labelWidth = tab.getLabelWidth();
        if (labelWidth == null || labelWidth.trim().length() == 0) {
            return "";
        }
        return "width: " + HtmlUtil.qualifySize((String)labelWidth) + ";";
    }

    public String encodeHeaderSpacing(FacesContext context, UITab tab) throws IOException {
        UITabPanel pane = tab.getPane();
        String headerSpacing = pane.getHeaderSpacing();
        return "width: " + HtmlUtil.qualifySize((String)headerSpacing) + "; ";
    }
}

