/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.renderkit.RendererUtils;
import org.richfaces.component.Column;
import org.richfaces.component.UIColumnGroup;
import org.richfaces.renderkit.AbstractRowsRenderer;
import org.richfaces.renderkit.TableHolder;

public class ColgroupRenderer
extends AbstractRowsRenderer {
    public static final String[] EVENT_ATTRS = new String[AbstractRowsRenderer.TABLE_EVENT_ATTRS.length];

    protected void doEncodeBegin(ResponseWriter writer, FacesContext context, UIComponent colgroup) throws IOException {
        this.encodeRowStart(context, colgroup, writer, 0);
    }

    @Override
    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        UIColumnGroup colgroup = (UIColumnGroup)component;
        ResponseWriter writer = context.getResponseWriter();
        String[] classes = null;
        String columnClasses = (String)component.getAttributes().get("columnClasses");
        if (null != columnClasses) {
            classes = columnClasses.split(",");
        }
        Iterator<UIComponent> iter = colgroup.columns();
        boolean first = true;
        int currentColumn = 0;
        int currentRow = 0;
        UIComponent column = null;
        Map requestMap = context.getExternalContext().getRequestMap();
        while (iter.hasNext()) {
            column = iter.next();
            if (column instanceof Column) {
                boolean breakBefore = ((Column)column).isBreakBefore();
                if (breakBefore && !first) {
                    writer.endElement("tr");
                    currentColumn = 0;
                    this.encodeRowStart(context, (UIComponent)colgroup, writer, ++currentRow);
                }
                String styleClass = null;
                if (null != classes) {
                    styleClass = classes[currentColumn % classes.length];
                }
                this.encodeCellChildren(context, column, null, null, null, (String)requestMap.get(AbstractRowsRenderer.SKIN_CELL_CLASS_KEY), styleClass);
            } else if (column.isRendered()) {
                writer.startElement("td", column);
                this.getUtils().encodeId(context, column);
                String styleClass = null != classes ? classes[currentColumn % classes.length] : (String)column.getAttributes().get("styleClass");
                this.encodeStyleClass(context.getResponseWriter(), requestMap.get(AbstractRowsRenderer.SKIN_CELL_CLASS_KEY), "rich-table-cell", requestMap.get(AbstractRowsRenderer.CELL_CLASS_KEY), styleClass);
                this.renderChildren(context, column);
                writer.endElement("td");
            }
            ++currentColumn;
            first = false;
        }
    }

    protected void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        writer.endElement("tr");
    }

    private void encodeRowStart(FacesContext context, UIComponent colspan, ResponseWriter writer, int currentRow) throws IOException {
        String styleClass;
        String rowClasses = (String)colspan.getAttributes().get("rowClasses");
        String style = (String)colspan.getAttributes().get("style");
        if (null != rowClasses) {
            String[] classes = rowClasses.split(",");
            styleClass = classes[currentRow % classes.length];
        } else {
            styleClass = (String)colspan.getAttributes().get("styleClass");
        }
        if (style != null) {
            style = this.getEncodedStyle(context.getResponseWriter(), null, null, null, style);
            String cssClassName = RendererUtils.getCssId((FacesContext)context, (UIComponent)colspan);
            this.getUtils().writeStyle(writer, context, colspan, cssClassName, style);
            styleClass = this.getUtils().concatStyleClasses(styleClass, cssClassName);
        }
        String eventScript = this.creaScriptEventHandler(writer, context, colspan, "tr");
        this.getUtils().writeScript(writer, context, colspan, (Object)eventScript);
        writer.startElement("tr", colspan);
        Map requestMap = context.getExternalContext().getRequestMap();
        Object skinRowClass = currentRow == 0 ? requestMap.get(AbstractRowsRenderer.SKIN_FIRST_ROW_CLASS_KEY) : requestMap.get(AbstractRowsRenderer.SKIN_ROW_CLASS_KEY);
        this.encodeStyleClass(context.getResponseWriter(), skinRowClass, "rich-tablerow", requestMap.get(AbstractRowsRenderer.ROW_CLASS_KEY), styleClass);
        this.getUtils().encodePassThruWithExclusionsArray(context, colspan, (Object[])EVENT_ATTRS);
    }

    protected String creaScriptEventHandler(ResponseWriter writer, FacesContext context, UIComponent colspan, String tag) throws IOException {
        String clientId = colspan.getClientId(context);
        return this.creaScriptEventHandler(writer, context, colspan, tag, clientId);
    }

    protected String creaScriptEventHandler(ResponseWriter writer, FacesContext context, UIComponent colspan, String tag, String clientId) throws IOException {
        StringBuffer sb = new StringBuffer();
        UIComponent parent = colspan.getParent();
        boolean inRow = null != parent && parent.getChildren().contains(colspan);
        sb.append("jQuery(document).ready(function() {");
        for (int i = 0; i < AbstractRowsRenderer.TABLE_EVENT_ATTRS.length; ++i) {
            String[] attrs = AbstractRowsRenderer.TABLE_EVENT_ATTRS[i];
            String event = (String)colspan.getAttributes().get(attrs[0]);
            if (null == event && inRow) {
                event = (String)parent.getAttributes().get(attrs[1]);
            }
            if (null == event) continue;
            String jQueryEvent = attrs[0].substring(attrs[0].indexOf("on") + "on".length());
            sb.append("jQuery(\"" + tag + "[id$='" + clientId + "']\")." + jQueryEvent + "(function() {");
            sb.append(event);
            sb.append("});");
        }
        sb.append("});");
        return sb.toString();
    }

    @Override
    public boolean getRendersChildren() {
        return true;
    }

    protected Class<? extends UIComponent> getComponentClass() {
        return UIColumnGroup.class;
    }

    @Override
    public void encodeOneRow(FacesContext context, TableHolder holder) throws IOException {
    }

    static {
        for (int i = 0; i < AbstractRowsRenderer.TABLE_EVENT_ATTRS.length; ++i) {
            ColgroupRenderer.EVENT_ATTRS[i] = AbstractRowsRenderer.TABLE_EVENT_ATTRS[i][0];
        }
    }
}

