/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.validator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.validation.ConstraintViolation;
import javax.validation.MessageInterpolator;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorContext;
import javax.validation.ValidatorFactory;
import org.richfaces.validator.ObjectValidator;

public class BeanValidator
extends ObjectValidator {
    private static final Class[] DEFAULT_PROFILE = new Class[0];
    private final ValidatorFactory validatorFactory;
    private ValidatorContext validatorContext;

    BeanValidator() {
        ValidatorFactory.class.getName();
        this.validatorFactory = Validation.buildDefaultValidatorFactory();
        this.validatorContext = this.validatorFactory.usingContext();
        JsfMessageInterpolator jsfMessageInterpolator = new JsfMessageInterpolator(this.validatorFactory.getMessageInterpolator());
        this.validatorContext.messageInterpolator((MessageInterpolator)jsfMessageInterpolator);
    }

    @Override
    protected Collection<String> validate(FacesContext facesContext, Object base, String property, Object value, Set<String> profiles) {
        Class<?> beanType = base.getClass();
        Set constrains = this.getValidator(facesContext).validateValue(beanType, property, value, (Class[])this.getGroups(profiles));
        return this.extractMessages(constrains);
    }

    @Override
    public Collection<String> validateGraph(FacesContext context, Object value, Set<String> profiles) {
        Class[] groups = this.getGroups(profiles);
        Set violations = this.getValidator(context).validate(value, groups);
        Collection<String> messages = this.extractMessages(violations);
        if (null != this.parent) {
            Collection<String> parentMessages = this.parent.validateGraph(context, value, profiles);
            if (null != messages) {
                if (null != parentMessages) {
                    messages.addAll(parentMessages);
                }
            } else {
                messages = parentMessages;
            }
        }
        return messages;
    }

    private Class<?>[] getGroups(Set<String> profiles) {
        Class[] groups = null;
        if (null != profiles) {
            groups = new Class[profiles.size()];
            int i = 0;
            for (String group : profiles) {
                try {
                    groups[i] = Class.forName(group, false, Thread.currentThread().getContextClassLoader());
                }
                catch (ClassNotFoundException e) {
                    try {
                        groups[i] = Class.forName(group);
                    }
                    catch (ClassNotFoundException e1) {
                        throw new FacesException("Bean validation group not found " + group, (Throwable)e1);
                    }
                }
                ++i;
            }
        } else {
            groups = DEFAULT_PROFILE;
        }
        return groups;
    }

    private Collection<String> extractMessages(Set<ConstraintViolation<Object>> violations) {
        ArrayList<String> messages = null;
        if (null != violations && violations.size() > 0) {
            messages = new ArrayList<String>(violations.size());
            for (ConstraintViolation<Object> constraintViolation : violations) {
                messages.add(constraintViolation.getMessage());
            }
        }
        return messages;
    }

    protected Validator getValidator(FacesContext facesContext) {
        Validator beanValidator = this.validatorContext.getValidator();
        return beanValidator;
    }

    private static class JsfMessageInterpolator
    implements MessageInterpolator {
        private MessageInterpolator delegate;

        public JsfMessageInterpolator(MessageInterpolator delegate) {
            this.delegate = delegate;
        }

        public String interpolate(String messageTemplate, MessageInterpolator.Context context) {
            Locale locale = ObjectValidator.calculateLocale(FacesContext.getCurrentInstance());
            if (null != locale) {
                return this.delegate.interpolate(messageTemplate, context, locale);
            }
            return this.delegate.interpolate(messageTemplate, context);
        }

        public String interpolate(String messageTemplate, MessageInterpolator.Context context, Locale locale) {
            Locale faceslocale = ObjectValidator.calculateLocale(FacesContext.getCurrentInstance());
            if (null != faceslocale) {
                return this.delegate.interpolate(messageTemplate, context, faceslocale);
            }
            return this.delegate.interpolate(messageTemplate, context, locale);
        }
    }
}

