/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.basic.archive;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.openspcoop2.core.allarmi.constants.RuoloPorta;
import org.openspcoop2.core.config.Configurazione;
import org.openspcoop2.core.config.ConfigurazioneUrlInvocazione;
import org.openspcoop2.core.controllo_traffico.ConfigurazioneGenerale;
import org.openspcoop2.core.controllo_traffico.constants.RuoloPolicy;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDAccordoCooperazione;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.mapping.MappingFruizionePortaDelegata;
import org.openspcoop2.core.registry.driver.IDAccordoCooperazioneFactory;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.archive.ArchiveAccordoCooperazione;
import org.openspcoop2.protocol.sdk.archive.ArchiveAccordoServizioComposto;
import org.openspcoop2.protocol.sdk.archive.ArchiveAccordoServizioParteComune;
import org.openspcoop2.protocol.sdk.archive.ArchiveAccordoServizioParteSpecifica;
import org.openspcoop2.protocol.sdk.archive.ArchiveActivePolicy;
import org.openspcoop2.protocol.sdk.archive.ArchiveAllarme;
import org.openspcoop2.protocol.sdk.archive.ArchiveAttributeAuthority;
import org.openspcoop2.protocol.sdk.archive.ArchiveConfigurationPolicy;
import org.openspcoop2.protocol.sdk.archive.ArchiveEsitoImport;
import org.openspcoop2.protocol.sdk.archive.ArchiveEsitoImportDetail;
import org.openspcoop2.protocol.sdk.archive.ArchiveEsitoImportDetailConfigurazione;
import org.openspcoop2.protocol.sdk.archive.ArchiveFruitore;
import org.openspcoop2.protocol.sdk.archive.ArchiveGruppo;
import org.openspcoop2.protocol.sdk.archive.ArchiveIdCorrelazione;
import org.openspcoop2.protocol.sdk.archive.ArchiveMappingErogazione;
import org.openspcoop2.protocol.sdk.archive.ArchiveMappingFruizione;
import org.openspcoop2.protocol.sdk.archive.ArchivePdd;
import org.openspcoop2.protocol.sdk.archive.ArchivePluginArchivio;
import org.openspcoop2.protocol.sdk.archive.ArchivePluginClasse;
import org.openspcoop2.protocol.sdk.archive.ArchivePortaApplicativa;
import org.openspcoop2.protocol.sdk.archive.ArchivePortaDelegata;
import org.openspcoop2.protocol.sdk.archive.ArchiveRuolo;
import org.openspcoop2.protocol.sdk.archive.ArchiveScope;
import org.openspcoop2.protocol.sdk.archive.ArchiveServizioApplicativo;
import org.openspcoop2.protocol.sdk.archive.ArchiveSoggetto;
import org.openspcoop2.protocol.sdk.archive.ArchiveTokenPolicy;
import org.openspcoop2.protocol.sdk.archive.ArchiveUrlInvocazioneRegola;
import org.openspcoop2.protocol.sdk.constants.ArchiveStatoImport;

public class EsitoUtils {
    protected IProtocolFactory<?> protocolFactory = null;
    protected IDAccordoCooperazioneFactory idAccordoCooperazioneFactory;
    protected IDAccordoFactory idAccordoFactory;
    protected IDServizioFactory idServizioFactory;
    public static final String LABEL_IMPORT_POLICY = "Policy di Configurazione";
    public static final String LABEL_DELETE_POLICY = "Policy di Configurazione";
    public static final String LABEL_IMPORT_PLUGIN = "Plugins";
    public static final String LABEL_DELETE_PLUGIN = "Plugins";
    public static final String LABEL_IMPORT_CONFIGURAZIONE = "Configurazione di GovWay";

    public EsitoUtils(IProtocolFactory<?> protocolFactory) {
        this.protocolFactory = protocolFactory;
        this.idAccordoCooperazioneFactory = IDAccordoCooperazioneFactory.getInstance();
        this.idAccordoFactory = IDAccordoFactory.getInstance();
        this.idServizioFactory = IDServizioFactory.getInstance();
    }

    public String toString(ArchiveEsitoImport archive, boolean readIdCorrelazione, boolean importOperation) throws ProtocolException {
        if (!readIdCorrelazione) {
            return this._toString(archive, importOperation);
        }
        HashMap<String, ArchiveEsitoImport> map = new HashMap<String, ArchiveEsitoImport>();
        HashMap<String, ArchiveIdCorrelazione> mapIdCorrelazione = new HashMap<String, ArchiveIdCorrelazione>();
        this.readIdCorrelazione(map, mapIdCorrelazione, archive);
        if (map.size() < 1) {
            return "";
        }
        if (map.size() == 1) {
            for (String idCorrelazione : map.keySet()) {
                if (!"@PackageOpenSPCoop@".equals(idCorrelazione)) continue;
                return this._toString(archive, importOperation);
            }
        }
        StringBuilder bfEsito = new StringBuilder();
        ArchiveEsitoImport defaultArchiveEsitoImport = null;
        ArchiveIdCorrelazione defaultArchiveIdCorrelazione = null;
        ArrayList<String> idCorrelazioneOrdinato = new ArrayList<String>();
        for (String idCorrelazione : map.keySet()) {
            idCorrelazioneOrdinato.add(idCorrelazione);
        }
        Collections.sort(idCorrelazioneOrdinato);
        for (String idCorrelazione : idCorrelazioneOrdinato) {
            ArchiveIdCorrelazione archiveIdCorrelazione = (ArchiveIdCorrelazione)mapIdCorrelazione.get(idCorrelazione);
            ArchiveEsitoImport archiveCorrelazione = (ArchiveEsitoImport)map.get(idCorrelazione);
            if ("@PackageOpenSPCoop@".equals(idCorrelazione)) {
                defaultArchiveEsitoImport = archiveCorrelazione;
                defaultArchiveIdCorrelazione = archiveIdCorrelazione;
                continue;
            }
            this.append(bfEsito, archiveIdCorrelazione, archiveCorrelazione, importOperation);
        }
        if (defaultArchiveEsitoImport != null) {
            ArchiveIdCorrelazione i = new ArchiveIdCorrelazione(defaultArchiveIdCorrelazione.getId());
            i.setDescrizione("       Altro      ");
            this.append(bfEsito, i, defaultArchiveEsitoImport, importOperation);
        }
        return bfEsito.toString();
    }

    private void append(StringBuilder bfEsito, ArchiveIdCorrelazione archiveIdCorrelazione, ArchiveEsitoImport archiveCorrelazione, boolean importOperation) {
        int i;
        String descrizione = archiveIdCorrelazione.getDescrizione();
        if (descrizione == null) {
            descrizione = archiveIdCorrelazione.getId();
        }
        for (i = 0; i < descrizione.length(); ++i) {
            bfEsito.append("=");
        }
        bfEsito.append("\n");
        bfEsito.append(descrizione);
        bfEsito.append("\n");
        for (i = 0; i < descrizione.length(); ++i) {
            bfEsito.append("=");
        }
        bfEsito.append("\n");
        bfEsito.append("\n");
        bfEsito.append(this._toString(archiveCorrelazione, importOperation));
        bfEsito.append("\n\n");
    }

    private String _toString(ArchiveEsitoImport archive, boolean importOperation) {
        ArchiveEsitoImportDetail archiveTokenPolicy;
        String nomePolicy;
        ArchiveEsitoImportDetail archiveCCPolicy;
        int i;
        IDServizio idServizio;
        String nome;
        MappingFruizionePortaDelegata mapping;
        IDSoggetto idProprietario;
        IDServizio idServizio2;
        ArchiveEsitoImportDetail archiveAccordoServizioParteSpecifica;
        IDAccordo idAccordo;
        String uriAccordo;
        int i2;
        StringBuilder bfEsito = new StringBuilder();
        String labelNonErrore = "non importato";
        if (!importOperation) {
            labelNonErrore = "non eliminato";
        }
        if (archive.getPdd().size() > 0) {
            bfEsito.append("Gateway (").append(archive.getPdd().size()).append(")\n");
        }
        for (i2 = 0; i2 < archive.getPdd().size(); ++i2) {
            try {
                ArchiveEsitoImportDetail archivePdd = (ArchiveEsitoImportDetail)archive.getPdd().get(i2);
                String nomePdd = ((ArchivePdd)archivePdd.getArchiveObject()).getNomePdd();
                bfEsito.append("\t- [").append(nomePdd).append("] ");
                this.serializeStato(archivePdd, bfEsito, importOperation);
            }
            catch (Throwable e) {
                bfEsito.append("\t- [").append(i2 + 1).append("] " + labelNonErrore + ": ").append(e.getMessage());
            }
            bfEsito.append("\n");
        }
        if (archive.getPdd().size() > 0) {
            bfEsito.append("\n");
        }
        if (archive.getGruppi().size() > 0) {
            bfEsito.append("Tags (").append(archive.getGruppi().size()).append(")\n");
        }
        for (i2 = 0; i2 < archive.getGruppi().size(); ++i2) {
            try {
                ArchiveEsitoImportDetail archiveGruppo = (ArchiveEsitoImportDetail)archive.getGruppi().get(i2);
                String nomeGruppo = ((ArchiveGruppo)archiveGruppo.getArchiveObject()).getIdGruppo().getNome();
                bfEsito.append("\t- [").append(nomeGruppo).append("] ");
                this.serializeStato(archiveGruppo, bfEsito, importOperation);
            }
            catch (Throwable e) {
                bfEsito.append("\t- [").append(i2 + 1).append("] " + labelNonErrore + ": ").append(e.getMessage());
            }
            bfEsito.append("\n");
        }
        if (archive.getGruppi().size() > 0) {
            bfEsito.append("\n");
        }
        if (archive.getRuoli().size() > 0) {
            bfEsito.append("Ruoli (").append(archive.getRuoli().size()).append(")\n");
        }
        for (i2 = 0; i2 < archive.getRuoli().size(); ++i2) {
            try {
                ArchiveEsitoImportDetail archiveRuolo = (ArchiveEsitoImportDetail)archive.getRuoli().get(i2);
                String nomeRuolo = ((ArchiveRuolo)archiveRuolo.getArchiveObject()).getIdRuolo().getNome();
                bfEsito.append("\t- [").append(nomeRuolo).append("] ");
                this.serializeStato(archiveRuolo, bfEsito, importOperation);
            }
            catch (Throwable e) {
                bfEsito.append("\t- [").append(i2 + 1).append("] " + labelNonErrore + ": ").append(e.getMessage());
            }
            bfEsito.append("\n");
        }
        if (archive.getRuoli().size() > 0) {
            bfEsito.append("\n");
        }
        if (archive.getScope().size() > 0) {
            bfEsito.append("Scope (").append(archive.getScope().size()).append(")\n");
        }
        for (i2 = 0; i2 < archive.getScope().size(); ++i2) {
            try {
                ArchiveEsitoImportDetail archiveScope = (ArchiveEsitoImportDetail)archive.getScope().get(i2);
                String nomeScope = ((ArchiveScope)archiveScope.getArchiveObject()).getIdScope().getNome();
                bfEsito.append("\t- [").append(nomeScope).append("] ");
                this.serializeStato(archiveScope, bfEsito, importOperation);
            }
            catch (Throwable e) {
                bfEsito.append("\t- [").append(i2 + 1).append("] " + labelNonErrore + ": ").append(e.getMessage());
            }
            bfEsito.append("\n");
        }
        if (archive.getScope().size() > 0) {
            bfEsito.append("\n");
        }
        if (archive.getSoggetti().size() > 0) {
            bfEsito.append("Soggetti (").append(archive.getSoggetti().size()).append(")\n");
        }
        for (i2 = 0; i2 < archive.getSoggetti().size(); ++i2) {
            try {
                ArchiveEsitoImportDetail archiveSoggetto = (ArchiveEsitoImportDetail)archive.getSoggetti().get(i2);
                IDSoggetto idSoggetto = ((ArchiveSoggetto)archiveSoggetto.getArchiveObject()).getIdSoggetto();
                bfEsito.append("\t- [").append(idSoggetto.toString()).append("] ");
                this.serializeStato(archiveSoggetto, bfEsito, importOperation);
            }
            catch (Exception e) {
                bfEsito.append("\t- [").append(i2 + 1).append("] " + labelNonErrore + ": ").append(e.getMessage());
            }
            bfEsito.append("\n");
        }
        if (archive.getSoggetti().size() > 0) {
            bfEsito.append("\n");
        }
        if (archive.getServiziApplicativi().size() > 0) {
            bfEsito.append("Applicativi Fruitori/Erogatori (").append(archive.getServiziApplicativi().size()).append(")\n");
        }
        for (i2 = 0; i2 < archive.getServiziApplicativi().size(); ++i2) {
            try {
                ArchiveEsitoImportDetail archiveServizioApplicativo = (ArchiveEsitoImportDetail)archive.getServiziApplicativi().get(i2);
                IDServizioApplicativo idServizioApplicativo = ((ArchiveServizioApplicativo)archiveServizioApplicativo.getArchiveObject()).getIdServizioApplicativo();
                bfEsito.append("\t- [").append(idServizioApplicativo.getIdSoggettoProprietario().toString()).append("_").append(idServizioApplicativo.getNome()).append("] ");
                this.serializeStato(archiveServizioApplicativo, bfEsito, importOperation);
            }
            catch (Exception e) {
                bfEsito.append("\t- [").append(i2 + 1).append("] " + labelNonErrore + ": ").append(e.getMessage());
            }
            bfEsito.append("\n");
        }
        if (archive.getServiziApplicativi().size() > 0) {
            bfEsito.append("\n");
        }
        if (archive.getAccordiCooperazione().size() > 0) {
            bfEsito.append("Accordi di Cooperazione (").append(archive.getAccordiCooperazione().size()).append(")\n");
        }
        for (i2 = 0; i2 < archive.getAccordiCooperazione().size(); ++i2) {
            try {
                ArchiveEsitoImportDetail archiveAccordoCooperazione = (ArchiveEsitoImportDetail)archive.getAccordiCooperazione().get(i2);
                IDAccordoCooperazione idAccordoCooperazione = ((ArchiveAccordoCooperazione)archiveAccordoCooperazione.getArchiveObject()).getIdAccordoCooperazione();
                uriAccordo = this.idAccordoCooperazioneFactory.getUriFromIDAccordo(idAccordoCooperazione);
                bfEsito.append("\t- [").append(uriAccordo).append("] ");
                this.serializeStato(archiveAccordoCooperazione, bfEsito, importOperation);
            }
            catch (Exception e) {
                bfEsito.append("\t- [").append(i2 + 1).append("] " + labelNonErrore + ": ").append(e.getMessage());
            }
            bfEsito.append("\n");
        }
        if (archive.getAccordiCooperazione().size() > 0) {
            bfEsito.append("\n");
        }
        if (archive.getAccordiServizioParteComune().size() > 0) {
            bfEsito.append("API (").append(archive.getAccordiServizioParteComune().size()).append(")\n");
        }
        for (i2 = 0; i2 < archive.getAccordiServizioParteComune().size(); ++i2) {
            try {
                ArchiveEsitoImportDetail archiveAccordoServizioParteComune = (ArchiveEsitoImportDetail)archive.getAccordiServizioParteComune().get(i2);
                idAccordo = ((ArchiveAccordoServizioParteComune)archiveAccordoServizioParteComune.getArchiveObject()).getIdAccordoServizioParteComune();
                uriAccordo = this.idAccordoFactory.getUriFromIDAccordo(idAccordo);
                bfEsito.append("\t- [").append(uriAccordo).append("] ");
                this.serializeStato(archiveAccordoServizioParteComune, bfEsito, importOperation);
            }
            catch (Exception e) {
                bfEsito.append("\t- [").append(i2 + 1).append("] " + labelNonErrore + ": ").append(e.getMessage());
            }
            bfEsito.append("\n");
        }
        if (archive.getAccordiServizioParteComune().size() > 0) {
            bfEsito.append("\n");
        }
        if (archive.getAccordiServizioParteSpecifica().size() > 0) {
            bfEsito.append("Servizi (").append(archive.getAccordiServizioParteSpecifica().size()).append(")\n");
        }
        for (i2 = 0; i2 < archive.getAccordiServizioParteSpecifica().size(); ++i2) {
            try {
                archiveAccordoServizioParteSpecifica = (ArchiveEsitoImportDetail)archive.getAccordiServizioParteSpecifica().get(i2);
                idServizio2 = ((ArchiveAccordoServizioParteSpecifica)archiveAccordoServizioParteSpecifica.getArchiveObject()).getIdAccordoServizioParteSpecifica();
                uriAccordo = this.idServizioFactory.getUriFromIDServizio(idServizio2);
                bfEsito.append("\t- [").append(uriAccordo).append("] ");
                this.serializeStato(archiveAccordoServizioParteSpecifica, bfEsito, importOperation);
            }
            catch (Exception e) {
                bfEsito.append("\t- [").append(i2 + 1).append("] " + labelNonErrore + ": ").append(e.getMessage());
            }
            bfEsito.append("\n");
        }
        if (archive.getAccordiServizioParteSpecifica().size() > 0) {
            bfEsito.append("\n");
        }
        if (archive.getAccordiServizioComposto().size() > 0) {
            bfEsito.append("Accordi di Servizio Composto (").append(archive.getAccordiServizioComposto().size()).append(")\n");
        }
        for (i2 = 0; i2 < archive.getAccordiServizioComposto().size(); ++i2) {
            try {
                ArchiveEsitoImportDetail archiveAccordoServizioComposto = (ArchiveEsitoImportDetail)archive.getAccordiServizioComposto().get(i2);
                idAccordo = ((ArchiveAccordoServizioComposto)archiveAccordoServizioComposto.getArchiveObject()).getIdAccordoServizioParteComune();
                uriAccordo = this.idAccordoFactory.getUriFromIDAccordo(idAccordo);
                bfEsito.append("\t- [").append(uriAccordo).append("] ");
                this.serializeStato(archiveAccordoServizioComposto, bfEsito, importOperation);
            }
            catch (Exception e) {
                bfEsito.append("\t- [").append(i2 + 1).append("] " + labelNonErrore + ": ").append(e.getMessage());
            }
            bfEsito.append("\n");
        }
        if (archive.getAccordiServizioComposto().size() > 0) {
            bfEsito.append("\n");
        }
        if (archive.getAccordiServizioParteSpecificaServiziComposti().size() > 0) {
            bfEsito.append("Servizi (").append(archive.getAccordiServizioParteSpecificaServiziComposti().size()).append(") [accordi di servizio composto]\n");
        }
        for (i2 = 0; i2 < archive.getAccordiServizioParteSpecificaServiziComposti().size(); ++i2) {
            try {
                archiveAccordoServizioParteSpecifica = (ArchiveEsitoImportDetail)archive.getAccordiServizioParteSpecificaServiziComposti().get(i2);
                idServizio2 = ((ArchiveAccordoServizioParteSpecifica)archiveAccordoServizioParteSpecifica.getArchiveObject()).getIdAccordoServizioParteSpecifica();
                uriAccordo = this.idServizioFactory.getUriFromIDServizio(idServizio2);
                bfEsito.append("\t- [").append(uriAccordo).append("] ");
                this.serializeStato(archiveAccordoServizioParteSpecifica, bfEsito, importOperation);
            }
            catch (Exception e) {
                bfEsito.append("\t- [").append(i2 + 1).append("] " + labelNonErrore + ": ").append(e.getMessage());
            }
            bfEsito.append("\n");
        }
        if (archive.getAccordiServizioParteSpecificaServiziComposti().size() > 0) {
            bfEsito.append("\n");
        }
        if (archive.getAccordiFruitori().size() > 0) {
            bfEsito.append("Fruitori (").append(archive.getAccordiFruitori().size()).append(")\n");
        }
        for (i2 = 0; i2 < archive.getAccordiFruitori().size(); ++i2) {
            try {
                ArchiveEsitoImportDetail archiveFruitore = (ArchiveEsitoImportDetail)archive.getAccordiFruitori().get(i2);
                idServizio2 = ((ArchiveFruitore)archiveFruitore.getArchiveObject()).getIdAccordoServizioParteSpecifica();
                uriAccordo = this.idServizioFactory.getUriFromIDServizio(idServizio2);
                IDSoggetto idFruitore = ((ArchiveFruitore)archiveFruitore.getArchiveObject()).getIdSoggettoFruitore();
                bfEsito.append("\t- [" + String.valueOf(idFruitore) + "] -> [").append(uriAccordo).append("] ");
                this.serializeStato(archiveFruitore, bfEsito, importOperation);
            }
            catch (Exception e) {
                bfEsito.append("\t- [").append(i2 + 1).append("] " + labelNonErrore + ": ").append(e.getMessage());
            }
            bfEsito.append("\n");
        }
        if (archive.getAccordiFruitori().size() > 0) {
            bfEsito.append("\n");
        }
        if (archive.getPorteDelegate().size() > 0) {
            bfEsito.append("Porte Outbound (").append(archive.getPorteDelegate().size()).append(")\n");
        }
        for (i2 = 0; i2 < archive.getPorteDelegate().size(); ++i2) {
            IDPortaDelegata idPortaDelegata;
            ArchiveEsitoImportDetail archivePortaDelegata;
            try {
                archivePortaDelegata = (ArchiveEsitoImportDetail)archive.getPorteDelegate().get(i2);
                idPortaDelegata = ((ArchivePortaDelegata)archivePortaDelegata.getArchiveObject()).getIdPortaDelegata();
                idProprietario = ((ArchivePortaDelegata)archivePortaDelegata.getArchiveObject()).getIdSoggettoProprietario();
                bfEsito.append("\t- [" + String.valueOf(idProprietario) + "][" + idPortaDelegata.getNome() + "] ");
                this.serializeStato(archivePortaDelegata, bfEsito, importOperation);
            }
            catch (Exception e) {
                bfEsito.append("\t- [").append(i2 + 1).append("] " + labelNonErrore + ": ").append(e.getMessage());
            }
            bfEsito.append("\n");
            if (!importOperation) continue;
            try {
                archivePortaDelegata = (ArchiveEsitoImportDetail)archive.getPorteDelegate_initMapping().get(i2);
                if (!ArchiveStatoImport.ERROR.equals((Object)archivePortaDelegata.getState())) continue;
                idPortaDelegata = ((ArchivePortaDelegata)archivePortaDelegata.getArchiveObject()).getIdPortaDelegata();
                idProprietario = ((ArchivePortaDelegata)archivePortaDelegata.getArchiveObject()).getIdSoggettoProprietario();
                bfEsito.append("\t- Fruizione [" + String.valueOf(idProprietario) + "][" + idPortaDelegata.getNome() + "] ");
                this.serializeStato(archivePortaDelegata, bfEsito, importOperation);
                bfEsito.append("\n");
                continue;
            }
            catch (Exception e) {
                bfEsito.append("\t- [").append(i2 + 1).append("] fruizione non creata: ").append(e.getMessage());
                bfEsito.append("\n");
            }
        }
        if (archive.getPorteDelegate().size() > 0) {
            bfEsito.append("\n");
        }
        if (archive.getPorteApplicative().size() > 0) {
            bfEsito.append("Porte Inbound (").append(archive.getPorteApplicative().size()).append(")\n");
        }
        for (i2 = 0; i2 < archive.getPorteApplicative().size(); ++i2) {
            IDPortaApplicativa idPortaApplicativa;
            ArchiveEsitoImportDetail archivePortaApplicativa;
            try {
                archivePortaApplicativa = (ArchiveEsitoImportDetail)archive.getPorteApplicative().get(i2);
                idPortaApplicativa = ((ArchivePortaApplicativa)archivePortaApplicativa.getArchiveObject()).getIdPortaApplicativa();
                idProprietario = ((ArchivePortaApplicativa)archivePortaApplicativa.getArchiveObject()).getIdSoggettoProprietario();
                bfEsito.append("\t- [" + String.valueOf(idProprietario) + "][" + idPortaApplicativa.getNome() + "] ");
                this.serializeStato(archivePortaApplicativa, bfEsito, importOperation);
            }
            catch (Exception e) {
                bfEsito.append("\t- [").append(i2 + 1).append("] " + labelNonErrore + ": ").append(e.getMessage());
            }
            bfEsito.append("\n");
            if (!importOperation) continue;
            try {
                archivePortaApplicativa = (ArchiveEsitoImportDetail)archive.getPorteApplicative_initMapping().get(i2);
                if (!ArchiveStatoImport.ERROR.equals((Object)archivePortaApplicativa.getState())) continue;
                idPortaApplicativa = ((ArchivePortaApplicativa)archivePortaApplicativa.getArchiveObject()).getIdPortaApplicativa();
                idProprietario = ((ArchivePortaApplicativa)archivePortaApplicativa.getArchiveObject()).getIdSoggettoProprietario();
                bfEsito.append("\t- Erogazione [" + String.valueOf(idProprietario) + "][" + idPortaApplicativa.getNome() + "] ");
                this.serializeStato(archivePortaApplicativa, bfEsito, importOperation);
                bfEsito.append("\n");
                continue;
            }
            catch (Exception e) {
                bfEsito.append("\t- [").append(i2 + 1).append("] erogazione non creata: ").append(e.getMessage());
                bfEsito.append("\n");
            }
        }
        if (archive.getPorteApplicative().size() > 0) {
            bfEsito.append("\n");
        }
        if (archive.getMappingFruizioni().size() > 0) {
            bfEsito.append("Fruizioni (").append(archive.getMappingFruizioni().size()).append(")\n");
        }
        for (i2 = 0; i2 < archive.getMappingFruizioni().size(); ++i2) {
            try {
                ArchiveEsitoImportDetail archiveFruizione = (ArchiveEsitoImportDetail)archive.getMappingFruizioni().get(i2);
                mapping = ((ArchiveMappingFruizione)archiveFruizione.getArchiveObject()).getMappingFruizionePortaDelegata();
                nome = mapping.getDescrizione() != null && !"".equals(mapping.getDescrizione()) ? mapping.getDescrizione() : mapping.getNome();
                idServizio = mapping.getIdServizio();
                IDSoggetto idFruitore = mapping.getIdFruitore();
                bfEsito.append("\t- (gruppo:" + nome + ") [" + String.valueOf(idFruitore) + "] -> [" + String.valueOf(idServizio) + "] ");
                this.serializeStato(archiveFruizione, bfEsito, importOperation);
            }
            catch (Exception e) {
                bfEsito.append("\t- [").append(i2 + 1).append("] " + labelNonErrore + ": ").append(e.getMessage());
            }
            bfEsito.append("\n");
        }
        if (archive.getMappingFruizioni().size() > 0) {
            bfEsito.append("\n");
        }
        if (archive.getMappingErogazioni().size() > 0) {
            bfEsito.append("Erogazioni (").append(archive.getMappingErogazioni().size()).append(")\n");
        }
        for (i2 = 0; i2 < archive.getMappingErogazioni().size(); ++i2) {
            try {
                ArchiveEsitoImportDetail archiveErogazione = (ArchiveEsitoImportDetail)archive.getMappingErogazioni().get(i2);
                mapping = ((ArchiveMappingErogazione)archiveErogazione.getArchiveObject()).getMappingErogazionePortaApplicativa();
                nome = mapping.getDescrizione() != null && !"".equals(mapping.getDescrizione()) ? mapping.getDescrizione() : mapping.getNome();
                idServizio = mapping.getIdServizio();
                bfEsito.append("\t- (gruppo:" + nome + ") [" + String.valueOf(idServizio) + "] ");
                this.serializeStato(archiveErogazione, bfEsito, importOperation);
            }
            catch (Exception e) {
                bfEsito.append("\t- [").append(i2 + 1).append("] " + labelNonErrore + ": ").append(e.getMessage());
            }
            bfEsito.append("\n");
        }
        if (archive.getMappingErogazioni().size() > 0) {
            bfEsito.append("\n");
        }
        if (archive.getControlloTraffico_configurazione() != null) {
            bfEsito.append("Controllo del Traffico - Configurazione\n");
            try {
                ArchiveEsitoImportDetailConfigurazione<ConfigurazioneGenerale> configurazione = archive.getControlloTraffico_configurazione();
                bfEsito.append("\t- ");
                this.serializeStato(configurazione, bfEsito);
            }
            catch (Exception e) {
                bfEsito.append("\t- non importata: ").append(e.getMessage());
            }
            bfEsito.append("\n");
            bfEsito.append("\n");
        }
        if (archive.getControlloTraffico_configurationPolicies().size() > 0) {
            bfEsito.append("Controllo del Traffico - Registro Policy (").append(archive.getControlloTraffico_configurationPolicies().size()).append(")\n");
        }
        for (i = 0; i < archive.getControlloTraffico_configurationPolicies().size(); ++i) {
            try {
                archiveCCPolicy = (ArchiveEsitoImportDetail)archive.getControlloTraffico_configurationPolicies().get(i);
                nomePolicy = ((ArchiveConfigurationPolicy)archiveCCPolicy.getArchiveObject()).getNomePolicy();
                bfEsito.append("\t- [").append(nomePolicy).append("] ");
                this.serializeStato(archiveCCPolicy, bfEsito, importOperation);
            }
            catch (Throwable e) {
                bfEsito.append("\t- [").append(i + 1).append("] " + labelNonErrore + ": ").append(e.getMessage());
            }
            bfEsito.append("\n");
        }
        if (archive.getControlloTraffico_configurationPolicies().size() > 0) {
            bfEsito.append("\n");
        }
        if (archive.getControlloTraffico_activePolicies().size() > 0) {
            bfEsito.append("Controllo del Traffico - Policy (").append(archive.getControlloTraffico_activePolicies().size()).append(")\n");
        }
        for (i = 0; i < archive.getControlloTraffico_activePolicies().size(); ++i) {
            try {
                archiveCCPolicy = (ArchiveEsitoImportDetail)archive.getControlloTraffico_activePolicies().get(i);
                ArchiveActivePolicy activePolicy = (ArchiveActivePolicy)archiveCCPolicy.getArchiveObject();
                Object nomePolicy2 = activePolicy.getAliasPolicy();
                if (activePolicy.getRuoloPorta() != null && activePolicy.getNomePorta() != null) {
                    nomePolicy2 = RuoloPolicy.APPLICATIVA.equals((Object)activePolicy.getRuoloPorta()) ? (String)nomePolicy2 + " (inbound:" + activePolicy.getNomePorta() + ")" : (String)nomePolicy2 + " (outbound:" + activePolicy.getNomePorta() + ")";
                }
                bfEsito.append("\t- [").append((String)nomePolicy2).append("] ");
                this.serializeStato(archiveCCPolicy, bfEsito, importOperation);
            }
            catch (Throwable e) {
                bfEsito.append("\t- [").append(i + 1).append("] " + labelNonErrore + ": ").append(e.getMessage());
            }
            bfEsito.append("\n");
        }
        if (archive.getControlloTraffico_activePolicies().size() > 0) {
            bfEsito.append("\n");
        }
        if (archive.getAllarmi().size() > 0) {
            bfEsito.append("Allarmi (").append(archive.getAllarmi().size()).append(")\n");
        }
        for (i = 0; i < archive.getAllarmi().size(); ++i) {
            try {
                ArchiveEsitoImportDetail archiveAllarme = (ArchiveEsitoImportDetail)archive.getAllarmi().get(i);
                ArchiveAllarme allarme = (ArchiveAllarme)archiveAllarme.getArchiveObject();
                Object aliasAllarme = allarme.getAlias();
                if (allarme.getRuoloPorta() != null && allarme.getNomePorta() != null) {
                    aliasAllarme = RuoloPorta.APPLICATIVA.equals((Object)allarme.getRuoloPorta()) ? (String)aliasAllarme + " (inbound:" + allarme.getNomePorta() + ")" : (String)aliasAllarme + " (outbound:" + allarme.getNomePorta() + ")";
                }
                bfEsito.append("\t- [").append((String)aliasAllarme).append("] ");
                this.serializeStato(archiveAllarme, bfEsito, importOperation);
            }
            catch (Throwable e) {
                bfEsito.append("\t- [").append(i + 1).append("] " + labelNonErrore + ": ").append(e.getMessage());
            }
            bfEsito.append("\n");
        }
        if (archive.getAllarmi().size() > 0) {
            bfEsito.append("\n");
        }
        if (archive.getToken_validation_policies().size() > 0) {
            bfEsito.append("Token Policy - Validation (").append(archive.getToken_validation_policies().size()).append(")\n");
        }
        for (i = 0; i < archive.getToken_validation_policies().size(); ++i) {
            try {
                archiveTokenPolicy = (ArchiveEsitoImportDetail)archive.getToken_validation_policies().get(i);
                nomePolicy = ((ArchiveTokenPolicy)archiveTokenPolicy.getArchiveObject()).getNomePolicy();
                bfEsito.append("\t- [").append(nomePolicy).append("] ");
                this.serializeStato(archiveTokenPolicy, bfEsito, importOperation);
            }
            catch (Throwable e) {
                bfEsito.append("\t- [").append(i + 1).append("] " + labelNonErrore + ": ").append(e.getMessage());
            }
            bfEsito.append("\n");
        }
        if (archive.getToken_validation_policies().size() > 0) {
            bfEsito.append("\n");
        }
        if (archive.getToken_retrieve_policies().size() > 0) {
            bfEsito.append("Token Policy - Retrieve (").append(archive.getToken_retrieve_policies().size()).append(")\n");
        }
        for (i = 0; i < archive.getToken_retrieve_policies().size(); ++i) {
            try {
                archiveTokenPolicy = (ArchiveEsitoImportDetail)archive.getToken_retrieve_policies().get(i);
                nomePolicy = ((ArchiveTokenPolicy)archiveTokenPolicy.getArchiveObject()).getNomePolicy();
                bfEsito.append("\t- [").append(nomePolicy).append("] ");
                this.serializeStato(archiveTokenPolicy, bfEsito, importOperation);
            }
            catch (Throwable e) {
                bfEsito.append("\t- [").append(i + 1).append("] " + labelNonErrore + ": ").append(e.getMessage());
            }
            bfEsito.append("\n");
        }
        if (archive.getToken_retrieve_policies().size() > 0) {
            bfEsito.append("\n");
        }
        if (archive.getAttributeAuthorities().size() > 0) {
            bfEsito.append("Attribute Authority (").append(archive.getAttributeAuthorities().size()).append(")\n");
        }
        for (i = 0; i < archive.getAttributeAuthorities().size(); ++i) {
            try {
                ArchiveEsitoImportDetail archiveAttributeAuthority = (ArchiveEsitoImportDetail)archive.getAttributeAuthorities().get(i);
                String nomeAA = ((ArchiveAttributeAuthority)archiveAttributeAuthority.getArchiveObject()).getNomePolicy();
                bfEsito.append("\t- [").append(nomeAA).append("] ");
                this.serializeStato(archiveAttributeAuthority, bfEsito, importOperation);
            }
            catch (Throwable e) {
                bfEsito.append("\t- [").append(i + 1).append("] " + labelNonErrore + ": ").append(e.getMessage());
            }
            bfEsito.append("\n");
        }
        if (archive.getAttributeAuthorities().size() > 0) {
            bfEsito.append("\n");
        }
        if (archive.getPlugin_classi().size() > 0) {
            bfEsito.append("Plugin - Classi (").append(archive.getPlugin_classi().size()).append(")\n");
        }
        for (i = 0; i < archive.getPlugin_classi().size(); ++i) {
            try {
                ArchiveEsitoImportDetail archivePluginClasse = (ArchiveEsitoImportDetail)archive.getPlugin_classi().get(i);
                String tipoPlugin = ((ArchivePluginClasse)archivePluginClasse.getArchiveObject()).getTipoPlugin();
                String tipo = ((ArchivePluginClasse)archivePluginClasse.getArchiveObject()).getTipo();
                bfEsito.append("\t- [").append(tipoPlugin).append(" " + tipo + "] ");
                this.serializeStato(archivePluginClasse, bfEsito, importOperation);
            }
            catch (Throwable e) {
                bfEsito.append("\t- [").append(i + 1).append("] " + labelNonErrore + ": ").append(e.getMessage());
            }
            bfEsito.append("\n");
        }
        if (archive.getPlugin_classi().size() > 0) {
            bfEsito.append("\n");
        }
        if (archive.getPlugin_archivi().size() > 0) {
            bfEsito.append("Plugin - Archivi (").append(archive.getPlugin_archivi().size()).append(")\n");
        }
        for (i = 0; i < archive.getPlugin_archivi().size(); ++i) {
            try {
                ArchiveEsitoImportDetail archivePluginArchivio = (ArchiveEsitoImportDetail)archive.getPlugin_archivi().get(i);
                String nomeArchivio = ((ArchivePluginArchivio)archivePluginArchivio.getArchiveObject()).getNome();
                bfEsito.append("\t- [").append(nomeArchivio).append("] ");
                this.serializeStato(archivePluginArchivio, bfEsito, importOperation);
            }
            catch (Throwable e) {
                bfEsito.append("\t- [").append(i + 1).append("] " + labelNonErrore + ": ").append(e.getMessage());
            }
            bfEsito.append("\n");
        }
        if (archive.getPlugin_archivi().size() > 0) {
            bfEsito.append("\n");
        }
        if (archive.getConfigurazionePdD_urlInvocazione_regole().size() > 0) {
            bfEsito.append("Configurazione - Regole ProxyPass (").append(archive.getConfigurazionePdD_urlInvocazione_regole().size()).append(")\n");
        }
        for (i = 0; i < archive.getConfigurazionePdD_urlInvocazione_regole().size(); ++i) {
            try {
                ArchiveEsitoImportDetail archiveRegola = (ArchiveEsitoImportDetail)archive.getConfigurazionePdD_urlInvocazione_regole().get(i);
                String nomeRegola = ((ArchiveUrlInvocazioneRegola)archiveRegola.getArchiveObject()).getNome();
                bfEsito.append("\t- [").append(nomeRegola).append("] ");
                this.serializeStato(archiveRegola, bfEsito, importOperation);
            }
            catch (Throwable e) {
                bfEsito.append("\t- [").append(i + 1).append("] " + labelNonErrore + ": ").append(e.getMessage());
            }
            bfEsito.append("\n");
        }
        if (archive.getConfigurazionePdD_urlInvocazione_regole().size() > 0) {
            bfEsito.append("\n");
        }
        if (archive.getConfigurazionePdD_urlInvocazione() != null) {
            bfEsito.append("Configurazione - UrlInvocazione\n");
            try {
                ArchiveEsitoImportDetailConfigurazione<ConfigurazioneUrlInvocazione> configurazione = archive.getConfigurazionePdD_urlInvocazione();
                bfEsito.append("\t- ");
                this.serializeStato(configurazione, bfEsito);
            }
            catch (Exception e) {
                bfEsito.append("\t- non importata: ").append(e.getMessage());
            }
            bfEsito.append("\n");
            bfEsito.append("\n");
        }
        if (archive.getConfigurazionePdD() != null) {
            bfEsito.append("Configurazione\n");
            try {
                ArchiveEsitoImportDetailConfigurazione<Configurazione> configurazione = archive.getConfigurazionePdD();
                bfEsito.append("\t- ");
                this.serializeStato(configurazione, bfEsito);
            }
            catch (Exception e) {
                bfEsito.append("\t- non importata: ").append(e.getMessage());
            }
            bfEsito.append("\n");
            bfEsito.append("\n");
        }
        return bfEsito.toString();
    }

    public void serializeStato(ArchiveEsitoImportDetail detail, StringBuilder bfEsito, boolean importOperation) {
        Object stateDetail = "";
        if (detail.getStateDetail() != null) {
            stateDetail = detail.getStateDetail();
        }
        switch (detail.getState()) {
            case UPDATE_NOT_ENABLED: {
                bfEsito.append("non importato: gi\u00e0 presente (aggiornamento non abilitato)").append((String)stateDetail);
                break;
            }
            case NOT_UPDATABLE: {
                bfEsito.append("gi\u00e0 presente (aggiornamento non necessario)").append((String)stateDetail);
                break;
            }
            case IMPORT_POLICY_CONFIG_NOT_ENABLED: {
                bfEsito.append("non importato: opzione 'Policy di Configurazione' non abilitata").append((String)stateDetail);
                break;
            }
            case IMPORT_PLUGIN_CONFIG_NOT_ENABLED: {
                bfEsito.append("non importato: opzione 'Plugins' non abilitata").append((String)stateDetail);
                break;
            }
            case IMPORT_CONFIG_NOT_ENABLED: {
                bfEsito.append("non importato: opzione 'Configurazione di GovWay' non abilitata").append((String)stateDetail);
                break;
            }
            case ERROR: {
                if (detail.getStateDetail() != null) {
                    stateDetail = " [" + detail.getStateDetail() + "]";
                }
                if (importOperation) {
                    bfEsito.append("non importato" + (String)stateDetail + ": ").append(detail.getException().getMessage());
                    break;
                }
                bfEsito.append("non eliminato" + (String)stateDetail + ": ").append(detail.getException().getMessage());
                break;
            }
            case CREATED: {
                bfEsito.append("importato correttamente").append((String)stateDetail);
                break;
            }
            case UPDATED: {
                bfEsito.append("gi\u00e0 presente, aggiornato correttamente").append((String)stateDetail);
                break;
            }
            case DELETED_POLICY_CONFIG_NOT_ENABLED: {
                bfEsito.append("non eliminato: opzione 'Policy di Configurazione' non abilitata").append((String)stateDetail);
                break;
            }
            case DELETED_PLUGIN_CONFIG_NOT_ENABLED: {
                bfEsito.append("non eliminato: opzione 'Plugins' non abilitata").append((String)stateDetail);
                break;
            }
            case DELETED_NOT_EXISTS: {
                bfEsito.append("non esistente").append((String)stateDetail);
                break;
            }
            case DELETED: {
                bfEsito.append("eliminato correttamente").append((String)stateDetail);
            }
        }
    }

    public void serializeStato(ArchiveEsitoImportDetailConfigurazione<?> detail, StringBuilder bfEsito) {
        Object stateDetail = "";
        if (detail.getStateDetail() != null) {
            stateDetail = detail.getStateDetail();
        }
        switch (detail.getState()) {
            case UPDATE_NOT_ENABLED: {
                break;
            }
            case NOT_UPDATABLE: {
                break;
            }
            case IMPORT_POLICY_CONFIG_NOT_ENABLED: {
                bfEsito.append("non importato: opzione 'Policy di Configurazione' non abilitata").append((String)stateDetail);
                break;
            }
            case IMPORT_PLUGIN_CONFIG_NOT_ENABLED: {
                bfEsito.append("non importato: opzione 'Plugins' non abilitata").append((String)stateDetail);
                break;
            }
            case IMPORT_CONFIG_NOT_ENABLED: {
                bfEsito.append("non importato: opzione 'Configurazione di GovWay' non abilitata").append((String)stateDetail);
                break;
            }
            case ERROR: {
                if (detail.getStateDetail() != null) {
                    stateDetail = " [" + detail.getStateDetail() + "]";
                }
                bfEsito.append("non importata" + (String)stateDetail + ": ").append(detail.getException().getMessage());
                break;
            }
            case CREATED: {
                break;
            }
            case UPDATED: {
                bfEsito.append("aggiornata correttamente").append((String)stateDetail);
                break;
            }
            case DELETED_POLICY_CONFIG_NOT_ENABLED: {
                bfEsito.append("non eliminato: opzione 'Policy di Configurazione' non abilitata").append((String)stateDetail);
                break;
            }
            case DELETED_PLUGIN_CONFIG_NOT_ENABLED: {
                bfEsito.append("non eliminato: opzione 'Plugins' non abilitata").append((String)stateDetail);
                break;
            }
            case DELETED_NOT_EXISTS: {
                break;
            }
            case DELETED: {
                bfEsito.append("eliminazione effettuata correttamente").append((String)stateDetail);
            }
        }
    }

    private ArchiveEsitoImport getArchiveEsitoImport(ArchiveIdCorrelazione idCorrelazioneParam, Map<String, ArchiveEsitoImport> map, Map<String, ArchiveIdCorrelazione> mapIdCorrelazione) {
        if (idCorrelazioneParam == null) {
            throw new RuntimeException("Param idCorrelazioneParam is null");
        }
        if (map == null) {
            throw new RuntimeException("Param map is null");
        }
        if (mapIdCorrelazione == null) {
            throw new RuntimeException("Param mapIdCorrelazione is null");
        }
        String idCorrelazione = idCorrelazioneParam.getId();
        if (idCorrelazione == null) {
            idCorrelazione = "@PackageOpenSPCoop@";
        }
        ArchiveEsitoImport tmp = null;
        if (map.containsKey(idCorrelazione)) {
            tmp = map.get(idCorrelazione);
        } else {
            tmp = new ArchiveEsitoImport();
            map.put(idCorrelazione, tmp);
            mapIdCorrelazione.put(idCorrelazione, idCorrelazioneParam);
        }
        return tmp;
    }

    public void readIdCorrelazione(Map<String, ArchiveEsitoImport> map, Map<String, ArchiveIdCorrelazione> mapIdCorrelazione, ArchiveEsitoImport archive) throws ProtocolException {
        ArchiveEsitoImportDetail archiveTokenPolicy;
        ArchiveEsitoImportDetail archiveCCPolicy;
        int i;
        ArchiveIdCorrelazione idCorrelazione;
        ArchiveEsitoImportDetail archiveAccordoServizioParteSpecifica;
        ArchiveIdCorrelazione idCorrelazione2;
        int i2;
        for (i2 = 0; i2 < archive.getPdd().size(); ++i2) {
            ArchiveEsitoImportDetail archivePdd = (ArchiveEsitoImportDetail)archive.getPdd().get(i2);
            idCorrelazione2 = ((ArchivePdd)archivePdd.getArchiveObject()).getIdCorrelazione();
            this.getArchiveEsitoImport(idCorrelazione2, map, mapIdCorrelazione).getPdd().add(archivePdd);
        }
        for (i2 = 0; i2 < archive.getGruppi().size(); ++i2) {
            ArchiveEsitoImportDetail archiveGruppo = (ArchiveEsitoImportDetail)archive.getGruppi().get(i2);
            idCorrelazione2 = ((ArchiveGruppo)archiveGruppo.getArchiveObject()).getIdCorrelazione();
            this.getArchiveEsitoImport(idCorrelazione2, map, mapIdCorrelazione).getGruppi().add(archiveGruppo);
        }
        for (i2 = 0; i2 < archive.getRuoli().size(); ++i2) {
            ArchiveEsitoImportDetail archiveRuolo = (ArchiveEsitoImportDetail)archive.getRuoli().get(i2);
            idCorrelazione2 = ((ArchiveRuolo)archiveRuolo.getArchiveObject()).getIdCorrelazione();
            this.getArchiveEsitoImport(idCorrelazione2, map, mapIdCorrelazione).getRuoli().add(archiveRuolo);
        }
        for (i2 = 0; i2 < archive.getScope().size(); ++i2) {
            ArchiveEsitoImportDetail archiveScope = (ArchiveEsitoImportDetail)archive.getScope().get(i2);
            idCorrelazione2 = ((ArchiveScope)archiveScope.getArchiveObject()).getIdCorrelazione();
            this.getArchiveEsitoImport(idCorrelazione2, map, mapIdCorrelazione).getScope().add(archiveScope);
        }
        for (i2 = 0; i2 < archive.getSoggetti().size(); ++i2) {
            ArchiveEsitoImportDetail archiveSoggetto = (ArchiveEsitoImportDetail)archive.getSoggetti().get(i2);
            idCorrelazione2 = ((ArchiveSoggetto)archiveSoggetto.getArchiveObject()).getIdCorrelazione();
            this.getArchiveEsitoImport(idCorrelazione2, map, mapIdCorrelazione).getSoggetti().add(archiveSoggetto);
        }
        for (i2 = 0; i2 < archive.getServiziApplicativi().size(); ++i2) {
            ArchiveEsitoImportDetail archiveServizioApplicativo = (ArchiveEsitoImportDetail)archive.getServiziApplicativi().get(i2);
            idCorrelazione2 = ((ArchiveServizioApplicativo)archiveServizioApplicativo.getArchiveObject()).getIdCorrelazione();
            this.getArchiveEsitoImport(idCorrelazione2, map, mapIdCorrelazione).getServiziApplicativi().add(archiveServizioApplicativo);
        }
        for (i2 = 0; i2 < archive.getAccordiCooperazione().size(); ++i2) {
            ArchiveEsitoImportDetail archiveAccordoCooperazione = (ArchiveEsitoImportDetail)archive.getAccordiCooperazione().get(i2);
            idCorrelazione2 = ((ArchiveAccordoCooperazione)archiveAccordoCooperazione.getArchiveObject()).getIdCorrelazione();
            this.getArchiveEsitoImport(idCorrelazione2, map, mapIdCorrelazione).getAccordiCooperazione().add(archiveAccordoCooperazione);
        }
        for (i2 = 0; i2 < archive.getAccordiServizioParteComune().size(); ++i2) {
            ArchiveEsitoImportDetail archiveAccordoServizioParteComune = (ArchiveEsitoImportDetail)archive.getAccordiServizioParteComune().get(i2);
            idCorrelazione2 = ((ArchiveAccordoServizioParteComune)archiveAccordoServizioParteComune.getArchiveObject()).getIdCorrelazione();
            this.getArchiveEsitoImport(idCorrelazione2, map, mapIdCorrelazione).getAccordiServizioParteComune().add(archiveAccordoServizioParteComune);
        }
        for (i2 = 0; i2 < archive.getAccordiServizioParteSpecifica().size(); ++i2) {
            archiveAccordoServizioParteSpecifica = (ArchiveEsitoImportDetail)archive.getAccordiServizioParteSpecifica().get(i2);
            idCorrelazione2 = ((ArchiveAccordoServizioParteSpecifica)archiveAccordoServizioParteSpecifica.getArchiveObject()).getIdCorrelazione();
            this.getArchiveEsitoImport(idCorrelazione2, map, mapIdCorrelazione).getAccordiServizioParteSpecifica().add(archiveAccordoServizioParteSpecifica);
        }
        for (i2 = 0; i2 < archive.getAccordiServizioComposto().size(); ++i2) {
            ArchiveEsitoImportDetail archiveAccordoServizioComposto = (ArchiveEsitoImportDetail)archive.getAccordiServizioComposto().get(i2);
            idCorrelazione2 = ((ArchiveAccordoServizioComposto)archiveAccordoServizioComposto.getArchiveObject()).getIdCorrelazione();
            this.getArchiveEsitoImport(idCorrelazione2, map, mapIdCorrelazione).getAccordiServizioComposto().add(archiveAccordoServizioComposto);
        }
        for (i2 = 0; i2 < archive.getAccordiServizioParteSpecificaServiziComposti().size(); ++i2) {
            archiveAccordoServizioParteSpecifica = (ArchiveEsitoImportDetail)archive.getAccordiServizioParteSpecificaServiziComposti().get(i2);
            idCorrelazione2 = ((ArchiveAccordoServizioParteSpecifica)archiveAccordoServizioParteSpecifica.getArchiveObject()).getIdCorrelazione();
            this.getArchiveEsitoImport(idCorrelazione2, map, mapIdCorrelazione).getAccordiServizioParteSpecificaServiziComposti().add(archiveAccordoServizioParteSpecifica);
        }
        for (i2 = 0; i2 < archive.getAccordiFruitori().size(); ++i2) {
            ArchiveEsitoImportDetail archiveFruitore = (ArchiveEsitoImportDetail)archive.getAccordiFruitori().get(i2);
            idCorrelazione2 = ((ArchiveFruitore)archiveFruitore.getArchiveObject()).getIdCorrelazione();
            this.getArchiveEsitoImport(idCorrelazione2, map, mapIdCorrelazione).getAccordiFruitori().add(archiveFruitore);
        }
        for (i2 = 0; i2 < archive.getPorteDelegate().size(); ++i2) {
            ArchiveEsitoImportDetail archivePortaDelegata = (ArchiveEsitoImportDetail)archive.getPorteDelegate().get(i2);
            idCorrelazione2 = ((ArchivePortaDelegata)archivePortaDelegata.getArchiveObject()).getIdCorrelazione();
            this.getArchiveEsitoImport(idCorrelazione2, map, mapIdCorrelazione).getPorteDelegate().add(archivePortaDelegata);
        }
        for (i2 = 0; i2 < archive.getPorteApplicative().size(); ++i2) {
            ArchiveEsitoImportDetail archivePortaApplicativa = (ArchiveEsitoImportDetail)archive.getPorteApplicative().get(i2);
            idCorrelazione2 = ((ArchivePortaApplicativa)archivePortaApplicativa.getArchiveObject()).getIdCorrelazione();
            this.getArchiveEsitoImport(idCorrelazione2, map, mapIdCorrelazione).getPorteApplicative().add(archivePortaApplicativa);
        }
        if (archive.getControlloTraffico_configurazione() != null) {
            ArchiveEsitoImportDetailConfigurazione<ConfigurazioneGenerale> configurazione = archive.getControlloTraffico_configurazione();
            if (mapIdCorrelazione.size() > 1) {
                throw new ProtocolException("Configurazione permessa solo con una unica correlazione tra oggetti");
            }
            idCorrelazione = null;
            if (mapIdCorrelazione.size() == 1) {
                idCorrelazione = mapIdCorrelazione.values().iterator().next();
            } else if (mapIdCorrelazione.size() == 0) {
                idCorrelazione = new ArchiveIdCorrelazione("@PackageOpenSPCoop@");
            }
            this.getArchiveEsitoImport(idCorrelazione, map, mapIdCorrelazione).setControlloTraffico_configurazione(configurazione);
        }
        for (i = 0; i < archive.getControlloTraffico_configurationPolicies().size(); ++i) {
            archiveCCPolicy = (ArchiveEsitoImportDetail)archive.getControlloTraffico_configurationPolicies().get(i);
            idCorrelazione2 = ((ArchiveConfigurationPolicy)archiveCCPolicy.getArchiveObject()).getIdCorrelazione();
            this.getArchiveEsitoImport(idCorrelazione2, map, mapIdCorrelazione).getControlloTraffico_configurationPolicies().add(archiveCCPolicy);
        }
        for (i = 0; i < archive.getControlloTraffico_activePolicies().size(); ++i) {
            archiveCCPolicy = (ArchiveEsitoImportDetail)archive.getControlloTraffico_activePolicies().get(i);
            idCorrelazione2 = ((ArchiveActivePolicy)archiveCCPolicy.getArchiveObject()).getIdCorrelazione();
            this.getArchiveEsitoImport(idCorrelazione2, map, mapIdCorrelazione).getControlloTraffico_activePolicies().add(archiveCCPolicy);
        }
        for (i = 0; i < archive.getAllarmi().size(); ++i) {
            ArchiveEsitoImportDetail archiveAllarme = (ArchiveEsitoImportDetail)archive.getAllarmi().get(i);
            idCorrelazione2 = ((ArchiveAllarme)archiveAllarme.getArchiveObject()).getIdCorrelazione();
            this.getArchiveEsitoImport(idCorrelazione2, map, mapIdCorrelazione).getAllarmi().add(archiveAllarme);
        }
        for (i = 0; i < archive.getToken_validation_policies().size(); ++i) {
            archiveTokenPolicy = (ArchiveEsitoImportDetail)archive.getToken_validation_policies().get(i);
            idCorrelazione2 = ((ArchiveTokenPolicy)archiveTokenPolicy.getArchiveObject()).getIdCorrelazione();
            this.getArchiveEsitoImport(idCorrelazione2, map, mapIdCorrelazione).getToken_validation_policies().add(archiveTokenPolicy);
        }
        for (i = 0; i < archive.getToken_retrieve_policies().size(); ++i) {
            archiveTokenPolicy = (ArchiveEsitoImportDetail)archive.getToken_retrieve_policies().get(i);
            idCorrelazione2 = ((ArchiveTokenPolicy)archiveTokenPolicy.getArchiveObject()).getIdCorrelazione();
            this.getArchiveEsitoImport(idCorrelazione2, map, mapIdCorrelazione).getToken_retrieve_policies().add(archiveTokenPolicy);
        }
        for (i = 0; i < archive.getAttributeAuthorities().size(); ++i) {
            ArchiveEsitoImportDetail archiveAttributeAuthority = (ArchiveEsitoImportDetail)archive.getAttributeAuthorities().get(i);
            idCorrelazione2 = ((ArchiveAttributeAuthority)archiveAttributeAuthority.getArchiveObject()).getIdCorrelazione();
            this.getArchiveEsitoImport(idCorrelazione2, map, mapIdCorrelazione).getAttributeAuthorities().add(archiveAttributeAuthority);
        }
        for (i = 0; i < archive.getPlugin_classi().size(); ++i) {
            ArchiveEsitoImportDetail archivePluginClasse = (ArchiveEsitoImportDetail)archive.getPlugin_classi().get(i);
            idCorrelazione2 = ((ArchivePluginClasse)archivePluginClasse.getArchiveObject()).getIdCorrelazione();
            this.getArchiveEsitoImport(idCorrelazione2, map, mapIdCorrelazione).getPlugin_classi().add(archivePluginClasse);
        }
        for (i = 0; i < archive.getPlugin_archivi().size(); ++i) {
            ArchiveEsitoImportDetail archivePluginArchivio = (ArchiveEsitoImportDetail)archive.getPlugin_archivi().get(i);
            idCorrelazione2 = ((ArchivePluginArchivio)archivePluginArchivio.getArchiveObject()).getIdCorrelazione();
            this.getArchiveEsitoImport(idCorrelazione2, map, mapIdCorrelazione).getPlugin_archivi().add(archivePluginArchivio);
        }
        for (i = 0; i < archive.getConfigurazionePdD_urlInvocazione_regole().size(); ++i) {
            ArchiveEsitoImportDetail archiveRegola = (ArchiveEsitoImportDetail)archive.getConfigurazionePdD_urlInvocazione_regole().get(i);
            idCorrelazione2 = ((ArchiveUrlInvocazioneRegola)archiveRegola.getArchiveObject()).getIdCorrelazione();
            this.getArchiveEsitoImport(idCorrelazione2, map, mapIdCorrelazione).getConfigurazionePdD_urlInvocazione_regole().add(archiveRegola);
        }
        if (archive.getConfigurazionePdD_urlInvocazione() != null) {
            ArchiveEsitoImportDetailConfigurazione<ConfigurazioneUrlInvocazione> configurazione = archive.getConfigurazionePdD_urlInvocazione();
            if (mapIdCorrelazione.size() > 1) {
                throw new ProtocolException("Configurazione permessa solo con una unica correlazione tra oggetti");
            }
            idCorrelazione = null;
            if (mapIdCorrelazione.size() == 1) {
                idCorrelazione = mapIdCorrelazione.values().iterator().next();
            } else if (mapIdCorrelazione.size() == 0) {
                idCorrelazione = new ArchiveIdCorrelazione("@PackageOpenSPCoop@");
            }
            this.getArchiveEsitoImport(idCorrelazione, map, mapIdCorrelazione).setConfigurazionePdD_urlInvocazione(configurazione);
        }
        if (archive.getConfigurazionePdD() != null) {
            ArchiveEsitoImportDetailConfigurazione<Configurazione> configurazione = archive.getConfigurazionePdD();
            if (mapIdCorrelazione.size() > 1) {
                throw new ProtocolException("Configurazione permessa solo con una unica correlazione tra oggetti");
            }
            idCorrelazione = null;
            if (mapIdCorrelazione.size() == 1) {
                idCorrelazione = mapIdCorrelazione.values().iterator().next();
            } else if (mapIdCorrelazione.size() == 0) {
                idCorrelazione = new ArchiveIdCorrelazione("@PackageOpenSPCoop@");
            }
            this.getArchiveEsitoImport(idCorrelazione, map, mapIdCorrelazione).setConfigurazionePdD(configurazione);
        }
    }
}

