/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.basic.archive;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.openspcoop2.core.allarmi.Allarme;
import org.openspcoop2.core.config.Configurazione;
import org.openspcoop2.core.config.ConfigurazioneUrlInvocazione;
import org.openspcoop2.core.config.ConfigurazioneUrlInvocazioneRegola;
import org.openspcoop2.core.config.GenericProperties;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.RegistroPlugin;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.Soggetto;
import org.openspcoop2.core.config.driver.ExtendedInfoManager;
import org.openspcoop2.core.constants.ProprietariProtocolProperty;
import org.openspcoop2.core.controllo_traffico.AttivazionePolicy;
import org.openspcoop2.core.controllo_traffico.ConfigurazioneGenerale;
import org.openspcoop2.core.controllo_traffico.ConfigurazionePolicy;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDAccordoCooperazione;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.mapping.MappingErogazionePortaApplicativa;
import org.openspcoop2.core.mapping.MappingFruizionePortaDelegata;
import org.openspcoop2.core.plugins.Plugin;
import org.openspcoop2.core.plugins.utils.serializer.JaxbSerializer;
import org.openspcoop2.core.registry.AccordoCooperazione;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.Azione;
import org.openspcoop2.core.registry.Fruitore;
import org.openspcoop2.core.registry.Gruppo;
import org.openspcoop2.core.registry.Operation;
import org.openspcoop2.core.registry.PortType;
import org.openspcoop2.core.registry.PortaDominio;
import org.openspcoop2.core.registry.ProtocolProperty;
import org.openspcoop2.core.registry.Resource;
import org.openspcoop2.core.registry.Ruolo;
import org.openspcoop2.core.registry.Scope;
import org.openspcoop2.core.registry.utils.CleanerOpenSPCoop2Extensions;
import org.openspcoop2.generic_project.exception.SerializerException;
import org.openspcoop2.protocol.basic.archive.SerializationType;
import org.openspcoop2.protocol.basic.archive.ZIPUtils;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.archive.Archive;
import org.openspcoop2.protocol.sdk.archive.ArchiveAccordoCooperazione;
import org.openspcoop2.protocol.sdk.archive.ArchiveAccordoServizioComposto;
import org.openspcoop2.protocol.sdk.archive.ArchiveAccordoServizioParteComune;
import org.openspcoop2.protocol.sdk.archive.ArchiveAccordoServizioParteSpecifica;
import org.openspcoop2.protocol.sdk.archive.ArchiveActivePolicy;
import org.openspcoop2.protocol.sdk.archive.ArchiveAllarme;
import org.openspcoop2.protocol.sdk.archive.ArchiveAttributeAuthority;
import org.openspcoop2.protocol.sdk.archive.ArchiveConfigurationPolicy;
import org.openspcoop2.protocol.sdk.archive.ArchiveFruitore;
import org.openspcoop2.protocol.sdk.archive.ArchiveGruppo;
import org.openspcoop2.protocol.sdk.archive.ArchivePdd;
import org.openspcoop2.protocol.sdk.archive.ArchivePluginArchivio;
import org.openspcoop2.protocol.sdk.archive.ArchivePluginClasse;
import org.openspcoop2.protocol.sdk.archive.ArchivePortaApplicativa;
import org.openspcoop2.protocol.sdk.archive.ArchivePortaDelegata;
import org.openspcoop2.protocol.sdk.archive.ArchiveRuolo;
import org.openspcoop2.protocol.sdk.archive.ArchiveScope;
import org.openspcoop2.protocol.sdk.archive.ArchiveServizioApplicativo;
import org.openspcoop2.protocol.sdk.archive.ArchiveSoggetto;
import org.openspcoop2.protocol.sdk.archive.ArchiveTokenPolicy;
import org.openspcoop2.protocol.sdk.archive.ArchiveUrlInvocazioneRegola;
import org.openspcoop2.protocol.sdk.archive.IArchiveObject;
import org.openspcoop2.protocol.sdk.constants.ArchiveVersion;
import org.openspcoop2.protocol.sdk.registry.IConfigIntegrationReader;
import org.openspcoop2.protocol.sdk.registry.IRegistryReader;
import org.slf4j.Logger;

public class ZIPWriteUtils {
    protected Logger log = null;
    protected IRegistryReader registryReader;
    protected IConfigIntegrationReader configIntegrationReader;
    private org.openspcoop2.core.registry.utils.serializer.JaxbSerializer jaxbRegistrySerializer = null;
    private org.openspcoop2.core.config.utils.serializer.JaxbSerializer jaxbConfigSerializer = null;
    private JaxbSerializer jaxbPluginSerializer = null;
    private org.openspcoop2.core.controllo_traffico.utils.serializer.JaxbSerializer jaxbControlloTrafficoSerializer = null;
    private org.openspcoop2.core.allarmi.utils.serializer.JaxbSerializer jaxbAllarmeSerializer = null;
    private CleanerOpenSPCoop2Extensions cleanerOpenSPCoop2ExtensionsRegistry = null;
    private org.openspcoop2.core.config.utils.CleanerOpenSPCoop2Extensions cleanerOpenSPCoop2ExtensionsConfig = null;
    private org.openspcoop2.core.plugins.utils.CleanerOpenSPCoop2Extensions cleanerOpenSPCoop2ExtensionsPlugin = null;
    private org.openspcoop2.core.controllo_traffico.utils.CleanerOpenSPCoop2Extensions cleanerOpenSPCoop2ExtensionsControlloTraffico = null;
    private org.openspcoop2.core.allarmi.utils.CleanerOpenSPCoop2Extensions cleanerOpenSPCoop2ExtensionsAllarme = null;

    public ZIPWriteUtils(Logger log, IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader) throws ProtocolException {
        this.log = log;
        this.registryReader = registryReader;
        this.configIntegrationReader = configIntegrationReader;
        this.jaxbRegistrySerializer = new org.openspcoop2.core.registry.utils.serializer.JaxbSerializer();
        this.jaxbConfigSerializer = new org.openspcoop2.core.config.utils.serializer.JaxbSerializer();
        this.jaxbPluginSerializer = new JaxbSerializer();
        this.jaxbControlloTrafficoSerializer = new org.openspcoop2.core.controllo_traffico.utils.serializer.JaxbSerializer();
        this.jaxbAllarmeSerializer = new org.openspcoop2.core.allarmi.utils.serializer.JaxbSerializer();
        this.cleanerOpenSPCoop2ExtensionsRegistry = new CleanerOpenSPCoop2Extensions();
        this.cleanerOpenSPCoop2ExtensionsConfig = new org.openspcoop2.core.config.utils.CleanerOpenSPCoop2Extensions();
        this.cleanerOpenSPCoop2ExtensionsPlugin = new org.openspcoop2.core.plugins.utils.CleanerOpenSPCoop2Extensions();
        this.cleanerOpenSPCoop2ExtensionsControlloTraffico = new org.openspcoop2.core.controllo_traffico.utils.CleanerOpenSPCoop2Extensions();
        this.cleanerOpenSPCoop2ExtensionsAllarme = new org.openspcoop2.core.allarmi.utils.CleanerOpenSPCoop2Extensions();
    }

    public void generateArchive(Archive archive, File file) throws ProtocolException {
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(file);
            this.generateArchive(archive, fout);
            fout.flush();
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
        finally {
            try {
                if (fout != null) {
                    fout.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void generateArchive(Archive archive, String fileName) throws ProtocolException {
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(fileName);
            this.generateArchive(archive, fout);
            fout.flush();
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
        finally {
            try {
                if (fout != null) {
                    fout.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public byte[] generateArchive(Archive archive) throws ProtocolException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            this.generateArchive(archive, bout);
            bout.flush();
            bout.close();
            return bout.toByteArray();
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
    }

    private void write(ZipOutputStream zipOut, String elemento, Object idElemento, SerializationType serializationType, Object object) throws ProtocolException {
        try {
            Method method = null;
            byte[] bytes = null;
            switch (serializationType) {
                case REGISTRY: {
                    method = this.jaxbRegistrySerializer.getClass().getMethod("toByteArray", object.getClass());
                    bytes = (byte[])method.invoke((Object)this.jaxbRegistrySerializer, object);
                    break;
                }
                case CONFIG: {
                    method = this.jaxbConfigSerializer.getClass().getMethod("toByteArray", object.getClass());
                    bytes = (byte[])method.invoke((Object)this.jaxbConfigSerializer, object);
                    break;
                }
                case PLUGIN: {
                    method = this.jaxbPluginSerializer.getClass().getMethod("toByteArray", object.getClass());
                    bytes = (byte[])method.invoke((Object)this.jaxbPluginSerializer, object);
                    break;
                }
                case CONTROLLO_TRAFFICO: {
                    method = this.jaxbControlloTrafficoSerializer.getClass().getMethod("toByteArray", object.getClass());
                    bytes = (byte[])method.invoke((Object)this.jaxbControlloTrafficoSerializer, object);
                    break;
                }
                case ALLARME: {
                    method = this.jaxbAllarmeSerializer.getClass().getMethod("toByteArray", object.getClass());
                    bytes = (byte[])method.invoke((Object)this.jaxbAllarmeSerializer, object);
                }
            }
            if (bytes != null) {
                zipOut.write(bytes);
            }
        }
        catch (Exception e) {
            String xml = null;
            try {
                Method method = object.getClass().getMethod("toXml_Jaxb", new Class[0]);
                xml = (String)method.invoke(object, new Object[0]);
            }
            catch (Exception eDebug) {
                this.log.error("Errore durante il recupero della struttura xml: " + String.valueOf(eDebug), (Throwable)eDebug);
                throw new ProtocolException("[" + elemento + "][" + String.valueOf(idElemento) + "]: " + e.getMessage(), e);
            }
            throw new ProtocolException("[" + elemento + "][" + String.valueOf(idElemento) + "] (" + xml + "): " + e.getMessage(), e);
        }
    }

    public void generateArchive(Archive archive, OutputStream out) throws ProtocolException {
        ZipOutputStream zipOut = null;
        try {
            Plugin plugin;
            ConfigurazionePolicy policy;
            zipOut = new ZipOutputStream(out);
            Object rootPackageDir = "";
            rootPackageDir = "openspcoop" + File.separatorChar;
            ExtendedInfoManager extendedInfoManager = ExtendedInfoManager.getInstance();
            Object nomeFile = "archive.info";
            zipOut.putNextEntry(new ZipEntry((String)rootPackageDir + (String)nomeFile));
            zipOut.write(ArchiveVersion.getContentFileVersion("GovWay/3.4.2").getBytes());
            if (archive.getConfigurazionePdD() != null) {
                nomeFile = "configurazione" + File.separatorChar + "configurazione.xml";
                zipOut.putNextEntry(new ZipEntry((String)rootPackageDir + (String)nomeFile));
                Configurazione configurazionePdD = archive.getConfigurazionePdD();
                while (configurazionePdD.sizeGenericPropertiesList() > 0) {
                    configurazionePdD.removeGenericProperties(0);
                }
                this.cleanerOpenSPCoop2ExtensionsConfig.clean(configurazionePdD);
                this.write(zipOut, "ConfigurazionePdD", "", SerializationType.CONFIG, configurazionePdD);
            }
            if (archive.getConfigurazionePdD_urlInvocazione() != null) {
                nomeFile = "configUrlInvocazione" + File.separatorChar + "configurazione.xml";
                zipOut.putNextEntry(new ZipEntry((String)rootPackageDir + (String)nomeFile));
                ConfigurazioneUrlInvocazione configurazioneUrlInvocazione = archive.getConfigurazionePdD_urlInvocazione();
                this.cleanerOpenSPCoop2ExtensionsConfig.clean(configurazioneUrlInvocazione);
                this.write(zipOut, "ConfigurazionePdD_UrlInvocazione", "", SerializationType.CONFIG, configurazioneUrlInvocazione);
            }
            if (archive.getConfigurazionePdD_urlInvocazione_regole() != null && archive.getConfigurazionePdD_urlInvocazione_regole().size() > 0) {
                for (int i = 0; i < archive.getConfigurazionePdD_urlInvocazione_regole().size(); ++i) {
                    ArchiveUrlInvocazioneRegola archiveUrlRegola = (ArchiveUrlInvocazioneRegola)archive.getConfigurazionePdD_urlInvocazione_regole().get(i);
                    nomeFile = "configUrlInvocazione" + File.separatorChar + "regole" + File.separatorChar + ZIPUtils.convertNameToSistemaOperativoCompatible(archiveUrlRegola.getNome()) + ".xml";
                    zipOut.putNextEntry(new ZipEntry((String)rootPackageDir + (String)nomeFile));
                    ConfigurazioneUrlInvocazioneRegola regola = archiveUrlRegola.getRegola();
                    this.cleanerOpenSPCoop2ExtensionsConfig.clean(regola);
                    this.write(zipOut, "ConfigurazionePdD_UrlInvocazione_regola", archiveUrlRegola.getNome(), SerializationType.CONFIG, regola);
                }
            }
            if (archive.getConfigurazionePdD() != null && archive.getConfigurazionePdD().sizeExtendedInfoList() > 0) {
                String prefix = "configurazione" + File.separatorChar + "extended" + File.separatorChar;
                for (int i = 0; i < archive.getConfigurazionePdD().sizeExtendedInfoList(); ++i) {
                    nomeFile = prefix + "extended" + (i + 1) + ".bin";
                    zipOut.putNextEntry(new ZipEntry((String)rootPackageDir + (String)nomeFile));
                    String className = null;
                    try {
                        Object o = archive.getConfigurazionePdD().getExtendedInfo(i);
                        className = o.getClass().getName();
                        zipOut.write(extendedInfoManager.newInstanceExtendedInfoConfigurazione().serialize(this.log, (Object)archive.getConfigurazionePdD(), o));
                        continue;
                    }
                    catch (Exception e) {
                        throw new ProtocolException("[ConfigurazionePdDExt][Posizione-" + i + "] (" + className + "): " + e.getMessage(), e);
                    }
                }
            }
            if (archive.getControlloTraffico_configurazione() != null) {
                nomeFile = "controlloTraffico" + File.separatorChar + "configurazione.xml";
                zipOut.putNextEntry(new ZipEntry((String)rootPackageDir + (String)nomeFile));
                ConfigurazioneGenerale configurazioneCC = archive.getControlloTraffico_configurazione();
                this.cleanerOpenSPCoop2ExtensionsControlloTraffico.clean(configurazioneCC);
                this.write(zipOut, "ControlloTraffico_Configurazione", "", SerializationType.CONTROLLO_TRAFFICO, configurazioneCC);
            }
            if (archive.getControlloTraffico_configurationPolicies() != null && archive.getControlloTraffico_configurationPolicies().size() > 0) {
                for (int i = 0; i < archive.getControlloTraffico_configurationPolicies().size(); ++i) {
                    ArchiveConfigurationPolicy archiveCC = (ArchiveConfigurationPolicy)archive.getControlloTraffico_configurationPolicies().get(i);
                    nomeFile = "controlloTraffico" + File.separatorChar + "configPolicies" + File.separatorChar + ZIPUtils.convertNameToSistemaOperativoCompatible(archiveCC.getNomePolicy()) + ".xml";
                    zipOut.putNextEntry(new ZipEntry((String)rootPackageDir + (String)nomeFile));
                    policy = archiveCC.getPolicy();
                    this.cleanerOpenSPCoop2ExtensionsControlloTraffico.clean(policy);
                    this.write(zipOut, "ControlloTraffico_ConfigurazionePolicy", archiveCC.getNomePolicy(), SerializationType.CONTROLLO_TRAFFICO, policy);
                }
            }
            if (archive.getControlloTraffico_activePolicies() != null && archive.getControlloTraffico_activePolicies().size() > 0) {
                for (int i = 0; i < archive.getControlloTraffico_activePolicies().size(); ++i) {
                    ArchiveActivePolicy archiveCC = (ArchiveActivePolicy)archive.getControlloTraffico_activePolicies().get(i);
                    nomeFile = "controlloTraffico" + File.separatorChar + "policies" + File.separatorChar + ZIPUtils.convertNameToSistemaOperativoCompatible(archiveCC.getPolicy().getIdActivePolicy()) + ".xml";
                    zipOut.putNextEntry(new ZipEntry((String)rootPackageDir + (String)nomeFile));
                    policy = archiveCC.getPolicy();
                    this.cleanerOpenSPCoop2ExtensionsControlloTraffico.clean((AttivazionePolicy)policy);
                    this.write(zipOut, "ControlloTraffico_AttivazionePolicy", archiveCC.getPolicy().getIdActivePolicy(), SerializationType.CONTROLLO_TRAFFICO, policy);
                }
            }
            if (archive.getAllarmi() != null && archive.getAllarmi().size() > 0) {
                for (int i = 0; i < archive.getAllarmi().size(); ++i) {
                    ArchiveAllarme archiveAllarme = (ArchiveAllarme)archive.getAllarmi().get(i);
                    nomeFile = "allarmi" + File.separatorChar + ZIPUtils.convertNameToSistemaOperativoCompatible(archiveAllarme.getAllarme().getNome()) + ".xml";
                    zipOut.putNextEntry(new ZipEntry((String)rootPackageDir + (String)nomeFile));
                    Allarme allarme = archiveAllarme.getAllarme();
                    this.cleanerOpenSPCoop2ExtensionsAllarme.clean(allarme);
                    this.write(zipOut, "Allarme", archiveAllarme.getAllarme().getNome(), SerializationType.ALLARME, allarme);
                }
            }
            if (archive.getToken_validation_policies() != null && archive.getToken_validation_policies().size() > 0) {
                for (int i = 0; i < archive.getToken_validation_policies().size(); ++i) {
                    ArchiveTokenPolicy archiveTP = (ArchiveTokenPolicy)archive.getToken_validation_policies().get(i);
                    nomeFile = "tokenPolicy" + File.separatorChar + "validation" + File.separatorChar + ZIPUtils.convertNameToSistemaOperativoCompatible(archiveTP.getNomePolicy()) + ".xml";
                    zipOut.putNextEntry(new ZipEntry((String)rootPackageDir + (String)nomeFile));
                    policy = archiveTP.getPolicy();
                    this.cleanerOpenSPCoop2ExtensionsConfig.clean((GenericProperties)policy);
                    this.write(zipOut, "TokenPolicy_Validation", archiveTP.getNomePolicy(), SerializationType.CONFIG, policy);
                }
            }
            if (archive.getToken_retrieve_policies() != null && archive.getToken_retrieve_policies().size() > 0) {
                for (int i = 0; i < archive.getToken_retrieve_policies().size(); ++i) {
                    ArchiveTokenPolicy archiveTP = (ArchiveTokenPolicy)archive.getToken_retrieve_policies().get(i);
                    nomeFile = "tokenPolicy" + File.separatorChar + "retrieve" + File.separatorChar + ZIPUtils.convertNameToSistemaOperativoCompatible(archiveTP.getNomePolicy()) + ".xml";
                    zipOut.putNextEntry(new ZipEntry((String)rootPackageDir + (String)nomeFile));
                    policy = archiveTP.getPolicy();
                    this.cleanerOpenSPCoop2ExtensionsConfig.clean((GenericProperties)policy);
                    this.write(zipOut, "TokenPolicy_Retrieve", archiveTP.getNomePolicy(), SerializationType.CONFIG, policy);
                }
            }
            if (archive.getAttributeAuthorities() != null && archive.getAttributeAuthorities().size() > 0) {
                for (int i = 0; i < archive.getAttributeAuthorities().size(); ++i) {
                    ArchiveAttributeAuthority archiveAA = (ArchiveAttributeAuthority)archive.getAttributeAuthorities().get(i);
                    nomeFile = "attributeAuthority" + File.separatorChar + "retrieve" + File.separatorChar + ZIPUtils.convertNameToSistemaOperativoCompatible(archiveAA.getNomePolicy()) + ".xml";
                    zipOut.putNextEntry(new ZipEntry((String)rootPackageDir + (String)nomeFile));
                    policy = archiveAA.getPolicy();
                    this.cleanerOpenSPCoop2ExtensionsConfig.clean((GenericProperties)policy);
                    this.write(zipOut, "AttributeAuthority_Retrieve", archiveAA.getNomePolicy(), SerializationType.CONFIG, policy);
                }
            }
            if (archive.getPlugin_classi() != null && archive.getPlugin_classi().size() > 0) {
                for (int i = 0; i < archive.getPlugin_classi().size(); ++i) {
                    ArchivePluginClasse archivePC = (ArchivePluginClasse)archive.getPlugin_classi().get(i);
                    nomeFile = "plugins" + File.separatorChar + "classi" + File.separatorChar + ZIPUtils.convertNameToSistemaOperativoCompatible(archivePC.getTipoPlugin()) + "_" + ZIPUtils.convertNameToSistemaOperativoCompatible(archivePC.getTipo()) + ".xml";
                    zipOut.putNextEntry(new ZipEntry((String)rootPackageDir + (String)nomeFile));
                    plugin = archivePC.getPlugin();
                    this.cleanerOpenSPCoop2ExtensionsPlugin.clean(plugin);
                    this.write(zipOut, "Plugin_Classe", archivePC.getTipoPlugin() + "_" + archivePC.getTipo(), SerializationType.PLUGIN, plugin);
                }
            }
            if (archive.getPlugin_archivi() != null && archive.getPlugin_archivi().size() > 0) {
                for (int i = 0; i < archive.getPlugin_archivi().size(); ++i) {
                    ArchivePluginArchivio archivePA = (ArchivePluginArchivio)archive.getPlugin_archivi().get(i);
                    nomeFile = "plugins" + File.separatorChar + "archivi" + File.separatorChar + ZIPUtils.convertNameToSistemaOperativoCompatible(archivePA.getNome()) + ".xml";
                    zipOut.putNextEntry(new ZipEntry((String)rootPackageDir + (String)nomeFile));
                    plugin = archivePA.getPlugin();
                    this.cleanerOpenSPCoop2ExtensionsConfig.clean((RegistroPlugin)plugin);
                    this.write(zipOut, "Plugin_Archivio", archivePA.getNome(), SerializationType.CONFIG, plugin);
                }
            }
            if (archive.getPdd() != null && archive.getPdd().size() > 0) {
                for (int i = 0; i < archive.getPdd().size(); ++i) {
                    ArchivePdd archivePdd = (ArchivePdd)archive.getPdd().get(i);
                    nomeFile = "porteDominio" + File.separatorChar + ZIPUtils.convertNameToSistemaOperativoCompatible(archivePdd.getNomePdd()) + ".xml";
                    zipOut.putNextEntry(new ZipEntry((String)rootPackageDir + (String)nomeFile));
                    PortaDominio pdd = archivePdd.getPortaDominio();
                    this.cleanerOpenSPCoop2ExtensionsRegistry.clean(pdd);
                    this.write(zipOut, "PortaDominio", archivePdd.getNomePdd(), SerializationType.REGISTRY, pdd);
                }
            }
            if (archive.getGruppi() != null && archive.getGruppi().size() > 0) {
                for (int i = 0; i < archive.getGruppi().size(); ++i) {
                    ArchiveGruppo archiveGruppo = (ArchiveGruppo)archive.getGruppi().get(i);
                    nomeFile = "gruppi" + File.separatorChar + ZIPUtils.convertNameToSistemaOperativoCompatible(archiveGruppo.getIdGruppo().getNome()) + ".xml";
                    zipOut.putNextEntry(new ZipEntry((String)rootPackageDir + (String)nomeFile));
                    Gruppo gruppo = archiveGruppo.getGruppo();
                    this.cleanerOpenSPCoop2ExtensionsRegistry.clean(gruppo);
                    this.write(zipOut, "Gruppo", archiveGruppo.getIdGruppo().getNome(), SerializationType.REGISTRY, gruppo);
                }
            }
            if (archive.getRuoli() != null && archive.getRuoli().size() > 0) {
                for (int i = 0; i < archive.getRuoli().size(); ++i) {
                    ArchiveRuolo archiveRuolo = (ArchiveRuolo)archive.getRuoli().get(i);
                    nomeFile = "ruoli" + File.separatorChar + ZIPUtils.convertNameToSistemaOperativoCompatible(archiveRuolo.getIdRuolo().getNome()) + ".xml";
                    zipOut.putNextEntry(new ZipEntry((String)rootPackageDir + (String)nomeFile));
                    Ruolo ruolo = archiveRuolo.getRuolo();
                    this.cleanerOpenSPCoop2ExtensionsRegistry.clean(ruolo);
                    this.write(zipOut, "Ruolo", archiveRuolo.getIdRuolo().getNome(), SerializationType.REGISTRY, ruolo);
                }
            }
            if (archive.getScope() != null && archive.getScope().size() > 0) {
                for (int i = 0; i < archive.getScope().size(); ++i) {
                    ArchiveScope archiveScope = (ArchiveScope)archive.getScope().get(i);
                    nomeFile = "scope" + File.separatorChar + ZIPUtils.convertNameToSistemaOperativoCompatible(archiveScope.getIdScope().getNome()) + ".xml";
                    zipOut.putNextEntry(new ZipEntry((String)rootPackageDir + (String)nomeFile));
                    Scope scope = archiveScope.getScope();
                    this.cleanerOpenSPCoop2ExtensionsRegistry.clean(scope);
                    this.write(zipOut, "Scope", archiveScope.getIdScope().getNome(), SerializationType.REGISTRY, scope);
                }
            }
            Map<String, Archive> archiveMapIntoSoggetti = this.archiveMapIntoSoggetti(archive);
            ArrayList<String> listaSoggetti = new ArrayList<String>();
            listaSoggetti.addAll(archiveMapIntoSoggetti.keySet());
            Collections.sort(listaSoggetti);
            for (String idSoggettoAsString : listaSoggetti) {
                IArchiveObject archiveAccordo;
                Object o;
                IDSoggetto idSoggetto = new IDSoggetto(idSoggettoAsString.split("/")[0], idSoggettoAsString.split("/")[1]);
                Archive archiveListaOggettiSoggetto = archiveMapIntoSoggetti.get(idSoggettoAsString);
                String rootDir = (String)rootPackageDir + "soggetti" + File.separatorChar + ZIPUtils.convertNameToSistemaOperativoCompatible(idSoggetto.getTipo()) + "_" + ZIPUtils.convertNameToSistemaOperativoCompatible(idSoggetto.getNome()) + File.separatorChar;
                String datiIdentificativiSoggetto = idSoggetto.toFormatString();
                nomeFile = "_datiIdentificativiSoggetto.id";
                zipOut.putNextEntry(new ZipEntry(rootDir + (String)nomeFile));
                zipOut.write(datiIdentificativiSoggetto.getBytes());
                if (archiveListaOggettiSoggetto.getSoggetti() != null && archiveListaOggettiSoggetto.getSoggetti().size() > 0) {
                    ArchiveSoggetto archiveSoggetto = (ArchiveSoggetto)archiveListaOggettiSoggetto.getSoggetti().get(0);
                    if (archiveSoggetto.getSoggettoRegistro() != null) {
                        HashMap<CallSite, byte[]> protocolPropertiesList = new HashMap<CallSite, byte[]>();
                        for (ProtocolProperty pp : archiveSoggetto.getSoggettoRegistro().getProtocolPropertyList()) {
                            if (pp.getByteFile() == null) continue;
                            if (pp.getFile() == null) {
                                throw new ProtocolException("ProtocolProperties [" + pp.getName() + "] senza nome file");
                            }
                            ProprietariProtocolProperty tipologiaProprietarioProtocolProperty = ProprietariProtocolProperty.SOGGETTO;
                            Object id = tipologiaProprietarioProtocolProperty.name() + "###" + pp.getName();
                            protocolPropertiesList.put((CallSite)id, pp.getByteFile());
                            pp.setByteFile(null);
                        }
                        nomeFile = "_soggettoRegistroServizi.xml";
                        zipOut.putNextEntry(new ZipEntry(rootDir + (String)nomeFile));
                        org.openspcoop2.core.registry.Soggetto soggettoRegistro = archiveSoggetto.getSoggettoRegistro();
                        this.cleanerOpenSPCoop2ExtensionsRegistry.clean(soggettoRegistro);
                        this.write(zipOut, "SoggettoRegistro", archiveSoggetto.getIdSoggetto(), SerializationType.REGISTRY, soggettoRegistro);
                        if (protocolPropertiesList.size() > 0) {
                            int indexPP = 1;
                            for (Object id : protocolPropertiesList.keySet()) {
                                nomeFile = "proprietaProtocollo" + File.separatorChar + "attachment_" + indexPP + ".id";
                                zipOut.putNextEntry(new ZipEntry(rootDir + (String)nomeFile));
                                zipOut.write(((String)id).getBytes());
                                nomeFile = "proprietaProtocollo" + File.separatorChar + "attachment_" + indexPP + ".raw";
                                zipOut.putNextEntry(new ZipEntry(rootDir + (String)nomeFile));
                                zipOut.write((byte[])protocolPropertiesList.get(id));
                                ++indexPP;
                            }
                        }
                    }
                    if (archiveSoggetto.getSoggettoConfigurazione() != null) {
                        nomeFile = "_soggettoConfigurazione.xml";
                        zipOut.putNextEntry(new ZipEntry(rootDir + (String)nomeFile));
                        Soggetto soggettoConfigurazione = archiveSoggetto.getSoggettoConfigurazione();
                        this.cleanerOpenSPCoop2ExtensionsConfig.clean(soggettoConfigurazione);
                        this.write(zipOut, "SoggettoConfigurazione", archiveSoggetto.getIdSoggetto(), SerializationType.CONFIG, soggettoConfigurazione);
                    }
                }
                if (archiveListaOggettiSoggetto.getServiziApplicativi() != null && archiveListaOggettiSoggetto.getServiziApplicativi().size() > 0) {
                    for (int i = 0; i < archiveListaOggettiSoggetto.getServiziApplicativi().size(); ++i) {
                        ArchiveServizioApplicativo archiveServizioApplicativo = (ArchiveServizioApplicativo)archiveListaOggettiSoggetto.getServiziApplicativi().get(i);
                        HashMap<CallSite, byte[]> protocolPropertiesList = new HashMap<CallSite, byte[]>();
                        for (org.openspcoop2.core.config.ProtocolProperty pp : archiveServizioApplicativo.getServizioApplicativo().getProtocolPropertyList()) {
                            if (pp.getByteFile() == null) continue;
                            if (pp.getFile() == null) {
                                throw new ProtocolException("ProtocolProperties [" + pp.getName() + "] senza nome file");
                            }
                            ProprietariProtocolProperty tipologiaProprietarioProtocolProperty = ProprietariProtocolProperty.SERVIZIO_APPLICATIVO;
                            String id = tipologiaProprietarioProtocolProperty.name() + "###" + pp.getName();
                            protocolPropertiesList.put((CallSite)((Object)id), pp.getByteFile());
                            pp.setByteFile(null);
                        }
                        String nomeFileSA = "serviziApplicativi" + File.separatorChar + ZIPUtils.convertNameToSistemaOperativoCompatible(archiveServizioApplicativo.getIdServizioApplicativo().getNome());
                        zipOut.putNextEntry(new ZipEntry(rootDir + nomeFileSA + ".xml"));
                        ServizioApplicativo servizioApplicativo = archiveServizioApplicativo.getServizioApplicativo();
                        this.cleanerOpenSPCoop2ExtensionsConfig.clean(servizioApplicativo);
                        this.write(zipOut, "ServizioApplicativo", archiveServizioApplicativo.getIdServizioApplicativo(), SerializationType.CONFIG, servizioApplicativo);
                        if (protocolPropertiesList.size() <= 0) continue;
                        int indexPP = 1;
                        for (Object id : protocolPropertiesList.keySet()) {
                            String nomeFilePP = nomeFileSA + File.separatorChar + "proprietaProtocollo" + File.separatorChar + "attachment_" + indexPP + ".id";
                            zipOut.putNextEntry(new ZipEntry(rootDir + nomeFilePP));
                            zipOut.write(((String)id).getBytes());
                            nomeFilePP = nomeFileSA + File.separatorChar + "proprietaProtocollo" + File.separatorChar + "attachment_" + indexPP + ".raw";
                            zipOut.putNextEntry(new ZipEntry(rootDir + nomeFilePP));
                            zipOut.write((byte[])protocolPropertiesList.get(id));
                            ++indexPP;
                        }
                    }
                }
                if (archiveListaOggettiSoggetto.getPorteDelegate() != null && archiveListaOggettiSoggetto.getPorteDelegate().size() > 0) {
                    for (int i = 0; i < archiveListaOggettiSoggetto.getPorteDelegate().size(); ++i) {
                        ArchivePortaDelegata archivePortaDelegata = (ArchivePortaDelegata)archiveListaOggettiSoggetto.getPorteDelegate().get(i);
                        nomeFile = "porteDelegate" + File.separatorChar + ZIPUtils.convertNameToSistemaOperativoCompatible(archivePortaDelegata.getIdPortaDelegata().getNome()) + ".xml";
                        zipOut.putNextEntry(new ZipEntry(rootDir + (String)nomeFile));
                        PortaDelegata portaDelegata = archivePortaDelegata.getPortaDelegata();
                        this.cleanerOpenSPCoop2ExtensionsConfig.clean(portaDelegata);
                        this.write(zipOut, "PortaDelegata", archivePortaDelegata.getIdPortaDelegata(), SerializationType.CONFIG, portaDelegata);
                        if (archivePortaDelegata.getPortaDelegata() == null || archivePortaDelegata.getPortaDelegata().sizeExtendedInfoList() <= 0) continue;
                        String prefix = "porteDelegate" + File.separatorChar + "extended" + File.separatorChar + ZIPUtils.convertNameToSistemaOperativoCompatible(archivePortaDelegata.getIdPortaDelegata().getNome()) + File.separatorChar;
                        for (int k = 0; k < archivePortaDelegata.getPortaDelegata().sizeExtendedInfoList(); ++k) {
                            nomeFile = prefix + "extended" + (k + 1) + ".bin";
                            zipOut.putNextEntry(new ZipEntry(rootDir + (String)nomeFile));
                            String className = null;
                            try {
                                o = archivePortaDelegata.getPortaDelegata().getExtendedInfo(k);
                                className = o.getClass().getName();
                                zipOut.write(extendedInfoManager.newInstanceExtendedInfoPortaDelegata().serialize(this.log, (Object)archivePortaDelegata.getPortaDelegata(), o));
                                continue;
                            }
                            catch (Exception e) {
                                throw new ProtocolException("[PortaDelegataExt][" + String.valueOf(archivePortaDelegata.getIdPortaDelegata()) + "][Posizione-" + i + "] (" + className + "): " + e.getMessage(), e);
                            }
                        }
                    }
                }
                if (archiveListaOggettiSoggetto.getPorteApplicative() != null && archiveListaOggettiSoggetto.getPorteApplicative().size() > 0) {
                    for (int i = 0; i < archiveListaOggettiSoggetto.getPorteApplicative().size(); ++i) {
                        ArchivePortaApplicativa archivePortaApplicativa = (ArchivePortaApplicativa)archiveListaOggettiSoggetto.getPorteApplicative().get(i);
                        nomeFile = "porteApplicative" + File.separatorChar + ZIPUtils.convertNameToSistemaOperativoCompatible(archivePortaApplicativa.getIdPortaApplicativa().getNome()) + ".xml";
                        zipOut.putNextEntry(new ZipEntry(rootDir + (String)nomeFile));
                        PortaApplicativa portaApplicativa = archivePortaApplicativa.getPortaApplicativa();
                        this.cleanerOpenSPCoop2ExtensionsConfig.clean(portaApplicativa);
                        this.write(zipOut, "PortaApplicativa", archivePortaApplicativa.getIdPortaApplicativa(), SerializationType.CONFIG, portaApplicativa);
                        if (archivePortaApplicativa.getPortaApplicativa() == null || archivePortaApplicativa.getPortaApplicativa().sizeExtendedInfoList() <= 0) continue;
                        String prefix = "porteApplicative" + File.separatorChar + "extended" + File.separatorChar + ZIPUtils.convertNameToSistemaOperativoCompatible(archivePortaApplicativa.getIdPortaApplicativa().getNome()) + File.separatorChar;
                        for (int k = 0; k < archivePortaApplicativa.getPortaApplicativa().sizeExtendedInfoList(); ++k) {
                            nomeFile = prefix + "extended" + (k + 1) + ".bin";
                            zipOut.putNextEntry(new ZipEntry(rootDir + (String)nomeFile));
                            String className = null;
                            try {
                                o = archivePortaApplicativa.getPortaApplicativa().getExtendedInfo(k);
                                className = o.getClass().getName();
                                zipOut.write(extendedInfoManager.newInstanceExtendedInfoPortaApplicativa().serialize(this.log, (Object)archivePortaApplicativa.getPortaApplicativa(), o));
                                continue;
                            }
                            catch (Exception e) {
                                throw new ProtocolException("[PortaApplicativaExt][" + String.valueOf(archivePortaApplicativa.getIdPortaApplicativa()) + "][Posizione-" + i + "] (" + className + "): " + e.getMessage(), e);
                            }
                        }
                    }
                }
                if (archiveListaOggettiSoggetto.getAccordiServizioParteComune() != null && archiveListaOggettiSoggetto.getAccordiServizioParteComune().size() > 0) {
                    for (int i = 0; i < archiveListaOggettiSoggetto.getAccordiServizioParteComune().size(); ++i) {
                        ArchiveAccordoServizioParteComune archiveAccordo2 = (ArchiveAccordoServizioParteComune)archiveListaOggettiSoggetto.getAccordiServizioParteComune().get(i);
                        AccordoServizioParteComune accordo = archiveAccordo2.getAccordoServizioParteComune();
                        IDAccordo idAccordo = archiveAccordo2.getIdAccordoServizioParteComune();
                        this.saveAccordo(accordo, idAccordo, false, rootDir, zipOut);
                    }
                }
                HashMap<String, String> map_IdApsScritti_nomeFileSystem = new HashMap<String, String>();
                if (archiveListaOggettiSoggetto.getAccordiServizioParteSpecifica() != null && archiveListaOggettiSoggetto.getAccordiServizioParteSpecifica().size() > 0) {
                    for (int i = 0; i < archiveListaOggettiSoggetto.getAccordiServizioParteSpecifica().size(); ++i) {
                        archiveAccordo = (ArchiveAccordoServizioParteSpecifica)archiveListaOggettiSoggetto.getAccordiServizioParteSpecifica().get(i);
                        AccordoServizioParteSpecifica accordo = ((ArchiveAccordoServizioParteSpecifica)archiveAccordo).getAccordoServizioParteSpecifica();
                        IDServizio idAccordo = ((ArchiveAccordoServizioParteSpecifica)archiveAccordo).getIdAccordoServizioParteSpecifica();
                        this.saveAccordo(accordo, idAccordo, ((ArchiveAccordoServizioParteSpecifica)archiveAccordo).getMappingPorteApplicativeAssociate(), rootDir, zipOut, map_IdApsScritti_nomeFileSystem);
                    }
                }
                if (archiveListaOggettiSoggetto.getAccordiCooperazione() != null && archiveListaOggettiSoggetto.getAccordiCooperazione().size() > 0) {
                    for (int i = 0; i < archiveListaOggettiSoggetto.getAccordiCooperazione().size(); ++i) {
                        archiveAccordo = (ArchiveAccordoCooperazione)archiveListaOggettiSoggetto.getAccordiCooperazione().get(i);
                        AccordoCooperazione accordo = ((ArchiveAccordoCooperazione)archiveAccordo).getAccordoCooperazione();
                        IDAccordoCooperazione idAccordo = ((ArchiveAccordoCooperazione)archiveAccordo).getIdAccordoCooperazione();
                        this.saveAccordo(accordo, idAccordo, rootDir, zipOut);
                    }
                }
                if (archiveListaOggettiSoggetto.getAccordiServizioComposto() != null && archiveListaOggettiSoggetto.getAccordiServizioComposto().size() > 0) {
                    for (int i = 0; i < archiveListaOggettiSoggetto.getAccordiServizioComposto().size(); ++i) {
                        archiveAccordo = (ArchiveAccordoServizioParteComune)archiveListaOggettiSoggetto.getAccordiServizioComposto().get(i);
                        AccordoServizioParteComune accordo = ((ArchiveAccordoServizioParteComune)archiveAccordo).getAccordoServizioParteComune();
                        IDAccordo idAccordo = ((ArchiveAccordoServizioParteComune)archiveAccordo).getIdAccordoServizioParteComune();
                        this.saveAccordo(accordo, idAccordo, true, rootDir, zipOut);
                    }
                }
                if (archiveListaOggettiSoggetto.getAccordiFruitori() == null || archiveListaOggettiSoggetto.getAccordiFruitori().size() <= 0) continue;
                for (int i = 0; i < archiveListaOggettiSoggetto.getAccordiFruitori().size(); ++i) {
                    ArchiveFruitore archiveFruitore = (ArchiveFruitore)archiveListaOggettiSoggetto.getAccordiFruitori().get(i);
                    Object dirAsps = null;
                    String idAps = archiveFruitore.getIdAccordoServizioParteSpecifica().getNome() + " " + archiveFruitore.getIdAccordoServizioParteSpecifica().getVersione();
                    if (!map_IdApsScritti_nomeFileSystem.containsKey(idAps)) {
                        dirAsps = "accordiServizioParteSpecifica" + File.separatorChar + ZIPUtils.convertNameToSistemaOperativoCompatible(archiveFruitore.getIdAccordoServizioParteSpecifica().getNome()) + "_" + archiveFruitore.getIdAccordoServizioParteSpecifica().getVersione() + File.separatorChar;
                        nomeFile = (String)dirAsps + "accordo.id";
                        zipOut.putNextEntry(new ZipEntry(rootDir + (String)nomeFile));
                        String identificativo = idAps;
                        zipOut.write(identificativo.getBytes());
                        map_IdApsScritti_nomeFileSystem.put(idAps, (String)dirAsps);
                    } else {
                        dirAsps = (String)map_IdApsScritti_nomeFileSystem.get(idAps);
                    }
                    Fruitore fruitore = archiveFruitore.getFruitore();
                    HashMap<CallSite, byte[]> protocolPropertiesList = new HashMap<CallSite, byte[]>();
                    if (fruitore.sizeProtocolPropertyList() > 0) {
                        Object id;
                        id = fruitore.getProtocolPropertyList().iterator();
                        while (id.hasNext()) {
                            ProtocolProperty pp = (ProtocolProperty)id.next();
                            if (pp.getByteFile() == null) continue;
                            if (pp.getFile() == null) {
                                throw new ProtocolException("ProtocolProperties [" + pp.getName() + "] senza nome file");
                            }
                            ProprietariProtocolProperty tipologiaProprietarioProtocolProperty = ProprietariProtocolProperty.FRUITORE;
                            String id2 = tipologiaProprietarioProtocolProperty.name() + "###" + pp.getName();
                            protocolPropertiesList.put((CallSite)((Object)id2), pp.getByteFile());
                            pp.setByteFile(null);
                        }
                    }
                    String nomeFruitore = (String)dirAsps + "fruitori" + File.separatorChar + ZIPUtils.convertNameToSistemaOperativoCompatible(archiveFruitore.getIdSoggettoFruitore().getTipo()) + "_" + ZIPUtils.convertNameToSistemaOperativoCompatible(archiveFruitore.getIdSoggettoFruitore().getNome());
                    String datiIdentificativiFruitore = archiveFruitore.getIdSoggettoFruitore().toFormatString();
                    nomeFile = nomeFruitore + ".id";
                    zipOut.putNextEntry(new ZipEntry(rootDir + (String)nomeFile));
                    zipOut.write(datiIdentificativiFruitore.getBytes());
                    nomeFile = nomeFruitore + ".xml";
                    zipOut.putNextEntry(new ZipEntry(rootDir + (String)nomeFile));
                    this.cleanerOpenSPCoop2ExtensionsRegistry.clean(fruitore);
                    this.write(zipOut, "Fruitore", archiveFruitore.getIdSoggettoFruitore().toString() + " di " + archiveFruitore.getIdAccordoServizioParteSpecifica().toString(), SerializationType.REGISTRY, fruitore);
                    if (protocolPropertiesList.size() > 0) {
                        int indexPP = 1;
                        for (String id : protocolPropertiesList.keySet()) {
                            nomeFile = nomeFruitore + File.separatorChar + "proprietaProtocollo" + File.separatorChar + "attachment_" + indexPP + ".id";
                            zipOut.putNextEntry(new ZipEntry(rootDir + (String)nomeFile));
                            zipOut.write(id.getBytes());
                            nomeFile = nomeFruitore + File.separatorChar + "proprietaProtocollo" + File.separatorChar + "attachment_" + indexPP + ".raw";
                            zipOut.putNextEntry(new ZipEntry(rootDir + (String)nomeFile));
                            zipOut.write((byte[])protocolPropertiesList.get(id));
                            ++indexPP;
                        }
                    }
                    if (archiveFruitore.getMappingPorteDelegateAssociate() == null) continue;
                    for (int j = 0; j < archiveFruitore.getMappingPorteDelegateAssociate().size(); ++j) {
                        String nomeFilePDAssociata = nomeFruitore + File.separatorChar + (j + 1) + "_mappingFruizionePD.id";
                        zipOut.putNextEntry(new ZipEntry(rootDir + nomeFilePDAssociata));
                        MappingFruizionePortaDelegata mappingPortaDelegataAssociata = archiveFruitore.getMappingPorteDelegateAssociate().get(j);
                        String id = mappingPortaDelegataAssociata.getNome() + " " + mappingPortaDelegataAssociata.getIdPortaDelegata().getNome() + " " + mappingPortaDelegataAssociata.isDefault() + " " + mappingPortaDelegataAssociata.getDescrizione();
                        zipOut.write(id.getBytes());
                    }
                }
            }
            zipOut.flush();
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
        finally {
            try {
                if (zipOut != null) {
                    zipOut.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private Map<String, Archive> archiveMapIntoSoggetti(Archive archive) throws ProtocolException {
        IArchiveObject archiveAccordo;
        Archive archiveListaOggettiSoggetti;
        IDSoggetto idSoggetto;
        int i;
        HashMap<String, Archive> archiveMapIntoSoggetti = new HashMap<String, Archive>();
        if (archive.getSoggetti() != null && archive.getSoggetti().size() > 0) {
            for (i = 0; i < archive.getSoggetti().size(); ++i) {
                ArchiveSoggetto archiveSoggetto = (ArchiveSoggetto)archive.getSoggetti().get(i);
                idSoggetto = archiveSoggetto.getIdSoggetto();
                archiveListaOggettiSoggetti = null;
                archiveListaOggettiSoggetti = archiveMapIntoSoggetti.containsKey(idSoggetto.toString()) ? (Archive)archiveMapIntoSoggetti.remove(idSoggetto.toString()) : new Archive();
                archiveListaOggettiSoggetti.getSoggetti().add(archiveSoggetto);
                archiveMapIntoSoggetti.put(idSoggetto.toString(), archiveListaOggettiSoggetti);
            }
        }
        if (archive.getServiziApplicativi() != null && archive.getServiziApplicativi().size() > 0) {
            for (i = 0; i < archive.getServiziApplicativi().size(); ++i) {
                ArchiveServizioApplicativo archiveServizioApplicativo = (ArchiveServizioApplicativo)archive.getServiziApplicativi().get(i);
                idSoggetto = archiveServizioApplicativo.getIdSoggettoProprietario();
                archiveListaOggettiSoggetti = null;
                archiveListaOggettiSoggetti = archiveMapIntoSoggetti.containsKey(idSoggetto.toString()) ? (Archive)archiveMapIntoSoggetti.remove(idSoggetto.toString()) : new Archive();
                archiveListaOggettiSoggetti.getServiziApplicativi().add(archiveServizioApplicativo);
                archiveMapIntoSoggetti.put(idSoggetto.toString(), archiveListaOggettiSoggetti);
            }
        }
        if (archive.getPorteDelegate() != null && archive.getPorteDelegate().size() > 0) {
            for (i = 0; i < archive.getPorteDelegate().size(); ++i) {
                ArchivePortaDelegata archivePortaDelegata = (ArchivePortaDelegata)archive.getPorteDelegate().get(i);
                idSoggetto = archivePortaDelegata.getIdSoggettoProprietario();
                archiveListaOggettiSoggetti = null;
                archiveListaOggettiSoggetti = archiveMapIntoSoggetti.containsKey(idSoggetto.toString()) ? (Archive)archiveMapIntoSoggetti.remove(idSoggetto.toString()) : new Archive();
                archiveListaOggettiSoggetti.getPorteDelegate().add(archivePortaDelegata);
                archiveMapIntoSoggetti.put(idSoggetto.toString(), archiveListaOggettiSoggetti);
            }
        }
        if (archive.getPorteApplicative() != null && archive.getPorteApplicative().size() > 0) {
            for (i = 0; i < archive.getPorteApplicative().size(); ++i) {
                ArchivePortaApplicativa archivePortaApplicativa = (ArchivePortaApplicativa)archive.getPorteApplicative().get(i);
                idSoggetto = archivePortaApplicativa.getIdSoggettoProprietario();
                archiveListaOggettiSoggetti = null;
                archiveListaOggettiSoggetti = archiveMapIntoSoggetti.containsKey(idSoggetto.toString()) ? (Archive)archiveMapIntoSoggetti.remove(idSoggetto.toString()) : new Archive();
                archiveListaOggettiSoggetti.getPorteApplicative().add(archivePortaApplicativa);
                archiveMapIntoSoggetti.put(idSoggetto.toString(), archiveListaOggettiSoggetti);
            }
        }
        if (archive.getAccordiServizioParteComune() != null && archive.getAccordiServizioParteComune().size() > 0) {
            for (i = 0; i < archive.getAccordiServizioParteComune().size(); ++i) {
                archiveAccordo = (ArchiveAccordoServizioParteComune)archive.getAccordiServizioParteComune().get(i);
                idSoggetto = ((ArchiveAccordoServizioParteComune)archiveAccordo).getIdSoggettoReferente();
                archiveListaOggettiSoggetti = null;
                archiveListaOggettiSoggetti = archiveMapIntoSoggetti.containsKey(idSoggetto.toString()) ? (Archive)archiveMapIntoSoggetti.remove(idSoggetto.toString()) : new Archive();
                archiveListaOggettiSoggetti.getAccordiServizioParteComune().add((ArchiveAccordoServizioParteComune)archiveAccordo);
                archiveMapIntoSoggetti.put(idSoggetto.toString(), archiveListaOggettiSoggetti);
            }
        }
        if (archive.getAccordiServizioComposto() != null && archive.getAccordiServizioComposto().size() > 0) {
            for (i = 0; i < archive.getAccordiServizioComposto().size(); ++i) {
                archiveAccordo = (ArchiveAccordoServizioComposto)archive.getAccordiServizioComposto().get(i);
                idSoggetto = ((ArchiveAccordoServizioParteComune)archiveAccordo).getIdSoggettoReferente();
                archiveListaOggettiSoggetti = null;
                archiveListaOggettiSoggetti = archiveMapIntoSoggetti.containsKey(idSoggetto.toString()) ? (Archive)archiveMapIntoSoggetti.remove(idSoggetto.toString()) : new Archive();
                archiveListaOggettiSoggetti.getAccordiServizioComposto().add((ArchiveAccordoServizioComposto)archiveAccordo);
                archiveMapIntoSoggetti.put(idSoggetto.toString(), archiveListaOggettiSoggetti);
            }
        }
        if (archive.getAccordiServizioParteSpecifica() != null && archive.getAccordiServizioParteSpecifica().size() > 0) {
            for (i = 0; i < archive.getAccordiServizioParteSpecifica().size(); ++i) {
                archiveAccordo = (ArchiveAccordoServizioParteSpecifica)archive.getAccordiServizioParteSpecifica().get(i);
                idSoggetto = ((ArchiveAccordoServizioParteSpecifica)archiveAccordo).getIdSoggettoErogatore();
                archiveListaOggettiSoggetti = null;
                archiveListaOggettiSoggetti = archiveMapIntoSoggetti.containsKey(idSoggetto.toString()) ? (Archive)archiveMapIntoSoggetti.remove(idSoggetto.toString()) : new Archive();
                archiveListaOggettiSoggetti.getAccordiServizioParteSpecifica().add((ArchiveAccordoServizioParteSpecifica)archiveAccordo);
                archiveMapIntoSoggetti.put(idSoggetto.toString(), archiveListaOggettiSoggetti);
            }
        }
        if (archive.getAccordiCooperazione() != null && archive.getAccordiCooperazione().size() > 0) {
            for (i = 0; i < archive.getAccordiCooperazione().size(); ++i) {
                archiveAccordo = (ArchiveAccordoCooperazione)archive.getAccordiCooperazione().get(i);
                idSoggetto = ((ArchiveAccordoCooperazione)archiveAccordo).getIdSoggettoReferente();
                archiveListaOggettiSoggetti = null;
                archiveListaOggettiSoggetti = archiveMapIntoSoggetti.containsKey(idSoggetto.toString()) ? (Archive)archiveMapIntoSoggetti.remove(idSoggetto.toString()) : new Archive();
                archiveListaOggettiSoggetti.getAccordiCooperazione().add((ArchiveAccordoCooperazione)archiveAccordo);
                archiveMapIntoSoggetti.put(idSoggetto.toString(), archiveListaOggettiSoggetti);
            }
        }
        if (archive.getAccordiFruitori() != null && archive.getAccordiFruitori().size() > 0) {
            for (i = 0; i < archive.getAccordiFruitori().size(); ++i) {
                ArchiveFruitore archiveFruitore = (ArchiveFruitore)archive.getAccordiFruitori().get(i);
                idSoggetto = archiveFruitore.getIdAccordoServizioParteSpecifica().getSoggettoErogatore();
                archiveListaOggettiSoggetti = null;
                archiveListaOggettiSoggetti = archiveMapIntoSoggetti.containsKey(idSoggetto.toString()) ? (Archive)archiveMapIntoSoggetti.remove(idSoggetto.toString()) : new Archive();
                archiveListaOggettiSoggetti.getAccordiFruitori().add(archiveFruitore);
                archiveMapIntoSoggetti.put(idSoggetto.toString(), archiveListaOggettiSoggetti);
            }
        }
        return archiveMapIntoSoggetti;
    }

    private void saveAccordo(AccordoServizioParteComune accordo, IDAccordo idAccordo, boolean servizioComposto, String parentDir, ZipOutputStream zipOut) throws IOException, SerializerException, ProtocolException {
        String nomeAccordo = null;
        try {
            Object id7;
            Object tipologiaProprietarioProtocolProperty;
            String nomeDefinizione = "accordo.xml";
            nomeAccordo = "accordiServizioParteComune";
            if (servizioComposto) {
                nomeDefinizione = "accordo.xml";
                nomeAccordo = "accordiServizioComposto";
            }
            String rootDir = parentDir + nomeAccordo + File.separatorChar + ZIPUtils.convertNameToSistemaOperativoCompatible(idAccordo.getNome()) + "_" + idAccordo.getVersione() + File.separatorChar;
            byte[] wsdlInterfacciaDefinitoria = accordo.getByteWsdlDefinitorio();
            accordo.setByteWsdlDefinitorio(null);
            byte[] wsdlInterfacciaConcettuale = accordo.getByteWsdlConcettuale();
            accordo.setByteWsdlConcettuale(null);
            byte[] wsdlInterfacciaLogicaErogatore = accordo.getByteWsdlLogicoErogatore();
            accordo.setByteWsdlLogicoErogatore(null);
            byte[] wsdlInterfacciaLogicaFruitore = accordo.getByteWsdlLogicoFruitore();
            accordo.setByteWsdlLogicoFruitore(null);
            byte[] specificaConversazioneConcettuale = accordo.getByteSpecificaConversazioneConcettuale();
            accordo.setSpecificaConversazioneConcettuale(null);
            byte[] specificaConversazioneLogicaErogatore = accordo.getByteSpecificaConversazioneErogatore();
            accordo.setSpecificaConversazioneErogatore(null);
            byte[] specificaConversazioneLogicaFruitore = accordo.getByteSpecificaConversazioneFruitore();
            accordo.setSpecificaConversazioneFruitore(null);
            HashMap<CallSite, byte[]> allegatiList = new HashMap<CallSite, byte[]>();
            for (Object documento : accordo.getAllegatoList()) {
                if (documento.getFile() == null) {
                    throw new ProtocolException("Allegato senza nome file");
                }
                if (documento.getByteContenuto() == null) {
                    throw new ProtocolException("Allegato[" + documento.getFile() + "] senza contenuto");
                }
                if (documento.getTipo() == null) {
                    throw new ProtocolException("Allegato[" + documento.getFile() + "] senza tipo");
                }
                String id2 = documento.getTipo() + "###" + documento.getFile();
                allegatiList.put((CallSite)((Object)id2), documento.getByteContenuto());
                documento.setByteContenuto(null);
            }
            HashMap<CallSite, byte[]> specificaSemiformaleList = new HashMap<CallSite, byte[]>();
            for (Object documento : accordo.getSpecificaSemiformaleList()) {
                if (documento.getFile() == null) {
                    throw new ProtocolException("SpecificaSemiformale senza nome file");
                }
                if (documento.getByteContenuto() == null) {
                    throw new ProtocolException("SpecificaSemiformale[" + documento.getFile() + "] senza contenuto");
                }
                if (documento.getTipo() == null) {
                    throw new ProtocolException("SpecificaSemiformale[" + documento.getFile() + "] senza tipo");
                }
                String id3 = documento.getTipo() + "###" + documento.getFile();
                specificaSemiformaleList.put((CallSite)((Object)id3), documento.getByteContenuto());
                documento.setByteContenuto(null);
            }
            HashMap<CallSite, byte[]> specificaCoordinamentoList = new HashMap<CallSite, byte[]>();
            if (servizioComposto) {
                for (Object documento : accordo.getServizioComposto().getSpecificaCoordinamentoList()) {
                    if (documento.getFile() == null) {
                        throw new ProtocolException("SpecificaCoordinamento senza nome file");
                    }
                    if (documento.getByteContenuto() == null) {
                        throw new ProtocolException("SpecificaCoordinamento[" + documento.getFile() + "] senza contenuto");
                    }
                    if (documento.getTipo() == null) {
                        throw new ProtocolException("SpecificaCoordinamento[" + documento.getFile() + "] senza tipo");
                    }
                    String id4 = documento.getTipo() + "###" + documento.getFile();
                    specificaCoordinamentoList.put((CallSite)((Object)id4), documento.getByteContenuto());
                    documento.setByteContenuto(null);
                }
            }
            HashMap<CallSite, byte[]> protocolPropertiesList = new HashMap<CallSite, byte[]>();
            for (ProtocolProperty pp : accordo.getProtocolPropertyList()) {
                if (pp.getByteFile() == null) continue;
                if (pp.getFile() == null) {
                    throw new ProtocolException("ProtocolProperties [" + pp.getName() + "] senza nome file");
                }
                ProprietariProtocolProperty tipologiaProprietarioProtocolProperty2 = ProprietariProtocolProperty.ACCORDO_SERVIZIO_PARTE_COMUNE;
                String id5 = tipologiaProprietarioProtocolProperty2.name() + "###" + pp.getName();
                protocolPropertiesList.put((CallSite)((Object)id5), pp.getByteFile());
                pp.setByteFile(null);
            }
            if (accordo.sizeAzioneList() > 0) {
                for (Azione az : accordo.getAzioneList()) {
                    for (ProtocolProperty pp : az.getProtocolPropertyList()) {
                        if (pp.getByteFile() == null) continue;
                        if (pp.getFile() == null) {
                            throw new ProtocolException("ProtocolProperties (azione:" + az.getNome() + ") [" + pp.getName() + "] senza nome file");
                        }
                        tipologiaProprietarioProtocolProperty = ProprietariProtocolProperty.AZIONE_ACCORDO;
                        id7 = tipologiaProprietarioProtocolProperty.name() + "###" + az.getNome() + "###" + pp.getName();
                        protocolPropertiesList.put((CallSite)id7, pp.getByteFile());
                        pp.setByteFile(null);
                    }
                }
            }
            if (accordo.sizePortTypeList() > 0) {
                for (PortType pt : accordo.getPortTypeList()) {
                    for (ProtocolProperty pp : pt.getProtocolPropertyList()) {
                        if (pp.getByteFile() == null) continue;
                        if (pp.getFile() == null) {
                            throw new ProtocolException("ProtocolProperties (pt:" + pt.getNome() + ") [" + pp.getName() + "] senza nome file");
                        }
                        tipologiaProprietarioProtocolProperty = ProprietariProtocolProperty.PORT_TYPE;
                        id7 = tipologiaProprietarioProtocolProperty.name() + "###" + pt.getNome() + "###" + pp.getName();
                        protocolPropertiesList.put((CallSite)id7, pp.getByteFile());
                        pp.setByteFile(null);
                    }
                    if (pt.sizeAzioneList() <= 0) continue;
                    for (Operation op : pt.getAzioneList()) {
                        for (ProtocolProperty pp : op.getProtocolPropertyList()) {
                            if (pp.getByteFile() == null) continue;
                            if (pp.getFile() == null) {
                                throw new ProtocolException("ProtocolProperties (op:" + op.getNome() + ") [" + pp.getName() + "] senza nome file");
                            }
                            ProprietariProtocolProperty tipologiaProprietarioProtocolProperty3 = ProprietariProtocolProperty.OPERATION;
                            String id6 = tipologiaProprietarioProtocolProperty3.name() + "###" + op.getNome() + "###" + pp.getName();
                            protocolPropertiesList.put((CallSite)((Object)id6), pp.getByteFile());
                            pp.setByteFile(null);
                        }
                    }
                }
            }
            if (accordo.sizeResourceList() > 0) {
                for (Resource resource : accordo.getResourceList()) {
                    for (ProtocolProperty pp : resource.getProtocolPropertyList()) {
                        if (pp.getByteFile() == null) continue;
                        if (pp.getFile() == null) {
                            throw new ProtocolException("ProtocolProperties (resource:" + resource.getNome() + ") [" + pp.getName() + "] senza nome file");
                        }
                        tipologiaProprietarioProtocolProperty = ProprietariProtocolProperty.RESOURCE;
                        id7 = tipologiaProprietarioProtocolProperty.name() + "###" + resource.getNome() + "###" + pp.getName();
                        protocolPropertiesList.put((CallSite)id7, pp.getByteFile());
                        pp.setByteFile(null);
                    }
                }
            }
            Object nomeFile = "accordo.id";
            zipOut.putNextEntry(new ZipEntry(rootDir + (String)nomeFile));
            String identificativo = accordo.getNome() + " " + accordo.getVersione();
            zipOut.write(identificativo.getBytes());
            nomeFile = nomeDefinizione;
            zipOut.putNextEntry(new ZipEntry(rootDir + (String)nomeFile));
            this.cleanerOpenSPCoop2ExtensionsRegistry.clean(accordo);
            zipOut.write(this.jaxbRegistrySerializer.toByteArray(accordo));
            if (wsdlInterfacciaDefinitoria != null) {
                nomeFile = "wsdl" + File.separatorChar + "InterfacciaDefinitoria.xsd";
                zipOut.putNextEntry(new ZipEntry(rootDir + (String)nomeFile));
                zipOut.write(wsdlInterfacciaDefinitoria);
            }
            if (wsdlInterfacciaConcettuale != null) {
                nomeFile = "wsdl" + File.separatorChar + "InterfacciaConcettuale.wsdl";
                zipOut.putNextEntry(new ZipEntry(rootDir + (String)nomeFile));
                zipOut.write(wsdlInterfacciaConcettuale);
            }
            if (wsdlInterfacciaLogicaErogatore != null) {
                nomeFile = "wsdl" + File.separatorChar + "InterfacciaLogicaErogatore.wsdl";
                zipOut.putNextEntry(new ZipEntry(rootDir + (String)nomeFile));
                zipOut.write(wsdlInterfacciaLogicaErogatore);
            }
            if (wsdlInterfacciaLogicaFruitore != null) {
                nomeFile = "wsdl" + File.separatorChar + "InterfacciaLogicaFruitore.wsdl";
                zipOut.putNextEntry(new ZipEntry(rootDir + (String)nomeFile));
                zipOut.write(wsdlInterfacciaLogicaFruitore);
            }
            if (specificaConversazioneConcettuale != null) {
                nomeFile = "specificheConversazioni" + File.separatorChar + "ConversazioneConcettuale.xml";
                zipOut.putNextEntry(new ZipEntry(rootDir + (String)nomeFile));
                zipOut.write(specificaConversazioneConcettuale);
            }
            if (specificaConversazioneLogicaErogatore != null) {
                nomeFile = "specificheConversazioni" + File.separatorChar + "ConversazioneLogicaErogatore.xml";
                zipOut.putNextEntry(new ZipEntry(rootDir + (String)nomeFile));
                zipOut.write(specificaConversazioneLogicaErogatore);
            }
            if (specificaConversazioneLogicaFruitore != null) {
                nomeFile = "specificheConversazioni" + File.separatorChar + "ConversazioneLogicaFruitore.xml";
                zipOut.putNextEntry(new ZipEntry(rootDir + (String)nomeFile));
                zipOut.write(specificaConversazioneLogicaFruitore);
            }
            ArrayList<Character> listCharacterPermit = new ArrayList<Character>();
            listCharacterPermit.add(Character.valueOf('.'));
            if (allegatiList.size() > 0) {
                int index = 1;
                for (Object id7 : allegatiList.keySet()) {
                    nomeFile = "allegati" + File.separatorChar + "attachment_" + index + ".id";
                    zipOut.putNextEntry(new ZipEntry(rootDir + (String)nomeFile));
                    zipOut.write(((String)id7).getBytes());
                    nomeFile = "allegati" + File.separatorChar + "attachment_" + index + ".raw";
                    zipOut.putNextEntry(new ZipEntry(rootDir + (String)nomeFile));
                    zipOut.write((byte[])allegatiList.get(id7));
                    ++index;
                }
            }
            if (specificaSemiformaleList.size() > 0) {
                int index = 1;
                for (Object id7 : specificaSemiformaleList.keySet()) {
                    nomeFile = "specificheSemiformali" + File.separatorChar + "attachment_" + index + ".id";
                    zipOut.putNextEntry(new ZipEntry(rootDir + (String)nomeFile));
                    zipOut.write(((String)id7).getBytes());
                    nomeFile = "specificheSemiformali" + File.separatorChar + "attachment_" + index + ".raw";
                    zipOut.putNextEntry(new ZipEntry(rootDir + (String)nomeFile));
                    zipOut.write((byte[])specificaSemiformaleList.get(id7));
                    ++index;
                }
            }
            if (servizioComposto && specificaCoordinamentoList.size() > 0) {
                int index = 1;
                for (Object id7 : specificaCoordinamentoList.keySet()) {
                    nomeFile = "specificheCoordinamento" + File.separatorChar + "attachment_" + index + ".id";
                    zipOut.putNextEntry(new ZipEntry(rootDir + (String)nomeFile));
                    zipOut.write(((String)id7).getBytes());
                    nomeFile = "specificheCoordinamento" + File.separatorChar + "attachment_" + index + ".raw";
                    zipOut.putNextEntry(new ZipEntry(rootDir + (String)nomeFile));
                    zipOut.write((byte[])specificaCoordinamentoList.get(id7));
                    ++index;
                }
            }
            if (protocolPropertiesList.size() > 0) {
                int indexPP = 1;
                for (Object id7 : protocolPropertiesList.keySet()) {
                    nomeFile = "proprietaProtocollo" + File.separatorChar + "attachment_" + indexPP + ".id";
                    zipOut.putNextEntry(new ZipEntry(rootDir + (String)nomeFile));
                    zipOut.write(((String)id7).getBytes());
                    nomeFile = "proprietaProtocollo" + File.separatorChar + "attachment_" + indexPP + ".raw";
                    zipOut.putNextEntry(new ZipEntry(rootDir + (String)nomeFile));
                    zipOut.write((byte[])protocolPropertiesList.get(id7));
                    ++indexPP;
                }
            }
        }
        catch (Exception e) {
            String xml = null;
            try {
                xml = accordo.toXml();
            }
            catch (Exception eDebug) {
                this.log.error("Errore durante il recupero della struttura xml: " + String.valueOf(eDebug), (Throwable)eDebug);
                throw new ProtocolException("[" + nomeAccordo + "][" + String.valueOf(idAccordo) + "]: " + e.getMessage(), e);
            }
            throw new ProtocolException("[" + nomeAccordo + "][" + String.valueOf(idAccordo) + "] (" + xml + "): " + e.getMessage(), e);
        }
    }

    private void saveAccordo(AccordoServizioParteSpecifica accordo, IDServizio idServizio, List<MappingErogazionePortaApplicativa> mappingPorteApplicativeAssociate, String parentDir, ZipOutputStream zipOut, Map<String, String> map_IdApsScritti_nomeFileSystem) throws IOException, SerializerException, ProtocolException {
        try {
            int index;
            String aspsDir = "accordiServizioParteSpecifica" + File.separatorChar + ZIPUtils.convertNameToSistemaOperativoCompatible(idServizio.getTipo()) + "_" + ZIPUtils.convertNameToSistemaOperativoCompatible(idServizio.getNome()) + "_" + idServizio.getVersione() + File.separatorChar;
            String rootDir = parentDir + aspsDir;
            String keyMap = accordo.getNome() + " " + accordo.getVersione();
            map_IdApsScritti_nomeFileSystem.put(keyMap, aspsDir);
            byte[] wsdlInterfacciaImplementativaErogatore = accordo.getByteWsdlImplementativoErogatore();
            accordo.setByteWsdlImplementativoErogatore(null);
            byte[] wsdlInterfacciaImplementativaFruitore = accordo.getByteWsdlImplementativoFruitore();
            accordo.setByteWsdlImplementativoFruitore(null);
            HashMap<CallSite, byte[]> allegatiList = new HashMap<CallSite, byte[]>();
            for (Object documento : accordo.getAllegatoList()) {
                if (documento.getFile() == null) {
                    throw new ProtocolException("Allegato senza nome file");
                }
                if (documento.getByteContenuto() == null) {
                    throw new ProtocolException("Allegato[" + documento.getFile() + "] senza contenuto");
                }
                if (documento.getTipo() == null) {
                    throw new ProtocolException("Allegato[" + documento.getFile() + "] senza tipo");
                }
                String id = documento.getTipo() + "###" + documento.getFile();
                allegatiList.put((CallSite)((Object)id), documento.getByteContenuto());
                documento.setByteContenuto(null);
            }
            HashMap<CallSite, byte[]> specificaSemiformaleList = new HashMap<CallSite, byte[]>();
            for (Object documento : accordo.getSpecificaSemiformaleList()) {
                if (documento.getFile() == null) {
                    throw new ProtocolException("SpecificaSemiformale senza nome file");
                }
                if (documento.getByteContenuto() == null) {
                    throw new ProtocolException("SpecificaSemiformale[" + documento.getFile() + "] senza contenuto");
                }
                if (documento.getTipo() == null) {
                    throw new ProtocolException("SpecificaSemiformale[" + documento.getFile() + "] senza tipo");
                }
                String id = documento.getTipo() + "###" + documento.getFile();
                specificaSemiformaleList.put((CallSite)((Object)id), documento.getByteContenuto());
                documento.setByteContenuto(null);
            }
            HashMap<CallSite, byte[]> specificaLivelloServizioList = new HashMap<CallSite, byte[]>();
            for (Object documento : accordo.getSpecificaLivelloServizioList()) {
                if (documento.getFile() == null) {
                    throw new ProtocolException("SpecificaLivelloServizio senza nome file");
                }
                if (documento.getByteContenuto() == null) {
                    throw new ProtocolException("SpecificaLivelloServizio[" + documento.getFile() + "] senza contenuto");
                }
                if (documento.getTipo() == null) {
                    throw new ProtocolException("SpecificaLivelloServizio[" + documento.getFile() + "] senza tipo");
                }
                String id = documento.getTipo() + "###" + documento.getFile();
                specificaLivelloServizioList.put((CallSite)((Object)id), documento.getByteContenuto());
                documento.setByteContenuto(null);
            }
            HashMap<CallSite, byte[]> specificaSicurezzaList = new HashMap<CallSite, byte[]>();
            for (Object documento : accordo.getSpecificaSicurezzaList()) {
                if (documento.getFile() == null) {
                    throw new ProtocolException("SpecificaSicurezza senza nome file");
                }
                if (documento.getByteContenuto() == null) {
                    throw new ProtocolException("SpecificaSicurezza[" + documento.getFile() + "] senza contenuto");
                }
                if (documento.getTipo() == null) {
                    throw new ProtocolException("SpecificaSicurezza[" + documento.getFile() + "] senza tipo");
                }
                String id = documento.getTipo() + "###" + documento.getFile();
                specificaSicurezzaList.put((CallSite)((Object)id), documento.getByteContenuto());
                documento.setByteContenuto(null);
            }
            HashMap<CallSite, byte[]> protocolPropertiesList = new HashMap<CallSite, byte[]>();
            for (ProtocolProperty pp : accordo.getProtocolPropertyList()) {
                if (pp.getByteFile() == null) continue;
                if (pp.getFile() == null) {
                    throw new ProtocolException("ProtocolProperties [" + pp.getName() + "] senza nome file");
                }
                ProprietariProtocolProperty tipologiaProprietarioProtocolProperty = ProprietariProtocolProperty.ACCORDO_SERVIZIO_PARTE_SPECIFICA;
                String id = tipologiaProprietarioProtocolProperty.name() + "###" + pp.getName();
                protocolPropertiesList.put((CallSite)((Object)id), pp.getByteFile());
                pp.setByteFile(null);
            }
            ArrayList<Fruitore> listFruitore = new ArrayList<Fruitore>();
            while (accordo.sizeFruitoreList() > 0) {
                listFruitore.add(accordo.removeFruitore(0));
            }
            Object nomeFile = "accordo.id";
            zipOut.putNextEntry(new ZipEntry(rootDir + (String)nomeFile));
            String identificativo = accordo.getTipo() + " " + accordo.getNome() + " " + accordo.getVersione();
            zipOut.write(identificativo.getBytes());
            nomeFile = "accordo.xml";
            zipOut.putNextEntry(new ZipEntry(rootDir + (String)nomeFile));
            this.cleanerOpenSPCoop2ExtensionsRegistry.clean(accordo);
            zipOut.write(this.jaxbRegistrySerializer.toByteArray(accordo));
            if (wsdlInterfacciaImplementativaErogatore != null) {
                nomeFile = "wsdl" + File.separatorChar + "InterfacciaImplementativaErogatore.wsdl";
                zipOut.putNextEntry(new ZipEntry(rootDir + (String)nomeFile));
                zipOut.write(wsdlInterfacciaImplementativaErogatore);
            }
            if (wsdlInterfacciaImplementativaFruitore != null) {
                nomeFile = "wsdl" + File.separatorChar + "InterfacciaImplementativaFruitore.wsdl";
                zipOut.putNextEntry(new ZipEntry(rootDir + (String)nomeFile));
                zipOut.write(wsdlInterfacciaImplementativaFruitore);
            }
            ArrayList<Character> listCharacterPermit = new ArrayList<Character>();
            listCharacterPermit.add(Character.valueOf('.'));
            if (allegatiList.size() > 0) {
                index = 1;
                for (String id : allegatiList.keySet()) {
                    nomeFile = "allegati" + File.separatorChar + "attachment_" + index + ".id";
                    zipOut.putNextEntry(new ZipEntry(rootDir + (String)nomeFile));
                    zipOut.write(id.getBytes());
                    nomeFile = "allegati" + File.separatorChar + "attachment_" + index + ".raw";
                    zipOut.putNextEntry(new ZipEntry(rootDir + (String)nomeFile));
                    zipOut.write((byte[])allegatiList.get(id));
                    ++index;
                }
            }
            if (specificaSemiformaleList.size() > 0) {
                index = 1;
                for (String id : specificaSemiformaleList.keySet()) {
                    nomeFile = "specificheSemiformali" + File.separatorChar + "attachment_" + index + ".id";
                    zipOut.putNextEntry(new ZipEntry(rootDir + (String)nomeFile));
                    zipOut.write(id.getBytes());
                    nomeFile = "specificheSemiformali" + File.separatorChar + "attachment_" + index + ".raw";
                    zipOut.putNextEntry(new ZipEntry(rootDir + (String)nomeFile));
                    zipOut.write((byte[])specificaSemiformaleList.get(id));
                    ++index;
                }
            }
            if (specificaLivelloServizioList.size() > 0) {
                index = 1;
                for (String id : specificaLivelloServizioList.keySet()) {
                    nomeFile = "specificheLivelliServizio" + File.separatorChar + "attachment_" + index + ".id";
                    zipOut.putNextEntry(new ZipEntry(rootDir + (String)nomeFile));
                    zipOut.write(id.getBytes());
                    nomeFile = "specificheLivelliServizio" + File.separatorChar + "attachment_" + index + ".raw";
                    zipOut.putNextEntry(new ZipEntry(rootDir + (String)nomeFile));
                    zipOut.write((byte[])specificaLivelloServizioList.get(id));
                    ++index;
                }
            }
            if (specificaSicurezzaList.size() > 0) {
                index = 1;
                for (String id : specificaSicurezzaList.keySet()) {
                    nomeFile = "specificheSicurezza" + File.separatorChar + "attachment_" + index + ".id";
                    zipOut.putNextEntry(new ZipEntry(rootDir + (String)nomeFile));
                    zipOut.write(id.getBytes());
                    nomeFile = "specificheSicurezza" + File.separatorChar + "attachment_" + index + ".raw";
                    zipOut.putNextEntry(new ZipEntry(rootDir + (String)nomeFile));
                    zipOut.write((byte[])specificaSicurezzaList.get(id));
                    ++index;
                }
            }
            if (protocolPropertiesList.size() > 0) {
                int indexPP = 1;
                for (String id : protocolPropertiesList.keySet()) {
                    nomeFile = "proprietaProtocollo" + File.separatorChar + "attachment_" + indexPP + ".id";
                    zipOut.putNextEntry(new ZipEntry(rootDir + (String)nomeFile));
                    zipOut.write(id.getBytes());
                    nomeFile = "proprietaProtocollo" + File.separatorChar + "attachment_" + indexPP + ".raw";
                    zipOut.putNextEntry(new ZipEntry(rootDir + (String)nomeFile));
                    zipOut.write((byte[])protocolPropertiesList.get(id));
                    ++indexPP;
                }
            }
            if (listFruitore.size() > 0) {
                for (Fruitore fruitore : listFruitore) {
                    nomeFile = "fruitori" + File.separatorChar + ZIPUtils.convertNameToSistemaOperativoCompatible(fruitore.getTipo()) + "_" + ZIPUtils.convertNameToSistemaOperativoCompatible(fruitore.getNome()) + ".xml";
                    zipOut.putNextEntry(new ZipEntry(rootDir + (String)nomeFile));
                    this.cleanerOpenSPCoop2ExtensionsRegistry.clean(fruitore);
                    zipOut.write(this.jaxbRegistrySerializer.toByteArray(fruitore));
                }
            }
            if (mappingPorteApplicativeAssociate != null) {
                for (int i = 0; i < mappingPorteApplicativeAssociate.size(); ++i) {
                    String nomeFilePAAssociata = "mapping" + File.separatorChar + (i + 1) + "_mappingErogazionePA.id";
                    zipOut.putNextEntry(new ZipEntry(rootDir + nomeFilePAAssociata));
                    MappingErogazionePortaApplicativa mappingPortaApplicativaAssociata = mappingPorteApplicativeAssociate.get(i);
                    String id = mappingPortaApplicativaAssociata.getNome() + " " + mappingPortaApplicativaAssociata.getIdPortaApplicativa().getNome() + " " + mappingPortaApplicativaAssociata.isDefault() + " " + mappingPortaApplicativaAssociata.getDescrizione();
                    zipOut.write(id.getBytes());
                }
            }
        }
        catch (Exception e) {
            String xml = null;
            try {
                xml = accordo.toXml();
            }
            catch (Exception eDebug) {
                this.log.error("Errore durante il recupero della struttura xml: " + String.valueOf(eDebug), (Throwable)eDebug);
                throw new ProtocolException("[AccordoServizioParteSpecifica][" + String.valueOf(idServizio) + "]: " + e.getMessage(), e);
            }
            throw new ProtocolException("[AccordoServizioParteSpecifica][" + String.valueOf(idServizio) + "] (" + xml + "): " + e.getMessage(), e);
        }
    }

    private void saveAccordo(AccordoCooperazione accordo, IDAccordoCooperazione idAccordo, String parentDir, ZipOutputStream zipOut) throws IOException, SerializerException, ProtocolException {
        try {
            String rootDir = parentDir + "accordiCooperazione" + File.separatorChar + ZIPUtils.convertNameToSistemaOperativoCompatible(idAccordo.getNome()) + "_" + idAccordo.getVersione() + File.separatorChar;
            HashMap<CallSite, byte[]> allegatiList = new HashMap<CallSite, byte[]>();
            for (Object documento : accordo.getAllegatoList()) {
                if (documento.getFile() == null) {
                    throw new ProtocolException("Allegato senza nome file");
                }
                if (documento.getByteContenuto() == null) {
                    throw new ProtocolException("Allegato[" + documento.getFile() + "] senza contenuto");
                }
                if (documento.getTipo() == null) {
                    throw new ProtocolException("Allegato[" + documento.getFile() + "] senza tipo");
                }
                String id = documento.getTipo() + "###" + documento.getFile();
                allegatiList.put((CallSite)((Object)id), documento.getByteContenuto());
                documento.setByteContenuto(null);
            }
            HashMap<CallSite, byte[]> specificaSemiformaleList = new HashMap<CallSite, byte[]>();
            for (Object documento : accordo.getSpecificaSemiformaleList()) {
                if (documento.getFile() == null) {
                    throw new ProtocolException("SpecificaSemiformale senza nome file");
                }
                if (documento.getByteContenuto() == null) {
                    throw new ProtocolException("SpecificaSemiformale[" + documento.getFile() + "] senza contenuto");
                }
                if (documento.getTipo() == null) {
                    throw new ProtocolException("SpecificaSemiformale[" + documento.getFile() + "] senza tipo");
                }
                String id = documento.getTipo() + "###" + documento.getFile();
                specificaSemiformaleList.put((CallSite)((Object)id), documento.getByteContenuto());
                documento.setByteContenuto(null);
            }
            HashMap<CallSite, byte[]> protocolPropertiesList = new HashMap<CallSite, byte[]>();
            for (ProtocolProperty pp : accordo.getProtocolPropertyList()) {
                if (pp.getByteFile() == null) continue;
                if (pp.getFile() == null) {
                    throw new ProtocolException("ProtocolProperties [" + pp.getName() + "] senza nome file");
                }
                ProprietariProtocolProperty tipologiaProprietarioProtocolProperty = ProprietariProtocolProperty.ACCORDO_COOPERAZIONE;
                String id = tipologiaProprietarioProtocolProperty.name() + "###" + pp.getName();
                protocolPropertiesList.put((CallSite)((Object)id), pp.getByteFile());
                pp.setByteFile(null);
            }
            Object nomeFile = "accordo.id";
            zipOut.putNextEntry(new ZipEntry(rootDir + (String)nomeFile));
            String identificativo = accordo.getNome() + " " + accordo.getVersione();
            zipOut.write(identificativo.getBytes());
            nomeFile = "accordo.xml";
            zipOut.putNextEntry(new ZipEntry(rootDir + (String)nomeFile));
            this.cleanerOpenSPCoop2ExtensionsRegistry.clean(accordo);
            zipOut.write(this.jaxbRegistrySerializer.toByteArray(accordo));
            ArrayList<Character> listCharacterPermit = new ArrayList<Character>();
            listCharacterPermit.add(Character.valueOf('.'));
            if (allegatiList.size() > 0) {
                int index = 1;
                for (String id : allegatiList.keySet()) {
                    nomeFile = "allegati" + File.separatorChar + "attachment_" + index + ".id";
                    zipOut.putNextEntry(new ZipEntry(rootDir + (String)nomeFile));
                    zipOut.write(id.getBytes());
                    nomeFile = "allegati" + File.separatorChar + "attachment_" + index + ".raw";
                    zipOut.putNextEntry(new ZipEntry(rootDir + (String)nomeFile));
                    zipOut.write((byte[])allegatiList.get(id));
                    ++index;
                }
            }
            if (specificaSemiformaleList.size() > 0) {
                int index = 1;
                for (String id : specificaSemiformaleList.keySet()) {
                    nomeFile = "specificheSemiformali" + File.separatorChar + "attachment_" + index + ".id";
                    zipOut.putNextEntry(new ZipEntry(rootDir + (String)nomeFile));
                    zipOut.write(id.getBytes());
                    nomeFile = "specificheSemiformali" + File.separatorChar + "attachment_" + index + ".raw";
                    zipOut.putNextEntry(new ZipEntry(rootDir + (String)nomeFile));
                    zipOut.write((byte[])specificaSemiformaleList.get(id));
                    ++index;
                }
            }
            if (protocolPropertiesList.size() > 0) {
                int indexPP = 1;
                for (String id : protocolPropertiesList.keySet()) {
                    nomeFile = "proprietaProtocollo" + File.separatorChar + "attachment_" + indexPP + ".id";
                    zipOut.putNextEntry(new ZipEntry(rootDir + (String)nomeFile));
                    zipOut.write(id.getBytes());
                    nomeFile = "proprietaProtocollo" + File.separatorChar + "attachment_" + indexPP + ".raw";
                    zipOut.putNextEntry(new ZipEntry(rootDir + (String)nomeFile));
                    zipOut.write((byte[])protocolPropertiesList.get(id));
                    ++indexPP;
                }
            }
        }
        catch (Exception e) {
            String xml = null;
            try {
                xml = accordo.toXml();
            }
            catch (Exception eDebug) {
                this.log.error("Errore durante il recupero della struttura xml: " + String.valueOf(eDebug), (Throwable)eDebug);
                throw new ProtocolException("[AccordoCooperazione][" + String.valueOf(idAccordo) + "]: " + e.getMessage(), e);
            }
            throw new ProtocolException("[AccordoCooperazione][" + String.valueOf(idAccordo) + "] (" + xml + "): " + e.getMessage(), e);
        }
    }
}

