/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.basic.config;

import java.util.HashMap;
import java.util.Map;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.Connettore;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.protocol.basic.BasicComponentFactory;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.config.IProtocolManager;
import org.openspcoop2.protocol.sdk.constants.FaultIntegrationGenericInfoMode;
import org.openspcoop2.protocol.sdk.constants.TipoIntegrazione;
import org.openspcoop2.protocol.sdk.registry.IRegistryReader;
import org.openspcoop2.utils.BooleanNullable;
import org.openspcoop2.utils.io.notifier.NotifierInputStreamParams;
import org.openspcoop2.utils.transport.TransportRequestContext;
import org.openspcoop2.utils.transport.TransportResponseContext;

public abstract class BasicManager
extends BasicComponentFactory
implements IProtocolManager {
    public BasicManager(IProtocolFactory<?> protocolFactory) throws ProtocolException {
        super(protocolFactory);
    }

    @Override
    public boolean isBustaServizio(Busta busta) {
        return false;
    }

    @Override
    public String getKeywordTipoMittenteSconosciuto() {
        return "Sconosciuto";
    }

    @Override
    public String getKeywordMittenteSconosciuto() {
        return "Sconosciuto";
    }

    @Override
    public long getIntervalloScadenzaBuste() {
        return 7200L;
    }

    @Override
    public boolean isGenerazioneElementiNonValidabiliRispettoXSD() {
        return false;
    }

    @Override
    public boolean isIgnoraEccezioniNonGravi() {
        return false;
    }

    @Override
    public boolean isGenerazioneListaEccezioniErroreProcessamento() {
        return false;
    }

    @Override
    public boolean isGenerazioneDetailsFaultProtocollo_EccezioneValidazione() {
        return false;
    }

    @Override
    public boolean isGenerazioneDetailsFaultProtocollo_EccezioneProcessamento() {
        return true;
    }

    @Override
    public boolean isGenerazioneDetailsFaultProtocolloConStackTrace() {
        return false;
    }

    @Override
    public boolean isGenerazioneDetailsFaultProtocolloConInformazioniGeneriche() {
        return true;
    }

    @Override
    public boolean isGenerazioneDetailsFaultIntegratione_erroreServer() {
        return true;
    }

    @Override
    public boolean isGenerazioneDetailsFaultIntegratione_erroreClient() {
        return false;
    }

    @Override
    public boolean isGenerazioneDetailsFaultIntegrationeConStackTrace() {
        return false;
    }

    @Override
    public FaultIntegrationGenericInfoMode getModalitaGenerazioneInformazioniGeneriche_DetailsFaultIntegrazione() {
        return FaultIntegrationGenericInfoMode.SERVIZIO_APPLICATIVO;
    }

    @Override
    public BooleanNullable isAggiungiDetailErroreApplicativo_FaultApplicativo() {
        return BooleanNullable.NULL();
    }

    @Override
    public BooleanNullable isAggiungiDetailErroreApplicativo_FaultPdD() {
        return BooleanNullable.NULL();
    }

    @Override
    public Map<String, String> buildIntegrationProperties(Busta busta, boolean isRichiesta, TipoIntegrazione tipoIntegrazione) throws ProtocolException {
        if (busta != null && busta.sizeProperties() > 0) {
            HashMap<String, String> map = new HashMap<String, String>();
            String[] names = busta.getPropertiesNames();
            for (int i = 0; i < names.length; ++i) {
                String nomeProprieta = names[i];
                String valoreProprieta = busta.getProperty(nomeProprieta);
                if (TipoIntegrazione.TRASPORTO.equals((Object)tipoIntegrazione)) {
                    map.put(busta.getProtocollo().toUpperCase() + "-" + nomeProprieta, valoreProprieta);
                    continue;
                }
                if (TipoIntegrazione.URL.equals((Object)tipoIntegrazione)) {
                    map.put(busta.getProtocollo().toUpperCase() + nomeProprieta, valoreProprieta);
                    continue;
                }
                map.put(nomeProprieta, valoreProprieta);
            }
            return map;
        }
        return null;
    }

    @Override
    public OpenSPCoop2Message updateOpenSPCoop2MessageRequest(OpenSPCoop2Message msg, Busta busta, IRegistryReader registryReader) throws ProtocolException {
        return msg;
    }

    @Override
    public OpenSPCoop2Message updateOpenSPCoop2MessageResponse(OpenSPCoop2Message msg, Busta busta, NotifierInputStreamParams notifierInputStreamParams, TransportRequestContext transportRequestContext, TransportResponseContext transportResponseContext, IRegistryReader registryReader, boolean integration) throws ProtocolException {
        return msg;
    }

    @Override
    public boolean isStaticRoute() throws ProtocolException {
        return false;
    }

    @Override
    public Connettore getStaticRoute(IDSoggetto idSoggettoMittente, IDServizio idServizio, IRegistryReader registryReader) throws ProtocolException {
        return null;
    }

    @Override
    public boolean isSuccessfulHttpRedirectStatusCode(ServiceBinding serviceBinding) throws ProtocolException {
        return ServiceBinding.REST.equals((Object)serviceBinding);
    }

    @Override
    public boolean isHttpEmptyResponseOneWay() {
        return true;
    }

    @Override
    public Integer getHttpReturnCodeEmptyResponseOneWay() {
        return 200;
    }

    @Override
    public boolean isHttpOneWay_PD_HTTPEmptyResponse() {
        return true;
    }

    @Override
    public boolean isBlockedTransaction_responseMessageWithTransportCodeError() {
        return false;
    }
}

