/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.basic.config;

import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.PortType;
import org.openspcoop2.core.registry.Resource;
import org.openspcoop2.core.registry.ResourceRepresentation;
import org.openspcoop2.core.registry.ResourceResponse;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.message.config.ConfigurationRFC7807;
import org.openspcoop2.message.config.ConfigurationServiceBindingRest;
import org.openspcoop2.message.config.ConfigurationServiceBindingSoap;
import org.openspcoop2.message.config.ContextUrlCollection;
import org.openspcoop2.message.config.IntegrationErrorReturnConfiguration;
import org.openspcoop2.message.config.RestBinding;
import org.openspcoop2.message.config.ServiceBindingConfiguration;
import org.openspcoop2.message.config.SoapBinding;
import org.openspcoop2.message.constants.IntegrationError;
import org.openspcoop2.message.constants.IntegrationErrorMessageType;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.message.exception.MessageException;
import org.openspcoop2.protocol.manifest.Context;
import org.openspcoop2.protocol.manifest.EmptySubContextMapping;
import org.openspcoop2.protocol.manifest.IntegrationErrorCode;
import org.openspcoop2.protocol.manifest.IntegrationErrorCollection;
import org.openspcoop2.protocol.manifest.Openspcoop2;
import org.openspcoop2.protocol.manifest.RFC7807;
import org.openspcoop2.protocol.manifest.RestConfiguration;
import org.openspcoop2.protocol.manifest.RestMediaTypeCollection;
import org.openspcoop2.protocol.manifest.RestMediaTypeDefaultMapping;
import org.openspcoop2.protocol.manifest.RestMediaTypeMapping;
import org.openspcoop2.protocol.manifest.RestMediaTypeUndefinedMapping;
import org.openspcoop2.protocol.manifest.SoapConfiguration;
import org.openspcoop2.protocol.manifest.SoapMediaTypeCollection;
import org.openspcoop2.protocol.manifest.SoapMediaTypeDefaultMapping;
import org.openspcoop2.protocol.manifest.SoapMediaTypeMapping;
import org.openspcoop2.protocol.manifest.SoapMediaTypeUndefinedMapping;
import org.openspcoop2.protocol.manifest.SubContextMapping;
import org.openspcoop2.protocol.manifest.constants.DefaultIntegrationErrorMessageType;
import org.openspcoop2.protocol.manifest.constants.IntegrationErrorMessageDetailType;
import org.openspcoop2.protocol.manifest.constants.IntegrationErrorProblemType;
import org.openspcoop2.protocol.manifest.constants.RestMessageType;
import org.openspcoop2.protocol.manifest.constants.SoapMessageType;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.registry.IRegistryReader;
import org.openspcoop2.protocol.sdk.registry.RegistryNotFound;
import org.openspcoop2.utils.transport.TransportRequestContext;

public class ServiceBindingConfigurationReader {
    public static ServiceBinding getServiceBinding(IDServizio idServizio, IRegistryReader registryReader) throws ProtocolException, RegistryNotFound {
        try {
            AccordoServizioParteSpecifica aps = registryReader.getAccordoServizioParteSpecifica(idServizio);
            IDAccordo idAccordoParteComune = IDAccordoFactory.getInstance().getIDAccordoFromUri(aps.getAccordoServizioParteComune());
            AccordoServizioParteComune apc = registryReader.getAccordoServizioParteComune(idAccordoParteComune);
            switch (apc.getServiceBinding()) {
                case SOAP: {
                    return ServiceBinding.SOAP;
                }
                case REST: {
                    return ServiceBinding.REST;
                }
            }
            throw new ProtocolException("Service [" + String.valueOf(idServizio) + "] not found");
        }
        catch (RegistryNotFound notFound) {
            throw notFound;
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
    }

    public static ServiceBindingConfiguration getDefaultServiceBindingConfiguration(Openspcoop2 manifest, TransportRequestContext transportRequest) throws ProtocolException {
        return ServiceBindingConfigurationReader.getServiceBindingConfiguration(manifest, transportRequest, null, null, null);
    }

    private static MessageType convertMessageType(org.openspcoop2.core.registry.constants.MessageType mt) {
        if (mt != null) {
            switch (mt) {
                case SOAP_11: {
                    return MessageType.SOAP_11;
                }
                case SOAP_12: {
                    return MessageType.SOAP_12;
                }
                case XML: {
                    return MessageType.XML;
                }
                case JSON: {
                    return MessageType.JSON;
                }
                case BINARY: {
                    return MessageType.BINARY;
                }
                case MIME_MULTIPART: {
                    return MessageType.MIME_MULTIPART;
                }
            }
        }
        return null;
    }

    public static ServiceBindingConfiguration getServiceBindingConfiguration(Openspcoop2 manifest, TransportRequestContext transportRequest, ServiceBinding serviceBinding, IDServizio idServizio, IRegistryReader registryReader) throws ProtocolException {
        try {
            int i;
            String protocolWebContext = null;
            if (transportRequest != null && transportRequest.getProtocolWebContext() != null && !"".equals(transportRequest.getProtocolWebContext())) {
                protocolWebContext = transportRequest.getProtocolWebContext();
            }
            ServiceBinding defaultBinding = ServiceBindingConfigurationReader.getServiceBindingDefault(manifest, protocolWebContext);
            ConfigurationServiceBindingSoap soap = ServiceBindingConfigurationReader.readConfigurationServiceBindingSoap(manifest);
            ConfigurationServiceBindingRest rest = ServiceBindingConfigurationReader.readConfigurationServiceBindingRest(manifest);
            ContextUrlCollection contextUrlCollection = ServiceBindingConfigurationReader.readContextUrlCollection(manifest, soap, rest);
            String context = null;
            if (transportRequest != null) {
                context = transportRequest.getProtocolWebContext();
            }
            if (context != null && !"@EMPTY@".equals(context)) {
                for (i = 0; i < manifest.getWeb().sizeContextList(); ++i) {
                    if (!manifest.getWeb().getContext(i).getName().equals(context)) continue;
                    if (manifest.getWeb().getContext(i).getSoapMediaTypeCollection() != null) {
                        ServiceBindingConfigurationReader.updateMediaTypeCollection(soap, manifest.getWeb().getContext(i).getSoapMediaTypeCollection(), true, true);
                    }
                    if (manifest.getWeb().getContext(i).getRestMediaTypeCollection() == null) continue;
                    ServiceBindingConfigurationReader.updateMediaTypeCollection(rest, manifest.getWeb().getContext(i).getRestMediaTypeCollection(), true, true);
                }
            } else if (manifest.getWeb().getEmptyContext() != null) {
                if (manifest.getWeb().getEmptyContext().getSoapMediaTypeCollection() != null) {
                    ServiceBindingConfigurationReader.updateMediaTypeCollection(soap, manifest.getWeb().getEmptyContext().getSoapMediaTypeCollection(), true, true);
                }
                if (manifest.getWeb().getEmptyContext().getRestMediaTypeCollection() != null) {
                    ServiceBindingConfigurationReader.updateMediaTypeCollection(rest, manifest.getWeb().getEmptyContext().getRestMediaTypeCollection(), true, true);
                }
            }
            if (serviceBinding != null && idServizio != null) {
                MessageType messageTypeParteSpecifica;
                Object messageTypeService;
                for (i = 0; i < manifest.getRegistry().getService().getTypes().sizeTypeList(); ++i) {
                    String serviceType = manifest.getRegistry().getService().getTypes().getType(i).getName();
                    if (!serviceType.equals(idServizio.getTipo())) continue;
                    if (manifest.getRegistry().getService().getTypes().getType(i).getSoapMediaTypeCollection() != null) {
                        ServiceBindingConfigurationReader.updateMediaTypeCollection(soap, manifest.getRegistry().getService().getTypes().getType(i).getSoapMediaTypeCollection(), true, true);
                    }
                    if (manifest.getRegistry().getService().getTypes().getType(i).getRestMediaTypeCollection() == null) continue;
                    ServiceBindingConfigurationReader.updateMediaTypeCollection(rest, manifest.getRegistry().getService().getTypes().getType(i).getRestMediaTypeCollection(), true, true);
                }
                AccordoServizioParteComune aspc = null;
                AccordoServizioParteSpecifica asps = null;
                try {
                    asps = registryReader.getAccordoServizioParteSpecifica(idServizio, false);
                }
                catch (RegistryNotFound registryNotFound) {
                    // empty catch block
                }
                if (asps != null) {
                    try {
                        IDAccordo idAccordo = IDAccordoFactory.getInstance().getIDAccordoFromUri(asps.getAccordoServizioParteComune());
                        aspc = registryReader.getAccordoServizioParteComune(idAccordo, false, false);
                    }
                    catch (RegistryNotFound idAccordo) {
                        // empty catch block
                    }
                }
                if (aspc != null && (messageTypeService = ServiceBindingConfigurationReader.convertMessageType(aspc.getMessageType())) != null) {
                    if (ServiceBinding.SOAP.equals((Object)serviceBinding)) {
                        ServiceBindingConfigurationReader.updateSoapMediaTypeCollection(soap, (MessageType)messageTypeService, true, true);
                    } else if (ServiceBinding.REST.equals((Object)serviceBinding)) {
                        ServiceBindingConfigurationReader.updateRestMediaTypeCollection(rest, (MessageType)messageTypeService, true, true);
                    }
                }
                if (ServiceBinding.SOAP.equals((Object)serviceBinding) && aspc != null && asps != null && asps.getPortType() != null) {
                    for (PortType pt : aspc.getPortTypeList()) {
                        if (!pt.getNome().equals(asps.getPortType())) continue;
                        MessageType messageTypeService2 = ServiceBindingConfigurationReader.convertMessageType(pt.getMessageType());
                        if (messageTypeService2 == null || !ServiceBinding.SOAP.equals((Object)serviceBinding)) break;
                        ServiceBindingConfigurationReader.updateSoapMediaTypeCollection(soap, messageTypeService2, true, true);
                        break;
                    }
                }
                if (asps != null && (messageTypeParteSpecifica = ServiceBindingConfigurationReader.convertMessageType(asps.getMessageType())) != null) {
                    if (ServiceBinding.SOAP.equals((Object)serviceBinding)) {
                        ServiceBindingConfigurationReader.updateSoapMediaTypeCollection(soap, messageTypeParteSpecifica, true, true);
                    } else if (ServiceBinding.REST.equals((Object)serviceBinding)) {
                        ServiceBindingConfigurationReader.updateRestMediaTypeCollection(rest, messageTypeParteSpecifica, true, true);
                    }
                }
                if (idServizio.getAzione() != null && aspc != null && ServiceBinding.REST.equals((Object)serviceBinding) && aspc.sizeResourceList() > 0) {
                    for (Resource resource : aspc.getResourceList()) {
                        MessageType messageTypeAzioneRisposta;
                        MessageType messageTypeAzioneRichiesta;
                        if (!resource.getNome().equals(idServizio.getAzione())) continue;
                        MessageType messageTypeRisorsa = ServiceBindingConfigurationReader.convertMessageType(resource.getMessageType());
                        if (messageTypeRisorsa != null) {
                            ServiceBindingConfigurationReader.updateRestMediaTypeCollection(rest, messageTypeRisorsa, true, true);
                        }
                        if ((messageTypeAzioneRichiesta = ServiceBindingConfigurationReader.convertMessageType(resource.getRequestMessageType())) != null) {
                            ServiceBindingConfigurationReader.updateRestMediaTypeCollection(rest, messageTypeAzioneRichiesta, true, false);
                        }
                        if ((messageTypeAzioneRisposta = ServiceBindingConfigurationReader.convertMessageType(resource.getResponseMessageType())) != null) {
                            ServiceBindingConfigurationReader.updateRestMediaTypeCollection(rest, messageTypeAzioneRisposta, false, true);
                        }
                        if (resource.getRequest() != null && resource.getRequest().sizeRepresentationList() > 0) {
                            for (ResourceRepresentation rr : resource.getRequest().getRepresentationList()) {
                                MessageType messageTypeMediaType = ServiceBindingConfigurationReader.convertMessageType(rr.getMessageType());
                                if (messageTypeMediaType == null) continue;
                                rest.getRequest().addOrReplaceMediaType(rr.getMediaType(), messageTypeMediaType, false);
                            }
                        }
                        if (resource.sizeResponseList() <= 0) break;
                        for (ResourceResponse response : resource.getResponseList()) {
                            if (response.sizeRepresentationList() <= 0) continue;
                            for (ResourceRepresentation rr : response.getRepresentationList()) {
                                MessageType messageTypeMediaType = ServiceBindingConfigurationReader.convertMessageType(rr.getMessageType());
                                if (messageTypeMediaType == null) continue;
                                rest.getResponse().addOrReplaceMediaType(rr.getMediaType(), Integer.valueOf(response.getStatus()), messageTypeMediaType, false);
                            }
                        }
                    }
                }
            }
            ServiceBindingConfiguration config = new ServiceBindingConfiguration(defaultBinding, soap, rest, contextUrlCollection);
            ServiceBindingConfigurationReader.addServiceBindingRestriction(manifest, config);
            return config;
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
    }

    private static ServiceBinding getServiceBindingDefault(Openspcoop2 manifest, String protocolWebContext) {
        ServiceBinding defaultBinding = null;
        org.openspcoop2.protocol.manifest.constants.ServiceBinding defaultBindingManifest = manifest.getBinding().getDefault();
        if (defaultBindingManifest != null) {
            switch (defaultBindingManifest) {
                case SOAP: {
                    defaultBinding = ServiceBinding.SOAP;
                    break;
                }
                case REST: {
                    defaultBinding = ServiceBinding.REST;
                }
            }
        } else {
            defaultBinding = manifest.getBinding().getSoap() != null ? ServiceBinding.SOAP : ServiceBinding.REST;
        }
        if (protocolWebContext != null && manifest.getWeb() != null && manifest.getWeb().sizeContextList() > 0) {
            for (Context webContext : manifest.getWeb().getContextList()) {
                if (webContext.getName() == null || !webContext.getName().equals(protocolWebContext)) continue;
                if (webContext.getBinding() == null) break;
                switch (webContext.getBinding()) {
                    case SOAP: {
                        defaultBinding = ServiceBinding.SOAP;
                        break;
                    }
                    case REST: {
                        defaultBinding = ServiceBinding.REST;
                    }
                }
                break;
            }
        }
        return defaultBinding;
    }

    private static ConfigurationServiceBindingSoap readConfigurationServiceBindingSoap(Openspcoop2 manifest) throws MessageException {
        SoapConfiguration soapConfig = manifest.getBinding().getSoap();
        boolean enabled = soapConfig != null;
        SoapBinding binding = null;
        org.openspcoop2.message.config.IntegrationErrorCollection internalIntegrationErrorConfiguration = null;
        org.openspcoop2.message.config.IntegrationErrorCollection externalIntegrationErrorConfiguration = null;
        if (enabled) {
            binding = new SoapBinding(soapConfig.isSoap11(), soapConfig.isSoap11WithAttachments(), soapConfig.isSoap11Mtom(), soapConfig.isSoap12(), soapConfig.isSoap12WithAttachments(), soapConfig.isSoap12Mtom());
            internalIntegrationErrorConfiguration = ServiceBindingConfigurationReader.readIntegrationErrorConfiguration(soapConfig.getIntegrationError().getInternal());
            externalIntegrationErrorConfiguration = ServiceBindingConfigurationReader.readIntegrationErrorConfiguration(soapConfig.getIntegrationError().getExternal());
        }
        ConfigurationServiceBindingSoap soap = new ConfigurationServiceBindingSoap(enabled, binding, internalIntegrationErrorConfiguration, externalIntegrationErrorConfiguration);
        soap.init();
        if (enabled && soapConfig.getMediaTypeCollection() != null) {
            ServiceBindingConfigurationReader.updateMediaTypeCollection(soap, soapConfig.getMediaTypeCollection(), true, true);
        }
        return soap;
    }

    private static void updateMediaTypeCollection(ConfigurationServiceBindingSoap soap, SoapMediaTypeCollection mediaTypesCollection, boolean request, boolean response) throws MessageException {
        if (mediaTypesCollection.sizeMediaTypeList() <= 0 && mediaTypesCollection.getDefault() == null && mediaTypesCollection.getUndefined() == null) {
            return;
        }
        if (request) {
            soap.getRequest().clear();
        }
        if (response) {
            soap.getResponse().clear();
        }
        for (int i = 0; i < mediaTypesCollection.sizeMediaTypeList(); ++i) {
            SoapMediaTypeMapping mapping = mediaTypesCollection.getMediaType(i);
            if (request) {
                soap.getRequest().addMediaType(mapping.getBase(), ServiceBindingConfigurationReader.convertToMessageType(mapping.getMessageType()), mapping.isRegExpr());
            }
            if (!response) continue;
            soap.getResponse().addMediaType(mapping.getBase(), ServiceBindingConfigurationReader.convertToMessageType(mapping.getMessageType()), mapping.isRegExpr());
        }
        if (mediaTypesCollection.getDefault() != null) {
            if (request) {
                soap.getRequest().addDefaultMediaType(ServiceBindingConfigurationReader.convertToMessageType(mediaTypesCollection.getDefault().getMessageType()));
            }
            if (response) {
                soap.getResponse().addDefaultMediaType(ServiceBindingConfigurationReader.convertToMessageType(mediaTypesCollection.getDefault().getMessageType()));
            }
        }
        if (mediaTypesCollection.getUndefined() != null) {
            if (request) {
                soap.getRequest().addUndefinedMediaType(ServiceBindingConfigurationReader.convertToMessageType(mediaTypesCollection.getUndefined().getMessageType()));
            }
            if (response) {
                soap.getResponse().addUndefinedMediaType(ServiceBindingConfigurationReader.convertToMessageType(mediaTypesCollection.getUndefined().getMessageType()));
            }
        }
    }

    private static void updateSoapMediaTypeCollection(ConfigurationServiceBindingSoap soap, MessageType messageType, boolean request, boolean response) throws MessageException {
        SoapMediaTypeCollection mediaTypeCollection = new SoapMediaTypeCollection();
        SoapMediaTypeDefaultMapping defaultMapping = new SoapMediaTypeDefaultMapping();
        defaultMapping.setMessageType(ServiceBindingConfigurationReader.convertToSoapMessageType(messageType));
        mediaTypeCollection.setDefault(defaultMapping);
        SoapMediaTypeUndefinedMapping undefinedMapping = new SoapMediaTypeUndefinedMapping();
        undefinedMapping.setMessageType(ServiceBindingConfigurationReader.convertToSoapMessageType(messageType));
        mediaTypeCollection.setUndefined(undefinedMapping);
        ServiceBindingConfigurationReader.updateMediaTypeCollection(soap, mediaTypeCollection, request, response);
    }

    private static MessageType convertToMessageType(SoapMessageType messageType) {
        switch (messageType) {
            case SOAP_11: {
                return MessageType.SOAP_11;
            }
            case SOAP_12: {
                return MessageType.SOAP_12;
            }
        }
        return null;
    }

    private static SoapMessageType convertToSoapMessageType(MessageType messageType) {
        switch (messageType) {
            case SOAP_11: {
                return SoapMessageType.SOAP_11;
            }
            case SOAP_12: {
                return SoapMessageType.SOAP_12;
            }
        }
        return null;
    }

    private static ConfigurationServiceBindingRest readConfigurationServiceBindingRest(Openspcoop2 manifest) throws MessageException {
        RestConfiguration restConfig = manifest.getBinding().getRest();
        boolean enabled = restConfig != null;
        RestBinding binding = null;
        org.openspcoop2.message.config.IntegrationErrorCollection internalIntegrationErrorConfiguration = null;
        org.openspcoop2.message.config.IntegrationErrorCollection externalIntegrationErrorConfiguration = null;
        if (enabled) {
            binding = new RestBinding(restConfig.isXml(), restConfig.isJson(), restConfig.isBinary(), restConfig.isMimeMultipart());
            internalIntegrationErrorConfiguration = ServiceBindingConfigurationReader.readIntegrationErrorConfiguration(restConfig.getIntegrationError().getInternal());
            externalIntegrationErrorConfiguration = ServiceBindingConfigurationReader.readIntegrationErrorConfiguration(restConfig.getIntegrationError().getExternal());
        }
        ConfigurationServiceBindingRest rest = new ConfigurationServiceBindingRest(enabled, binding, internalIntegrationErrorConfiguration, externalIntegrationErrorConfiguration);
        rest.init();
        if (enabled && restConfig.getMediaTypeCollection() != null) {
            ServiceBindingConfigurationReader.updateMediaTypeCollection(rest, restConfig.getMediaTypeCollection(), true, true);
        }
        return rest;
    }

    private static void updateMediaTypeCollection(ConfigurationServiceBindingRest rest, RestMediaTypeCollection mediaTypesCollection, boolean request, boolean response) throws MessageException {
        if (mediaTypesCollection.sizeMediaTypeList() <= 0 && mediaTypesCollection.getDefault() == null && mediaTypesCollection.getUndefined() == null) {
            return;
        }
        if (request) {
            rest.getRequest().clear();
        }
        if (response) {
            rest.getResponse().clear();
        }
        for (int i = 0; i < mediaTypesCollection.sizeMediaTypeList(); ++i) {
            RestMediaTypeMapping mapping = mediaTypesCollection.getMediaType(i);
            if (request) {
                rest.getRequest().addMediaType(mapping.getBase(), ServiceBindingConfigurationReader.convertToMessageType(mapping.getMessageType()), mapping.isRegExpr());
            }
            if (!response) continue;
            rest.getResponse().addMediaType(mapping.getBase(), ServiceBindingConfigurationReader.convertToMessageType(mapping.getMessageType()), mapping.isRegExpr());
        }
        if (mediaTypesCollection.getDefault() != null) {
            if (request) {
                rest.getRequest().addDefaultMediaType(ServiceBindingConfigurationReader.convertToMessageType(mediaTypesCollection.getDefault().getMessageType()));
            }
            if (response) {
                rest.getResponse().addDefaultMediaType(ServiceBindingConfigurationReader.convertToMessageType(mediaTypesCollection.getDefault().getMessageType()));
            }
        }
        if (mediaTypesCollection.getUndefined() != null) {
            if (request) {
                rest.getRequest().addUndefinedMediaType(ServiceBindingConfigurationReader.convertToMessageType(mediaTypesCollection.getUndefined().getMessageType()));
            }
            if (response) {
                rest.getResponse().addUndefinedMediaType(ServiceBindingConfigurationReader.convertToMessageType(mediaTypesCollection.getUndefined().getMessageType()));
            }
        }
    }

    private static void updateRestMediaTypeCollection(ConfigurationServiceBindingRest rest, MessageType messageType, boolean request, boolean response) throws MessageException {
        RestMediaTypeCollection mediaTypeCollection = new RestMediaTypeCollection();
        RestMediaTypeDefaultMapping defaultMapping = new RestMediaTypeDefaultMapping();
        defaultMapping.setMessageType(ServiceBindingConfigurationReader.convertToRestMessageType(messageType));
        mediaTypeCollection.setDefault(defaultMapping);
        RestMediaTypeUndefinedMapping undefinedMapping = new RestMediaTypeUndefinedMapping();
        undefinedMapping.setMessageType(ServiceBindingConfigurationReader.convertToRestMessageType(messageType));
        mediaTypeCollection.setUndefined(undefinedMapping);
        ServiceBindingConfigurationReader.updateMediaTypeCollection(rest, mediaTypeCollection, request, response);
    }

    private static MessageType convertToMessageType(RestMessageType messageType) {
        switch (messageType) {
            case XML: {
                return MessageType.XML;
            }
            case JSON: {
                return MessageType.JSON;
            }
            case BINARY: {
                return MessageType.BINARY;
            }
            case MIME_MULTIPART: {
                return MessageType.MIME_MULTIPART;
            }
        }
        return null;
    }

    private static RestMessageType convertToRestMessageType(MessageType messageType) {
        switch (messageType) {
            case XML: {
                return RestMessageType.XML;
            }
            case JSON: {
                return RestMessageType.JSON;
            }
            case BINARY: {
                return RestMessageType.BINARY;
            }
            case MIME_MULTIPART: {
                return RestMessageType.MIME_MULTIPART;
            }
        }
        return null;
    }

    private static IntegrationErrorReturnConfiguration to(IntegrationErrorCode errorCode, boolean retry, IntegrationErrorMessageDetailType errorMessage) {
        IntegrationErrorReturnConfiguration conf = new IntegrationErrorReturnConfiguration();
        conf.setHttpReturnCode(errorCode.getHttp());
        conf.setGovwayReturnCode(errorCode.getGovway());
        conf.setRetry(retry);
        conf.setGenericDetails(IntegrationErrorMessageDetailType.GENERIC.equals(errorMessage));
        return conf;
    }

    private static org.openspcoop2.message.config.IntegrationErrorCollection readIntegrationErrorConfiguration(IntegrationErrorCollection config) throws MessageException {
        org.openspcoop2.message.config.IntegrationErrorCollection integrationErrorConfiguration = new org.openspcoop2.message.config.IntegrationErrorCollection();
        ConfigurationRFC7807 rfc7807 = null;
        if (IntegrationErrorProblemType.RFC_7807.equals(config.getProblemType())) {
            RFC7807 rfc7807_protocolManifest = config.getRfc7807();
            rfc7807 = new ConfigurationRFC7807();
            rfc7807.setType(rfc7807_protocolManifest.isType());
            rfc7807.setTypeFormat(rfc7807_protocolManifest.getTypeFormat());
            rfc7807.setUseAcceptHeader(rfc7807_protocolManifest.getUseAcceptHeader());
            rfc7807.setInstance(rfc7807_protocolManifest.getInstance());
            rfc7807.setGovwayType(rfc7807_protocolManifest.getGovwayType());
            rfc7807.setGovwayStatus(rfc7807_protocolManifest.getGovwayStatus());
            rfc7807.setGovwayTransactionId(rfc7807_protocolManifest.getGovwayTransactionId());
            rfc7807.setDetails(rfc7807_protocolManifest.getDetails());
        }
        if (config.getDefault() != null) {
            integrationErrorConfiguration.addIntegrationError(rfc7807, IntegrationError.DEFAULT, ServiceBindingConfigurationReader.convertToMessageType(config.getDefault().getMessageType()), ServiceBindingConfigurationReader.to(config.getDefault().getErrorCode(), config.getDefault().getRetry(), config.getDefault().getErrorMessage()), config.isUseInternalFault());
        }
        if (config.getAuthentication() != null) {
            integrationErrorConfiguration.addIntegrationError(rfc7807, IntegrationError.AUTHENTICATION, ServiceBindingConfigurationReader.convertToMessageType(config.getAuthentication().getMessageType()), ServiceBindingConfigurationReader.to(config.getAuthentication().getErrorCode(), config.getAuthentication().getRetry(), config.getAuthentication().getErrorMessage()), config.isUseInternalFault());
        }
        if (config.getAuthorization() != null) {
            integrationErrorConfiguration.addIntegrationError(rfc7807, IntegrationError.AUTHORIZATION, ServiceBindingConfigurationReader.convertToMessageType(config.getAuthorization().getMessageType()), ServiceBindingConfigurationReader.to(config.getAuthorization().getErrorCode(), config.getAuthorization().getRetry(), config.getAuthorization().getErrorMessage()), config.isUseInternalFault());
        }
        if (config.getNotFound() != null) {
            integrationErrorConfiguration.addIntegrationError(rfc7807, IntegrationError.NOT_FOUND, ServiceBindingConfigurationReader.convertToMessageType(config.getNotFound().getMessageType()), ServiceBindingConfigurationReader.to(config.getNotFound().getErrorCode(), config.getNotFound().getRetry(), config.getNotFound().getErrorMessage()), config.isUseInternalFault());
        }
        if (config.getBadRequest() != null) {
            integrationErrorConfiguration.addIntegrationError(rfc7807, IntegrationError.BAD_REQUEST, ServiceBindingConfigurationReader.convertToMessageType(config.getBadRequest().getMessageType()), ServiceBindingConfigurationReader.to(config.getBadRequest().getErrorCode(), config.getBadRequest().getRetry(), config.getBadRequest().getErrorMessage()), config.isUseInternalFault());
        }
        if (config.getConflict() != null) {
            integrationErrorConfiguration.addIntegrationError(rfc7807, IntegrationError.CONFLICT, ServiceBindingConfigurationReader.convertToMessageType(config.getConflict().getMessageType()), ServiceBindingConfigurationReader.to(config.getConflict().getErrorCode(), config.getConflict().getRetry(), config.getConflict().getErrorMessage()), config.isUseInternalFault());
        }
        if (config.getRequestTooLarge() != null) {
            integrationErrorConfiguration.addIntegrationError(rfc7807, IntegrationError.REQUEST_TOO_LARGE, ServiceBindingConfigurationReader.convertToMessageType(config.getRequestTooLarge().getMessageType()), ServiceBindingConfigurationReader.to(config.getRequestTooLarge().getErrorCode(), config.getRequestTooLarge().getRetry(), config.getRequestTooLarge().getErrorMessage()), config.isUseInternalFault());
        }
        if (config.getLimitExceeded() != null) {
            integrationErrorConfiguration.addIntegrationError(rfc7807, IntegrationError.LIMIT_EXCEEDED, ServiceBindingConfigurationReader.convertToMessageType(config.getLimitExceeded().getMessageType()), ServiceBindingConfigurationReader.to(config.getLimitExceeded().getErrorCode(), config.getLimitExceeded().getRetry(), config.getLimitExceeded().getErrorMessage()), config.isUseInternalFault());
        }
        if (config.getTooManyRequests() != null) {
            integrationErrorConfiguration.addIntegrationError(rfc7807, IntegrationError.TOO_MANY_REQUESTS, ServiceBindingConfigurationReader.convertToMessageType(config.getTooManyRequests().getMessageType()), ServiceBindingConfigurationReader.to(config.getTooManyRequests().getErrorCode(), config.getTooManyRequests().getRetry(), config.getTooManyRequests().getErrorMessage()), config.isUseInternalFault());
        }
        if (config.getServiceUnavailable() != null) {
            integrationErrorConfiguration.addIntegrationError(rfc7807, IntegrationError.SERVICE_UNAVAILABLE, ServiceBindingConfigurationReader.convertToMessageType(config.getServiceUnavailable().getMessageType()), ServiceBindingConfigurationReader.to(config.getServiceUnavailable().getErrorCode(), config.getServiceUnavailable().getRetry(), config.getServiceUnavailable().getErrorMessage()), config.isUseInternalFault());
        }
        if (config.getEndpointRequestTimedOut() != null) {
            integrationErrorConfiguration.addIntegrationError(rfc7807, IntegrationError.ENDPOINT_REQUEST_TIMED_OUT, ServiceBindingConfigurationReader.convertToMessageType(config.getEndpointRequestTimedOut().getMessageType()), ServiceBindingConfigurationReader.to(config.getEndpointRequestTimedOut().getErrorCode(), config.getEndpointRequestTimedOut().getRetry(), config.getEndpointRequestTimedOut().getErrorMessage()), config.isUseInternalFault());
        }
        if (config.getBadResponse() != null) {
            integrationErrorConfiguration.addIntegrationError(rfc7807, IntegrationError.BAD_RESPONSE, ServiceBindingConfigurationReader.convertToMessageType(config.getBadResponse().getMessageType()), ServiceBindingConfigurationReader.to(config.getBadResponse().getErrorCode(), config.getBadResponse().getRetry(), config.getBadResponse().getErrorMessage()), config.isUseInternalFault());
        }
        if (config.getInternalRequestError() != null) {
            integrationErrorConfiguration.addIntegrationError(rfc7807, IntegrationError.INTERNAL_REQUEST_ERROR, ServiceBindingConfigurationReader.convertToMessageType(config.getInternalRequestError().getMessageType()), ServiceBindingConfigurationReader.to(config.getInternalRequestError().getErrorCode(), config.getInternalRequestError().getRetry(), config.getInternalRequestError().getErrorMessage()), config.isUseInternalFault());
        }
        if (config.getInternalResponseError() != null) {
            integrationErrorConfiguration.addIntegrationError(rfc7807, IntegrationError.INTERNAL_RESPONSE_ERROR, ServiceBindingConfigurationReader.convertToMessageType(config.getInternalResponseError().getMessageType()), ServiceBindingConfigurationReader.to(config.getInternalResponseError().getErrorCode(), config.getInternalResponseError().getRetry(), config.getInternalResponseError().getErrorMessage()), config.isUseInternalFault());
        }
        return integrationErrorConfiguration;
    }

    private static IntegrationErrorMessageType convertToMessageType(DefaultIntegrationErrorMessageType messageType) {
        switch (messageType) {
            case SOAP_11: {
                return IntegrationErrorMessageType.SOAP_11;
            }
            case SOAP_12: {
                return IntegrationErrorMessageType.SOAP_12;
            }
            case XML: {
                return IntegrationErrorMessageType.XML;
            }
            case JSON: {
                return IntegrationErrorMessageType.JSON;
            }
            case NONE: {
                return IntegrationErrorMessageType.NONE;
            }
        }
        return null;
    }

    private static IntegrationErrorMessageType convertToMessageType(org.openspcoop2.protocol.manifest.constants.IntegrationErrorMessageType messageType) {
        switch (messageType) {
            case SOAP_AS_REQUEST: {
                return IntegrationErrorMessageType.SOAP_AS_REQUEST;
            }
            case SOAP_11: {
                return IntegrationErrorMessageType.SOAP_11;
            }
            case SOAP_12: {
                return IntegrationErrorMessageType.SOAP_12;
            }
            case XML: {
                return IntegrationErrorMessageType.XML;
            }
            case JSON: {
                return IntegrationErrorMessageType.JSON;
            }
            case NONE: {
                return IntegrationErrorMessageType.NONE;
            }
            case SAME_AS_REQUEST: {
                return IntegrationErrorMessageType.SAME_AS_REQUEST;
            }
        }
        return null;
    }

    private static void addServiceBindingRestriction(Openspcoop2 manifest, ServiceBindingConfiguration config) {
        org.openspcoop2.protocol.manifest.constants.ServiceBinding serviceBinding;
        org.openspcoop2.protocol.manifest.constants.ServiceBinding serviceBinding2;
        int i;
        for (i = 0; i < manifest.getWeb().sizeContextList(); ++i) {
            String context = manifest.getWeb().getContext(i).getName();
            serviceBinding2 = manifest.getWeb().getContext(i).getBinding();
            if (serviceBinding2 == null) continue;
            config.addServiceBindingContextRestriction(ServiceBindingConfigurationReader.convertToServiceBinding(serviceBinding2), context);
        }
        if (manifest.getWeb().getEmptyContext() != null && (serviceBinding = manifest.getWeb().getEmptyContext().getBinding()) != null) {
            config.addServiceBindingEmptyContextRestriction(ServiceBindingConfigurationReader.convertToServiceBinding(serviceBinding));
        }
        for (i = 0; i < manifest.getRegistry().getService().getTypes().sizeTypeList(); ++i) {
            String serviceType = manifest.getRegistry().getService().getTypes().getType(i).getName();
            serviceBinding2 = manifest.getRegistry().getService().getTypes().getType(i).getBinding();
            if (serviceBinding2 == null) continue;
            config.addServiceBindingServiceTypeRestriction(ServiceBindingConfigurationReader.convertToServiceBinding(serviceBinding2), serviceType);
        }
    }

    private static ServiceBinding convertToServiceBinding(org.openspcoop2.protocol.manifest.constants.ServiceBinding serviceBinding) {
        switch (serviceBinding) {
            case SOAP: {
                return ServiceBinding.SOAP;
            }
            case REST: {
                return ServiceBinding.REST;
            }
        }
        return null;
    }

    private static ContextUrlCollection readContextUrlCollection(Openspcoop2 manifest, ConfigurationServiceBindingSoap soap, ConfigurationServiceBindingRest rest) throws MessageException {
        ContextUrlCollection urlCollection = new ContextUrlCollection(soap.getBinding(), rest.getBinding());
        for (int i = 0; i < manifest.getWeb().sizeContextList(); ++i) {
            String context = manifest.getWeb().getContext(i).getName();
            if (manifest.getWeb().getContext(i).sizeSubContextList() > 0) {
                for (int j = 0; j < manifest.getWeb().getContext(i).sizeSubContextList(); ++j) {
                    SubContextMapping subContext = manifest.getWeb().getContext(i).getSubContext(j);
                    urlCollection.addContext(context, subContext.getFunctionRawEnumValue(), subContext.getBase(), ServiceBindingConfigurationReader.convertToMessageType(subContext.getMessageType()), new String[0]);
                }
            }
            if (manifest.getWeb().getContext(i).getEmptySubContext() == null) continue;
            EmptySubContextMapping subContext = manifest.getWeb().getContext(i).getEmptySubContext();
            urlCollection.addContext(context, subContext.getFunctionRawEnumValue(), null, ServiceBindingConfigurationReader.convertToMessageType(subContext.getMessageType()), new String[0]);
        }
        if (manifest.getWeb().getEmptyContext() != null) {
            if (manifest.getWeb().getEmptyContext().sizeSubContextList() > 0) {
                for (int j = 0; j < manifest.getWeb().getEmptyContext().sizeSubContextList(); ++j) {
                    SubContextMapping subContext = manifest.getWeb().getEmptyContext().getSubContext(j);
                    urlCollection.addContext(null, subContext.getFunctionRawEnumValue(), subContext.getBase(), ServiceBindingConfigurationReader.convertToMessageType(subContext.getMessageType()), new String[0]);
                }
            }
            if (manifest.getWeb().getEmptyContext().getEmptySubContext() != null) {
                EmptySubContextMapping subContext = manifest.getWeb().getEmptyContext().getEmptySubContext();
                urlCollection.addContext(null, subContext.getFunctionRawEnumValue(), null, ServiceBindingConfigurationReader.convertToMessageType(subContext.getMessageType()), new String[0]);
            }
        }
        return urlCollection;
    }

    private static MessageType convertToMessageType(org.openspcoop2.protocol.manifest.constants.MessageType messageType) {
        switch (messageType) {
            case SOAP_11: {
                return MessageType.SOAP_11;
            }
            case SOAP_12: {
                return MessageType.SOAP_12;
            }
            case XML: {
                return MessageType.XML;
            }
            case JSON: {
                return MessageType.JSON;
            }
            case BINARY: {
                return MessageType.BINARY;
            }
            case MIME_MULTIPART: {
                return MessageType.MIME_MULTIPART;
            }
        }
        return null;
    }
}

