/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.manifest.utils.serializer;

import jakarta.xml.bind.JAXBElement;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import org.openspcoop2.generic_project.exception.SerializerException;
import org.openspcoop2.protocol.manifest.Binding;
import org.openspcoop2.protocol.manifest.CollaborationProfile;
import org.openspcoop2.protocol.manifest.Context;
import org.openspcoop2.protocol.manifest.DefaultIntegrationError;
import org.openspcoop2.protocol.manifest.EmptySubContextMapping;
import org.openspcoop2.protocol.manifest.Functionality;
import org.openspcoop2.protocol.manifest.Integration;
import org.openspcoop2.protocol.manifest.IntegrationConfiguration;
import org.openspcoop2.protocol.manifest.IntegrationConfigurationElementName;
import org.openspcoop2.protocol.manifest.IntegrationConfigurationName;
import org.openspcoop2.protocol.manifest.IntegrationConfigurationResourceIdentification;
import org.openspcoop2.protocol.manifest.IntegrationConfigurationResourceIdentificationMode;
import org.openspcoop2.protocol.manifest.IntegrationConfigurationResourceIdentificationModes;
import org.openspcoop2.protocol.manifest.IntegrationConfigurationResourceIdentificationSpecificResource;
import org.openspcoop2.protocol.manifest.IntegrationError;
import org.openspcoop2.protocol.manifest.IntegrationErrorCode;
import org.openspcoop2.protocol.manifest.IntegrationErrorCollection;
import org.openspcoop2.protocol.manifest.IntegrationErrorConfiguration;
import org.openspcoop2.protocol.manifest.InterfaceConfiguration;
import org.openspcoop2.protocol.manifest.InterfacesConfiguration;
import org.openspcoop2.protocol.manifest.Openspcoop2;
import org.openspcoop2.protocol.manifest.Organization;
import org.openspcoop2.protocol.manifest.OrganizationType;
import org.openspcoop2.protocol.manifest.OrganizationTypes;
import org.openspcoop2.protocol.manifest.Protocol;
import org.openspcoop2.protocol.manifest.RFC7807;
import org.openspcoop2.protocol.manifest.Registry;
import org.openspcoop2.protocol.manifest.RestCollaborationProfile;
import org.openspcoop2.protocol.manifest.RestConfiguration;
import org.openspcoop2.protocol.manifest.RestMediaTypeCollection;
import org.openspcoop2.protocol.manifest.RestMediaTypeDefaultMapping;
import org.openspcoop2.protocol.manifest.RestMediaTypeMapping;
import org.openspcoop2.protocol.manifest.RestMediaTypeUndefinedMapping;
import org.openspcoop2.protocol.manifest.Service;
import org.openspcoop2.protocol.manifest.ServiceType;
import org.openspcoop2.protocol.manifest.ServiceTypes;
import org.openspcoop2.protocol.manifest.SoapConfiguration;
import org.openspcoop2.protocol.manifest.SoapHeaderBypassMustUnderstand;
import org.openspcoop2.protocol.manifest.SoapHeaderBypassMustUnderstandHeader;
import org.openspcoop2.protocol.manifest.SoapMediaTypeCollection;
import org.openspcoop2.protocol.manifest.SoapMediaTypeDefaultMapping;
import org.openspcoop2.protocol.manifest.SoapMediaTypeMapping;
import org.openspcoop2.protocol.manifest.SoapMediaTypeUndefinedMapping;
import org.openspcoop2.protocol.manifest.SubContextMapping;
import org.openspcoop2.protocol.manifest.Transaction;
import org.openspcoop2.protocol.manifest.UrlMapping;
import org.openspcoop2.protocol.manifest.Version;
import org.openspcoop2.protocol.manifest.Versions;
import org.openspcoop2.protocol.manifest.Web;
import org.openspcoop2.protocol.manifest.WebEmptyContext;
import org.openspcoop2.utils.beans.WriteToSerializerType;
import org.openspcoop2.utils.xml.JaxbUtils;

public abstract class AbstractSerializer {
    protected abstract WriteToSerializerType getType();

    protected void _objToXml(OutputStream out, Class<?> c, Object object, boolean prettyPrint) throws Exception {
        if (object instanceof JAXBElement) {
            JaxbUtils.objToXml((OutputStream)out, c, (Object)object, (boolean)prettyPrint);
        } else {
            Method m = c.getMethod("writeTo", OutputStream.class, WriteToSerializerType.class);
            m.invoke(object, out, this.getType());
        }
    }

    protected void objToXml(OutputStream out, Class<?> c, Object object, boolean prettyPrint) throws SerializerException {
        try {
            this._objToXml(out, c, object, prettyPrint);
        }
        catch (Exception e) {
            throw new SerializerException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                out.flush();
            }
            catch (Exception exception) {}
        }
    }

    protected void objToXml(String fileName, Class<?> c, Object object, boolean prettyPrint) throws SerializerException {
        try {
            this.objToXml(new File(fileName), c, object, prettyPrint);
        }
        catch (Exception e) {
            throw new SerializerException(e.getMessage(), (Throwable)e);
        }
    }

    protected void objToXml(File file, Class<?> c, Object object, boolean prettyPrint) throws SerializerException {
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(file);
            this._objToXml(fout, c, object, prettyPrint);
        }
        catch (Exception e) {
            throw new SerializerException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (fout != null) {
                    fout.flush();
                }
            }
            catch (Exception exception) {}
            try {
                if (fout != null) {
                    fout.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    protected ByteArrayOutputStream objToXml(Class<?> c, Object object, boolean prettyPrint) throws SerializerException {
        ByteArrayOutputStream bout = null;
        try {
            bout = new ByteArrayOutputStream();
            this._objToXml(bout, c, object, prettyPrint);
        }
        catch (Exception e) {
            throw new SerializerException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (bout != null) {
                    bout.flush();
                }
            }
            catch (Exception exception) {}
            try {
                if (bout != null) {
                    bout.close();
                }
            }
            catch (Exception exception) {}
        }
        return bout;
    }

    public void write(String fileName, Protocol protocol) throws SerializerException {
        this.objToXml(fileName, Protocol.class, (Object)protocol, false);
    }

    public void write(String fileName, Protocol protocol, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, Protocol.class, (Object)protocol, prettyPrint);
    }

    public void write(File file, Protocol protocol) throws SerializerException {
        this.objToXml(file, Protocol.class, (Object)protocol, false);
    }

    public void write(File file, Protocol protocol, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, Protocol.class, (Object)protocol, prettyPrint);
    }

    public void write(OutputStream out, Protocol protocol) throws SerializerException {
        this.objToXml(out, Protocol.class, (Object)protocol, false);
    }

    public void write(OutputStream out, Protocol protocol, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, Protocol.class, (Object)protocol, prettyPrint);
    }

    public byte[] toByteArray(Protocol protocol) throws SerializerException {
        return this.objToXml(Protocol.class, protocol, false).toByteArray();
    }

    public byte[] toByteArray(Protocol protocol, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Protocol.class, protocol, prettyPrint).toByteArray();
    }

    public String toString(Protocol protocol) throws SerializerException {
        return this.objToXml(Protocol.class, protocol, false).toString();
    }

    public String toString(Protocol protocol, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Protocol.class, protocol, prettyPrint).toString();
    }

    public void write(String fileName, Openspcoop2 openspcoop2) throws SerializerException {
        this.objToXml(fileName, Openspcoop2.class, (Object)openspcoop2, false);
    }

    public void write(String fileName, Openspcoop2 openspcoop2, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, Openspcoop2.class, (Object)openspcoop2, prettyPrint);
    }

    public void write(File file, Openspcoop2 openspcoop2) throws SerializerException {
        this.objToXml(file, Openspcoop2.class, (Object)openspcoop2, false);
    }

    public void write(File file, Openspcoop2 openspcoop2, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, Openspcoop2.class, (Object)openspcoop2, prettyPrint);
    }

    public void write(OutputStream out, Openspcoop2 openspcoop2) throws SerializerException {
        this.objToXml(out, Openspcoop2.class, (Object)openspcoop2, false);
    }

    public void write(OutputStream out, Openspcoop2 openspcoop2, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, Openspcoop2.class, (Object)openspcoop2, prettyPrint);
    }

    public byte[] toByteArray(Openspcoop2 openspcoop2) throws SerializerException {
        return this.objToXml(Openspcoop2.class, openspcoop2, false).toByteArray();
    }

    public byte[] toByteArray(Openspcoop2 openspcoop2, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Openspcoop2.class, openspcoop2, prettyPrint).toByteArray();
    }

    public String toString(Openspcoop2 openspcoop2) throws SerializerException {
        return this.objToXml(Openspcoop2.class, openspcoop2, false).toString();
    }

    public String toString(Openspcoop2 openspcoop2, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Openspcoop2.class, openspcoop2, prettyPrint).toString();
    }

    public void write(String fileName, Binding binding) throws SerializerException {
        this.objToXml(fileName, Binding.class, (Object)binding, false);
    }

    public void write(String fileName, Binding binding, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, Binding.class, (Object)binding, prettyPrint);
    }

    public void write(File file, Binding binding) throws SerializerException {
        this.objToXml(file, Binding.class, (Object)binding, false);
    }

    public void write(File file, Binding binding, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, Binding.class, (Object)binding, prettyPrint);
    }

    public void write(OutputStream out, Binding binding) throws SerializerException {
        this.objToXml(out, Binding.class, (Object)binding, false);
    }

    public void write(OutputStream out, Binding binding, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, Binding.class, (Object)binding, prettyPrint);
    }

    public byte[] toByteArray(Binding binding) throws SerializerException {
        return this.objToXml(Binding.class, binding, false).toByteArray();
    }

    public byte[] toByteArray(Binding binding, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Binding.class, binding, prettyPrint).toByteArray();
    }

    public String toString(Binding binding) throws SerializerException {
        return this.objToXml(Binding.class, binding, false).toString();
    }

    public String toString(Binding binding, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Binding.class, binding, prettyPrint).toString();
    }

    public void write(String fileName, Web web) throws SerializerException {
        this.objToXml(fileName, Web.class, (Object)web, false);
    }

    public void write(String fileName, Web web, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, Web.class, (Object)web, prettyPrint);
    }

    public void write(File file, Web web) throws SerializerException {
        this.objToXml(file, Web.class, (Object)web, false);
    }

    public void write(File file, Web web, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, Web.class, (Object)web, prettyPrint);
    }

    public void write(OutputStream out, Web web) throws SerializerException {
        this.objToXml(out, Web.class, (Object)web, false);
    }

    public void write(OutputStream out, Web web, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, Web.class, (Object)web, prettyPrint);
    }

    public byte[] toByteArray(Web web) throws SerializerException {
        return this.objToXml(Web.class, web, false).toByteArray();
    }

    public byte[] toByteArray(Web web, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Web.class, web, prettyPrint).toByteArray();
    }

    public String toString(Web web) throws SerializerException {
        return this.objToXml(Web.class, web, false).toString();
    }

    public String toString(Web web, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Web.class, web, prettyPrint).toString();
    }

    public void write(String fileName, Registry registry) throws SerializerException {
        this.objToXml(fileName, Registry.class, (Object)registry, false);
    }

    public void write(String fileName, Registry registry, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, Registry.class, (Object)registry, prettyPrint);
    }

    public void write(File file, Registry registry) throws SerializerException {
        this.objToXml(file, Registry.class, (Object)registry, false);
    }

    public void write(File file, Registry registry, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, Registry.class, (Object)registry, prettyPrint);
    }

    public void write(OutputStream out, Registry registry) throws SerializerException {
        this.objToXml(out, Registry.class, (Object)registry, false);
    }

    public void write(OutputStream out, Registry registry, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, Registry.class, (Object)registry, prettyPrint);
    }

    public byte[] toByteArray(Registry registry) throws SerializerException {
        return this.objToXml(Registry.class, registry, false).toByteArray();
    }

    public byte[] toByteArray(Registry registry, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Registry.class, registry, prettyPrint).toByteArray();
    }

    public String toString(Registry registry) throws SerializerException {
        return this.objToXml(Registry.class, registry, false).toString();
    }

    public String toString(Registry registry, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Registry.class, registry, prettyPrint).toString();
    }

    public void write(String fileName, UrlMapping urlMapping) throws SerializerException {
        this.objToXml(fileName, UrlMapping.class, (Object)urlMapping, false);
    }

    public void write(String fileName, UrlMapping urlMapping, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, UrlMapping.class, (Object)urlMapping, prettyPrint);
    }

    public void write(File file, UrlMapping urlMapping) throws SerializerException {
        this.objToXml(file, UrlMapping.class, (Object)urlMapping, false);
    }

    public void write(File file, UrlMapping urlMapping, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, UrlMapping.class, (Object)urlMapping, prettyPrint);
    }

    public void write(OutputStream out, UrlMapping urlMapping) throws SerializerException {
        this.objToXml(out, UrlMapping.class, (Object)urlMapping, false);
    }

    public void write(OutputStream out, UrlMapping urlMapping, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, UrlMapping.class, (Object)urlMapping, prettyPrint);
    }

    public byte[] toByteArray(UrlMapping urlMapping) throws SerializerException {
        return this.objToXml(UrlMapping.class, urlMapping, false).toByteArray();
    }

    public byte[] toByteArray(UrlMapping urlMapping, boolean prettyPrint) throws SerializerException {
        return this.objToXml(UrlMapping.class, urlMapping, prettyPrint).toByteArray();
    }

    public String toString(UrlMapping urlMapping) throws SerializerException {
        return this.objToXml(UrlMapping.class, urlMapping, false).toString();
    }

    public String toString(UrlMapping urlMapping, boolean prettyPrint) throws SerializerException {
        return this.objToXml(UrlMapping.class, urlMapping, prettyPrint).toString();
    }

    public void write(String fileName, ServiceTypes serviceTypes) throws SerializerException {
        this.objToXml(fileName, ServiceTypes.class, (Object)serviceTypes, false);
    }

    public void write(String fileName, ServiceTypes serviceTypes, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, ServiceTypes.class, (Object)serviceTypes, prettyPrint);
    }

    public void write(File file, ServiceTypes serviceTypes) throws SerializerException {
        this.objToXml(file, ServiceTypes.class, (Object)serviceTypes, false);
    }

    public void write(File file, ServiceTypes serviceTypes, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, ServiceTypes.class, (Object)serviceTypes, prettyPrint);
    }

    public void write(OutputStream out, ServiceTypes serviceTypes) throws SerializerException {
        this.objToXml(out, ServiceTypes.class, (Object)serviceTypes, false);
    }

    public void write(OutputStream out, ServiceTypes serviceTypes, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, ServiceTypes.class, (Object)serviceTypes, prettyPrint);
    }

    public byte[] toByteArray(ServiceTypes serviceTypes) throws SerializerException {
        return this.objToXml(ServiceTypes.class, serviceTypes, false).toByteArray();
    }

    public byte[] toByteArray(ServiceTypes serviceTypes, boolean prettyPrint) throws SerializerException {
        return this.objToXml(ServiceTypes.class, serviceTypes, prettyPrint).toByteArray();
    }

    public String toString(ServiceTypes serviceTypes) throws SerializerException {
        return this.objToXml(ServiceTypes.class, serviceTypes, false).toString();
    }

    public String toString(ServiceTypes serviceTypes, boolean prettyPrint) throws SerializerException {
        return this.objToXml(ServiceTypes.class, serviceTypes, prettyPrint).toString();
    }

    public void write(String fileName, Service service) throws SerializerException {
        this.objToXml(fileName, Service.class, (Object)service, false);
    }

    public void write(String fileName, Service service, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, Service.class, (Object)service, prettyPrint);
    }

    public void write(File file, Service service) throws SerializerException {
        this.objToXml(file, Service.class, (Object)service, false);
    }

    public void write(File file, Service service, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, Service.class, (Object)service, prettyPrint);
    }

    public void write(OutputStream out, Service service) throws SerializerException {
        this.objToXml(out, Service.class, (Object)service, false);
    }

    public void write(OutputStream out, Service service, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, Service.class, (Object)service, prettyPrint);
    }

    public byte[] toByteArray(Service service) throws SerializerException {
        return this.objToXml(Service.class, service, false).toByteArray();
    }

    public byte[] toByteArray(Service service, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Service.class, service, prettyPrint).toByteArray();
    }

    public String toString(Service service) throws SerializerException {
        return this.objToXml(Service.class, service, false).toString();
    }

    public String toString(Service service, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Service.class, service, prettyPrint).toString();
    }

    public void write(String fileName, SoapMediaTypeMapping soapMediaTypeMapping) throws SerializerException {
        this.objToXml(fileName, SoapMediaTypeMapping.class, (Object)soapMediaTypeMapping, false);
    }

    public void write(String fileName, SoapMediaTypeMapping soapMediaTypeMapping, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, SoapMediaTypeMapping.class, (Object)soapMediaTypeMapping, prettyPrint);
    }

    public void write(File file, SoapMediaTypeMapping soapMediaTypeMapping) throws SerializerException {
        this.objToXml(file, SoapMediaTypeMapping.class, (Object)soapMediaTypeMapping, false);
    }

    public void write(File file, SoapMediaTypeMapping soapMediaTypeMapping, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, SoapMediaTypeMapping.class, (Object)soapMediaTypeMapping, prettyPrint);
    }

    public void write(OutputStream out, SoapMediaTypeMapping soapMediaTypeMapping) throws SerializerException {
        this.objToXml(out, SoapMediaTypeMapping.class, (Object)soapMediaTypeMapping, false);
    }

    public void write(OutputStream out, SoapMediaTypeMapping soapMediaTypeMapping, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, SoapMediaTypeMapping.class, (Object)soapMediaTypeMapping, prettyPrint);
    }

    public byte[] toByteArray(SoapMediaTypeMapping soapMediaTypeMapping) throws SerializerException {
        return this.objToXml(SoapMediaTypeMapping.class, soapMediaTypeMapping, false).toByteArray();
    }

    public byte[] toByteArray(SoapMediaTypeMapping soapMediaTypeMapping, boolean prettyPrint) throws SerializerException {
        return this.objToXml(SoapMediaTypeMapping.class, soapMediaTypeMapping, prettyPrint).toByteArray();
    }

    public String toString(SoapMediaTypeMapping soapMediaTypeMapping) throws SerializerException {
        return this.objToXml(SoapMediaTypeMapping.class, soapMediaTypeMapping, false).toString();
    }

    public String toString(SoapMediaTypeMapping soapMediaTypeMapping, boolean prettyPrint) throws SerializerException {
        return this.objToXml(SoapMediaTypeMapping.class, soapMediaTypeMapping, prettyPrint).toString();
    }

    public void write(String fileName, SoapMediaTypeCollection soapMediaTypeCollection) throws SerializerException {
        this.objToXml(fileName, SoapMediaTypeCollection.class, (Object)soapMediaTypeCollection, false);
    }

    public void write(String fileName, SoapMediaTypeCollection soapMediaTypeCollection, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, SoapMediaTypeCollection.class, (Object)soapMediaTypeCollection, prettyPrint);
    }

    public void write(File file, SoapMediaTypeCollection soapMediaTypeCollection) throws SerializerException {
        this.objToXml(file, SoapMediaTypeCollection.class, (Object)soapMediaTypeCollection, false);
    }

    public void write(File file, SoapMediaTypeCollection soapMediaTypeCollection, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, SoapMediaTypeCollection.class, (Object)soapMediaTypeCollection, prettyPrint);
    }

    public void write(OutputStream out, SoapMediaTypeCollection soapMediaTypeCollection) throws SerializerException {
        this.objToXml(out, SoapMediaTypeCollection.class, (Object)soapMediaTypeCollection, false);
    }

    public void write(OutputStream out, SoapMediaTypeCollection soapMediaTypeCollection, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, SoapMediaTypeCollection.class, (Object)soapMediaTypeCollection, prettyPrint);
    }

    public byte[] toByteArray(SoapMediaTypeCollection soapMediaTypeCollection) throws SerializerException {
        return this.objToXml(SoapMediaTypeCollection.class, soapMediaTypeCollection, false).toByteArray();
    }

    public byte[] toByteArray(SoapMediaTypeCollection soapMediaTypeCollection, boolean prettyPrint) throws SerializerException {
        return this.objToXml(SoapMediaTypeCollection.class, soapMediaTypeCollection, prettyPrint).toByteArray();
    }

    public String toString(SoapMediaTypeCollection soapMediaTypeCollection) throws SerializerException {
        return this.objToXml(SoapMediaTypeCollection.class, soapMediaTypeCollection, false).toString();
    }

    public String toString(SoapMediaTypeCollection soapMediaTypeCollection, boolean prettyPrint) throws SerializerException {
        return this.objToXml(SoapMediaTypeCollection.class, soapMediaTypeCollection, prettyPrint).toString();
    }

    public void write(String fileName, SoapMediaTypeDefaultMapping soapMediaTypeDefaultMapping) throws SerializerException {
        this.objToXml(fileName, SoapMediaTypeDefaultMapping.class, (Object)soapMediaTypeDefaultMapping, false);
    }

    public void write(String fileName, SoapMediaTypeDefaultMapping soapMediaTypeDefaultMapping, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, SoapMediaTypeDefaultMapping.class, (Object)soapMediaTypeDefaultMapping, prettyPrint);
    }

    public void write(File file, SoapMediaTypeDefaultMapping soapMediaTypeDefaultMapping) throws SerializerException {
        this.objToXml(file, SoapMediaTypeDefaultMapping.class, (Object)soapMediaTypeDefaultMapping, false);
    }

    public void write(File file, SoapMediaTypeDefaultMapping soapMediaTypeDefaultMapping, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, SoapMediaTypeDefaultMapping.class, (Object)soapMediaTypeDefaultMapping, prettyPrint);
    }

    public void write(OutputStream out, SoapMediaTypeDefaultMapping soapMediaTypeDefaultMapping) throws SerializerException {
        this.objToXml(out, SoapMediaTypeDefaultMapping.class, (Object)soapMediaTypeDefaultMapping, false);
    }

    public void write(OutputStream out, SoapMediaTypeDefaultMapping soapMediaTypeDefaultMapping, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, SoapMediaTypeDefaultMapping.class, (Object)soapMediaTypeDefaultMapping, prettyPrint);
    }

    public byte[] toByteArray(SoapMediaTypeDefaultMapping soapMediaTypeDefaultMapping) throws SerializerException {
        return this.objToXml(SoapMediaTypeDefaultMapping.class, soapMediaTypeDefaultMapping, false).toByteArray();
    }

    public byte[] toByteArray(SoapMediaTypeDefaultMapping soapMediaTypeDefaultMapping, boolean prettyPrint) throws SerializerException {
        return this.objToXml(SoapMediaTypeDefaultMapping.class, soapMediaTypeDefaultMapping, prettyPrint).toByteArray();
    }

    public String toString(SoapMediaTypeDefaultMapping soapMediaTypeDefaultMapping) throws SerializerException {
        return this.objToXml(SoapMediaTypeDefaultMapping.class, soapMediaTypeDefaultMapping, false).toString();
    }

    public String toString(SoapMediaTypeDefaultMapping soapMediaTypeDefaultMapping, boolean prettyPrint) throws SerializerException {
        return this.objToXml(SoapMediaTypeDefaultMapping.class, soapMediaTypeDefaultMapping, prettyPrint).toString();
    }

    public void write(String fileName, SoapMediaTypeUndefinedMapping soapMediaTypeUndefinedMapping) throws SerializerException {
        this.objToXml(fileName, SoapMediaTypeUndefinedMapping.class, (Object)soapMediaTypeUndefinedMapping, false);
    }

    public void write(String fileName, SoapMediaTypeUndefinedMapping soapMediaTypeUndefinedMapping, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, SoapMediaTypeUndefinedMapping.class, (Object)soapMediaTypeUndefinedMapping, prettyPrint);
    }

    public void write(File file, SoapMediaTypeUndefinedMapping soapMediaTypeUndefinedMapping) throws SerializerException {
        this.objToXml(file, SoapMediaTypeUndefinedMapping.class, (Object)soapMediaTypeUndefinedMapping, false);
    }

    public void write(File file, SoapMediaTypeUndefinedMapping soapMediaTypeUndefinedMapping, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, SoapMediaTypeUndefinedMapping.class, (Object)soapMediaTypeUndefinedMapping, prettyPrint);
    }

    public void write(OutputStream out, SoapMediaTypeUndefinedMapping soapMediaTypeUndefinedMapping) throws SerializerException {
        this.objToXml(out, SoapMediaTypeUndefinedMapping.class, (Object)soapMediaTypeUndefinedMapping, false);
    }

    public void write(OutputStream out, SoapMediaTypeUndefinedMapping soapMediaTypeUndefinedMapping, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, SoapMediaTypeUndefinedMapping.class, (Object)soapMediaTypeUndefinedMapping, prettyPrint);
    }

    public byte[] toByteArray(SoapMediaTypeUndefinedMapping soapMediaTypeUndefinedMapping) throws SerializerException {
        return this.objToXml(SoapMediaTypeUndefinedMapping.class, soapMediaTypeUndefinedMapping, false).toByteArray();
    }

    public byte[] toByteArray(SoapMediaTypeUndefinedMapping soapMediaTypeUndefinedMapping, boolean prettyPrint) throws SerializerException {
        return this.objToXml(SoapMediaTypeUndefinedMapping.class, soapMediaTypeUndefinedMapping, prettyPrint).toByteArray();
    }

    public String toString(SoapMediaTypeUndefinedMapping soapMediaTypeUndefinedMapping) throws SerializerException {
        return this.objToXml(SoapMediaTypeUndefinedMapping.class, soapMediaTypeUndefinedMapping, false).toString();
    }

    public String toString(SoapMediaTypeUndefinedMapping soapMediaTypeUndefinedMapping, boolean prettyPrint) throws SerializerException {
        return this.objToXml(SoapMediaTypeUndefinedMapping.class, soapMediaTypeUndefinedMapping, prettyPrint).toString();
    }

    public void write(String fileName, IntegrationErrorCode integrationErrorCode) throws SerializerException {
        this.objToXml(fileName, IntegrationErrorCode.class, (Object)integrationErrorCode, false);
    }

    public void write(String fileName, IntegrationErrorCode integrationErrorCode, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, IntegrationErrorCode.class, (Object)integrationErrorCode, prettyPrint);
    }

    public void write(File file, IntegrationErrorCode integrationErrorCode) throws SerializerException {
        this.objToXml(file, IntegrationErrorCode.class, (Object)integrationErrorCode, false);
    }

    public void write(File file, IntegrationErrorCode integrationErrorCode, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, IntegrationErrorCode.class, (Object)integrationErrorCode, prettyPrint);
    }

    public void write(OutputStream out, IntegrationErrorCode integrationErrorCode) throws SerializerException {
        this.objToXml(out, IntegrationErrorCode.class, (Object)integrationErrorCode, false);
    }

    public void write(OutputStream out, IntegrationErrorCode integrationErrorCode, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, IntegrationErrorCode.class, (Object)integrationErrorCode, prettyPrint);
    }

    public byte[] toByteArray(IntegrationErrorCode integrationErrorCode) throws SerializerException {
        return this.objToXml(IntegrationErrorCode.class, integrationErrorCode, false).toByteArray();
    }

    public byte[] toByteArray(IntegrationErrorCode integrationErrorCode, boolean prettyPrint) throws SerializerException {
        return this.objToXml(IntegrationErrorCode.class, integrationErrorCode, prettyPrint).toByteArray();
    }

    public String toString(IntegrationErrorCode integrationErrorCode) throws SerializerException {
        return this.objToXml(IntegrationErrorCode.class, integrationErrorCode, false).toString();
    }

    public String toString(IntegrationErrorCode integrationErrorCode, boolean prettyPrint) throws SerializerException {
        return this.objToXml(IntegrationErrorCode.class, integrationErrorCode, prettyPrint).toString();
    }

    public void write(String fileName, Integration integration) throws SerializerException {
        this.objToXml(fileName, Integration.class, (Object)integration, false);
    }

    public void write(String fileName, Integration integration, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, Integration.class, (Object)integration, prettyPrint);
    }

    public void write(File file, Integration integration) throws SerializerException {
        this.objToXml(file, Integration.class, (Object)integration, false);
    }

    public void write(File file, Integration integration, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, Integration.class, (Object)integration, prettyPrint);
    }

    public void write(OutputStream out, Integration integration) throws SerializerException {
        this.objToXml(out, Integration.class, (Object)integration, false);
    }

    public void write(OutputStream out, Integration integration, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, Integration.class, (Object)integration, prettyPrint);
    }

    public byte[] toByteArray(Integration integration) throws SerializerException {
        return this.objToXml(Integration.class, integration, false).toByteArray();
    }

    public byte[] toByteArray(Integration integration, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Integration.class, integration, prettyPrint).toByteArray();
    }

    public String toString(Integration integration) throws SerializerException {
        return this.objToXml(Integration.class, integration, false).toString();
    }

    public String toString(Integration integration, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Integration.class, integration, prettyPrint).toString();
    }

    public void write(String fileName, RestConfiguration restConfiguration) throws SerializerException {
        this.objToXml(fileName, RestConfiguration.class, (Object)restConfiguration, false);
    }

    public void write(String fileName, RestConfiguration restConfiguration, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, RestConfiguration.class, (Object)restConfiguration, prettyPrint);
    }

    public void write(File file, RestConfiguration restConfiguration) throws SerializerException {
        this.objToXml(file, RestConfiguration.class, (Object)restConfiguration, false);
    }

    public void write(File file, RestConfiguration restConfiguration, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, RestConfiguration.class, (Object)restConfiguration, prettyPrint);
    }

    public void write(OutputStream out, RestConfiguration restConfiguration) throws SerializerException {
        this.objToXml(out, RestConfiguration.class, (Object)restConfiguration, false);
    }

    public void write(OutputStream out, RestConfiguration restConfiguration, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, RestConfiguration.class, (Object)restConfiguration, prettyPrint);
    }

    public byte[] toByteArray(RestConfiguration restConfiguration) throws SerializerException {
        return this.objToXml(RestConfiguration.class, restConfiguration, false).toByteArray();
    }

    public byte[] toByteArray(RestConfiguration restConfiguration, boolean prettyPrint) throws SerializerException {
        return this.objToXml(RestConfiguration.class, restConfiguration, prettyPrint).toByteArray();
    }

    public String toString(RestConfiguration restConfiguration) throws SerializerException {
        return this.objToXml(RestConfiguration.class, restConfiguration, false).toString();
    }

    public String toString(RestConfiguration restConfiguration, boolean prettyPrint) throws SerializerException {
        return this.objToXml(RestConfiguration.class, restConfiguration, prettyPrint).toString();
    }

    public void write(String fileName, IntegrationErrorConfiguration integrationErrorConfiguration) throws SerializerException {
        this.objToXml(fileName, IntegrationErrorConfiguration.class, (Object)integrationErrorConfiguration, false);
    }

    public void write(String fileName, IntegrationErrorConfiguration integrationErrorConfiguration, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, IntegrationErrorConfiguration.class, (Object)integrationErrorConfiguration, prettyPrint);
    }

    public void write(File file, IntegrationErrorConfiguration integrationErrorConfiguration) throws SerializerException {
        this.objToXml(file, IntegrationErrorConfiguration.class, (Object)integrationErrorConfiguration, false);
    }

    public void write(File file, IntegrationErrorConfiguration integrationErrorConfiguration, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, IntegrationErrorConfiguration.class, (Object)integrationErrorConfiguration, prettyPrint);
    }

    public void write(OutputStream out, IntegrationErrorConfiguration integrationErrorConfiguration) throws SerializerException {
        this.objToXml(out, IntegrationErrorConfiguration.class, (Object)integrationErrorConfiguration, false);
    }

    public void write(OutputStream out, IntegrationErrorConfiguration integrationErrorConfiguration, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, IntegrationErrorConfiguration.class, (Object)integrationErrorConfiguration, prettyPrint);
    }

    public byte[] toByteArray(IntegrationErrorConfiguration integrationErrorConfiguration) throws SerializerException {
        return this.objToXml(IntegrationErrorConfiguration.class, integrationErrorConfiguration, false).toByteArray();
    }

    public byte[] toByteArray(IntegrationErrorConfiguration integrationErrorConfiguration, boolean prettyPrint) throws SerializerException {
        return this.objToXml(IntegrationErrorConfiguration.class, integrationErrorConfiguration, prettyPrint).toByteArray();
    }

    public String toString(IntegrationErrorConfiguration integrationErrorConfiguration) throws SerializerException {
        return this.objToXml(IntegrationErrorConfiguration.class, integrationErrorConfiguration, false).toString();
    }

    public String toString(IntegrationErrorConfiguration integrationErrorConfiguration, boolean prettyPrint) throws SerializerException {
        return this.objToXml(IntegrationErrorConfiguration.class, integrationErrorConfiguration, prettyPrint).toString();
    }

    public void write(String fileName, RestMediaTypeCollection restMediaTypeCollection) throws SerializerException {
        this.objToXml(fileName, RestMediaTypeCollection.class, (Object)restMediaTypeCollection, false);
    }

    public void write(String fileName, RestMediaTypeCollection restMediaTypeCollection, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, RestMediaTypeCollection.class, (Object)restMediaTypeCollection, prettyPrint);
    }

    public void write(File file, RestMediaTypeCollection restMediaTypeCollection) throws SerializerException {
        this.objToXml(file, RestMediaTypeCollection.class, (Object)restMediaTypeCollection, false);
    }

    public void write(File file, RestMediaTypeCollection restMediaTypeCollection, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, RestMediaTypeCollection.class, (Object)restMediaTypeCollection, prettyPrint);
    }

    public void write(OutputStream out, RestMediaTypeCollection restMediaTypeCollection) throws SerializerException {
        this.objToXml(out, RestMediaTypeCollection.class, (Object)restMediaTypeCollection, false);
    }

    public void write(OutputStream out, RestMediaTypeCollection restMediaTypeCollection, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, RestMediaTypeCollection.class, (Object)restMediaTypeCollection, prettyPrint);
    }

    public byte[] toByteArray(RestMediaTypeCollection restMediaTypeCollection) throws SerializerException {
        return this.objToXml(RestMediaTypeCollection.class, restMediaTypeCollection, false).toByteArray();
    }

    public byte[] toByteArray(RestMediaTypeCollection restMediaTypeCollection, boolean prettyPrint) throws SerializerException {
        return this.objToXml(RestMediaTypeCollection.class, restMediaTypeCollection, prettyPrint).toByteArray();
    }

    public String toString(RestMediaTypeCollection restMediaTypeCollection) throws SerializerException {
        return this.objToXml(RestMediaTypeCollection.class, restMediaTypeCollection, false).toString();
    }

    public String toString(RestMediaTypeCollection restMediaTypeCollection, boolean prettyPrint) throws SerializerException {
        return this.objToXml(RestMediaTypeCollection.class, restMediaTypeCollection, prettyPrint).toString();
    }

    public void write(String fileName, InterfacesConfiguration interfacesConfiguration) throws SerializerException {
        this.objToXml(fileName, InterfacesConfiguration.class, (Object)interfacesConfiguration, false);
    }

    public void write(String fileName, InterfacesConfiguration interfacesConfiguration, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, InterfacesConfiguration.class, (Object)interfacesConfiguration, prettyPrint);
    }

    public void write(File file, InterfacesConfiguration interfacesConfiguration) throws SerializerException {
        this.objToXml(file, InterfacesConfiguration.class, (Object)interfacesConfiguration, false);
    }

    public void write(File file, InterfacesConfiguration interfacesConfiguration, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, InterfacesConfiguration.class, (Object)interfacesConfiguration, prettyPrint);
    }

    public void write(OutputStream out, InterfacesConfiguration interfacesConfiguration) throws SerializerException {
        this.objToXml(out, InterfacesConfiguration.class, (Object)interfacesConfiguration, false);
    }

    public void write(OutputStream out, InterfacesConfiguration interfacesConfiguration, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, InterfacesConfiguration.class, (Object)interfacesConfiguration, prettyPrint);
    }

    public byte[] toByteArray(InterfacesConfiguration interfacesConfiguration) throws SerializerException {
        return this.objToXml(InterfacesConfiguration.class, interfacesConfiguration, false).toByteArray();
    }

    public byte[] toByteArray(InterfacesConfiguration interfacesConfiguration, boolean prettyPrint) throws SerializerException {
        return this.objToXml(InterfacesConfiguration.class, interfacesConfiguration, prettyPrint).toByteArray();
    }

    public String toString(InterfacesConfiguration interfacesConfiguration) throws SerializerException {
        return this.objToXml(InterfacesConfiguration.class, interfacesConfiguration, false).toString();
    }

    public String toString(InterfacesConfiguration interfacesConfiguration, boolean prettyPrint) throws SerializerException {
        return this.objToXml(InterfacesConfiguration.class, interfacesConfiguration, prettyPrint).toString();
    }

    public void write(String fileName, RestCollaborationProfile restCollaborationProfile) throws SerializerException {
        this.objToXml(fileName, RestCollaborationProfile.class, (Object)restCollaborationProfile, false);
    }

    public void write(String fileName, RestCollaborationProfile restCollaborationProfile, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, RestCollaborationProfile.class, (Object)restCollaborationProfile, prettyPrint);
    }

    public void write(File file, RestCollaborationProfile restCollaborationProfile) throws SerializerException {
        this.objToXml(file, RestCollaborationProfile.class, (Object)restCollaborationProfile, false);
    }

    public void write(File file, RestCollaborationProfile restCollaborationProfile, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, RestCollaborationProfile.class, (Object)restCollaborationProfile, prettyPrint);
    }

    public void write(OutputStream out, RestCollaborationProfile restCollaborationProfile) throws SerializerException {
        this.objToXml(out, RestCollaborationProfile.class, (Object)restCollaborationProfile, false);
    }

    public void write(OutputStream out, RestCollaborationProfile restCollaborationProfile, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, RestCollaborationProfile.class, (Object)restCollaborationProfile, prettyPrint);
    }

    public byte[] toByteArray(RestCollaborationProfile restCollaborationProfile) throws SerializerException {
        return this.objToXml(RestCollaborationProfile.class, restCollaborationProfile, false).toByteArray();
    }

    public byte[] toByteArray(RestCollaborationProfile restCollaborationProfile, boolean prettyPrint) throws SerializerException {
        return this.objToXml(RestCollaborationProfile.class, restCollaborationProfile, prettyPrint).toByteArray();
    }

    public String toString(RestCollaborationProfile restCollaborationProfile) throws SerializerException {
        return this.objToXml(RestCollaborationProfile.class, restCollaborationProfile, false).toString();
    }

    public String toString(RestCollaborationProfile restCollaborationProfile, boolean prettyPrint) throws SerializerException {
        return this.objToXml(RestCollaborationProfile.class, restCollaborationProfile, prettyPrint).toString();
    }

    public void write(String fileName, Functionality functionality) throws SerializerException {
        this.objToXml(fileName, Functionality.class, (Object)functionality, false);
    }

    public void write(String fileName, Functionality functionality, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, Functionality.class, (Object)functionality, prettyPrint);
    }

    public void write(File file, Functionality functionality) throws SerializerException {
        this.objToXml(file, Functionality.class, (Object)functionality, false);
    }

    public void write(File file, Functionality functionality, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, Functionality.class, (Object)functionality, prettyPrint);
    }

    public void write(OutputStream out, Functionality functionality) throws SerializerException {
        this.objToXml(out, Functionality.class, (Object)functionality, false);
    }

    public void write(OutputStream out, Functionality functionality, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, Functionality.class, (Object)functionality, prettyPrint);
    }

    public byte[] toByteArray(Functionality functionality) throws SerializerException {
        return this.objToXml(Functionality.class, functionality, false).toByteArray();
    }

    public byte[] toByteArray(Functionality functionality, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Functionality.class, functionality, prettyPrint).toByteArray();
    }

    public String toString(Functionality functionality) throws SerializerException {
        return this.objToXml(Functionality.class, functionality, false).toString();
    }

    public String toString(Functionality functionality, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Functionality.class, functionality, prettyPrint).toString();
    }

    public void write(String fileName, IntegrationErrorCollection integrationErrorCollection) throws SerializerException {
        this.objToXml(fileName, IntegrationErrorCollection.class, (Object)integrationErrorCollection, false);
    }

    public void write(String fileName, IntegrationErrorCollection integrationErrorCollection, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, IntegrationErrorCollection.class, (Object)integrationErrorCollection, prettyPrint);
    }

    public void write(File file, IntegrationErrorCollection integrationErrorCollection) throws SerializerException {
        this.objToXml(file, IntegrationErrorCollection.class, (Object)integrationErrorCollection, false);
    }

    public void write(File file, IntegrationErrorCollection integrationErrorCollection, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, IntegrationErrorCollection.class, (Object)integrationErrorCollection, prettyPrint);
    }

    public void write(OutputStream out, IntegrationErrorCollection integrationErrorCollection) throws SerializerException {
        this.objToXml(out, IntegrationErrorCollection.class, (Object)integrationErrorCollection, false);
    }

    public void write(OutputStream out, IntegrationErrorCollection integrationErrorCollection, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, IntegrationErrorCollection.class, (Object)integrationErrorCollection, prettyPrint);
    }

    public byte[] toByteArray(IntegrationErrorCollection integrationErrorCollection) throws SerializerException {
        return this.objToXml(IntegrationErrorCollection.class, integrationErrorCollection, false).toByteArray();
    }

    public byte[] toByteArray(IntegrationErrorCollection integrationErrorCollection, boolean prettyPrint) throws SerializerException {
        return this.objToXml(IntegrationErrorCollection.class, integrationErrorCollection, prettyPrint).toByteArray();
    }

    public String toString(IntegrationErrorCollection integrationErrorCollection) throws SerializerException {
        return this.objToXml(IntegrationErrorCollection.class, integrationErrorCollection, false).toString();
    }

    public String toString(IntegrationErrorCollection integrationErrorCollection, boolean prettyPrint) throws SerializerException {
        return this.objToXml(IntegrationErrorCollection.class, integrationErrorCollection, prettyPrint).toString();
    }

    public void write(String fileName, SoapConfiguration soapConfiguration) throws SerializerException {
        this.objToXml(fileName, SoapConfiguration.class, (Object)soapConfiguration, false);
    }

    public void write(String fileName, SoapConfiguration soapConfiguration, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, SoapConfiguration.class, (Object)soapConfiguration, prettyPrint);
    }

    public void write(File file, SoapConfiguration soapConfiguration) throws SerializerException {
        this.objToXml(file, SoapConfiguration.class, (Object)soapConfiguration, false);
    }

    public void write(File file, SoapConfiguration soapConfiguration, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, SoapConfiguration.class, (Object)soapConfiguration, prettyPrint);
    }

    public void write(OutputStream out, SoapConfiguration soapConfiguration) throws SerializerException {
        this.objToXml(out, SoapConfiguration.class, (Object)soapConfiguration, false);
    }

    public void write(OutputStream out, SoapConfiguration soapConfiguration, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, SoapConfiguration.class, (Object)soapConfiguration, prettyPrint);
    }

    public byte[] toByteArray(SoapConfiguration soapConfiguration) throws SerializerException {
        return this.objToXml(SoapConfiguration.class, soapConfiguration, false).toByteArray();
    }

    public byte[] toByteArray(SoapConfiguration soapConfiguration, boolean prettyPrint) throws SerializerException {
        return this.objToXml(SoapConfiguration.class, soapConfiguration, prettyPrint).toByteArray();
    }

    public String toString(SoapConfiguration soapConfiguration) throws SerializerException {
        return this.objToXml(SoapConfiguration.class, soapConfiguration, false).toString();
    }

    public String toString(SoapConfiguration soapConfiguration, boolean prettyPrint) throws SerializerException {
        return this.objToXml(SoapConfiguration.class, soapConfiguration, prettyPrint).toString();
    }

    public void write(String fileName, IntegrationError integrationError) throws SerializerException {
        this.objToXml(fileName, IntegrationError.class, (Object)integrationError, false);
    }

    public void write(String fileName, IntegrationError integrationError, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, IntegrationError.class, (Object)integrationError, prettyPrint);
    }

    public void write(File file, IntegrationError integrationError) throws SerializerException {
        this.objToXml(file, IntegrationError.class, (Object)integrationError, false);
    }

    public void write(File file, IntegrationError integrationError, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, IntegrationError.class, (Object)integrationError, prettyPrint);
    }

    public void write(OutputStream out, IntegrationError integrationError) throws SerializerException {
        this.objToXml(out, IntegrationError.class, (Object)integrationError, false);
    }

    public void write(OutputStream out, IntegrationError integrationError, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, IntegrationError.class, (Object)integrationError, prettyPrint);
    }

    public byte[] toByteArray(IntegrationError integrationError) throws SerializerException {
        return this.objToXml(IntegrationError.class, integrationError, false).toByteArray();
    }

    public byte[] toByteArray(IntegrationError integrationError, boolean prettyPrint) throws SerializerException {
        return this.objToXml(IntegrationError.class, integrationError, prettyPrint).toByteArray();
    }

    public String toString(IntegrationError integrationError) throws SerializerException {
        return this.objToXml(IntegrationError.class, integrationError, false).toString();
    }

    public String toString(IntegrationError integrationError, boolean prettyPrint) throws SerializerException {
        return this.objToXml(IntegrationError.class, integrationError, prettyPrint).toString();
    }

    public void write(String fileName, IntegrationConfigurationElementName integrationConfigurationElementName) throws SerializerException {
        this.objToXml(fileName, IntegrationConfigurationElementName.class, (Object)integrationConfigurationElementName, false);
    }

    public void write(String fileName, IntegrationConfigurationElementName integrationConfigurationElementName, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, IntegrationConfigurationElementName.class, (Object)integrationConfigurationElementName, prettyPrint);
    }

    public void write(File file, IntegrationConfigurationElementName integrationConfigurationElementName) throws SerializerException {
        this.objToXml(file, IntegrationConfigurationElementName.class, (Object)integrationConfigurationElementName, false);
    }

    public void write(File file, IntegrationConfigurationElementName integrationConfigurationElementName, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, IntegrationConfigurationElementName.class, (Object)integrationConfigurationElementName, prettyPrint);
    }

    public void write(OutputStream out, IntegrationConfigurationElementName integrationConfigurationElementName) throws SerializerException {
        this.objToXml(out, IntegrationConfigurationElementName.class, (Object)integrationConfigurationElementName, false);
    }

    public void write(OutputStream out, IntegrationConfigurationElementName integrationConfigurationElementName, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, IntegrationConfigurationElementName.class, (Object)integrationConfigurationElementName, prettyPrint);
    }

    public byte[] toByteArray(IntegrationConfigurationElementName integrationConfigurationElementName) throws SerializerException {
        return this.objToXml(IntegrationConfigurationElementName.class, integrationConfigurationElementName, false).toByteArray();
    }

    public byte[] toByteArray(IntegrationConfigurationElementName integrationConfigurationElementName, boolean prettyPrint) throws SerializerException {
        return this.objToXml(IntegrationConfigurationElementName.class, integrationConfigurationElementName, prettyPrint).toByteArray();
    }

    public String toString(IntegrationConfigurationElementName integrationConfigurationElementName) throws SerializerException {
        return this.objToXml(IntegrationConfigurationElementName.class, integrationConfigurationElementName, false).toString();
    }

    public String toString(IntegrationConfigurationElementName integrationConfigurationElementName, boolean prettyPrint) throws SerializerException {
        return this.objToXml(IntegrationConfigurationElementName.class, integrationConfigurationElementName, prettyPrint).toString();
    }

    public void write(String fileName, IntegrationConfigurationName integrationConfigurationName) throws SerializerException {
        this.objToXml(fileName, IntegrationConfigurationName.class, (Object)integrationConfigurationName, false);
    }

    public void write(String fileName, IntegrationConfigurationName integrationConfigurationName, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, IntegrationConfigurationName.class, (Object)integrationConfigurationName, prettyPrint);
    }

    public void write(File file, IntegrationConfigurationName integrationConfigurationName) throws SerializerException {
        this.objToXml(file, IntegrationConfigurationName.class, (Object)integrationConfigurationName, false);
    }

    public void write(File file, IntegrationConfigurationName integrationConfigurationName, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, IntegrationConfigurationName.class, (Object)integrationConfigurationName, prettyPrint);
    }

    public void write(OutputStream out, IntegrationConfigurationName integrationConfigurationName) throws SerializerException {
        this.objToXml(out, IntegrationConfigurationName.class, (Object)integrationConfigurationName, false);
    }

    public void write(OutputStream out, IntegrationConfigurationName integrationConfigurationName, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, IntegrationConfigurationName.class, (Object)integrationConfigurationName, prettyPrint);
    }

    public byte[] toByteArray(IntegrationConfigurationName integrationConfigurationName) throws SerializerException {
        return this.objToXml(IntegrationConfigurationName.class, integrationConfigurationName, false).toByteArray();
    }

    public byte[] toByteArray(IntegrationConfigurationName integrationConfigurationName, boolean prettyPrint) throws SerializerException {
        return this.objToXml(IntegrationConfigurationName.class, integrationConfigurationName, prettyPrint).toByteArray();
    }

    public String toString(IntegrationConfigurationName integrationConfigurationName) throws SerializerException {
        return this.objToXml(IntegrationConfigurationName.class, integrationConfigurationName, false).toString();
    }

    public String toString(IntegrationConfigurationName integrationConfigurationName, boolean prettyPrint) throws SerializerException {
        return this.objToXml(IntegrationConfigurationName.class, integrationConfigurationName, prettyPrint).toString();
    }

    public void write(String fileName, IntegrationConfiguration integrationConfiguration) throws SerializerException {
        this.objToXml(fileName, IntegrationConfiguration.class, (Object)integrationConfiguration, false);
    }

    public void write(String fileName, IntegrationConfiguration integrationConfiguration, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, IntegrationConfiguration.class, (Object)integrationConfiguration, prettyPrint);
    }

    public void write(File file, IntegrationConfiguration integrationConfiguration) throws SerializerException {
        this.objToXml(file, IntegrationConfiguration.class, (Object)integrationConfiguration, false);
    }

    public void write(File file, IntegrationConfiguration integrationConfiguration, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, IntegrationConfiguration.class, (Object)integrationConfiguration, prettyPrint);
    }

    public void write(OutputStream out, IntegrationConfiguration integrationConfiguration) throws SerializerException {
        this.objToXml(out, IntegrationConfiguration.class, (Object)integrationConfiguration, false);
    }

    public void write(OutputStream out, IntegrationConfiguration integrationConfiguration, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, IntegrationConfiguration.class, (Object)integrationConfiguration, prettyPrint);
    }

    public byte[] toByteArray(IntegrationConfiguration integrationConfiguration) throws SerializerException {
        return this.objToXml(IntegrationConfiguration.class, integrationConfiguration, false).toByteArray();
    }

    public byte[] toByteArray(IntegrationConfiguration integrationConfiguration, boolean prettyPrint) throws SerializerException {
        return this.objToXml(IntegrationConfiguration.class, integrationConfiguration, prettyPrint).toByteArray();
    }

    public String toString(IntegrationConfiguration integrationConfiguration) throws SerializerException {
        return this.objToXml(IntegrationConfiguration.class, integrationConfiguration, false).toString();
    }

    public String toString(IntegrationConfiguration integrationConfiguration, boolean prettyPrint) throws SerializerException {
        return this.objToXml(IntegrationConfiguration.class, integrationConfiguration, prettyPrint).toString();
    }

    public void write(String fileName, IntegrationConfigurationResourceIdentification integrationConfigurationResourceIdentification) throws SerializerException {
        this.objToXml(fileName, IntegrationConfigurationResourceIdentification.class, (Object)integrationConfigurationResourceIdentification, false);
    }

    public void write(String fileName, IntegrationConfigurationResourceIdentification integrationConfigurationResourceIdentification, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, IntegrationConfigurationResourceIdentification.class, (Object)integrationConfigurationResourceIdentification, prettyPrint);
    }

    public void write(File file, IntegrationConfigurationResourceIdentification integrationConfigurationResourceIdentification) throws SerializerException {
        this.objToXml(file, IntegrationConfigurationResourceIdentification.class, (Object)integrationConfigurationResourceIdentification, false);
    }

    public void write(File file, IntegrationConfigurationResourceIdentification integrationConfigurationResourceIdentification, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, IntegrationConfigurationResourceIdentification.class, (Object)integrationConfigurationResourceIdentification, prettyPrint);
    }

    public void write(OutputStream out, IntegrationConfigurationResourceIdentification integrationConfigurationResourceIdentification) throws SerializerException {
        this.objToXml(out, IntegrationConfigurationResourceIdentification.class, (Object)integrationConfigurationResourceIdentification, false);
    }

    public void write(OutputStream out, IntegrationConfigurationResourceIdentification integrationConfigurationResourceIdentification, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, IntegrationConfigurationResourceIdentification.class, (Object)integrationConfigurationResourceIdentification, prettyPrint);
    }

    public byte[] toByteArray(IntegrationConfigurationResourceIdentification integrationConfigurationResourceIdentification) throws SerializerException {
        return this.objToXml(IntegrationConfigurationResourceIdentification.class, integrationConfigurationResourceIdentification, false).toByteArray();
    }

    public byte[] toByteArray(IntegrationConfigurationResourceIdentification integrationConfigurationResourceIdentification, boolean prettyPrint) throws SerializerException {
        return this.objToXml(IntegrationConfigurationResourceIdentification.class, integrationConfigurationResourceIdentification, prettyPrint).toByteArray();
    }

    public String toString(IntegrationConfigurationResourceIdentification integrationConfigurationResourceIdentification) throws SerializerException {
        return this.objToXml(IntegrationConfigurationResourceIdentification.class, integrationConfigurationResourceIdentification, false).toString();
    }

    public String toString(IntegrationConfigurationResourceIdentification integrationConfigurationResourceIdentification, boolean prettyPrint) throws SerializerException {
        return this.objToXml(IntegrationConfigurationResourceIdentification.class, integrationConfigurationResourceIdentification, prettyPrint).toString();
    }

    public void write(String fileName, IntegrationConfigurationResourceIdentificationModes integrationConfigurationResourceIdentificationModes) throws SerializerException {
        this.objToXml(fileName, IntegrationConfigurationResourceIdentificationModes.class, (Object)integrationConfigurationResourceIdentificationModes, false);
    }

    public void write(String fileName, IntegrationConfigurationResourceIdentificationModes integrationConfigurationResourceIdentificationModes, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, IntegrationConfigurationResourceIdentificationModes.class, (Object)integrationConfigurationResourceIdentificationModes, prettyPrint);
    }

    public void write(File file, IntegrationConfigurationResourceIdentificationModes integrationConfigurationResourceIdentificationModes) throws SerializerException {
        this.objToXml(file, IntegrationConfigurationResourceIdentificationModes.class, (Object)integrationConfigurationResourceIdentificationModes, false);
    }

    public void write(File file, IntegrationConfigurationResourceIdentificationModes integrationConfigurationResourceIdentificationModes, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, IntegrationConfigurationResourceIdentificationModes.class, (Object)integrationConfigurationResourceIdentificationModes, prettyPrint);
    }

    public void write(OutputStream out, IntegrationConfigurationResourceIdentificationModes integrationConfigurationResourceIdentificationModes) throws SerializerException {
        this.objToXml(out, IntegrationConfigurationResourceIdentificationModes.class, (Object)integrationConfigurationResourceIdentificationModes, false);
    }

    public void write(OutputStream out, IntegrationConfigurationResourceIdentificationModes integrationConfigurationResourceIdentificationModes, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, IntegrationConfigurationResourceIdentificationModes.class, (Object)integrationConfigurationResourceIdentificationModes, prettyPrint);
    }

    public byte[] toByteArray(IntegrationConfigurationResourceIdentificationModes integrationConfigurationResourceIdentificationModes) throws SerializerException {
        return this.objToXml(IntegrationConfigurationResourceIdentificationModes.class, integrationConfigurationResourceIdentificationModes, false).toByteArray();
    }

    public byte[] toByteArray(IntegrationConfigurationResourceIdentificationModes integrationConfigurationResourceIdentificationModes, boolean prettyPrint) throws SerializerException {
        return this.objToXml(IntegrationConfigurationResourceIdentificationModes.class, integrationConfigurationResourceIdentificationModes, prettyPrint).toByteArray();
    }

    public String toString(IntegrationConfigurationResourceIdentificationModes integrationConfigurationResourceIdentificationModes) throws SerializerException {
        return this.objToXml(IntegrationConfigurationResourceIdentificationModes.class, integrationConfigurationResourceIdentificationModes, false).toString();
    }

    public String toString(IntegrationConfigurationResourceIdentificationModes integrationConfigurationResourceIdentificationModes, boolean prettyPrint) throws SerializerException {
        return this.objToXml(IntegrationConfigurationResourceIdentificationModes.class, integrationConfigurationResourceIdentificationModes, prettyPrint).toString();
    }

    public void write(String fileName, IntegrationConfigurationResourceIdentificationSpecificResource integrationConfigurationResourceIdentificationSpecificResource) throws SerializerException {
        this.objToXml(fileName, IntegrationConfigurationResourceIdentificationSpecificResource.class, (Object)integrationConfigurationResourceIdentificationSpecificResource, false);
    }

    public void write(String fileName, IntegrationConfigurationResourceIdentificationSpecificResource integrationConfigurationResourceIdentificationSpecificResource, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, IntegrationConfigurationResourceIdentificationSpecificResource.class, (Object)integrationConfigurationResourceIdentificationSpecificResource, prettyPrint);
    }

    public void write(File file, IntegrationConfigurationResourceIdentificationSpecificResource integrationConfigurationResourceIdentificationSpecificResource) throws SerializerException {
        this.objToXml(file, IntegrationConfigurationResourceIdentificationSpecificResource.class, (Object)integrationConfigurationResourceIdentificationSpecificResource, false);
    }

    public void write(File file, IntegrationConfigurationResourceIdentificationSpecificResource integrationConfigurationResourceIdentificationSpecificResource, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, IntegrationConfigurationResourceIdentificationSpecificResource.class, (Object)integrationConfigurationResourceIdentificationSpecificResource, prettyPrint);
    }

    public void write(OutputStream out, IntegrationConfigurationResourceIdentificationSpecificResource integrationConfigurationResourceIdentificationSpecificResource) throws SerializerException {
        this.objToXml(out, IntegrationConfigurationResourceIdentificationSpecificResource.class, (Object)integrationConfigurationResourceIdentificationSpecificResource, false);
    }

    public void write(OutputStream out, IntegrationConfigurationResourceIdentificationSpecificResource integrationConfigurationResourceIdentificationSpecificResource, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, IntegrationConfigurationResourceIdentificationSpecificResource.class, (Object)integrationConfigurationResourceIdentificationSpecificResource, prettyPrint);
    }

    public byte[] toByteArray(IntegrationConfigurationResourceIdentificationSpecificResource integrationConfigurationResourceIdentificationSpecificResource) throws SerializerException {
        return this.objToXml(IntegrationConfigurationResourceIdentificationSpecificResource.class, integrationConfigurationResourceIdentificationSpecificResource, false).toByteArray();
    }

    public byte[] toByteArray(IntegrationConfigurationResourceIdentificationSpecificResource integrationConfigurationResourceIdentificationSpecificResource, boolean prettyPrint) throws SerializerException {
        return this.objToXml(IntegrationConfigurationResourceIdentificationSpecificResource.class, integrationConfigurationResourceIdentificationSpecificResource, prettyPrint).toByteArray();
    }

    public String toString(IntegrationConfigurationResourceIdentificationSpecificResource integrationConfigurationResourceIdentificationSpecificResource) throws SerializerException {
        return this.objToXml(IntegrationConfigurationResourceIdentificationSpecificResource.class, integrationConfigurationResourceIdentificationSpecificResource, false).toString();
    }

    public String toString(IntegrationConfigurationResourceIdentificationSpecificResource integrationConfigurationResourceIdentificationSpecificResource, boolean prettyPrint) throws SerializerException {
        return this.objToXml(IntegrationConfigurationResourceIdentificationSpecificResource.class, integrationConfigurationResourceIdentificationSpecificResource, prettyPrint).toString();
    }

    public void write(String fileName, SoapHeaderBypassMustUnderstandHeader soapHeaderBypassMustUnderstandHeader) throws SerializerException {
        this.objToXml(fileName, SoapHeaderBypassMustUnderstandHeader.class, (Object)soapHeaderBypassMustUnderstandHeader, false);
    }

    public void write(String fileName, SoapHeaderBypassMustUnderstandHeader soapHeaderBypassMustUnderstandHeader, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, SoapHeaderBypassMustUnderstandHeader.class, (Object)soapHeaderBypassMustUnderstandHeader, prettyPrint);
    }

    public void write(File file, SoapHeaderBypassMustUnderstandHeader soapHeaderBypassMustUnderstandHeader) throws SerializerException {
        this.objToXml(file, SoapHeaderBypassMustUnderstandHeader.class, (Object)soapHeaderBypassMustUnderstandHeader, false);
    }

    public void write(File file, SoapHeaderBypassMustUnderstandHeader soapHeaderBypassMustUnderstandHeader, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, SoapHeaderBypassMustUnderstandHeader.class, (Object)soapHeaderBypassMustUnderstandHeader, prettyPrint);
    }

    public void write(OutputStream out, SoapHeaderBypassMustUnderstandHeader soapHeaderBypassMustUnderstandHeader) throws SerializerException {
        this.objToXml(out, SoapHeaderBypassMustUnderstandHeader.class, (Object)soapHeaderBypassMustUnderstandHeader, false);
    }

    public void write(OutputStream out, SoapHeaderBypassMustUnderstandHeader soapHeaderBypassMustUnderstandHeader, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, SoapHeaderBypassMustUnderstandHeader.class, (Object)soapHeaderBypassMustUnderstandHeader, prettyPrint);
    }

    public byte[] toByteArray(SoapHeaderBypassMustUnderstandHeader soapHeaderBypassMustUnderstandHeader) throws SerializerException {
        return this.objToXml(SoapHeaderBypassMustUnderstandHeader.class, soapHeaderBypassMustUnderstandHeader, false).toByteArray();
    }

    public byte[] toByteArray(SoapHeaderBypassMustUnderstandHeader soapHeaderBypassMustUnderstandHeader, boolean prettyPrint) throws SerializerException {
        return this.objToXml(SoapHeaderBypassMustUnderstandHeader.class, soapHeaderBypassMustUnderstandHeader, prettyPrint).toByteArray();
    }

    public String toString(SoapHeaderBypassMustUnderstandHeader soapHeaderBypassMustUnderstandHeader) throws SerializerException {
        return this.objToXml(SoapHeaderBypassMustUnderstandHeader.class, soapHeaderBypassMustUnderstandHeader, false).toString();
    }

    public String toString(SoapHeaderBypassMustUnderstandHeader soapHeaderBypassMustUnderstandHeader, boolean prettyPrint) throws SerializerException {
        return this.objToXml(SoapHeaderBypassMustUnderstandHeader.class, soapHeaderBypassMustUnderstandHeader, prettyPrint).toString();
    }

    public void write(String fileName, SoapHeaderBypassMustUnderstand soapHeaderBypassMustUnderstand) throws SerializerException {
        this.objToXml(fileName, SoapHeaderBypassMustUnderstand.class, (Object)soapHeaderBypassMustUnderstand, false);
    }

    public void write(String fileName, SoapHeaderBypassMustUnderstand soapHeaderBypassMustUnderstand, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, SoapHeaderBypassMustUnderstand.class, (Object)soapHeaderBypassMustUnderstand, prettyPrint);
    }

    public void write(File file, SoapHeaderBypassMustUnderstand soapHeaderBypassMustUnderstand) throws SerializerException {
        this.objToXml(file, SoapHeaderBypassMustUnderstand.class, (Object)soapHeaderBypassMustUnderstand, false);
    }

    public void write(File file, SoapHeaderBypassMustUnderstand soapHeaderBypassMustUnderstand, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, SoapHeaderBypassMustUnderstand.class, (Object)soapHeaderBypassMustUnderstand, prettyPrint);
    }

    public void write(OutputStream out, SoapHeaderBypassMustUnderstand soapHeaderBypassMustUnderstand) throws SerializerException {
        this.objToXml(out, SoapHeaderBypassMustUnderstand.class, (Object)soapHeaderBypassMustUnderstand, false);
    }

    public void write(OutputStream out, SoapHeaderBypassMustUnderstand soapHeaderBypassMustUnderstand, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, SoapHeaderBypassMustUnderstand.class, (Object)soapHeaderBypassMustUnderstand, prettyPrint);
    }

    public byte[] toByteArray(SoapHeaderBypassMustUnderstand soapHeaderBypassMustUnderstand) throws SerializerException {
        return this.objToXml(SoapHeaderBypassMustUnderstand.class, soapHeaderBypassMustUnderstand, false).toByteArray();
    }

    public byte[] toByteArray(SoapHeaderBypassMustUnderstand soapHeaderBypassMustUnderstand, boolean prettyPrint) throws SerializerException {
        return this.objToXml(SoapHeaderBypassMustUnderstand.class, soapHeaderBypassMustUnderstand, prettyPrint).toByteArray();
    }

    public String toString(SoapHeaderBypassMustUnderstand soapHeaderBypassMustUnderstand) throws SerializerException {
        return this.objToXml(SoapHeaderBypassMustUnderstand.class, soapHeaderBypassMustUnderstand, false).toString();
    }

    public String toString(SoapHeaderBypassMustUnderstand soapHeaderBypassMustUnderstand, boolean prettyPrint) throws SerializerException {
        return this.objToXml(SoapHeaderBypassMustUnderstand.class, soapHeaderBypassMustUnderstand, prettyPrint).toString();
    }

    public void write(String fileName, Organization organization) throws SerializerException {
        this.objToXml(fileName, Organization.class, (Object)organization, false);
    }

    public void write(String fileName, Organization organization, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, Organization.class, (Object)organization, prettyPrint);
    }

    public void write(File file, Organization organization) throws SerializerException {
        this.objToXml(file, Organization.class, (Object)organization, false);
    }

    public void write(File file, Organization organization, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, Organization.class, (Object)organization, prettyPrint);
    }

    public void write(OutputStream out, Organization organization) throws SerializerException {
        this.objToXml(out, Organization.class, (Object)organization, false);
    }

    public void write(OutputStream out, Organization organization, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, Organization.class, (Object)organization, prettyPrint);
    }

    public byte[] toByteArray(Organization organization) throws SerializerException {
        return this.objToXml(Organization.class, organization, false).toByteArray();
    }

    public byte[] toByteArray(Organization organization, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Organization.class, organization, prettyPrint).toByteArray();
    }

    public String toString(Organization organization) throws SerializerException {
        return this.objToXml(Organization.class, organization, false).toString();
    }

    public String toString(Organization organization, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Organization.class, organization, prettyPrint).toString();
    }

    public void write(String fileName, Versions versions) throws SerializerException {
        this.objToXml(fileName, Versions.class, (Object)versions, false);
    }

    public void write(String fileName, Versions versions, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, Versions.class, (Object)versions, prettyPrint);
    }

    public void write(File file, Versions versions) throws SerializerException {
        this.objToXml(file, Versions.class, (Object)versions, false);
    }

    public void write(File file, Versions versions, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, Versions.class, (Object)versions, prettyPrint);
    }

    public void write(OutputStream out, Versions versions) throws SerializerException {
        this.objToXml(out, Versions.class, (Object)versions, false);
    }

    public void write(OutputStream out, Versions versions, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, Versions.class, (Object)versions, prettyPrint);
    }

    public byte[] toByteArray(Versions versions) throws SerializerException {
        return this.objToXml(Versions.class, versions, false).toByteArray();
    }

    public byte[] toByteArray(Versions versions, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Versions.class, versions, prettyPrint).toByteArray();
    }

    public String toString(Versions versions) throws SerializerException {
        return this.objToXml(Versions.class, versions, false).toString();
    }

    public String toString(Versions versions, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Versions.class, versions, prettyPrint).toString();
    }

    public void write(String fileName, SubContextMapping subContextMapping) throws SerializerException {
        this.objToXml(fileName, SubContextMapping.class, (Object)subContextMapping, false);
    }

    public void write(String fileName, SubContextMapping subContextMapping, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, SubContextMapping.class, (Object)subContextMapping, prettyPrint);
    }

    public void write(File file, SubContextMapping subContextMapping) throws SerializerException {
        this.objToXml(file, SubContextMapping.class, (Object)subContextMapping, false);
    }

    public void write(File file, SubContextMapping subContextMapping, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, SubContextMapping.class, (Object)subContextMapping, prettyPrint);
    }

    public void write(OutputStream out, SubContextMapping subContextMapping) throws SerializerException {
        this.objToXml(out, SubContextMapping.class, (Object)subContextMapping, false);
    }

    public void write(OutputStream out, SubContextMapping subContextMapping, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, SubContextMapping.class, (Object)subContextMapping, prettyPrint);
    }

    public byte[] toByteArray(SubContextMapping subContextMapping) throws SerializerException {
        return this.objToXml(SubContextMapping.class, subContextMapping, false).toByteArray();
    }

    public byte[] toByteArray(SubContextMapping subContextMapping, boolean prettyPrint) throws SerializerException {
        return this.objToXml(SubContextMapping.class, subContextMapping, prettyPrint).toByteArray();
    }

    public String toString(SubContextMapping subContextMapping) throws SerializerException {
        return this.objToXml(SubContextMapping.class, subContextMapping, false).toString();
    }

    public String toString(SubContextMapping subContextMapping, boolean prettyPrint) throws SerializerException {
        return this.objToXml(SubContextMapping.class, subContextMapping, prettyPrint).toString();
    }

    public void write(String fileName, WebEmptyContext webEmptyContext) throws SerializerException {
        this.objToXml(fileName, WebEmptyContext.class, (Object)webEmptyContext, false);
    }

    public void write(String fileName, WebEmptyContext webEmptyContext, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, WebEmptyContext.class, (Object)webEmptyContext, prettyPrint);
    }

    public void write(File file, WebEmptyContext webEmptyContext) throws SerializerException {
        this.objToXml(file, WebEmptyContext.class, (Object)webEmptyContext, false);
    }

    public void write(File file, WebEmptyContext webEmptyContext, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, WebEmptyContext.class, (Object)webEmptyContext, prettyPrint);
    }

    public void write(OutputStream out, WebEmptyContext webEmptyContext) throws SerializerException {
        this.objToXml(out, WebEmptyContext.class, (Object)webEmptyContext, false);
    }

    public void write(OutputStream out, WebEmptyContext webEmptyContext, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, WebEmptyContext.class, (Object)webEmptyContext, prettyPrint);
    }

    public byte[] toByteArray(WebEmptyContext webEmptyContext) throws SerializerException {
        return this.objToXml(WebEmptyContext.class, webEmptyContext, false).toByteArray();
    }

    public byte[] toByteArray(WebEmptyContext webEmptyContext, boolean prettyPrint) throws SerializerException {
        return this.objToXml(WebEmptyContext.class, webEmptyContext, prettyPrint).toByteArray();
    }

    public String toString(WebEmptyContext webEmptyContext) throws SerializerException {
        return this.objToXml(WebEmptyContext.class, webEmptyContext, false).toString();
    }

    public String toString(WebEmptyContext webEmptyContext, boolean prettyPrint) throws SerializerException {
        return this.objToXml(WebEmptyContext.class, webEmptyContext, prettyPrint).toString();
    }

    public void write(String fileName, EmptySubContextMapping emptySubContextMapping) throws SerializerException {
        this.objToXml(fileName, EmptySubContextMapping.class, (Object)emptySubContextMapping, false);
    }

    public void write(String fileName, EmptySubContextMapping emptySubContextMapping, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, EmptySubContextMapping.class, (Object)emptySubContextMapping, prettyPrint);
    }

    public void write(File file, EmptySubContextMapping emptySubContextMapping) throws SerializerException {
        this.objToXml(file, EmptySubContextMapping.class, (Object)emptySubContextMapping, false);
    }

    public void write(File file, EmptySubContextMapping emptySubContextMapping, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, EmptySubContextMapping.class, (Object)emptySubContextMapping, prettyPrint);
    }

    public void write(OutputStream out, EmptySubContextMapping emptySubContextMapping) throws SerializerException {
        this.objToXml(out, EmptySubContextMapping.class, (Object)emptySubContextMapping, false);
    }

    public void write(OutputStream out, EmptySubContextMapping emptySubContextMapping, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, EmptySubContextMapping.class, (Object)emptySubContextMapping, prettyPrint);
    }

    public byte[] toByteArray(EmptySubContextMapping emptySubContextMapping) throws SerializerException {
        return this.objToXml(EmptySubContextMapping.class, emptySubContextMapping, false).toByteArray();
    }

    public byte[] toByteArray(EmptySubContextMapping emptySubContextMapping, boolean prettyPrint) throws SerializerException {
        return this.objToXml(EmptySubContextMapping.class, emptySubContextMapping, prettyPrint).toByteArray();
    }

    public String toString(EmptySubContextMapping emptySubContextMapping) throws SerializerException {
        return this.objToXml(EmptySubContextMapping.class, emptySubContextMapping, false).toString();
    }

    public String toString(EmptySubContextMapping emptySubContextMapping, boolean prettyPrint) throws SerializerException {
        return this.objToXml(EmptySubContextMapping.class, emptySubContextMapping, prettyPrint).toString();
    }

    public void write(String fileName, RestMediaTypeMapping restMediaTypeMapping) throws SerializerException {
        this.objToXml(fileName, RestMediaTypeMapping.class, (Object)restMediaTypeMapping, false);
    }

    public void write(String fileName, RestMediaTypeMapping restMediaTypeMapping, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, RestMediaTypeMapping.class, (Object)restMediaTypeMapping, prettyPrint);
    }

    public void write(File file, RestMediaTypeMapping restMediaTypeMapping) throws SerializerException {
        this.objToXml(file, RestMediaTypeMapping.class, (Object)restMediaTypeMapping, false);
    }

    public void write(File file, RestMediaTypeMapping restMediaTypeMapping, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, RestMediaTypeMapping.class, (Object)restMediaTypeMapping, prettyPrint);
    }

    public void write(OutputStream out, RestMediaTypeMapping restMediaTypeMapping) throws SerializerException {
        this.objToXml(out, RestMediaTypeMapping.class, (Object)restMediaTypeMapping, false);
    }

    public void write(OutputStream out, RestMediaTypeMapping restMediaTypeMapping, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, RestMediaTypeMapping.class, (Object)restMediaTypeMapping, prettyPrint);
    }

    public byte[] toByteArray(RestMediaTypeMapping restMediaTypeMapping) throws SerializerException {
        return this.objToXml(RestMediaTypeMapping.class, restMediaTypeMapping, false).toByteArray();
    }

    public byte[] toByteArray(RestMediaTypeMapping restMediaTypeMapping, boolean prettyPrint) throws SerializerException {
        return this.objToXml(RestMediaTypeMapping.class, restMediaTypeMapping, prettyPrint).toByteArray();
    }

    public String toString(RestMediaTypeMapping restMediaTypeMapping) throws SerializerException {
        return this.objToXml(RestMediaTypeMapping.class, restMediaTypeMapping, false).toString();
    }

    public String toString(RestMediaTypeMapping restMediaTypeMapping, boolean prettyPrint) throws SerializerException {
        return this.objToXml(RestMediaTypeMapping.class, restMediaTypeMapping, prettyPrint).toString();
    }

    public void write(String fileName, OrganizationTypes organizationTypes) throws SerializerException {
        this.objToXml(fileName, OrganizationTypes.class, (Object)organizationTypes, false);
    }

    public void write(String fileName, OrganizationTypes organizationTypes, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, OrganizationTypes.class, (Object)organizationTypes, prettyPrint);
    }

    public void write(File file, OrganizationTypes organizationTypes) throws SerializerException {
        this.objToXml(file, OrganizationTypes.class, (Object)organizationTypes, false);
    }

    public void write(File file, OrganizationTypes organizationTypes, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, OrganizationTypes.class, (Object)organizationTypes, prettyPrint);
    }

    public void write(OutputStream out, OrganizationTypes organizationTypes) throws SerializerException {
        this.objToXml(out, OrganizationTypes.class, (Object)organizationTypes, false);
    }

    public void write(OutputStream out, OrganizationTypes organizationTypes, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, OrganizationTypes.class, (Object)organizationTypes, prettyPrint);
    }

    public byte[] toByteArray(OrganizationTypes organizationTypes) throws SerializerException {
        return this.objToXml(OrganizationTypes.class, organizationTypes, false).toByteArray();
    }

    public byte[] toByteArray(OrganizationTypes organizationTypes, boolean prettyPrint) throws SerializerException {
        return this.objToXml(OrganizationTypes.class, organizationTypes, prettyPrint).toByteArray();
    }

    public String toString(OrganizationTypes organizationTypes) throws SerializerException {
        return this.objToXml(OrganizationTypes.class, organizationTypes, false).toString();
    }

    public String toString(OrganizationTypes organizationTypes, boolean prettyPrint) throws SerializerException {
        return this.objToXml(OrganizationTypes.class, organizationTypes, prettyPrint).toString();
    }

    public void write(String fileName, InterfaceConfiguration interfaceConfiguration) throws SerializerException {
        this.objToXml(fileName, InterfaceConfiguration.class, (Object)interfaceConfiguration, false);
    }

    public void write(String fileName, InterfaceConfiguration interfaceConfiguration, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, InterfaceConfiguration.class, (Object)interfaceConfiguration, prettyPrint);
    }

    public void write(File file, InterfaceConfiguration interfaceConfiguration) throws SerializerException {
        this.objToXml(file, InterfaceConfiguration.class, (Object)interfaceConfiguration, false);
    }

    public void write(File file, InterfaceConfiguration interfaceConfiguration, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, InterfaceConfiguration.class, (Object)interfaceConfiguration, prettyPrint);
    }

    public void write(OutputStream out, InterfaceConfiguration interfaceConfiguration) throws SerializerException {
        this.objToXml(out, InterfaceConfiguration.class, (Object)interfaceConfiguration, false);
    }

    public void write(OutputStream out, InterfaceConfiguration interfaceConfiguration, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, InterfaceConfiguration.class, (Object)interfaceConfiguration, prettyPrint);
    }

    public byte[] toByteArray(InterfaceConfiguration interfaceConfiguration) throws SerializerException {
        return this.objToXml(InterfaceConfiguration.class, interfaceConfiguration, false).toByteArray();
    }

    public byte[] toByteArray(InterfaceConfiguration interfaceConfiguration, boolean prettyPrint) throws SerializerException {
        return this.objToXml(InterfaceConfiguration.class, interfaceConfiguration, prettyPrint).toByteArray();
    }

    public String toString(InterfaceConfiguration interfaceConfiguration) throws SerializerException {
        return this.objToXml(InterfaceConfiguration.class, interfaceConfiguration, false).toString();
    }

    public String toString(InterfaceConfiguration interfaceConfiguration, boolean prettyPrint) throws SerializerException {
        return this.objToXml(InterfaceConfiguration.class, interfaceConfiguration, prettyPrint).toString();
    }

    public void write(String fileName, Version version) throws SerializerException {
        this.objToXml(fileName, Version.class, (Object)version, false);
    }

    public void write(String fileName, Version version, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, Version.class, (Object)version, prettyPrint);
    }

    public void write(File file, Version version) throws SerializerException {
        this.objToXml(file, Version.class, (Object)version, false);
    }

    public void write(File file, Version version, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, Version.class, (Object)version, prettyPrint);
    }

    public void write(OutputStream out, Version version) throws SerializerException {
        this.objToXml(out, Version.class, (Object)version, false);
    }

    public void write(OutputStream out, Version version, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, Version.class, (Object)version, prettyPrint);
    }

    public byte[] toByteArray(Version version) throws SerializerException {
        return this.objToXml(Version.class, version, false).toByteArray();
    }

    public byte[] toByteArray(Version version, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Version.class, version, prettyPrint).toByteArray();
    }

    public String toString(Version version) throws SerializerException {
        return this.objToXml(Version.class, version, false).toString();
    }

    public String toString(Version version, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Version.class, version, prettyPrint).toString();
    }

    public void write(String fileName, CollaborationProfile collaborationProfile) throws SerializerException {
        this.objToXml(fileName, CollaborationProfile.class, (Object)collaborationProfile, false);
    }

    public void write(String fileName, CollaborationProfile collaborationProfile, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, CollaborationProfile.class, (Object)collaborationProfile, prettyPrint);
    }

    public void write(File file, CollaborationProfile collaborationProfile) throws SerializerException {
        this.objToXml(file, CollaborationProfile.class, (Object)collaborationProfile, false);
    }

    public void write(File file, CollaborationProfile collaborationProfile, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, CollaborationProfile.class, (Object)collaborationProfile, prettyPrint);
    }

    public void write(OutputStream out, CollaborationProfile collaborationProfile) throws SerializerException {
        this.objToXml(out, CollaborationProfile.class, (Object)collaborationProfile, false);
    }

    public void write(OutputStream out, CollaborationProfile collaborationProfile, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, CollaborationProfile.class, (Object)collaborationProfile, prettyPrint);
    }

    public byte[] toByteArray(CollaborationProfile collaborationProfile) throws SerializerException {
        return this.objToXml(CollaborationProfile.class, collaborationProfile, false).toByteArray();
    }

    public byte[] toByteArray(CollaborationProfile collaborationProfile, boolean prettyPrint) throws SerializerException {
        return this.objToXml(CollaborationProfile.class, collaborationProfile, prettyPrint).toByteArray();
    }

    public String toString(CollaborationProfile collaborationProfile) throws SerializerException {
        return this.objToXml(CollaborationProfile.class, collaborationProfile, false).toString();
    }

    public String toString(CollaborationProfile collaborationProfile, boolean prettyPrint) throws SerializerException {
        return this.objToXml(CollaborationProfile.class, collaborationProfile, prettyPrint).toString();
    }

    public void write(String fileName, ServiceType serviceType) throws SerializerException {
        this.objToXml(fileName, ServiceType.class, (Object)serviceType, false);
    }

    public void write(String fileName, ServiceType serviceType, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, ServiceType.class, (Object)serviceType, prettyPrint);
    }

    public void write(File file, ServiceType serviceType) throws SerializerException {
        this.objToXml(file, ServiceType.class, (Object)serviceType, false);
    }

    public void write(File file, ServiceType serviceType, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, ServiceType.class, (Object)serviceType, prettyPrint);
    }

    public void write(OutputStream out, ServiceType serviceType) throws SerializerException {
        this.objToXml(out, ServiceType.class, (Object)serviceType, false);
    }

    public void write(OutputStream out, ServiceType serviceType, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, ServiceType.class, (Object)serviceType, prettyPrint);
    }

    public byte[] toByteArray(ServiceType serviceType) throws SerializerException {
        return this.objToXml(ServiceType.class, serviceType, false).toByteArray();
    }

    public byte[] toByteArray(ServiceType serviceType, boolean prettyPrint) throws SerializerException {
        return this.objToXml(ServiceType.class, serviceType, prettyPrint).toByteArray();
    }

    public String toString(ServiceType serviceType) throws SerializerException {
        return this.objToXml(ServiceType.class, serviceType, false).toString();
    }

    public String toString(ServiceType serviceType, boolean prettyPrint) throws SerializerException {
        return this.objToXml(ServiceType.class, serviceType, prettyPrint).toString();
    }

    public void write(String fileName, Transaction transaction) throws SerializerException {
        this.objToXml(fileName, Transaction.class, (Object)transaction, false);
    }

    public void write(String fileName, Transaction transaction, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, Transaction.class, (Object)transaction, prettyPrint);
    }

    public void write(File file, Transaction transaction) throws SerializerException {
        this.objToXml(file, Transaction.class, (Object)transaction, false);
    }

    public void write(File file, Transaction transaction, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, Transaction.class, (Object)transaction, prettyPrint);
    }

    public void write(OutputStream out, Transaction transaction) throws SerializerException {
        this.objToXml(out, Transaction.class, (Object)transaction, false);
    }

    public void write(OutputStream out, Transaction transaction, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, Transaction.class, (Object)transaction, prettyPrint);
    }

    public byte[] toByteArray(Transaction transaction) throws SerializerException {
        return this.objToXml(Transaction.class, transaction, false).toByteArray();
    }

    public byte[] toByteArray(Transaction transaction, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Transaction.class, transaction, prettyPrint).toByteArray();
    }

    public String toString(Transaction transaction) throws SerializerException {
        return this.objToXml(Transaction.class, transaction, false).toString();
    }

    public String toString(Transaction transaction, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Transaction.class, transaction, prettyPrint).toString();
    }

    public void write(String fileName, IntegrationConfigurationResourceIdentificationMode integrationConfigurationResourceIdentificationMode) throws SerializerException {
        this.objToXml(fileName, IntegrationConfigurationResourceIdentificationMode.class, (Object)integrationConfigurationResourceIdentificationMode, false);
    }

    public void write(String fileName, IntegrationConfigurationResourceIdentificationMode integrationConfigurationResourceIdentificationMode, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, IntegrationConfigurationResourceIdentificationMode.class, (Object)integrationConfigurationResourceIdentificationMode, prettyPrint);
    }

    public void write(File file, IntegrationConfigurationResourceIdentificationMode integrationConfigurationResourceIdentificationMode) throws SerializerException {
        this.objToXml(file, IntegrationConfigurationResourceIdentificationMode.class, (Object)integrationConfigurationResourceIdentificationMode, false);
    }

    public void write(File file, IntegrationConfigurationResourceIdentificationMode integrationConfigurationResourceIdentificationMode, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, IntegrationConfigurationResourceIdentificationMode.class, (Object)integrationConfigurationResourceIdentificationMode, prettyPrint);
    }

    public void write(OutputStream out, IntegrationConfigurationResourceIdentificationMode integrationConfigurationResourceIdentificationMode) throws SerializerException {
        this.objToXml(out, IntegrationConfigurationResourceIdentificationMode.class, (Object)integrationConfigurationResourceIdentificationMode, false);
    }

    public void write(OutputStream out, IntegrationConfigurationResourceIdentificationMode integrationConfigurationResourceIdentificationMode, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, IntegrationConfigurationResourceIdentificationMode.class, (Object)integrationConfigurationResourceIdentificationMode, prettyPrint);
    }

    public byte[] toByteArray(IntegrationConfigurationResourceIdentificationMode integrationConfigurationResourceIdentificationMode) throws SerializerException {
        return this.objToXml(IntegrationConfigurationResourceIdentificationMode.class, integrationConfigurationResourceIdentificationMode, false).toByteArray();
    }

    public byte[] toByteArray(IntegrationConfigurationResourceIdentificationMode integrationConfigurationResourceIdentificationMode, boolean prettyPrint) throws SerializerException {
        return this.objToXml(IntegrationConfigurationResourceIdentificationMode.class, integrationConfigurationResourceIdentificationMode, prettyPrint).toByteArray();
    }

    public String toString(IntegrationConfigurationResourceIdentificationMode integrationConfigurationResourceIdentificationMode) throws SerializerException {
        return this.objToXml(IntegrationConfigurationResourceIdentificationMode.class, integrationConfigurationResourceIdentificationMode, false).toString();
    }

    public String toString(IntegrationConfigurationResourceIdentificationMode integrationConfigurationResourceIdentificationMode, boolean prettyPrint) throws SerializerException {
        return this.objToXml(IntegrationConfigurationResourceIdentificationMode.class, integrationConfigurationResourceIdentificationMode, prettyPrint).toString();
    }

    public void write(String fileName, RFC7807 rfC7807) throws SerializerException {
        this.objToXml(fileName, RFC7807.class, (Object)rfC7807, false);
    }

    public void write(String fileName, RFC7807 rfC7807, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, RFC7807.class, (Object)rfC7807, prettyPrint);
    }

    public void write(File file, RFC7807 rfC7807) throws SerializerException {
        this.objToXml(file, RFC7807.class, (Object)rfC7807, false);
    }

    public void write(File file, RFC7807 rfC7807, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, RFC7807.class, (Object)rfC7807, prettyPrint);
    }

    public void write(OutputStream out, RFC7807 rfC7807) throws SerializerException {
        this.objToXml(out, RFC7807.class, (Object)rfC7807, false);
    }

    public void write(OutputStream out, RFC7807 rfC7807, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, RFC7807.class, (Object)rfC7807, prettyPrint);
    }

    public byte[] toByteArray(RFC7807 rfC7807) throws SerializerException {
        return this.objToXml(RFC7807.class, rfC7807, false).toByteArray();
    }

    public byte[] toByteArray(RFC7807 rfC7807, boolean prettyPrint) throws SerializerException {
        return this.objToXml(RFC7807.class, rfC7807, prettyPrint).toByteArray();
    }

    public String toString(RFC7807 rfC7807) throws SerializerException {
        return this.objToXml(RFC7807.class, rfC7807, false).toString();
    }

    public String toString(RFC7807 rfC7807, boolean prettyPrint) throws SerializerException {
        return this.objToXml(RFC7807.class, rfC7807, prettyPrint).toString();
    }

    public void write(String fileName, RestMediaTypeDefaultMapping restMediaTypeDefaultMapping) throws SerializerException {
        this.objToXml(fileName, RestMediaTypeDefaultMapping.class, (Object)restMediaTypeDefaultMapping, false);
    }

    public void write(String fileName, RestMediaTypeDefaultMapping restMediaTypeDefaultMapping, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, RestMediaTypeDefaultMapping.class, (Object)restMediaTypeDefaultMapping, prettyPrint);
    }

    public void write(File file, RestMediaTypeDefaultMapping restMediaTypeDefaultMapping) throws SerializerException {
        this.objToXml(file, RestMediaTypeDefaultMapping.class, (Object)restMediaTypeDefaultMapping, false);
    }

    public void write(File file, RestMediaTypeDefaultMapping restMediaTypeDefaultMapping, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, RestMediaTypeDefaultMapping.class, (Object)restMediaTypeDefaultMapping, prettyPrint);
    }

    public void write(OutputStream out, RestMediaTypeDefaultMapping restMediaTypeDefaultMapping) throws SerializerException {
        this.objToXml(out, RestMediaTypeDefaultMapping.class, (Object)restMediaTypeDefaultMapping, false);
    }

    public void write(OutputStream out, RestMediaTypeDefaultMapping restMediaTypeDefaultMapping, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, RestMediaTypeDefaultMapping.class, (Object)restMediaTypeDefaultMapping, prettyPrint);
    }

    public byte[] toByteArray(RestMediaTypeDefaultMapping restMediaTypeDefaultMapping) throws SerializerException {
        return this.objToXml(RestMediaTypeDefaultMapping.class, restMediaTypeDefaultMapping, false).toByteArray();
    }

    public byte[] toByteArray(RestMediaTypeDefaultMapping restMediaTypeDefaultMapping, boolean prettyPrint) throws SerializerException {
        return this.objToXml(RestMediaTypeDefaultMapping.class, restMediaTypeDefaultMapping, prettyPrint).toByteArray();
    }

    public String toString(RestMediaTypeDefaultMapping restMediaTypeDefaultMapping) throws SerializerException {
        return this.objToXml(RestMediaTypeDefaultMapping.class, restMediaTypeDefaultMapping, false).toString();
    }

    public String toString(RestMediaTypeDefaultMapping restMediaTypeDefaultMapping, boolean prettyPrint) throws SerializerException {
        return this.objToXml(RestMediaTypeDefaultMapping.class, restMediaTypeDefaultMapping, prettyPrint).toString();
    }

    public void write(String fileName, RestMediaTypeUndefinedMapping restMediaTypeUndefinedMapping) throws SerializerException {
        this.objToXml(fileName, RestMediaTypeUndefinedMapping.class, (Object)restMediaTypeUndefinedMapping, false);
    }

    public void write(String fileName, RestMediaTypeUndefinedMapping restMediaTypeUndefinedMapping, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, RestMediaTypeUndefinedMapping.class, (Object)restMediaTypeUndefinedMapping, prettyPrint);
    }

    public void write(File file, RestMediaTypeUndefinedMapping restMediaTypeUndefinedMapping) throws SerializerException {
        this.objToXml(file, RestMediaTypeUndefinedMapping.class, (Object)restMediaTypeUndefinedMapping, false);
    }

    public void write(File file, RestMediaTypeUndefinedMapping restMediaTypeUndefinedMapping, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, RestMediaTypeUndefinedMapping.class, (Object)restMediaTypeUndefinedMapping, prettyPrint);
    }

    public void write(OutputStream out, RestMediaTypeUndefinedMapping restMediaTypeUndefinedMapping) throws SerializerException {
        this.objToXml(out, RestMediaTypeUndefinedMapping.class, (Object)restMediaTypeUndefinedMapping, false);
    }

    public void write(OutputStream out, RestMediaTypeUndefinedMapping restMediaTypeUndefinedMapping, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, RestMediaTypeUndefinedMapping.class, (Object)restMediaTypeUndefinedMapping, prettyPrint);
    }

    public byte[] toByteArray(RestMediaTypeUndefinedMapping restMediaTypeUndefinedMapping) throws SerializerException {
        return this.objToXml(RestMediaTypeUndefinedMapping.class, restMediaTypeUndefinedMapping, false).toByteArray();
    }

    public byte[] toByteArray(RestMediaTypeUndefinedMapping restMediaTypeUndefinedMapping, boolean prettyPrint) throws SerializerException {
        return this.objToXml(RestMediaTypeUndefinedMapping.class, restMediaTypeUndefinedMapping, prettyPrint).toByteArray();
    }

    public String toString(RestMediaTypeUndefinedMapping restMediaTypeUndefinedMapping) throws SerializerException {
        return this.objToXml(RestMediaTypeUndefinedMapping.class, restMediaTypeUndefinedMapping, false).toString();
    }

    public String toString(RestMediaTypeUndefinedMapping restMediaTypeUndefinedMapping, boolean prettyPrint) throws SerializerException {
        return this.objToXml(RestMediaTypeUndefinedMapping.class, restMediaTypeUndefinedMapping, prettyPrint).toString();
    }

    public void write(String fileName, OrganizationType organizationType) throws SerializerException {
        this.objToXml(fileName, OrganizationType.class, (Object)organizationType, false);
    }

    public void write(String fileName, OrganizationType organizationType, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, OrganizationType.class, (Object)organizationType, prettyPrint);
    }

    public void write(File file, OrganizationType organizationType) throws SerializerException {
        this.objToXml(file, OrganizationType.class, (Object)organizationType, false);
    }

    public void write(File file, OrganizationType organizationType, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, OrganizationType.class, (Object)organizationType, prettyPrint);
    }

    public void write(OutputStream out, OrganizationType organizationType) throws SerializerException {
        this.objToXml(out, OrganizationType.class, (Object)organizationType, false);
    }

    public void write(OutputStream out, OrganizationType organizationType, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, OrganizationType.class, (Object)organizationType, prettyPrint);
    }

    public byte[] toByteArray(OrganizationType organizationType) throws SerializerException {
        return this.objToXml(OrganizationType.class, organizationType, false).toByteArray();
    }

    public byte[] toByteArray(OrganizationType organizationType, boolean prettyPrint) throws SerializerException {
        return this.objToXml(OrganizationType.class, organizationType, prettyPrint).toByteArray();
    }

    public String toString(OrganizationType organizationType) throws SerializerException {
        return this.objToXml(OrganizationType.class, organizationType, false).toString();
    }

    public String toString(OrganizationType organizationType, boolean prettyPrint) throws SerializerException {
        return this.objToXml(OrganizationType.class, organizationType, prettyPrint).toString();
    }

    public void write(String fileName, Context context) throws SerializerException {
        this.objToXml(fileName, Context.class, (Object)context, false);
    }

    public void write(String fileName, Context context, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, Context.class, (Object)context, prettyPrint);
    }

    public void write(File file, Context context) throws SerializerException {
        this.objToXml(file, Context.class, (Object)context, false);
    }

    public void write(File file, Context context, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, Context.class, (Object)context, prettyPrint);
    }

    public void write(OutputStream out, Context context) throws SerializerException {
        this.objToXml(out, Context.class, (Object)context, false);
    }

    public void write(OutputStream out, Context context, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, Context.class, (Object)context, prettyPrint);
    }

    public byte[] toByteArray(Context context) throws SerializerException {
        return this.objToXml(Context.class, context, false).toByteArray();
    }

    public byte[] toByteArray(Context context, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Context.class, context, prettyPrint).toByteArray();
    }

    public String toString(Context context) throws SerializerException {
        return this.objToXml(Context.class, context, false).toString();
    }

    public String toString(Context context, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Context.class, context, prettyPrint).toString();
    }

    public void write(String fileName, DefaultIntegrationError defaultIntegrationError) throws SerializerException {
        this.objToXml(fileName, DefaultIntegrationError.class, (Object)defaultIntegrationError, false);
    }

    public void write(String fileName, DefaultIntegrationError defaultIntegrationError, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, DefaultIntegrationError.class, (Object)defaultIntegrationError, prettyPrint);
    }

    public void write(File file, DefaultIntegrationError defaultIntegrationError) throws SerializerException {
        this.objToXml(file, DefaultIntegrationError.class, (Object)defaultIntegrationError, false);
    }

    public void write(File file, DefaultIntegrationError defaultIntegrationError, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, DefaultIntegrationError.class, (Object)defaultIntegrationError, prettyPrint);
    }

    public void write(OutputStream out, DefaultIntegrationError defaultIntegrationError) throws SerializerException {
        this.objToXml(out, DefaultIntegrationError.class, (Object)defaultIntegrationError, false);
    }

    public void write(OutputStream out, DefaultIntegrationError defaultIntegrationError, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, DefaultIntegrationError.class, (Object)defaultIntegrationError, prettyPrint);
    }

    public byte[] toByteArray(DefaultIntegrationError defaultIntegrationError) throws SerializerException {
        return this.objToXml(DefaultIntegrationError.class, defaultIntegrationError, false).toByteArray();
    }

    public byte[] toByteArray(DefaultIntegrationError defaultIntegrationError, boolean prettyPrint) throws SerializerException {
        return this.objToXml(DefaultIntegrationError.class, defaultIntegrationError, prettyPrint).toByteArray();
    }

    public String toString(DefaultIntegrationError defaultIntegrationError) throws SerializerException {
        return this.objToXml(DefaultIntegrationError.class, defaultIntegrationError, false).toString();
    }

    public String toString(DefaultIntegrationError defaultIntegrationError, boolean prettyPrint) throws SerializerException {
        return this.objToXml(DefaultIntegrationError.class, defaultIntegrationError, prettyPrint).toString();
    }
}

