/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.registry;

import java.io.Serializable;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openspcoop2.core.byok.IDriverBYOK;
import org.openspcoop2.core.commons.ConnettoreHTTPSProperties;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.commons.IMonitoraggioRisorsa;
import org.openspcoop2.core.config.AccessoRegistro;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.constants.CostantiDB;
import org.openspcoop2.core.constants.CostantiLabel;
import org.openspcoop2.core.constants.StatoCheck;
import org.openspcoop2.core.constants.TipiConnettore;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDAccordoAzione;
import org.openspcoop2.core.id.IDAccordoCooperazione;
import org.openspcoop2.core.id.IDFruizione;
import org.openspcoop2.core.id.IDGruppo;
import org.openspcoop2.core.id.IDPortType;
import org.openspcoop2.core.id.IDPortTypeAzione;
import org.openspcoop2.core.id.IDResource;
import org.openspcoop2.core.id.IDRuolo;
import org.openspcoop2.core.id.IDScope;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoCooperazione;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.Azione;
import org.openspcoop2.core.registry.ConfigurazioneServizioAzione;
import org.openspcoop2.core.registry.Connettore;
import org.openspcoop2.core.registry.CredenzialiSoggetto;
import org.openspcoop2.core.registry.Documento;
import org.openspcoop2.core.registry.Fruitore;
import org.openspcoop2.core.registry.Operation;
import org.openspcoop2.core.registry.PortType;
import org.openspcoop2.core.registry.PortaDominio;
import org.openspcoop2.core.registry.Proprieta;
import org.openspcoop2.core.registry.Resource;
import org.openspcoop2.core.registry.Ruolo;
import org.openspcoop2.core.registry.Scope;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.constants.CostantiRegistroServizi;
import org.openspcoop2.core.registry.constants.CredenzialeTipo;
import org.openspcoop2.core.registry.constants.ProfiloCollaborazione;
import org.openspcoop2.core.registry.constants.ServiceBinding;
import org.openspcoop2.core.registry.constants.StatoFunzionalita;
import org.openspcoop2.core.registry.constants.TipiDocumentoLivelloServizio;
import org.openspcoop2.core.registry.constants.TipiDocumentoSemiformale;
import org.openspcoop2.core.registry.constants.TipiDocumentoSicurezza;
import org.openspcoop2.core.registry.constants.TipologiaServizio;
import org.openspcoop2.core.registry.driver.BeanUtilities;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziAzioneNotFound;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziCorrelatoNotFound;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziPortTypeNotFound;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziServizioNotFound;
import org.openspcoop2.core.registry.driver.FiltroRicerca;
import org.openspcoop2.core.registry.driver.FiltroRicercaAccordi;
import org.openspcoop2.core.registry.driver.FiltroRicercaAzioni;
import org.openspcoop2.core.registry.driver.FiltroRicercaFruizioniServizio;
import org.openspcoop2.core.registry.driver.FiltroRicercaGruppi;
import org.openspcoop2.core.registry.driver.FiltroRicercaOperations;
import org.openspcoop2.core.registry.driver.FiltroRicercaPortTypes;
import org.openspcoop2.core.registry.driver.FiltroRicercaResources;
import org.openspcoop2.core.registry.driver.FiltroRicercaRuoli;
import org.openspcoop2.core.registry.driver.FiltroRicercaScope;
import org.openspcoop2.core.registry.driver.FiltroRicercaServizi;
import org.openspcoop2.core.registry.driver.FiltroRicercaSoggetti;
import org.openspcoop2.core.registry.driver.IDAccordoCooperazioneFactory;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.core.registry.driver.IDriverRegistroServiziGet;
import org.openspcoop2.core.registry.driver.ValidazioneSemantica;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB;
import org.openspcoop2.core.registry.driver.xml.DriverRegistroServiziXML;
import org.openspcoop2.core.registry.rest.AccordoServizioWrapper;
import org.openspcoop2.core.registry.utils.RegistroServiziUtils;
import org.openspcoop2.protocol.registry.Allegati;
import org.openspcoop2.protocol.registry.CertificateCheck;
import org.openspcoop2.protocol.registry.CertificateUtils;
import org.openspcoop2.protocol.registry.EsitoAutorizzazioneRegistro;
import org.openspcoop2.protocol.registry.RegistroServizi;
import org.openspcoop2.protocol.registry.RegistroServiziManager;
import org.openspcoop2.protocol.registry.RisultatoValidazione;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.Servizio;
import org.openspcoop2.protocol.sdk.constants.InformationApiSource;
import org.openspcoop2.protocol.sdk.constants.Inoltro;
import org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.protocol.utils.ModISecurityUtils;
import org.openspcoop2.protocol.utils.ModIUtils;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.cache.CacheType;
import org.openspcoop2.utils.certificate.CertificateInfo;
import org.openspcoop2.utils.certificate.KeystoreParams;
import org.openspcoop2.utils.certificate.PrincipalType;
import org.openspcoop2.utils.certificate.remote.RemoteStoreConfig;
import org.openspcoop2.utils.crypt.CryptConfig;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.transport.http.IBYOKUnwrapFactory;
import org.openspcoop2.utils.transport.http.IBYOKUnwrapManager;
import org.slf4j.Logger;

public class RegistroServiziReader {
    private static RegistroServiziReader registroServiziReader;
    private static boolean initialize;
    private RegistroServizi registroServizi;
    private Logger log = null;
    private IDAccordoFactory idAccordoFactory = IDAccordoFactory.getInstance();
    public static final String ID_CONFIGURAZIONE_CONNETTORE_HTTPS = "Configurazione connettore https";
    public static final String ID_CONFIGURAZIONE_FIRMA_MODI = "Configurazione della firma ModI";
    private static final String ID_CONFIGURAZIONE_DPOP = "Configurazione DPoP";

    public static boolean isCacheAbilitata() throws DriverRegistroServiziException {
        try {
            RegistroServiziReader registroServiziReader = RegistroServiziReader.getInstance();
            if (registroServiziReader != null && registroServiziReader.registroServizi != null) {
                return registroServiziReader.registroServizi.isCacheAbilitata();
            }
            return false;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("IsCacheAbilitata, recupero informazione della cache del registri dei servizi non riuscita: " + e.getMessage(), (Throwable)e);
        }
    }

    public static void resetCache() throws DriverRegistroServiziException {
        try {
            RegistroServiziReader registroServiziReader = RegistroServiziReader.getInstance();
            if (registroServiziReader != null && registroServiziReader.registroServizi != null) {
                registroServiziReader.registroServizi.resetCache();
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Reset della cache di accesso ai registri dei servizi non riuscita: " + e.getMessage(), (Throwable)e);
        }
    }

    public static void prefillCache(CryptConfig cryptConfigSoggetti) throws DriverRegistroServiziException {
        try {
            RegistroServiziReader registroServiziReader = RegistroServiziReader.getInstance();
            if (registroServiziReader != null && registroServiziReader.registroServizi != null) {
                registroServiziReader.registroServizi.prefillCache(null, registroServiziReader.log, cryptConfigSoggetti);
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Prefill della cache di accesso ai registri dei servizi non riuscita: " + e.getMessage(), (Throwable)e);
        }
    }

    public static String printStatsCache(String separator) throws DriverRegistroServiziException {
        try {
            RegistroServiziReader registroServiziReader = RegistroServiziReader.getInstance();
            if (registroServiziReader != null && registroServiziReader.registroServizi != null) {
                return registroServiziReader.registroServizi.printStatsCache(separator);
            }
            throw new Exception("RegistroServizi Non disponibile");
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Visualizzazione Statistiche riguardante la cache del registro dei servizi non riuscita: " + e.getMessage(), (Throwable)e);
        }
    }

    public static void abilitaCache() throws DriverRegistroServiziException {
        try {
            RegistroServiziReader registroServiziReader = RegistroServiziReader.getInstance();
            if (registroServiziReader != null && registroServiziReader.registroServizi != null) {
                registroServiziReader.registroServizi.abilitaCache();
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Abilitazione cache di accesso ai registri dei servizi non riuscita: " + e.getMessage(), (Throwable)e);
        }
    }

    public static void abilitaCache(Long dimensioneCache, Boolean algoritmoCacheLRU, Long itemIdleTime, Long itemLifeSecond, CryptConfig cryptConfigSoggetti) throws DriverRegistroServiziException {
        try {
            RegistroServiziReader registroServiziReader = RegistroServiziReader.getInstance();
            if (registroServiziReader != null && registroServiziReader.registroServizi != null) {
                registroServiziReader.registroServizi.abilitaCache(dimensioneCache, algoritmoCacheLRU, itemIdleTime, itemLifeSecond, cryptConfigSoggetti);
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Abilitazione cache di accesso ai registri dei servizi non riuscita: " + e.getMessage(), (Throwable)e);
        }
    }

    public static void disabilitaCache() throws DriverRegistroServiziException {
        try {
            RegistroServiziReader registroServiziReader = RegistroServiziReader.getInstance();
            if (registroServiziReader != null && registroServiziReader.registroServizi != null) {
                registroServiziReader.registroServizi.disabilitaCache();
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Disabilitazione cache di accesso ai registri dei servizi non riuscita: " + e.getMessage(), (Throwable)e);
        }
    }

    public static String listKeysCache(String separator) throws DriverRegistroServiziException {
        try {
            RegistroServiziReader registroServiziReader = RegistroServiziReader.getInstance();
            if (registroServiziReader != null && registroServiziReader.registroServizi != null) {
                return registroServiziReader.registroServizi.listKeysCache(separator);
            }
            throw new Exception("RegistroServizi Non disponibile");
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Visualizzazione chiavi presenti nella cache del RegistroServizi non riuscita: " + e.getMessage(), (Throwable)e);
        }
    }

    public static List<String> keysCache() throws DriverRegistroServiziException {
        try {
            RegistroServiziReader registroServiziReader = RegistroServiziReader.getInstance();
            if (registroServiziReader != null && registroServiziReader.registroServizi != null) {
                return registroServiziReader.registroServizi.keysCache();
            }
            throw new Exception("RegistroServizi Non disponibile");
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Visualizzazione chiavi presenti nella cache del RegistroServizi non riuscita: " + e.getMessage(), (Throwable)e);
        }
    }

    public static String getObjectCache(String key) throws DriverRegistroServiziException {
        try {
            RegistroServiziReader registroServiziReader = RegistroServiziReader.getInstance();
            if (registroServiziReader != null && registroServiziReader.registroServizi != null) {
                return registroServiziReader.registroServizi.getObjectCache(key);
            }
            throw new Exception("RegistroServizi Non disponibile");
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Visualizzazione oggetto presente nella cache del RegistroServizi non riuscita: " + e.getMessage(), (Throwable)e);
        }
    }

    public static Object getRawObjectCache(String key) throws DriverRegistroServiziException {
        try {
            RegistroServiziReader registroServiziReader = RegistroServiziReader.getInstance();
            if (registroServiziReader != null && registroServiziReader.registroServizi != null) {
                return registroServiziReader.registroServizi.getRawObjectCache(key);
            }
            throw new Exception("ConfigurazionePdD Non disponibile");
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Visualizzazione oggetto presente nella cache del RegistroServizi non riuscita: " + e.getMessage(), (Throwable)e);
        }
    }

    public static void removeObjectCache(String key) throws DriverRegistroServiziException {
        try {
            RegistroServiziReader registroServiziReader = RegistroServiziReader.getInstance();
            if (registroServiziReader == null || registroServiziReader.registroServizi == null) {
                throw new Exception("RegistroServizi Non disponibile");
            }
            registroServiziReader.registroServizi.removeObjectCache(key);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Rimozione oggetto presente nella cache del RegistroServizi non riuscita: " + e.getMessage(), (Throwable)e);
        }
    }

    public static void removeAccordoCooperazione(IDAccordoCooperazione idAccordo) throws Exception {
        if (RegistroServiziReader.isCacheAbilitata()) {
            for (int i = 0; i < 3; ++i) {
                Boolean readContenutiAllegati = null;
                if (i == 1) {
                    readContenutiAllegati = true;
                } else if (i == 2) {
                    readContenutiAllegati = false;
                }
                String keyIdAccordo = RegistroServizi._getKey_getAccordoCooperazione(IDAccordoCooperazioneFactory.getInstance(), idAccordo, readContenutiAllegati);
                RegistroServiziReader.removeObjectCache(keyIdAccordo);
            }
            ArrayList<String> keyForClean = new ArrayList<String>();
            List<String> keys = RegistroServiziReader.keysCache();
            if (keys != null && !keys.isEmpty()) {
                String prefixGetAllId = RegistroServizi._toKey_getAllIdAccordiCooperazione_method();
                block1: for (String key : keys) {
                    List l;
                    Object oCode;
                    if (key == null || !key.startsWith(prefixGetAllId) || (oCode = RegistroServiziReader.getRawObjectCache(key)) == null || !(oCode instanceof List) || (l = (List)oCode) == null || l.isEmpty()) continue;
                    for (Object object : l) {
                        IDAccordoCooperazione idCheck;
                        if (object == null || !(object instanceof IDAccordoCooperazione) || !(idCheck = (IDAccordoCooperazione)object).equals((Object)idAccordo)) continue;
                        keyForClean.add(key);
                        continue block1;
                    }
                }
            }
            if (keyForClean != null && !keyForClean.isEmpty()) {
                for (String key : keyForClean) {
                    RegistroServiziReader.removeObjectCache(key);
                }
            }
        }
    }

    public static void removeApi(IDAccordo idAccordo) throws Exception {
        if (RegistroServiziReader.isCacheAbilitata()) {
            for (int i = 0; i < 3; ++i) {
                Boolean readContenutiAllegati = null;
                if (i == 1) {
                    readContenutiAllegati = true;
                } else if (i == 2) {
                    readContenutiAllegati = false;
                }
                Boolean readDatiRegistro = null;
                for (int j = 0; j < 3; ++j) {
                    if (i == 1) {
                        readDatiRegistro = true;
                    } else if (i == 2) {
                        readDatiRegistro = false;
                    }
                    String keyIdAccordo = RegistroServizi._getKey_getAccordoServizioParteComune(IDAccordoFactory.getInstance(), idAccordo, readContenutiAllegati, readDatiRegistro);
                    RegistroServiziReader.removeObjectCache(keyIdAccordo);
                }
            }
            List<IDServizio> serviziImplementati = null;
            try {
                FiltroRicercaServizi filtro = new FiltroRicercaServizi();
                filtro.setIdAccordoServizioParteComune(idAccordo);
                serviziImplementati = RegistroServiziManager.getInstance().getAllIdServizi(filtro, null);
            }
            catch (Throwable filtro) {
                // empty catch block
            }
            ArrayList<String> keyForClean = new ArrayList<String>();
            List<String> keys = RegistroServiziReader.keysCache();
            if (keys != null && !keys.isEmpty()) {
                String prefixServizioCorrelatoPrefix = RegistroServizi._toKey_getAccordoServizioParteSpecifica_ServizioCorrelato_prefix();
                String servizioCorrelato = RegistroServizi._toKey_getAccordoServizioParteSpecifica_ServizioCorrelato(IDAccordoFactory.getInstance(), idAccordo);
                String prefixGetAllId = RegistroServizi._toKey_getAllIdAccordiServizioParteComune_method();
                String prefixGetAllId_portTypes = RegistroServizi._toKey_getAllIdPortType_method();
                String prefixGetAllId_azionePortType = RegistroServizi._toKey_getAllIdAzionePortType_method();
                String prefixGetAllId_azione = RegistroServizi._toKey_getAllIdAzione_method();
                String prefixGetAllId_resource = RegistroServizi._toKey_getAllIdResource_method();
                String wsdlAccordoServizioPrefix = RegistroServizi._toKey_getWsdlAccordoServizioPrefix();
                String restAccordoServizioPrefix = RegistroServizi._toKey_getRestAccordoServizioPrefix();
                String documentoPrefix = RegistroServizi._toKey_prefixGetAllegatoAccordoServizioParteComune(idAccordo);
                block4: for (String key : keys) {
                    IDAccordo idCheck;
                    List l;
                    Object oCode;
                    if (key == null) continue;
                    if (key.startsWith(prefixServizioCorrelatoPrefix) && key.contains(servizioCorrelato)) {
                        keyForClean.add(key);
                        continue;
                    }
                    if (key.startsWith(prefixGetAllId)) {
                        oCode = RegistroServiziReader.getRawObjectCache(key);
                        if (oCode == null || !(oCode instanceof List) || (l = (List)oCode) == null || l.isEmpty()) continue;
                        for (Object object : l) {
                            if (object == null || !(object instanceof IDAccordo) || !(idCheck = (IDAccordo)object).equals((Object)idAccordo)) continue;
                            keyForClean.add(key);
                            continue block4;
                        }
                        continue;
                    }
                    if (key.startsWith(prefixGetAllId_portTypes)) {
                        oCode = RegistroServiziReader.getRawObjectCache(key);
                        if (oCode == null || !(oCode instanceof List) || (l = (List)oCode) == null || l.isEmpty()) continue;
                        for (Object object : l) {
                            if (object == null || !(object instanceof IDPortType) || !(idCheck = (IDPortType)object).getIdAccordo().equals((Object)idAccordo)) continue;
                            keyForClean.add(key);
                            continue block4;
                        }
                        continue;
                    }
                    if (key.startsWith(prefixGetAllId_azionePortType)) {
                        oCode = RegistroServiziReader.getRawObjectCache(key);
                        if (oCode == null || !(oCode instanceof List) || (l = (List)oCode) == null || l.isEmpty()) continue;
                        for (Object object : l) {
                            if (object == null || !(object instanceof IDPortTypeAzione) || !(idCheck = (IDPortTypeAzione)object).getIdPortType().getIdAccordo().equals((Object)idAccordo)) continue;
                            keyForClean.add(key);
                            continue block4;
                        }
                        continue;
                    }
                    if (key.startsWith(prefixGetAllId_azione)) {
                        oCode = RegistroServiziReader.getRawObjectCache(key);
                        if (oCode == null || !(oCode instanceof List) || (l = (List)oCode) == null || l.isEmpty()) continue;
                        for (Object object : l) {
                            if (object == null || !(object instanceof IDAccordoAzione) || !(idCheck = (IDAccordoAzione)object).getIdAccordo().equals((Object)idAccordo)) continue;
                            keyForClean.add(key);
                            continue block4;
                        }
                        continue;
                    }
                    if (key.startsWith(prefixGetAllId_resource)) {
                        oCode = RegistroServiziReader.getRawObjectCache(key);
                        if (oCode == null || !(oCode instanceof List) || (l = (List)oCode) == null || l.isEmpty()) continue;
                        for (Object object : l) {
                            if (object == null || !(object instanceof IDResource) || !(idCheck = (IDResource)object).getIdAccordo().equals((Object)idAccordo)) continue;
                            keyForClean.add(key);
                            continue block4;
                        }
                        continue;
                    }
                    if (key.startsWith(wsdlAccordoServizioPrefix) && serviziImplementati != null && !serviziImplementati.isEmpty()) {
                        for (IDServizio idServizio : serviziImplementati) {
                            String wsdlAccordoServizioService = RegistroServizi._toKey_getWsdlAccordoServizioService(idServizio);
                            if (!key.contains(wsdlAccordoServizioService)) continue;
                            keyForClean.add(key);
                        }
                        continue;
                    }
                    if (key.startsWith(restAccordoServizioPrefix)) {
                        for (IDServizio idServizio : serviziImplementati) {
                            String restAccordoServizioService = RegistroServizi._toKey_getRestAccordoServizioService(idServizio);
                            if (!key.contains(restAccordoServizioService)) continue;
                            keyForClean.add(key);
                        }
                        continue;
                    }
                    if (!key.startsWith(documentoPrefix)) continue;
                    keyForClean.add(key);
                }
            }
            if (keyForClean != null && !keyForClean.isEmpty()) {
                for (String key : keyForClean) {
                    RegistroServiziReader.removeObjectCache(key);
                }
            }
        }
    }

    public static void removeErogazione(IDServizio idServizio) throws Exception {
        RegistroServiziReader.removeApiImpl(null, idServizio, true);
    }

    public static void removeFruizione(IDSoggetto fruitore, IDServizio idServizio) throws Exception {
        RegistroServiziReader.removeApiImpl(fruitore, idServizio, false);
    }

    private static void removeApiImpl(IDSoggetto idFruitore, IDServizio idServizio, boolean erogazione) throws Exception {
        if (RegistroServiziReader.isCacheAbilitata()) {
            String keyServiceBinding = RegistroServizi._getKey_getServiceBinding(idServizio);
            RegistroServiziReader.removeObjectCache(keyServiceBinding);
            ArrayList<String> keyForClean = new ArrayList<String>();
            List<String> keys = RegistroServiziReader.keysCache();
            if (keys != null && !keys.isEmpty()) {
                String prefixAccordo = RegistroServizi._toKey_getAccordoServizioParteSpecificaPrefix(idServizio);
                String prefixGetAllId = RegistroServizi._toKey_getAllIdServizi_method();
                String prefixGetAllIdFruizione = null;
                if (!erogazione) {
                    prefixGetAllIdFruizione = RegistroServizi._toKey_getAllIdFruizioniServizio_method();
                }
                String wsdlAccordoServizioPrefix = RegistroServizi._toKey_getWsdlAccordoServizioPrefix();
                String wsdlAccordoServizioService = RegistroServizi._toKey_getWsdlAccordoServizioService(idServizio);
                String restAccordoServizioPrefix = RegistroServizi._toKey_getRestAccordoServizioPrefix();
                String restAccordoServizioService = RegistroServizi._toKey_getRestAccordoServizioService(idServizio);
                String documentoPrefix = RegistroServizi._toKey_prefixGetAllegatoAccordoServizioParteSpecifica(idServizio);
                block0: for (String key : keys) {
                    IDServizio idCheck;
                    List l;
                    Object oCode;
                    if (key == null) continue;
                    if (key.startsWith(prefixAccordo)) {
                        keyForClean.add(key);
                        continue;
                    }
                    if (key.startsWith(prefixGetAllId)) {
                        oCode = RegistroServiziReader.getRawObjectCache(key);
                        if (oCode == null || !(oCode instanceof List) || (l = (List)oCode) == null || l.isEmpty()) continue;
                        for (Object object : l) {
                            if (object == null || !(object instanceof IDServizio) || !(idCheck = (IDServizio)object).equals(idServizio, false)) continue;
                            keyForClean.add(key);
                            continue block0;
                        }
                        continue;
                    }
                    if (!erogazione && key.startsWith(prefixGetAllIdFruizione)) {
                        oCode = RegistroServiziReader.getRawObjectCache(key);
                        if (oCode == null || !(oCode instanceof List) || (l = (List)oCode) == null || l.isEmpty()) continue;
                        for (Object object : l) {
                            if (object == null || !(object instanceof IDFruizione) || !(idCheck = (IDFruizione)object).getIdFruitore().equals((Object)idFruitore) || !idCheck.getIdServizio().equals(idServizio, false)) continue;
                            keyForClean.add(key);
                            continue block0;
                        }
                        continue;
                    }
                    if (key.startsWith(wsdlAccordoServizioPrefix) && key.contains(wsdlAccordoServizioService)) {
                        keyForClean.add(key);
                        continue;
                    }
                    if (key.startsWith(restAccordoServizioPrefix) && key.contains(restAccordoServizioService)) {
                        keyForClean.add(key);
                        continue;
                    }
                    if (!key.startsWith(documentoPrefix)) continue;
                    keyForClean.add(key);
                }
            }
            if (keyForClean != null && !keyForClean.isEmpty()) {
                for (String key : keyForClean) {
                    RegistroServiziReader.removeObjectCache(key);
                }
            }
        }
    }

    public static void removePdd(String portaDominio) throws Exception {
        if (RegistroServiziReader.isCacheAbilitata()) {
            String keyPdd = RegistroServizi._getKey_getPortaDominio(portaDominio);
            RegistroServiziReader.removeObjectCache(keyPdd);
            ArrayList<String> keyForClean = new ArrayList<String>();
            List<String> keys = RegistroServiziReader.keysCache();
            if (keys != null && !keys.isEmpty()) {
                String prefixGetAllId = RegistroServizi._toKey_getAllIdPorteDominio_method();
                block0: for (String key : keys) {
                    List l;
                    Object oCode;
                    if (key == null || !key.startsWith(prefixGetAllId) || (oCode = RegistroServiziReader.getRawObjectCache(key)) == null || !(oCode instanceof List) || (l = (List)oCode) == null || l.isEmpty()) continue;
                    for (Object object : l) {
                        String idCheck;
                        if (object == null || !(object instanceof String) || !(idCheck = (String)object).equals(portaDominio)) continue;
                        keyForClean.add(key);
                        continue block0;
                    }
                }
            }
            if (keyForClean != null && !keyForClean.isEmpty()) {
                for (String key : keyForClean) {
                    RegistroServiziReader.removeObjectCache(key);
                }
            }
        }
    }

    public static void removeSoggetto(IDSoggetto idSoggetto) throws Exception {
        if (RegistroServiziReader.isCacheAbilitata()) {
            String keySoggetto = RegistroServizi._getKey_getSoggetto(idSoggetto);
            RegistroServiziReader.removeObjectCache(keySoggetto);
            ArrayList<String> keyForClean = new ArrayList<String>();
            List<String> keys = RegistroServiziReader.keysCache();
            if (keys != null && !keys.isEmpty()) {
                String prefixCredenzialiBasic = RegistroServizi._toKey_getSoggettoByCredenzialiBasicPrefix();
                String prefixCredenzialiApiKey = RegistroServizi._toKey_getSoggettoByCredenzialiApiKeyPrefix(false);
                String prefixCredenzialiApiKeyAppId = RegistroServizi._toKey_getSoggettoByCredenzialiApiKeyPrefix(true);
                String prefixCredenzialiSsl = RegistroServizi._toKey_getSoggettoByCredenzialiSslPrefix(true);
                String prefixCredenzialiSslCert = RegistroServizi._toKey_getSoggettoByCredenzialiSslCertPrefix(true);
                String prefixCredenzialiPrincipal = RegistroServizi._toKey_getSoggettoByCredenzialiPrincipalPrefix();
                String prefixGetAllId = RegistroServizi._toKey_getAllIdSoggetti_method();
                block0: for (String key : keys) {
                    List l;
                    Object oCode;
                    if (key == null) continue;
                    if (key.startsWith(prefixCredenzialiBasic) || key.startsWith(prefixCredenzialiApiKey) || key.startsWith(prefixCredenzialiApiKeyAppId) || key.startsWith(prefixCredenzialiSsl) || key.startsWith(prefixCredenzialiSslCert) || key.startsWith(prefixCredenzialiPrincipal)) {
                        Soggetto soggetto;
                        Object o = RegistroServiziReader.getRawObjectCache(key);
                        if (o == null || !(o instanceof Soggetto) || !(soggetto = (Soggetto)o).getTipo().equals(idSoggetto.getTipo()) || !soggetto.getNome().equals(idSoggetto.getNome())) continue;
                        keyForClean.add(key);
                        continue;
                    }
                    if (!key.startsWith(prefixGetAllId) || (oCode = RegistroServiziReader.getRawObjectCache(key)) == null || !(oCode instanceof List) || (l = (List)oCode) == null || l.isEmpty()) continue;
                    for (Object object : l) {
                        IDSoggetto idCheck;
                        if (object == null || !(object instanceof IDSoggetto) || !(idCheck = (IDSoggetto)object).equals((Object)idSoggetto)) continue;
                        keyForClean.add(key);
                        continue block0;
                    }
                }
            }
            if (keyForClean != null && !keyForClean.isEmpty()) {
                for (String key : keyForClean) {
                    RegistroServiziReader.removeObjectCache(key);
                }
            }
        }
    }

    public static void removeGruppo(IDGruppo idGruppo) throws Exception {
        if (RegistroServiziReader.isCacheAbilitata()) {
            String keyGruppo = RegistroServizi._getKey_getGruppo(idGruppo.getNome());
            RegistroServiziReader.removeObjectCache(keyGruppo);
            ArrayList<String> keyForClean = new ArrayList<String>();
            List<String> keys = RegistroServiziReader.keysCache();
            if (keys != null && !keys.isEmpty()) {
                String prefixGetAllId = RegistroServizi._toKey_getAllIdGruppi_method();
                block0: for (String key : keys) {
                    List l;
                    Object oCode;
                    if (key == null || !key.startsWith(prefixGetAllId) || !((oCode = RegistroServiziReader.getRawObjectCache(key)) instanceof List) || (l = (List)oCode) == null || l.isEmpty()) continue;
                    for (Object object : l) {
                        IDGruppo idCheck;
                        if (!(object instanceof IDGruppo) || !(idCheck = (IDGruppo)object).equals((Object)idGruppo)) continue;
                        keyForClean.add(key);
                        continue block0;
                    }
                }
            }
            if (keyForClean != null && !keyForClean.isEmpty()) {
                for (String key : keyForClean) {
                    RegistroServiziReader.removeObjectCache(key);
                }
            }
        }
    }

    public static void removeRuolo(IDRuolo idRuolo) throws Exception {
        if (RegistroServiziReader.isCacheAbilitata()) {
            String keyRuolo = RegistroServizi._getKey_getRuolo(idRuolo.getNome());
            RegistroServiziReader.removeObjectCache(keyRuolo);
            ArrayList<String> keyForClean = new ArrayList<String>();
            List<String> keys = RegistroServiziReader.keysCache();
            if (keys != null && !keys.isEmpty()) {
                String prefixGetAllId = RegistroServizi._toKey_getAllIdRuoli_method();
                block0: for (String key : keys) {
                    List l;
                    Object oCode;
                    if (key == null || !key.startsWith(prefixGetAllId) || (oCode = RegistroServiziReader.getRawObjectCache(key)) == null || !(oCode instanceof List) || (l = (List)oCode) == null || l.isEmpty()) continue;
                    for (Object object : l) {
                        IDRuolo idCheck;
                        if (object == null || !(object instanceof IDRuolo) || !(idCheck = (IDRuolo)object).equals((Object)idRuolo)) continue;
                        keyForClean.add(key);
                        continue block0;
                    }
                }
            }
            if (keyForClean != null && !keyForClean.isEmpty()) {
                for (String key : keyForClean) {
                    RegistroServiziReader.removeObjectCache(key);
                }
            }
        }
    }

    public static void removeScope(IDScope idScope) throws Exception {
        if (RegistroServiziReader.isCacheAbilitata()) {
            String keyScope = RegistroServizi._getKey_getScope(idScope.getNome());
            RegistroServiziReader.removeObjectCache(keyScope);
            ArrayList<String> keyForClean = new ArrayList<String>();
            List<String> keys = RegistroServiziReader.keysCache();
            if (keys != null && !keys.isEmpty()) {
                String prefixGetAllId = RegistroServizi._toKey_getAllIdScope_method();
                block0: for (String key : keys) {
                    List l;
                    Object oCode;
                    if (key == null || !key.startsWith(prefixGetAllId) || (oCode = RegistroServiziReader.getRawObjectCache(key)) == null || !(oCode instanceof List) || (l = (List)oCode) == null || l.isEmpty()) continue;
                    for (Object object : l) {
                        IDScope idCheck;
                        if (object == null || !(object instanceof IDScope) || !(idCheck = (IDScope)object).equals((Object)idScope)) continue;
                        keyForClean.add(key);
                        continue block0;
                    }
                }
            }
            if (keyForClean != null && !keyForClean.isEmpty()) {
                for (String key : keyForClean) {
                    RegistroServiziReader.removeObjectCache(key);
                }
            }
        }
    }

    public static boolean initialize(AccessoRegistro accessoRegistro, Logger aLog, Logger aLogconsole, boolean raggiungibilitaTotale, boolean readObjectStatoBozza, String jndiNameDatasourcePdD, boolean useOp2UtilsDatasource, boolean bindJMX, boolean prefillCache, CryptConfig cryptConfigSoggetti, CacheType cacheType, IDriverBYOK driverBYOK) {
        try {
            registroServiziReader = new RegistroServiziReader(accessoRegistro, aLog, aLogconsole, raggiungibilitaTotale, readObjectStatoBozza, jndiNameDatasourcePdD, useOp2UtilsDatasource, bindJMX, prefillCache, cryptConfigSoggetti, cacheType, driverBYOK);
            return initialize;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isInitialize() {
        return initialize;
    }

    public static RegistroServiziReader getInstance() {
        return registroServiziReader;
    }

    public static Map<String, IDriverRegistroServiziGet> getDriverRegistroServizi() {
        return RegistroServiziReader.registroServiziReader.registroServizi.getDriverRegistroServizi();
    }

    public RegistroServiziReader(AccessoRegistro accessoRegistro, Logger aLog, Logger aLogconsole, boolean raggiungibilitaTotale, boolean readObjectStatoBozza, String jndiNameDatasourcePdD, boolean useOp2UtilsDatasource, boolean bindJMX, boolean prefillCache, CryptConfig cryptConfigSoggetti, CacheType cacheType, IDriverBYOK driverBYOK) throws DriverRegistroServiziException {
        try {
            this.log = aLog != null ? aLog : LoggerWrapperFactory.getLogger(RegistroServiziReader.class);
            this.registroServizi = new RegistroServizi(accessoRegistro, this.log, aLogconsole, raggiungibilitaTotale, readObjectStatoBozza, jndiNameDatasourcePdD, useOp2UtilsDatasource, bindJMX, prefillCache, cryptConfigSoggetti, cacheType, driverBYOK);
            initialize = true;
        }
        catch (Exception e) {
            initialize = false;
        }
    }

    protected void isAlive(boolean controlloTotale) throws CoreException {
        if (controlloTotale) {
            for (String nomeRegInLista : this.registroServizi.getDriverRegistroServizi().keySet()) {
                try {
                    IMonitoraggioRisorsa monitorDriver = (IMonitoraggioRisorsa)this.registroServizi.getDriverRegistroServizi().get(nomeRegInLista);
                    monitorDriver.isAlive();
                }
                catch (Exception e) {
                    throw new CoreException("[Registro " + nomeRegInLista + "] " + e.getMessage(), (Throwable)e);
                }
            }
        } else {
            boolean registroRaggiungibile = false;
            StringBuilder eccezioni = new StringBuilder();
            for (String nomeRegInLista : this.registroServizi.getDriverRegistroServizi().keySet()) {
                try {
                    IMonitoraggioRisorsa monitorDriver = (IMonitoraggioRisorsa)this.registroServizi.getDriverRegistroServizi().get(nomeRegInLista);
                    monitorDriver.isAlive();
                    registroRaggiungibile = true;
                    break;
                }
                catch (Exception e) {
                    this.log.debug("Registro non accessibile [Registro " + nomeRegInLista + "]", (Throwable)e);
                    eccezioni.append("\n[Registro " + nomeRegInLista + "] " + e.getMessage());
                }
            }
            if (!registroRaggiungibile) {
                throw new CoreException(eccezioni.toString());
            }
        }
    }

    protected void validazioneSemantica(boolean controlloTotale, boolean verificaURI, String[] tipiSoggettiValidi, String[] tipiServiziSoapValidi, String[] tipiServiziRestValidi, String[] tipiConnettoriValidi, boolean validazioneSemanticaAbilitataXML, boolean validazioneSemanticaAbilitataAltriRegistri, Logger logConsole) throws CoreException {
        if (controlloTotale) {
            for (String nomeRegInLista : this.registroServizi.getDriverRegistroServizi().keySet()) {
                try {
                    IDriverRegistroServiziGet o = this.registroServizi.getDriverRegistroServizi().get(nomeRegInLista);
                    boolean validazione = false;
                    validazione = o instanceof DriverRegistroServiziXML ? validazioneSemanticaAbilitataXML : validazioneSemanticaAbilitataAltriRegistri;
                    if (!validazione) continue;
                    BeanUtilities driverRegistro = (BeanUtilities)o;
                    org.openspcoop2.core.registry.RegistroServizi registroServizi = driverRegistro.getImmagineCompletaRegistroServizi();
                    ValidazioneSemantica validazioneSemantica = new ValidazioneSemantica(registroServizi, verificaURI, tipiConnettoriValidi, tipiSoggettiValidi, tipiServiziSoapValidi, tipiServiziRestValidi);
                    validazioneSemantica.validazioneSemantica(false);
                    if (logConsole == null) continue;
                    logConsole.info("Validazione semantica del registro dei servizi [" + nomeRegInLista + "] effettuata.");
                }
                catch (Exception e) {
                    throw new CoreException("[Registro " + nomeRegInLista + "] " + e.getMessage(), (Throwable)e);
                }
            }
        } else {
            boolean registroRaggiungibile = false;
            StringBuilder eccezioni = new StringBuilder();
            for (String nomeRegInLista : this.registroServizi.getDriverRegistroServizi().keySet()) {
                try {
                    IDriverRegistroServiziGet o = this.registroServizi.getDriverRegistroServizi().get(nomeRegInLista);
                    boolean validazione = false;
                    validazione = o instanceof DriverRegistroServiziXML ? validazioneSemanticaAbilitataXML : validazioneSemanticaAbilitataAltriRegistri;
                    if (!validazione) continue;
                    BeanUtilities driverRegistro = (BeanUtilities)o;
                    org.openspcoop2.core.registry.RegistroServizi registroServizi = driverRegistro.getImmagineCompletaRegistroServizi();
                    ValidazioneSemantica validazioneSemantica = new ValidazioneSemantica(registroServizi, verificaURI, tipiConnettoriValidi, tipiSoggettiValidi, tipiServiziSoapValidi, tipiServiziRestValidi);
                    validazioneSemantica.validazioneSemantica(false);
                    if (logConsole != null) {
                        logConsole.info("Validazione semantica del registro dei servizi [" + nomeRegInLista + "] effettuata.");
                    }
                    registroRaggiungibile = true;
                    break;
                }
                catch (Exception e) {
                    this.log.debug("Registro non accessibile [Registro " + nomeRegInLista + "]", (Throwable)e);
                    eccezioni.append("\n[Registro " + nomeRegInLista + "] " + e.getMessage());
                }
            }
            if (!registroRaggiungibile) {
                throw new CoreException(eccezioni.toString());
            }
        }
    }

    protected void setValidazioneSemanticaModificaRegistroServiziXML(boolean verificaURI, String[] tipiSoggettiValidi, String[] tipiServiziSoapValidi, String[] tipiServiziRestValidi, String[] tipiConnettoriValidi) throws CoreException {
        for (String nomeRegInLista : this.registroServizi.getDriverRegistroServizi().keySet()) {
            try {
                IDriverRegistroServiziGet o = this.registroServizi.getDriverRegistroServizi().get(nomeRegInLista);
                if (!(o instanceof DriverRegistroServiziXML)) continue;
                DriverRegistroServiziXML driver = (DriverRegistroServiziXML)o;
                driver.abilitazioneValidazioneSemanticaDuranteModificaXML(verificaURI, tipiConnettoriValidi, tipiSoggettiValidi, tipiServiziSoapValidi, tipiServiziRestValidi);
            }
            catch (Exception e) {
                throw new CoreException("[Registro " + nomeRegInLista + "] " + e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void verificaConsistenzaRegistroServizi() throws DriverRegistroServiziException {
        for (String nomeRegInLista : this.registroServizi.getDriverRegistroServizi().keySet()) {
            IDriverRegistroServiziGet o = this.registroServizi.getDriverRegistroServizi().get(nomeRegInLista);
            if (!(o instanceof DriverRegistroServiziXML)) continue;
            DriverRegistroServiziXML driver = (DriverRegistroServiziXML)o;
            driver.refreshRegistroServiziXML();
        }
    }

    public PortaDominio getPortaDominio_noCache(String nome, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        PortaDominio r = null;
        for (String nomeRegInLista : this.registroServizi.getDriverRegistroServizi().keySet()) {
            if (nomeRegistro != null && !nomeRegistro.equals(nomeRegInLista)) continue;
            IDriverRegistroServiziGet driver = this.registroServizi.getDriverRegistroServizi().get(nomeRegInLista);
            try {
                r = driver.getPortaDominio(nome);
            }
            catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                // empty catch block
            }
            if (r == null && nomeRegistro == null) continue;
            break;
        }
        if (r == null) {
            throw new DriverRegistroServiziNotFound();
        }
        return r;
    }

    public Ruolo getRuolo_noCache(String nome, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Ruolo r = null;
        for (String nomeRegInLista : this.registroServizi.getDriverRegistroServizi().keySet()) {
            if (nomeRegistro != null && !nomeRegistro.equals(nomeRegInLista)) continue;
            IDriverRegistroServiziGet driver = this.registroServizi.getDriverRegistroServizi().get(nomeRegInLista);
            try {
                IDRuolo idRuolo = new IDRuolo(nome);
                r = driver.getRuolo(idRuolo);
            }
            catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                // empty catch block
            }
            if (r == null && nomeRegistro == null) continue;
            break;
        }
        if (r == null) {
            throw new DriverRegistroServiziNotFound();
        }
        return r;
    }

    public Soggetto getSoggetto_noCache(IDSoggetto idSoggetto, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Soggetto r = null;
        for (String nomeRegInLista : this.registroServizi.getDriverRegistroServizi().keySet()) {
            if (nomeRegistro != null && !nomeRegistro.equals(nomeRegInLista)) continue;
            IDriverRegistroServiziGet driver = this.registroServizi.getDriverRegistroServizi().get(nomeRegInLista);
            try {
                r = driver.getSoggetto(idSoggetto);
            }
            catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                // empty catch block
            }
            if (r == null && nomeRegistro == null) continue;
            break;
        }
        if (r == null) {
            throw new DriverRegistroServiziNotFound();
        }
        return r;
    }

    public AccordoServizioParteComune getAccordoServizioParteComune_noCache(IDAccordo idAccordo, String nomeRegistro, Boolean readContenutiAllegati, Boolean readDatiRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        AccordoServizioParteComune r = null;
        for (String nomeRegInLista : this.registroServizi.getDriverRegistroServizi().keySet()) {
            if (nomeRegistro != null && !nomeRegistro.equals(nomeRegInLista)) continue;
            IDriverRegistroServiziGet driver = this.registroServizi.getDriverRegistroServizi().get(nomeRegInLista);
            try {
                r = driver instanceof DriverRegistroServiziDB ? ((DriverRegistroServiziDB)driver).getAccordoServizioParteComune(idAccordo, readContenutiAllegati.booleanValue(), readDatiRegistro.booleanValue()) : driver.getAccordoServizioParteComune(idAccordo);
            }
            catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                // empty catch block
            }
            if (r == null && nomeRegistro == null) continue;
            break;
        }
        if (r == null) {
            throw new DriverRegistroServiziNotFound();
        }
        return r;
    }

    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica_noCache(IDServizio idServizio, String nomeRegistro, Boolean readContenutiAllegati) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        AccordoServizioParteSpecifica r = null;
        for (String nomeRegInLista : this.registroServizi.getDriverRegistroServizi().keySet()) {
            if (nomeRegistro != null && !nomeRegistro.equals(nomeRegInLista)) continue;
            IDriverRegistroServiziGet driver = this.registroServizi.getDriverRegistroServizi().get(nomeRegInLista);
            try {
                r = driver instanceof DriverRegistroServiziDB ? ((DriverRegistroServiziDB)driver).getAccordoServizioParteSpecifica(idServizio, readContenutiAllegati.booleanValue()) : driver.getAccordoServizioParteSpecifica(idServizio);
            }
            catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                // empty catch block
            }
            if (r == null && nomeRegistro == null) continue;
            break;
        }
        if (r == null) {
            throw new DriverRegistroServiziNotFound();
        }
        return r;
    }

    public AccordoCooperazione getAccordoCooperazione_noCache(IDAccordoCooperazione idAccordo, String nomeRegistro, Boolean readContenutiAllegati) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        AccordoCooperazione r = null;
        for (String nomeRegInLista : this.registroServizi.getDriverRegistroServizi().keySet()) {
            if (nomeRegistro != null && !nomeRegistro.equals(nomeRegInLista)) continue;
            IDriverRegistroServiziGet driver = this.registroServizi.getDriverRegistroServizi().get(nomeRegInLista);
            try {
                r = driver instanceof DriverRegistroServiziDB ? ((DriverRegistroServiziDB)driver).getAccordoCooperazione(idAccordo, readContenutiAllegati.booleanValue()) : driver.getAccordoCooperazione(idAccordo);
            }
            catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                // empty catch block
            }
            if (r == null && nomeRegistro == null) continue;
            break;
        }
        if (r == null) {
            throw new DriverRegistroServiziNotFound();
        }
        return r;
    }

    public List<String> getAllIdPorteDominio_noCache(FiltroRicerca filtroRicerca, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        List r = null;
        for (String nomeRegInLista : this.registroServizi.getDriverRegistroServizi().keySet()) {
            if (nomeRegistro != null && !nomeRegistro.equals(nomeRegInLista)) continue;
            IDriverRegistroServiziGet driver = this.registroServizi.getDriverRegistroServizi().get(nomeRegInLista);
            try {
                r = driver.getAllIdPorteDominio(filtroRicerca);
            }
            catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                // empty catch block
            }
            if (r == null && nomeRegistro == null) continue;
            break;
        }
        if (r == null) {
            throw new DriverRegistroServiziNotFound();
        }
        return r;
    }

    public List<IDRuolo> getAllIdRuoli_noCache(FiltroRicercaRuoli filtroRicerca, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        List r = null;
        for (String nomeRegInLista : this.registroServizi.getDriverRegistroServizi().keySet()) {
            if (nomeRegistro != null && !nomeRegistro.equals(nomeRegInLista)) continue;
            IDriverRegistroServiziGet driver = this.registroServizi.getDriverRegistroServizi().get(nomeRegInLista);
            try {
                r = driver.getAllIdRuoli(filtroRicerca);
            }
            catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                // empty catch block
            }
            if (r == null && nomeRegistro == null) continue;
            break;
        }
        if (r == null) {
            throw new DriverRegistroServiziNotFound();
        }
        return r;
    }

    public List<IDSoggetto> getAllIdSoggetti_noCache(FiltroRicercaSoggetti filtroRicerca, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        List r = null;
        for (String nomeRegInLista : this.registroServizi.getDriverRegistroServizi().keySet()) {
            if (nomeRegistro != null && !nomeRegistro.equals(nomeRegInLista)) continue;
            IDriverRegistroServiziGet driver = this.registroServizi.getDriverRegistroServizi().get(nomeRegInLista);
            try {
                r = driver.getAllIdSoggetti(filtroRicerca);
            }
            catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                // empty catch block
            }
            if (r == null && nomeRegistro == null) continue;
            break;
        }
        if (r == null) {
            throw new DriverRegistroServiziNotFound();
        }
        return r;
    }

    public List<IDAccordoCooperazione> getAllIdAccordiCooperazione_noCache(FiltroRicercaAccordi filtroRicerca, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        List r = null;
        for (String nomeRegInLista : this.registroServizi.getDriverRegistroServizi().keySet()) {
            if (nomeRegistro != null && !nomeRegistro.equals(nomeRegInLista)) continue;
            IDriverRegistroServiziGet driver = this.registroServizi.getDriverRegistroServizi().get(nomeRegInLista);
            try {
                r = driver.getAllIdAccordiCooperazione(filtroRicerca);
            }
            catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                // empty catch block
            }
            if (r == null && nomeRegistro == null) continue;
            break;
        }
        if (r == null) {
            throw new DriverRegistroServiziNotFound();
        }
        return r;
    }

    public List<IDAccordo> getAllIdAccordiServizioParteComune_noCache(FiltroRicercaAccordi filtroRicerca, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        List r = null;
        for (String nomeRegInLista : this.registroServizi.getDriverRegistroServizi().keySet()) {
            if (nomeRegistro != null && !nomeRegistro.equals(nomeRegInLista)) continue;
            IDriverRegistroServiziGet driver = this.registroServizi.getDriverRegistroServizi().get(nomeRegInLista);
            try {
                r = driver.getAllIdAccordiServizioParteComune(filtroRicerca);
            }
            catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                // empty catch block
            }
            if (r == null && nomeRegistro == null) continue;
            break;
        }
        if (r == null) {
            throw new DriverRegistroServiziNotFound();
        }
        return r;
    }

    public List<IDPortType> getAllIdPortType_noCache(FiltroRicercaPortTypes filtroRicerca, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        List r = null;
        for (String nomeRegInLista : this.registroServizi.getDriverRegistroServizi().keySet()) {
            if (nomeRegistro != null && !nomeRegistro.equals(nomeRegInLista)) continue;
            IDriverRegistroServiziGet driver = this.registroServizi.getDriverRegistroServizi().get(nomeRegInLista);
            try {
                r = driver.getAllIdPortType(filtroRicerca);
            }
            catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                // empty catch block
            }
            if (r == null && nomeRegistro == null) continue;
            break;
        }
        if (r == null) {
            throw new DriverRegistroServiziNotFound();
        }
        return r;
    }

    public List<IDPortTypeAzione> getAllIdAzionePortType_noCache(FiltroRicercaOperations filtroRicerca, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        List r = null;
        for (String nomeRegInLista : this.registroServizi.getDriverRegistroServizi().keySet()) {
            if (nomeRegistro != null && !nomeRegistro.equals(nomeRegInLista)) continue;
            IDriverRegistroServiziGet driver = this.registroServizi.getDriverRegistroServizi().get(nomeRegInLista);
            try {
                r = driver.getAllIdAzionePortType(filtroRicerca);
            }
            catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                // empty catch block
            }
            if (r == null && nomeRegistro == null) continue;
            break;
        }
        if (r == null) {
            throw new DriverRegistroServiziNotFound();
        }
        return r;
    }

    public List<IDAccordoAzione> getAllIdAzioneAccordo_noCache(FiltroRicercaAzioni filtroRicerca, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        List r = null;
        for (String nomeRegInLista : this.registroServizi.getDriverRegistroServizi().keySet()) {
            if (nomeRegistro != null && !nomeRegistro.equals(nomeRegInLista)) continue;
            IDriverRegistroServiziGet driver = this.registroServizi.getDriverRegistroServizi().get(nomeRegInLista);
            try {
                r = driver.getAllIdAzioneAccordo(filtroRicerca);
            }
            catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                // empty catch block
            }
            if (r == null && nomeRegistro == null) continue;
            break;
        }
        if (r == null) {
            throw new DriverRegistroServiziNotFound();
        }
        return r;
    }

    public List<IDServizio> getAllIdServizi_noCache(FiltroRicercaServizi filtroRicerca, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        List r = null;
        for (String nomeRegInLista : this.registroServizi.getDriverRegistroServizi().keySet()) {
            if (nomeRegistro != null && !nomeRegistro.equals(nomeRegInLista)) continue;
            IDriverRegistroServiziGet driver = this.registroServizi.getDriverRegistroServizi().get(nomeRegInLista);
            try {
                r = driver.getAllIdServizi(filtroRicerca);
            }
            catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                // empty catch block
            }
            if (r == null && nomeRegistro == null) continue;
            break;
        }
        if (r == null) {
            throw new DriverRegistroServiziNotFound();
        }
        return r;
    }

    public List<IDFruizione> getAllIdFruizioniServizio_noCache(FiltroRicercaFruizioniServizio filtroRicerca, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        List r = null;
        for (String nomeRegInLista : this.registroServizi.getDriverRegistroServizi().keySet()) {
            if (nomeRegistro != null && !nomeRegistro.equals(nomeRegInLista)) continue;
            IDriverRegistroServiziGet driver = this.registroServizi.getDriverRegistroServizi().get(nomeRegInLista);
            try {
                r = driver.getAllIdFruizioniServizio(filtroRicerca);
            }
            catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                // empty catch block
            }
            if (r == null && nomeRegistro == null) continue;
            break;
        }
        if (r == null) {
            throw new DriverRegistroServiziNotFound();
        }
        return r;
    }

    protected String getProfiloGestioneFruizioneServizio(Connection connectionPdD, IDServizio idServizio, String nomeRegistro, RequestInfo requestInfo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        String profilo = null;
        AccordoServizioParteSpecifica servizio = null;
        try {
            servizio = this.registroServizi.getAccordoServizioParteSpecifica(connectionPdD, nomeRegistro, idServizio);
        }
        catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
            // empty catch block
        }
        if (servizio != null) {
            profilo = servizio.getVersioneProtocollo();
        }
        if (profilo == null) {
            Soggetto soggettoErogatore = RegistroServiziManager._getSoggettoFromRequestInfo(idServizio.getSoggettoErogatore(), requestInfo);
            if (soggettoErogatore == null) {
                soggettoErogatore = this.registroServizi.getSoggetto(connectionPdD, nomeRegistro, idServizio.getSoggettoErogatore());
            }
            if (soggettoErogatore == null) {
                throw new DriverRegistroServiziNotFound("getProfiloGestioneFruizioneServizio, soggettoErogatore [" + String.valueOf(idServizio.getSoggettoErogatore()) + "] non definito (o non registrato)");
            }
            profilo = soggettoErogatore.getVersioneProtocollo();
        }
        return profilo;
    }

    protected String getProfiloGestioneErogazioneServizio(Connection connectionPdD, IDSoggetto idFruitore, IDServizio idServizio, String nomeRegistro, RequestInfo requestInfo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        String profilo = null;
        Soggetto soggettoFruitore = RegistroServiziManager._getSoggettoFromRequestInfo(idFruitore, requestInfo);
        if (soggettoFruitore == null) {
            soggettoFruitore = this.registroServizi.getSoggetto(connectionPdD, nomeRegistro, idFruitore);
        }
        if (soggettoFruitore == null) {
            throw new DriverRegistroServiziNotFound("getProfiloGestioneErogazioneServizio, soggettoFruitore [" + String.valueOf(idFruitore) + "] non definito (o non registrato)");
        }
        profilo = soggettoFruitore.getVersioneProtocollo();
        return profilo;
    }

    protected String getProfiloGestioneSoggetto(Connection connectionPdD, IDSoggetto idSoggetto, String nomeRegistro, RequestInfo requestInfo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        String profilo = null;
        Soggetto soggetto = RegistroServiziManager._getSoggettoFromRequestInfo(idSoggetto, requestInfo);
        if (soggetto == null) {
            soggetto = this.registroServizi.getSoggetto(connectionPdD, nomeRegistro, idSoggetto);
        }
        if (soggetto == null) {
            throw new DriverRegistroServiziNotFound("getProfiloGestioneSoggetto, Soggetto [" + String.valueOf(idSoggetto) + "] non definito (o non registrato)");
        }
        profilo = soggetto.getVersioneProtocollo();
        return profilo;
    }

    protected Servizio getInfoServizio(Connection connectionPdD, IDSoggetto idSoggetto, IDServizio idService, String nomeRegistro, boolean verificaEsistenzaServizioAzioneCorrelato, boolean throwAzioneNotFound) throws DriverRegistroServiziException, DriverRegistroServiziNotFound, DriverRegistroServiziAzioneNotFound, DriverRegistroServiziPortTypeNotFound, DriverRegistroServiziCorrelatoNotFound {
        return this.getInfoServizio(connectionPdD, false, false, idSoggetto, idService, nomeRegistro, verificaEsistenzaServizioAzioneCorrelato, throwAzioneNotFound);
    }

    protected Servizio getInfoServizioCorrelato(Connection connectionPdD, IDSoggetto idSoggetto, IDServizio idService, String nomeRegistro, boolean throwAzioneNotFound) throws DriverRegistroServiziException, DriverRegistroServiziNotFound, DriverRegistroServiziAzioneNotFound, DriverRegistroServiziPortTypeNotFound, DriverRegistroServiziCorrelatoNotFound {
        return this.getInfoServizio(connectionPdD, true, false, idSoggetto, idService, nomeRegistro, false, throwAzioneNotFound);
    }

    protected Servizio getInfoServizioAzioneCorrelata(Connection connectionPdD, IDSoggetto idSoggetto, IDServizio idService, String nomeRegistro, boolean throwAzioneNotFound) throws DriverRegistroServiziException, DriverRegistroServiziNotFound, DriverRegistroServiziAzioneNotFound, DriverRegistroServiziPortTypeNotFound, DriverRegistroServiziCorrelatoNotFound {
        return this.getInfoServizio(connectionPdD, false, true, idSoggetto, idService, nomeRegistro, false, throwAzioneNotFound);
    }

    private Servizio getInfoServizio(Connection connectionPdD, boolean servizioCorrelato, boolean azioneCorrelata, IDSoggetto idSoggetto, IDServizio idService, String nomeRegistro, boolean verificaEsistenzaServizioAzioneCorrelato, boolean throwAzioneNotFound) throws DriverRegistroServiziException, DriverRegistroServiziNotFound, DriverRegistroServiziAzioneNotFound, DriverRegistroServiziPortTypeNotFound, DriverRegistroServiziCorrelatoNotFound {
        Servizio infoServizio = new Servizio();
        AccordoServizioParteSpecifica servizio = null;
        servizio = this.registroServizi.getAccordoServizioParteSpecifica(connectionPdD, nomeRegistro, idService);
        if (servizio == null) {
            throw new DriverRegistroServiziNotFound("Servizio non definito");
        }
        TipologiaServizio tipologiaServizio = servizio.getTipologiaServizio();
        if (servizioCorrelato) {
            if (!TipologiaServizio.CORRELATO.equals((Object)tipologiaServizio)) {
                throw new DriverRegistroServiziNotFound("Servizio [" + idService.toString() + "] (tipologia:" + String.valueOf(tipologiaServizio) + ") non \u00e8 di tipologia correlata");
            }
        } else if (!TipologiaServizio.NORMALE.equals((Object)tipologiaServizio)) {
            throw new DriverRegistroServiziNotFound("Servizio [" + idService.toString() + "] (tipologia:" + String.valueOf(tipologiaServizio) + ") \u00e8 di tipologia normale");
        }
        String azione = idService.getAzione();
        if (azioneCorrelata && azione == null) {
            throw new DriverRegistroServiziException("Azione obbligatoria in questa modalit\u00e0 di ricerca");
        }
        String uriAccordo = servizio.getAccordoServizioParteComune();
        if (uriAccordo == null) {
            throw new DriverRegistroServiziException("Identificativo dell'API non definito nel servizio");
        }
        IDAccordo idAccordo = this.idAccordoFactory.getIDAccordoFromUri(uriAccordo);
        AccordoServizioParteComune as = this.registroServizi.getAccordoServizioParteComune(connectionPdD, nomeRegistro, idAccordo);
        if (as == null) {
            throw new DriverRegistroServiziNotFound("API '" + uriAccordo + "' non trovata");
        }
        infoServizio.setIdAccordo(idAccordo);
        ServiceBinding serviceBinding = as.getServiceBinding();
        infoServizio.setServiceBinding(RegistroServiziUtils.convertToMessage((ServiceBinding)serviceBinding));
        infoServizio.setIDServizio(idService);
        if (ServiceBinding.SOAP.equals((Object)serviceBinding)) {
            return this._getInfoServizioSOAP(idService, servizio, idAccordo, as, uriAccordo, azione, infoServizio, idSoggetto, verificaEsistenzaServizioAzioneCorrelato, servizioCorrelato, azioneCorrelata, nomeRegistro, connectionPdD, throwAzioneNotFound);
        }
        return this._getInfoServizioREST(as, uriAccordo, azione, infoServizio, throwAzioneNotFound);
    }

    private Servizio _getInfoServizioREST(AccordoServizioParteComune as, String uriAccordo, String azione, Servizio infoServizio, boolean throwAzioneNotFound) throws DriverRegistroServiziAzioneNotFound {
        Resource resource = null;
        if (azione == null) {
            if (throwAzioneNotFound) {
                throw new DriverRegistroServiziAzioneNotFound("La richiesta effettuata non \u00e8 associabile a nessuna risorsa definita nell'API " + uriAccordo);
            }
        } else {
            boolean find = false;
            for (int i = 0; i < as.sizeResourceList(); ++i) {
                if (!azione.equals(as.getResource(i).getNome())) continue;
                resource = as.getResource(i);
                find = true;
                break;
            }
            if (!find && throwAzioneNotFound) {
                throw new DriverRegistroServiziAzioneNotFound("Risorsa '" + azione + "' non trovata nell'API " + uriAccordo);
            }
        }
        infoServizio.setInoltro(Inoltro.CON_DUPLICATI);
        infoServizio.setCollaborazione(false);
        infoServizio.setConfermaRicezione(false);
        infoServizio.setOrdineConsegna(false);
        infoServizio.setCorrelato(false);
        if (as.getProfiloCollaborazione() != null) {
            if (ProfiloCollaborazione.ONEWAY.equals((Object)as.getProfiloCollaborazione())) {
                infoServizio.setProfiloDiCollaborazione(ProfiloDiCollaborazione.ONEWAY);
            } else {
                infoServizio.setProfiloDiCollaborazione(ProfiloDiCollaborazione.SINCRONO);
            }
        } else {
            infoServizio.setProfiloDiCollaborazione(ProfiloDiCollaborazione.SINCRONO);
        }
        if (as.getIdCollaborazione() == null) {
            infoServizio.setCollaborazione(false);
        } else if (as.getIdCollaborazione().equals((Object)CostantiRegistroServizi.DISABILITATO)) {
            infoServizio.setCollaborazione(false);
        } else if (as.getIdCollaborazione().equals((Object)CostantiRegistroServizi.ABILITATO)) {
            infoServizio.setCollaborazione(true);
        } else {
            infoServizio.setCollaborazione(false);
        }
        if (as.getIdRiferimentoRichiesta() == null) {
            infoServizio.setIdRiferimentoRichiesta(false);
        } else if (as.getIdRiferimentoRichiesta().equals((Object)CostantiRegistroServizi.DISABILITATO)) {
            infoServizio.setIdRiferimentoRichiesta(false);
        } else if (as.getIdRiferimentoRichiesta().equals((Object)CostantiRegistroServizi.ABILITATO)) {
            infoServizio.setIdRiferimentoRichiesta(true);
        } else {
            infoServizio.setIdRiferimentoRichiesta(false);
        }
        if (as.getConsegnaInOrdine() == null) {
            infoServizio.setOrdineConsegna(false);
        } else if (as.getConsegnaInOrdine().equals((Object)CostantiRegistroServizi.DISABILITATO)) {
            infoServizio.setOrdineConsegna(false);
        } else if (as.getConsegnaInOrdine().equals((Object)CostantiRegistroServizi.ABILITATO)) {
            infoServizio.setOrdineConsegna(true);
        } else {
            infoServizio.setOrdineConsegna(false);
        }
        if (as.getConfermaRicezione() == null) {
            infoServizio.setConfermaRicezione(false);
        } else if (as.getConfermaRicezione().equals((Object)CostantiRegistroServizi.DISABILITATO)) {
            infoServizio.setConfermaRicezione(false);
        } else if (as.getConfermaRicezione().equals((Object)CostantiRegistroServizi.ABILITATO)) {
            infoServizio.setConfermaRicezione(true);
        } else {
            infoServizio.setConfermaRicezione(false);
        }
        if (as.getFiltroDuplicati() == null) {
            infoServizio.setInoltro(Inoltro.CON_DUPLICATI);
        } else if (as.getFiltroDuplicati().equals((Object)CostantiRegistroServizi.DISABILITATO)) {
            infoServizio.setInoltro(Inoltro.CON_DUPLICATI);
        } else if (as.getFiltroDuplicati().equals((Object)CostantiRegistroServizi.ABILITATO)) {
            infoServizio.setInoltro(Inoltro.SENZA_DUPLICATI);
        } else {
            infoServizio.setInoltro(Inoltro.CON_DUPLICATI);
        }
        if (as.getScadenza() != null) {
            try {
                long minuti = Long.parseLong(as.getScadenza());
                Date nowDate = DateManager.getDate();
                long now = nowDate.getTime();
                nowDate.setTime(now += minuti * 60L * 1000L);
                infoServizio.setScadenza(nowDate);
                infoServizio.setScadenzaMinuti(minuti);
            }
            catch (Exception minuti) {
                // empty catch block
            }
        }
        if (resource != null) {
            boolean ridefinisci = true;
            if ("default".equals(resource.getProfAzione())) {
                ridefinisci = false;
            }
            if (ridefinisci) {
                String scadenza;
                StatoFunzionalita filtroDuplicati;
                StatoFunzionalita confermaRicezione;
                StatoFunzionalita consegnaInOrdine;
                StatoFunzionalita idRiferimentoRichiesta;
                StatoFunzionalita idCollaborazione = resource.getIdCollaborazione();
                if (idCollaborazione != null) {
                    if (idCollaborazione.equals((Object)CostantiRegistroServizi.DISABILITATO)) {
                        infoServizio.setCollaborazione(false);
                    } else if (idCollaborazione.equals((Object)CostantiRegistroServizi.ABILITATO)) {
                        infoServizio.setCollaborazione(true);
                    }
                }
                if ((idRiferimentoRichiesta = resource.getIdRiferimentoRichiesta()) != null) {
                    if (idRiferimentoRichiesta.equals((Object)CostantiRegistroServizi.DISABILITATO)) {
                        infoServizio.setIdRiferimentoRichiesta(false);
                    } else if (idRiferimentoRichiesta.equals((Object)CostantiRegistroServizi.ABILITATO)) {
                        infoServizio.setIdRiferimentoRichiesta(true);
                    }
                }
                if ((consegnaInOrdine = resource.getConsegnaInOrdine()) != null) {
                    if (consegnaInOrdine.equals((Object)CostantiRegistroServizi.DISABILITATO)) {
                        infoServizio.setOrdineConsegna(false);
                    } else if (consegnaInOrdine.equals((Object)CostantiRegistroServizi.ABILITATO)) {
                        infoServizio.setOrdineConsegna(true);
                    }
                }
                if ((confermaRicezione = resource.getConfermaRicezione()) != null) {
                    if (confermaRicezione.equals((Object)CostantiRegistroServizi.DISABILITATO)) {
                        infoServizio.setConfermaRicezione(false);
                    } else if (confermaRicezione.equals((Object)CostantiRegistroServizi.ABILITATO)) {
                        infoServizio.setConfermaRicezione(true);
                    }
                }
                if ((filtroDuplicati = resource.getFiltroDuplicati()) != null) {
                    if (filtroDuplicati.equals((Object)CostantiRegistroServizi.DISABILITATO)) {
                        infoServizio.setInoltro(Inoltro.CON_DUPLICATI);
                    } else if (filtroDuplicati.equals((Object)CostantiRegistroServizi.ABILITATO)) {
                        infoServizio.setInoltro(Inoltro.SENZA_DUPLICATI);
                    }
                }
                if ((scadenza = resource.getScadenza()) != null) {
                    try {
                        long minuti = Long.parseLong(scadenza);
                        Date nowDate = DateManager.getDate();
                        long now = nowDate.getTime();
                        nowDate.setTime(now += minuti * 60L * 1000L);
                        infoServizio.setScadenza(nowDate);
                        infoServizio.setScadenzaMinuti(minuti);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return infoServizio;
    }

    private Servizio _getInfoServizioSOAP(IDServizio idService, AccordoServizioParteSpecifica servizio, IDAccordo idAccordo, AccordoServizioParteComune as, String uriAccordo, String azione, Servizio infoServizio, IDSoggetto idSoggetto, boolean verificaEsistenzaServizioAzioneCorrelato, boolean servizioCorrelato, boolean azioneCorrelata, String nomeRegistro, Connection connectionPdD, boolean throwAzioneNotFound) throws DriverRegistroServiziPortTypeNotFound, DriverRegistroServiziAzioneNotFound, DriverRegistroServiziCorrelatoNotFound, DriverRegistroServiziNotFound {
        Date nowDate;
        PortType pt = null;
        if (servizio.getPortType() != null) {
            for (int i = 0; i < as.sizePortTypeList(); ++i) {
                if (!servizio.getPortType().equals(as.getPortType(i).getNome())) continue;
                pt = as.getPortType(i);
            }
            if (pt == null) {
                throw new DriverRegistroServiziPortTypeNotFound("Servizio '" + servizio.getPortType() + "' non definito nell'API " + uriAccordo);
            }
        }
        Azione az = null;
        Operation ptAz = null;
        if (azione == null) {
            if (pt != null) {
                if (throwAzioneNotFound) {
                    throw new DriverRegistroServiziAzioneNotFound("La richiesta effettuata non \u00e8 associabile a nessuna azione (servizio: " + pt.getNome() + ") dell'API " + uriAccordo);
                }
            } else if (!as.getUtilizzoSenzaAzione() && throwAzioneNotFound) {
                throw new DriverRegistroServiziAzioneNotFound("La richiesta effettuata non \u00e8 associabile a nessuna azione dell'API " + uriAccordo + " (invocazione senza la definizione di una azione non permessa)");
            }
        } else {
            boolean find = false;
            if (pt != null) {
                for (i = 0; i < pt.sizeAzioneList(); ++i) {
                    if (!azione.equals(pt.getAzione(i).getNome())) continue;
                    ptAz = pt.getAzione(i);
                    find = true;
                    break;
                }
                if (!find && throwAzioneNotFound) {
                    throw new DriverRegistroServiziAzioneNotFound("Azione '" + azione + "' non trovata per il servizio [" + pt.getNome() + "] dell'API " + uriAccordo);
                }
            } else {
                for (i = 0; i < as.sizeAzioneList(); ++i) {
                    if (!azione.equals(as.getAzione(i).getNome())) continue;
                    az = as.getAzione(i);
                    find = true;
                    break;
                }
                if (!find && throwAzioneNotFound) {
                    throw new DriverRegistroServiziAzioneNotFound("Azione '" + azione + "' non trovata nell'API " + uriAccordo);
                }
            }
        }
        if (as.getProfiloCollaborazione() == null) {
            infoServizio.setProfiloDiCollaborazione(ProfiloDiCollaborazione.ONEWAY);
        } else if (as.getProfiloCollaborazione().equals((Object)CostantiRegistroServizi.ONEWAY)) {
            infoServizio.setProfiloDiCollaborazione(ProfiloDiCollaborazione.ONEWAY);
        } else if (as.getProfiloCollaborazione().equals((Object)CostantiRegistroServizi.SINCRONO)) {
            infoServizio.setProfiloDiCollaborazione(ProfiloDiCollaborazione.SINCRONO);
        } else if (as.getProfiloCollaborazione().equals((Object)CostantiRegistroServizi.ASINCRONO_SIMMETRICO)) {
            infoServizio.setProfiloDiCollaborazione(ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO);
        } else if (as.getProfiloCollaborazione().equals((Object)CostantiRegistroServizi.ASINCRONO_ASIMMETRICO)) {
            infoServizio.setProfiloDiCollaborazione(ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO);
        } else {
            infoServizio.setProfiloDiCollaborazione(ProfiloDiCollaborazione.ONEWAY);
        }
        if (as.getIdCollaborazione() == null) {
            infoServizio.setCollaborazione(false);
        } else if (as.getIdCollaborazione().equals((Object)CostantiRegistroServizi.DISABILITATO)) {
            infoServizio.setCollaborazione(false);
        } else if (as.getIdCollaborazione().equals((Object)CostantiRegistroServizi.ABILITATO)) {
            infoServizio.setCollaborazione(true);
        } else {
            infoServizio.setCollaborazione(false);
        }
        if (as.getIdRiferimentoRichiesta() == null) {
            infoServizio.setIdRiferimentoRichiesta(false);
        } else if (as.getIdRiferimentoRichiesta().equals((Object)CostantiRegistroServizi.DISABILITATO)) {
            infoServizio.setIdRiferimentoRichiesta(false);
        } else if (as.getIdRiferimentoRichiesta().equals((Object)CostantiRegistroServizi.ABILITATO)) {
            infoServizio.setIdRiferimentoRichiesta(true);
        } else {
            infoServizio.setIdRiferimentoRichiesta(false);
        }
        if (as.getConsegnaInOrdine() == null) {
            infoServizio.setOrdineConsegna(false);
        } else if (as.getConsegnaInOrdine().equals((Object)CostantiRegistroServizi.DISABILITATO)) {
            infoServizio.setOrdineConsegna(false);
        } else if (as.getConsegnaInOrdine().equals((Object)CostantiRegistroServizi.ABILITATO)) {
            infoServizio.setOrdineConsegna(true);
        } else {
            infoServizio.setOrdineConsegna(false);
        }
        if (as.getConfermaRicezione() == null) {
            infoServizio.setConfermaRicezione(false);
        } else if (as.getConfermaRicezione().equals((Object)CostantiRegistroServizi.DISABILITATO)) {
            infoServizio.setConfermaRicezione(false);
        } else if (as.getConfermaRicezione().equals((Object)CostantiRegistroServizi.ABILITATO)) {
            infoServizio.setConfermaRicezione(true);
        } else {
            infoServizio.setConfermaRicezione(false);
        }
        if (as.getFiltroDuplicati() == null) {
            infoServizio.setInoltro(Inoltro.CON_DUPLICATI);
        } else if (as.getFiltroDuplicati().equals((Object)CostantiRegistroServizi.DISABILITATO)) {
            infoServizio.setInoltro(Inoltro.CON_DUPLICATI);
        } else if (as.getFiltroDuplicati().equals((Object)CostantiRegistroServizi.ABILITATO)) {
            infoServizio.setInoltro(Inoltro.SENZA_DUPLICATI);
        } else {
            infoServizio.setInoltro(Inoltro.CON_DUPLICATI);
        }
        if (as.getScadenza() != null) {
            try {
                long minuti = Long.parseLong(as.getScadenza());
                nowDate = DateManager.getDate();
                long now = nowDate.getTime();
                nowDate.setTime(now += minuti * 60L * 1000L);
                infoServizio.setScadenza(nowDate);
                infoServizio.setScadenzaMinuti(minuti);
            }
            catch (Exception minuti) {
                // empty catch block
            }
        }
        if (pt != null) {
            boolean ridefinisci = true;
            if ("default".equals(pt.getProfiloPT())) {
                ridefinisci = false;
            }
            if (ridefinisci) {
                if (pt.getProfiloCollaborazione() != null) {
                    if (pt.getProfiloCollaborazione().equals((Object)CostantiRegistroServizi.ONEWAY)) {
                        infoServizio.setProfiloDiCollaborazione(ProfiloDiCollaborazione.ONEWAY);
                    } else if (pt.getProfiloCollaborazione().equals((Object)CostantiRegistroServizi.SINCRONO)) {
                        infoServizio.setProfiloDiCollaborazione(ProfiloDiCollaborazione.SINCRONO);
                    } else if (pt.getProfiloCollaborazione().equals((Object)CostantiRegistroServizi.ASINCRONO_SIMMETRICO)) {
                        infoServizio.setProfiloDiCollaborazione(ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO);
                    } else if (pt.getProfiloCollaborazione().equals((Object)CostantiRegistroServizi.ASINCRONO_ASIMMETRICO)) {
                        infoServizio.setProfiloDiCollaborazione(ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO);
                    }
                }
                if (pt.getIdCollaborazione() != null) {
                    if (pt.getIdCollaborazione().equals((Object)CostantiRegistroServizi.DISABILITATO)) {
                        infoServizio.setCollaborazione(false);
                    } else if (pt.getIdCollaborazione().equals((Object)CostantiRegistroServizi.ABILITATO)) {
                        infoServizio.setCollaborazione(true);
                    }
                }
                if (pt.getIdRiferimentoRichiesta() != null) {
                    if (pt.getIdRiferimentoRichiesta().equals((Object)CostantiRegistroServizi.DISABILITATO)) {
                        infoServizio.setIdRiferimentoRichiesta(false);
                    } else if (pt.getIdRiferimentoRichiesta().equals((Object)CostantiRegistroServizi.ABILITATO)) {
                        infoServizio.setIdRiferimentoRichiesta(true);
                    }
                }
                if (pt.getConsegnaInOrdine() != null) {
                    if (pt.getConsegnaInOrdine().equals((Object)CostantiRegistroServizi.DISABILITATO)) {
                        infoServizio.setOrdineConsegna(false);
                    } else if (pt.getConsegnaInOrdine().equals((Object)CostantiRegistroServizi.ABILITATO)) {
                        infoServizio.setOrdineConsegna(true);
                    }
                }
                if (pt.getConfermaRicezione() != null) {
                    if (pt.getConfermaRicezione().equals((Object)CostantiRegistroServizi.DISABILITATO)) {
                        infoServizio.setConfermaRicezione(false);
                    } else if (pt.getConfermaRicezione().equals((Object)CostantiRegistroServizi.ABILITATO)) {
                        infoServizio.setConfermaRicezione(true);
                    }
                }
                if (pt.getFiltroDuplicati() != null) {
                    if (pt.getFiltroDuplicati().equals((Object)CostantiRegistroServizi.DISABILITATO)) {
                        infoServizio.setInoltro(Inoltro.CON_DUPLICATI);
                    } else if (pt.getFiltroDuplicati().equals((Object)CostantiRegistroServizi.ABILITATO)) {
                        infoServizio.setInoltro(Inoltro.SENZA_DUPLICATI);
                    }
                }
                if (pt.getScadenza() != null) {
                    try {
                        long minuti = Long.parseLong(pt.getScadenza());
                        Date nowDate2 = DateManager.getDate();
                        long now = nowDate2.getTime();
                        nowDate2.setTime(now += minuti * 60L * 1000L);
                        infoServizio.setScadenza(nowDate2);
                        infoServizio.setScadenzaMinuti(minuti);
                    }
                    catch (Exception minuti) {
                        // empty catch block
                    }
                }
            }
        }
        if (az != null || ptAz != null) {
            boolean ridefinisci = true;
            if (az != null) {
                if ("default".equals(az.getProfAzione())) {
                    ridefinisci = false;
                }
            } else if ("default".equals(ptAz.getProfAzione())) {
                ridefinisci = false;
            }
            if (ridefinisci) {
                ProfiloCollaborazione profilo = null;
                profilo = az != null ? az.getProfiloCollaborazione() : ptAz.getProfiloCollaborazione();
                if (profilo != null) {
                    if (profilo.equals((Object)CostantiRegistroServizi.ONEWAY)) {
                        infoServizio.setProfiloDiCollaborazione(ProfiloDiCollaborazione.ONEWAY);
                    } else if (profilo.equals((Object)CostantiRegistroServizi.SINCRONO)) {
                        infoServizio.setProfiloDiCollaborazione(ProfiloDiCollaborazione.SINCRONO);
                    } else if (profilo.equals((Object)CostantiRegistroServizi.ASINCRONO_SIMMETRICO)) {
                        infoServizio.setProfiloDiCollaborazione(ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO);
                    } else if (profilo.equals((Object)CostantiRegistroServizi.ASINCRONO_ASIMMETRICO)) {
                        infoServizio.setProfiloDiCollaborazione(ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO);
                    }
                }
                StatoFunzionalita idCollaborazione = null;
                idCollaborazione = az != null ? az.getIdCollaborazione() : ptAz.getIdCollaborazione();
                if (idCollaborazione != null) {
                    if (idCollaborazione.equals((Object)CostantiRegistroServizi.DISABILITATO)) {
                        infoServizio.setCollaborazione(false);
                    } else if (idCollaborazione.equals((Object)CostantiRegistroServizi.ABILITATO)) {
                        infoServizio.setCollaborazione(true);
                    }
                }
                StatoFunzionalita idRiferimentoRichiesta = null;
                idRiferimentoRichiesta = az != null ? az.getIdRiferimentoRichiesta() : ptAz.getIdRiferimentoRichiesta();
                if (idRiferimentoRichiesta != null) {
                    if (idRiferimentoRichiesta.equals((Object)CostantiRegistroServizi.DISABILITATO)) {
                        infoServizio.setIdRiferimentoRichiesta(false);
                    } else if (idRiferimentoRichiesta.equals((Object)CostantiRegistroServizi.ABILITATO)) {
                        infoServizio.setIdRiferimentoRichiesta(true);
                    }
                }
                StatoFunzionalita consegnaInOrdine = null;
                consegnaInOrdine = az != null ? az.getConsegnaInOrdine() : ptAz.getConsegnaInOrdine();
                if (consegnaInOrdine != null) {
                    if (consegnaInOrdine.equals((Object)CostantiRegistroServizi.DISABILITATO)) {
                        infoServizio.setOrdineConsegna(false);
                    } else if (consegnaInOrdine.equals((Object)CostantiRegistroServizi.ABILITATO)) {
                        infoServizio.setOrdineConsegna(true);
                    }
                }
                StatoFunzionalita confermaRicezione = null;
                confermaRicezione = az != null ? az.getConfermaRicezione() : ptAz.getConfermaRicezione();
                if (confermaRicezione != null) {
                    if (confermaRicezione.equals((Object)CostantiRegistroServizi.DISABILITATO)) {
                        infoServizio.setConfermaRicezione(false);
                    } else if (confermaRicezione.equals((Object)CostantiRegistroServizi.ABILITATO)) {
                        infoServizio.setConfermaRicezione(true);
                    }
                }
                StatoFunzionalita filtroDuplicati = null;
                filtroDuplicati = az != null ? az.getFiltroDuplicati() : ptAz.getFiltroDuplicati();
                if (filtroDuplicati != null) {
                    if (filtroDuplicati.equals((Object)CostantiRegistroServizi.DISABILITATO)) {
                        infoServizio.setInoltro(Inoltro.CON_DUPLICATI);
                    } else if (filtroDuplicati.equals((Object)CostantiRegistroServizi.ABILITATO)) {
                        infoServizio.setInoltro(Inoltro.SENZA_DUPLICATI);
                    }
                }
                String scadenza = null;
                scadenza = az != null ? az.getScadenza() : ptAz.getScadenza();
                if (scadenza != null) {
                    try {
                        long minuti = Long.parseLong(scadenza);
                        Date nowDate3 = DateManager.getDate();
                        long now = nowDate3.getTime();
                        nowDate3.setTime(now += minuti * 60L * 1000L);
                        infoServizio.setScadenza(nowDate3);
                        infoServizio.setScadenzaMinuti(minuti);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        if (servizio.getIdCollaborazione() != null) {
            if (servizio.getIdCollaborazione().equals((Object)CostantiRegistroServizi.DISABILITATO)) {
                infoServizio.setCollaborazione(false);
            } else if (servizio.getIdCollaborazione().equals((Object)CostantiRegistroServizi.ABILITATO)) {
                infoServizio.setCollaborazione(true);
            }
        }
        if (servizio.getIdRiferimentoRichiesta() != null) {
            if (servizio.getIdRiferimentoRichiesta().equals((Object)CostantiRegistroServizi.DISABILITATO)) {
                infoServizio.setIdRiferimentoRichiesta(false);
            } else if (servizio.getIdRiferimentoRichiesta().equals((Object)CostantiRegistroServizi.ABILITATO)) {
                infoServizio.setIdRiferimentoRichiesta(true);
            }
        }
        if (servizio.getConsegnaInOrdine() != null) {
            if (servizio.getConsegnaInOrdine().equals((Object)CostantiRegistroServizi.DISABILITATO)) {
                infoServizio.setOrdineConsegna(false);
            } else if (servizio.getConsegnaInOrdine().equals((Object)CostantiRegistroServizi.ABILITATO)) {
                infoServizio.setOrdineConsegna(true);
            }
        }
        if (servizio.getConfermaRicezione() != null) {
            if (servizio.getConfermaRicezione().equals((Object)CostantiRegistroServizi.DISABILITATO)) {
                infoServizio.setConfermaRicezione(false);
            } else if (servizio.getConfermaRicezione().equals((Object)CostantiRegistroServizi.ABILITATO)) {
                infoServizio.setConfermaRicezione(true);
            }
        }
        if (servizio.getFiltroDuplicati() != null) {
            if (servizio.getFiltroDuplicati().equals((Object)CostantiRegistroServizi.DISABILITATO)) {
                infoServizio.setInoltro(Inoltro.CON_DUPLICATI);
            } else if (servizio.getFiltroDuplicati().equals((Object)CostantiRegistroServizi.ABILITATO)) {
                infoServizio.setInoltro(Inoltro.SENZA_DUPLICATI);
            }
        }
        if (servizio.getScadenza() != null) {
            try {
                long minuti = Long.parseLong(servizio.getScadenza());
                nowDate = DateManager.getDate();
                long now = nowDate.getTime();
                nowDate.setTime(now += minuti * 60L * 1000L);
                infoServizio.setScadenza(nowDate);
                infoServizio.setScadenzaMinuti(minuti);
            }
            catch (Exception minuti) {
                // empty catch block
            }
        }
        if (verificaEsistenzaServizioAzioneCorrelato) {
            if (ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals((Object)infoServizio.getProfiloDiCollaborazione())) {
                AccordoServizioParteSpecifica servizioC = null;
                try {
                    if (idSoggetto == null || idSoggetto.getTipo() == null || idSoggetto.getNome() == null) {
                        throw new Exception("Identita soggetto fruitore non fornita");
                    }
                    servizioC = this.registroServizi.getAccordoServizioParteSpecifica_ServizioCorrelato(connectionPdD, nomeRegistro, idSoggetto, idAccordo);
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziCorrelatoNotFound("getInfoServizio, servizio correlato da associare al servizio asincrono simmetrico non trovato: " + e.getMessage());
                }
                if (servizioC == null) {
                    throw new DriverRegistroServiziCorrelatoNotFound("getInfoServizio, servizio correlato da associare al servizio asincrono simmetrico non trovato");
                }
                if (servizioC.getNome() == null || servizioC.getTipo() == null || servizioC.getVersione() == null) {
                    throw new DriverRegistroServiziCorrelatoNotFound("getInfoServizio, servizio correlato al servizio asincrono simmetrico non configurato correttamente (tipo e/o nome is null?)");
                }
                infoServizio.setServizioCorrelato(servizioC.getNome());
                infoServizio.setTipoServizioCorrelato(servizioC.getTipo());
                infoServizio.setVersioneServizioCorrelato(servizioC.getVersione());
            }
            if (ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals((Object)infoServizio.getProfiloDiCollaborazione())) {
                DriverRegistroServiziCorrelatoNotFound eFound = null;
                AccordoServizioParteSpecifica servizioC = null;
                try {
                    servizioC = this.registroServizi.getAccordoServizioParteSpecifica_ServizioCorrelato(connectionPdD, nomeRegistro, idService.getSoggettoErogatore(), idAccordo);
                }
                catch (Exception e) {
                    eFound = new DriverRegistroServiziCorrelatoNotFound("servizio correlato da associare al servizio asincrono asimmetrico non trovato: " + e.getMessage());
                }
                if (eFound == null) {
                    if (servizioC == null) {
                        eFound = new DriverRegistroServiziCorrelatoNotFound("servizio correlato da associare al servizio asincrono asimmetrico non trovato");
                    } else if (servizioC.getNome() == null || servizioC.getTipo() == null || servizioC.getVersione() == null) {
                        throw new DriverRegistroServiziCorrelatoNotFound("servizio correlato al servizio asincrono asimmetrico non configurato correttamente (tipo e/o nome is null?)");
                    }
                }
                if (eFound != null) {
                    if (az != null) {
                        boolean find = false;
                        for (int i = 0; i < as.sizeAzioneList(); ++i) {
                            Azione azCheck = as.getAzione(i);
                            if (azCheck.getNome().equals(az.getNome()) || azCheck.getCorrelata() == null || !azCheck.getCorrelata().equals(az.getNome())) continue;
                            find = true;
                            break;
                        }
                        if (!find) {
                            throw new DriverRegistroServiziCorrelatoNotFound("getInfoServizio, azione correlata o " + eFound.getMessage());
                        }
                    } else if (ptAz != null && pt != null) {
                        boolean find = false;
                        for (int i = 0; i < pt.sizeAzioneList(); ++i) {
                            Operation azCheck = pt.getAzione(i);
                            if (azCheck.getNome().equals(ptAz.getNome()) || azCheck.getCorrelata() == null || !azCheck.getCorrelata().equals(ptAz.getNome()) || azCheck.getCorrelataServizio() != null && !"".equals(azCheck.getCorrelataServizio()) && !azCheck.getCorrelataServizio().equals(pt.getNome())) continue;
                            find = true;
                            break;
                        }
                        if (!find) {
                            throw new DriverRegistroServiziCorrelatoNotFound("getInfoServizio, azione correlata o " + eFound.getMessage());
                        }
                    } else {
                        throw eFound;
                    }
                }
            }
        }
        if (!servizioCorrelato && azioneCorrelata && ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals((Object)infoServizio.getProfiloDiCollaborazione())) {
            String azionePT = null;
            String correlazione = null;
            if (ptAz != null) {
                azionePT = ptAz.getNome();
                correlazione = ptAz.getCorrelata();
            } else if (az != null) {
                azionePT = az.getNome();
                correlazione = az.getCorrelata();
            }
            String uriServizio = null;
            try {
                uriServizio = IDServizioFactory.getInstance().getUriFromIDServizio(idService);
            }
            catch (Exception e) {
                uriServizio = idService.toString(false);
            }
            if (correlazione == null) {
                throw new DriverRegistroServiziNotFound("getInfoServizio, l'azione [" + azionePT + "] invocata con il servizio [" + uriServizio + "] non e' correlata ad un'altra azione dell'accordo");
            }
            boolean find = false;
            if (pt != null) {
                for (int i = 0; i < pt.sizeAzioneList(); ++i) {
                    if (!correlazione.equals(pt.getAzione(i).getNome())) continue;
                    find = true;
                    break;
                }
            } else {
                for (int i = 0; i < as.sizeAzioneList(); ++i) {
                    if (!correlazione.equals(as.getAzione(i).getNome())) continue;
                    find = true;
                    break;
                }
            }
            if (!find) {
                if (pt != null) {
                    throw new DriverRegistroServiziNotFound("getInfoServizio, l'operation [" + correlazione + "] definita come correlata nell'operation [" + azionePT + "] non esiste ( port type[" + pt.getNome() + "], servizio[" + uriServizio + "] accordo di servizio[" + uriAccordo + "]");
                }
                throw new DriverRegistroServiziNotFound("getInfoServizio, l'azione [" + correlazione + "] definita come correlata nell'azione [" + azionePT + "] non esiste ( servizio[" + uriServizio + "] accordo di servizio[" + uriAccordo + "]");
            }
        }
        return infoServizio;
    }

    protected Allegati getAllegati(Connection connectionPdD, IDServizio idASPS) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Allegati allegati = new Allegati();
        AccordoServizioParteSpecifica asps = this.registroServizi.getAccordoServizioParteSpecifica(connectionPdD, null, idASPS, true);
        allegati.setAllegatiASParteSpecifica(asps.getAllegatoList());
        allegati.setSpecificheSemiformaliASParteSpecifica(asps.getSpecificaSemiformaleList());
        allegati.setSpecificheSicurezzaASParteSpecifica(asps.getSpecificaSicurezzaList());
        allegati.setSpecificheLivelloServizioASParteSpecifica(asps.getSpecificaLivelloServizioList());
        AccordoServizioParteComune aspc = this.registroServizi.getAccordoServizioParteComune(connectionPdD, null, this.idAccordoFactory.getIDAccordoFromUri(asps.getAccordoServizioParteComune()), true, false);
        allegati.setAllegatiASParteComune(aspc.getAllegatoList());
        allegati.setSpecificheSemiformaliASParteComune(aspc.getSpecificaSemiformaleList());
        return allegati;
    }

    protected Documento getAllegato(Connection connectionPdD, IDAccordo idAccordo, String nome, RequestInfo requestInfo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServizi.getAllegato(connectionPdD, null, idAccordo, nome, requestInfo);
    }

    protected Documento getSpecificaSemiformale(Connection connectionPdD, IDAccordo idAccordo, TipiDocumentoSemiformale tipo, String nome, RequestInfo requestInfo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServizi.getSpecificaSemiformale(connectionPdD, null, idAccordo, tipo, nome, requestInfo);
    }

    protected Documento getAllegato(Connection connectionPdD, IDServizio idASPS, String nome, RequestInfo requestInfo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServizi.getAllegato(connectionPdD, null, idASPS, nome, requestInfo);
    }

    protected Documento getSpecificaSemiformale(Connection connectionPdD, IDServizio idASPS, TipiDocumentoSemiformale tipo, String nome, RequestInfo requestInfo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServizi.getSpecificaSemiformale(connectionPdD, null, idASPS, tipo, nome, requestInfo);
    }

    protected Documento getSpecificaSicurezza(Connection connectionPdD, IDServizio idASPS, TipiDocumentoSicurezza tipo, String nome, RequestInfo requestInfo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServizi.getSpecificaSicurezza(connectionPdD, null, idASPS, tipo, nome, requestInfo);
    }

    protected Documento getSpecificaLivelloServizio(Connection connectionPdD, IDServizio idASPS, TipiDocumentoLivelloServizio tipo, String nome, RequestInfo requestInfo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServizi.getSpecificaLivelloServizio(connectionPdD, null, idASPS, tipo, nome, requestInfo);
    }

    protected org.openspcoop2.core.registry.wsdl.AccordoServizioWrapper getWsdlAccordoServizio(Connection connectionPdD, IDServizio idService, InformationApiSource infoWsdlSource, boolean buildSchemaXSD, boolean readDatiRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServizi.getWsdlAccordoServizio(connectionPdD, null, idService, infoWsdlSource, buildSchemaXSD, readDatiRegistro);
    }

    protected AccordoServizioWrapper getRestAccordoServizio(Connection connectionPdD, IDServizio idService, InformationApiSource infoWsdlSource, boolean buildSchemaXSD, boolean processIncludeForOpenApi, boolean readDatiRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServizi.getRestAccordoServizio(connectionPdD, null, idService, infoWsdlSource, buildSchemaXSD, processIncludeForOpenApi, readDatiRegistro);
    }

    protected ServiceBinding getServiceBinding(Connection connectionPdD, IDServizio idService) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServizi.getServiceBinding(connectionPdD, null, idService);
    }

    protected EsitoAutorizzazioneRegistro isFruitoreServizioAutorizzato(Connection connectionPdD, String pdd, String servizioApplicativo, IDSoggetto soggetto, IDServizio servizio) throws DriverRegistroServiziException, DriverRegistroServiziNotFound, DriverRegistroServiziServizioNotFound {
        try {
            EsitoAutorizzazioneRegistro esitoAutorizzazione = new EsitoAutorizzazioneRegistro();
            if (soggetto == null) {
                String error = "identita del chiamante non fornita (autenticazione non attiva?)";
                this.log.error("Identita del chiamante non fornita");
                esitoAutorizzazione.setServizioAutorizzato(false);
                esitoAutorizzazione.setDetails(error);
                return esitoAutorizzazione;
            }
            Soggetto fruitoreSoggetto = this.registroServizi.getSoggetto(connectionPdD, null, soggetto);
            if (fruitoreSoggetto.getPortaDominio() != null) {
                PortaDominio portaDominio = this.registroServizi.getPortaDominio(connectionPdD, null, fruitoreSoggetto.getPortaDominio());
                StatoFunzionalita authMode = portaDominio.getClientAuth();
                if (authMode == null) {
                    authMode = CostantiRegistroServizi.DISABILITATO;
                }
                if (CostantiRegistroServizi.ABILITATO.equals((Object)authMode)) {
                    if (pdd == null) {
                        String error = "subject della porta di dominio che ha inviato la busta non presente (https attivo?, client-auth attivo?)";
                        this.log.error("Autorizzazione (" + soggetto.toString() + " -> " + servizio.toString() + ") fallita: " + error);
                        esitoAutorizzazione.setServizioAutorizzato(false);
                        esitoAutorizzazione.setDetails(error);
                        return esitoAutorizzazione;
                    }
                    if (!org.openspcoop2.utils.certificate.CertificateUtils.sslVerify((String)portaDominio.getSubject(), (String)pdd, (PrincipalType)PrincipalType.SUBJECT, (Logger)this.log)) {
                        String error = "subject estratto dal certificato client [" + pdd + "] diverso da quello registrato per la porta di dominio " + portaDominio.getNome() + " del mittente [" + portaDominio.getSubject() + "]";
                        this.log.error("Autorizzazione (" + soggetto.toString() + " -> " + servizio.toString() + ") fallita: " + error);
                        esitoAutorizzazione.setServizioAutorizzato(false);
                        esitoAutorizzazione.setDetails(error);
                        return esitoAutorizzazione;
                    }
                    this.log.info("Autorizzazione (" + soggetto.toString() + " -> " + servizio.toString() + ") effettuata: subject corrispondono");
                    esitoAutorizzazione.setServizioAutorizzato(true);
                    return esitoAutorizzazione;
                }
                if (CostantiRegistroServizi.DISABILITATO.equals((Object)authMode)) {
                    this.log.debug("Autorizzazione (" + soggetto.toString() + " -> " + servizio.toString() + ") effettuata: client-auth disabilitato nella porta di dominio " + portaDominio.getNome());
                    esitoAutorizzazione.setServizioAutorizzato(true);
                    esitoAutorizzazione.setDetails("client-auth disabilitato nella porta di dominio " + portaDominio.getNome());
                    return esitoAutorizzazione;
                }
                throw new Exception("Valore di client-auth presente nella porta di dominio " + portaDominio.getNome() + " non valido: " + String.valueOf(authMode));
            }
            this.log.debug("Autorizzazione (" + soggetto.toString() + " -> " + servizio.toString() + ") effettuata: client-auth non effettuata; il soggetto fruitore non \u00e8 associato ad una porta di dominio");
            esitoAutorizzazione.setServizioAutorizzato(true);
            esitoAutorizzazione.setDetails("client-auth disabilitato");
            return esitoAutorizzazione;
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (DriverRegistroServiziServizioNotFound e) {
            throw e;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Errore durante il controllo della fruizione di un servizio: " + e.getMessage(), (Throwable)e);
        }
    }

    private org.openspcoop2.core.config.Connettore getConnettore(IDSoggetto idSoggetto, String nomeConnettore, String nomeRegistro) {
        org.openspcoop2.core.registry.RegistroServizi[] registri = this.registroServizi.getRegistriServiziXML();
        if (registri != null) {
            for (int l = 0; l < registri.length; ++l) {
                for (int i = 0; i < registri[l].sizeConnettoreList(); ++i) {
                    if (!nomeConnettore.equals(registri[l].getConnettore(i).getNome())) continue;
                    Connettore conn = registri[l].getConnettore(i);
                    if (conn != null && !"none".equals(conn.getTipo())) {
                        return conn.mappingIntoConnettoreConfigurazione();
                    }
                    return null;
                }
            }
        }
        return null;
    }

    private org.openspcoop2.core.config.Connettore getConnettore(IDServizio idService, String nomeConnettore, String nomeRegistro) {
        org.openspcoop2.core.registry.RegistroServizi[] registri = this.registroServizi.getRegistriServiziXML();
        if (registri != null) {
            for (int l = 0; l < registri.length; ++l) {
                for (int i = 0; i < registri[l].sizeConnettoreList(); ++i) {
                    if (!nomeConnettore.equals(registri[l].getConnettore(i).getNome())) continue;
                    Connettore conn = registri[l].getConnettore(i);
                    if (conn != null && !"none".equals(conn.getTipo())) {
                        return conn.mappingIntoConnettoreConfigurazione();
                    }
                    return null;
                }
            }
        }
        return null;
    }

    protected org.openspcoop2.core.config.Connettore getConnettore(Connection connectionPdD, IDSoggetto idSoggetto, IDServizio idService, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Soggetto soggettoErogatore;
        int i;
        if (idService == null) {
            throw new DriverRegistroServiziException("getConnettore error: Servizio non definito");
        }
        AccordoServizioParteSpecifica servizio = null;
        try {
            servizio = this.registroServizi.getAccordoServizioParteSpecifica(connectionPdD, nomeRegistro, idService);
        }
        catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
            // empty catch block
        }
        String uriServizio = null;
        try {
            uriServizio = IDServizioFactory.getInstance().getUriFromIDServizio(idService);
        }
        catch (Exception e) {
            uriServizio = idService.toString(false);
        }
        if (servizio == null) {
            throw new DriverRegistroServiziNotFound("getConnettore, Servizio [" + uriServizio + "] non definito nel registro");
        }
        org.openspcoop2.core.config.Connettore connector = null;
        String azione = idService.getAzione();
        String nomeFruitore = idSoggetto.getNome();
        String tipoFruitore = idSoggetto.getTipo();
        if (connector == null || CostantiRegistroServizi.DISABILITATO.equals(connector.getTipo())) {
            for (i = 0; i < servizio.sizeFruitoreList(); ++i) {
                Fruitore f = servizio.getFruitore(i);
                if (f.getTipo() == null || f.getNome() == null || !f.getTipo().equals(tipoFruitore) || !f.getNome().equals(nomeFruitore)) continue;
                for (int j = 0; j < f.sizeConfigurazioneAzioneList(); ++j) {
                    boolean findAzione = false;
                    ConfigurazioneServizioAzione conf = f.getConfigurazioneAzione(j);
                    if (conf != null && conf.sizeAzioneList() > 0) {
                        for (String azioneCheck : conf.getAzioneList()) {
                            if (azione == null || !azione.equals(azioneCheck)) continue;
                            findAzione = true;
                        }
                    }
                    if (!findAzione) continue;
                    if (conf.getConnettore() == null) break;
                    if (conf.getConnettore().getTipo() != null) {
                        connector = conf.getConnettore().mappingIntoConnettoreConfigurazione();
                        break;
                    }
                    connector = this.getConnettore(idService, conf.getConnettore().getNome(), nomeRegistro);
                    break;
                }
                if (connector != null && !CostantiRegistroServizi.DISABILITATO.equals(connector.getTipo()) || f.getConnettore() == null) break;
                if (f.getConnettore().getTipo() != null) {
                    connector = f.getConnettore().mappingIntoConnettoreConfigurazione();
                    break;
                }
                connector = this.getConnettore(idService, f.getConnettore().getNome(), nomeRegistro);
                break;
            }
        }
        if ((connector == null || CostantiRegistroServizi.DISABILITATO.equals(connector.getTipo())) && azione != null && servizio.getConfigurazioneServizio() != null) {
            for (i = 0; i < servizio.getConfigurazioneServizio().sizeConfigurazioneAzioneList(); ++i) {
                boolean findAzione = false;
                ConfigurazioneServizioAzione conf = servizio.getConfigurazioneServizio().getConfigurazioneAzione(i);
                if (conf != null && conf.sizeAzioneList() > 0) {
                    for (String azioneCheck : conf.getAzioneList()) {
                        if (!azione.equals(azioneCheck)) continue;
                        findAzione = true;
                    }
                }
                if (!findAzione) continue;
                if (conf.getConnettore() == null) break;
                if (conf.getConnettore().getTipo() != null) {
                    connector = conf.getConnettore().mappingIntoConnettoreConfigurazione();
                    break;
                }
                connector = this.getConnettore(idService, conf.getConnettore().getNome(), nomeRegistro);
                break;
            }
        }
        if ((connector == null || CostantiRegistroServizi.DISABILITATO.equals(connector.getTipo())) && servizio.getConfigurazioneServizio() != null && servizio.getConfigurazioneServizio().getConnettore() != null) {
            connector = servizio.getConfigurazioneServizio().getConnettore().getTipo() != null ? servizio.getConfigurazioneServizio().getConnettore().mappingIntoConnettoreConfigurazione() : this.getConnettore(idService, servizio.getConfigurazioneServizio().getConnettore().getNome(), nomeRegistro);
        }
        if ((connector == null || CostantiRegistroServizi.DISABILITATO.equals(connector.getTipo())) && (soggettoErogatore = this.registroServizi.getSoggetto(connectionPdD, nomeRegistro, idService.getSoggettoErogatore())).getConnettore() != null) {
            connector = soggettoErogatore.getConnettore().getTipo() != null ? soggettoErogatore.getConnettore().mappingIntoConnettoreConfigurazione() : this.getConnettore(idService, soggettoErogatore.getConnettore().getNome(), nomeRegistro);
        }
        if (connector == null || CostantiRegistroServizi.DISABILITATO.equals(connector.getTipo())) {
            throw new DriverRegistroServiziNotFound("Connettore non trovato per il Servizio [" + idService.toString() + "]");
        }
        connector.setNomeDestinatarioTrasmissioneBusta(idService.getSoggettoErogatore().getNome());
        connector.setTipoDestinatarioTrasmissioneBusta(idService.getSoggettoErogatore().getTipo());
        return connector;
    }

    protected org.openspcoop2.core.config.Connettore getConnettore(Connection connectionPdD, IDSoggetto idSoggetto, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idSoggetto == null) {
            throw new DriverRegistroServiziException("getConnettore error: Soggetto destinatario non definito");
        }
        org.openspcoop2.core.config.Connettore connector = null;
        Soggetto soggetto = this.registroServizi.getSoggetto(connectionPdD, nomeRegistro, idSoggetto);
        if (soggetto.getConnettore() != null) {
            connector = soggetto.getConnettore().getTipo() != null ? soggetto.getConnettore().mappingIntoConnettoreConfigurazione() : this.getConnettore(idSoggetto, soggetto.getConnettore().getNome(), nomeRegistro);
        }
        if (connector == null || CostantiRegistroServizi.DISABILITATO.equals(connector.getTipo())) {
            throw new DriverRegistroServiziNotFound("Connettore non trovato per il Soggetto [" + idSoggetto.toString() + "]");
        }
        connector.setNomeDestinatarioTrasmissioneBusta(idSoggetto.getNome());
        connector.setTipoDestinatarioTrasmissioneBusta(idSoggetto.getTipo());
        return connector;
    }

    protected String getDominio(Connection connectionPdD, IDSoggetto idSoggetto, String nomeRegistro, IProtocolFactory<?> protocolFactory) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idSoggetto == null) {
            throw new DriverRegistroServiziException("getDominio error: soggetto non definito");
        }
        Soggetto soggetto = this.registroServizi.getSoggetto(connectionPdD, nomeRegistro, idSoggetto);
        if (soggetto == null) {
            throw new DriverRegistroServiziNotFound("getDominio, soggetto non definito nel registro");
        }
        if (soggetto.getIdentificativoPorta() != null) {
            return soggetto.getIdentificativoPorta();
        }
        try {
            return protocolFactory.createTraduttore().getIdentificativoPortaDefault(idSoggetto);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), (Throwable)e);
        }
    }

    protected String getImplementazionePdD(Connection connectionPdD, IDSoggetto idSoggetto, String nomeRegistro) throws DriverRegistroServiziException {
        try {
            PortaDominio pdd = this.getPortaDominio(connectionPdD, idSoggetto, nomeRegistro, "getImplementazionePdD");
            if (pdd.getImplementazione() != null) {
                return pdd.getImplementazione();
            }
            return "standard";
        }
        catch (DriverRegistroServiziNotFound e) {
            return "standard";
        }
    }

    protected String getIdPortaDominio(Connection connectionPdD, IDSoggetto idSoggetto, String nomeRegistro) throws DriverRegistroServiziException {
        try {
            PortaDominio pdd = this.getPortaDominio(connectionPdD, idSoggetto, nomeRegistro, "getImplementazionePdD");
            return pdd.getNome();
        }
        catch (DriverRegistroServiziNotFound e) {
            return null;
        }
    }

    private PortaDominio getPortaDominio(Connection connectionPdD, IDSoggetto idSoggetto, String nomeRegistro, String nomeMetodo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idSoggetto == null) {
            throw new DriverRegistroServiziException(nomeMetodo + " error: soggetto non definito");
        }
        Soggetto soggetto = null;
        try {
            soggetto = this.registroServizi.getSoggetto(connectionPdD, nomeRegistro, idSoggetto);
            if (soggetto == null) {
                throw new DriverRegistroServiziNotFound("Soggetto non esistente (null)");
            }
        }
        catch (DriverRegistroServiziNotFound e) {
            this.log.debug(nomeMetodo + ", soggetto [" + idSoggetto.toString() + "] non trovato: " + e.getMessage());
            throw e;
        }
        catch (DriverRegistroServiziException ex) {
            this.log.error(nomeMetodo + ", soggetto [" + idSoggetto.toString() + "] ricerca con errore: " + ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            this.log.error(nomeMetodo + ", soggetto [" + idSoggetto.toString() + "] ricerca con errore generale: " + ex.getMessage(), (Throwable)ex);
            throw new DriverRegistroServiziException(nomeMetodo + ", soggetto [" + idSoggetto.toString() + "] ricerca con errore generale: " + ex.getMessage(), (Throwable)ex);
        }
        if (soggetto.getPortaDominio() != null) {
            PortaDominio pdd = null;
            try {
                pdd = this.registroServizi.getPortaDominio(connectionPdD, nomeRegistro, soggetto.getPortaDominio());
                if (pdd == null) {
                    throw new DriverRegistroServiziNotFound("PdD non esistente (null)");
                }
            }
            catch (DriverRegistroServiziNotFound e) {
                this.log.debug(nomeMetodo + ", porta di domino [" + soggetto.getPortaDominio() + "] associata al soggetto [" + idSoggetto.toString() + "] non trovata: " + e.getMessage());
                throw new DriverRegistroServiziNotFound("Il soggetto [" + idSoggetto.toString() + "] \u00e8 associato ad una Porta di Dominio [" + soggetto.getPortaDominio() + "] non registrata", (Throwable)e);
            }
            catch (DriverRegistroServiziException ex) {
                this.log.error(nomeMetodo + ", porta di domino [" + soggetto.getPortaDominio() + "] associata al soggetto [" + idSoggetto.toString() + "]  ricerca con errore: " + ex.getMessage(), (Throwable)ex);
                throw ex;
            }
            catch (Exception ex) {
                this.log.error(nomeMetodo + ", porta di domino [" + soggetto.getPortaDominio() + "] associata al soggetto [" + idSoggetto.toString() + "]  ricerca con errore generale: " + ex.getMessage(), (Throwable)ex);
                throw new DriverRegistroServiziException(nomeMetodo + ", porta di domino [" + soggetto.getPortaDominio() + "] associata al soggetto [" + idSoggetto.toString() + "]  ricerca con errore generale: " + ex.getMessage(), (Throwable)ex);
            }
            return pdd;
        }
        throw new DriverRegistroServiziNotFound("Il soggetto [" + idSoggetto.toString() + "] non \u00e8 associato a nessuna Porta di Dominio");
    }

    protected RisultatoValidazione validaServizio(Connection connectionPdD, IDSoggetto soggettoFruitore, IDServizio idService, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziPortTypeNotFound {
        int i;
        RisultatoValidazione risultato = new RisultatoValidazione();
        if (idService == null) {
            risultato.setServizioRegistrato(false);
            return risultato;
        }
        boolean correlato = false;
        AccordoServizioParteSpecifica servizio = null;
        try {
            servizio = this.registroServizi.getAccordoServizioParteSpecifica(connectionPdD, nomeRegistro, idService);
        }
        catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
            // empty catch block
        }
        if (servizio == null) {
            risultato.setServizioRegistrato(false);
            return risultato;
        }
        correlato = TipologiaServizio.CORRELATO.equals((Object)servizio.getTipologiaServizio());
        risultato.setIsServizioCorrelato(correlato);
        String uriAccordo = servizio.getAccordoServizioParteComune();
        IDAccordo idAccordo = this.idAccordoFactory.getIDAccordoFromUri(uriAccordo);
        AccordoServizioParteComune as = null;
        try {
            as = this.registroServizi.getAccordoServizioParteComune(connectionPdD, nomeRegistro, idAccordo);
        }
        catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
            // empty catch block
        }
        if (as == null) {
            risultato.setServizioRegistrato(false);
            return risultato;
        }
        ServiceBinding serviceBinding = as.getServiceBinding();
        if (ServiceBinding.REST.equals((Object)serviceBinding)) {
            risultato.setAccessoSenzaAzione(false);
            for (int i2 = 0; i2 < as.sizeResourceList(); ++i2) {
                risultato.addAzione(as.getResource(i2).getNome());
            }
            risultato.setServizioRegistrato(true);
            return risultato;
        }
        PortType pt = null;
        if (servizio.getPortType() != null) {
            for (i = 0; i < as.sizePortTypeList(); ++i) {
                if (!servizio.getPortType().equals(as.getPortType(i).getNome())) continue;
                pt = as.getPortType(i);
            }
            if (pt == null) {
                throw new DriverRegistroServiziPortTypeNotFound("Port-Type [" + servizio.getPortType() + "] associato al servizio non definito nell'accordo di servizio " + uriAccordo);
            }
        }
        if (pt != null) {
            risultato.setAccessoSenzaAzione(false);
        } else {
            risultato.setAccessoSenzaAzione(as.getUtilizzoSenzaAzione());
        }
        if (!correlato && soggettoFruitore != null) {
            ProfiloCollaborazione profiloCollaborazione = as.getProfiloCollaborazione();
            if (idService.getAzione() != null) {
                if (pt != null) {
                    if (pt.getProfiloCollaborazione() != null) {
                        profiloCollaborazione = pt.getProfiloCollaborazione();
                    }
                    for (k = 0; k < pt.sizeAzioneList(); ++k) {
                        if (!idService.getAzione().equals(pt.getAzione(k).getNome())) continue;
                        if (pt.getAzione(k).getProfiloCollaborazione() == null) break;
                        profiloCollaborazione = pt.getAzione(k).getProfiloCollaborazione();
                        break;
                    }
                } else {
                    for (k = 0; k < as.sizeAzioneList(); ++k) {
                        if (!idService.getAzione().equals(as.getAzione(k).getNome())) continue;
                        if (as.getAzione(k).getProfiloCollaborazione() == null) break;
                        profiloCollaborazione = as.getAzione(k).getProfiloCollaborazione();
                        break;
                    }
                }
            }
            if (CostantiRegistroServizi.ASINCRONO_SIMMETRICO.equals((Object)profiloCollaborazione)) {
                AccordoServizioParteSpecifica servizioC = null;
                try {
                    servizioC = this.registroServizi.getAccordoServizioParteSpecifica_ServizioCorrelato(connectionPdD, nomeRegistro, soggettoFruitore, idAccordo);
                }
                catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                    // empty catch block
                }
                if (servizioC != null && servizioC.getNome() != null && servizioC.getTipo() != null && servizioC.getVersione() != null) {
                    risultato.setTipoServizioCorrelato(servizioC.getTipo());
                    risultato.setServizioCorrelato(servizioC.getNome());
                    risultato.setVersioneServizioCorrelato(servizioC.getVersione());
                }
            } else if (CostantiRegistroServizi.ASINCRONO_ASIMMETRICO.equals((Object)profiloCollaborazione)) {
                String azioneRichiesta = idService.getAzione();
                String azioneCorrelata = null;
                if (azioneRichiesta != null) {
                    if (pt != null) {
                        for (i = 0; i < pt.sizeAzioneList(); ++i) {
                            if (!azioneRichiesta.equals(pt.getAzione(i).getCorrelata())) continue;
                            azioneCorrelata = pt.getAzione(i).getCorrelata();
                            break;
                        }
                    } else {
                        for (i = 0; i < as.sizeAzioneList(); ++i) {
                            if (!azioneRichiesta.equals(as.getAzione(i).getCorrelata())) continue;
                            azioneCorrelata = as.getAzione(i).getCorrelata();
                            break;
                        }
                    }
                }
                if (azioneCorrelata != null) {
                    risultato.setTipoServizioCorrelato(idService.getTipo());
                    risultato.setServizioCorrelato(idService.getNome());
                    risultato.setVersioneServizioCorrelato(idService.getVersione());
                    risultato.setAzioneCorrelata(azioneCorrelata);
                } else {
                    AccordoServizioParteSpecifica servizioC = null;
                    try {
                        servizioC = this.registroServizi.getAccordoServizioParteSpecifica_ServizioCorrelato(connectionPdD, nomeRegistro, idService.getSoggettoErogatore(), idAccordo);
                    }
                    catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                        // empty catch block
                    }
                    if (servizioC != null && servizioC.getNome() != null && servizioC.getTipo() != null && servizioC.getVersione() != null) {
                        risultato.setTipoServizioCorrelato(servizioC.getTipo());
                        risultato.setServizioCorrelato(servizioC.getNome());
                        risultato.setVersioneServizioCorrelato(servizioC.getVersione());
                    }
                }
            }
        }
        if (pt != null) {
            for (i = 0; i < pt.sizeAzioneList(); ++i) {
                risultato.addAzione(pt.getAzione(i).getNome());
            }
        } else {
            for (i = 0; i < as.sizeAzioneList(); ++i) {
                risultato.addAzione(as.getAzione(i).getNome());
            }
        }
        risultato.setServizioRegistrato(true);
        return risultato;
    }

    public Soggetto getSoggettoByCredenzialiBasic(Connection connectionPdD, String username, String password, CryptConfig cryptConfig, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServizi.getSoggettoByCredenzialiBasic(connectionPdD, nomeRegistro, username, password, cryptConfig);
    }

    public Soggetto getSoggettoByCredenzialiApiKey(Connection connectionPdD, String username, String password, boolean appId, CryptConfig cryptConfig, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServizi.getSoggettoByCredenzialiApiKey(connectionPdD, nomeRegistro, username, password, appId, cryptConfig);
    }

    public Soggetto getSoggettoByCredenzialiSsl(Connection connectionPdD, String subject, String issuer, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServizi.getSoggettoByCredenzialiSsl(connectionPdD, nomeRegistro, subject, issuer);
    }

    public Soggetto getSoggettoByCredenzialiSsl(Connection connectionPdD, CertificateInfo certificate, boolean strictVerifier, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServizi.getSoggettoByCredenzialiSsl(connectionPdD, nomeRegistro, certificate, strictVerifier);
    }

    public Soggetto getSoggettoByCredenzialiPrincipal(Connection connectionPdD, String principal, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServizi.getSoggettoByCredenzialiPrincipal(connectionPdD, nomeRegistro, principal);
    }

    public IDSoggetto getIdSoggettoByCredenzialiBasic(Connection connectionPdD, String username, String password, CryptConfig cryptConfig, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.convertToId(this.registroServizi.getSoggettoByCredenzialiBasic(connectionPdD, nomeRegistro, username, password, cryptConfig));
    }

    public IDSoggetto getIdSoggettoByCredenzialiApiKey(Connection connectionPdD, String username, String password, boolean appId, CryptConfig cryptConfig, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.convertToId(this.registroServizi.getSoggettoByCredenzialiApiKey(connectionPdD, nomeRegistro, username, password, appId, cryptConfig));
    }

    public IDSoggetto getIdSoggettoByCredenzialiSsl(Connection connectionPdD, String subject, String issuer, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.convertToId(this.registroServizi.getSoggettoByCredenzialiSsl(connectionPdD, nomeRegistro, subject, issuer));
    }

    public IDSoggetto getIdSoggettoByCredenzialiSsl(Connection connectionPdD, CertificateInfo certificate, boolean strictVerifier, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.convertToId(this.registroServizi.getSoggettoByCredenzialiSsl(connectionPdD, nomeRegistro, certificate, strictVerifier));
    }

    public IDSoggetto getIdSoggettoByCredenzialiPrincipal(Connection connectionPdD, String principal, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.convertToId(this.registroServizi.getSoggettoByCredenzialiPrincipal(connectionPdD, nomeRegistro, principal));
    }

    private IDSoggetto convertToId(Soggetto s) {
        IDSoggetto id = new IDSoggetto(s.getTipo(), s.getNome(), s.getIdentificativoPorta());
        return id;
    }

    public Map<String, String> getProprietaConfigurazione(Soggetto soggetto) throws DriverRegistroServiziException {
        if (soggetto == null) {
            throw new DriverRegistroServiziException("Soggetto non fornito");
        }
        if (soggetto.sizeProprietaList() <= 0) {
            return null;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        for (int i = 0; i < soggetto.sizeProprietaList(); ++i) {
            Proprieta p = soggetto.getProprieta(i);
            properties.put(p.getNome(), p.getValore());
        }
        return properties;
    }

    protected CertificateCheck checkCertificatoSoggetto(Connection connectionPdD, boolean useCache, long idSoggetto, int sogliaWarningGiorni, boolean addCertificateDetails, String separator, String newLine) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (useCache) {
            throw new DriverRegistroServiziException("Not Implemented");
        }
        Soggetto soggetto = null;
        Iterator<IDriverRegistroServiziGet> iterator = this.registroServizi.getDriverRegistroServizi().values().iterator();
        if (iterator.hasNext()) {
            IDriverRegistroServiziGet driver = iterator.next();
            if (driver instanceof DriverRegistroServiziDB) {
                DriverRegistroServiziDB driverDB = (DriverRegistroServiziDB)driver;
                soggetto = driverDB.getSoggetto(idSoggetto);
            } else {
                throw new DriverRegistroServiziException("Not Implemented with driver '" + driver.getClass().getName() + "'");
            }
        }
        return RegistroServiziReader.checkCertificatoSoggetto(soggetto, sogliaWarningGiorni, addCertificateDetails, separator, newLine, this.log);
    }

    protected CertificateCheck checkCertificatoSoggetto(Connection connectionPdD, boolean useCache, IDSoggetto idSoggetto, int sogliaWarningGiorni, boolean addCertificateDetails, String separator, String newLine) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Soggetto soggetto = null;
        if (useCache) {
            this.registroServizi.getSoggetto(connectionPdD, null, idSoggetto);
        } else {
            for (IDriverRegistroServiziGet driver : this.registroServizi.getDriverRegistroServizi().values()) {
                soggetto = driver.getSoggetto(idSoggetto);
            }
        }
        return RegistroServiziReader.checkCertificatoSoggetto(soggetto, sogliaWarningGiorni, addCertificateDetails, separator, newLine, this.log);
    }

    public static CertificateCheck checkCertificatoSoggetto(Soggetto soggetto, int sogliaWarningGiorni, boolean addCertificateDetails, String separator, String newLine, Logger log) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (soggetto == null) {
            throw new DriverRegistroServiziException("Param soggetto is null");
        }
        if (soggetto.sizeCredenzialiList() <= 0) {
            throw new DriverRegistroServiziException("Nessuna credenziale risulta associata al soggetto");
        }
        ArrayList<byte[]> certs = new ArrayList<byte[]>();
        ArrayList<Boolean> strictValidation = new ArrayList<Boolean>();
        for (int i = 0; i < soggetto.sizeCredenzialiList(); ++i) {
            CredenzialiSoggetto c = soggetto.getCredenziali(i);
            if (!CredenzialeTipo.SSL.equals((Object)c.getTipo())) {
                throw new DriverRegistroServiziException("La credenziale (" + String.valueOf(c.getTipo()) + ") associata al soggetto non \u00e8 un certificato x509");
            }
            if (c.getCertificate() == null) continue;
            certs.add(c.getCertificate());
            strictValidation.add(c.isCertificateStrictVerification());
        }
        if (certs.isEmpty()) {
            throw new DriverRegistroServiziException("Nessun certificato risulta associata al soggetto");
        }
        try {
            return CertificateUtils.checkCertificateClient(certs, strictValidation, sogliaWarningGiorni, addCertificateDetails, separator, newLine, log);
        }
        catch (Throwable t) {
            throw new DriverRegistroServiziException(t.getMessage(), t);
        }
    }

    protected CertificateCheck checkCertificatiConnettoreHttpsById(Connection connectionPdD, boolean useCache, long idConnettore, int sogliaWarningGiorni, IBYOKUnwrapFactory byokUnwrapFactory, boolean addCertificateDetails, String separator, String newLine) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (useCache) {
            throw new DriverRegistroServiziException("Not Implemented");
        }
        Connettore connettore = null;
        Iterator<IDriverRegistroServiziGet> iterator = this.registroServizi.getDriverRegistroServizi().values().iterator();
        if (iterator.hasNext()) {
            IDriverRegistroServiziGet driver = iterator.next();
            if (driver instanceof DriverRegistroServiziDB) {
                DriverRegistroServiziDB driverDB = (DriverRegistroServiziDB)driver;
                connettore = driverDB.getConnettore(idConnettore);
            } else {
                throw new DriverRegistroServiziException("Not Implemented with driver '" + driver.getClass().getName() + "'");
            }
        }
        return RegistroServiziReader.checkCertificatiConnettoreHttpsById(connettore, sogliaWarningGiorni, byokUnwrapFactory, addCertificateDetails, separator, newLine, this.log);
    }

    public static CertificateCheck checkCertificatiConnettoreHttpsById(Connettore connettore, int sogliaWarningGiorni, IBYOKUnwrapFactory byokUnwrapFactory, boolean addCertificateDetails, String separator, String newLine, Logger log) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (connettore == null) {
            throw new DriverRegistroServiziException("Param connettore is null");
        }
        TipiConnettore tipo = TipiConnettore.toEnumFromName((String)connettore.getTipo());
        if (!TipiConnettore.HTTPS.equals((Object)tipo)) {
            throw new DriverRegistroServiziException("Il connettore indicato non \u00e8 di tipo https");
        }
        ConnettoreHTTPSProperties httpsProp = null;
        try {
            httpsProp = ConnettoreHTTPSProperties.readProperties((Map)connettore.getProperties());
        }
        catch (Throwable t) {
            throw new DriverRegistroServiziException(t.getMessage(), t);
        }
        CertificateCheck check = null;
        boolean classpathSupported = false;
        String storeDetails = null;
        if (httpsProp.getKeyStoreLocation() != null) {
            try {
                IBYOKUnwrapManager byokUnwrapManager = null;
                if (byokUnwrapFactory != null && httpsProp.getKeyStoreBYOKPolicy() != null) {
                    byokUnwrapManager = byokUnwrapFactory.newInstance(httpsProp.getKeyStoreBYOKPolicy(), log);
                }
                if ((check = CertificateUtils.checkKeyStore(httpsProp.getKeyStoreLocation(), classpathSupported, httpsProp.getKeyStoreType(), httpsProp.getKeyStorePassword(), byokUnwrapManager, httpsProp.getKeyAlias(), httpsProp.getKeyPassword(), sogliaWarningGiorni, false, separator, newLine, log)) != null && !StatoCheck.OK.equals((Object)check.getStatoCheck())) {
                    storeDetails = CertificateUtils.toStringKeyStore(httpsProp.getKeyStoreLocation(), httpsProp.getKeyStoreType(), httpsProp.getKeyStoreBYOKPolicy(), httpsProp.getKeyAlias(), separator, newLine);
                }
            }
            catch (Throwable t) {
                throw new DriverRegistroServiziException(t.getMessage(), t);
            }
        }
        if ((check == null || StatoCheck.OK.equals((Object)check.getStatoCheck())) && !httpsProp.isTrustAllCerts() && httpsProp.getTrustStoreLocation() != null) {
            try {
                check = CertificateUtils.checkTrustStore(httpsProp.getTrustStoreLocation(), classpathSupported, httpsProp.getTrustStoreType(), httpsProp.getTrustStorePassword(), httpsProp.getTrustStoreCRLsLocation(), httpsProp.getTrustStoreOCSPPolicy(), sogliaWarningGiorni, false, separator, newLine, log);
                if (check != null && !StatoCheck.OK.equals((Object)check.getStatoCheck())) {
                    storeDetails = CertificateUtils.toStringTrustStore(httpsProp.getTrustStoreLocation(), httpsProp.getTrustStoreType(), httpsProp.getTrustStoreCRLsLocation(), httpsProp.getTrustStoreOCSPPolicy(), separator, newLine);
                }
            }
            catch (Throwable t) {
                throw new DriverRegistroServiziException(t.getMessage(), t);
            }
        }
        if (check != null && !StatoCheck.OK.equals((Object)check.getStatoCheck())) {
            Object id = ID_CONFIGURAZIONE_CONNETTORE_HTTPS;
            if (addCertificateDetails && storeDetails != null) {
                id = (String)id + newLine + storeDetails;
            }
            check.setConfigurationId((String)id);
        }
        if (check == null) {
            check = new CertificateCheck();
            check.setStatoCheck(StatoCheck.OK);
        }
        return check;
    }

    protected CertificateCheck checkCertificatiModIErogazioneById(Connection connectionPdD, boolean useCache, long idAsps, int sogliaWarningGiorni, IBYOKUnwrapFactory byokUnwrapFactory, boolean addCertificateDetails, String separator, String newLine) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (connectionPdD != null) {
            // empty if block
        }
        if (useCache) {
            throw new DriverRegistroServiziException("Not Implemented");
        }
        AccordoServizioParteSpecifica asps = null;
        AccordoServizioParteComune api = null;
        Iterator<IDriverRegistroServiziGet> iterator = this.registroServizi.getDriverRegistroServizi().values().iterator();
        if (iterator.hasNext()) {
            IDriverRegistroServiziGet driver = iterator.next();
            if (driver instanceof DriverRegistroServiziDB) {
                DriverRegistroServiziDB driverDB = (DriverRegistroServiziDB)driver;
                asps = driverDB.getAccordoServizioParteSpecifica(idAsps);
                IDAccordo idAccordo = IDAccordoFactory.getInstance().getIDAccordoFromUri(asps.getAccordoServizioParteComune());
                api = driverDB.getAccordoServizioParteComune(idAccordo);
            } else {
                throw new DriverRegistroServiziException("Not Implemented with driver '" + driver.getClass().getName() + "'");
            }
        }
        return RegistroServiziReader.checkCertificatiModIErogazioneById(api, asps, sogliaWarningGiorni, byokUnwrapFactory, addCertificateDetails, separator, newLine, this.log);
    }

    public static CertificateCheck checkCertificatiModIErogazioneById(AccordoServizioParteComune api, AccordoServizioParteSpecifica asps, int sogliaWarningGiorni, IBYOKUnwrapFactory byokUnwrapFactory, boolean addCertificateDetails, String separator, String newLine, Logger log) throws DriverRegistroServiziException {
        if (asps == null) {
            throw new DriverRegistroServiziException("Param asps is null");
        }
        boolean modi = asps.getTipoSoggettoErogatore().equals("modipa");
        if (!modi) {
            throw new DriverRegistroServiziException("Il profilo di interoperabilit\u00e0 non \u00e8 ModI");
        }
        KeystoreParams keystoreParams = null;
        boolean sicurezzaRisposta = false;
        if (ModISecurityUtils.isSicurezzaMessaggioRequired(api, asps.getPortType())) {
            sicurezzaRisposta = ModISecurityUtils.isProfiloSicurezzaMessaggioApplicabileRisposta(api, asps.getPortType(), true);
        }
        if (sicurezzaRisposta) {
            try {
                keystoreParams = ModIUtils.getKeyStoreParams(asps.getProtocolPropertyList(), false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException(e.getMessage(), (Throwable)e);
            }
        }
        KeystoreParams truststoreParams = null;
        try {
            truststoreParams = ModIUtils.getTrustStoreParams(asps.getProtocolPropertyList());
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), (Throwable)e);
        }
        KeystoreParams truststoreSslParams = null;
        try {
            truststoreSslParams = ModIUtils.getTrustStoreSSLParams(asps.getProtocolPropertyList());
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), (Throwable)e);
        }
        List<RemoteStoreConfig> trustStoreRemoteConfig = null;
        try {
            trustStoreRemoteConfig = ModIUtils.getRemoteStoreConfig();
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), (Throwable)e);
        }
        return RegistroServiziReader._checkStore(keystoreParams, byokUnwrapFactory, truststoreParams, truststoreSslParams, sogliaWarningGiorni, addCertificateDetails, separator, newLine, log, trustStoreRemoteConfig);
    }

    protected CertificateCheck checkCertificatiModIFruizioneById(Connection connectionPdD, boolean useCache, long idFruitore, int sogliaWarningGiorni, IBYOKUnwrapFactory byokUnwrapFactory, boolean addCertificateDetails, String separator, String newLine) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (connectionPdD != null) {
            // empty if block
        }
        if (useCache) {
            throw new DriverRegistroServiziException("Not Implemented");
        }
        AccordoServizioParteComune api = null;
        AccordoServizioParteSpecifica asps = null;
        Fruitore fruitore = null;
        Iterator<IDriverRegistroServiziGet> iterator = this.registroServizi.getDriverRegistroServizi().values().iterator();
        if (iterator.hasNext()) {
            IDriverRegistroServiziGet driver = iterator.next();
            if (driver instanceof DriverRegistroServiziDB) {
                DriverRegistroServiziDB driverDB = (DriverRegistroServiziDB)driver;
                fruitore = driverDB.getServizioFruitore(idFruitore);
                asps = driverDB.getAccordoServizioParteSpecifica(fruitore.getIdServizio().longValue());
                IDAccordo idAccordo = IDAccordoFactory.getInstance().getIDAccordoFromUri(asps.getAccordoServizioParteComune());
                api = driverDB.getAccordoServizioParteComune(idAccordo);
            } else {
                throw new DriverRegistroServiziException("Not Implemented with driver '" + driver.getClass().getName() + "'");
            }
        }
        if (fruitore == null) {
            throw new DriverRegistroServiziNotFound("Fruitore con id '" + idFruitore + "' non trovato");
        }
        return RegistroServiziReader.checkCertificatiModIFruizioneById(api, asps, fruitore, sogliaWarningGiorni, byokUnwrapFactory, addCertificateDetails, separator, newLine, this.log);
    }

    public static CertificateCheck checkCertificatiModIFruizioneById(AccordoServizioParteComune api, AccordoServizioParteSpecifica asps, Fruitore fruitore, int sogliaWarningGiorni, IBYOKUnwrapFactory byokUnwrapFactory, boolean addCertificateDetails, String separator, String newLine, Logger log) throws DriverRegistroServiziException {
        boolean modi = fruitore.getTipo().equals("modipa");
        if (!modi) {
            throw new DriverRegistroServiziException("Il profilo di interoperabilit\u00e0 non \u00e8 ModI");
        }
        KeystoreParams keystoreParams = null;
        try {
            keystoreParams = ModIUtils.getKeyStoreParams(fruitore.getProtocolPropertyList(), true);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), (Throwable)e);
        }
        KeystoreParams truststoreParams = null;
        KeystoreParams truststoreSslParams = null;
        List<RemoteStoreConfig> trustStoreRemoteConfig = null;
        boolean sicurezzaRisposta = false;
        if (ModISecurityUtils.isSicurezzaMessaggioRequired(api, asps.getPortType())) {
            sicurezzaRisposta = ModISecurityUtils.isProfiloSicurezzaMessaggioApplicabileRisposta(api, asps.getPortType(), true);
        }
        if (sicurezzaRisposta) {
            try {
                truststoreParams = ModIUtils.getTrustStoreParams(fruitore.getProtocolPropertyList());
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException(e.getMessage(), (Throwable)e);
            }
            try {
                truststoreSslParams = ModIUtils.getTrustStoreSSLParams(fruitore.getProtocolPropertyList());
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException(e.getMessage(), (Throwable)e);
            }
            try {
                trustStoreRemoteConfig = ModIUtils.getRemoteStoreConfig();
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException(e.getMessage(), (Throwable)e);
            }
        }
        KeystoreParams dpopKeystoreParams = null;
        try {
            dpopKeystoreParams = ModIUtils.getFruizioneDPoPKeystoreParams(fruitore.getProtocolPropertyList());
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), (Throwable)e);
        }
        CertificateCheck check = null;
        if (keystoreParams == null && !sicurezzaRisposta && dpopKeystoreParams == null) {
            check = new CertificateCheck();
            check.setStatoCheck(StatoCheck.OK);
        } else if (keystoreParams != null || sicurezzaRisposta) {
            check = RegistroServiziReader._checkStore(keystoreParams, byokUnwrapFactory, truststoreParams, truststoreSslParams, sogliaWarningGiorni, addCertificateDetails, separator, newLine, log, trustStoreRemoteConfig);
        }
        if (dpopKeystoreParams != null && (check == null || StatoCheck.OK.equals((Object)check.getStatoCheck()))) {
            check = RegistroServiziReader._checkDPoPKeystore(dpopKeystoreParams, byokUnwrapFactory, sogliaWarningGiorni, addCertificateDetails, separator, newLine, log);
        }
        return check;
    }

    private static CertificateCheck _checkStore(KeystoreParams keystoreParams, IBYOKUnwrapFactory byokUnwrapFactory, KeystoreParams truststoreParams, KeystoreParams truststoreSslParams, int sogliaWarningGiorni, boolean addCertificateDetails, String separator, String newLine, Logger log, List<RemoteStoreConfig> trustStoreRemoteConfig) throws DriverRegistroServiziException {
        if (keystoreParams == null && truststoreParams == null && truststoreSslParams == null) {
            throw new DriverRegistroServiziException("Non risulta alcun keystore ridefinito, da utilizzare per la gestione della firma ModI");
        }
        CertificateCheck check = null;
        boolean classpathSupported = false;
        String storeDetails = null;
        if (keystoreParams != null) {
            try {
                if (CostantiDB.KEYSTORE_TYPE_KEY_PAIR.equalsIgnoreCase(keystoreParams.getType())) {
                    byokUnwrapManager = null;
                    if (byokUnwrapFactory != null && keystoreParams.getByokPolicy() != null) {
                        byokUnwrapManager = byokUnwrapFactory.newInstance(keystoreParams.getByokPolicy(), log);
                    }
                    if ((check = CertificateUtils.checkKeyPair(classpathSupported, keystoreParams.getPath(), keystoreParams.getKeyPairPublicKeyPath(), keystoreParams.getKeyPassword(), keystoreParams.getKeyPairAlgorithm(), byokUnwrapManager, false, separator, newLine)) != null && !StatoCheck.OK.equals((Object)check.getStatoCheck())) {
                        storeDetails = CertificateUtils.toStringKeyPair(keystoreParams, separator, newLine);
                    }
                } else {
                    if (CostantiDB.KEYSTORE_TYPE_PUBLIC_KEY.equalsIgnoreCase(keystoreParams.getType())) {
                        throw new DriverConfigurazioneException("Nella configurazione ModI viene utilizzato un keystore " + CostantiLabel.KEYSTORE_TYPE_PUBLIC_KEY + " non compatibile la firma dei messaggi");
                    }
                    if (CostantiDB.KEYSTORE_TYPE_JWK.equalsIgnoreCase(keystoreParams.getType())) {
                        byokUnwrapManager = null;
                        if (byokUnwrapFactory != null && keystoreParams.getByokPolicy() != null) {
                            byokUnwrapManager = byokUnwrapFactory.newInstance(keystoreParams.getByokPolicy(), log);
                        }
                        if ((check = CertificateUtils.checkKeystoreJWKs(classpathSupported, keystoreParams.getPath(), keystoreParams.getKeyAlias(), byokUnwrapManager, false, separator, newLine)) != null && !StatoCheck.OK.equals((Object)check.getStatoCheck())) {
                            storeDetails = CertificateUtils.toStringKeystoreJWKs(keystoreParams, separator, newLine);
                        }
                    } else {
                        byokUnwrapManager = null;
                        if (byokUnwrapFactory != null && keystoreParams.getByokPolicy() != null) {
                            byokUnwrapManager = byokUnwrapFactory.newInstance(keystoreParams.getByokPolicy(), log);
                        }
                        if ((check = keystoreParams.getStore() != null ? CertificateUtils.checkKeyStore("Archivio caricato", keystoreParams.getStore(), keystoreParams.getType(), keystoreParams.getPassword(), byokUnwrapManager, keystoreParams.getKeyAlias(), keystoreParams.getKeyPassword(), sogliaWarningGiorni, false, separator, newLine, log) : CertificateUtils.checkKeyStore(keystoreParams.getPath(), classpathSupported, keystoreParams.getType(), keystoreParams.getPassword(), byokUnwrapManager, keystoreParams.getKeyAlias(), keystoreParams.getKeyPassword(), sogliaWarningGiorni, false, separator, newLine, log)) != null && !StatoCheck.OK.equals((Object)check.getStatoCheck())) {
                            storeDetails = CertificateUtils.toStringKeyStore(keystoreParams, separator, newLine);
                        }
                    }
                }
            }
            catch (Throwable t) {
                throw new DriverRegistroServiziException(t.getMessage(), t);
            }
        }
        if ((check == null || StatoCheck.OK.equals((Object)check.getStatoCheck())) && truststoreParams != null) {
            try {
                boolean isRemoteStore = false;
                if (trustStoreRemoteConfig != null && !trustStoreRemoteConfig.isEmpty()) {
                    for (RemoteStoreConfig remoteStoreConfig : trustStoreRemoteConfig) {
                        if (remoteStoreConfig == null || remoteStoreConfig.getStoreName() == null || !remoteStoreConfig.getStoreName().equals(truststoreParams.getType())) continue;
                        isRemoteStore = true;
                        break;
                    }
                }
                if (isRemoteStore) {
                    check = new CertificateCheck();
                    check.setStatoCheck(StatoCheck.OK);
                } else {
                    if (CostantiDB.KEYSTORE_TYPE_KEY_PAIR.equalsIgnoreCase(truststoreParams.getType())) {
                        throw new DriverConfigurazioneException("Nella configurazione ModI viene utilizzato un keystore " + CostantiLabel.KEYSTORE_TYPE_KEY_PAIR + " non compatibile la validazione della firma dei messaggi");
                    }
                    if (CostantiDB.KEYSTORE_TYPE_PUBLIC_KEY.equalsIgnoreCase(truststoreParams.getType())) {
                        check = CertificateUtils.checkPublicKey(classpathSupported, truststoreParams.getPath(), truststoreParams.getKeyPairAlgorithm(), false, separator, newLine);
                        if (check != null && !StatoCheck.OK.equals((Object)check.getStatoCheck())) {
                            storeDetails = CertificateUtils.toStringPublicKey(truststoreParams, separator, newLine);
                        }
                    } else if (CostantiDB.KEYSTORE_TYPE_JWK.equalsIgnoreCase(truststoreParams.getType())) {
                        check = CertificateUtils.checkTruststoreJWKs(classpathSupported, truststoreParams.getPath(), truststoreParams.getKeyAlias(), false, separator, newLine);
                        if (check != null && !StatoCheck.OK.equals((Object)check.getStatoCheck())) {
                            storeDetails = CertificateUtils.toStringKeystoreJWKs(truststoreParams, separator, newLine);
                        }
                    } else {
                        check = CertificateUtils.checkTrustStore(truststoreParams.getPath(), classpathSupported, truststoreParams.getType(), truststoreParams.getPassword(), truststoreParams.getCrls(), truststoreParams.getOcspPolicy(), sogliaWarningGiorni, false, separator, newLine, log);
                        if (check != null && !StatoCheck.OK.equals((Object)check.getStatoCheck())) {
                            storeDetails = CertificateUtils.toStringTrustStore(truststoreParams, separator, newLine);
                        }
                    }
                }
            }
            catch (Throwable t) {
                throw new DriverRegistroServiziException(t.getMessage(), t);
            }
        }
        if ((check == null || StatoCheck.OK.equals((Object)check.getStatoCheck())) && truststoreSslParams != null) {
            try {
                check = CertificateUtils.checkTrustStore(truststoreSslParams.getPath(), classpathSupported, truststoreSslParams.getType(), truststoreSslParams.getPassword(), truststoreSslParams.getCrls(), truststoreSslParams.getOcspPolicy(), sogliaWarningGiorni, false, separator, newLine, log);
                if (check != null && !StatoCheck.OK.equals((Object)check.getStatoCheck())) {
                    storeDetails = CertificateUtils.toStringTrustStore(truststoreSslParams, separator, newLine);
                }
            }
            catch (Throwable t) {
                throw new DriverRegistroServiziException(t.getMessage(), t);
            }
        }
        if (check != null && !StatoCheck.OK.equals((Object)check.getStatoCheck())) {
            Object id = ID_CONFIGURAZIONE_FIRMA_MODI;
            if (addCertificateDetails && storeDetails != null) {
                id = (String)id + newLine + storeDetails;
            }
            check.setConfigurationId((String)id);
        }
        return check;
    }

    private static CertificateCheck _checkDPoPKeystore(KeystoreParams keystoreParams, IBYOKUnwrapFactory byokUnwrapFactory, int sogliaWarningGiorni, boolean addCertificateDetails, String separator, String newLine, Logger log) throws DriverRegistroServiziException {
        if (keystoreParams == null) {
            return null;
        }
        CertificateCheck check = null;
        boolean classpathSupported = false;
        String storeDetails = null;
        try {
            if (CostantiDB.KEYSTORE_TYPE_KEY_PAIR.equalsIgnoreCase(keystoreParams.getType())) {
                byokUnwrapManager = null;
                if (byokUnwrapFactory != null && keystoreParams.getByokPolicy() != null) {
                    byokUnwrapManager = byokUnwrapFactory.newInstance(keystoreParams.getByokPolicy(), log);
                }
                if ((check = CertificateUtils.checkKeyPair(classpathSupported, keystoreParams.getPath(), keystoreParams.getKeyPairPublicKeyPath(), keystoreParams.getKeyPassword(), keystoreParams.getKeyPairAlgorithm(), byokUnwrapManager, false, separator, newLine)) != null && !StatoCheck.OK.equals((Object)check.getStatoCheck())) {
                    storeDetails = CertificateUtils.toStringKeyPair(keystoreParams, separator, newLine);
                }
            } else {
                if (CostantiDB.KEYSTORE_TYPE_PUBLIC_KEY.equalsIgnoreCase(keystoreParams.getType())) {
                    throw new DriverConfigurazioneException("Nella configurazione DPoP viene utilizzato un keystore " + CostantiLabel.KEYSTORE_TYPE_PUBLIC_KEY + " non compatibile la firma dei messaggi");
                }
                if (CostantiDB.KEYSTORE_TYPE_JWK.equalsIgnoreCase(keystoreParams.getType())) {
                    byokUnwrapManager = null;
                    if (byokUnwrapFactory != null && keystoreParams.getByokPolicy() != null) {
                        byokUnwrapManager = byokUnwrapFactory.newInstance(keystoreParams.getByokPolicy(), log);
                    }
                    if ((check = CertificateUtils.checkKeystoreJWKs(classpathSupported, keystoreParams.getPath(), keystoreParams.getKeyAlias(), byokUnwrapManager, false, separator, newLine)) != null && !StatoCheck.OK.equals((Object)check.getStatoCheck())) {
                        storeDetails = CertificateUtils.toStringKeystoreJWKs(keystoreParams, separator, newLine);
                    }
                } else {
                    byokUnwrapManager = null;
                    if (byokUnwrapFactory != null && keystoreParams.getByokPolicy() != null) {
                        byokUnwrapManager = byokUnwrapFactory.newInstance(keystoreParams.getByokPolicy(), log);
                    }
                    if ((check = keystoreParams.getStore() != null ? CertificateUtils.checkKeyStore("Archivio caricato", keystoreParams.getStore(), keystoreParams.getType(), keystoreParams.getPassword(), byokUnwrapManager, keystoreParams.getKeyAlias(), keystoreParams.getKeyPassword(), sogliaWarningGiorni, false, separator, newLine, log) : CertificateUtils.checkKeyStore(keystoreParams.getPath(), classpathSupported, keystoreParams.getType(), keystoreParams.getPassword(), byokUnwrapManager, keystoreParams.getKeyAlias(), keystoreParams.getKeyPassword(), sogliaWarningGiorni, false, separator, newLine, log)) != null && !StatoCheck.OK.equals((Object)check.getStatoCheck())) {
                        storeDetails = CertificateUtils.toStringKeyStore(keystoreParams, separator, newLine);
                    }
                }
            }
        }
        catch (Throwable t) {
            throw new DriverRegistroServiziException(t.getMessage(), t);
        }
        if (check != null && !StatoCheck.OK.equals((Object)check.getStatoCheck())) {
            Object id = ID_CONFIGURAZIONE_DPOP;
            if (addCertificateDetails && storeDetails != null) {
                id = (String)id + newLine + storeDetails;
            }
            check.setConfigurationId((String)id);
        }
        return check;
    }

    public PortaDominio getPortaDominio(Connection connectionPdD, String nome, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServizi.getPortaDominio(connectionPdD, nomeRegistro, nome);
    }

    public Ruolo getRuolo(Connection connectionPdD, String nome, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServizi.getRuolo(connectionPdD, nomeRegistro, nome);
    }

    public Scope getScope(Connection connectionPdD, String nome, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServizi.getScope(connectionPdD, nomeRegistro, nome);
    }

    public Soggetto getSoggetto(Connection connectionPdD, IDSoggetto idSoggetto, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServizi.getSoggetto(connectionPdD, nomeRegistro, idSoggetto);
    }

    public AccordoServizioParteComune getAccordoServizioParteComune(Connection connectionPdD, IDAccordo idAccordo, Boolean readContenutiAllegati, Boolean readDatiRegistro, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServizi.getAccordoServizioParteComune(connectionPdD, nomeRegistro, idAccordo, readContenutiAllegati, readDatiRegistro);
    }

    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(Connection connectionPdD, IDServizio idServizio, Boolean readContenutiAllegati, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServizi.getAccordoServizioParteSpecifica(connectionPdD, nomeRegistro, idServizio, readContenutiAllegati);
    }

    public AccordoCooperazione getAccordoCooperazione(Connection connectionPdD, IDAccordoCooperazione idAccordoCooperazione, Boolean readContenutiAllegati, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServizi.getAccordoCooperazione(connectionPdD, nomeRegistro, idAccordoCooperazione, readContenutiAllegati);
    }

    public List<String> getAllIdPorteDominio(Connection connectionPdD, FiltroRicerca filtroRicerca, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServizi.getAllIdPorteDominio(connectionPdD, nomeRegistro, filtroRicerca);
    }

    public List<IDGruppo> getAllIdGruppi(Connection connectionPdD, FiltroRicercaGruppi filtroRicerca, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServizi.getAllIdGruppi(connectionPdD, nomeRegistro, filtroRicerca);
    }

    public List<IDRuolo> getAllIdRuoli(Connection connectionPdD, FiltroRicercaRuoli filtroRicerca, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServizi.getAllIdRuoli(connectionPdD, nomeRegistro, filtroRicerca);
    }

    public List<IDScope> getAllIdScope(Connection connectionPdD, FiltroRicercaScope filtroRicerca, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServizi.getAllIdScope(connectionPdD, nomeRegistro, filtroRicerca);
    }

    public List<IDSoggetto> getAllIdSoggetti(Connection connectionPdD, FiltroRicercaSoggetti filtroRicerca, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServizi.getAllIdSoggetti(connectionPdD, nomeRegistro, filtroRicerca);
    }

    public List<IDAccordoCooperazione> getAllIdAccordiCooperazione(Connection connectionPdD, FiltroRicercaAccordi filtroRicerca, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServizi.getAllIdAccordiCooperazione(connectionPdD, nomeRegistro, filtroRicerca);
    }

    public List<IDAccordo> getAllIdAccordiServizioParteComune(Connection connectionPdD, FiltroRicercaAccordi filtroRicerca, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServizi.getAllIdAccordiServizioParteComune(connectionPdD, nomeRegistro, filtroRicerca);
    }

    public List<IDPortType> getAllIdPortType(Connection connectionPdD, FiltroRicercaPortTypes filtroRicerca, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServizi.getAllIdPortType(connectionPdD, nomeRegistro, filtroRicerca);
    }

    public List<IDPortTypeAzione> getAllIdAzionePortType(Connection connectionPdD, FiltroRicercaOperations filtroRicerca, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServizi.getAllIdAzionePortType(connectionPdD, nomeRegistro, filtroRicerca);
    }

    public List<IDAccordoAzione> getAllIdAzioneAccordo(Connection connectionPdD, FiltroRicercaAzioni filtroRicerca, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServizi.getAllIdAzioneAccordo(connectionPdD, nomeRegistro, filtroRicerca);
    }

    public List<IDResource> getAllIdResource(Connection connectionPdD, FiltroRicercaResources filtroRicerca, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServizi.getAllIdResource(connectionPdD, nomeRegistro, filtroRicerca);
    }

    public List<IDServizio> getAllIdServizi(Connection connectionPdD, FiltroRicercaServizi filtroRicerca, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServizi.getAllIdServizi(connectionPdD, nomeRegistro, filtroRicerca);
    }

    public List<IDFruizione> getAllIdFruizioniServizio(Connection connectionPdD, FiltroRicercaFruizioniServizio filtroRicerca, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServizi.getAllIdFruizioniServizio(connectionPdD, nomeRegistro, filtroRicerca);
    }

    public Serializable getGenericObject(String keyObject) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServizi.getGenericObject(keyObject);
    }

    public Serializable pushGenericObject(String keyObject, Serializable object) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServizi.pushGenericObject(keyObject, object);
    }

    static {
        initialize = false;
    }
}

