/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.sdk;

import java.io.Serializable;
import java.util.Date;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.constants.Inoltro;
import org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione;

public class Servizio
implements Serializable {
    private static final long serialVersionUID = 1L;
    private IDServizio idServizio;
    private IDAccordo idAccordo;
    private ServiceBinding serviceBinding;
    private ProfiloDiCollaborazione profiloDiCollaborazione;
    private boolean idCollaborazione;
    private boolean idRiferimentoRichiesta;
    private boolean ordineConsegna;
    private Date scadenza;
    private long scadenzaMinuti = -1L;
    private Inoltro inoltro;
    private boolean confermaRicezione;
    private String tipoServizioCorrelato;
    private String servizioCorrelato;
    private Integer versioneServizioCorrelato;
    private boolean correlato;

    public Busta convertToBusta(String protocollo, IDSoggetto fruitore) {
        Busta busta = new Busta(protocollo);
        if (fruitore != null) {
            busta.setTipoMittente(fruitore.getTipo());
            busta.setMittente(fruitore.getNome());
            busta.setIdentificativoPortaMittente(fruitore.getCodicePorta());
        }
        if (this.idServizio != null) {
            if (this.idServizio.getSoggettoErogatore() != null) {
                busta.setTipoDestinatario(this.idServizio.getSoggettoErogatore().getTipo());
                busta.setDestinatario(this.idServizio.getSoggettoErogatore().getNome());
                busta.setIdentificativoPortaDestinatario(this.idServizio.getSoggettoErogatore().getCodicePorta());
            }
            busta.setTipoServizio(this.idServizio.getTipo());
            busta.setServizio(this.idServizio.getNome());
            busta.setVersioneServizio(this.idServizio.getVersione());
            busta.setAzione(this.idServizio.getAzione());
        }
        busta.setProfiloDiCollaborazione(this.profiloDiCollaborazione);
        busta.setInoltro(this.inoltro);
        busta.setConfermaRicezione(this.confermaRicezione);
        busta.setTipoServizioCorrelato(this.tipoServizioCorrelato);
        busta.setServizioCorrelato(this.servizioCorrelato);
        busta.setVersioneServizioCorrelato(this.versioneServizioCorrelato);
        return busta;
    }

    public void setIDServizio(IDServizio idServizio) {
        this.idServizio = idServizio;
    }

    public void setProfiloDiCollaborazione(ProfiloDiCollaborazione p) {
        this.profiloDiCollaborazione = p;
    }

    public void setCollaborazione(boolean c) {
        this.idCollaborazione = c;
    }

    public void setIdRiferimentoRichiesta(boolean c) {
        this.idRiferimentoRichiesta = c;
    }

    public void setOrdineConsegna(boolean s) {
        this.ordineConsegna = s;
    }

    public void setScadenza(Date s) {
        this.scadenza = s;
    }

    public void setInoltro(Inoltro i) {
        this.inoltro = i;
    }

    public void setConfermaRicezione(boolean cr) {
        this.confermaRicezione = cr;
    }

    public void setServizioCorrelato(String nome) {
        this.servizioCorrelato = nome;
    }

    public void setTipoServizioCorrelato(String tipoServizioCorrelato) {
        this.tipoServizioCorrelato = tipoServizioCorrelato;
    }

    public void setVersioneServizioCorrelato(Integer versioneServizioCorrelato) {
        this.versioneServizioCorrelato = versioneServizioCorrelato;
    }

    public void setCorrelato(boolean correlato) {
        this.correlato = correlato;
    }

    public void setScadenzaMinuti(long scadenzaMinuti) {
        this.scadenzaMinuti = scadenzaMinuti;
    }

    public IDServizio getIDServizio() {
        return this.idServizio;
    }

    public ProfiloDiCollaborazione getProfiloDiCollaborazione() {
        return this.profiloDiCollaborazione;
    }

    public boolean getCollaborazione() {
        return this.idCollaborazione;
    }

    public boolean getIdRiferimentoRichiesta() {
        return this.idRiferimentoRichiesta;
    }

    public boolean getOrdineConsegna() {
        return this.ordineConsegna;
    }

    public Date getScadenza() {
        return this.scadenza;
    }

    public Inoltro getInoltro() {
        return this.inoltro;
    }

    public boolean getConfermaRicezione() {
        return this.confermaRicezione;
    }

    public String getServizioCorrelato() {
        return this.servizioCorrelato;
    }

    public String getTipoServizioCorrelato() {
        return this.tipoServizioCorrelato;
    }

    public Integer getVersioneServizioCorrelato() {
        return this.versioneServizioCorrelato;
    }

    public boolean isCorrelato() {
        return this.correlato;
    }

    public long getScadenzaMinuti() {
        return this.scadenzaMinuti;
    }

    public IDAccordo getIdAccordo() {
        return this.idAccordo;
    }

    public void setIdAccordo(IDAccordo idAccordo) {
        this.idAccordo = idAccordo;
    }

    public ServiceBinding getServiceBinding() {
        return this.serviceBinding;
    }

    public void setServiceBinding(ServiceBinding serviceBinding) {
        this.serviceBinding = serviceBinding;
    }
}

