/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.sdk.archive;

import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.id.IDAccordoCooperazione;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteComuneServizioCompostoServizioComponente;
import org.openspcoop2.core.registry.driver.IDAccordoCooperazioneFactory;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.archive.ArchiveAccordoServizioParteComune;
import org.openspcoop2.protocol.sdk.archive.ArchiveIdCorrelazione;

public class ArchiveAccordoServizioComposto
extends ArchiveAccordoServizioParteComune {
    private IDAccordoCooperazione idAccordoCooperazione;
    private List<IDServizio> idServiziComponenti = new ArrayList<IDServizio>();

    public static String buildKeyComposto(String tipoSoggetto, String nomeSoggetto, String nomeAccordo, Integer versione) throws ProtocolException {
        if (tipoSoggetto == null) {
            throw new ProtocolException("tipoSoggetto non fornito");
        }
        if (nomeSoggetto == null) {
            throw new ProtocolException("nomeSoggetto non fornito");
        }
        if (nomeAccordo == null) {
            throw new ProtocolException("nomeAccordo non fornito");
        }
        if (versione == null) {
            throw new ProtocolException("versione non fornita");
        }
        StringBuilder bf = new StringBuilder();
        bf.append("AccordoServizioComposto_");
        bf.append(tipoSoggetto);
        bf.append("/");
        bf.append(nomeSoggetto);
        bf.append("_");
        bf.append(nomeAccordo);
        bf.append("_");
        bf.append(versione);
        return bf.toString();
    }

    @Override
    public String key() throws ProtocolException {
        String tipoSoggetto = "-";
        String nomeSoggetto = "-";
        String nomeAccordo = this.accordoServizioParteComune.getNome();
        Integer versione = null;
        if (this.accordoServizioParteComune.getSoggettoReferente() != null) {
            if (this.accordoServizioParteComune.getSoggettoReferente().getTipo() != null) {
                tipoSoggetto = this.accordoServizioParteComune.getSoggettoReferente().getTipo();
            }
            if (this.accordoServizioParteComune.getSoggettoReferente().getNome() != null) {
                nomeSoggetto = this.accordoServizioParteComune.getSoggettoReferente().getNome();
            }
        }
        if (this.accordoServizioParteComune.getVersione() != null) {
            versione = this.accordoServizioParteComune.getVersione();
        }
        return ArchiveAccordoServizioComposto.buildKeyComposto(tipoSoggetto, nomeSoggetto, nomeAccordo, versione);
    }

    public ArchiveAccordoServizioComposto(IDSoggetto idSoggettoProprietario, AccordoServizioParteComune accordoServizioParteComune, ArchiveIdCorrelazione idCorrelazione) throws ProtocolException {
        super(idSoggettoProprietario, accordoServizioParteComune, idCorrelazione);
    }

    public ArchiveAccordoServizioComposto(IDSoggetto idSoggettoProprietario, AccordoServizioParteComune accordoServizioParteComune, ArchiveIdCorrelazione idCorrelazione, boolean informationMissingManagementEnabled) throws ProtocolException {
        super(idSoggettoProprietario, accordoServizioParteComune, idCorrelazione, informationMissingManagementEnabled);
    }

    public ArchiveAccordoServizioComposto(AccordoServizioParteComune accordoServizioParteComune, ArchiveIdCorrelazione idCorrelazione) throws ProtocolException {
        super(accordoServizioParteComune, idCorrelazione);
    }

    public ArchiveAccordoServizioComposto(AccordoServizioParteComune accordoServizioParteComune, ArchiveIdCorrelazione idCorrelazione, boolean informationMissingManagementEnabled) throws ProtocolException {
        super(accordoServizioParteComune, idCorrelazione, informationMissingManagementEnabled);
    }

    @Override
    public void update(AccordoServizioParteComune accordoServizioComposto, boolean informationMissingManagementEnabled) throws ProtocolException {
        super.update(accordoServizioComposto, informationMissingManagementEnabled);
        if (accordoServizioComposto.getServizioComposto() == null) {
            throw new ProtocolException("AccordoServizioComposto.servizioComposto non definito");
        }
        if (accordoServizioComposto.getServizioComposto().getAccordoCooperazione() == null) {
            throw new ProtocolException("AccordoServizioComposto.servizioComposto.nomeAccordoCooperazione non definito");
        }
        try {
            this.idAccordoCooperazione = IDAccordoCooperazioneFactory.getInstance().getIDAccordoFromUri(accordoServizioComposto.getServizioComposto().getAccordoCooperazione());
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
        for (int i = 0; i < accordoServizioComposto.getServizioComposto().getServizioComponenteList().size(); ++i) {
            AccordoServizioParteComuneServizioCompostoServizioComponente sComponente;
            if (this.idServiziComponenti == null) {
                this.idServiziComponenti = new ArrayList<IDServizio>();
            }
            if ((sComponente = (AccordoServizioParteComuneServizioCompostoServizioComponente)accordoServizioComposto.getServizioComposto().getServizioComponenteList().get(i)) == null) {
                throw new ProtocolException("AccordoServizioComposto.servizioComposto.serviziComponente[" + i + "] non definito");
            }
            if (sComponente.getTipo() == null) {
                throw new ProtocolException("AccordoServizioComposto.servizioComposto.serviziComponente[" + i + "].tipo non definito");
            }
            if (sComponente.getNome() == null) {
                throw new ProtocolException("AccordoServizioComposto.servizioComposto.serviziComponente[" + i + "].nome non definito");
            }
            if (sComponente.getTipoSoggetto() == null) {
                throw new ProtocolException("AccordoServizioComposto.servizioComposto.serviziComponente[" + i + "].tipoSoggetto non definito");
            }
            if (sComponente.getNomeSoggetto() == null) {
                throw new ProtocolException("AccordoServizioComposto.servizioComposto.serviziComponente[" + i + "].nomeSoggetto non definito");
            }
            try {
                IDServizio idServizioComponente = IDServizioFactory.getInstance().getIDServizioFromValues(sComponente.getTipo(), sComponente.getNome(), sComponente.getTipoSoggetto(), sComponente.getNomeSoggetto(), sComponente.getVersione().intValue());
                idServizioComponente.setAzione(sComponente.getAzione());
                this.idServiziComponenti.add(idServizioComponente);
                continue;
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage(), e);
            }
        }
    }

    public IDAccordoCooperazione getIdAccordoCooperazione() {
        return this.idAccordoCooperazione;
    }

    public List<IDServizio> getIdServiziComponenti() {
        return this.idServiziComponenti;
    }
}

