/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.sdk.properties;

import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.constants.ConsoleItemType;
import org.openspcoop2.protocol.sdk.properties.BaseConsoleItem;
import org.openspcoop2.protocol.sdk.properties.ConsoleItemInfo;
import org.openspcoop2.utils.SortedMap;
import org.openspcoop2.utils.UtilsRuntimeException;

public abstract class AbstractConsoleItem<T>
extends BaseConsoleItem {
    private T defaultValue;
    private T defaultValueForCloseableSection;
    private boolean reloadOnChange;
    private boolean reloadOnHttpPost;
    private boolean required;
    private String regexpr;
    private SortedMap<T> mapLabelValues = new SortedMap();
    private String note;
    private ConsoleItemInfo info;
    private String labelRight;

    protected AbstractConsoleItem(String id, String label, ConsoleItemType type) throws ProtocolException {
        super(id, label, type);
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(T defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean isReloadOnChange() {
        return this.reloadOnChange;
    }

    public boolean isReloadOnHttpPost() {
        return this.reloadOnHttpPost;
    }

    public void setReloadOnChange(boolean reloadOnChange) {
        this.setReloadOnChange(reloadOnChange, false);
    }

    public void setReloadOnChange(boolean reloadOnChange, boolean reloadOnHttpPost) {
        this.reloadOnChange = reloadOnChange;
        this.reloadOnHttpPost = reloadOnHttpPost;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public String getRegexpr() {
        return this.regexpr;
    }

    public void setRegexpr(String regexpr) {
        this.regexpr = regexpr;
    }

    public SortedMap<T> getMapLabelValues() {
        return this.mapLabelValues;
    }

    public List<String> getLabels() {
        ArrayList<String> labels = null;
        if (this.mapLabelValues != null && this.mapLabelValues.size() > 0) {
            labels = new ArrayList<String>();
            labels.addAll(this.mapLabelValues.keys());
            return labels;
        }
        return labels;
    }

    public List<T> getValues() {
        ArrayList values = null;
        if (this.mapLabelValues != null && this.mapLabelValues.size() > 0) {
            values = new ArrayList();
            values.addAll(this.mapLabelValues.values());
            return values;
        }
        return values;
    }

    public void clearMapLabelValues() {
        this.mapLabelValues.clear();
    }

    public void addLabelValue(String key, T value) {
        try {
            if (this.mapLabelValues.containsKey(key)) {
                this.mapLabelValues.remove(key);
            }
            this.mapLabelValues.put(key, value);
        }
        catch (Exception e) {
            throw new UtilsRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    public void removeLabelValue(String label) {
        this.mapLabelValues.remove(label);
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public ConsoleItemInfo getInfo() {
        return this.info;
    }

    public void setInfo(ConsoleItemInfo info) {
        this.info = info;
    }

    public String getLabelRight() {
        return this.labelRight;
    }

    public void setLabelRight(String labelRight) {
        this.labelRight = labelRight;
    }

    public void setUseDefaultValueForCloseableSection(boolean useDefaultValueForCloseableSection) throws ProtocolException {
        if (this.defaultValue == null) {
            throw new ProtocolException("Default value undefined (useDefaultValue:" + useDefaultValueForCloseableSection + ")");
        }
        this.defaultValueForCloseableSection = this.cloneValue(this.defaultValue);
    }

    protected abstract T cloneValue(T var1) throws ProtocolException;

    public T getDefaultValueForCloseableSection() {
        return this.defaultValueForCloseableSection;
    }
}

