/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.sdk.properties;

import java.io.ByteArrayOutputStream;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.constants.ConsoleItemType;
import org.openspcoop2.protocol.sdk.properties.AbstractConsoleItem;

public class BinaryConsoleItem
extends AbstractConsoleItem<byte[]> {
    private String fileName = null;
    private String fileId = null;
    private boolean readOnly = false;
    private boolean showContent = true;
    private String noteUpdate = null;
    private boolean lock = false;

    protected BinaryConsoleItem(String id, String label, ConsoleItemType type) throws ProtocolException {
        this(id, label, type, null, null);
    }

    protected BinaryConsoleItem(String id, String label, ConsoleItemType type, String fileName, String fileId) throws ProtocolException {
        super(id, label, type);
        this.fileName = fileName;
        this.fileId = fileId;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileId() {
        return this.fileId;
    }

    public void setFileId(String fileId) {
        this.fileId = fileId;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isShowContent() {
        return this.showContent;
    }

    public void setShowContent(boolean showContent) {
        this.showContent = showContent;
    }

    public String getNoteUpdate() {
        return this.noteUpdate;
    }

    public void setNoteUpdate(String noteUpdate) {
        this.noteUpdate = noteUpdate;
    }

    public void setLock(boolean lock) {
        this.lock = lock;
    }

    @Override
    public boolean isLockedType() {
        return this.lock;
    }

    @Override
    protected byte[] cloneValue(byte[] value) throws ProtocolException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            bout.write(value);
            bout.flush();
            bout.close();
            return bout.toByteArray();
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
    }
}

