/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.sdk.state;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Map;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.StateMap;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.slf4j.Logger;

public class StateMessage
implements IState {
    private Connection connectionDB;
    private StateMap tablePstmt;
    private Logger log = null;

    public StateMessage() {
    }

    public StateMessage(Connection con, Logger log) {
        this.connectionDB = con;
        this.log = log;
        this.tablePstmt = new StateMap(log);
    }

    public StateMessage(Connection con, Logger log, StateMap preparedStatement) {
        this.connectionDB = con;
        this.log = log;
        this.tablePstmt = preparedStatement;
    }

    public Logger getLog() {
        return this.log;
    }

    public void setLog(Logger log) {
        this.log = log;
    }

    public Connection getConnectionDB() {
        return this.connectionDB;
    }

    public void setConnectionDB(Connection connectionDB) {
        this.connectionDB = connectionDB;
    }

    public void updateConnection(Connection con) {
        this.connectionDB = con;
    }

    public StateMap getPreparedStatement() {
        return this.tablePstmt;
    }

    public void setPreparedStatement(Map<String, PreparedStatement> pstm) {
        this.tablePstmt.setPreparedStatement(pstm);
    }

    public void setPreparedStatement(StateMap pstm) {
        this.tablePstmt = pstm;
    }

    public void closePreparedStatement() {
        JDBCUtilities.closePreparedStatement(this.tablePstmt.getPreparedStatement(), (Logger)this.log);
    }

    public void executePreparedStatement() throws UtilsException {
        JDBCUtilities.executePreparedStatement(this.tablePstmt.getPreparedStatement());
    }

    public void addPreparedStatement(Map<String, PreparedStatement> pstmt) throws UtilsException {
        JDBCUtilities.addPreparedStatement(pstmt, this.tablePstmt.getPreparedStatement(), (Logger)this.log);
    }

    public static Connection getConnection(StateMessage state) {
        if (state != null) {
            boolean validConnection = false;
            if (state.getConnectionDB() != null) {
                try {
                    validConnection = !state.getConnectionDB().isClosed();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (validConnection) {
                return state.getConnectionDB();
            }
        }
        return null;
    }
}

