/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.utils;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.constants.CostantiDB;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.ProtocolProperty;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.properties.ProtocolPropertiesUtils;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.KeystoreParams;
import org.openspcoop2.utils.certificate.KeystoreType;
import org.openspcoop2.utils.certificate.hsm.HSMUtils;
import org.openspcoop2.utils.transport.http.HttpUtilities;

public class ModIKeystoreUtils {
    protected String securityMessageKeystoreMode = null;
    protected byte[] securityMessageKeystoreArchive = null;
    protected String securityMessageKeystoreType = null;
    protected boolean securityMessageKeystoreHSM = false;
    protected String securityMessageKeystorePath = null;
    protected String securityMessageKeystorePathPublicKey = null;
    protected String securityMessageKeystoreKeyAlgorithm = null;
    protected String securityMessageKeystorePassword = null;
    protected String securityMessageKeystoreByokPolicy = null;
    protected String securityMessageKeyAlias = null;
    protected String securityMessageKeyPassword = null;

    public ModIKeystoreUtils() throws ProtocolException, UtilsException {
    }

    public ModIKeystoreUtils(ServizioApplicativo sa, String securityMessageProfile) throws ProtocolException, UtilsException {
        boolean required;
        boolean securityMessageProfileDefinedApplicativo = ProtocolPropertiesUtils.getBooleanValuePropertyConfig(sa.getProtocolPropertyList(), "modipaSecurityMessage", false);
        if (!securityMessageProfileDefinedApplicativo) {
            ProtocolException pe = new ProtocolException("Il profilo di sicurezza richiesto '" + securityMessageProfile + "' non \u00e8 applicabile poich\u00e8 l'applicativo mittente " + sa.getNome() + " (" + sa.getNomeSoggettoProprietario() + ") non possiede una configurazione dei parametri di sicurezza messaggio (Keystore)");
            pe.setInteroperabilityError(true);
            throw pe;
        }
        this.securityMessageKeystoreMode = ProtocolPropertiesUtils.getRequiredStringValuePropertyConfig(sa.getProtocolPropertyList(), "modipaKeystoreMode");
        if ("hsm".equals(this.securityMessageKeystoreMode)) {
            this.securityMessageKeystoreHSM = true;
        } else if ("archive".equals(this.securityMessageKeystoreMode)) {
            this.securityMessageKeystoreArchive = ProtocolPropertiesUtils.getRequiredBinaryValuePropertyConfig(sa.getProtocolPropertyList(), "modipaKeystoreArchive");
        } else {
            this.securityMessageKeystorePath = ProtocolPropertiesUtils.getRequiredStringValuePropertyConfig(sa.getProtocolPropertyList(), "modipaKeystorePath");
            try {
                HttpUtilities.validateUri((String)this.securityMessageKeystorePath, (boolean)true);
            }
            catch (Exception e) {
                throw new ProtocolException("[" + this.securityMessageKeystorePath + "] " + e.getMessage(), e);
            }
        }
        this.securityMessageKeystoreType = ProtocolPropertiesUtils.getRequiredStringValuePropertyConfig(sa.getProtocolPropertyList(), "modipaKeystoreType");
        if (this.securityMessageKeystoreHSM) {
            this.securityMessageKeystorePath = "HSM-" + this.securityMessageKeystoreType;
        }
        if (!this.securityMessageKeystoreHSM) {
            if (CostantiDB.KEYSTORE_TYPE_KEY_PAIR.equalsIgnoreCase(this.securityMessageKeystoreType)) {
                this.securityMessageKeystorePathPublicKey = ProtocolPropertiesUtils.getRequiredStringValuePropertyConfig(sa.getProtocolPropertyList(), "modipaKeystorePathPublicKey");
            }
            if (CostantiDB.KEYSTORE_TYPE_KEY_PAIR.equalsIgnoreCase(this.securityMessageKeystoreType) || CostantiDB.KEYSTORE_TYPE_PUBLIC_KEY.equalsIgnoreCase(this.securityMessageKeystoreType)) {
                this.securityMessageKeystoreKeyAlgorithm = ProtocolPropertiesUtils.getOptionalStringValuePropertyConfig(sa.getProtocolPropertyList(), "modipaKeystoreKeyPairAlgo");
                if (this.securityMessageKeystoreKeyAlgorithm == null || StringUtils.isEmpty((CharSequence)this.securityMessageKeystoreKeyAlgorithm)) {
                    this.securityMessageKeystoreKeyAlgorithm = "RSA";
                }
            }
        }
        if (!this.securityMessageKeystoreHSM) {
            if (!(CostantiDB.KEYSTORE_TYPE_JWK.equalsIgnoreCase(this.securityMessageKeystoreType) || CostantiDB.KEYSTORE_TYPE_KEY_PAIR.equalsIgnoreCase(this.securityMessageKeystoreType) || CostantiDB.KEYSTORE_TYPE_PUBLIC_KEY.equalsIgnoreCase(this.securityMessageKeystoreType))) {
                required = true;
                if (KeystoreType.JKS.isType(this.securityMessageKeystoreType) && !DBUtils.isKeystoreJksPasswordRequired() || KeystoreType.PKCS12.isType(this.securityMessageKeystoreType) && !DBUtils.isKeystorePkcs12PasswordRequired()) {
                    required = false;
                }
                this.securityMessageKeystorePassword = required ? ProtocolPropertiesUtils.getRequiredStringValuePropertyConfig(sa.getProtocolPropertyList(), "modipaKeystorePassword") : ProtocolPropertiesUtils.getOptionalStringValuePropertyConfig(sa.getProtocolPropertyList(), "modipaKeystorePassword");
            } else {
                this.securityMessageKeystorePassword = ProtocolPropertiesUtils.getOptionalStringValuePropertyConfig(sa.getProtocolPropertyList(), "modipaKeystorePassword");
            }
        } else {
            this.securityMessageKeystorePassword = "-";
        }
        this.securityMessageKeystoreByokPolicy = !this.securityMessageKeystoreHSM && !"archive".equals(this.securityMessageKeystoreMode) ? ProtocolPropertiesUtils.getOptionalStringValuePropertyConfig(sa.getProtocolPropertyList(), "modipaKeystoreByokPolicy") : "-";
        if (!CostantiDB.KEYSTORE_TYPE_KEY_PAIR.equalsIgnoreCase(this.securityMessageKeystoreType) && !CostantiDB.KEYSTORE_TYPE_PUBLIC_KEY.equalsIgnoreCase(this.securityMessageKeystoreType)) {
            this.securityMessageKeyAlias = ProtocolPropertiesUtils.getRequiredStringValuePropertyConfig(sa.getProtocolPropertyList(), "modipaKeyAlias");
        }
        if (!this.securityMessageKeystoreHSM) {
            if (!(CostantiDB.KEYSTORE_TYPE_JWK.equalsIgnoreCase(this.securityMessageKeystoreType) || CostantiDB.KEYSTORE_TYPE_KEY_PAIR.equalsIgnoreCase(this.securityMessageKeystoreType) || CostantiDB.KEYSTORE_TYPE_PUBLIC_KEY.equalsIgnoreCase(this.securityMessageKeystoreType))) {
                required = true;
                if (KeystoreType.JKS.isType(this.securityMessageKeystoreType) && !DBUtils.isKeystoreJksKeyPasswordRequired() || KeystoreType.PKCS12.isType(this.securityMessageKeystoreType) && !DBUtils.isKeystorePkcs12KeyPasswordRequired()) {
                    required = false;
                }
                this.securityMessageKeyPassword = required ? ProtocolPropertiesUtils.getRequiredStringValuePropertyConfig(sa.getProtocolPropertyList(), "modipaKeyPassword") : ProtocolPropertiesUtils.getOptionalStringValuePropertyConfig(sa.getProtocolPropertyList(), "modipaKeyPassword");
            } else {
                this.securityMessageKeyPassword = ProtocolPropertiesUtils.getOptionalStringValuePropertyConfig(sa.getProtocolPropertyList(), "modipaKeyPassword");
            }
        } else {
            this.securityMessageKeyPassword = HSMUtils.isHsmConfigurableKeyPassword() ? ProtocolPropertiesUtils.getRequiredStringValuePropertyConfig(sa.getProtocolPropertyList(), "modipaKeyPassword") : "-";
        }
    }

    public ModIKeystoreUtils(boolean fruizione, IDSoggetto soggettoFruitore, AccordoServizioParteSpecifica asps, String securityMessageProfile, String modIpropertiesSecurityMessageKeystoreType, String modIpropertiesSecurityMessageKeystorePath, String modIpropertiesSecurityMessageKeystorePassword, String modIpropertiesSecurityMessageKeyAlias, String modIpropertiesSecurityMessageKeyPassword) throws ProtocolException, UtilsException {
        try {
            String fruizioneMode;
            List<ProtocolProperty> listProtocolProperties = ProtocolPropertiesUtils.getProtocolProperties(fruizione, soggettoFruitore, asps);
            String prefix = "KeyStore";
            String mode = ProtocolPropertiesUtils.getRequiredStringValuePropertyRegistry(listProtocolProperties, "modipaKeystoreCertMode");
            if (fruizione && "token".equals(fruizioneMode = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry(listProtocolProperties, "modipaKeystoreFruizioneMode"))) {
                mode = "-";
            }
            boolean ridefinisci = "ridefinisci".equals(mode);
            boolean undefined = "-".equals(mode);
            if (ridefinisci) {
                boolean required;
                this.securityMessageKeystoreMode = ProtocolPropertiesUtils.getRequiredStringValuePropertyRegistry(listProtocolProperties, "modipaKeystoreMode");
                if ("hsm".equals(this.securityMessageKeystoreMode)) {
                    this.securityMessageKeystoreHSM = true;
                } else if ("archive".equals(this.securityMessageKeystoreMode)) {
                    this.securityMessageKeystoreArchive = ProtocolPropertiesUtils.getRequiredBinaryValuePropertyRegistry(listProtocolProperties, "modipaKeystoreArchive");
                } else {
                    this.securityMessageKeystorePath = ProtocolPropertiesUtils.getRequiredStringValuePropertyRegistry(listProtocolProperties, "modipaKeystorePath");
                    try {
                        HttpUtilities.validateUri((String)this.securityMessageKeystorePath, (boolean)true);
                    }
                    catch (Exception e) {
                        throw new ProtocolException("[" + this.securityMessageKeystorePath + "] " + e.getMessage(), e);
                    }
                }
                this.securityMessageKeystoreType = ProtocolPropertiesUtils.getRequiredStringValuePropertyRegistry(listProtocolProperties, "modipaKeystoreType");
                if (this.securityMessageKeystoreHSM) {
                    this.securityMessageKeystorePath = "HSM-" + this.securityMessageKeystoreType;
                }
                if (!this.securityMessageKeystoreHSM) {
                    if (CostantiDB.KEYSTORE_TYPE_KEY_PAIR.equalsIgnoreCase(this.securityMessageKeystoreType)) {
                        this.securityMessageKeystorePathPublicKey = ProtocolPropertiesUtils.getRequiredStringValuePropertyRegistry(listProtocolProperties, "modipaKeystorePathPublicKey");
                    }
                    if (CostantiDB.KEYSTORE_TYPE_KEY_PAIR.equalsIgnoreCase(this.securityMessageKeystoreType) || CostantiDB.KEYSTORE_TYPE_PUBLIC_KEY.equalsIgnoreCase(this.securityMessageKeystoreType)) {
                        this.securityMessageKeystoreKeyAlgorithm = ProtocolPropertiesUtils.getRequiredStringValuePropertyRegistry(listProtocolProperties, "modipaKeystoreKeyPairAlgo");
                        if (this.securityMessageKeystoreKeyAlgorithm == null || StringUtils.isEmpty((CharSequence)this.securityMessageKeystoreKeyAlgorithm)) {
                            this.securityMessageKeystoreKeyAlgorithm = "RSA";
                        }
                    }
                }
                if (!this.securityMessageKeystoreHSM) {
                    if (!(CostantiDB.KEYSTORE_TYPE_JWK.equalsIgnoreCase(this.securityMessageKeystoreType) || CostantiDB.KEYSTORE_TYPE_KEY_PAIR.equalsIgnoreCase(this.securityMessageKeystoreType) || CostantiDB.KEYSTORE_TYPE_PUBLIC_KEY.equalsIgnoreCase(this.securityMessageKeystoreType))) {
                        required = true;
                        if (KeystoreType.JKS.isType(this.securityMessageKeystoreType) && !DBUtils.isKeystoreJksPasswordRequired() || KeystoreType.PKCS12.isType(this.securityMessageKeystoreType) && !DBUtils.isKeystorePkcs12PasswordRequired()) {
                            required = false;
                        }
                        this.securityMessageKeystorePassword = required ? ProtocolPropertiesUtils.getRequiredStringValuePropertyRegistry(listProtocolProperties, "modipaKeystorePassword") : ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry(listProtocolProperties, "modipaKeystorePassword");
                    } else {
                        this.securityMessageKeystorePassword = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry(listProtocolProperties, "modipaKeystorePassword");
                    }
                } else {
                    this.securityMessageKeystorePassword = "-";
                }
                this.securityMessageKeystoreByokPolicy = !this.securityMessageKeystoreHSM && !"archive".equals(this.securityMessageKeystoreMode) ? ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry(listProtocolProperties, "modipaKeystoreByokPolicy") : "-";
                if (!CostantiDB.KEYSTORE_TYPE_KEY_PAIR.equalsIgnoreCase(this.securityMessageKeystoreType) && !CostantiDB.KEYSTORE_TYPE_PUBLIC_KEY.equalsIgnoreCase(this.securityMessageKeystoreType)) {
                    this.securityMessageKeyAlias = ProtocolPropertiesUtils.getRequiredStringValuePropertyRegistry(listProtocolProperties, "modipaKeyAlias");
                }
                if (!this.securityMessageKeystoreHSM) {
                    if (!(CostantiDB.KEYSTORE_TYPE_JWK.equalsIgnoreCase(this.securityMessageKeystoreType) || CostantiDB.KEYSTORE_TYPE_KEY_PAIR.equalsIgnoreCase(this.securityMessageKeystoreType) || CostantiDB.KEYSTORE_TYPE_PUBLIC_KEY.equalsIgnoreCase(this.securityMessageKeystoreType))) {
                        required = true;
                        if (KeystoreType.JKS.isType(this.securityMessageKeystoreType) && !DBUtils.isKeystoreJksKeyPasswordRequired() || KeystoreType.PKCS12.isType(this.securityMessageKeystoreType) && !DBUtils.isKeystorePkcs12KeyPasswordRequired()) {
                            required = false;
                        }
                        this.securityMessageKeyPassword = required ? ProtocolPropertiesUtils.getRequiredStringValuePropertyRegistry(listProtocolProperties, "modipaKeyPassword") : ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry(listProtocolProperties, "modipaKeyPassword");
                    } else {
                        this.securityMessageKeyPassword = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry(listProtocolProperties, "modipaKeyPassword");
                    }
                } else {
                    this.securityMessageKeyPassword = HSMUtils.isHsmConfigurableKeyPassword() ? ProtocolPropertiesUtils.getRequiredStringValuePropertyRegistry(listProtocolProperties, "modipaKeyPassword") : "-";
                }
            } else {
                if (undefined) {
                    throw new ProtocolException(prefix + " non definito");
                }
                this.securityMessageKeystoreType = modIpropertiesSecurityMessageKeystoreType;
                if (this.securityMessageKeystoreType != null) {
                    this.securityMessageKeystoreHSM = HSMUtils.isKeystoreHSM((String)this.securityMessageKeystoreType);
                    if (this.securityMessageKeystoreHSM) {
                        this.securityMessageKeystorePath = "HSM-" + this.securityMessageKeystoreType;
                    } else {
                        this.securityMessageKeystorePath = modIpropertiesSecurityMessageKeystorePath;
                        try {
                            HttpUtilities.validateUri((String)this.securityMessageKeystorePath, (boolean)true);
                        }
                        catch (Exception e) {
                            throw new ProtocolException(prefix + " [" + this.securityMessageKeystorePath + "] " + e.getMessage(), e);
                        }
                    }
                    this.securityMessageKeystorePassword = !this.securityMessageKeystoreHSM ? modIpropertiesSecurityMessageKeystorePassword : "-";
                    this.securityMessageKeyAlias = modIpropertiesSecurityMessageKeyAlias;
                    this.securityMessageKeyPassword = !this.securityMessageKeystoreHSM || HSMUtils.isHsmConfigurableKeyPassword() ? modIpropertiesSecurityMessageKeyPassword : "-";
                }
            }
            if (this.securityMessageKeystoreArchive == null && this.securityMessageKeystorePath == null) {
                throw new ProtocolException(prefix + " non definito");
            }
        }
        catch (Exception e) {
            throw new ProtocolException(e);
        }
    }

    public ModIKeystoreUtils(KeystoreParams kp) throws ProtocolException, UtilsException {
        this.securityMessageKeystoreHSM = HSMUtils.isKeystoreHSM((String)kp.getType());
        if (!this.securityMessageKeystoreHSM) {
            this.securityMessageKeystorePath = kp.getPath();
            try {
                HttpUtilities.validateUri((String)this.securityMessageKeystorePath, (boolean)true);
            }
            catch (Exception e) {
                throw new ProtocolException("[" + this.securityMessageKeystorePath + "] " + e.getMessage(), e);
            }
        }
        this.securityMessageKeystoreType = kp.getType();
        if (this.securityMessageKeystoreHSM) {
            this.securityMessageKeystorePath = "HSM-" + this.securityMessageKeystoreType;
        }
        if (!this.securityMessageKeystoreHSM) {
            if (CostantiDB.KEYSTORE_TYPE_KEY_PAIR.equalsIgnoreCase(this.securityMessageKeystoreType)) {
                this.securityMessageKeystorePathPublicKey = kp.getKeyPairPublicKeyPath();
            }
            if (CostantiDB.KEYSTORE_TYPE_KEY_PAIR.equalsIgnoreCase(this.securityMessageKeystoreType) || CostantiDB.KEYSTORE_TYPE_PUBLIC_KEY.equalsIgnoreCase(this.securityMessageKeystoreType)) {
                this.securityMessageKeystoreKeyAlgorithm = kp.getKeyPairAlgorithm();
            }
        }
        this.securityMessageKeystorePassword = !this.securityMessageKeystoreHSM ? kp.getPassword() : "-";
        this.securityMessageKeystoreByokPolicy = !this.securityMessageKeystoreHSM && !"archive".equals(this.securityMessageKeystoreMode) ? kp.getByokPolicy() : "-";
        if (!CostantiDB.KEYSTORE_TYPE_KEY_PAIR.equalsIgnoreCase(this.securityMessageKeystoreType) && !CostantiDB.KEYSTORE_TYPE_PUBLIC_KEY.equalsIgnoreCase(this.securityMessageKeystoreType)) {
            this.securityMessageKeyAlias = kp.getKeyAlias();
        }
        this.securityMessageKeyPassword = !this.securityMessageKeystoreHSM ? kp.getKeyPassword() : (HSMUtils.isHsmConfigurableKeyPassword() ? kp.getKeyPassword() : "-");
    }

    public String getSecurityMessageKeyAlias() {
        return this.securityMessageKeyAlias;
    }

    public String getSecurityMessageKeystoreType() {
        return this.securityMessageKeystoreType;
    }

    public boolean isSecurityMessageKeystoreHSM() {
        return this.securityMessageKeystoreHSM;
    }

    public String getSecurityMessageKeystoreMode() {
        return this.securityMessageKeystoreMode;
    }

    public byte[] getSecurityMessageKeystoreArchive() {
        return this.securityMessageKeystoreArchive;
    }

    public String getSecurityMessageKeystorePath() {
        return this.securityMessageKeystorePath;
    }

    public String getSecurityMessageKeystorePassword() {
        return this.securityMessageKeystorePassword;
    }

    public String getSecurityMessageKeystoreByokPolicy() {
        return this.securityMessageKeystoreByokPolicy;
    }

    public String getSecurityMessageKeyPassword() {
        return this.securityMessageKeyPassword;
    }

    public String getSecurityMessageKeystorePathPublicKey() {
        return this.securityMessageKeystorePathPublicKey;
    }

    public String getSecurityMessageKeystoreKeyAlgorithm() {
        return this.securityMessageKeystoreKeyAlgorithm;
    }

    public static boolean isKeystoreConfigEnabled(ServizioApplicativo sa, ModIKeystoreConfigType configType) throws ProtocolException {
        String statoPropertyName = null;
        switch (configType.ordinal()) {
            case 0: {
                statoPropertyName = "modipaDPoPStato";
            }
        }
        return ProtocolPropertiesUtils.getBooleanValuePropertyConfig(sa.getProtocolPropertyList(), statoPropertyName, false);
    }

    public static boolean isKeystoreConfigRidefinito(IDSoggetto soggettoFruitore, AccordoServizioParteSpecifica asps, ModIKeystoreConfigType configType) throws ProtocolException {
        String keystoreFruizioneModePropertyName = null;
        switch (configType.ordinal()) {
            case 0: {
                keystoreFruizioneModePropertyName = "modipaDPoPFruizioneKeystoreMode";
            }
        }
        List<ProtocolProperty> listProtocolProperties = ProtocolPropertiesUtils.getProtocolProperties(true, soggettoFruitore, asps);
        String fruizioneMode = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry(listProtocolProperties, keystoreFruizioneModePropertyName);
        return "ridefinisci".equals(fruizioneMode);
    }

    public static boolean isKeystoreConfigDefault(IDSoggetto soggettoFruitore, AccordoServizioParteSpecifica asps, ModIKeystoreConfigType configType) throws ProtocolException {
        String keystoreFruizioneModePropertyName = null;
        switch (configType.ordinal()) {
            case 0: {
                keystoreFruizioneModePropertyName = "modipaDPoPFruizioneKeystoreMode";
            }
        }
        List<ProtocolProperty> listProtocolProperties = ProtocolPropertiesUtils.getProtocolProperties(true, soggettoFruitore, asps);
        String fruizioneMode = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry(listProtocolProperties, keystoreFruizioneModePropertyName);
        return "default".equals(fruizioneMode);
    }

    public ModIKeystoreUtils(ServizioApplicativo sa, ModIKeystoreConfigType configType) throws ProtocolException, UtilsException {
        boolean required;
        String statoPropertyName = null;
        String keystoreModePropertyName = null;
        String keystoreTypePropertyName = null;
        String keystoreArchivePropertyName = null;
        String keystorePathPropertyName = null;
        String keystorePathPublicKeyPropertyName = null;
        String keystoreKeyAlgorithmPropertyName = null;
        String keystorePsPropertyName = null;
        String keystoreByokPolicyPropertyName = null;
        String keyAliasPropertyName = null;
        String keyPsPropertyName = null;
        switch (configType.ordinal()) {
            case 0: {
                statoPropertyName = "modipaDPoPStato";
                keystoreModePropertyName = "modipaDPoPKeystoreMode";
                keystoreTypePropertyName = "modipaDPoPKeystoreType";
                keystoreArchivePropertyName = "modipaDPoPKeystoreArchive";
                keystorePathPropertyName = "modipaDPoPKeystorePath";
                keystorePathPublicKeyPropertyName = "modipaDPoPKeystorePathPublicKey";
                keystoreKeyAlgorithmPropertyName = "modipaDPoPKeystoreKeyPairAlgo";
                keystorePsPropertyName = "modipaDPoPKeystorePassword";
                keystoreByokPolicyPropertyName = "modipaDPoPKeystoreByokPolicy";
                keyAliasPropertyName = "modipaDPoPKeyAlias";
                keyPsPropertyName = "modipaDPoPKeyPassword";
            }
        }
        boolean stato = ProtocolPropertiesUtils.getBooleanValuePropertyConfig(sa.getProtocolPropertyList(), statoPropertyName, false);
        if (!stato) {
            throw new ProtocolException("La configurazione " + configType.name() + " non \u00e8 abilitata per l'applicativo " + sa.getNome() + " (" + sa.getNomeSoggettoProprietario() + ")");
        }
        this.securityMessageKeystoreMode = ProtocolPropertiesUtils.getRequiredStringValuePropertyConfig(sa.getProtocolPropertyList(), keystoreModePropertyName);
        if ("hsm".equals(this.securityMessageKeystoreMode)) {
            this.securityMessageKeystoreHSM = true;
        } else if ("archive".equals(this.securityMessageKeystoreMode)) {
            this.securityMessageKeystoreArchive = ProtocolPropertiesUtils.getRequiredBinaryValuePropertyConfig(sa.getProtocolPropertyList(), keystoreArchivePropertyName);
        } else {
            this.securityMessageKeystorePath = ProtocolPropertiesUtils.getRequiredStringValuePropertyConfig(sa.getProtocolPropertyList(), keystorePathPropertyName);
            try {
                HttpUtilities.validateUri((String)this.securityMessageKeystorePath, (boolean)true);
            }
            catch (Exception e) {
                throw new ProtocolException("[" + this.securityMessageKeystorePath + "] " + e.getMessage(), e);
            }
        }
        this.securityMessageKeystoreType = ProtocolPropertiesUtils.getRequiredStringValuePropertyConfig(sa.getProtocolPropertyList(), keystoreTypePropertyName);
        if (this.securityMessageKeystoreHSM) {
            this.securityMessageKeystorePath = "HSM-" + this.securityMessageKeystoreType;
        }
        if (!this.securityMessageKeystoreHSM) {
            if (CostantiDB.KEYSTORE_TYPE_KEY_PAIR.equalsIgnoreCase(this.securityMessageKeystoreType)) {
                this.securityMessageKeystorePathPublicKey = ProtocolPropertiesUtils.getRequiredStringValuePropertyConfig(sa.getProtocolPropertyList(), keystorePathPublicKeyPropertyName);
            }
            if (CostantiDB.KEYSTORE_TYPE_KEY_PAIR.equalsIgnoreCase(this.securityMessageKeystoreType) || CostantiDB.KEYSTORE_TYPE_PUBLIC_KEY.equalsIgnoreCase(this.securityMessageKeystoreType)) {
                this.securityMessageKeystoreKeyAlgorithm = ProtocolPropertiesUtils.getOptionalStringValuePropertyConfig(sa.getProtocolPropertyList(), keystoreKeyAlgorithmPropertyName);
                if (this.securityMessageKeystoreKeyAlgorithm == null || StringUtils.isEmpty((CharSequence)this.securityMessageKeystoreKeyAlgorithm)) {
                    this.securityMessageKeystoreKeyAlgorithm = "RSA";
                }
            }
        }
        if (!this.securityMessageKeystoreHSM) {
            if (!(CostantiDB.KEYSTORE_TYPE_JWK.equalsIgnoreCase(this.securityMessageKeystoreType) || CostantiDB.KEYSTORE_TYPE_KEY_PAIR.equalsIgnoreCase(this.securityMessageKeystoreType) || CostantiDB.KEYSTORE_TYPE_PUBLIC_KEY.equalsIgnoreCase(this.securityMessageKeystoreType))) {
                required = true;
                if (KeystoreType.JKS.isType(this.securityMessageKeystoreType) && !DBUtils.isKeystoreJksPasswordRequired() || KeystoreType.PKCS12.isType(this.securityMessageKeystoreType) && !DBUtils.isKeystorePkcs12PasswordRequired()) {
                    required = false;
                }
                this.securityMessageKeystorePassword = required ? ProtocolPropertiesUtils.getRequiredStringValuePropertyConfig(sa.getProtocolPropertyList(), keystorePsPropertyName) : ProtocolPropertiesUtils.getOptionalStringValuePropertyConfig(sa.getProtocolPropertyList(), keystorePsPropertyName);
            } else {
                this.securityMessageKeystorePassword = ProtocolPropertiesUtils.getOptionalStringValuePropertyConfig(sa.getProtocolPropertyList(), keystorePsPropertyName);
            }
        } else {
            this.securityMessageKeystorePassword = "-";
        }
        this.securityMessageKeystoreByokPolicy = !this.securityMessageKeystoreHSM && !"archive".equals(this.securityMessageKeystoreMode) ? ProtocolPropertiesUtils.getOptionalStringValuePropertyConfig(sa.getProtocolPropertyList(), keystoreByokPolicyPropertyName) : "-";
        if (!CostantiDB.KEYSTORE_TYPE_KEY_PAIR.equalsIgnoreCase(this.securityMessageKeystoreType) && !CostantiDB.KEYSTORE_TYPE_PUBLIC_KEY.equalsIgnoreCase(this.securityMessageKeystoreType)) {
            this.securityMessageKeyAlias = ProtocolPropertiesUtils.getRequiredStringValuePropertyConfig(sa.getProtocolPropertyList(), keyAliasPropertyName);
        }
        if (!this.securityMessageKeystoreHSM) {
            if (!(CostantiDB.KEYSTORE_TYPE_JWK.equalsIgnoreCase(this.securityMessageKeystoreType) || CostantiDB.KEYSTORE_TYPE_KEY_PAIR.equalsIgnoreCase(this.securityMessageKeystoreType) || CostantiDB.KEYSTORE_TYPE_PUBLIC_KEY.equalsIgnoreCase(this.securityMessageKeystoreType))) {
                required = true;
                if (KeystoreType.JKS.isType(this.securityMessageKeystoreType) && !DBUtils.isKeystoreJksKeyPasswordRequired() || KeystoreType.PKCS12.isType(this.securityMessageKeystoreType) && !DBUtils.isKeystorePkcs12KeyPasswordRequired()) {
                    required = false;
                }
                this.securityMessageKeyPassword = required ? ProtocolPropertiesUtils.getRequiredStringValuePropertyConfig(sa.getProtocolPropertyList(), keyPsPropertyName) : ProtocolPropertiesUtils.getOptionalStringValuePropertyConfig(sa.getProtocolPropertyList(), keyPsPropertyName);
            } else {
                this.securityMessageKeyPassword = ProtocolPropertiesUtils.getOptionalStringValuePropertyConfig(sa.getProtocolPropertyList(), keyPsPropertyName);
            }
        } else {
            this.securityMessageKeyPassword = HSMUtils.isHsmConfigurableKeyPassword() ? ProtocolPropertiesUtils.getRequiredStringValuePropertyConfig(sa.getProtocolPropertyList(), keyPsPropertyName) : "-";
        }
    }

    public ModIKeystoreUtils(IDSoggetto soggettoFruitore, AccordoServizioParteSpecifica asps, ModIKeystoreConfigType configType) throws ProtocolException, UtilsException {
        boolean required;
        String keystoreFruizioneModePropertyName = null;
        String keystoreModePropertyName = null;
        String keystoreTypePropertyName = null;
        String keystoreArchivePropertyName = null;
        String keystorePathPropertyName = null;
        String keystorePathPublicKeyPropertyName = null;
        String keystoreKeyAlgorithmPropertyName = null;
        String keystorePsPropertyName = null;
        String keystoreByokPolicyPropertyName = null;
        String keyAliasPropertyName = null;
        String keyPsPropertyName = null;
        switch (configType.ordinal()) {
            case 0: {
                keystoreFruizioneModePropertyName = "modipaDPoPFruizioneKeystoreMode";
                keystoreModePropertyName = "modipaDPoPKeystoreMode";
                keystoreTypePropertyName = "modipaDPoPKeystoreType";
                keystoreArchivePropertyName = "modipaDPoPKeystoreArchive";
                keystorePathPropertyName = "modipaDPoPKeystorePath";
                keystorePathPublicKeyPropertyName = "modipaDPoPKeystorePathPublicKey";
                keystoreKeyAlgorithmPropertyName = "modipaDPoPKeystoreKeyPairAlgo";
                keystorePsPropertyName = "modipaDPoPKeystorePassword";
                keystoreByokPolicyPropertyName = "modipaDPoPKeystoreByokPolicy";
                keyAliasPropertyName = "modipaDPoPKeyAlias";
                keyPsPropertyName = "modipaDPoPKeyPassword";
            }
        }
        List<ProtocolProperty> listProtocolProperties = ProtocolPropertiesUtils.getProtocolProperties(true, soggettoFruitore, asps);
        String fruizioneMode = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry(listProtocolProperties, keystoreFruizioneModePropertyName);
        if (fruizioneMode == null || StringUtils.isEmpty((CharSequence)fruizioneMode) || "-".equals(fruizioneMode) || "default".equals(fruizioneMode) || !"ridefinisci".equals(fruizioneMode)) {
            throw new ProtocolException("La configurazione " + configType.name() + " non \u00e8 ridefinita per la fruizione");
        }
        this.securityMessageKeystoreMode = ProtocolPropertiesUtils.getRequiredStringValuePropertyRegistry(listProtocolProperties, keystoreModePropertyName);
        if ("hsm".equals(this.securityMessageKeystoreMode)) {
            this.securityMessageKeystoreHSM = true;
        } else if ("archive".equals(this.securityMessageKeystoreMode)) {
            this.securityMessageKeystoreArchive = ProtocolPropertiesUtils.getRequiredBinaryValuePropertyRegistry(listProtocolProperties, keystoreArchivePropertyName);
        } else {
            this.securityMessageKeystorePath = ProtocolPropertiesUtils.getRequiredStringValuePropertyRegistry(listProtocolProperties, keystorePathPropertyName);
            try {
                HttpUtilities.validateUri((String)this.securityMessageKeystorePath, (boolean)true);
            }
            catch (Exception e) {
                throw new ProtocolException("[" + this.securityMessageKeystorePath + "] " + e.getMessage(), e);
            }
        }
        this.securityMessageKeystoreType = ProtocolPropertiesUtils.getRequiredStringValuePropertyRegistry(listProtocolProperties, keystoreTypePropertyName);
        if (this.securityMessageKeystoreHSM) {
            this.securityMessageKeystorePath = "HSM-" + this.securityMessageKeystoreType;
        }
        if (!this.securityMessageKeystoreHSM) {
            if (CostantiDB.KEYSTORE_TYPE_KEY_PAIR.equalsIgnoreCase(this.securityMessageKeystoreType)) {
                this.securityMessageKeystorePathPublicKey = ProtocolPropertiesUtils.getRequiredStringValuePropertyRegistry(listProtocolProperties, keystorePathPublicKeyPropertyName);
            }
            if (CostantiDB.KEYSTORE_TYPE_KEY_PAIR.equalsIgnoreCase(this.securityMessageKeystoreType) || CostantiDB.KEYSTORE_TYPE_PUBLIC_KEY.equalsIgnoreCase(this.securityMessageKeystoreType)) {
                this.securityMessageKeystoreKeyAlgorithm = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry(listProtocolProperties, keystoreKeyAlgorithmPropertyName);
                if (this.securityMessageKeystoreKeyAlgorithm == null || StringUtils.isEmpty((CharSequence)this.securityMessageKeystoreKeyAlgorithm)) {
                    this.securityMessageKeystoreKeyAlgorithm = "RSA";
                }
            }
        }
        if (!this.securityMessageKeystoreHSM) {
            if (!(CostantiDB.KEYSTORE_TYPE_JWK.equalsIgnoreCase(this.securityMessageKeystoreType) || CostantiDB.KEYSTORE_TYPE_KEY_PAIR.equalsIgnoreCase(this.securityMessageKeystoreType) || CostantiDB.KEYSTORE_TYPE_PUBLIC_KEY.equalsIgnoreCase(this.securityMessageKeystoreType))) {
                required = true;
                if (KeystoreType.JKS.isType(this.securityMessageKeystoreType) && !DBUtils.isKeystoreJksPasswordRequired() || KeystoreType.PKCS12.isType(this.securityMessageKeystoreType) && !DBUtils.isKeystorePkcs12PasswordRequired()) {
                    required = false;
                }
                this.securityMessageKeystorePassword = required ? ProtocolPropertiesUtils.getRequiredStringValuePropertyRegistry(listProtocolProperties, keystorePsPropertyName) : ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry(listProtocolProperties, keystorePsPropertyName);
            } else {
                this.securityMessageKeystorePassword = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry(listProtocolProperties, keystorePsPropertyName);
            }
        } else {
            this.securityMessageKeystorePassword = "-";
        }
        this.securityMessageKeystoreByokPolicy = !this.securityMessageKeystoreHSM && !"archive".equals(this.securityMessageKeystoreMode) ? ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry(listProtocolProperties, keystoreByokPolicyPropertyName) : "-";
        if (!CostantiDB.KEYSTORE_TYPE_KEY_PAIR.equalsIgnoreCase(this.securityMessageKeystoreType) && !CostantiDB.KEYSTORE_TYPE_PUBLIC_KEY.equalsIgnoreCase(this.securityMessageKeystoreType)) {
            this.securityMessageKeyAlias = ProtocolPropertiesUtils.getRequiredStringValuePropertyRegistry(listProtocolProperties, keyAliasPropertyName);
        }
        if (!this.securityMessageKeystoreHSM) {
            if (!(CostantiDB.KEYSTORE_TYPE_JWK.equalsIgnoreCase(this.securityMessageKeystoreType) || CostantiDB.KEYSTORE_TYPE_KEY_PAIR.equalsIgnoreCase(this.securityMessageKeystoreType) || CostantiDB.KEYSTORE_TYPE_PUBLIC_KEY.equalsIgnoreCase(this.securityMessageKeystoreType))) {
                required = true;
                if (KeystoreType.JKS.isType(this.securityMessageKeystoreType) && !DBUtils.isKeystoreJksKeyPasswordRequired() || KeystoreType.PKCS12.isType(this.securityMessageKeystoreType) && !DBUtils.isKeystorePkcs12KeyPasswordRequired()) {
                    required = false;
                }
                this.securityMessageKeyPassword = required ? ProtocolPropertiesUtils.getRequiredStringValuePropertyRegistry(listProtocolProperties, keyPsPropertyName) : ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry(listProtocolProperties, keyPsPropertyName);
            } else {
                this.securityMessageKeyPassword = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry(listProtocolProperties, keyPsPropertyName);
            }
        } else {
            this.securityMessageKeyPassword = HSMUtils.isHsmConfigurableKeyPassword() ? ProtocolPropertiesUtils.getRequiredStringValuePropertyRegistry(listProtocolProperties, keyPsPropertyName) : "-";
        }
    }

    public ModIKeystoreUtils(IDSoggetto soggettoFruitore, AccordoServizioParteSpecifica asps, ModIKeystoreConfigType configType, String modIpropertiesSecurityMessageKeystoreType, String modIpropertiesSecurityMessageKeystorePath, String modIpropertiesSecurityMessageKeystorePassword, String modIpropertiesSecurityMessageKeyAlias, String modIpropertiesSecurityMessageKeyPassword) throws ProtocolException, UtilsException {
        String keystoreFruizioneModePropertyName = null;
        String prefix = null;
        switch (configType.ordinal()) {
            case 0: {
                keystoreFruizioneModePropertyName = "modipaDPoPFruizioneKeystoreMode";
                prefix = "DPoP - KeyStore";
            }
        }
        List<ProtocolProperty> listProtocolProperties = ProtocolPropertiesUtils.getProtocolProperties(true, soggettoFruitore, asps);
        String fruizioneMode = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry(listProtocolProperties, keystoreFruizioneModePropertyName);
        if (fruizioneMode == null || StringUtils.isEmpty((CharSequence)fruizioneMode) || "-".equals(fruizioneMode) || "ridefinisci".equals(fruizioneMode)) {
            throw new ProtocolException("La configurazione " + configType.name() + " non utilizza un keystore di default per la fruizione");
        }
        this.securityMessageKeystoreType = modIpropertiesSecurityMessageKeystoreType;
        if (this.securityMessageKeystoreType != null) {
            this.securityMessageKeystoreHSM = HSMUtils.isKeystoreHSM((String)this.securityMessageKeystoreType);
            if (this.securityMessageKeystoreHSM) {
                this.securityMessageKeystorePath = "HSM-" + this.securityMessageKeystoreType;
            } else {
                this.securityMessageKeystorePath = modIpropertiesSecurityMessageKeystorePath;
                try {
                    HttpUtilities.validateUri((String)this.securityMessageKeystorePath, (boolean)true);
                }
                catch (Exception e) {
                    throw new ProtocolException(prefix + " [" + this.securityMessageKeystorePath + "] " + e.getMessage(), e);
                }
            }
            this.securityMessageKeystorePassword = !this.securityMessageKeystoreHSM ? modIpropertiesSecurityMessageKeystorePassword : "-";
            this.securityMessageKeyAlias = modIpropertiesSecurityMessageKeyAlias;
            this.securityMessageKeyPassword = !this.securityMessageKeystoreHSM || HSMUtils.isHsmConfigurableKeyPassword() ? modIpropertiesSecurityMessageKeyPassword : "-";
        } else {
            throw new ProtocolException(prefix + " default non definito nelle propriet\u00e0 di protocollo");
        }
    }

    public static enum ModIKeystoreConfigType {
        DPOP;

    }
}

