/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.lib.users;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.commons.Filtri;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.commons.SearchUtils;
import org.openspcoop2.core.commons.search.AccordoServizioParteSpecifica;
import org.openspcoop2.core.commons.search.Soggetto;
import org.openspcoop2.core.commons.search.dao.IDBAccordoServizioParteSpecificaServiceSearch;
import org.openspcoop2.core.commons.search.dao.IDBSoggettoServiceSearch;
import org.openspcoop2.core.commons.search.dao.jdbc.JDBCServiceManager;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.constants.PddTipologia;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.generic_project.dao.jdbc.JDBCServiceManagerProperties;
import org.openspcoop2.protocol.sdk.tracciamento.DriverTracciamentoException;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.resources.GestoreJNDI;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;
import org.openspcoop2.utils.sql.SQLQueryObjectException;
import org.openspcoop2.web.lib.users.DriverUsersDBException;
import org.openspcoop2.web.lib.users.RicercaUtenteNotFoundException;
import org.openspcoop2.web.lib.users.dao.InterfaceType;
import org.openspcoop2.web.lib.users.dao.PermessiUtente;
import org.openspcoop2.web.lib.users.dao.RicercaUtente;
import org.openspcoop2.web.lib.users.dao.Stato;
import org.openspcoop2.web.lib.users.dao.User;
import org.openspcoop2.web.lib.users.dao.UserObjects;
import org.openspcoop2.web.lib.users.dao.UserPassword;
import org.slf4j.Logger;

public class DriverUsersDB {
    private static final String LOG_DRIVER_DB_USER = "DRIVER_DB_USER";
    private DataSource datasource = null;
    private Connection connection = null;
    private boolean connectionOpenViaJDBCInCostructor = false;
    String tipoDatabase = null;
    private Logger log;
    private static final String DB_PASSWORD_EMPTY_VALUE = " ";

    public void close() throws DriverTracciamentoException {
        try {
            if (this.connectionOpenViaJDBCInCostructor && this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
            }
        }
        catch (Exception e) {
            throw new DriverTracciamentoException(e.getMessage(), (Throwable)e);
        }
    }

    public DriverUsersDB(String nomeDataSource, String tipoDatabase, Properties jndiContext) throws DriverUsersDBException {
        this(nomeDataSource, tipoDatabase, jndiContext, null);
    }

    public DriverUsersDB(String nomeDataSource, String tipoDatabase, Properties jndiContext, Logger log) throws DriverUsersDBException {
        try {
            this.log = log == null ? LoggerWrapperFactory.getLogger((String)LOG_DRIVER_DB_USER) : log;
        }
        catch (Exception e) {
            throw new DriverUsersDBException("Errore durante l'inizializzazione del logger...", e);
        }
        try {
            this.log.info("Inizializzo DriverUsersDB...");
            GestoreJNDI gestoreJNDI = new GestoreJNDI(jndiContext);
            this.datasource = (DataSource)gestoreJNDI.lookup(nomeDataSource);
            if (this.datasource == null) {
                throw new Exception("datasource is null");
            }
            this.log.info("Inizializzo DriverUsersDB terminata.");
        }
        catch (Exception e) {
            this.log.error("Errore durante la ricerca del datasource...", (Throwable)e);
            throw new DriverUsersDBException("Errore durante la ricerca del datasource...", e);
        }
        try {
            this.log.info("Inizializzo ISQLQueryObject...");
            if (!TipiDatabase.isAMember((String)tipoDatabase)) {
                throw new Exception("Tipo database non gestito");
            }
            this.tipoDatabase = tipoDatabase;
            this.log.info("Inizializzo ISQLQueryObject terminata.");
        }
        catch (Exception e) {
            this.log.error("Errore durante la ricerca del SQLQueryObject...", (Throwable)e);
            throw new DriverUsersDBException("Errore durante la ricerca del SQLQueryObject...", e);
        }
    }

    public DriverUsersDB(DataSource dataSourceObject, String tipoDatabase) throws DriverUsersDBException {
        this(dataSourceObject, tipoDatabase, null);
    }

    public DriverUsersDB(DataSource dataSourceObject, String tipoDatabase, Logger log) throws DriverUsersDBException {
        try {
            this.log = log == null ? LoggerWrapperFactory.getLogger((String)LOG_DRIVER_DB_USER) : log;
        }
        catch (Exception e) {
            throw new DriverUsersDBException("Errore durante l'inizializzazione del logger...", e);
        }
        try {
            this.datasource = dataSourceObject;
            if (this.datasource == null) {
                throw new Exception("datasource is null");
            }
        }
        catch (Exception e) {
            this.log.error("Errore durante la ricerca del datasource...", (Throwable)e);
            throw new DriverUsersDBException("Errore durante la ricerca del datasource...", e);
        }
        try {
            this.log.info("Inizializzo ISQLQueryObject...");
            if (!TipiDatabase.isAMember((String)tipoDatabase)) {
                throw new Exception("Tipo database non gestito");
            }
            this.tipoDatabase = tipoDatabase;
            this.log.info("Inizializzo ISQLQueryObject terminata.");
        }
        catch (Exception e) {
            this.log.error("Errore durante la ricerca del SQLQueryObject...", (Throwable)e);
            throw new DriverUsersDBException("Errore durante la ricerca del SQLQueryObject...", e);
        }
    }

    public DriverUsersDB(Connection connection, String tipoDatabase) throws DriverUsersDBException {
        this(connection, tipoDatabase, null);
    }

    public DriverUsersDB(Connection connection, String tipoDatabase, Logger log) throws DriverUsersDBException {
        try {
            this.log = log == null ? LoggerWrapperFactory.getLogger((String)LOG_DRIVER_DB_USER) : log;
        }
        catch (Exception e) {
            throw new DriverUsersDBException("Errore durante l'inizializzazione del logger...", e);
        }
        this.connection = connection;
        try {
            this.log.info("Inizializzo ISQLQueryObject...");
            if (!TipiDatabase.isAMember((String)tipoDatabase)) {
                throw new Exception("Tipo database non gestito");
            }
            this.tipoDatabase = tipoDatabase;
            this.log.info("Inizializzo ISQLQueryObject terminata.");
        }
        catch (Exception e) {
            this.log.error("Errore durante la ricerca del SQLQueryObject...", (Throwable)e);
            throw new DriverUsersDBException("Errore durante la ricerca del SQLQueryObject...", e);
        }
    }

    public DriverUsersDB(String urlJDBC, String driverJDBC, String username, String password, String tipoDatabase) throws DriverUsersDBException {
        this(urlJDBC, driverJDBC, username, password, tipoDatabase, null);
    }

    public DriverUsersDB(String urlJDBC, String driverJDBC, String username, String password, String tipoDatabase, Logger log) throws DriverUsersDBException {
        try {
            this.log = log == null ? LoggerWrapperFactory.getLogger((String)LOG_DRIVER_DB_USER) : log;
        }
        catch (Exception e) {
            throw new DriverUsersDBException("Errore durante l'inizializzazione del logger...", e);
        }
        try {
            Class.forName(driverJDBC);
            this.connection = username != null ? DriverManager.getConnection(urlJDBC, username, password) : DriverManager.getConnection(urlJDBC);
            this.connectionOpenViaJDBCInCostructor = true;
        }
        catch (Exception e) {
            this.log.error("Errore durante l'inizializzazione della connessione...", (Throwable)e);
            throw new DriverUsersDBException("Errore durante l'inizializzazione della connessione...", e);
        }
        try {
            this.log.info("Inizializzo ISQLQueryObject...");
            if (!TipiDatabase.isAMember((String)tipoDatabase)) {
                throw new Exception("Tipo database non gestito");
            }
            this.tipoDatabase = tipoDatabase;
            this.log.info("Inizializzo ISQLQueryObject terminata.");
        }
        catch (Exception e) {
            this.log.error("Errore durante la ricerca del SQLQueryObject...", (Throwable)e);
            throw new DriverUsersDBException("Errore durante la ricerca del SQLQueryObject...", e);
        }
    }

    private Connection getConnection() throws Exception {
        Connection connectionDB = null;
        connectionDB = this.connection != null ? this.connection : this.datasource.getConnection();
        this.checkConnection(connectionDB);
        return connectionDB;
    }

    private void checkConnection(Connection connectionDB) throws Exception {
        if (connectionDB == null) {
            throw new Exception("Connection non ottenuta dal datasource[" + String.valueOf(this.datasource) + "]");
        }
    }

    private void releaseConnection(Connection connectionDB) {
        try {
            if (this.connection == null && connectionDB != null) {
                connectionDB.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public User getUser(String login) throws DriverUsersDBException {
        if (login == null) {
            throw new DriverUsersDBException("[getUser] Parametri Non Validi");
        }
        Connection connectionDB = null;
        try {
            connectionDB = this.getConnection();
            User user = this.getUser(connectionDB, login);
            return user;
        }
        catch (SQLException se) {
            throw new DriverUsersDBException("[DriverUsersDB::getUser] SqlException: " + se.getMessage(), se);
        }
        catch (Exception ex) {
            throw new DriverUsersDBException("[DriverUsersDB::getUser] Exception: " + ex.getMessage(), ex);
        }
        finally {
            this.releaseConnection(connectionDB);
        }
    }

    private static final String convertToDbValue(String v) {
        if ("".equals(v)) {
            return DB_PASSWORD_EMPTY_VALUE;
        }
        return v;
    }

    private static final String convertFromDbValue(String v) {
        if (DB_PASSWORD_EMPTY_VALUE.equals(v)) {
            return "";
        }
        return v;
    }

    public User getUser(Connection conParam, String login) throws DriverUsersDBException {
        if (login == null) {
            throw new DriverUsersDBException("[getUser] Parametri Non Validi");
        }
        User user = null;
        Statement stm = null;
        ResultSet rs = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            sqlQueryObject.addFromTable("users");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("login = ?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = conParam.prepareStatement(sqlQuery);
            stm.setString(1, login);
            rs = stm.executeQuery();
            if (rs.next()) {
                user = new User();
                user.setId(Long.valueOf(rs.getInt("id")));
                user.setLogin(login);
                user.setPassword(DriverUsersDB.convertFromDbValue(rs.getString("password")));
                user.setLastUpdatePassword(rs.getTimestamp("data_password"));
                user.setCheckLastUpdatePassword(rs.getInt("check_data_password") == 1);
                String gui = rs.getString("tipo_interfaccia");
                if (gui == null || "".equals(gui)) {
                    user.setInterfaceType(InterfaceType.AVANZATA);
                } else {
                    user.setInterfaceType(InterfaceType.valueOf(gui.toUpperCase()));
                }
                int interfaceCompletePermit = rs.getInt("interfaccia_completa");
                if (1 == interfaceCompletePermit) {
                    user.setPermitInterfaceComplete(true);
                } else {
                    user.setPermitInterfaceComplete(false);
                }
                String perm = rs.getString("permessi");
                user.setPermessi(PermessiUtente.toPermessiUtente(perm));
                String protocolli = rs.getString("protocolli");
                user.setProtocolliSupportatiFromString(protocolli);
                String protocollo_pddconsole = rs.getString("protocollo_pddconsole");
                user.setProtocolloSelezionatoPddConsole(protocollo_pddconsole);
                String protocollo_pddmonitor = rs.getString("protocollo_pddmonitor");
                user.setProtocolloSelezionatoPddMonitor(protocollo_pddmonitor);
                String soggetto_pddconsole = rs.getString("soggetto_pddconsole");
                user.setSoggettoSelezionatoPddConsole(soggetto_pddconsole);
                String soggetto_pddmonitor = rs.getString("soggetto_pddmonitor");
                user.setSoggettoSelezionatoPddMonitor(soggetto_pddmonitor);
                int permitAllSoggetti = rs.getInt("soggetti_all");
                if (1 == permitAllSoggetti) {
                    user.setPermitAllSoggetti(true);
                } else {
                    user.setPermitAllSoggetti(false);
                }
                int permitAllServizi = rs.getInt("servizi_all");
                if (1 == permitAllServizi) {
                    user.setPermitAllServizi(true);
                } else {
                    user.setPermitAllServizi(false);
                }
                if (user.isPermitInterfaceComplete()) {
                    user.setInterfaceType(InterfaceType.COMPLETA);
                }
            }
            rs.close();
            stm.close();
            if (user == null) {
                throw new DriverUsersDBException("[DriverUsersDB::getUser] User [" + login + "] non esistente.");
            }
            JDBCServiceManagerProperties jdbcProperties = new JDBCServiceManagerProperties();
            jdbcProperties.setDatabaseType(this.tipoDatabase);
            jdbcProperties.setShowSql(true);
            JDBCServiceManager search = new JDBCServiceManager(conParam, jdbcProperties, this.log);
            IDBSoggettoServiceSearch soggettiSearch = (IDBSoggettoServiceSearch)search.getSoggettoServiceSearch();
            IDBAccordoServizioParteSpecificaServiceSearch serviziSearch = (IDBAccordoServizioParteSpecificaServiceSearch)search.getAccordoServizioParteSpecificaServiceSearch();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            sqlQueryObject.addFromTable("users_stati");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_utente = ?");
            sqlQueryObject.addOrderBy("users_stati.oggetto");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setANDLogicOperator(true);
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = conParam.prepareStatement(sqlQuery);
            stm.setLong(1, user.getId());
            rs = stm.executeQuery();
            while (rs.next()) {
                String oggetto = rs.getString("oggetto");
                String stato = rs.getString("stato");
                Stato statoObject = new Stato();
                statoObject.setOggetto(oggetto);
                statoObject.setStato(stato);
                user.getStati().add(statoObject);
            }
            rs.close();
            stm.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            sqlQueryObject.addFromTable("users_password");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_utente = ?");
            sqlQueryObject.addOrderBy("users_password.data_password");
            sqlQueryObject.setSortType(false);
            sqlQueryObject.setANDLogicOperator(true);
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = conParam.prepareStatement(sqlQuery);
            stm.setLong(1, user.getId());
            rs = stm.executeQuery();
            while (rs.next()) {
                UserPassword userPassword = new UserPassword();
                userPassword.setPassword(DriverUsersDB.convertFromDbValue(rs.getString("password")));
                userPassword.setDatePassword(rs.getTimestamp("data_password"));
                user.getPrecedentiPassword().add(userPassword);
            }
            rs.close();
            stm.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            sqlQueryObject.addFromTable("users_soggetti");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("users_soggetti.id_soggetto");
            sqlQueryObject.addSelectField("soggetti.nome_soggetto");
            sqlQueryObject.addSelectField("soggetti.tipo_soggetto");
            sqlQueryObject.addWhereCondition("id_utente = ?");
            sqlQueryObject.addWhereCondition("users_soggetti.id_soggetto = soggetti.id");
            sqlQueryObject.addOrderBy("soggetti.nome_soggetto");
            sqlQueryObject.addOrderBy("soggetti.tipo_soggetto");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setANDLogicOperator(true);
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = conParam.prepareStatement(sqlQuery);
            stm.setLong(1, user.getId());
            rs = stm.executeQuery();
            while (rs.next()) {
                long id = rs.getLong("id_soggetto");
                Soggetto soggetto = (Soggetto)soggettiSearch.get(id);
                IDSoggetto idSoggetto = new IDSoggetto(soggetto.getTipoSoggetto(), soggetto.getNomeSoggetto(), soggetto.getIdentificativoPorta());
                user.getSoggetti().add(idSoggetto);
            }
            rs.close();
            stm.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            sqlQueryObject.addFromTable("users_servizi");
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("users_servizi.id_servizio");
            sqlQueryObject.addSelectField("servizi.tipo_servizio");
            sqlQueryObject.addSelectField("servizi.nome_servizio");
            sqlQueryObject.addSelectField("servizi.versione_servizio");
            sqlQueryObject.addSelectField("soggetti.tipo_soggetto");
            sqlQueryObject.addSelectField("soggetti.nome_soggetto");
            sqlQueryObject.addWhereCondition("id_utente = ?");
            sqlQueryObject.addWhereCondition("users_servizi.id_servizio = servizi.id");
            sqlQueryObject.addWhereCondition("servizi.id_soggetto = soggetti.id");
            sqlQueryObject.addOrderBy("servizi.nome_servizio");
            sqlQueryObject.addOrderBy("servizi.versione_servizio");
            sqlQueryObject.addOrderBy("soggetti.nome_soggetto");
            sqlQueryObject.addOrderBy("servizi.tipo_servizio");
            sqlQueryObject.addOrderBy("soggetti.tipo_soggetto");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setANDLogicOperator(true);
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = conParam.prepareStatement(sqlQuery);
            stm.setLong(1, user.getId());
            rs = stm.executeQuery();
            while (rs.next()) {
                long id = rs.getLong("id_servizio");
                AccordoServizioParteSpecifica servizio = (AccordoServizioParteSpecifica)serviziSearch.get(id);
                IDServizio idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(servizio.getTipo(), servizio.getNome(), servizio.getIdErogatore().getTipo(), servizio.getIdErogatore().getNome(), servizio.getVersione().intValue());
                user.getServizi().add(idServizio);
            }
            rs.close();
            stm.close();
            User user2 = user;
            return user2;
        }
        catch (SQLException se) {
            throw new DriverUsersDBException("[DriverUsersDB::getUser] SqlException: " + se.getMessage(), se);
        }
        catch (Exception ex) {
            throw new DriverUsersDBException("[DriverUsersDB::getUser] Exception: " + ex.getMessage(), ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception exception) {}
            try {
                stm.close();
            }
            catch (Exception exception) {}
        }
    }

    public User getUser(Long id) throws DriverUsersDBException {
        if (id == null || id <= 0L) {
            throw new DriverUsersDBException("[getUser] Parametri Non Validi");
        }
        Connection connectionDB = null;
        User user = null;
        Statement stm = null;
        ResultSet rs = null;
        try {
            connectionDB = this.getConnection();
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            sqlQueryObject.addFromTable("users");
            sqlQueryObject.addSelectField("login");
            sqlQueryObject.addWhereCondition("id = ?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connectionDB.prepareStatement(sqlQuery);
            stm.setLong(1, id);
            rs = stm.executeQuery();
            if (rs.next()) {
                user = this.getUser(connectionDB, rs.getString("login"));
            }
            rs.close();
            stm.close();
            if (user == null) {
                throw new DriverUsersDBException("[DriverUsersDB::getUser] User [id:" + id + "] non esistente.");
            }
            User user2 = user;
            return user2;
        }
        catch (SQLException se) {
            throw new DriverUsersDBException("[DriverUsersDB::getUser] SqlException: " + se.getMessage(), se);
        }
        catch (Exception ex) {
            throw new DriverUsersDBException("[DriverUsersDB::getUser] Exception: " + ex.getMessage(), ex);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            this.releaseConnection(connectionDB);
        }
    }

    public List<User> userList(ISearch ricerca) throws DriverUsersDBException {
        return this.userList(ricerca, Liste.SU);
    }

    public List<User> userList(ISearch ricerca, int IDLISTA) throws DriverUsersDBException {
        String nomeMetodo = "userList";
        int idLista = IDLISTA;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection connectionDB = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<User> lista = new ArrayList<User>();
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            connectionDB = this.getConnection();
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
                sqlQueryObject.addFromTable("users");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereLikeCondition("login", search, true, true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
                sqlQueryObject.addFromTable("users");
                sqlQueryObject.addSelectCountField("*", "cont");
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = connectionDB.prepareStatement(queryString);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
                sqlQueryObject.addFromTable("users");
                sqlQueryObject.addSelectField("login");
                sqlQueryObject.addWhereLikeCondition("login", search, true, true);
                sqlQueryObject.addOrderBy("login");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
                sqlQueryObject.addFromTable("users");
                sqlQueryObject.addSelectField("login");
                sqlQueryObject.addOrderBy("login");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = connectionDB.prepareStatement(queryString);
            risultato = stmt.executeQuery();
            User newU = null;
            while (risultato.next()) {
                newU = this.getUser(connectionDB, risultato.getString("login"));
                lista.add(newU);
            }
            risultato.close();
            ArrayList<User> arrayList = lista;
            return arrayList;
        }
        catch (Exception qe) {
            throw new DriverUsersDBException("[DriverUsersDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            this.releaseConnection(connectionDB);
        }
    }

    public boolean existsUser(String login) throws DriverUsersDBException {
        Connection connectionDB = null;
        Statement stm = null;
        ResultSet rs = null;
        String sqlQuery = "";
        try {
            connectionDB = this.getConnection();
            boolean esiste = false;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            sqlQueryObject.addFromTable("users");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("login = ?");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connectionDB.prepareStatement(sqlQuery);
            stm.setString(1, login);
            rs = stm.executeQuery();
            if (rs.next()) {
                esiste = true;
            }
            rs.close();
            stm.close();
            boolean bl = esiste;
            return bl;
        }
        catch (Exception qe) {
            throw new DriverUsersDBException(qe.getMessage(), qe);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            this.releaseConnection(connectionDB);
        }
    }

    public List<String> getUsersByPermesso(String permesso) throws DriverUsersDBException {
        Connection connectionDB = null;
        Statement stm = null;
        ResultSet rs = null;
        String sqlQuery = "";
        try {
            connectionDB = this.getConnection();
            ArrayList<String> userWithType = new ArrayList<String>();
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            sqlQueryObject.addFromTable("users");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addWhereLikeCondition("permessi", permesso, true, true);
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connectionDB.prepareStatement(sqlQuery);
            rs = stm.executeQuery();
            while (rs.next()) {
                userWithType.add(rs.getString("login"));
            }
            rs.close();
            stm.close();
            ArrayList<String> arrayList = userWithType;
            return arrayList;
        }
        catch (Exception qe) {
            throw new DriverUsersDBException(qe.getMessage(), qe);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            this.releaseConnection(connectionDB);
        }
    }

    public List<String> getUsersByProtocolloSupportato(String protocollo) throws DriverUsersDBException {
        return this.getUsersByProtocolloSupportato(protocollo, false);
    }

    public List<String> getUsersByProtocolloSupportato(String protocollo, boolean esclusiUtentiConSoloPermessoUtente) throws DriverUsersDBException {
        Connection connectionDB = null;
        Statement stm = null;
        ResultSet rs = null;
        String sqlQuery = "";
        try {
            connectionDB = this.getConnection();
            ArrayList<String> userWithType = new ArrayList<String>();
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            sqlQueryObject.addFromTable("users");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.setANDLogicOperator(true);
            ISQLQueryObject sqlQueryObjectPermit = sqlQueryObject.newSQLQueryObject();
            sqlQueryObjectPermit.addWhereIsNullCondition("protocolli");
            sqlQueryObjectPermit.addWhereLikeCondition("protocolli", protocollo, true, true);
            sqlQueryObjectPermit.setANDLogicOperator(false);
            sqlQueryObject.addWhereCondition(sqlQueryObjectPermit.createSQLConditions());
            if (esclusiUtentiConSoloPermessoUtente) {
                sqlQueryObject.addWhereCondition("permessi <> ?");
            }
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connectionDB.prepareStatement(sqlQuery);
            if (esclusiUtentiConSoloPermessoUtente) {
                stm.setString(1, "U");
            }
            rs = stm.executeQuery();
            while (rs.next()) {
                userWithType.add(rs.getString("login"));
            }
            rs.close();
            stm.close();
            ArrayList<String> arrayList = userWithType;
            return arrayList;
        }
        catch (Exception qe) {
            throw new DriverUsersDBException(qe.getMessage(), qe);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            this.releaseConnection(connectionDB);
        }
    }

    public void createUser(User user) throws DriverUsersDBException {
        Connection connectionDB = null;
        Statement stm = null;
        ResultSet rs = null;
        String sqlQuery = "";
        if (user == null) {
            throw new DriverUsersDBException("[DriverUsersDB::createUser] Parametro non valido.");
        }
        String login = user.getLogin();
        if (login == null || login.equals("")) {
            throw new DriverUsersDBException("[DriverUsersDB::createUser] Parametro Login non valido.");
        }
        try {
            connectionDB = this.getConnection();
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            sqlQueryObject.addInsertTable("users");
            sqlQueryObject.addInsertField("login", "?");
            sqlQueryObject.addInsertField("password", "?");
            sqlQueryObject.addInsertField("data_password", "?");
            sqlQueryObject.addInsertField("check_data_password", "?");
            sqlQueryObject.addInsertField("tipo_interfaccia", "?");
            sqlQueryObject.addInsertField("interfaccia_completa", "?");
            sqlQueryObject.addInsertField("permessi", "?");
            sqlQueryObject.addInsertField("protocolli", "?");
            sqlQueryObject.addInsertField("protocollo_pddconsole", "?");
            sqlQueryObject.addInsertField("protocollo_pddmonitor", "?");
            sqlQueryObject.addInsertField("soggetto_pddconsole", "?");
            sqlQueryObject.addInsertField("soggetto_pddmonitor", "?");
            sqlQueryObject.addInsertField("soggetti_all", "?");
            sqlQueryObject.addInsertField("servizi_all", "?");
            sqlQuery = sqlQueryObject.createSQLInsert();
            stm = connectionDB.prepareStatement(sqlQuery);
            int index = 1;
            stm.setString(index++, login);
            stm.setString(index++, DriverUsersDB.convertToDbValue(user.getPassword()));
            Timestamp dataPassword = DateManager.getTimestamp();
            if (user.getLastUpdatePassword() != null) {
                dataPassword = new Timestamp(user.getLastUpdatePassword().getTime());
            }
            stm.setTimestamp(index++, dataPassword);
            stm.setInt(index++, user.isCheckLastUpdatePassword() ? 1 : 0);
            stm.setString(index++, user.getInterfaceType().toString());
            stm.setInt(index++, user.isPermitInterfaceComplete() ? 1 : 0);
            stm.setString(index++, user.getPermessi().toString());
            stm.setString(index++, user.getProtocolliSupportatiAsString());
            stm.setString(index++, user.getProtocolloSelezionatoPddConsole());
            stm.setString(index++, user.getProtocolloSelezionatoPddMonitor());
            stm.setString(index++, user.getSoggettoSelezionatoPddConsole());
            stm.setString(index++, user.getSoggettoSelezionatoPddMonitor());
            stm.setInt(index++, user.isPermitAllSoggetti() ? 1 : 0);
            stm.setInt(index++, user.isPermitAllServizi() ? 1 : 0);
            stm.executeUpdate();
            stm.close();
            if (user.getStati().size() > 0 || user.getPrecedentiPassword().size() > 0 || user.getSoggetti().size() > 0 || user.getServizi().size() > 0) {
                long idUser = this._getIdUser(connectionDB, login);
                this._addListeUtente(connectionDB, user, idUser);
            }
        }
        catch (Exception qe) {
            throw new DriverUsersDBException(qe.getMessage(), qe);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.connection == null) {
                    connectionDB.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void updateUser(User user) throws DriverUsersDBException {
        Connection connectionDB = null;
        Statement stm = null;
        ResultSet rs = null;
        String sqlQuery = "";
        if (user == null) {
            throw new DriverUsersDBException("[DriverUsersDB::updateUser] Parametro non valido.");
        }
        String login = user.getLogin();
        if (login == null || login.equals("")) {
            throw new DriverUsersDBException("[DriverUsersDB::updateUser] Parametro Login non valido.");
        }
        try {
            connectionDB = this.getConnection();
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            sqlQueryObject.addUpdateTable("users");
            sqlQueryObject.addUpdateField("password", "?");
            if (user.getLastUpdatePassword() != null) {
                sqlQueryObject.addUpdateField("data_password", "?");
            }
            sqlQueryObject.addUpdateField("check_data_password", "?");
            sqlQueryObject.addUpdateField("tipo_interfaccia", "?");
            sqlQueryObject.addUpdateField("interfaccia_completa", "?");
            sqlQueryObject.addUpdateField("permessi", "?");
            sqlQueryObject.addUpdateField("protocolli", "?");
            sqlQueryObject.addUpdateField("protocollo_pddconsole", "?");
            sqlQueryObject.addUpdateField("protocollo_pddmonitor", "?");
            sqlQueryObject.addUpdateField("soggetto_pddconsole", "?");
            sqlQueryObject.addUpdateField("soggetto_pddmonitor", "?");
            sqlQueryObject.addUpdateField("soggetti_all", "?");
            sqlQueryObject.addUpdateField("servizi_all", "?");
            sqlQueryObject.addWhereCondition("login=?");
            sqlQuery = sqlQueryObject.createSQLUpdate();
            stm = connectionDB.prepareStatement(sqlQuery);
            int index = 1;
            stm.setString(index++, DriverUsersDB.convertToDbValue(user.getPassword()));
            if (user.getLastUpdatePassword() != null) {
                stm.setTimestamp(index++, new Timestamp(user.getLastUpdatePassword().getTime()));
            }
            stm.setInt(index++, user.isCheckLastUpdatePassword() ? 1 : 0);
            stm.setString(index++, user.getInterfaceType().toString());
            stm.setInt(index++, user.isPermitInterfaceComplete() ? 1 : 0);
            stm.setString(index++, user.getPermessi().toString());
            stm.setString(index++, user.getProtocolliSupportatiAsString());
            stm.setString(index++, user.getProtocolloSelezionatoPddConsole());
            stm.setString(index++, user.getProtocolloSelezionatoPddMonitor());
            stm.setString(index++, user.getSoggettoSelezionatoPddConsole());
            stm.setString(index++, user.getSoggettoSelezionatoPddMonitor());
            stm.setInt(index++, user.isPermitAllSoggetti() ? 1 : 0);
            stm.setInt(index++, user.isPermitAllServizi() ? 1 : 0);
            stm.setString(index++, user.getLogin());
            stm.executeUpdate();
            stm.close();
            long idUser = this._getIdUser(connectionDB, user);
            this._deleteListeUtente(connectionDB, idUser);
            if (user.getStati().size() > 0 || user.getPrecedentiPassword().size() > 0 || user.getSoggetti().size() > 0 || user.getServizi().size() > 0) {
                this._addListeUtente(connectionDB, user, idUser);
            }
        }
        catch (Exception qe) {
            throw new DriverUsersDBException(qe.getMessage(), qe);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            this.releaseConnection(connectionDB);
        }
    }

    public void deleteUser(User user) throws DriverUsersDBException {
        Connection connectionDB = null;
        Statement stm = null;
        String sqlQuery = "";
        if (user == null) {
            throw new DriverUsersDBException("[DriverUsersDB::deleteUser] Parametro non valido.");
        }
        String login = user.getLogin();
        if (login == null || login.equals("")) {
            throw new DriverUsersDBException("[DriverUsersDB::deleteUser] Parametro Login non valido.");
        }
        try {
            connectionDB = this.getConnection();
            long idUser = this._getIdUser(connectionDB, user);
            this._deleteListeUtente(connectionDB, idUser);
            this.deleteRicercheUtenteEngine(connectionDB, idUser);
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            sqlQueryObject.addDeleteTable("users");
            sqlQueryObject.addWhereCondition("login = ?");
            sqlQuery = sqlQueryObject.createSQLDelete();
            stm = connectionDB.prepareStatement(sqlQuery);
            stm.setString(1, login);
            stm.executeUpdate();
            stm.close();
        }
        catch (Exception qe) {
            throw new DriverUsersDBException(qe.getMessage(), qe);
        }
        finally {
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            this.releaseConnection(connectionDB);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _addListeUtente(Connection connectionDB, User user, long idUser) throws Exception {
        Statement stm = null;
        ResultSet rs = null;
        try {
            int index;
            String sqlQuery;
            int index2;
            String sqlQuery2;
            ISQLQueryObject sqlQueryObject;
            if (user.getStati().size() > 0) {
                for (Stato stato : user.getStati()) {
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
                    sqlQueryObject.addInsertTable("users_stati");
                    sqlQueryObject.addInsertField("id_utente", "?");
                    sqlQueryObject.addInsertField("oggetto", "?");
                    sqlQueryObject.addInsertField("stato", "?");
                    sqlQuery2 = sqlQueryObject.createSQLInsert();
                    stm = connectionDB.prepareStatement(sqlQuery2);
                    index2 = 1;
                    stm.setLong(index2++, idUser);
                    stm.setString(index2++, stato.getOggetto());
                    stm.setString(index2++, stato.getStato());
                    stm.executeUpdate();
                    stm.close();
                }
            }
            if (user.getPrecedentiPassword().size() > 0) {
                for (UserPassword userPassword : user.getPrecedentiPassword()) {
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
                    sqlQueryObject.addInsertTable("users_password");
                    sqlQueryObject.addInsertField("id_utente", "?");
                    sqlQueryObject.addInsertField("password", "?");
                    sqlQueryObject.addInsertField("data_password", "?");
                    sqlQuery2 = sqlQueryObject.createSQLInsert();
                    stm = connectionDB.prepareStatement(sqlQuery2);
                    index2 = 1;
                    stm.setLong(index2++, idUser);
                    stm.setString(index2++, DriverUsersDB.convertToDbValue(userPassword.getPassword()));
                    stm.setTimestamp(index2++, new Timestamp(userPassword.getDatePassword().getTime()));
                    stm.executeUpdate();
                    stm.close();
                }
            }
            if (user.getSoggetti().size() > 0) {
                for (IDSoggetto idSoggetto : user.getSoggetti()) {
                    long idSoggettoLong = DBUtils.getIdSoggetto((String)idSoggetto.getNome(), (String)idSoggetto.getTipo(), (Connection)connectionDB, (String)this.tipoDatabase);
                    if (idSoggettoLong <= 0L) {
                        throw new Exception("Impossibile recuperare id soggetto [" + String.valueOf(idSoggetto) + "]");
                    }
                    ISQLQueryObject sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
                    sqlQueryObject2.addInsertTable("users_soggetti");
                    sqlQueryObject2.addInsertField("id_utente", "?");
                    sqlQueryObject2.addInsertField("id_soggetto", "?");
                    sqlQuery = sqlQueryObject2.createSQLInsert();
                    stm = connectionDB.prepareStatement(sqlQuery);
                    index = 1;
                    stm.setLong(index++, idUser);
                    stm.setLong(index++, idSoggettoLong);
                    stm.executeUpdate();
                    stm.close();
                }
            }
            if (user.getServizi().size() > 0) {
                for (IDServizio idServizio : user.getServizi()) {
                    long idServizioLong = DBUtils.getIdServizio((String)idServizio.getNome(), (String)idServizio.getTipo(), (Integer)idServizio.getVersione(), (String)idServizio.getSoggettoErogatore().getNome(), (String)idServizio.getSoggettoErogatore().getTipo(), (Connection)connectionDB, (String)this.tipoDatabase);
                    if (idServizioLong <= 0L) {
                        throw new Exception("Impossibile recuperare id soggetto [" + String.valueOf(idServizio) + "]");
                    }
                    ISQLQueryObject sqlQueryObject3 = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
                    sqlQueryObject3.addInsertTable("users_servizi");
                    sqlQueryObject3.addInsertField("id_utente", "?");
                    sqlQueryObject3.addInsertField("id_servizio", "?");
                    sqlQuery = sqlQueryObject3.createSQLInsert();
                    stm = connectionDB.prepareStatement(sqlQuery);
                    index = 1;
                    stm.setLong(index++, idUser);
                    stm.setLong(index++, idServizioLong);
                    stm.executeUpdate();
                    stm.close();
                }
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _deleteListeUtente(Connection connectionDB, long idUser) throws Exception {
        Statement stm = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            sqlQueryObject.addDeleteTable("users_stati");
            sqlQueryObject.addWhereCondition("id_utente = ?");
            String sqlQuery = sqlQueryObject.createSQLDelete();
            stm = connectionDB.prepareStatement(sqlQuery);
            stm.setLong(1, idUser);
            stm.executeUpdate();
            stm.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            sqlQueryObject.addDeleteTable("users_password");
            sqlQueryObject.addWhereCondition("id_utente = ?");
            sqlQuery = sqlQueryObject.createSQLDelete();
            stm = connectionDB.prepareStatement(sqlQuery);
            stm.setLong(1, idUser);
            stm.executeUpdate();
            stm.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            sqlQueryObject.addDeleteTable("users_soggetti");
            sqlQueryObject.addWhereCondition("id_utente = ?");
            sqlQuery = sqlQueryObject.createSQLDelete();
            stm = connectionDB.prepareStatement(sqlQuery);
            stm.setLong(1, idUser);
            stm.executeUpdate();
            stm.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            sqlQueryObject.addDeleteTable("users_servizi");
            sqlQueryObject.addWhereCondition("id_utente = ?");
            sqlQuery = sqlQueryObject.createSQLDelete();
            stm = connectionDB.prepareStatement(sqlQuery);
            stm.setLong(1, idUser);
            stm.executeUpdate();
            stm.close();
        }
        finally {
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteRicercheUtenteEngine(Connection connectionDB, long idUser) throws SQLQueryObjectException, SQLException {
        Statement stm = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            sqlQueryObject.addDeleteTable("users_ricerche");
            sqlQueryObject.addWhereCondition("id_utente = ?");
            String sqlQuery = sqlQueryObject.createSQLDelete();
            stm = connectionDB.prepareStatement(sqlQuery);
            stm.setLong(1, idUser);
            stm.executeUpdate();
            stm.close();
        }
        finally {
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private long _getIdUser(Connection connectionDB, User user) throws DriverUsersDBException, SQLQueryObjectException, SQLException {
        if (user == null) {
            throw new DriverUsersDBException("[DriverUsersDB::_getIdUser] Parametro non valido.");
        }
        String login = user.getLogin();
        if (login == null || login.equals("")) {
            throw new DriverUsersDBException("[DriverUsersDB::_getIdUser] Parametro Login non valido.");
        }
        long idUser = -1L;
        idUser = user.getId() == null || user.getId() <= 0L ? this._getIdUser(connectionDB, login) : user.getId().longValue();
        return idUser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long _getIdUser(Connection connectionDB, String login) throws DriverUsersDBException, SQLQueryObjectException, SQLException {
        Statement stm = null;
        ResultSet rs = null;
        String sqlQuery = "";
        if (login == null || login.equals("")) {
            throw new DriverUsersDBException("[DriverUsersDB::_getIdUser] Parametro Login non valido.");
        }
        try {
            long idUser = -1L;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            sqlQueryObject.addFromTable("users");
            sqlQueryObject.addWhereCondition("login = ?");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connectionDB.prepareStatement(sqlQuery);
            stm.setString(1, login);
            rs = stm.executeQuery();
            if (rs.next()) {
                idUser = rs.getLong("id");
            }
            if (idUser <= 0L) {
                throw new DriverUsersDBException("Impossibile recuperare id utente con login [" + login + "]");
            }
            rs.close();
            stm.close();
            long l = idUser;
            return l;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<IDServizio> utentiServiziList(String login, ISearch ricerca) throws DriverUsersDBException {
        String nomeMetodo = "utentiServiziList";
        int idLista = Liste.UTENTI_SERVIZI;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        String filterProtocollo = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroProtocollo");
        String filterProtocolli = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroProtocolli");
        List tipoServiziProtocollo = null;
        try {
            tipoServiziProtocollo = Filtri.convertToTipiServizi((String)filterProtocollo, (String)filterProtocolli);
        }
        catch (Exception e) {
            throw new DriverUsersDBException(e.getMessage(), e);
        }
        String filterDominio = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroDominio");
        PddTipologia pddTipologia = null;
        if (filterDominio != null && !"".equals(filterDominio)) {
            pddTipologia = PddTipologia.toPddTipologia((String)filterDominio);
        }
        this.log.debug("search : " + search);
        this.log.debug("filterProtocollo : " + filterProtocollo);
        this.log.debug("filterProtocolli : " + filterProtocolli);
        this.log.debug("filterDominio : " + filterDominio);
        Connection connectionDB = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<IDServizio> lista = new ArrayList<IDServizio>();
        try {
            connectionDB = this.getConnection();
            ISQLQueryObject sqlQueryObjectSoggetti = null;
            if (!search.equals("")) {
                sqlQueryObjectSoggetti = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
                sqlQueryObjectSoggetti.addFromTable("soggetti");
                sqlQueryObjectSoggetti.addSelectField("soggetti", "tipo_soggetto");
                sqlQueryObjectSoggetti.addSelectField("soggetti", "nome_soggetto");
                sqlQueryObjectSoggetti.setANDLogicOperator(true);
                sqlQueryObjectSoggetti.addWhereCondition("servizi.id_soggetto=soggetti.id");
                sqlQueryObjectSoggetti.addWhereCondition(false, new String[]{sqlQueryObjectSoggetti.getWhereLikeCondition("nome_soggetto", search, true, true)});
            }
            ISQLQueryObject sqlQueryObjectPdd = null;
            if (pddTipologia != null && PddTipologia.ESTERNO.equals((Object)pddTipologia)) {
                ISQLQueryObject sqlQueryObjectExistsPdd = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
                sqlQueryObjectExistsPdd.addSelectField("pdd.nome");
                sqlQueryObjectExistsPdd.addFromTable("pdd");
                sqlQueryObjectExistsPdd.setANDLogicOperator(true);
                sqlQueryObjectExistsPdd.addWhereCondition("pdd.nome=soggetti.server");
                sqlQueryObjectExistsPdd.addWhereCondition("pdd.tipo=?");
                sqlQueryObjectPdd = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
                sqlQueryObjectPdd.setANDLogicOperator(false);
                sqlQueryObjectPdd.addWhereIsNullCondition("soggetti.server");
                sqlQueryObjectPdd.addWhereExistsCondition(false, sqlQueryObjectExistsPdd);
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            sqlQueryObject.addSelectCountField("*", "cont");
            sqlQueryObject.addFromTable("users");
            sqlQueryObject.addFromTable("users_servizi");
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addWhereCondition("users.login = ?");
            sqlQueryObject.addWhereCondition("users_servizi.id_utente = users.id");
            sqlQueryObject.addWhereCondition("users_servizi.id_servizio = servizi.id");
            sqlQueryObject.addWhereCondition("servizi.id_soggetto = soggetti.id");
            if (!search.equals("")) {
                sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("servizi.nome_servizio", search, true, true), sqlQueryObject.getWhereExistsCondition(false, sqlQueryObjectSoggetti)});
            }
            if (tipoServiziProtocollo != null && tipoServiziProtocollo.size() > 0) {
                sqlQueryObject.addWhereINCondition("servizi.tipo_servizio", true, tipoServiziProtocollo.toArray(new String[1]));
            }
            if (pddTipologia != null) {
                if (PddTipologia.ESTERNO.equals((Object)pddTipologia)) {
                    sqlQueryObject.addWhereCondition(sqlQueryObjectPdd.createSQLConditions());
                } else {
                    sqlQueryObject.addFromTable("pdd");
                    sqlQueryObject.addWhereCondition(true, new String[]{"pdd.nome=soggetti.server", "pdd.tipo=?"});
                }
            }
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = connectionDB.prepareStatement(queryString);
            int index = 1;
            stmt.setString(index++, login);
            if (pddTipologia != null) {
                stmt.setString(index++, pddTipologia.toString());
            }
            if ((risultato = stmt.executeQuery()).next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            sqlQueryObject.addSelectField("users_servizi.id_servizio");
            sqlQueryObject.addSelectField("servizi.tipo_servizio");
            sqlQueryObject.addSelectField("servizi.nome_servizio");
            sqlQueryObject.addSelectField("servizi.versione_servizio");
            sqlQueryObject.addSelectField("soggetti.tipo_soggetto");
            sqlQueryObject.addSelectField("soggetti.nome_soggetto");
            sqlQueryObject.addFromTable("users");
            sqlQueryObject.addFromTable("users_servizi");
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addWhereCondition("users.login = ?");
            sqlQueryObject.addWhereCondition("users_servizi.id_utente = users.id");
            sqlQueryObject.addWhereCondition("users_servizi.id_servizio = servizi.id");
            sqlQueryObject.addWhereCondition("servizi.id_soggetto = soggetti.id");
            if (!search.equals("")) {
                sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("servizi.nome_servizio", search, true, true), sqlQueryObject.getWhereExistsCondition(false, sqlQueryObjectSoggetti)});
            }
            if (tipoServiziProtocollo != null && tipoServiziProtocollo.size() > 0) {
                sqlQueryObject.addWhereINCondition("servizi.tipo_servizio", true, tipoServiziProtocollo.toArray(new String[1]));
            }
            if (pddTipologia != null) {
                if (PddTipologia.ESTERNO.equals((Object)pddTipologia)) {
                    sqlQueryObject.addWhereCondition(sqlQueryObjectPdd.createSQLConditions());
                } else {
                    sqlQueryObject.addFromTable("pdd");
                    sqlQueryObject.addWhereCondition(true, new String[]{"pdd.nome=soggetti.server", "pdd.tipo=?"});
                }
            }
            sqlQueryObject.addOrderBy("servizi.nome_servizio");
            sqlQueryObject.addOrderBy("servizi.versione_servizio");
            sqlQueryObject.addOrderBy("soggetti.nome_soggetto");
            sqlQueryObject.addOrderBy("servizi.tipo_servizio");
            sqlQueryObject.addOrderBy("soggetti.tipo_soggetto");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            sqlQueryObject.setANDLogicOperator(true);
            queryString = sqlQueryObject.createSQLQuery();
            stmt = connectionDB.prepareStatement(queryString);
            index = 1;
            stmt.setString(index++, login);
            if (pddTipologia != null) {
                stmt.setString(index++, pddTipologia.toString());
            }
            risultato = stmt.executeQuery();
            JDBCServiceManagerProperties jdbcProperties = new JDBCServiceManagerProperties();
            jdbcProperties.setDatabaseType(this.tipoDatabase);
            jdbcProperties.setShowSql(true);
            JDBCServiceManager manager = new JDBCServiceManager(connectionDB, jdbcProperties, this.log);
            IDBAccordoServizioParteSpecificaServiceSearch serviziSearch = (IDBAccordoServizioParteSpecificaServiceSearch)manager.getAccordoServizioParteSpecificaServiceSearch();
            while (risultato.next()) {
                long id = risultato.getLong("id_servizio");
                AccordoServizioParteSpecifica servizio = (AccordoServizioParteSpecifica)serviziSearch.get(id);
                IDServizio idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(servizio.getTipo(), servizio.getNome(), servizio.getIdErogatore().getTipo(), servizio.getIdErogatore().getNome(), servizio.getVersione().intValue());
                lista.add(idServizio);
            }
            risultato.close();
            ArrayList<IDServizio> arrayList = lista;
            return arrayList;
        }
        catch (Exception qe) {
            throw new DriverUsersDBException("[DriverUsersDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            this.releaseConnection(connectionDB);
        }
    }

    public List<IDSoggetto> utentiSoggettiList(String login, ISearch ricerca) throws DriverUsersDBException {
        String nomeMetodo = "utentiSoggettiList";
        int idLista = Liste.UTENTI_SOGGETTI;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        String filterProtocollo = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroProtocollo");
        String filterProtocolli = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroProtocolli");
        List tipoSoggettiProtocollo = null;
        try {
            tipoSoggettiProtocollo = Filtri.convertToTipiSoggetti((String)filterProtocollo, (String)filterProtocolli);
        }
        catch (Exception e) {
            throw new DriverUsersDBException(e.getMessage(), e);
        }
        String filterDominio = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroDominio");
        PddTipologia pddTipologia = null;
        if (filterDominio != null && !"".equals(filterDominio)) {
            pddTipologia = PddTipologia.toPddTipologia((String)filterDominio);
        }
        this.log.debug("search : " + search);
        this.log.debug("filterProtocollo : " + filterProtocollo);
        this.log.debug("filterProtocolli : " + filterProtocolli);
        this.log.debug("filterDominio : " + filterDominio);
        Connection connectionDB = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<IDSoggetto> lista = new ArrayList<IDSoggetto>();
        try {
            connectionDB = this.getConnection();
            ISQLQueryObject sqlQueryObjectPdd = null;
            if (pddTipologia != null && PddTipologia.ESTERNO.equals((Object)pddTipologia)) {
                ISQLQueryObject sqlQueryObjectExistsPdd = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
                sqlQueryObjectExistsPdd.addSelectField("pdd.nome");
                sqlQueryObjectExistsPdd.addFromTable("pdd");
                sqlQueryObjectExistsPdd.setANDLogicOperator(true);
                sqlQueryObjectExistsPdd.addWhereCondition("pdd.nome=soggetti.server");
                sqlQueryObjectExistsPdd.addWhereCondition("pdd.tipo=?");
                sqlQueryObjectPdd = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
                sqlQueryObjectPdd.setANDLogicOperator(false);
                sqlQueryObjectPdd.addWhereIsNullCondition("soggetti.server");
                sqlQueryObjectPdd.addWhereExistsCondition(false, sqlQueryObjectExistsPdd);
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            sqlQueryObject.addSelectCountField("*", "cont");
            sqlQueryObject.addFromTable("users");
            sqlQueryObject.addFromTable("users_soggetti");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addWhereCondition("users.login = ?");
            sqlQueryObject.addWhereCondition("users_soggetti.id_utente = users.id");
            sqlQueryObject.addWhereCondition("users_soggetti.id_soggetto = soggetti.id");
            if (!search.equals("")) {
                sqlQueryObject.addWhereLikeCondition("soggetti.nome_soggetto", search, true, true);
            }
            if (tipoSoggettiProtocollo != null && tipoSoggettiProtocollo.size() > 0) {
                sqlQueryObject.addWhereINCondition("soggetti.tipo_soggetto", true, tipoSoggettiProtocollo.toArray(new String[1]));
            }
            if (pddTipologia != null) {
                if (PddTipologia.ESTERNO.equals((Object)pddTipologia)) {
                    sqlQueryObject.addWhereCondition(sqlQueryObjectPdd.createSQLConditions());
                } else {
                    sqlQueryObject.addFromTable("pdd");
                    sqlQueryObject.addWhereCondition(true, new String[]{"pdd.nome=soggetti.server", "pdd.tipo=?"});
                }
            }
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = connectionDB.prepareStatement(queryString);
            int index = 1;
            stmt.setString(index++, login);
            if (pddTipologia != null) {
                stmt.setString(index++, pddTipologia.toString());
            }
            if ((risultato = stmt.executeQuery()).next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            sqlQueryObject.addSelectField("users_soggetti.id_soggetto");
            sqlQueryObject.addSelectField("soggetti.nome_soggetto");
            sqlQueryObject.addSelectField("soggetti.tipo_soggetto");
            sqlQueryObject.addFromTable("users");
            sqlQueryObject.addFromTable("users_soggetti");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addWhereCondition("users.login = ?");
            sqlQueryObject.addWhereCondition("users_soggetti.id_utente = users.id");
            sqlQueryObject.addWhereCondition("users_soggetti.id_soggetto = soggetti.id");
            if (!search.equals("")) {
                sqlQueryObject.addWhereLikeCondition("soggetti.nome_soggetto", search, true, true);
            }
            if (tipoSoggettiProtocollo != null && tipoSoggettiProtocollo.size() > 0) {
                sqlQueryObject.addWhereINCondition("soggetti.tipo_soggetto", true, tipoSoggettiProtocollo.toArray(new String[1]));
            }
            if (pddTipologia != null) {
                if (PddTipologia.ESTERNO.equals((Object)pddTipologia)) {
                    sqlQueryObject.addWhereCondition(sqlQueryObjectPdd.createSQLConditions());
                } else {
                    sqlQueryObject.addFromTable("pdd");
                    sqlQueryObject.addWhereCondition(true, new String[]{"pdd.nome=soggetti.server", "pdd.tipo=?"});
                }
            }
            sqlQueryObject.addOrderBy("soggetti.nome_soggetto");
            sqlQueryObject.addOrderBy("soggetti.tipo_soggetto");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            sqlQueryObject.setANDLogicOperator(true);
            queryString = sqlQueryObject.createSQLQuery();
            stmt = connectionDB.prepareStatement(queryString);
            index = 1;
            stmt.setString(index++, login);
            if (pddTipologia != null) {
                stmt.setString(index++, pddTipologia.toString());
            }
            risultato = stmt.executeQuery();
            JDBCServiceManagerProperties jdbcProperties = new JDBCServiceManagerProperties();
            jdbcProperties.setDatabaseType(this.tipoDatabase);
            jdbcProperties.setShowSql(true);
            JDBCServiceManager manager = new JDBCServiceManager(connectionDB, jdbcProperties, this.log);
            IDBSoggettoServiceSearch soggettiSearch = (IDBSoggettoServiceSearch)manager.getSoggettoServiceSearch();
            while (risultato.next()) {
                long id = risultato.getLong("id_soggetto");
                Soggetto soggetto = (Soggetto)soggettiSearch.get(id);
                IDSoggetto idSoggetto = new IDSoggetto(soggetto.getTipoSoggetto(), soggetto.getNomeSoggetto(), soggetto.getIdentificativoPorta());
                lista.add(idSoggetto);
            }
            risultato.close();
            ArrayList<IDSoggetto> arrayList = lista;
            return arrayList;
        }
        catch (Exception qe) {
            throw new DriverUsersDBException("[DriverUsersDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            this.releaseConnection(connectionDB);
        }
    }

    public Stato getStato(String login, String nomeOggetto) throws DriverUsersDBException {
        if (login == null || nomeOggetto == null) {
            throw new DriverUsersDBException("[getStato] Parametri Non Validi");
        }
        Connection connectionDB = null;
        Statement stm = null;
        ResultSet rs = null;
        Stato statoObject = null;
        try {
            connectionDB = this.getConnection();
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            sqlQueryObject.addFromTable("users");
            sqlQueryObject.addFromTable("users_stati");
            sqlQueryObject.addSelectField("users_stati.stato");
            sqlQueryObject.addSelectField("users_stati.oggetto");
            sqlQueryObject.addWhereCondition("users_stati.id_utente = users.id");
            sqlQueryObject.addWhereCondition("users.login = ?");
            sqlQueryObject.addWhereCondition("users_stati.oggetto = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connectionDB.prepareStatement(sqlQuery);
            stm.setString(1, login);
            stm.setString(2, nomeOggetto);
            rs = stm.executeQuery();
            while (rs.next()) {
                String oggetto = rs.getString("oggetto");
                String stato = rs.getString("stato");
                statoObject = new Stato();
                statoObject.setOggetto(oggetto);
                statoObject.setStato(stato);
            }
            rs.close();
            stm.close();
            Stato stato = statoObject;
            return stato;
        }
        catch (SQLException se) {
            throw new DriverUsersDBException("[DriverUsersDB::getStato] SqlException: " + se.getMessage(), se);
        }
        catch (Exception ex) {
            throw new DriverUsersDBException("[DriverUsersDB::getStato] Exception: " + ex.getMessage(), ex);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            this.releaseConnection(connectionDB);
        }
    }

    public void saveProtocolloUtilizzatoPddConsole(String login, String protocollo) throws DriverUsersDBException {
        if (login == null) {
            throw new DriverUsersDBException("[saveProtocolloUtilizzatoPddConsole] Parametri Non Validi");
        }
        Connection connectionDB = null;
        Statement stm = null;
        try {
            connectionDB = this.getConnection();
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            sqlQueryObject.addUpdateTable("users");
            sqlQueryObject.addUpdateField("protocollo_pddconsole", "?");
            sqlQueryObject.addWhereCondition("users.login = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLUpdate();
            stm = connectionDB.prepareStatement(sqlQuery);
            stm.setString(1, protocollo);
            stm.setString(2, login);
            stm.executeUpdate();
            stm.close();
        }
        catch (SQLException se) {
            throw new DriverUsersDBException("[DriverUsersDB::saveProtocolloUtilizzatoPddConsole] SqlException: " + se.getMessage(), se);
        }
        catch (Exception ex) {
            throw new DriverUsersDBException("[DriverUsersDB::saveProtocolloUtilizzatoPddConsole] Exception: " + ex.getMessage(), ex);
        }
        finally {
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            this.releaseConnection(connectionDB);
        }
    }

    public void saveProtocolloUtilizzatoPddMonitor(String login, String protocollo) throws DriverUsersDBException {
        if (login == null) {
            throw new DriverUsersDBException("[saveProtocolloUtilizzatoPddMonitor] Parametri Non Validi");
        }
        Connection connectionDB = null;
        Statement stm = null;
        try {
            connectionDB = this.getConnection();
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            sqlQueryObject.addUpdateTable("users");
            sqlQueryObject.addUpdateField("protocollo_pddmonitor", "?");
            sqlQueryObject.addWhereCondition("users.login = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLUpdate();
            stm = connectionDB.prepareStatement(sqlQuery);
            stm.setString(1, protocollo);
            stm.setString(2, login);
            stm.executeUpdate();
            stm.close();
        }
        catch (SQLException se) {
            throw new DriverUsersDBException("[DriverUsersDB::saveProtocolloUtilizzatoPddMonitor] SqlException: " + se.getMessage(), se);
        }
        catch (Exception ex) {
            throw new DriverUsersDBException("[DriverUsersDB::saveProtocolloUtilizzatoPddMonitor] Exception: " + ex.getMessage(), ex);
        }
        finally {
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            this.releaseConnection(connectionDB);
        }
    }

    public void saveSoggettoUtilizzatoPddConsole(String login, String soggetto) throws DriverUsersDBException {
        if (login == null) {
            throw new DriverUsersDBException("[saveSoggettoUtilizzatoPddConsole] Parametri Non Validi");
        }
        Connection connectionDB = null;
        try {
            connectionDB = this.getConnection();
            this.saveSoggettoUtilizzatoPddConsole(connectionDB, login, soggetto);
        }
        catch (SQLException se) {
            throw new DriverUsersDBException("[DriverUsersDB::saveSoggettoUtilizzatoPddConsole] SqlException: " + se.getMessage(), se);
        }
        catch (Exception ex) {
            throw new DriverUsersDBException("[DriverUsersDB::saveSoggettoUtilizzatoPddConsole] Exception: " + ex.getMessage(), ex);
        }
        finally {
            this.releaseConnection(connectionDB);
        }
    }

    public void saveSoggettoUtilizzatoPddConsole(Connection conParam, String login, String soggetto) throws DriverUsersDBException {
        if (login == null) {
            throw new DriverUsersDBException("[saveSoggettoUtilizzatoPddConsole] Parametri Non Validi");
        }
        Statement stm = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            sqlQueryObject.addUpdateTable("users");
            sqlQueryObject.addUpdateField("soggetto_pddconsole", "?");
            sqlQueryObject.addWhereCondition("users.login = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLUpdate();
            stm = conParam.prepareStatement(sqlQuery);
            stm.setString(1, soggetto);
            stm.setString(2, login);
            stm.executeUpdate();
            stm.close();
        }
        catch (SQLException se) {
            throw new DriverUsersDBException("[DriverUsersDB::saveSoggettoUtilizzatoPddConsole] SqlException: " + se.getMessage(), se);
        }
        catch (Exception ex) {
            throw new DriverUsersDBException("[DriverUsersDB::saveSoggettoUtilizzatoPddConsole] Exception: " + ex.getMessage(), ex);
        }
        finally {
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void saveSoggettoUtilizzatoPddMonitor(String login, String soggetto) throws DriverUsersDBException {
        if (login == null) {
            throw new DriverUsersDBException("[saveSoggettoUtilizzatoPddMonitor] Parametri Non Validi");
        }
        Connection connectionDB = null;
        try {
            connectionDB = this.getConnection();
            this.saveSoggettoUtilizzatoPddMonitor(connectionDB, login, soggetto);
        }
        catch (SQLException se) {
            throw new DriverUsersDBException("[DriverUsersDB::saveSoggettoUtilizzatoPddMonitor] SqlException: " + se.getMessage(), se);
        }
        catch (Exception ex) {
            throw new DriverUsersDBException("[DriverUsersDB::saveSoggettoUtilizzatoPddMonitor] Exception: " + ex.getMessage(), ex);
        }
        finally {
            this.releaseConnection(connectionDB);
        }
    }

    public void saveSoggettoUtilizzatoPddMonitor(Connection conParam, String login, String soggetto) throws DriverUsersDBException {
        if (login == null) {
            throw new DriverUsersDBException("[saveSoggettoUtilizzatoPddMonitor] Parametri Non Validi");
        }
        Statement stm = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            sqlQueryObject.addUpdateTable("users");
            sqlQueryObject.addUpdateField("soggetto_pddmonitor", "?");
            sqlQueryObject.addWhereCondition("users.login = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLUpdate();
            stm = conParam.prepareStatement(sqlQuery);
            stm.setString(1, soggetto);
            stm.setString(2, login);
            stm.executeUpdate();
            stm.close();
        }
        catch (SQLException se) {
            throw new DriverUsersDBException("[DriverUsersDB::saveSoggettoUtilizzatoPddMonitor] SqlException: " + se.getMessage(), se);
        }
        catch (Exception ex) {
            throw new DriverUsersDBException("[DriverUsersDB::saveSoggettoUtilizzatoPddMonitor] Exception: " + ex.getMessage(), ex);
        }
        finally {
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void modificaSoggettoUtilizzatoConsole(String oldSoggetto, String newSoggetto) throws DriverUsersDBException {
        if (oldSoggetto == null) {
            throw new DriverUsersDBException("[modificaSoggettoUtilizzatoConsole] Parametri Non Validi");
        }
        Connection connectionDB = null;
        Statement stm = null;
        ResultSet rs = null;
        try {
            Object login;
            connectionDB = this.getConnection();
            ArrayList<Object> users = new ArrayList<Object>();
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            sqlQueryObject.addFromTable("users");
            sqlQueryObject.addWhereCondition("soggetto_pddconsole=?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connectionDB.prepareStatement(sqlQuery);
            stm.setString(1, oldSoggetto);
            rs = stm.executeQuery();
            while (rs.next()) {
                login = rs.getString("login");
                users.add(login);
            }
            rs.close();
            stm.close();
            if (!users.isEmpty()) {
                for (String string : users) {
                    this.saveSoggettoUtilizzatoPddConsole(connectionDB, string, newSoggetto);
                }
            }
            users = new ArrayList();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            sqlQueryObject.addFromTable("users");
            sqlQueryObject.addWhereCondition("soggetto_pddmonitor=?");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connectionDB.prepareStatement(sqlQuery);
            stm.setString(1, oldSoggetto);
            rs = stm.executeQuery();
            while (rs.next()) {
                login = rs.getString("login");
                users.add(login);
            }
            rs.close();
            stm.close();
            if (!users.isEmpty()) {
                for (String string : users) {
                    this.saveSoggettoUtilizzatoPddMonitor(connectionDB, string, newSoggetto);
                }
            }
        }
        catch (SQLException se) {
            throw new DriverUsersDBException("[DriverUsersDB::saveSoggettoUtilizzatoPddMonitor] SqlException: " + se.getMessage(), se);
        }
        catch (Exception ex) {
            throw new DriverUsersDBException("[DriverUsersDB::saveSoggettoUtilizzatoPddMonitor] Exception: " + ex.getMessage(), ex);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            this.releaseConnection(connectionDB);
        }
    }

    public void saveStato(String login, String nomeOggetto, String statoOggetto) throws DriverUsersDBException {
        if (login == null || nomeOggetto == null) {
            throw new DriverUsersDBException("[saveStato] Parametri Non Validi");
        }
        Connection connectionDB = null;
        Statement stm = null;
        ResultSet rs = null;
        try {
            connectionDB = this.getConnection();
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addFromTable("users");
            sqlQueryObject.addWhereCondition("users.login = ?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connectionDB.prepareStatement(sqlQuery);
            stm.setString(1, login);
            rs = stm.executeQuery();
            Long idUtente = null;
            while (rs.next()) {
                idUtente = rs.getLong("id");
            }
            rs.close();
            stm.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            sqlQueryObject.addUpdateTable("users_stati");
            sqlQueryObject.addUpdateField("stato", "?");
            sqlQueryObject.addWhereCondition("users_stati.id_utente = ?");
            sqlQueryObject.addWhereCondition("users_stati.oggetto = ?");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQuery = sqlQueryObject.createSQLUpdate();
            stm = connectionDB.prepareStatement(sqlQuery);
            stm.setString(1, statoOggetto);
            stm.setLong(2, idUtente);
            stm.setString(3, nomeOggetto);
            int update = stm.executeUpdate();
            stm.close();
            if (update == 0) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
                sqlQueryObject.addInsertTable("users_stati");
                sqlQueryObject.addInsertField("stato", "?");
                sqlQueryObject.addInsertField("id_utente", "?");
                sqlQueryObject.addInsertField("oggetto", "?");
                sqlQuery = sqlQueryObject.createSQLInsert();
                stm = connectionDB.prepareStatement(sqlQuery);
                stm.setString(1, statoOggetto);
                stm.setLong(2, idUtente);
                stm.setString(3, nomeOggetto);
                update = stm.executeUpdate();
                stm.close();
            }
        }
        catch (SQLException se) {
            throw new DriverUsersDBException("[DriverUsersDB::saveStato] SqlException: " + se.getMessage(), se);
        }
        catch (Exception ex) {
            throw new DriverUsersDBException("[DriverUsersDB::saveStato] Exception: " + ex.getMessage(), ex);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            this.releaseConnection(connectionDB);
        }
    }

    public void savePassword(Long idUser, String login, String newPassword, Date dataAggiornamentoPassword) throws DriverUsersDBException {
        this.savePassword(idUser, login, newPassword, dataAggiornamentoPassword, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void savePassword(Long idUser, String login, String password, Date dataAggiornamentoPassword, List<UserPassword> storicoPassword) throws DriverUsersDBException {
        block36: {
            if (login == null || password == null) {
                throw new DriverUsersDBException("[savePassword] Parametri Non Validi");
            }
            Connection connectionDB = null;
            Statement stm = null;
            try {
                connectionDB = this.getConnection();
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
                sqlQueryObject.addUpdateTable("users");
                sqlQueryObject.addUpdateField("password", "?");
                if (dataAggiornamentoPassword != null) {
                    sqlQueryObject.addUpdateField("data_password", "?");
                }
                sqlQueryObject.addWhereCondition("users.login = ?");
                sqlQueryObject.setANDLogicOperator(true);
                String sqlQuery = sqlQueryObject.createSQLUpdate();
                stm = connectionDB.prepareStatement(sqlQuery);
                int index = 1;
                stm.setString(index++, DriverUsersDB.convertToDbValue(password));
                if (dataAggiornamentoPassword != null) {
                    stm.setTimestamp(index++, new Timestamp(dataAggiornamentoPassword.getTime()));
                }
                stm.setString(index++, login);
                stm.executeUpdate();
                stm.close();
                if (storicoPassword == null) break block36;
                try {
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
                    sqlQueryObject.addDeleteTable("users_password");
                    sqlQueryObject.addWhereCondition("id_utente = ?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = connectionDB.prepareStatement(sqlQuery);
                    stm.setLong(1, idUser);
                    stm.executeUpdate();
                    stm.close();
                }
                finally {
                    try {
                        if (stm != null) {
                            stm.close();
                        }
                    }
                    catch (Exception exception) {}
                }
                if (storicoPassword.size() <= 0) break block36;
                stm = null;
                ResultSet rs = null;
                try {
                    for (UserPassword userPassword : storicoPassword) {
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
                        sqlQueryObject.addInsertTable("users_password");
                        sqlQueryObject.addInsertField("id_utente", "?");
                        sqlQueryObject.addInsertField("password", "?");
                        sqlQueryObject.addInsertField("data_password", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = connectionDB.prepareStatement(sqlQuery);
                        index = 1;
                        stm.setLong(index++, idUser);
                        stm.setString(index++, DriverUsersDB.convertToDbValue(userPassword.getPassword()));
                        stm.setTimestamp(index++, new Timestamp(userPassword.getDatePassword().getTime()));
                        stm.executeUpdate();
                        stm.close();
                    }
                }
                finally {
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    catch (Exception exception) {}
                    try {
                        if (stm != null) {
                            stm.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            catch (SQLException se) {
                throw new DriverUsersDBException("[DriverUsersDB::savePassword] SqlException: " + se.getMessage(), se);
            }
            catch (Exception ex) {
                throw new DriverUsersDBException("[DriverUsersDB::savePassword] Exception: " + ex.getMessage(), ex);
            }
            finally {
                try {
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception exception) {}
                this.releaseConnection(connectionDB);
            }
        }
    }

    public UserObjects countUserServizi(String user) throws DriverUsersDBException {
        return this.countUser(user, false);
    }

    public UserObjects countUserCooperazione(String user) throws DriverUsersDBException {
        return this.countUser(user, true);
    }

    public UserObjects countUser(String user, boolean cooperazione) throws DriverUsersDBException {
        if (user == null) {
            throw new DriverUsersDBException("[countUser] Parametri Non Validi");
        }
        Connection connectionDB = null;
        Statement stm = null;
        ResultSet rs = null;
        try {
            connectionDB = this.getConnection();
            ArrayList<String> tables = new ArrayList<String>();
            if (cooperazione) {
                tables.add("accordi_cooperazione");
                tables.add("accordi");
            } else {
                tables.add("pdd");
                tables.add("gruppi");
                tables.add("ruoli");
                tables.add("scope");
                tables.add("soggetti");
                tables.add("accordi");
                tables.add("servizi");
            }
            UserObjects results = new UserObjects();
            for (String table : tables) {
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
                sqlQueryObject.addFromTable(table);
                sqlQueryObject.addSelectCountField("id", "somma");
                sqlQueryObject.addWhereCondition("superuser = ?");
                if ("accordi".equals(table)) {
                    ISQLQueryObject sqlQueryObjectExclude = null;
                    sqlQueryObjectExclude = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
                    sqlQueryObjectExclude.addFromTable("acc_serv_composti");
                    sqlQueryObjectExclude.addSelectField("acc_serv_composti", "id_accordo");
                    sqlQueryObjectExclude.addWhereCondition("acc_serv_composti.id_accordo=accordi.id");
                    if (cooperazione) {
                        sqlQueryObject.addWhereExistsCondition(false, sqlQueryObjectExclude);
                    } else {
                        sqlQueryObject.addWhereExistsCondition(true, sqlQueryObjectExclude);
                    }
                }
                sqlQueryObject.setANDLogicOperator(true);
                String sqlQuery = sqlQueryObject.createSQLQuery();
                stm = connectionDB.prepareStatement(sqlQuery);
                int index = 1;
                stm.setString(index++, user);
                rs = stm.executeQuery();
                int result = rs.getInt("somma");
                rs.close();
                stm.close();
                if ("pdd".equals(table)) {
                    results.pdd = result;
                    continue;
                }
                if ("gruppi".equals(table)) {
                    results.gruppi = result;
                    continue;
                }
                if ("ruoli".equals(table)) {
                    results.ruoli = result;
                    continue;
                }
                if ("scope".equals(table)) {
                    results.scope = result;
                    continue;
                }
                if ("soggetti".equals(table)) {
                    results.soggetti = result;
                    continue;
                }
                if ("accordi".equals(table)) {
                    results.accordi_parte_comune = result;
                    continue;
                }
                if ("accordi_cooperazione".equals(table)) {
                    results.accordi_accoperazione = result;
                    continue;
                }
                if (!"servizi".equals(table)) continue;
                results.accordi_parte_specifica = result;
            }
            UserObjects userObjects = results;
            return userObjects;
        }
        catch (SQLException se) {
            throw new DriverUsersDBException("[DriverUsersDB::countUser] SqlException: " + se.getMessage(), se);
        }
        catch (Exception ex) {
            throw new DriverUsersDBException("[DriverUsersDB::countUser] Exception: " + ex.getMessage(), ex);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            this.releaseConnection(connectionDB);
        }
    }

    public UserObjects updateUserServizi(String oldUser, String newUser) throws DriverUsersDBException {
        return this.updateUser(oldUser, newUser, false);
    }

    public UserObjects updateUserCooperazione(String oldUser, String newUser) throws DriverUsersDBException {
        return this.updateUser(oldUser, newUser, true);
    }

    public UserObjects updateUser(String oldUser, String newUser, boolean cooperazione) throws DriverUsersDBException {
        if (oldUser == null || newUser == null) {
            throw new DriverUsersDBException("[updateUser] Parametri Non Validi");
        }
        Connection connectionDB = null;
        Statement stm = null;
        try {
            connectionDB = this.getConnection();
            ArrayList<String> tables = new ArrayList<String>();
            if (cooperazione) {
                tables.add("accordi_cooperazione");
                tables.add("accordi");
            } else {
                tables.add("pdd");
                tables.add("gruppi");
                tables.add("ruoli");
                tables.add("scope");
                tables.add("soggetti");
                tables.add("accordi");
                tables.add("servizi");
            }
            UserObjects results = new UserObjects();
            for (String table : tables) {
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
                sqlQueryObject.addUpdateTable(table);
                sqlQueryObject.addUpdateField("superuser", "?");
                sqlQueryObject.addWhereCondition("superuser = ?");
                if ("accordi".equals(table)) {
                    ISQLQueryObject sqlQueryObjectExclude = null;
                    sqlQueryObjectExclude = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
                    sqlQueryObjectExclude.addFromTable("acc_serv_composti");
                    sqlQueryObjectExclude.addSelectField("acc_serv_composti", "id_accordo");
                    sqlQueryObjectExclude.addWhereCondition("acc_serv_composti.id_accordo=accordi.id");
                    if (cooperazione) {
                        sqlQueryObject.addWhereExistsCondition(false, sqlQueryObjectExclude);
                    } else {
                        sqlQueryObject.addWhereExistsCondition(true, sqlQueryObjectExclude);
                    }
                }
                sqlQueryObject.setANDLogicOperator(true);
                String sqlQuery = sqlQueryObject.createSQLUpdate();
                stm = connectionDB.prepareStatement(sqlQuery);
                int index = 1;
                stm.setString(index++, newUser);
                stm.setString(index++, oldUser);
                int result = stm.executeUpdate();
                stm.close();
                if ("pdd".equals(table)) {
                    results.pdd = result;
                    continue;
                }
                if ("gruppi".equals(table)) {
                    results.gruppi = result;
                    continue;
                }
                if ("ruoli".equals(table)) {
                    results.ruoli = result;
                    continue;
                }
                if ("scope".equals(table)) {
                    results.scope = result;
                    continue;
                }
                if ("soggetti".equals(table)) {
                    results.soggetti = result;
                    continue;
                }
                if ("accordi".equals(table)) {
                    results.accordi_parte_comune = result;
                    continue;
                }
                if ("accordi_cooperazione".equals(table)) {
                    results.accordi_accoperazione = result;
                    continue;
                }
                if (!"servizi".equals(table)) continue;
                results.accordi_parte_specifica = result;
            }
            UserObjects userObjects = results;
            return userObjects;
        }
        catch (SQLException se) {
            throw new DriverUsersDBException("[DriverUsersDB::updateUser] SqlException: " + se.getMessage(), se);
        }
        catch (Exception ex) {
            throw new DriverUsersDBException("[DriverUsersDB::updateUser] Exception: " + ex.getMessage(), ex);
        }
        finally {
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            this.releaseConnection(connectionDB);
        }
    }

    public List<RicercaUtente> listaRicercheDisponibiliPerUtente(String login, String modulo, String modalitaRicerca, String protocollo, String soggetto) throws DriverUsersDBException {
        if (login == null) {
            throw new DriverUsersDBException("[listaRicerche] Parametri Non Validi");
        }
        Connection connectionDB = null;
        Statement stm = null;
        ResultSet rs = null;
        ArrayList<RicercaUtente> stati = new ArrayList<RicercaUtente>();
        try {
            connectionDB = this.getConnection();
            Long idUtente = null;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            sqlQueryObject.addFromTable("users");
            sqlQueryObject.addSelectField("users.id");
            sqlQueryObject.addWhereCondition("users.login = ?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connectionDB.prepareStatement(sqlQuery);
            int index = 1;
            stm.setString(index++, login);
            rs = stm.executeQuery();
            if (rs.next()) {
                idUtente = rs.getLong("id");
            }
            rs.close();
            stm.close();
            if (idUtente == null) {
                throw new DriverUsersDBException("[DriverUsersDB::cancellaRicerca] User [" + login + "] non esistente.");
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            sqlQueryObject.addFromTable("users_ricerche");
            sqlQueryObject.addSelectField("users_ricerche.id");
            sqlQueryObject.addSelectField("users_ricerche.id_utente");
            sqlQueryObject.addSelectField("users_ricerche.label");
            sqlQueryObject.addSelectField("users_ricerche.modulo");
            sqlQueryObject.addSelectField("users_ricerche.modalita_ricerca");
            sqlQueryObject.addSelectField("users_ricerche.visibilita");
            sqlQueryObject.addSelectField("users_ricerche.ricerca");
            sqlQueryObject.addSelectField("users_ricerche.descrizione");
            sqlQueryObject.addSelectField("users_ricerche.data_creazione");
            sqlQueryObject.addSelectField("users_ricerche.protocollo");
            sqlQueryObject.addSelectField("users_ricerche.soggetto");
            sqlQueryObject.addWhereCondition("users_ricerche.modulo = ?");
            if (modalitaRicerca != null) {
                sqlQueryObject.addWhereCondition("users_ricerche.modalita_ricerca = ?");
            }
            if (protocollo != null) {
                sqlQueryObject.addWhereCondition(false, false, new String[]{"users_ricerche.protocollo = ?", "users_ricerche.protocollo is null"});
            }
            if (soggetto != null) {
                sqlQueryObject.addWhereCondition(false, false, new String[]{"users_ricerche.soggetto = ?", "users_ricerche.soggetto is null"});
            }
            sqlQueryObject.addWhereCondition(false, false, new String[]{"users_ricerche.id_utente = ?", "users_ricerche.id_utente != ? AND users_ricerche.visibilita = ?"});
            sqlQueryObject.addOrderBy("users_ricerche.label");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setANDLogicOperator(true);
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connectionDB.prepareStatement(sqlQuery);
            index = 1;
            stm.setString(index++, modulo);
            if (modalitaRicerca != null) {
                stm.setString(index++, modalitaRicerca);
            }
            if (protocollo != null) {
                stm.setString(index++, protocollo);
            }
            if (soggetto != null) {
                stm.setString(index++, soggetto);
            }
            stm.setLong(index++, idUtente);
            stm.setLong(index++, idUtente);
            stm.setString(index++, "pubblica");
            rs = stm.executeQuery();
            while (rs.next()) {
                RicercaUtente ricercaPersonalizzata = new RicercaUtente();
                ricercaPersonalizzata.setId(rs.getLong("id"));
                ricercaPersonalizzata.setIdUtente(rs.getLong("id_utente"));
                ricercaPersonalizzata.setLabel(rs.getString("label"));
                ricercaPersonalizzata.setModulo(rs.getString("modulo"));
                ricercaPersonalizzata.setModalitaRicerca(rs.getString("modalita_ricerca"));
                ricercaPersonalizzata.setVisibilita(rs.getString("visibilita"));
                ricercaPersonalizzata.setRicerca(rs.getString("ricerca"));
                ricercaPersonalizzata.setDescrizione(rs.getString("descrizione"));
                ricercaPersonalizzata.setDataCreazione(rs.getTimestamp("data_creazione"));
                ricercaPersonalizzata.setProtocollo(rs.getString("protocollo"));
                ricercaPersonalizzata.setSoggetto(rs.getString("soggetto"));
                stati.add(ricercaPersonalizzata);
            }
            rs.close();
            stm.close();
            ArrayList<RicercaUtente> arrayList = stati;
            return arrayList;
        }
        catch (SQLException se) {
            throw new DriverUsersDBException("[DriverUsersDB::listaRicerche] SqlException: " + se.getMessage(), se);
        }
        catch (Exception ex) {
            throw new DriverUsersDBException("[DriverUsersDB::listaRicerche] Exception: " + ex.getMessage(), ex);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            this.releaseConnection(connectionDB);
        }
    }

    public List<RicercaUtente> listaRicerche(String login, Integer offset, Integer limit, String modulo, String modalitaRicerca, String visibilita, String protocollo, String soggetto) throws DriverUsersDBException {
        if (login == null) {
            throw new DriverUsersDBException("[listaRicerche] Parametri Non Validi");
        }
        Connection connectionDB = null;
        Statement stm = null;
        ResultSet rs = null;
        ArrayList<RicercaUtente> stati = new ArrayList<RicercaUtente>();
        try {
            connectionDB = this.getConnection();
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            sqlQueryObject.addFromTable("users");
            sqlQueryObject.addFromTable("users_ricerche");
            sqlQueryObject.addSelectField("users_ricerche.id");
            sqlQueryObject.addSelectField("users_ricerche.id_utente");
            sqlQueryObject.addSelectField("users_ricerche.label");
            sqlQueryObject.addSelectField("users_ricerche.modulo");
            sqlQueryObject.addSelectField("users_ricerche.modalita_ricerca");
            sqlQueryObject.addSelectField("users_ricerche.visibilita");
            sqlQueryObject.addSelectField("users_ricerche.ricerca");
            sqlQueryObject.addSelectField("users_ricerche.descrizione");
            sqlQueryObject.addSelectField("users_ricerche.data_creazione");
            sqlQueryObject.addSelectField("users_ricerche.protocollo");
            sqlQueryObject.addSelectField("users_ricerche.soggetto");
            sqlQueryObject.addWhereCondition("users_ricerche.id_utente = users.id");
            sqlQueryObject.addWhereCondition("users.login = ?");
            if (modulo != null) {
                sqlQueryObject.addWhereCondition("users_ricerche.modulo = ?");
            }
            if (modalitaRicerca != null) {
                sqlQueryObject.addWhereCondition("users_ricerche.modalita_ricerca = ?");
            }
            if (visibilita != null) {
                sqlQueryObject.addWhereCondition("users_ricerche.visibilita = ?");
            }
            if (protocollo != null) {
                sqlQueryObject.addWhereCondition("users_ricerche.protocollo = ?");
            }
            if (soggetto != null) {
                sqlQueryObject.addWhereCondition("users_ricerche.soggetto = ?");
            }
            sqlQueryObject.addOrderBy("users_ricerche.modulo");
            sqlQueryObject.addOrderBy("users_ricerche.label");
            sqlQueryObject.setSortType(true);
            if (limit != null) {
                sqlQueryObject.setLimit(limit.intValue());
            }
            if (offset != null) {
                sqlQueryObject.setOffset(offset.intValue());
            }
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connectionDB.prepareStatement(sqlQuery);
            int index = 1;
            stm.setString(index++, login);
            if (modulo != null) {
                stm.setString(index++, modulo);
            }
            if (modalitaRicerca != null) {
                stm.setString(index++, modalitaRicerca);
            }
            if (visibilita != null) {
                stm.setString(index++, visibilita);
            }
            if (protocollo != null) {
                stm.setString(index++, protocollo);
            }
            if (soggetto != null) {
                stm.setString(index++, soggetto);
            }
            rs = stm.executeQuery();
            while (rs.next()) {
                RicercaUtente ricercaPersonalizzata = new RicercaUtente();
                ricercaPersonalizzata.setId(rs.getLong("id"));
                ricercaPersonalizzata.setIdUtente(rs.getLong("id_utente"));
                ricercaPersonalizzata.setLabel(rs.getString("label"));
                ricercaPersonalizzata.setModulo(rs.getString("modulo"));
                ricercaPersonalizzata.setModalitaRicerca(rs.getString("modalita_ricerca"));
                ricercaPersonalizzata.setVisibilita(rs.getString("visibilita"));
                ricercaPersonalizzata.setRicerca(rs.getString("ricerca"));
                ricercaPersonalizzata.setDescrizione(rs.getString("descrizione"));
                ricercaPersonalizzata.setDataCreazione(rs.getTimestamp("data_creazione"));
                ricercaPersonalizzata.setProtocollo(rs.getString("protocollo"));
                ricercaPersonalizzata.setSoggetto(rs.getString("soggetto"));
                stati.add(ricercaPersonalizzata);
            }
            rs.close();
            stm.close();
            ArrayList<RicercaUtente> arrayList = stati;
            return arrayList;
        }
        catch (SQLException se) {
            throw new DriverUsersDBException("[DriverUsersDB::listaRicerche] SqlException: " + se.getMessage(), se);
        }
        catch (Exception ex) {
            throw new DriverUsersDBException("[DriverUsersDB::listaRicerche] Exception: " + ex.getMessage(), ex);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            this.releaseConnection(connectionDB);
        }
    }

    public RicercaUtente leggiRicerca(long idUtente, long id) throws DriverUsersDBException, RicercaUtenteNotFoundException {
        return this.leggiRicercaEngine(null, idUtente, id, null, null, null, null, false);
    }

    public RicercaUtente leggiRicercaPrivata(String login, String label, String modulo, String modalitaRicerca) throws DriverUsersDBException, RicercaUtenteNotFoundException {
        return this.leggiRicercaEngine(login, null, null, label, modulo, modalitaRicerca, "privata", false);
    }

    public RicercaUtente leggiRicercaPubblica(String label, String modulo, String modalitaRicerca) throws DriverUsersDBException, RicercaUtenteNotFoundException {
        return this.leggiRicercaEngine(null, null, null, label, modulo, modalitaRicerca, "pubblica", true);
    }

    private RicercaUtente leggiRicercaEngine(String login, Long idUtente, Long idRicerca, String label, String modulo, String modalitaRicerca, String visibilita, boolean escludiUtenteCorrente) throws DriverUsersDBException, RicercaUtenteNotFoundException {
        if ((label == null || modulo == null || modalitaRicerca == null) && idRicerca == null) {
            throw new DriverUsersDBException("[leggiRicerca] Parametri Non Validi");
        }
        Connection connectionDB = null;
        Statement stm = null;
        ResultSet rs = null;
        RicercaUtente ricercaPersonalizzata = null;
        try {
            int index;
            String sqlQuery;
            ISQLQueryObject sqlQueryObject;
            connectionDB = this.getConnection();
            if (login != null && idUtente == null) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
                sqlQueryObject.addFromTable("users");
                sqlQueryObject.addSelectField("users.id");
                sqlQueryObject.addWhereCondition("users.login = ?");
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm = connectionDB.prepareStatement(sqlQuery);
                index = 1;
                stm.setString(index++, login);
                rs = stm.executeQuery();
                if (rs.next()) {
                    idUtente = rs.getLong("id");
                }
                rs.close();
                stm.close();
                if (idUtente == null) {
                    throw new DriverUsersDBException("[DriverUsersDB::cancellaRicerca] User [" + login + "] non esistente.");
                }
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            sqlQueryObject.addFromTable("users_ricerche");
            sqlQueryObject.addSelectField("users_ricerche.id");
            sqlQueryObject.addSelectField("users_ricerche.id_utente");
            sqlQueryObject.addSelectField("users_ricerche.label");
            sqlQueryObject.addSelectField("users_ricerche.modulo");
            sqlQueryObject.addSelectField("users_ricerche.modalita_ricerca");
            sqlQueryObject.addSelectField("users_ricerche.visibilita");
            sqlQueryObject.addSelectField("users_ricerche.ricerca");
            sqlQueryObject.addSelectField("users_ricerche.descrizione");
            sqlQueryObject.addSelectField("users_ricerche.data_creazione");
            sqlQueryObject.addSelectField("users_ricerche.protocollo");
            sqlQueryObject.addSelectField("users_ricerche.soggetto");
            if (idUtente != null) {
                if (escludiUtenteCorrente) {
                    sqlQueryObject.addWhereCondition("users_ricerche.id_utente <> ?");
                } else {
                    sqlQueryObject.addWhereCondition("users_ricerche.id_utente = ?");
                }
            }
            if (idRicerca != null) {
                sqlQueryObject.addWhereCondition("users_ricerche.id = ?");
            }
            if (label != null) {
                sqlQueryObject.addWhereCondition("users_ricerche.label = ?");
            }
            if (modulo != null) {
                sqlQueryObject.addWhereCondition("users_ricerche.modulo = ?");
            }
            if (modalitaRicerca != null) {
                sqlQueryObject.addWhereCondition("users_ricerche.modalita_ricerca = ?");
            }
            if (visibilita != null) {
                sqlQueryObject.addWhereCondition("users_ricerche.visibilita = ?");
            }
            sqlQueryObject.setANDLogicOperator(true);
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connectionDB.prepareStatement(sqlQuery);
            index = 1;
            if (idUtente != null) {
                stm.setLong(index++, idUtente);
            }
            if (idRicerca != null) {
                stm.setLong(index++, idRicerca);
            }
            if (label != null) {
                stm.setString(index++, label);
            }
            if (modulo != null) {
                stm.setString(index++, modulo);
            }
            if (modalitaRicerca != null) {
                stm.setString(index++, modalitaRicerca);
            }
            if (visibilita != null) {
                stm.setString(index++, visibilita);
            }
            if ((rs = stm.executeQuery()).next()) {
                ricercaPersonalizzata = new RicercaUtente();
                ricercaPersonalizzata.setId(rs.getLong("id"));
                ricercaPersonalizzata.setIdUtente(rs.getLong("id_utente"));
                ricercaPersonalizzata.setLabel(rs.getString("label"));
                ricercaPersonalizzata.setModulo(rs.getString("modulo"));
                ricercaPersonalizzata.setModalitaRicerca(rs.getString("modalita_ricerca"));
                ricercaPersonalizzata.setVisibilita(rs.getString("visibilita"));
                ricercaPersonalizzata.setRicerca(rs.getString("ricerca"));
                ricercaPersonalizzata.setDescrizione(rs.getString("descrizione"));
                ricercaPersonalizzata.setDataCreazione(rs.getTimestamp("data_creazione"));
                ricercaPersonalizzata.setProtocollo(rs.getString("protocollo"));
                ricercaPersonalizzata.setSoggetto(rs.getString("soggetto"));
            }
            rs.close();
            stm.close();
            if (ricercaPersonalizzata == null) {
                throw new RicercaUtenteNotFoundException("[DriverUsersDB::leggiRicerca] Ricerca [label:" + label + ", modulo: " + modulo + ", modalita' ricerca: " + modalitaRicerca + "] dell'utente [" + login + "] non esistente.");
            }
            RicercaUtente ricercaUtente = ricercaPersonalizzata;
            return ricercaUtente;
        }
        catch (SQLException se) {
            throw new DriverUsersDBException("[DriverUsersDB::leggiRicerca] SqlException: " + se.getMessage(), se);
        }
        catch (RicercaUtenteNotFoundException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new DriverUsersDBException("[DriverUsersDB::leggiRicerca] Exception: " + ex.getMessage(), ex);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            this.releaseConnection(connectionDB);
        }
    }

    public void cancellaRicerche(String login) throws DriverUsersDBException {
        this.cancellaRicercaEngine(login, null);
    }

    public void cancellaRicerca(String login, long id) throws DriverUsersDBException {
        this.cancellaRicercaEngine(login, id);
    }

    private void cancellaRicercaEngine(String login, Long id) throws DriverUsersDBException {
        if (login == null) {
            throw new DriverUsersDBException("[cancellaRicerca] Parametri Non Validi");
        }
        Connection connectionDB = null;
        Statement stm = null;
        ResultSet rs = null;
        try {
            connectionDB = this.getConnection();
            Long idUtente = null;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            sqlQueryObject.addFromTable("users");
            sqlQueryObject.addSelectField("users.id");
            sqlQueryObject.addWhereCondition("users.login = ?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connectionDB.prepareStatement(sqlQuery);
            int index = 1;
            stm.setString(index++, login);
            rs = stm.executeQuery();
            if (rs.next()) {
                idUtente = rs.getLong("id");
            }
            rs.close();
            stm.close();
            if (idUtente == null) {
                throw new DriverUsersDBException("[DriverUsersDB::cancellaRicerca] User [" + login + "] non esistente.");
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            sqlQueryObject.addDeleteTable("users_ricerche");
            sqlQueryObject.addWhereCondition("users_ricerche.id_utente = ?");
            if (id != null) {
                sqlQueryObject.addWhereCondition("users_ricerche.id = ?");
            }
            sqlQueryObject.setANDLogicOperator(true);
            sqlQuery = sqlQueryObject.createSQLDelete();
            stm = connectionDB.prepareStatement(sqlQuery);
            index = 1;
            stm.setLong(index++, idUtente);
            if (id != null) {
                stm.setLong(index++, id);
            }
            int res = stm.executeUpdate();
            rs.close();
            stm.close();
            this.log.debug("Cancellate {} ricerche associate all'utente {}.", (Object)res, (Object)login);
        }
        catch (SQLException se) {
            throw new DriverUsersDBException("[DriverUsersDB::cancellaRicerca] SqlException: " + se.getMessage(), se);
        }
        catch (Exception ex) {
            throw new DriverUsersDBException("[DriverUsersDB::cancellaRicerca] Exception: " + ex.getMessage(), ex);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            this.releaseConnection(connectionDB);
        }
    }

    public int countRicerche(String login, String label, String modulo, String modalitaRicerca, String visibilita, String protocollo, String soggetto) throws DriverUsersDBException {
        if (login == null) {
            throw new DriverUsersDBException("[countStati] Parametri Non Validi");
        }
        Connection connectionDB = null;
        Statement stm = null;
        ResultSet rs = null;
        int count = 0;
        try {
            connectionDB = this.getConnection();
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            sqlQueryObject.addFromTable("users");
            sqlQueryObject.addFromTable("users_ricerche");
            sqlQueryObject.addSelectCountField("*", "cont");
            sqlQueryObject.addWhereCondition("users_ricerche.id_utente = users.id");
            sqlQueryObject.addWhereCondition("users.login = ?");
            if (label != null) {
                sqlQueryObject.addWhereCondition("users_ricerche.label = ?");
            }
            if (modulo != null) {
                sqlQueryObject.addWhereCondition("users_ricerche.modulo = ?");
            }
            if (modalitaRicerca != null) {
                sqlQueryObject.addWhereCondition("users_ricerche.modalita_ricerca = ?");
            }
            if (visibilita != null) {
                sqlQueryObject.addWhereCondition("users_ricerche.visibilita = ?");
            }
            if (protocollo != null) {
                sqlQueryObject.addWhereCondition("users_ricerche.protocollo = ?");
            }
            if (soggetto != null) {
                sqlQueryObject.addWhereCondition("users_ricerche.soggetto = ?");
            }
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connectionDB.prepareStatement(sqlQuery);
            int index = 1;
            stm.setString(index++, login);
            if (label != null) {
                stm.setString(index++, label);
            }
            if (modulo != null) {
                stm.setString(index++, modulo);
            }
            if (modalitaRicerca != null) {
                stm.setString(index++, modalitaRicerca);
            }
            if (visibilita != null) {
                stm.setString(index++, visibilita);
            }
            if (protocollo != null) {
                stm.setString(index++, protocollo);
            }
            if (soggetto != null) {
                stm.setString(index++, soggetto);
            }
            if ((rs = stm.executeQuery()).next()) {
                count = rs.getInt(1);
            }
            rs.close();
            stm.close();
            int n = count;
            return n;
        }
        catch (SQLException se) {
            throw new DriverUsersDBException("[DriverUsersDB::countStati] SqlException: " + se.getMessage(), se);
        }
        catch (Exception ex) {
            throw new DriverUsersDBException("[DriverUsersDB::countStati] Exception: " + ex.getMessage(), ex);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            this.releaseConnection(connectionDB);
        }
    }

    public Long insertRicerca(String login, RicercaUtente ricercaPersonalizzata) throws DriverUsersDBException {
        if (login == null || ricercaPersonalizzata == null) {
            throw new DriverUsersDBException("[salvaRicerca] Parametri Non Validi");
        }
        Connection connectionDB = null;
        Statement stm = null;
        ResultSet rs = null;
        try {
            connectionDB = this.getConnection();
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addFromTable("users");
            sqlQueryObject.addWhereCondition("users.login = ?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connectionDB.prepareStatement(sqlQuery);
            stm.setString(1, login);
            rs = stm.executeQuery();
            Long idUtente = null;
            while (rs.next()) {
                idUtente = rs.getLong("id");
            }
            rs.close();
            stm.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            sqlQueryObject.addInsertTable("users_ricerche");
            sqlQueryObject.addInsertField("id_utente", "?");
            sqlQueryObject.addInsertField("label", "?");
            sqlQueryObject.addInsertField("modulo", "?");
            sqlQueryObject.addInsertField("modalita_ricerca", "?");
            sqlQueryObject.addInsertField("visibilita", "?");
            sqlQueryObject.addInsertField("ricerca", "?");
            sqlQueryObject.addInsertField("descrizione", "?");
            sqlQueryObject.addInsertField("data_creazione", "?");
            sqlQueryObject.addInsertField("protocollo", "?");
            sqlQueryObject.addInsertField("soggetto", "?");
            sqlQuery = sqlQueryObject.createSQLInsert();
            stm = connectionDB.prepareStatement(sqlQuery);
            int index = 1;
            stm.setLong(index++, idUtente);
            stm.setString(index++, ricercaPersonalizzata.getLabel());
            stm.setString(index++, ricercaPersonalizzata.getModulo());
            stm.setString(index++, ricercaPersonalizzata.getModalitaRicerca());
            stm.setString(index++, ricercaPersonalizzata.getVisibilita());
            stm.setString(index++, ricercaPersonalizzata.getRicerca());
            stm.setString(index++, ricercaPersonalizzata.getDescrizione());
            Timestamp dataCreazione = new Timestamp(ricercaPersonalizzata.getDataCreazione().getTime());
            stm.setTimestamp(index++, dataCreazione);
            stm.setString(index++, ricercaPersonalizzata.getProtocollo());
            stm.setString(index++, ricercaPersonalizzata.getSoggetto());
            stm.executeUpdate();
            stm.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            sqlQueryObject.addSelectMaxField("id", "max");
            sqlQueryObject.addFromTable("users_ricerche");
            sqlQueryObject.addWhereCondition("users_ricerche.id_utente = ?");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connectionDB.prepareStatement(sqlQuery);
            index = 1;
            stm.setLong(index++, idUtente);
            rs = stm.executeQuery();
            Long idRicerca = null;
            while (rs.next()) {
                idRicerca = rs.getLong("max");
            }
            rs.close();
            stm.close();
            Long l = idRicerca;
            return l;
        }
        catch (SQLException se) {
            throw new DriverUsersDBException("[DriverUsersDB::salvaRicerca] SqlException: " + se.getMessage(), se);
        }
        catch (Exception ex) {
            throw new DriverUsersDBException("[DriverUsersDB::salvaRicerca] Exception: " + ex.getMessage(), ex);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            this.releaseConnection(connectionDB);
        }
    }

    public void updateRicerca(String login, RicercaUtente ricercaPersonalizzata) throws DriverUsersDBException {
        if (login == null || ricercaPersonalizzata == null) {
            throw new DriverUsersDBException("[updateRicerca] Parametri Non Validi");
        }
        Connection connectionDB = null;
        Statement stm = null;
        ResultSet rs = null;
        try {
            connectionDB = this.getConnection();
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addFromTable("users");
            sqlQueryObject.addWhereCondition("users.login = ?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connectionDB.prepareStatement(sqlQuery);
            stm.setString(1, login);
            rs = stm.executeQuery();
            Long idUtente = null;
            while (rs.next()) {
                idUtente = rs.getLong("id");
            }
            rs.close();
            stm.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            sqlQueryObject.addUpdateTable("users_ricerche");
            sqlQueryObject.addUpdateField("label", "?");
            sqlQueryObject.addUpdateField("visibilita", "?");
            sqlQueryObject.addUpdateField("descrizione", "?");
            sqlQueryObject.addWhereCondition("users_ricerche.id_utente = ?");
            sqlQueryObject.addWhereCondition("users_ricerche.id = ?");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQuery = sqlQueryObject.createSQLUpdate();
            stm = connectionDB.prepareStatement(sqlQuery);
            int index = 1;
            stm.setString(index++, ricercaPersonalizzata.getLabel());
            stm.setString(index++, ricercaPersonalizzata.getVisibilita());
            stm.setString(index++, ricercaPersonalizzata.getDescrizione());
            stm.setLong(index++, idUtente);
            stm.setLong(index++, ricercaPersonalizzata.getId());
            stm.executeUpdate();
            stm.close();
        }
        catch (SQLException se) {
            throw new DriverUsersDBException("[DriverUsersDB::updateRicerca] SqlException: " + se.getMessage(), se);
        }
        catch (Exception ex) {
            throw new DriverUsersDBException("[DriverUsersDB::updateRicerca] Exception: " + ex.getMessage(), ex);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            this.releaseConnection(connectionDB);
        }
    }

    public boolean esisteRicerca(String login, boolean escludiUtenteCorrente, String label, String modulo, String modalitaRicerca, String visibilita) throws DriverUsersDBException {
        return this.esisteRicercaEngine(login, label, modulo, modalitaRicerca, visibilita, null, null, escludiUtenteCorrente, true);
    }

    public boolean esisteRicercaPrivataUtenteCorrente(String login, String label, String modulo, String modalitaRicerca) throws DriverUsersDBException {
        return this.esisteRicercaEngine(login, label, modulo, modalitaRicerca, "privata", null, null, false, true);
    }

    public boolean esisteRicercaPubblicaAltroUtente(String login, String label, String modulo, String modalitaRicerca) throws DriverUsersDBException {
        return this.esisteRicercaEngine(login, label, modulo, modalitaRicerca, "pubblica", null, null, true, true);
    }

    private boolean esisteRicercaEngine(String login, String label, String modulo, String modalitaRicerca, String visibilita, String protocollo, String soggetto, boolean escludiUtenteCorrente, boolean controlloLabelCaseInsensitive) throws DriverUsersDBException {
        Connection connectionDB = null;
        Statement stm = null;
        ResultSet rs = null;
        int count = 0;
        try {
            String sqlQuery;
            ISQLQueryObject sqlQueryObject;
            connectionDB = this.getConnection();
            Long idUtente = null;
            if (login != null) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addFromTable("users");
                sqlQueryObject.addWhereCondition("users.login = ?");
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm = connectionDB.prepareStatement(sqlQuery);
                stm.setString(1, login);
                rs = stm.executeQuery();
                while (rs.next()) {
                    idUtente = rs.getLong("id");
                }
                rs.close();
                stm.close();
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            sqlQueryObject.addFromTable("users_ricerche");
            sqlQueryObject.addSelectCountField("*", "cont");
            if (idUtente != null) {
                if (escludiUtenteCorrente) {
                    sqlQueryObject.addWhereCondition("users_ricerche.id_utente <> ?");
                } else {
                    sqlQueryObject.addWhereCondition("users_ricerche.id_utente = ?");
                }
            }
            if (label != null) {
                if (controlloLabelCaseInsensitive) {
                    sqlQueryObject.addWhereLikeCondition("users_ricerche.label", label, false, true);
                } else {
                    sqlQueryObject.addWhereCondition("users_ricerche.label = ?");
                }
            }
            if (modulo != null) {
                sqlQueryObject.addWhereCondition("users_ricerche.modulo = ?");
            }
            if (modalitaRicerca != null) {
                sqlQueryObject.addWhereCondition("users_ricerche.modalita_ricerca = ?");
            }
            if (visibilita != null) {
                sqlQueryObject.addWhereCondition("users_ricerche.visibilita = ?");
            }
            if (protocollo != null) {
                sqlQueryObject.addWhereCondition("users_ricerche.protocollo = ?");
            }
            if (soggetto != null) {
                sqlQueryObject.addWhereCondition("users_ricerche.soggetto = ?");
            }
            sqlQueryObject.setANDLogicOperator(true);
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connectionDB.prepareStatement(sqlQuery);
            int index = 1;
            if (idUtente != null) {
                stm.setLong(index++, idUtente);
            }
            if (label != null && !controlloLabelCaseInsensitive) {
                stm.setString(index++, label);
            }
            if (modulo != null) {
                stm.setString(index++, modulo);
            }
            if (modalitaRicerca != null) {
                stm.setString(index++, modalitaRicerca);
            }
            if (visibilita != null) {
                stm.setString(index++, visibilita);
            }
            if (protocollo != null) {
                stm.setString(index++, protocollo);
            }
            if (soggetto != null) {
                stm.setString(index++, soggetto);
            }
            if ((rs = stm.executeQuery()).next()) {
                count = rs.getInt(1);
            }
            rs.close();
            stm.close();
            boolean bl = count > 0;
            return bl;
        }
        catch (SQLException se) {
            throw new DriverUsersDBException("[DriverUsersDB::countStati] SqlException: " + se.getMessage(), se);
        }
        catch (Exception ex) {
            throw new DriverUsersDBException("[DriverUsersDB::countStati] Exception: " + ex.getMessage(), ex);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            this.releaseConnection(connectionDB);
        }
    }
}

