/*
 * Decompiled with CFR 0.152.
 */
package org.herasaf.xacml.core.context;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.PropertyException;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.ValidationEventHandler;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import org.herasaf.xacml.core.NotInitializedException;
import org.herasaf.xacml.core.SyntaxException;
import org.herasaf.xacml.core.WritingException;
import org.herasaf.xacml.core.context.impl.ObjectFactory;
import org.herasaf.xacml.core.context.impl.RequestType;
import org.herasaf.xacml.core.utils.DefaultValidationEventHandler;
import org.herasaf.xacml.core.utils.JAXBMarshallerConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;

public class RequestMarshaller {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(RequestMarshaller.class);
    private static JAXBContext CONTEXT;
    private static JAXBMarshallerConfiguration CONFIGURATION;
    private static final ObjectFactory OBJECT_FACTORY;

    public static void setJAXBContext(JAXBContext context) {
        CONTEXT = context;
    }

    public static void setJAXBMarshallerConfiguration(JAXBMarshallerConfiguration configuration) {
        CONFIGURATION = configuration;
    }

    private static Marshaller createMarshaller() throws JAXBException, PropertyException {
        if (CONTEXT == null || CONFIGURATION == null) {
            LOGGER.error("JAXB context and/or configuration not initialized.");
            throw new NotInitializedException("JAXB context and/or configuration not initialized.");
        }
        Marshaller marshaller = CONTEXT.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)CONFIGURATION.isFormattedOutput());
        marshaller.setProperty("jaxb.fragment", (Object)CONFIGURATION.isFragment());
        if (CONFIGURATION.isWriteSchemaLocation()) {
            if ("".equals(CONFIGURATION)) {
                LOGGER.error("SchemaLocation not initialized.");
                throw new NotInitializedException("SchemaLocation not initialized.");
            }
            marshaller.setProperty("jaxb.schemaLocation", (Object)CONFIGURATION.getSchemaLocationAsString());
        }
        if (CONFIGURATION.isValidateWriting()) {
            if (CONFIGURATION.getSchema() == null) {
                LOGGER.error("Schema not initialized.");
                throw new NotInitializedException("Schema not initialized");
            }
            marshaller.setSchema(CONFIGURATION.getSchema());
        }
        if (CONFIGURATION.getValidationEventHandler() == null) {
            marshaller.setEventHandler((ValidationEventHandler)new DefaultValidationEventHandler());
        } else {
            marshaller.setEventHandler(CONFIGURATION.getValidationEventHandler());
        }
        return marshaller;
    }

    private static Unmarshaller createUnmarshaller() throws JAXBException, PropertyException {
        if (CONTEXT == null || CONFIGURATION == null) {
            LOGGER.error("JAXB context and/or configuration not initialized.");
            throw new NotInitializedException("JAXB context and/or configuration not initialized.");
        }
        Unmarshaller unmarshaller = CONTEXT.createUnmarshaller();
        if (CONFIGURATION.isValidateParsing()) {
            if (CONFIGURATION.getSchema() == null) {
                LOGGER.error("Schema not initialized.");
                throw new NotInitializedException("Schema not initialized");
            }
            unmarshaller.setSchema(CONFIGURATION.getSchema());
        }
        if (CONFIGURATION.getValidationEventHandler() == null) {
            unmarshaller.setEventHandler((ValidationEventHandler)new DefaultValidationEventHandler());
        } else {
            unmarshaller.setEventHandler(CONFIGURATION.getValidationEventHandler());
        }
        return unmarshaller;
    }

    public static void marshal(RequestType request, ContentHandler ch) throws WritingException {
        try {
            RequestMarshaller.createMarshaller().marshal(OBJECT_FACTORY.createRequest(request), ch);
        }
        catch (JAXBException e) {
            WritingException we = new WritingException("Unable to write to the content handler.", e);
            LOGGER.error(we.getMessage());
            throw we;
        }
    }

    public static void marshal(RequestType request, File file) throws WritingException {
        try {
            RequestMarshaller.createMarshaller().marshal(OBJECT_FACTORY.createRequest(request), file);
        }
        catch (JAXBException e) {
            WritingException we = new WritingException("Unable to write to the file.", e);
            LOGGER.error(we.getMessage());
            throw we;
        }
    }

    public static void marshal(RequestType request, Result result) throws WritingException {
        try {
            RequestMarshaller.createMarshaller().marshal(OBJECT_FACTORY.createRequest(request), result);
        }
        catch (JAXBException e) {
            WritingException we = new WritingException("Unable to write to the result.", e);
            LOGGER.error(we.getMessage());
            throw we;
        }
    }

    public static void marshal(RequestType request, OutputStream out) throws WritingException {
        try {
            RequestMarshaller.createMarshaller().marshal(OBJECT_FACTORY.createRequest(request), out);
        }
        catch (JAXBException e) {
            WritingException we = new WritingException("Unable to write to the output stream.", e);
            LOGGER.error(we.getMessage());
            throw we;
        }
    }

    public static void marshal(RequestType request, Writer writer) throws WritingException {
        try {
            RequestMarshaller.createMarshaller().marshal(OBJECT_FACTORY.createRequest(request), writer);
        }
        catch (JAXBException e) {
            WritingException we = new WritingException("Unable to write to the writer.", e);
            LOGGER.error(we.getMessage());
            throw we;
        }
    }

    public static void marshal(RequestType request, Node node) throws WritingException {
        try {
            RequestMarshaller.createMarshaller().marshal(OBJECT_FACTORY.createRequest(request), node);
        }
        catch (JAXBException e) {
            WritingException we = new WritingException("Unable to write to the node.", e);
            LOGGER.error(we.getMessage());
            throw we;
        }
    }

    public static void marshal(RequestType request, XMLStreamWriter xmlStreamWriter) throws WritingException {
        try {
            RequestMarshaller.createMarshaller().marshal(OBJECT_FACTORY.createRequest(request), xmlStreamWriter);
        }
        catch (JAXBException e) {
            WritingException we = new WritingException("Unable to write to the xml stream writer.", e);
            LOGGER.error(we.getMessage());
            throw we;
        }
    }

    public static void marshal(RequestType request, XMLEventWriter xmlEventWriter) throws WritingException {
        try {
            RequestMarshaller.createMarshaller().marshal(OBJECT_FACTORY.createRequest(request), xmlEventWriter);
        }
        catch (JAXBException e) {
            WritingException we = new WritingException("Unable to write to the xml event writer.", e);
            LOGGER.error(we.getMessage());
            throw we;
        }
    }

    public static RequestType unmarshal(File file) throws SyntaxException {
        Unmarshaller unmarshaller;
        try {
            unmarshaller = RequestMarshaller.createUnmarshaller();
        }
        catch (PropertyException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        try {
            RequestType rt = (RequestType)((JAXBElement)unmarshaller.unmarshal(file)).getValue();
            return rt;
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the file.", e);
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
        catch (ClassCastException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the file.", e);
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
    }

    public static RequestType unmarshal(InputStream inputStream) throws SyntaxException {
        Unmarshaller unmarshaller;
        try {
            unmarshaller = RequestMarshaller.createUnmarshaller();
        }
        catch (PropertyException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        try {
            RequestType rt = (RequestType)((JAXBElement)unmarshaller.unmarshal(inputStream)).getValue();
            return rt;
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the input stream.", e);
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
        catch (ClassCastException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the input stream.", e);
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
    }

    public static RequestType unmarshal(Reader reader) throws SyntaxException {
        Unmarshaller unmarshaller;
        try {
            unmarshaller = RequestMarshaller.createUnmarshaller();
        }
        catch (PropertyException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        try {
            RequestType rt = (RequestType)((JAXBElement)unmarshaller.unmarshal(reader)).getValue();
            return rt;
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the reader.", e);
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
        catch (ClassCastException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the reader.", e);
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
    }

    public static RequestType unmarshal(URL url) throws SyntaxException {
        Unmarshaller unmarshaller;
        try {
            unmarshaller = RequestMarshaller.createUnmarshaller();
        }
        catch (PropertyException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        try {
            RequestType rt = (RequestType)((JAXBElement)unmarshaller.unmarshal(url)).getValue();
            return rt;
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the url.", e);
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
        catch (ClassCastException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the url.", e);
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
    }

    public static RequestType unmarshal(InputSource inputSource) throws SyntaxException {
        Unmarshaller unmarshaller;
        try {
            unmarshaller = RequestMarshaller.createUnmarshaller();
        }
        catch (PropertyException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        try {
            RequestType rt = (RequestType)((JAXBElement)unmarshaller.unmarshal(inputSource)).getValue();
            return rt;
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the input source.", e);
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
        catch (ClassCastException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the input source.", e);
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
    }

    public static RequestType unmarshal(Node node) throws SyntaxException {
        Unmarshaller unmarshaller;
        try {
            unmarshaller = RequestMarshaller.createUnmarshaller();
        }
        catch (PropertyException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        try {
            RequestType rt = (RequestType)((JAXBElement)unmarshaller.unmarshal(node)).getValue();
            return rt;
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the node.", e);
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
        catch (ClassCastException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the node.", e);
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
    }

    public static RequestType unmarshal(Source source) throws SyntaxException {
        Unmarshaller unmarshaller;
        try {
            unmarshaller = RequestMarshaller.createUnmarshaller();
        }
        catch (PropertyException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        try {
            RequestType rt = (RequestType)((JAXBElement)unmarshaller.unmarshal(source)).getValue();
            return rt;
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the source.", e);
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
        catch (ClassCastException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the source.", e);
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
    }

    public static RequestType unmarshal(XMLStreamReader xmlStreamReader) throws SyntaxException {
        Unmarshaller unmarshaller;
        try {
            unmarshaller = RequestMarshaller.createUnmarshaller();
        }
        catch (PropertyException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        try {
            RequestType rt = (RequestType)((JAXBElement)unmarshaller.unmarshal(xmlStreamReader)).getValue();
            return rt;
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the xml stream reader.", e);
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
        catch (ClassCastException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the xml stream reader.", e);
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
    }

    public static RequestType unmarshal(XMLEventReader xmlEventReader) throws SyntaxException {
        Unmarshaller unmarshaller;
        try {
            unmarshaller = RequestMarshaller.createUnmarshaller();
        }
        catch (PropertyException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        try {
            RequestType rt = (RequestType)((JAXBElement)unmarshaller.unmarshal(xmlEventReader)).getValue();
            return rt;
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the xml event reader.", e);
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
        catch (ClassCastException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the xml event reader.", e);
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
    }

    static {
        OBJECT_FACTORY = new ObjectFactory();
    }
}

