/*
 * Decompiled with CFR 0.152.
 */
package org.herasaf.xacml.core.policy.impl;

import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlElementRefs;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.herasaf.xacml.core.combiningAlgorithm.policy.PolicyCombiningAlgorithm;
import org.herasaf.xacml.core.context.EvaluationContext;
import org.herasaf.xacml.core.converter.EvaluatableIdJAXBTypeAdapter;
import org.herasaf.xacml.core.converter.PolicyCombiningAlgorithmJAXBTypeAdapter;
import org.herasaf.xacml.core.policy.Evaluatable;
import org.herasaf.xacml.core.policy.EvaluatableID;
import org.herasaf.xacml.core.policy.impl.DefaultsType;
import org.herasaf.xacml.core.policy.impl.EffectType;
import org.herasaf.xacml.core.policy.impl.ObligationType;
import org.herasaf.xacml.core.policy.impl.ObligationsType;
import org.herasaf.xacml.core.policy.impl.TargetType;

@XmlRootElement(name="PolicySet", namespace="urn:oasis:names:tc:xacml:2.0:policy:schema:os")
@XmlType(name="PolicySetType", propOrder={"description", "policySetDefaults", "target", "additionalInformation", "obligations"})
public class PolicySetType
implements Evaluatable,
Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="Description")
    private String description;
    @XmlElement(name="PolicySetDefaults")
    private DefaultsType policySetDefaults;
    @XmlElement(name="Target", required=true)
    private TargetType target;
    @XmlElementRefs(value={@XmlElementRef(name="PolicyIdReference", namespace="urn:oasis:names:tc:xacml:2.0:policy:schema:os", type=JAXBElement.class), @XmlElementRef(name="PolicySetIdReference", namespace="urn:oasis:names:tc:xacml:2.0:policy:schema:os", type=JAXBElement.class), @XmlElementRef(name="PolicySetCombinerParameters", namespace="urn:oasis:names:tc:xacml:2.0:policy:schema:os", type=JAXBElement.class), @XmlElementRef(name="CombinerParameters", namespace="urn:oasis:names:tc:xacml:2.0:policy:schema:os", type=JAXBElement.class), @XmlElementRef(name="PolicySet", namespace="urn:oasis:names:tc:xacml:2.0:policy:schema:os", type=JAXBElement.class), @XmlElementRef(name="PolicyCombinerParameters", namespace="urn:oasis:names:tc:xacml:2.0:policy:schema:os", type=JAXBElement.class), @XmlElementRef(name="Policy", namespace="urn:oasis:names:tc:xacml:2.0:policy:schema:os", type=JAXBElement.class)})
    private List<JAXBElement<?>> additionalInformation;
    @XmlElement(name="Obligations")
    private ObligationsType obligations;
    @XmlAttribute(name="PolicySetId", required=true)
    @XmlSchemaType(name="anyURI")
    @XmlJavaTypeAdapter(value=EvaluatableIdJAXBTypeAdapter.class)
    private EvaluatableID policySetId;
    @XmlAttribute(name="Version")
    private String version;
    @XmlAttribute(name="PolicyCombiningAlgId", required=true)
    @XmlJavaTypeAdapter(value=PolicyCombiningAlgorithmJAXBTypeAdapter.class)
    @XmlSchemaType(name="anyURI")
    private PolicyCombiningAlgorithm policyCombiningAlg;
    @XmlTransient
    private boolean hasObligations;

    public PolicySetType() {
        this.setHasObligations(true);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public DefaultsType getPolicySetDefaults() {
        return this.policySetDefaults;
    }

    public void setPolicySetDefaults(DefaultsType value) {
        this.policySetDefaults = value;
    }

    @Override
    public TargetType getTarget() {
        return this.target;
    }

    public void setTarget(TargetType value) {
        this.target = value;
    }

    public List<JAXBElement<?>> getAdditionalInformation() {
        if (this.additionalInformation == null) {
            this.additionalInformation = new ArrayList();
        }
        return this.additionalInformation;
    }

    public ObligationsType getObligations() {
        return this.obligations;
    }

    public void setObligations(ObligationsType value) {
        this.obligations = value;
    }

    public EvaluatableID getPolicySetId() {
        return this.policySetId;
    }

    public void setPolicySetId(EvaluatableID value) {
        this.policySetId = value;
    }

    public String getVersion() {
        if (this.version == null) {
            return "1.0";
        }
        return this.version;
    }

    public void setVersion(String value) {
        this.version = value;
    }

    @Override
    public PolicyCombiningAlgorithm getCombiningAlg() {
        return this.policyCombiningAlg;
    }

    public void setCombiningAlg(PolicyCombiningAlgorithm value) {
        this.policyCombiningAlg = value;
    }

    public List<Evaluatable> getOrderedEvaluatables(EvaluationContext evaluationContext) {
        ArrayList<Evaluatable> evals = new ArrayList<Evaluatable>();
        for (int i = 0; i < this.getAdditionalInformation().size(); ++i) {
            JAXBElement<?> jaxbElem = this.getAdditionalInformation().get(i);
            evals.add((Evaluatable)jaxbElem.getValue());
        }
        return evals;
    }

    public List<Evaluatable> getUnorderedEvaluatables(EvaluationContext evaluationContext) {
        return this.getOrderedEvaluatables(evaluationContext);
    }

    @Override
    public EvaluatableID getId() {
        return this.getPolicySetId();
    }

    @Override
    public String getEvalutableVersion() {
        return this.getVersion();
    }

    public void setHasObligations(boolean value) {
        this.hasObligations = value;
    }

    @Override
    public boolean hasObligations() {
        return this.hasObligations;
    }

    @Override
    public List<ObligationType> getContainedObligations(EffectType effect) {
        ArrayList<ObligationType> result = new ArrayList<ObligationType>();
        if (this.obligations != null) {
            List<ObligationType> oblis = this.obligations.getObligations();
            for (int i = 0; i < oblis.size(); ++i) {
                ObligationType obli = oblis.get(i);
                if (obli.getFulfillOn() != effect) continue;
                result.add(obli);
            }
        }
        return result;
    }
}

