/*
 * Decompiled with CFR 0.152.
 */
package org.herasaf.xacml.core.types;

import java.time.Duration;
import java.time.format.DateTimeParseException;
import java.util.Objects;

public class DayTimeDuration
implements Comparable<DayTimeDuration> {
    private Duration duration;
    private String durationValue;
    private boolean negative = false;

    public DayTimeDuration(String durationString) {
        try {
            String negationParsedValue = this.durationValue = durationString.trim();
            if (negationParsedValue.startsWith("-")) {
                this.negative = true;
                negationParsedValue = durationString.substring(1);
            }
            if (negationParsedValue.contains("-")) {
                throw new IllegalArgumentException("Negation only permitted for the whole value, not at each single place.");
            }
            this.duration = Duration.parse(negationParsedValue);
        }
        catch (DateTimeParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String toString() {
        return this.durationValue;
    }

    @Override
    public int compareTo(DayTimeDuration o) {
        Duration compareDuration = o.getDuration();
        return this.duration.compareTo(compareDuration);
    }

    public int hashCode() {
        return Objects.hash(this.duration, this.negative);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DayTimeDuration other = (DayTimeDuration)obj;
        if (!Objects.equals(this.duration, other.duration)) {
            return false;
        }
        return this.negative == other.negative;
    }

    protected Duration getDuration() {
        return this.duration;
    }
}

