/*
 * Decompiled with CFR 0.152.
 */
package org.herasaf.xacml.core.types;

public class RFC822Name {
    private String value;

    public RFC822Name(String value) {
        String[] parts = value.split("@");
        if (parts.length != 2) {
            throw new IllegalArgumentException("Invalid RFC822Name: " + value);
        }
        this.value = parts[0] + "@" + parts[1].toLowerCase();
    }

    public String toString() {
        return this.value;
    }

    public boolean match(String value) {
        if (value.contains("@")) {
            String[] compValue = value.split("@");
            String[] thisValue = this.value.split("@");
            if (compValue.length != 2) {
                return false;
            }
            if (!compValue[0].equals(thisValue[0])) {
                return false;
            }
            return thisValue[1].equalsIgnoreCase(compValue[1]);
        }
        if (value.charAt(0) == '.') {
            String[] thisValue;
            String[] compValue = value.split("\\.");
            if (compValue.length > (thisValue = this.value.split("@")[1].split("\\.")).length) {
                return false;
            }
            for (int i = 0; i < compValue.length - 1; ++i) {
                if (compValue[compValue.length - 1 - i].equalsIgnoreCase(thisValue[thisValue.length - 1 - i])) continue;
                return false;
            }
            return true;
        }
        return this.value.split("@")[1].equalsIgnoreCase(value);
    }

    public boolean equals(Object obj) {
        if (obj instanceof RFC822Name) {
            RFC822Name object = (RFC822Name)obj;
            return object.value.equals(this.value);
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

