/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.spcoop.builder;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.spcoop.builder.SPCoopImbustamento;

public class SPCoopStaticCounter {
    private static Map<String, SPCoopStaticCounter> mapCounter = new HashMap<String, SPCoopStaticCounter>();
    private String identificativo;
    private int serialCounter;
    private Date lastDate;
    private String formatLastDate;

    private static synchronized void initCounter(Date now, String formatLastDate, String key) {
        if (!mapCounter.containsKey(key)) {
            mapCounter.put(key, new SPCoopStaticCounter(now, formatLastDate, key));
        }
    }

    public static int getNextSerialCounter(Date now, String formatLastDate, String codAmm, String idPdd) throws ProtocolException {
        String key = codAmm + "_" + idPdd;
        if (!mapCounter.containsKey(key)) {
            SPCoopStaticCounter.initCounter(now, formatLastDate, key);
        }
        return mapCounter.get(key).getNextSerialCounter(now, formatLastDate);
    }

    public SPCoopStaticCounter(Date now, String formatLastDate, String identificativo) {
        this.identificativo = identificativo;
        this.serialCounter = 0;
        this.lastDate = now;
        this.formatLastDate = formatLastDate;
    }

    public synchronized int getNextSerialCounter(Date now, String formatNow) throws ProtocolException {
        if (!this.formatLastDate.equals(formatNow)) {
            this.serialCounter = 0;
            this.lastDate = now;
            this.formatLastDate = formatNow;
        }
        if (this.serialCounter + 1 > SPCoopImbustamento.maxSeriale) {
            throw new ProtocolException("Numero massimo del seriale (" + SPCoopImbustamento.maxSeriale + ") associabile all'identificato nel minuto raggiunto");
        }
        ++this.serialCounter;
        return this.serialCounter;
    }
}

