/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.monitor.engine.alarm;

import org.openspcoop2.core.allarmi.constants.StatoAllarme;
import org.openspcoop2.core.allarmi.utils.AllarmiConverterUtils;
import org.openspcoop2.core.plugins.constants.TipoPlugin;
import org.openspcoop2.monitor.engine.alarm.AlarmEngineConfig;
import org.openspcoop2.monitor.engine.alarm.AlarmImpl;
import org.openspcoop2.monitor.engine.alarm.AlarmLogger;
import org.openspcoop2.monitor.engine.alarm.AlarmThreadStatus;
import org.openspcoop2.monitor.engine.dynamic.DynamicFactory;
import org.openspcoop2.monitor.engine.dynamic.IDynamicLoader;
import org.openspcoop2.monitor.sdk.alarm.IAlarm;
import org.openspcoop2.monitor.sdk.constants.AlarmStateValues;
import org.openspcoop2.monitor.sdk.exceptions.AlarmException;
import org.openspcoop2.monitor.sdk.plugins.IAlarmProcessing;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.id.IDUtilities;
import org.slf4j.Logger;

public class AlarmThread
implements Runnable {
    private volatile int periodMillis;
    private String tipo;
    private String classname;
    private IAlarm alarm;
    private Logger _log;
    private AlarmEngineConfig alarmEngineConfig;
    private String threadName;
    private AlarmThreadStatus threadStatus = null;
    private volatile boolean terminated = false;
    private volatile boolean forceNewCheck = false;
    private AlarmLogger alarmLogger;

    public boolean isTerminated() {
        return this.terminated;
    }

    public void setStop(boolean stop) {
        this.threadStatus.setStop(stop);
    }

    public void forceNewCheck() {
        this.forceNewCheck = true;
    }

    public AlarmThread(Logger log, String tipo, String classname, IAlarm alarm, AlarmEngineConfig alarmEngineConfig) throws AlarmException {
        if (tipo == null) {
            throw new AlarmException("parametro tipo NULL passato al thread");
        }
        if (classname == null) {
            throw new AlarmException("parametro classname NULL passato al thread");
        }
        if (alarm == null) {
            throw new AlarmException("parametro alarm NULL passato al thread");
        }
        this.tipo = tipo;
        this.classname = classname;
        this.alarm = alarm;
        this._log = log;
        this.alarmEngineConfig = alarmEngineConfig;
        this.threadName = "T_" + IDUtilities.getUniqueSerialNumber((String)"newAlarmThread") + "_" + DateManager.getTimeMillis();
        ((AlarmImpl)this.alarm).setThreadName(this.threadName);
        this.threadStatus = new AlarmThreadStatus();
        ((AlarmImpl)this.alarm).setAlarmThreadStatus(this.threadStatus);
        this.alarmLogger = (AlarmLogger)alarm.getLogger();
    }

    public void updateState(AlarmStateValues alarmStatus) {
        this.alarm.getStatus().setStatus(alarmStatus);
        switch (alarmStatus) {
            case OK: {
                this.alarm.getConfigAllarme().setStato(Integer.valueOf(AllarmiConverterUtils.toIntegerValue((StatoAllarme)StatoAllarme.OK)));
                break;
            }
            case WARNING: {
                this.alarm.getConfigAllarme().setStato(Integer.valueOf(AllarmiConverterUtils.toIntegerValue((StatoAllarme)StatoAllarme.WARNING)));
                break;
            }
            case ERROR: {
                this.alarm.getConfigAllarme().setStato(Integer.valueOf(AllarmiConverterUtils.toIntegerValue((StatoAllarme)StatoAllarme.ERROR)));
            }
        }
    }

    public void updateAcknowledged(boolean acknoledgement) {
        if (acknoledgement) {
            this.alarm.getConfigAllarme().setAcknowledged(Integer.valueOf(1));
        } else {
            this.alarm.getConfigAllarme().setAcknowledged(Integer.valueOf(0));
        }
    }

    public void setPeriodByDays(int days) {
        this.periodMillis = days * 24 * 60 * 60 * 1000;
    }

    public void setPeriodByHours(int hours) {
        this.periodMillis = hours * 60 * 60 * 1000;
    }

    public void setPeriodByMinutes(int minutes) {
        this.periodMillis = minutes * 60 * 1000;
    }

    public void setPeriodBySeconds(int seconds) {
        this.periodMillis = seconds * 1000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.alarmLogger.debug("Thread avviato ...");
            while (!this.threadStatus.isStop()) {
                try {
                    this.alarmLogger.info("Verifica stato in corso ...");
                    TipoPlugin tipoPlugin = TipoPlugin.ALLARME;
                    IDynamicLoader cAllarme = DynamicFactory.getInstance().newDynamicLoader(tipoPlugin, this.tipo, this.classname, this._log);
                    IAlarmProcessing alarmProc = (IAlarmProcessing)cAllarme.newInstance();
                    this.alarmLogger.debug("Invocazione plugin '" + this.tipo + "' ...");
                    alarmProc.check(this.alarm);
                    this.alarmLogger.debug("Invocazione plugin '" + this.tipo + "' terminato");
                }
                catch (Exception e) {
                    this.alarmLogger.error("Errore inatteso emerso durante la verifica dello stato: " + e.getMessage(), e);
                }
                int timeSleep = 500;
                this.alarmLogger.debug("Sleep " + this.periodMillis + "ms ...");
                for (int sleep = 0; sleep < this.periodMillis && !this.threadStatus.isStop(); sleep += timeSleep) {
                    Utilities.sleep((long)timeSleep);
                    if (!this.forceNewCheck) continue;
                }
                if (this.forceNewCheck) {
                    this.alarmLogger.debug("Sleep terminata prematuramente; \u00e8 stato richiesto un nuovo controllo senza attendere il normale intervallo temporale");
                    this.forceNewCheck = false;
                    continue;
                }
                this.alarmLogger.debug("Sleep " + this.periodMillis + "ms terminato");
            }
            this.alarmLogger.debug("Thread terminato");
        }
        finally {
            this.terminated = true;
        }
    }

    public String getStatoAllarme() {
        return this.alarmLogger.getStatoAllarme();
    }
}

