/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.monitor.engine.alarm.wrapper;

import java.util.ArrayList;
import org.openspcoop2.core.allarmi.Allarme;
import org.openspcoop2.core.allarmi.constants.RuoloPorta;
import org.openspcoop2.core.allarmi.constants.TipoAllarme;
import org.openspcoop2.core.plugins.Plugin;
import org.openspcoop2.core.plugins.constants.TipoPlugin;
import org.openspcoop2.monitor.engine.dynamic.DynamicFactory;
import org.openspcoop2.monitor.engine.dynamic.IDynamicLoader;
import org.openspcoop2.monitor.sdk.plugins.IAlarmProcessing;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.beans.BeanUtils;
import org.openspcoop2.utils.beans.BlackListElement;
import org.slf4j.Logger;

public class ConfigurazioneAllarmeBean
extends Allarme {
    private static final long serialVersionUID = 1L;
    private Plugin plugin;
    private String dettaglioAPI = null;
    private String dettaglioFruitore = null;
    private String dettaglioErogatore = null;
    private static final int LIMIT_NOME = 80;
    private static final int LIMIT = 100;
    private Boolean manuallyUpdateState = null;
    private Boolean manuallyAckCriteria = null;
    private boolean existsAlmostOneManuallyUpdateState = true;
    private boolean existsAlmostOneManuallyAckCriteria = true;

    public void setPlugin(Plugin plugin) {
        this.plugin = plugin;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public ConfigurazioneAllarmeBean() {
    }

    public ConfigurazioneAllarmeBean(Allarme allarme, Plugin plugin) {
        ArrayList<BlackListElement> metodiEsclusi = new ArrayList<BlackListElement>(0);
        metodiEsclusi.add(new BlackListElement("setPlugin", new Class[]{Plugin.class}));
        metodiEsclusi.add(new BlackListElement("setDettaglioAPI", new Class[]{String.class}));
        metodiEsclusi.add(new BlackListElement("setDettaglioFruitore", new Class[]{String.class}));
        metodiEsclusi.add(new BlackListElement("setDettaglioErogatore", new Class[]{String.class}));
        metodiEsclusi.add(new BlackListElement("setExistsAlmostOneManuallyUpdateState", new Class[]{Boolean.TYPE}));
        metodiEsclusi.add(new BlackListElement("setExistsAlmostOneManuallyAckCriteria", new Class[]{Boolean.TYPE}));
        BeanUtils.copy((Object)((Object)this), (Object)allarme, metodiEsclusi);
        this.plugin = plugin;
    }

    public String getNomeAbbr() {
        String tmp = this.getNome();
        if (tmp != null && tmp.length() >= 80) {
            return tmp.substring(0, 77) + "...";
        }
        return tmp;
    }

    public String getDettaglioStatoAbbr() {
        String tmp = this.getDettaglioStato();
        if (tmp != null && tmp.length() >= 100) {
            return tmp.substring(0, 97) + "...";
        }
        return tmp;
    }

    public String getDettaglioStatoHtmlEscaped() {
        String tmp = this.getDettaglioStato();
        if (tmp != null) {
            while (tmp.contains("\n")) {
                tmp = tmp.replace("\n", "<BR/>");
            }
        }
        return tmp;
    }

    public String getDescrizioneAbbr() {
        String tmp = this.getDescrizione();
        if (tmp != null && tmp.length() >= 100) {
            return tmp.substring(0, 97) + "...";
        }
        return tmp;
    }

    public String getDettaglioAPI() {
        if (this.dettaglioAPI == null) {
            this.dettaglioAPI = "-";
        }
        return this.dettaglioAPI;
    }

    public void setDettaglioAPI(String dettaglioAPI) {
        this.dettaglioAPI = dettaglioAPI;
    }

    public boolean isRuoloPortaApplicativa() {
        boolean applicativa = false;
        if (this.getFiltro() != null && this.getFiltro().getRuoloPorta() != null && RuoloPorta.APPLICATIVA.equals((Object)this.getFiltro().getRuoloPorta())) {
            applicativa = this.getFiltro().getNomePorta() != null;
        }
        return applicativa;
    }

    public boolean isRuoloPortaDelegata() {
        boolean delegata = false;
        if (this.getFiltro() != null && this.getFiltro().getRuoloPorta() != null && RuoloPorta.DELEGATA.equals((Object)this.getFiltro().getRuoloPorta())) {
            delegata = this.getFiltro().getNomePorta() != null;
        }
        return delegata;
    }

    public boolean isAllarmeConfigurazione() {
        return !this.isRuoloPortaDelegata() && !this.isRuoloPortaApplicativa();
    }

    public String getDettaglioFruitore() {
        return this.dettaglioFruitore;
    }

    public void setDettaglioFruitore(String dettaglioFruitore) {
        this.dettaglioFruitore = dettaglioFruitore;
    }

    public String getDettaglioErogatore() {
        return this.dettaglioErogatore;
    }

    public void setDettaglioErogatore(String dettaglioErogatore) {
        this.dettaglioErogatore = dettaglioErogatore;
    }

    public boolean isModalitaAttiva() {
        boolean attivo = TipoAllarme.ATTIVO.equals((Object)this.getTipoAllarme());
        return attivo;
    }

    public boolean isManuallyUpdateState() {
        if (this.manuallyUpdateState == null) {
            Logger log = LoggerWrapperFactory.getLogger(ConfigurazioneAllarmeBean.class);
            try {
                IDynamicLoader dl = DynamicFactory.getInstance().newDynamicLoader(TipoPlugin.ALLARME, this.plugin.getTipo(), this.plugin.getClassName(), log);
                IAlarmProcessing alarm = (IAlarmProcessing)dl.newInstance();
                this.manuallyUpdateState = alarm.isManuallyUpdateState();
            }
            catch (Throwable t) {
                log.error(t.getMessage(), t);
                this.manuallyUpdateState = false;
            }
        }
        return this.manuallyUpdateState;
    }

    public boolean isManuallyAckCriteria() {
        if (this.manuallyAckCriteria == null) {
            Logger log = LoggerWrapperFactory.getLogger(ConfigurazioneAllarmeBean.class);
            try {
                IDynamicLoader dl = DynamicFactory.getInstance().newDynamicLoader(TipoPlugin.ALLARME, this.plugin.getTipo(), this.plugin.getClassName(), log);
                IAlarmProcessing alarm = (IAlarmProcessing)dl.newInstance();
                this.manuallyAckCriteria = alarm.isManuallyAckCriteria();
            }
            catch (Throwable t) {
                log.error(t.getMessage(), t);
                this.manuallyAckCriteria = false;
            }
        }
        return this.manuallyAckCriteria;
    }

    public void setExistsAlmostOneManuallyUpdateState(boolean existsAlmostOneManuallyUpdateState) {
        this.existsAlmostOneManuallyUpdateState = existsAlmostOneManuallyUpdateState;
    }

    public boolean isExistsAlmostOneManuallyUpdateState() {
        return this.existsAlmostOneManuallyUpdateState;
    }

    public void setExistsAlmostOneManuallyAckCriteria(boolean existsAlmostOneManuallyAckCriteria) {
        this.existsAlmostOneManuallyAckCriteria = existsAlmostOneManuallyAckCriteria;
    }

    public boolean isExistsAlmostOneManuallyAckCriteria() {
        return this.existsAlmostOneManuallyAckCriteria;
    }
}

