/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.monitor.engine.condition;

import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.plugins.utils.FilterUtils;
import org.openspcoop2.core.statistiche.StatisticaGiornaliera;
import org.openspcoop2.core.statistiche.StatisticaMensile;
import org.openspcoop2.core.statistiche.StatisticaOraria;
import org.openspcoop2.core.statistiche.StatisticaSettimanale;
import org.openspcoop2.core.statistiche.dao.jdbc.converter.StatisticaGiornalieraFieldConverter;
import org.openspcoop2.core.statistiche.dao.jdbc.converter.StatisticaMensileFieldConverter;
import org.openspcoop2.core.statistiche.dao.jdbc.converter.StatisticaOrariaFieldConverter;
import org.openspcoop2.core.statistiche.dao.jdbc.converter.StatisticaSettimanaleFieldConverter;
import org.openspcoop2.core.statistiche.model.StatisticaContenutiModel;
import org.openspcoop2.core.statistiche.model.StatisticaModel;
import org.openspcoop2.generic_project.beans.AliasTableComplexField;
import org.openspcoop2.generic_project.beans.ComplexField;
import org.openspcoop2.generic_project.beans.IAliasTableField;
import org.openspcoop2.generic_project.beans.IField;
import org.openspcoop2.generic_project.dao.jdbc.JDBCExpression;
import org.openspcoop2.generic_project.expression.IExpression;
import org.openspcoop2.generic_project.expression.impl.sql.ISQLFieldConverter;
import org.openspcoop2.monitor.engine.condition.FilterImpl;
import org.openspcoop2.monitor.sdk.condition.IStatisticFilter;
import org.openspcoop2.monitor.sdk.constants.StatisticType;
import org.openspcoop2.monitor.sdk.exceptions.SearchException;
import org.openspcoop2.monitor.sdk.statistic.StatisticFilterName;
import org.openspcoop2.utils.TipiDatabase;

public class FilterStatisticRepositoryImpl
extends FilterImpl {
    private StatisticType statisticType;
    private StatisticaModel model;
    private StatisticaContenutiModel contenutiModel;

    public FilterStatisticRepositoryImpl(TipiDatabase databaseType, StatisticType statisticType) throws SearchException {
        super(FilterStatisticRepositoryImpl.newExpression(databaseType, statisticType), databaseType, FilterStatisticRepositoryImpl.newFieldConverter(databaseType, statisticType));
        this.statisticType = statisticType;
        switch (this.statisticType) {
            case ORARIA: {
                this.model = StatisticaOraria.model().STATISTICA_BASE;
                this.contenutiModel = StatisticaOraria.model().STATISTICA_ORARIA_CONTENUTI;
                break;
            }
            case GIORNALIERA: {
                this.model = StatisticaGiornaliera.model().STATISTICA_BASE;
                this.contenutiModel = StatisticaGiornaliera.model().STATISTICA_GIORNALIERA_CONTENUTI;
                break;
            }
            case SETTIMANALE: {
                this.model = StatisticaSettimanale.model().STATISTICA_BASE;
                this.contenutiModel = StatisticaSettimanale.model().STATISTICA_SETTIMANALE_CONTENUTI;
                break;
            }
            case MENSILE: {
                this.model = StatisticaMensile.model().STATISTICA_BASE;
                this.contenutiModel = StatisticaMensile.model().STATISTICA_MENSILE_CONTENUTI;
            }
        }
    }

    private static IExpression newExpression(TipiDatabase databaseType, StatisticType statisticType) throws SearchException {
        try {
            return new JDBCExpression(FilterStatisticRepositoryImpl.newFieldConverter(databaseType, statisticType));
        }
        catch (Exception e) {
            throw new SearchException(e.getMessage(), (Throwable)e);
        }
    }

    private static ISQLFieldConverter newFieldConverter(TipiDatabase databaseType, StatisticType statisticType) throws SearchException {
        switch (statisticType) {
            case ORARIA: {
                return new StatisticaOrariaFieldConverter(databaseType);
            }
            case GIORNALIERA: {
                return new StatisticaGiornalieraFieldConverter(databaseType);
            }
            case SETTIMANALE: {
                return new StatisticaSettimanaleFieldConverter(databaseType);
            }
            case MENSILE: {
                return new StatisticaMensileFieldConverter(databaseType);
            }
        }
        throw new SearchException("StatisticType[" + String.valueOf(statisticType) + "] unknown");
    }

    @Override
    protected IStatisticFilter newIFilter() throws SearchException {
        try {
            return new FilterStatisticRepositoryImpl(this.databaseType, this.statisticType);
        }
        catch (Exception e) {
            throw new SearchException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected IExpression newIExpression() throws SearchException {
        try {
            return FilterStatisticRepositoryImpl.newExpression(this.databaseType, this.statisticType);
        }
        catch (Exception e) {
            throw new SearchException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected IField getIFieldForMessageType() throws SearchException {
        return null;
    }

    @Override
    protected List<IField> getIFieldForResourceName(StatisticFilterName statisticFilter) throws SearchException {
        try {
            ArrayList<IField> l = new ArrayList<IField>();
            if (statisticFilter == null) {
                l.add((IField)new AliasTableComplexField((ComplexField)this.contenutiModel.FILTRO_NOME_1, FilterUtils.getNextAliasStatisticsTable()));
                l.add((IField)new AliasTableComplexField((ComplexField)this.contenutiModel.FILTRO_NOME_2, FilterUtils.getNextAliasStatisticsTable()));
                l.add((IField)new AliasTableComplexField((ComplexField)this.contenutiModel.FILTRO_NOME_3, FilterUtils.getNextAliasStatisticsTable()));
                l.add((IField)new AliasTableComplexField((ComplexField)this.contenutiModel.FILTRO_NOME_4, FilterUtils.getNextAliasStatisticsTable()));
                l.add((IField)new AliasTableComplexField((ComplexField)this.contenutiModel.FILTRO_NOME_5, FilterUtils.getNextAliasStatisticsTable()));
                l.add((IField)new AliasTableComplexField((ComplexField)this.contenutiModel.FILTRO_NOME_6, FilterUtils.getNextAliasStatisticsTable()));
                l.add((IField)new AliasTableComplexField((ComplexField)this.contenutiModel.FILTRO_NOME_7, FilterUtils.getNextAliasStatisticsTable()));
                l.add((IField)new AliasTableComplexField((ComplexField)this.contenutiModel.FILTRO_NOME_8, FilterUtils.getNextAliasStatisticsTable()));
                l.add((IField)new AliasTableComplexField((ComplexField)this.contenutiModel.FILTRO_NOME_9, FilterUtils.getNextAliasStatisticsTable()));
                l.add((IField)new AliasTableComplexField((ComplexField)this.contenutiModel.FILTRO_NOME_10, FilterUtils.getNextAliasStatisticsTable()));
            } else {
                switch (statisticFilter) {
                    case FILTER_1: {
                        l.add(this.contenutiModel.FILTRO_NOME_1);
                        break;
                    }
                    case FILTER_2: {
                        l.add(this.contenutiModel.FILTRO_NOME_2);
                        break;
                    }
                    case FILTER_3: {
                        l.add(this.contenutiModel.FILTRO_NOME_3);
                        break;
                    }
                    case FILTER_4: {
                        l.add(this.contenutiModel.FILTRO_NOME_4);
                        break;
                    }
                    case FILTER_5: {
                        l.add(this.contenutiModel.FILTRO_NOME_5);
                        break;
                    }
                    case FILTER_6: {
                        l.add(this.contenutiModel.FILTRO_NOME_6);
                        break;
                    }
                    case FILTER_7: {
                        l.add(this.contenutiModel.FILTRO_NOME_7);
                        break;
                    }
                    case FILTER_8: {
                        l.add(this.contenutiModel.FILTRO_NOME_8);
                        break;
                    }
                    case FILTER_9: {
                        l.add(this.contenutiModel.FILTRO_NOME_9);
                        break;
                    }
                    case FILTER_10: {
                        l.add(this.contenutiModel.FILTRO_NOME_10);
                    }
                }
            }
            return l;
        }
        catch (Exception e) {
            throw new SearchException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected IField getIFieldForResourceValue(IField fieldResourceName) throws SearchException {
        try {
            String aliasTable = null;
            if (fieldResourceName instanceof IAliasTableField) {
                IAliasTableField af = (IAliasTableField)fieldResourceName;
                aliasTable = af.getAliasTable();
            }
            if (this.contenutiModel.FILTRO_NOME_1.equals((Object)fieldResourceName)) {
                if (aliasTable != null) {
                    return new AliasTableComplexField((ComplexField)this.contenutiModel.FILTRO_VALORE_1, aliasTable);
                }
                return this.contenutiModel.FILTRO_VALORE_1;
            }
            if (this.contenutiModel.FILTRO_NOME_2.equals((Object)fieldResourceName)) {
                if (aliasTable != null) {
                    return new AliasTableComplexField((ComplexField)this.contenutiModel.FILTRO_VALORE_2, aliasTable);
                }
                return this.contenutiModel.FILTRO_VALORE_2;
            }
            if (this.contenutiModel.FILTRO_NOME_3.equals((Object)fieldResourceName)) {
                if (aliasTable != null) {
                    return new AliasTableComplexField((ComplexField)this.contenutiModel.FILTRO_VALORE_3, aliasTable);
                }
                return this.contenutiModel.FILTRO_VALORE_3;
            }
            if (this.contenutiModel.FILTRO_NOME_4.equals((Object)fieldResourceName)) {
                if (aliasTable != null) {
                    return new AliasTableComplexField((ComplexField)this.contenutiModel.FILTRO_VALORE_4, aliasTable);
                }
                return this.contenutiModel.FILTRO_VALORE_4;
            }
            if (this.contenutiModel.FILTRO_NOME_5.equals((Object)fieldResourceName)) {
                if (aliasTable != null) {
                    return new AliasTableComplexField((ComplexField)this.contenutiModel.FILTRO_VALORE_5, aliasTable);
                }
                return this.contenutiModel.FILTRO_VALORE_5;
            }
            if (this.contenutiModel.FILTRO_NOME_6.equals((Object)fieldResourceName)) {
                if (aliasTable != null) {
                    return new AliasTableComplexField((ComplexField)this.contenutiModel.FILTRO_VALORE_6, aliasTable);
                }
                return this.contenutiModel.FILTRO_VALORE_6;
            }
            if (this.contenutiModel.FILTRO_NOME_7.equals((Object)fieldResourceName)) {
                if (aliasTable != null) {
                    return new AliasTableComplexField((ComplexField)this.contenutiModel.FILTRO_VALORE_7, aliasTable);
                }
                return this.contenutiModel.FILTRO_VALORE_7;
            }
            if (this.contenutiModel.FILTRO_NOME_8.equals((Object)fieldResourceName)) {
                if (aliasTable != null) {
                    return new AliasTableComplexField((ComplexField)this.contenutiModel.FILTRO_VALORE_8, aliasTable);
                }
                return this.contenutiModel.FILTRO_VALORE_8;
            }
            if (this.contenutiModel.FILTRO_NOME_9.equals((Object)fieldResourceName)) {
                if (aliasTable != null) {
                    return new AliasTableComplexField((ComplexField)this.contenutiModel.FILTRO_VALORE_9, aliasTable);
                }
                return this.contenutiModel.FILTRO_VALORE_9;
            }
            if (this.contenutiModel.FILTRO_NOME_10.equals((Object)fieldResourceName)) {
                if (aliasTable != null) {
                    return new AliasTableComplexField((ComplexField)this.contenutiModel.FILTRO_VALORE_10, aliasTable);
                }
                return this.contenutiModel.FILTRO_VALORE_10;
            }
            throw new Exception("Unknown field: " + String.valueOf(fieldResourceName));
        }
        catch (Exception e) {
            throw new SearchException(e.getMessage(), (Throwable)e);
        }
    }
}

