/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.monitor.engine.dynamic;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.openspcoop2.core.config.RegistroPlugin;
import org.openspcoop2.core.config.RegistroPluginArchivio;
import org.openspcoop2.core.plugins.constants.TipoPlugin;
import org.openspcoop2.monitor.engine.dynamic.PluginJar;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.regexp.RegExpException;
import org.openspcoop2.utils.regexp.RegExpNotFoundException;
import org.openspcoop2.utils.regexp.RegExpNotValidException;
import org.openspcoop2.utils.resources.DynamicClassLoader;

public class Plugin
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String nome;
    private Date date;
    private List<String> compatibilita;
    private List<PluginJar> archivePlugin = new ArrayList<PluginJar>();
    private transient DynamicClassLoader classLoader;

    public String getNome() {
        return this.nome;
    }

    public Date getDate() {
        return this.date;
    }

    public Plugin(RegistroPlugin plugin) throws UtilsException, IOException, RegExpException, RegExpNotValidException, RegExpNotFoundException, URISyntaxException {
        this.nome = plugin.getNome();
        this.date = plugin.getData();
        this.compatibilita = plugin.getCompatibilitaList();
        ArrayList<URL> listUrl = new ArrayList<URL>();
        for (RegistroPluginArchivio pluginJar : plugin.getArchivioList()) {
            this.init(pluginJar, listUrl);
        }
        this.classLoader = new DynamicClassLoader(listUrl.toArray(new URL[1]));
    }

    private void init(RegistroPluginArchivio pluginJar, List<URL> listUrl) throws UtilsException, IOException, RegExpException, RegExpNotValidException, RegExpNotFoundException, URISyntaxException {
        String archivioPrefix = "Archivio '" + pluginJar.getNome() + "' ";
        PluginJar plug = null;
        switch (pluginJar.getSorgente()) {
            case JAR: {
                if (pluginJar.getContenuto() == null) {
                    throw new UtilsException(archivioPrefix + "senza contenuto (sorgente: " + String.valueOf(pluginJar.getSorgente()) + ")");
                }
                plug = new PluginJar(pluginJar.getNome(), pluginJar.getData(), pluginJar.getContenuto());
                this.archivePlugin.add(plug);
                listUrl.add(plug.getResourceURL());
                break;
            }
            case URL: {
                if (pluginJar.getUrl() == null) {
                    throw new UtilsException(archivioPrefix + "senza url (sorgente: " + String.valueOf(pluginJar.getSorgente()) + ")");
                }
                plug = new PluginJar(pluginJar.getNome(), pluginJar.getData(), pluginJar.getUrl());
                this.archivePlugin.add(plug);
                listUrl.add(plug.getResourceURL());
                break;
            }
            case DIR: {
                if (pluginJar.getDir() == null) {
                    throw new UtilsException(archivioPrefix + "senza directory (sorgente: " + String.valueOf(pluginJar.getSorgente()) + ")");
                }
                File fDir = new File(pluginJar.getDir());
                if (!fDir.exists()) {
                    throw new UtilsException(archivioPrefix + "indica una directory '" + fDir.getAbsolutePath() + "' non esistente (sorgente: " + String.valueOf(pluginJar.getSorgente()) + ")");
                }
                if (fDir.isDirectory()) {
                    this.loadJar(pluginJar.getNome(), pluginJar.getData(), fDir, listUrl);
                    break;
                }
                plug = new PluginJar(pluginJar.getNome(), pluginJar.getData(), pluginJar.getDir());
                this.archivePlugin.add(plug);
                listUrl.add(plug.getResourceURL());
            }
        }
    }

    private void loadJar(String nomePlugin, Date data, File dir, List<URL> listUrl) throws UtilsException, MalformedURLException, RegExpException, RegExpNotValidException, RegExpNotFoundException, URISyntaxException {
        ArrayList<File> dirs = new ArrayList<File>();
        File[] files = dir.listFiles();
        if (files != null && files.length > 0) {
            for (int i = 0; i < files.length; ++i) {
                File f = files[i];
                if (f.isFile()) {
                    if (!f.getName().endsWith(".jar")) continue;
                    PluginJar plug = new PluginJar(nomePlugin + "#" + f.getAbsolutePath(), data, f.getAbsolutePath());
                    this.archivePlugin.add(plug);
                    listUrl.add(plug.getResourceURL());
                    continue;
                }
                if (!f.isDirectory()) continue;
                dirs.add(f);
            }
        }
        if (!dirs.isEmpty()) {
            for (File dirChild : dirs) {
                this.loadJar(nomePlugin, data, dirChild, listUrl);
            }
        }
    }

    public ClassLoader getClassLoader(TipoPlugin tipoClasseDaRicercare) {
        return this.getClassLoader(tipoClasseDaRicercare.getValue());
    }

    public ClassLoader getClassLoader(String tipoClasseCustomDaRicercare) {
        if (this.compatibilita != null && !this.compatibilita.isEmpty() && !this.compatibilita.contains(tipoClasseCustomDaRicercare)) {
            return null;
        }
        return this.classLoader;
    }

    public void close() {
        if (!this.archivePlugin.isEmpty()) {
            for (PluginJar pluginJar : this.archivePlugin) {
                pluginJar.close();
            }
        }
    }
}

