/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.monitor.engine.statistic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openspcoop2.core.commons.dao.DAOFactory;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.monitor.engine.statistic.AbstractStatistiche;
import org.openspcoop2.monitor.engine.statistic.RisorsaAggregata;
import org.openspcoop2.monitor.engine.statistic.RisorsaSemplice;
import org.openspcoop2.monitor.engine.statistic.StatisticBean;
import org.openspcoop2.monitor.sdk.condition.IFilter;
import org.openspcoop2.monitor.sdk.constants.StatisticType;
import org.openspcoop2.monitor.sdk.exceptions.StatisticException;
import org.openspcoop2.monitor.sdk.statistic.IStatistic;
import org.openspcoop2.monitor.sdk.statistic.StatisticFilter;
import org.openspcoop2.monitor.sdk.statistic.StatisticResourceFilter;
import org.openspcoop2.utils.TipiDatabase;
import org.slf4j.Logger;

public class CustomStatisticsSdkGenerator
implements IStatistic {
    private StatisticBean statistic;
    private StatisticType statisticType;
    private AbstractStatistiche abstractStatisticheCore;
    private int numeroVolteCreazioneStatisticaSemplice = 0;
    private List<String> idStatistiche = new ArrayList<String>();
    private List<String> idRisorse = new ArrayList<String>();
    private Map<String, String> mapIdRisorsaToIdStatistica = new HashMap<String, String>();

    protected CustomStatisticsSdkGenerator(StatisticBean stat, StatisticType statisticType, AbstractStatistiche abstractStatisticheCore) {
        this.statistic = stat;
        this.statisticType = statisticType;
        this.abstractStatisticheCore = abstractStatisticheCore;
    }

    public TipoPdD getTipoPorta() {
        return this.statistic.getTipoPorta();
    }

    public String getIdentificativoPorta() {
        return this.statistic.getIdPorta();
    }

    public String getTipoSoggettoMittente() {
        if (this.statistic.getMittente() != null) {
            return this.statistic.getMittente().getTipo();
        }
        return null;
    }

    public String getSoggettoMittente() {
        if (this.statistic.getMittente() != null) {
            return this.statistic.getMittente().getNome();
        }
        return null;
    }

    public String getTipoSoggettoDestinatario() {
        if (this.statistic.getDestinatario() != null) {
            return this.statistic.getDestinatario().getTipo();
        }
        return null;
    }

    public String getSoggettoDestinatario() {
        if (this.statistic.getDestinatario() != null) {
            return this.statistic.getDestinatario().getNome();
        }
        return null;
    }

    public String getTipoServizio() {
        return this.statistic.getTipoServizio();
    }

    public String getServizio() {
        return this.statistic.getServizio();
    }

    public Integer getVersioneServizio() {
        return this.statistic.getVersioneServizio();
    }

    public String getAzione() {
        return this.statistic.getAzione();
    }

    public String getServizioApplicativo() {
        return this.statistic.getServizioApplicativo();
    }

    public String getIdentificativoAutenticato() {
        return this.statistic.getTrasportoMittente();
    }

    public String getTokenInfoIssuer() {
        return this.statistic.getTokenIssuer();
    }

    public String getTokenInfoClientId() {
        return this.statistic.getTokenClientId();
    }

    public String getTokenInfoSubject() {
        return this.statistic.getTokenSubject();
    }

    public String getTokenInfoUsername() {
        return this.statistic.getTokenUsername();
    }

    public String getTokenInfoEmail() {
        return this.statistic.getTokenMail();
    }

    public String getClientAddress() {
        return this.statistic.getClientAddress();
    }

    public String getGruppo() {
        return this.statistic.getGruppo();
    }

    public String getApi() {
        return this.statistic.getApi();
    }

    public String getClusterId() {
        return this.statistic.getClusterId();
    }

    public TipiDatabase getDatabaseType() {
        return this.abstractStatisticheCore.getDatabaseType();
    }

    public StatisticType getStatisticType() {
        return this.statisticType;
    }

    public Logger getLogger() {
        return this.abstractStatisticheCore.logger;
    }

    public DAOFactory getDAOFactory() throws StatisticException {
        try {
            return DAOFactory.getInstance((Logger)this.abstractStatisticheCore.logger);
        }
        catch (Exception e) {
            throw new StatisticException(e.getMessage(), (Throwable)e);
        }
    }

    public StatisticBean getStatistic() {
        return this.statistic;
    }

    public AbstractStatistiche getAbstractStatisticheCore() {
        return this.abstractStatisticheCore;
    }

    public void createStatistics(String idRisorsa) throws StatisticException {
        this.createStatistics(idRisorsa, new StatisticResourceFilter[0]);
    }

    public void createStatistics(String idRisorsa, StatisticResourceFilter ... idRisorseFiltri) throws StatisticException {
        if (idRisorsa == null) {
            throw new StatisticException("IdResource undefined");
        }
        if (this.numeroVolteCreazioneStatisticaSemplice > 0) {
            throw new StatisticException("It is not allowed to generate more of a statistic without providing the identifier of the statistic (use method createStatistics(idStatistic,String idResource, ...))");
        }
        RisorsaSemplice risorsa = new RisorsaSemplice();
        risorsa.setIdRisorsa(idRisorsa);
        if (idRisorseFiltri != null && idRisorseFiltri.length > 0) {
            for (int i = 0; i < idRisorseFiltri.length; ++i) {
                risorsa.getFiltri().add(idRisorseFiltri[i]);
            }
        }
        this.abstractStatisticheCore.generaStatisticaPersonalizzata(this.statistic, risorsa);
        ++this.numeroVolteCreazioneStatisticaSemplice;
    }

    public void createStatistics(String idStatistica, String idRisorsa) throws StatisticException {
        this.createStatistics(idStatistica, idRisorsa, new StatisticResourceFilter[0]);
    }

    public void createStatistics(String idStatistica, String idRisorsa, StatisticResourceFilter ... idRisorseFiltri) throws StatisticException {
        if (idStatistica == null || "".equals(idStatistica)) {
            throw new StatisticException("IdStatistic undefined");
        }
        if (this.idStatistiche.contains(idStatistica)) {
            throw new StatisticException("IdStatistic [" + idStatistica + "] already used");
        }
        if (idRisorsa == null || "".equals(idRisorsa)) {
            throw new StatisticException("IdResource undefined");
        }
        if (this.idRisorse.contains(idRisorsa)) {
            throw new StatisticException("IdResource [" + idRisorsa + "] already used for statistic with id: " + this.mapIdRisorsaToIdStatistica.get(idRisorsa));
        }
        RisorsaSemplice risorsa = new RisorsaSemplice();
        risorsa.setIdStatistica(idStatistica);
        risorsa.setIdRisorsa(idRisorsa);
        if (idRisorseFiltri != null && idRisorseFiltri.length > 0) {
            for (int i = 0; i < idRisorseFiltri.length; ++i) {
                risorsa.getFiltri().add(idRisorseFiltri[i]);
            }
        }
        this.abstractStatisticheCore.generaStatisticaPersonalizzata(this.statistic, risorsa);
        this.idStatistiche.add(idStatistica);
        this.idRisorse.add(idRisorsa);
        this.mapIdRisorsaToIdStatistica.put(idRisorsa, idStatistica);
    }

    public void createStatistics(IFilter filtro, String valoreRisorsaAggregata) throws StatisticException {
        this.createStatistics(filtro, valoreRisorsaAggregata, new StatisticFilter[0]);
    }

    public void createStatistics(IFilter filtro, String valoreRisorsaAggregata, StatisticFilter ... filtriRicerca) throws StatisticException {
        if (filtro == null) {
            throw new StatisticException("Filter undefined");
        }
        if (valoreRisorsaAggregata == null || "".equals(valoreRisorsaAggregata)) {
            throw new StatisticException("AggregateResourceValue undefined");
        }
        RisorsaAggregata risorsa = new RisorsaAggregata();
        risorsa.setFiltro(filtro);
        try {
            risorsa.setValoreRisorsaAggregata(valoreRisorsaAggregata);
        }
        catch (Exception e) {
            throw new StatisticException(e.getMessage(), (Throwable)e);
        }
        if (filtriRicerca != null && filtriRicerca.length > 0) {
            for (int i = 0; i < filtriRicerca.length; ++i) {
                risorsa.getFiltri().add(filtriRicerca[i]);
            }
        }
        this.abstractStatisticheCore.generaStatisticaPersonalizzata(this.statistic, risorsa);
    }

    public void createStatisticsByStato() {
        this.abstractStatisticheCore.generaStatisticaPersonalizzataByStato(this.statistic);
    }
}

