/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.monitor.engine.statistic;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.csv.CSVFormat;
import org.openspcoop2.core.plugins.dao.IServiceManager;
import org.openspcoop2.core.statistiche.StatistichePdndTracing;
import org.openspcoop2.core.statistiche.constants.PdndMethods;
import org.openspcoop2.core.statistiche.constants.PossibiliStatiPdnd;
import org.openspcoop2.core.statistiche.constants.TipoIntervalloStatistico;
import org.openspcoop2.core.statistiche.dao.IDBStatistichePdndTracingService;
import org.openspcoop2.core.transazioni.CredenzialeMittente;
import org.openspcoop2.core.transazioni.Transazione;
import org.openspcoop2.core.transazioni.constants.PddRuolo;
import org.openspcoop2.core.transazioni.dao.jdbc.JDBCCredenzialeMittenteServiceSearch;
import org.openspcoop2.core.transazioni.utils.credenziali.AbstractCredenzialeList;
import org.openspcoop2.generic_project.beans.Function;
import org.openspcoop2.generic_project.beans.FunctionField;
import org.openspcoop2.generic_project.exception.ExpressionException;
import org.openspcoop2.generic_project.exception.ExpressionNotImplementedException;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.generic_project.exception.NotImplementedException;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.generic_project.expression.IPaginatedExpression;
import org.openspcoop2.generic_project.expression.SortOrder;
import org.openspcoop2.monitor.engine.statistic.IStatisticsEngine;
import org.openspcoop2.monitor.engine.statistic.PdndTracciamentoInfo;
import org.openspcoop2.monitor.engine.statistic.PdndTracciamentoSoggetto;
import org.openspcoop2.monitor.engine.statistic.PdndTracciamentoUtils;
import org.openspcoop2.monitor.engine.statistic.StatisticsConfig;
import org.openspcoop2.monitor.engine.statistic.StatisticsEngineException;
import org.openspcoop2.monitor.engine.statistic.StatisticsInfoUtils;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.csv.Format;
import org.openspcoop2.utils.csv.Printer;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.date.DateUtils;
import org.openspcoop2.utils.regexp.RegularExpressionEngine;
import org.slf4j.Logger;

public class PdndGenerazioneTracciamento
implements IStatisticsEngine {
    private static final String PDND_DATE_FORMAT = "yyyy-MM-dd";
    private static final String REQUESTS_COUNT_ID = "request_count";
    private StatisticsConfig config;
    private org.openspcoop2.core.statistiche.dao.IServiceManager statisticheSM;
    private org.openspcoop2.core.transazioni.dao.IServiceManager transazioniSM;
    private Map<String, Integer> eventsToCode;
    private PdndTracciamentoInfo internalPddCodes;
    private Logger logger;
    private static final String[] CSV_HEADERS = new String[]{"date", "purpose_id", "status", "token_id", "requests_count"};

    PdndGenerazioneTracciamento() {
    }

    @Override
    public void init(StatisticsConfig config, org.openspcoop2.core.statistiche.dao.IServiceManager statisticheSM, org.openspcoop2.core.transazioni.dao.IServiceManager transazioniSM, org.openspcoop2.monitor.engine.config.statistiche.dao.IServiceManager pluginsStatisticheSM, IServiceManager pluginsBaseSM, org.openspcoop2.core.commons.search.dao.IServiceManager utilsSM, org.openspcoop2.monitor.engine.config.transazioni.dao.IServiceManager pluginsTransazioniSM) {
        this.config = config;
        this.statisticheSM = statisticheSM;
        this.transazioniSM = transazioniSM;
        this.logger = config.getLogCore();
        this.eventsToCode = new HashMap<String, Integer>();
        try {
            this.internalPddCodes = PdndTracciamentoUtils.getEnabledPddCodes(utilsSM, config);
            PdndTracciamentoUtils.logDebugSoggettiAbilitati(this.internalPddCodes, this.logger);
        }
        catch (Throwable e) {
            this.logger.error("Impossibile inizializzare la classe PdndGenerazioneTracciamento", e);
        }
    }

    private Date truncDate(Date date) {
        Calendar cTmp = Calendar.getInstance();
        cTmp.setTime(date);
        cTmp.set(11, 0);
        cTmp.set(12, 0);
        cTmp.set(13, 0);
        cTmp.set(14, 0);
        return cTmp.getTime();
    }

    private Date incrementDate(Date date) {
        Calendar cTmp = Calendar.getInstance();
        cTmp.setTime(date);
        cTmp.set(6, cTmp.get(6) + 1);
        return cTmp.getTime();
    }

    private Integer convertEventToInteger(Object o) throws UtilsException {
        try {
            if (o instanceof Integer) {
                return (Integer)o;
            }
            String event = o.toString();
            Integer cached = this.eventsToCode.get(event);
            if (cached != null) {
                return cached;
            }
            CredenzialeMittente credenzialeMittente = ((JDBCCredenzialeMittenteServiceSearch)this.transazioniSM.getCredenzialeMittenteService()).get(Long.valueOf(event).longValue());
            String cred = AbstractCredenzialeList.normalize((String)credenzialeMittente.getCredenziale());
            String rawCode = RegularExpressionEngine.getStringFindPattern((String)cred, (String)"Out=(\\d+)");
            Integer code = Integer.valueOf(rawCode);
            this.eventsToCode.put(event, code);
            return code;
        }
        catch (Exception e) {
            throw new UtilsException("Errore nella risoluzione del campo eventi_gestione della transazione, id={" + String.valueOf(o) + "}: " + e.getMessage(), (Throwable)e);
        }
    }

    public byte[] generateCsv(Date tracingDate, Stream<Map<String, Object>> data) throws UtilsException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        CSVFormat csvFormat = CSVFormat.DEFAULT.builder().setHeader(CSV_HEADERS).get();
        Format format = new Format();
        format.setSkipEmptyRecord(false);
        format.setCsvFormat(csvFormat);
        Printer printer = new Printer(format, (OutputStream)os);
        for (Map row : data.collect(Collectors.toList())) {
            String purposeId = row.get(Transazione.model().TOKEN_PURPOSE_ID.getFieldName()).toString();
            String tokenId = row.get(Transazione.model().TOKEN_ID.getFieldName()).toString();
            Integer status = this.convertEventToInteger(row.get(Transazione.model().EVENTI_GESTIONE.getFieldName()));
            String requestsCount = row.get(REQUESTS_COUNT_ID).toString();
            printer.printRecord(new Object[]{this.dataTracciamentoFormat(tracingDate), purposeId, status, tokenId, requestsCount});
        }
        printer.close();
        return os.toByteArray();
    }

    private boolean createRecord(Date start, Date end, PdndTracciamentoSoggetto soggettoEntry) {
        String pddCode = soggettoEntry.getIdSoggetto().getCodicePorta();
        List<String> soggettiAggregati = PdndTracciamentoUtils.getNomiSoggettiAggregati(soggettoEntry);
        ArrayList<String> pddCodici = new ArrayList<String>();
        pddCodici.add(pddCode);
        pddCodici.addAll(soggettiAggregati);
        Date endTraceDate = this.truncDate(this.incrementDate(start));
        StatistichePdndTracing entry = new StatistichePdndTracing();
        Date now = DateManager.getDate();
        entry.setDataRegistrazione(now);
        entry.setDataTracciamento(start);
        entry.setPddCodice(soggettoEntry.getIdSoggetto().getCodicePorta());
        entry.setHistory(0);
        entry.setMethod(endTraceDate.before(this.truncDate(now)) ? PdndMethods.RECOVER : PdndMethods.SUBMIT);
        entry.setStatoPdnd(PossibiliStatiPdnd.WAITING);
        try {
            this.statisticheSM.getStatistichePdndTracingService().create((Object)entry);
        }
        catch (NotImplementedException | ServiceException e) {
            String dataTracciamento = this.dataTracciamentoFormat(start);
            this.logger.error("Errore nel inserire il record sul database per il soggetto {} (idPorta: {}), data tracciamento: {}", new Object[]{soggettoEntry.getIdSoggetto().getNome(), soggettoEntry.getIdSoggetto().getCodicePorta(), dataTracciamento, e});
            return false;
        }
        try {
            Stream<Map<String, Object>> groups = this.aggregateTransactions(start, end, pddCodici.toArray(new String[0]));
            try (ByteArrayInputStream csv = new ByteArrayInputStream(this.generateCsv(start, groups));){
                IDBStatistichePdndTracingService dbService = (IDBStatistichePdndTracingService)this.statisticheSM.getStatistichePdndTracingService();
                dbService.setCsvStream(entry.getId().longValue(), (InputStream)csv);
            }
        }
        catch (Exception e) {
            String dataTracciamento = this.dataTracciamentoFormat(start);
            this.logger.error("Errore nel generare/salvare il csv per il soggetto {} (idPorta: {}), data tracciamento: {}", new Object[]{soggettoEntry.getIdSoggetto().getNome(), soggettoEntry.getIdSoggetto().getCodicePorta(), dataTracciamento, e});
            return false;
        }
        return true;
    }

    private IPaginatedExpression buildAggregateExpression(Date start, Date end, int offset, int limit, String ... pddCode) throws ExpressionNotImplementedException, ExpressionException, ServiceException, NotImplementedException {
        IPaginatedExpression expr = this.transazioniSM.getTransazioneService().newPaginatedExpression();
        expr.limit(limit).offset(offset).sortOrder(SortOrder.ASC).addOrder(Transazione.model().EVENTI_GESTIONE).addGroupBy(Transazione.model().TOKEN_PURPOSE_ID).addGroupBy(Transazione.model().TOKEN_ID).addGroupBy(Transazione.model().EVENTI_GESTIONE).and().between(Transazione.model().DATA_INGRESSO_RICHIESTA, (Object)start, (Object)end).isNotNull(Transazione.model().PDD_CODICE).isNotNull(Transazione.model().TOKEN_PURPOSE_ID).isNotNull(Transazione.model().TOKEN_ID).isNotNull(Transazione.model().EVENTI_GESTIONE).equals(Transazione.model().PROTOCOLLO, (Object)"modipa");
        if (!this.config.isPdndTracciamentoFruizioniEnabled()) {
            expr.notEquals(Transazione.model().PDD_RUOLO, (Object)PddRuolo.DELEGATA);
        }
        if (!this.config.isPdndTracciamentoErogazioniEnabled()) {
            expr.notEquals(Transazione.model().PDD_RUOLO, (Object)PddRuolo.APPLICATIVA);
        }
        if (pddCode != null && pddCode.length > 0) {
            if (pddCode.length == 1) {
                expr.equals(Transazione.model().PDD_CODICE, (Object)pddCode[0]);
            } else {
                expr.in(Transazione.model().PDD_CODICE, Arrays.asList(pddCode));
            }
        }
        return expr;
    }

    private Stream<Map<String, Object>> aggregateTransactions(Date start, Date end, String ... pddCode) throws ExpressionNotImplementedException, ExpressionException, ServiceException, NotImplementedException {
        int limit = this.config.getPdndTracciamentoGenerazioneDbBatchSize();
        AtomicInteger offset = new AtomicInteger(0);
        LinkedList partialResult = new LinkedList();
        return ((Stream)Stream.generate(() -> {
            if (partialResult.isEmpty()) {
                try {
                    IPaginatedExpression expr = this.buildAggregateExpression(start, end, offset.get(), limit, pddCode);
                    FunctionField countFunction = new FunctionField(Transazione.model().ID_TRANSAZIONE, Function.COUNT, REQUESTS_COUNT_ID);
                    partialResult.addAll(this.transazioniSM.getTransazioneService().groupBy(expr, new FunctionField[]{countFunction}));
                    offset.addAndGet(limit);
                }
                catch (NotFoundException expr) {
                }
                catch (Exception e) {
                    partialResult.clear();
                    this.logger.error("Errore durante il prelievo dal db delle transazioni aggregate", (Throwable)e);
                }
            }
            return partialResult.isEmpty() ? null : (Map)partialResult.remove();
        }).sequential()).takeWhile(Objects::nonNull);
    }

    private boolean createRecords(Date start, Date end, Set<String> ignorePdd) {
        String dataTracciamento = this.dataTracciamentoFormat(start);
        boolean errors = false;
        for (PdndTracciamentoSoggetto soggettoEntry : this.internalPddCodes.getSoggetti()) {
            String pddCode = soggettoEntry.getIdSoggetto().getCodicePorta();
            String nomeSoggetto = soggettoEntry.getIdSoggetto().getNome();
            List<String> soggettiAggregati = PdndTracciamentoUtils.getNomiSoggettiAggregati(soggettoEntry);
            if (ignorePdd.contains(pddCode)) {
                this.logger.info("Tracciato [{}] gi\u00e0 presente per il soggetto: {} aggregati: {}, non genero", new Object[]{dataTracciamento, nomeSoggetto, soggettiAggregati});
                continue;
            }
            if (this.createRecord(start, end, soggettoEntry)) {
                this.logger.info("Tracciato [{}] generato correttamente per il soggetto: {} aggregati: {}", new Object[]{dataTracciamento, nomeSoggetto, soggettiAggregati});
                continue;
            }
            this.logger.info("Tracciato [{}] non generato per il soggetto: {} aggregati: {}", new Object[]{dataTracciamento, nomeSoggetto, soggettiAggregati});
            errors = true;
        }
        return !errors;
    }

    public void scanNull() throws ServiceException, NotImplementedException, ExpressionNotImplementedException, ExpressionException {
        IPaginatedExpression expr = this.statisticheSM.getStatistichePdndTracingService().newPaginatedExpression();
        expr.isNull(StatistichePdndTracing.model().CSV);
        this.logger.info("Cerco tracciati vuoti ...");
        List stats = null;
        try {
            stats = this.statisticheSM.getStatistichePdndTracingService().findAll(expr);
        }
        catch (Exception e) {
            if (e.getCause() instanceof NotFoundException || e instanceof NotFoundException) {
                this.logger.info("Non sono stati trovati tracciati vuoti");
                return;
            }
            throw new ServiceException("Non sono stati trovati tracciati vuoti per via di un'anomalia: " + e.getMessage(), (Throwable)e);
        }
        this.logger.info("Sono stati trovati {} tracciati vuoti, procedo a valorizzarli", (Object)stats.size());
        for (StatistichePdndTracing stat : stats) {
            PdndTracciamentoSoggetto soggettoEntry = this.internalPddCodes.getInfoByIdentificativoPorta(stat.getPddCodice(), true, false);
            List<String> soggettiAggregati = PdndTracciamentoUtils.getNomiSoggettiAggregati(soggettoEntry);
            ArrayList<String> pddCodici = new ArrayList<String>();
            pddCodici.add(soggettoEntry.getIdSoggetto().getCodicePorta());
            pddCodici.addAll(soggettiAggregati);
            String nomeSoggetto = soggettoEntry.getIdSoggetto().getNome();
            String dataTracciamento = this.dataTracciamentoFormat(stat.getDataTracciamento());
            Date startTracing = stat.getDataTracciamento();
            Date endTracing = this.truncDate(this.incrementDate(startTracing));
            this.logger.info("Tracciato [{}] vuoto del soggetto: {} aggregati: {}, valorizzazione in corso ...", new Object[]{dataTracciamento, nomeSoggetto, soggettiAggregati});
            try {
                Stream<Map<String, Object>> data = this.aggregateTransactions(startTracing, endTracing, pddCodici.toArray(new String[1]));
                try (ByteArrayInputStream csv = new ByteArrayInputStream(this.generateCsv(startTracing, data));){
                    IDBStatistichePdndTracingService dbService = (IDBStatistichePdndTracingService)this.statisticheSM.getStatistichePdndTracingService();
                    dbService.setCsvStream(stat.getId().longValue(), (InputStream)csv);
                }
                this.logger.info("Tracciato [{}] del soggetto: {} aggregati: {} valorizzato correttamente", new Object[]{dataTracciamento, nomeSoggetto, soggettiAggregati});
            }
            catch (Exception e) {
                this.logger.error("Errore nell'update della statistica con csv null, tracingDate: {}, codice pdd: {}", new Object[]{this.dataTracciamentoFormat(startTracing), stat.getPddCodice(), e});
            }
        }
    }

    private Map<Date, Set<String>> getAlreadyExistsPddRecords(Date lastDate) throws NotImplementedException, ServiceException {
        Map<Date, Set<String>> ignorePddCodes = null;
        try {
            IPaginatedExpression expr = this.statisticheSM.getStatistichePdndTracingService().newPaginatedExpression();
            expr.greaterEquals(StatistichePdndTracing.model().DATA_TRACCIAMENTO, (Object)lastDate);
            expr.equals(StatistichePdndTracing.model().HISTORY, (Object)0);
            List stats = this.statisticheSM.getStatistichePdndTracingService().findAll(expr);
            ignorePddCodes = stats.stream().collect(Collectors.toMap(StatistichePdndTracing::getDataTracciamento, o -> {
                HashSet<String> baseSet = new HashSet<String>();
                baseSet.add(o.getPddCodice());
                return baseSet;
            }, (o1, o2) -> {
                o1.addAll(o2);
                return o1;
            }));
        }
        catch (Exception e) {
            if (e.getCause() instanceof NotFoundException || e instanceof NotFoundException) {
                ignorePddCodes = Map.of();
            }
            throw new ServiceException("Impossibile ottenere record tracciati PDND gi\u00e0 presenti", (Throwable)e);
        }
        if (!ignorePddCodes.isEmpty()) {
            this.logger.warn("Attenzione alcuni tracciati sono gia presenti nel db per questo intervallo temporale, non li rigenero: {}", ignorePddCodes);
        }
        return ignorePddCodes;
    }

    private Date getLastTracingDate(Date currDate) throws ServiceException {
        Date lastDate = null;
        try {
            lastDate = StatisticsInfoUtils.readDataUltimaGenerazioneStatistiche(this.statisticheSM.getStatisticaInfoServiceSearch(), TipoIntervalloStatistico.PDND_GENERAZIONE_TRACCIAMENTO, this.config.getLogSql());
        }
        catch (NotFoundException e) {
            lastDate = new Date(0L);
        }
        catch (NotImplementedException | ServiceException e) {
            throw new ServiceException(e);
        }
        if (lastDate.equals(new Date(0L))) {
            lastDate = this.incrementDate(currDate);
        }
        return this.truncDate(lastDate);
    }

    public void scanDates() throws NotImplementedException, ServiceException {
        Date nextDate = null;
        Date lastNoErrorDate = null;
        int delayMinutes = this.config.getPdndTracciamentoGenerazioneDelayMinutes();
        Date now = DateManager.getDate();
        if (delayMinutes > 0) {
            now = new Date(now.getTime() - (long)(delayMinutes * 60 * 1000));
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Attivo offset delay '{}', nuova 'now date' {}", (Object)delayMinutes, (Object)DateUtils.getSimpleDateFormatMs().format(now));
            }
        }
        Date currDate = this.truncDate(now);
        Date lastDate = this.getLastTracingDate(currDate);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Verifico esistenza csv gi\u00e0 generati per la data {}", (Object)this.dataTracciamentoFormat(lastDate));
        }
        Map<Date, Set<String>> ignorePddCodes = this.getAlreadyExistsPddRecords(lastDate);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Intervallo di generazione PDND tracciamento {} -> {}", (Object)this.dataTracciamentoFormat(lastDate), (Object)this.dataTracciamentoFormat(currDate));
        }
        while (lastDate.before(currDate)) {
            nextDate = this.truncDate(this.incrementDate(lastDate));
            if (!this.createRecords(lastDate, nextDate, ignorePddCodes.getOrDefault(lastDate, Set.of())) && lastNoErrorDate == null) {
                lastNoErrorDate = lastDate;
            }
            lastDate = nextDate;
        }
        this.scanDatesUpdateDataUltimaGenerazione(lastNoErrorDate, currDate);
    }

    private void scanDatesUpdateDataUltimaGenerazione(Date lastNoErrorDate, Date currDate) throws NotImplementedException, ServiceException {
        if (lastNoErrorDate == null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Aggiornamento data ultima generazione alla data corrente: {}", (Object)this.dataTracciamentoFormat(currDate));
            }
            lastNoErrorDate = currDate;
        } else if (this.logger.isInfoEnabled()) {
            this.logger.info("A causa di errori per la generazione di data: {}, la data di ultima generazione sar\u00e0 impostata a tale data", (Object)this.dataTracciamentoFormat(lastNoErrorDate));
        }
        try {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Aggiorno data ultima generazione statistiche {} ...", (Object)this.dataTracciamentoFormat(lastNoErrorDate));
            }
            StatisticsInfoUtils.updateDataUltimaGenerazioneStatistiche(this.statisticheSM.getStatisticaInfoServiceSearch(), this.statisticheSM.getStatisticaInfoService(), TipoIntervalloStatistico.PDND_GENERAZIONE_TRACCIAMENTO, this.config.getLogSql(), lastNoErrorDate);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Aggiorno daa ultima generazione statistiche {} completato", (Object)this.dataTracciamentoFormat(lastNoErrorDate));
            }
        }
        catch (Exception e) {
            this.logger.error("Errore nell'aggiornamento della data ultima statistica {}", (Object)TipoIntervalloStatistico.PDND_GENERAZIONE_TRACCIAMENTO, (Object)e);
        }
    }

    @Override
    public void generate() throws StatisticsEngineException {
        this.logger.info("********************* INIZIO GENERAZIONE TRACCIATO PDND *********************");
        try {
            this.scanDates();
        }
        catch (NotImplementedException | ServiceException e) {
            throw new StatisticsEngineException(e);
        }
        try {
            this.scanNull();
        }
        catch (ExpressionException | ExpressionNotImplementedException | NotImplementedException | ServiceException e) {
            throw new StatisticsEngineException(e);
        }
        this.logger.info("********************* FINE GENERAZIONE TRACCIATO PDND *********************");
    }

    @Override
    public boolean isEnabled(StatisticsConfig config) {
        return config.isPdndTracciamentoGenerazione();
    }

    private String dataTracciamentoFormat(Date date) {
        return new SimpleDateFormat(PDND_DATE_FORMAT).format(date);
    }
}

