/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.monitor.engine.statistic;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.monitor.engine.config.MonitorProperties;
import org.openspcoop2.monitor.engine.exceptions.EngineException;
import org.openspcoop2.monitor.engine.statistic.StatisticsForceIndexConfig;
import org.openspcoop2.monitor.engine.statistic.StatisticsGroupByConfig;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.properties.InstanceProperties;
import org.openspcoop2.utils.properties.PropertiesReader;
import org.openspcoop2.utils.transport.http.HttpRequestConfig;
import org.slf4j.Logger;

public class StatisticsConfig {
    private Logger logCore = null;
    private Logger logSql = null;
    private boolean debug = false;
    private boolean useUnionForLatency = false;
    private boolean generazioneStatisticheCustom = false;
    private boolean analisiTransazioniCustom = false;
    private long waitMsBeforeNextInterval = -1L;
    private boolean waitStatiInConsegna = false;
    private boolean statisticheOrarie = false;
    private boolean statisticheGiornaliere = false;
    private boolean statisticheSettimanali = false;
    private boolean statisticheMensili = false;
    private boolean statisticheOrarieGestioneUltimoIntervallo = false;
    private boolean statisticheGiornaliereGestioneUltimoIntervallo = false;
    private boolean statisticheSettimanaliGestioneUltimoIntervallo = false;
    private boolean statisticheMensiliGestioneUltimoIntervallo = false;
    private StatisticsForceIndexConfig forceIndexConfig = null;
    private boolean pdndTracciamentoGenerazione = false;
    private boolean pdndTracciamentoPubblicazione = false;
    private HttpRequestConfig pdndTracciamentoRequestConfig;
    private boolean pdndTracciamentoSoggettiDisabled = false;
    private Set<String> pdndTracciamentoSoggettiEnabled;
    private Integer pdndTracciamentoMaxAttempt = null;
    private List<Integer> pdndTracciamentoPendingCheck = null;
    private boolean pdndTracciamentoErogazioniEnabled = true;
    private boolean pdndTracciamentoFruizioniEnabled = true;
    private int pdndTracciamentoGenerazioneDelayMinutes = 0;
    private int pdndTracciamentoGenerazioneDbBatchSize = 200;
    private int pdndTracciamentoPubblicazioneDbBatchSize = 200;
    private StatisticsGroupByConfig groupByConfig = new StatisticsGroupByConfig();
    private static final String FALSE = "false";

    public StatisticsConfig(boolean readPropertiesFromFile) throws EngineException {
        try {
            if (readPropertiesFromFile) {
                this.logCore = LoggerWrapperFactory.getLogger((String)"org.openspcoop2.monitor.engine.statistic");
                this.logSql = LoggerWrapperFactory.getLogger((String)"org.openspcoop2.monitor.engine.statistic.sql");
                MonitorProperties props = MonitorProperties.getInstance(this.logCore);
                this.debug = "true".equals(props.getProperty("org.openspcoop2.monitor.statistic.debug", FALSE, true));
                this.useUnionForLatency = "true".equals(props.getProperty("org.openspcoop2.monitor.statistic.useUnionForLatency", FALSE, true));
                this.generazioneStatisticheCustom = "true".equals(props.getProperty("org.openspcoop2.monitor.statistic.custom.enabled", FALSE, true));
                this.analisiTransazioniCustom = "true".equals(props.getProperty("org.openspcoop2.monitor.statistic.custom.transaction.enabled", FALSE, true));
                this.statisticheOrarie = "true".equals(props.getProperty("org.openspcoop2.monitor.statistic.hourly.enabled", "true", true));
                this.statisticheGiornaliere = "true".equals(props.getProperty("org.openspcoop2.monitor.statistic.daily.enabled", "true", true));
                this.statisticheSettimanali = "true".equals(props.getProperty("org.openspcoop2.monitor.statistic.weekly.enabled", "true", true));
                this.statisticheMensili = "true".equals(props.getProperty("org.openspcoop2.monitor.statistic.monthly.enabled", "true", true));
                this.pdndTracciamentoGenerazione = StatisticsConfig.parsePdndGenerazioneTracciamentoProperty(props);
                this.pdndTracciamentoPubblicazione = StatisticsConfig.parsePdndPubblicazioneTracciamentoProperty(props);
                this.pdndTracciamentoRequestConfig = StatisticsConfig.parsePdndTracingRequestConfig(props);
                this.pdndTracciamentoSoggettiEnabled = StatisticsConfig.parsePdndTracingSoggettiEnabled(props);
                this.pdndTracciamentoSoggettiDisabled = this.parsePdndTracingSoggettiDisabled(props);
                this.pdndTracciamentoErogazioniEnabled = StatisticsConfig.parsePdndTracingErogazioniEnabled(props);
                this.pdndTracciamentoFruizioniEnabled = StatisticsConfig.parsePdndTracingFruizioniEnabled(props);
                this.pdndTracciamentoGenerazioneDelayMinutes = StatisticsConfig.parsePdndTracingGenerazioneDelayMinutes(props);
                this.pdndTracciamentoPendingCheck = this.parsePdndTracciamentoPendingCheck(props);
                this.pdndTracciamentoMaxAttempt = this.parsePdndTracciamentoMaxAttempts(props);
                this.pdndTracciamentoGenerazioneDbBatchSize = StatisticsConfig.parsePdndTracciamentoDbBatchSize(props, "org.openspcoop2.monitor.statistic.pdnd.tracciamento.generazione.db.batchSize");
                this.pdndTracciamentoPubblicazioneDbBatchSize = StatisticsConfig.parsePdndTracciamentoDbBatchSize(props, "org.openspcoop2.monitor.statistic.pdnd.tracciamento.pubblicazione.db.batchSize");
                this.pdndTracciamentoPubblicazione = "true".equals(props.getProperty("org.openspcoop2.monitor.statistic.pdnd.tracciamento.pubblicazione.enabled", "true", true));
                this.statisticheOrarieGestioneUltimoIntervallo = "true".equals(props.getProperty("org.openspcoop2.monitor.statistic.hourly.lastinterval.enabled", "true", true));
                this.statisticheGiornaliereGestioneUltimoIntervallo = "true".equals(props.getProperty("org.openspcoop2.monitor.statistic.daily.lastinterval.enabled", "true", true));
                this.statisticheSettimanaliGestioneUltimoIntervallo = "true".equals(props.getProperty("org.openspcoop2.monitor.statistic.weekly.lastinterval.enabled", "true", true));
                this.statisticheMensiliGestioneUltimoIntervallo = "true".equals(props.getProperty("org.openspcoop2.monitor.statistic.monthly.lastinterval.enabled", "true", true));
                this.groupByConfig = StatisticsConfig.parseGroupByConfig(props.getReader(), "org.openspcoop2.monitor.statistic.");
            }
        }
        catch (Exception e) {
            throw new EngineException(e.getMessage(), e);
        }
    }

    private static boolean parsePdndGenerazioneTracciamentoProperty(MonitorProperties props) throws UtilsException {
        String propId = "org.openspcoop2.monitor.statistic.pdnd.tracciamento.generazione.enabled";
        return "true".equals(props.getProperty(propId, "true", true));
    }

    private static boolean parsePdndPubblicazioneTracciamentoProperty(MonitorProperties props) throws UtilsException {
        String propId = "org.openspcoop2.monitor.statistic.pdnd.tracciamento.pubblicazione.enabled";
        return "true".equals(props.getProperty(propId, "true", true));
    }

    private static boolean parsePdndTracingErogazioniEnabled(MonitorProperties props) throws UtilsException {
        String propId = "org.openspcoop2.monitor.statistic.pdnd.tracciamento.fruizioni.enabled";
        return "true".equals(props.getProperty(propId, "true", true));
    }

    private static boolean parsePdndTracingFruizioniEnabled(MonitorProperties props) throws UtilsException {
        String propId = "org.openspcoop2.monitor.statistic.pdnd.tracciamento.erogazioni.enabled";
        return "true".equals(props.getProperty(propId, "true", true));
    }

    private static int parsePdndTracingGenerazioneDelayMinutes(MonitorProperties props) throws UtilsException {
        String propId = "org.openspcoop2.monitor.statistic.pdnd.tracciamento.generazione.delayMinutes";
        String provValue = props.getProperty(propId, "0", true);
        return Integer.valueOf(provValue);
    }

    private static int parsePdndTracciamentoDbBatchSize(MonitorProperties props, String propId) throws UtilsException {
        String provValue = props.getProperty(propId, "200", true);
        return Integer.valueOf(provValue);
    }

    private static HttpRequestConfig parsePdndTracingRequestConfig(MonitorProperties props) {
        return new HttpRequestConfig("pdnd.tracciamento", str -> {
            try {
                return props.getProperty((String)str, false, true);
            }
            catch (UtilsException e) {
                return null;
            }
        });
    }

    private static Set<String> parsePdndTracingSoggettiEnabled(MonitorProperties props) throws UtilsException {
        String propId = "org.openspcoop2.monitor.statistic.pdnd.tracciamento.soggetti.enabled";
        String value = props.getProperty(propId, "", false);
        if (value == null || StringUtils.isEmpty((CharSequence)value.trim()) || "*".equals(value.trim())) {
            return Set.of();
        }
        return Arrays.stream(value.split(",")).map(String::trim).collect(Collectors.toSet());
    }

    private boolean parsePdndTracingSoggettiDisabled(MonitorProperties props) throws UtilsException {
        String propId = "org.openspcoop2.monitor.statistic.pdnd.tracciamento.soggetti.enabled";
        String value = props.getProperty(propId, "", false);
        return value == null || StringUtils.isEmpty((CharSequence)value.trim());
    }

    private List<Integer> parsePdndTracciamentoPendingCheck(MonitorProperties props) throws UtilsException {
        String propId = "org.openspcoop2.monitor.statistic.pdnd.tracciamento.pubblicazione.pending.check";
        String value = props.getProperty(propId, "", false);
        return value == null || StringUtils.isEmpty((CharSequence)value.trim()) ? List.of(Integer.valueOf(0)) : Arrays.stream(value.split(",")).map(Integer::valueOf).collect(Collectors.toList());
    }

    private Integer parsePdndTracciamentoMaxAttempts(MonitorProperties props) throws UtilsException {
        String propId = "org.openspcoop2.monitor.statistic.pdnd.tracciamento.pubblicazione.maxAttempts";
        String value = props.getProperty(propId, "", false);
        return value == null || StringUtils.isEmpty((CharSequence)value.trim()) ? null : Integer.valueOf(value);
    }

    public static StatisticsGroupByConfig parseGroupByConfig(InstanceProperties props, String prefix) throws UtilsException {
        return StatisticsConfig.parseGroupByConfig(props, null, prefix);
    }

    public static StatisticsGroupByConfig parseGroupByConfig(PropertiesReader props, String prefix) throws UtilsException {
        return StatisticsConfig.parseGroupByConfig(null, props, prefix);
    }

    private static StatisticsGroupByConfig parseGroupByConfig(InstanceProperties propsIP, PropertiesReader propsPR, String prefix) throws UtilsException {
        StatisticsGroupByConfig config = new StatisticsGroupByConfig();
        String groupByPrefix = prefix + "groupBy.";
        config.setTipoMittente(StatisticsConfig.getBooleanProperty(propsIP, propsPR, groupByPrefix + "tipoMittente"));
        config.setNomeMittente(StatisticsConfig.getBooleanProperty(propsIP, propsPR, groupByPrefix + "nomeMittente"));
        config.setTipoDestinatario(StatisticsConfig.getBooleanProperty(propsIP, propsPR, groupByPrefix + "tipoDestinatario"));
        config.setNomeDestinatario(StatisticsConfig.getBooleanProperty(propsIP, propsPR, groupByPrefix + "nomeDestinatario"));
        config.setTipoServizio(StatisticsConfig.getBooleanProperty(propsIP, propsPR, groupByPrefix + "tipoServizio"));
        config.setServizio(StatisticsConfig.getBooleanProperty(propsIP, propsPR, groupByPrefix + "servizio"));
        config.setVersioneServizio(StatisticsConfig.getBooleanProperty(propsIP, propsPR, groupByPrefix + "versioneServizio"));
        config.setAzione(StatisticsConfig.getBooleanProperty(propsIP, propsPR, groupByPrefix + "azione"));
        config.setServizioApplicativo(StatisticsConfig.getBooleanProperty(propsIP, propsPR, groupByPrefix + "servizioApplicativo"));
        config.setTrasportoMittente(StatisticsConfig.getBooleanProperty(propsIP, propsPR, groupByPrefix + "trasportoMittente"));
        config.setTokenIssuer(StatisticsConfig.getBooleanProperty(propsIP, propsPR, groupByPrefix + "tokenIssuer"));
        config.setTokenClientId(StatisticsConfig.getBooleanProperty(propsIP, propsPR, groupByPrefix + "tokenClientId"));
        config.setTokenSubject(StatisticsConfig.getBooleanProperty(propsIP, propsPR, groupByPrefix + "tokenSubject"));
        config.setTokenUsername(StatisticsConfig.getBooleanProperty(propsIP, propsPR, groupByPrefix + "tokenUsername"));
        config.setTokenMail(StatisticsConfig.getBooleanProperty(propsIP, propsPR, groupByPrefix + "tokenMail"));
        config.setEsito(StatisticsConfig.getBooleanProperty(propsIP, propsPR, groupByPrefix + "esito"));
        config.setEsitoContesto(StatisticsConfig.getBooleanProperty(propsIP, propsPR, groupByPrefix + "esitoContesto"));
        config.setGruppo(StatisticsConfig.getBooleanProperty(propsIP, propsPR, groupByPrefix + "gruppo"));
        config.setApi(StatisticsConfig.getBooleanProperty(propsIP, propsPR, groupByPrefix + "api"));
        config.setClusterId(StatisticsConfig.getBooleanProperty(propsIP, propsPR, groupByPrefix + "clusterId"));
        config.setClientAddress(StatisticsConfig.getBooleanProperty(propsIP, propsPR, groupByPrefix + "clientAddress"));
        return config;
    }

    private static boolean getBooleanProperty(InstanceProperties propsIP, PropertiesReader propsPR, String propertyName) throws UtilsException {
        String value = null;
        if (propsIP != null) {
            value = propsIP.getValueConvertEnvProperties(propertyName);
        } else if (propsPR != null) {
            value = propsPR.getValue_convertEnvProperties(propertyName);
        }
        if (value == null) {
            return true;
        }
        return "true".equalsIgnoreCase(value.trim());
    }

    public Logger getLogCore() {
        return this.logCore;
    }

    public void setLogCore(Logger logCore) {
        this.logCore = logCore;
    }

    public Logger getLogSql() {
        return this.logSql;
    }

    public void setLogSql(Logger logSql) {
        this.logSql = logSql;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isUseUnionForLatency() {
        return this.useUnionForLatency;
    }

    public void setUseUnionForLatency(boolean useUnionForLatency) {
        this.useUnionForLatency = useUnionForLatency;
    }

    public boolean isGenerazioneStatisticheCustom() {
        return this.generazioneStatisticheCustom;
    }

    public void setGenerazioneStatisticheCustom(boolean generazioneStatisticheCustom) {
        this.generazioneStatisticheCustom = generazioneStatisticheCustom;
    }

    public boolean isStatisticheOrarie() {
        return this.statisticheOrarie;
    }

    public void setStatisticheOrarie(boolean statisticheOrarie) {
        this.statisticheOrarie = statisticheOrarie;
    }

    public boolean isStatisticheGiornaliere() {
        return this.statisticheGiornaliere;
    }

    public void setStatisticheGiornaliere(boolean statisticheGiornaliere) {
        this.statisticheGiornaliere = statisticheGiornaliere;
    }

    public boolean isStatisticheSettimanali() {
        return this.statisticheSettimanali;
    }

    public void setStatisticheSettimanali(boolean statisticheSettimanali) {
        this.statisticheSettimanali = statisticheSettimanali;
    }

    public boolean isStatisticheMensili() {
        return this.statisticheMensili;
    }

    public void setStatisticheMensili(boolean statisticheMensili) {
        this.statisticheMensili = statisticheMensili;
    }

    public boolean isStatisticheOrarieGestioneUltimoIntervallo() {
        return this.statisticheOrarieGestioneUltimoIntervallo;
    }

    public void setStatisticheOrarieGestioneUltimoIntervallo(boolean statisticheOrarieGestioneUltimoIntervallo) {
        this.statisticheOrarieGestioneUltimoIntervallo = statisticheOrarieGestioneUltimoIntervallo;
    }

    public boolean isStatisticheGiornaliereGestioneUltimoIntervallo() {
        return this.statisticheGiornaliereGestioneUltimoIntervallo;
    }

    public void setStatisticheGiornaliereGestioneUltimoIntervallo(boolean statisticheGiornaliereGestioneUltimoIntervallo) {
        this.statisticheGiornaliereGestioneUltimoIntervallo = statisticheGiornaliereGestioneUltimoIntervallo;
    }

    public boolean isStatisticheSettimanaliGestioneUltimoIntervallo() {
        return this.statisticheSettimanaliGestioneUltimoIntervallo;
    }

    public void setStatisticheSettimanaliGestioneUltimoIntervallo(boolean statisticheSettimanaliGestioneUltimoIntervallo) {
        this.statisticheSettimanaliGestioneUltimoIntervallo = statisticheSettimanaliGestioneUltimoIntervallo;
    }

    public boolean isStatisticheMensiliGestioneUltimoIntervallo() {
        return this.statisticheMensiliGestioneUltimoIntervallo;
    }

    public void setStatisticheMensiliGestioneUltimoIntervallo(boolean statisticheMensiliGestioneUltimoIntervallo) {
        this.statisticheMensiliGestioneUltimoIntervallo = statisticheMensiliGestioneUltimoIntervallo;
    }

    public boolean isAnalisiTransazioniCustom() {
        return this.analisiTransazioniCustom;
    }

    public void setAnalisiTransazioniCustom(boolean analisiTransazioniCustom) {
        this.analisiTransazioniCustom = analisiTransazioniCustom;
    }

    public StatisticsForceIndexConfig getForceIndexConfig() {
        return this.forceIndexConfig;
    }

    public void setForceIndexConfig(StatisticsForceIndexConfig forceIndexConfig) {
        this.forceIndexConfig = forceIndexConfig;
    }

    public long getWaitMsBeforeNextInterval() {
        return this.waitMsBeforeNextInterval;
    }

    public void setWaitMsBeforeNextInterval(long waitMsBeforeNextInterval) {
        this.waitMsBeforeNextInterval = waitMsBeforeNextInterval;
    }

    public boolean isWaitStatiInConsegna() {
        return this.waitStatiInConsegna;
    }

    public void setWaitStatiInConsegna(boolean waitStatiInConsegna) {
        this.waitStatiInConsegna = waitStatiInConsegna;
    }

    public boolean isPdndTracciamentoPubblicazione() {
        return this.pdndTracciamentoPubblicazione;
    }

    public void setPdndTracciamentoPubblicazione(boolean pdndPubblicazioneTracciamento) {
        this.pdndTracciamentoPubblicazione = pdndPubblicazioneTracciamento;
    }

    public boolean isPdndTracciamentoGenerazione() {
        return this.pdndTracciamentoGenerazione;
    }

    public void setPdndTracciamentoGenerazione(boolean pdndGenerazioneTracciamento) {
        this.pdndTracciamentoGenerazione = pdndGenerazioneTracciamento;
    }

    public HttpRequestConfig getPdndTracciamentoRequestConfig() {
        return this.pdndTracciamentoRequestConfig;
    }

    public void setPdndTracciamentoRequestConfig(HttpRequestConfig pdndTracingRequestConfig) {
        this.pdndTracciamentoRequestConfig = pdndTracingRequestConfig;
    }

    public void setPdndTracciamentoMaxAttempt(Integer maxAttempt) {
        this.pdndTracciamentoMaxAttempt = maxAttempt;
    }

    public Integer getPdndTracciamentoMaxAttempt() {
        return this.pdndTracciamentoMaxAttempt;
    }

    public void setPdndTracciamentoPendingCheck(List<Integer> pdndTracciamentoPendingCheck) {
        this.pdndTracciamentoPendingCheck = pdndTracciamentoPendingCheck;
    }

    public List<Integer> getPdndTracciamentoPendingCheck() {
        return this.pdndTracciamentoPendingCheck;
    }

    public void setPdndTracciamentoSoggettiEnabled(Set<String> pdndTracingSoggettiEnabled) {
        this.pdndTracciamentoSoggettiEnabled = pdndTracingSoggettiEnabled;
    }

    public Set<String> getPdndTracciamentoSoggettiEnabled() {
        return this.pdndTracciamentoSoggettiEnabled;
    }

    public boolean isPdndTracciamentoSoggettiDisabled() {
        return this.pdndTracciamentoSoggettiDisabled;
    }

    public void setPdndTracciamentoSoggettiDisabled(boolean pdndTracciamentoSoggettiDisabled) {
        this.pdndTracciamentoSoggettiDisabled = pdndTracciamentoSoggettiDisabled;
    }

    public boolean isPdndTracciamentoErogazioniEnabled() {
        return this.pdndTracciamentoErogazioniEnabled;
    }

    public void setPdndTracciamentoErogazioniEnabled(boolean pdndTracingErogazioniEnabled) {
        this.pdndTracciamentoErogazioniEnabled = pdndTracingErogazioniEnabled;
    }

    public boolean isPdndTracciamentoFruizioniEnabled() {
        return this.pdndTracciamentoFruizioniEnabled;
    }

    public void setPdndTracciamentoFruizioniEnabled(boolean pdndTracingFruizioniEnabled) {
        this.pdndTracciamentoFruizioniEnabled = pdndTracingFruizioniEnabled;
    }

    public int getPdndTracciamentoGenerazioneDelayMinutes() {
        return this.pdndTracciamentoGenerazioneDelayMinutes;
    }

    public void setPdndTracciamentoGenerazioneDelayMinutes(int pdndTracciamentoGenerazioneDelayMinutes) {
        this.pdndTracciamentoGenerazioneDelayMinutes = pdndTracciamentoGenerazioneDelayMinutes;
    }

    public int getPdndTracciamentoGenerazioneDbBatchSize() {
        return this.pdndTracciamentoGenerazioneDbBatchSize;
    }

    public void setPdndTracciamentoGenerazioneDbBatchSize(int pdndTracciamentoGenerazioneDbBatchSize) {
        this.pdndTracciamentoGenerazioneDbBatchSize = pdndTracciamentoGenerazioneDbBatchSize;
    }

    public int getPdndTracciamentoPubblicazioneDbBatchSize() {
        return this.pdndTracciamentoPubblicazioneDbBatchSize;
    }

    public void setPdndTracciamentoPubblicazioneDbBatchSize(int pdndTracciamentoPubblicazioneDbBatchSize) {
        this.pdndTracciamentoPubblicazioneDbBatchSize = pdndTracciamentoPubblicazioneDbBatchSize;
    }

    public StatisticsGroupByConfig getGroupByConfig() {
        return this.groupByConfig;
    }

    public void setGroupByConfig(StatisticsGroupByConfig groupByConfig) {
        this.groupByConfig = groupByConfig;
    }
}

