/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.monitor.engine.transaction;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.openspcoop2.core.commons.dao.DAOFactory;
import org.openspcoop2.core.tracciamento.utils.ProjectInfo;
import org.openspcoop2.core.transazioni.DumpAllegato;
import org.openspcoop2.core.transazioni.DumpContenuto;
import org.openspcoop2.core.transazioni.DumpHeaderTrasporto;
import org.openspcoop2.core.transazioni.DumpMessaggio;
import org.openspcoop2.core.transazioni.IdDumpMessaggio;
import org.openspcoop2.core.transazioni.Transazione;
import org.openspcoop2.core.transazioni.constants.TipoMessaggio;
import org.openspcoop2.core.transazioni.dao.IDumpMessaggioService;
import org.openspcoop2.core.transazioni.dao.IDumpMessaggioServiceSearch;
import org.openspcoop2.core.transazioni.dao.IServiceManager;
import org.openspcoop2.core.transazioni.dao.ITransazioneServiceSearch;
import org.openspcoop2.generic_project.beans.IProjectInfo;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.generic_project.expression.IExpression;
import org.openspcoop2.generic_project.expression.IPaginatedExpression;
import org.openspcoop2.monitor.engine.transaction.TransactionContentUtils;
import org.openspcoop2.monitor.sdk.constants.MessageType;
import org.openspcoop2.monitor.sdk.constants.TransactionExceptionCode;
import org.openspcoop2.monitor.sdk.exceptions.TransactionException;
import org.openspcoop2.monitor.sdk.transaction.AbstractContentResource;
import org.openspcoop2.monitor.sdk.transaction.Attachment;
import org.openspcoop2.monitor.sdk.transaction.AttachmentResource;
import org.openspcoop2.monitor.sdk.transaction.ContentResource;
import org.openspcoop2.monitor.sdk.transaction.SOAPEnvelopeResource;
import org.openspcoop2.monitor.sdk.transaction.Transaction;
import org.openspcoop2.monitor.sdk.transaction.TransportHeaderResource;
import org.openspcoop2.protocol.sdk.constants.RuoloMessaggio;
import org.openspcoop2.protocol.sdk.diagnostica.DriverMsgDiagnosticiNotFoundException;
import org.openspcoop2.protocol.sdk.diagnostica.FiltroRicercaDiagnosticiConPaginazione;
import org.openspcoop2.protocol.sdk.diagnostica.IDiagnosticDriver;
import org.openspcoop2.protocol.sdk.tracciamento.DriverTracciamentoNotFoundException;
import org.openspcoop2.protocol.sdk.tracciamento.ITracciaDriver;
import org.openspcoop2.protocol.sdk.tracciamento.Traccia;
import org.openspcoop2.utils.date.DateManager;
import org.slf4j.Logger;

public class TransactionManager {
    public static Transaction getTransaction(DAOFactory daoFactory, Logger log, String id, boolean debug) throws TransactionException {
        Transaction transactionInfo = null;
        ITracciaDriver driverTracciamento = null;
        IDiagnosticDriver driverDiagnostici = null;
        try {
            IServiceManager transazioniSM;
            block23: {
                HashMap<String, String> propertiesRicerca;
                block22: {
                    block21: {
                        transazioniSM = (IServiceManager)daoFactory.getServiceManager((IProjectInfo)org.openspcoop2.core.transazioni.utils.ProjectInfo.getInstance());
                        ITransazioneServiceSearch transazioniSearchDAO = transazioniSM.getTransazioneServiceSearch();
                        driverTracciamento = (ITracciaDriver)daoFactory.getServiceManager((IProjectInfo)ProjectInfo.getInstance());
                        driverDiagnostici = (IDiagnosticDriver)daoFactory.getServiceManager((IProjectInfo)org.openspcoop2.core.diagnostica.utils.ProjectInfo.getInstance());
                        IExpression exprFindTraccia = transazioniSearchDAO.newExpression();
                        exprFindTraccia.equals(Transazione.model().ID_TRANSAZIONE, (Object)id);
                        Transazione transazione = null;
                        try {
                            transazione = (Transazione)transazioniSearchDAO.find(exprFindTraccia);
                            transactionInfo = new Transaction(log, daoFactory, transazione);
                        }
                        catch (NotFoundException notFound) {
                            log.info("Transazione con id [" + id + "] non trovata: " + notFound.getMessage(), (Throwable)notFound);
                            throw new TransactionException(TransactionExceptionCode.NOT_FOUND, "Transazione con id [" + id + "] non trovata: " + notFound.getMessage(), (Throwable)notFound);
                        }
                        propertiesRicerca = new HashMap<String, String>();
                        propertiesRicerca.put("id_transazione", id);
                        Traccia tracciaRichiesta = null;
                        try {
                            tracciaRichiesta = driverTracciamento.getTraccia(RuoloMessaggio.RICHIESTA, propertiesRicerca);
                            transactionInfo.setRequestTrace(tracciaRichiesta);
                        }
                        catch (DriverTracciamentoNotFoundException notFound) {
                            if (!debug) break block21;
                            log.debug("Traccia di richiesta non trovata per la transazione con id [" + id + "]: " + notFound.getMessage(), (Throwable)notFound);
                        }
                    }
                    Traccia tracciaRisposta = null;
                    try {
                        tracciaRisposta = driverTracciamento.getTraccia(RuoloMessaggio.RISPOSTA, propertiesRicerca);
                        transactionInfo.setResponseTrace(tracciaRisposta);
                    }
                    catch (DriverTracciamentoNotFoundException notFound) {
                        if (!debug) break block22;
                        log.debug("Traccia di risposta non trovata per la transazione con id [" + id + "]: " + notFound.getMessage(), (Throwable)notFound);
                    }
                }
                FiltroRicercaDiagnosticiConPaginazione filtro = new FiltroRicercaDiagnosticiConPaginazione();
                filtro.setProperties(propertiesRicerca);
                List listDiagnostici = null;
                try {
                    listDiagnostici = driverDiagnostici.getMessaggiDiagnostici(filtro);
                    transactionInfo.setMsgdiagnosticiList(listDiagnostici);
                }
                catch (DriverMsgDiagnosticiNotFoundException notFound) {
                    if (!debug) break block23;
                    log.debug("Diagnostici non presenti per la transazione con id [" + id + "]: " + notFound.getMessage(), (Throwable)notFound);
                }
            }
            IDumpMessaggioServiceSearch dumpMessaggioSearchDAO = transazioniSM.getDumpMessaggioServiceSearch();
            TransactionManager.retrieveContentResources(dumpMessaggioSearchDAO, transactionInfo);
        }
        catch (Exception e) {
            log.error("TransactionManager.getTransaction(" + id + ") ha generato un errore: " + e.getMessage(), (Throwable)e);
            throw new TransactionException(TransactionExceptionCode.GENERIC_ERROR, e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                driverTracciamento.close();
            }
            catch (Exception exception) {}
            try {
                driverDiagnostici.close();
            }
            catch (Exception exception) {}
        }
        return transactionInfo;
    }

    public static void updateContentResources(Transaction transaction) throws TransactionException {
        try {
            List resList = transaction.getContentResourcesByType(ContentResource.class);
            if (resList.size() != 0) {
                IServiceManager transazioniSM = (IServiceManager)transaction.getDAOFactory().getServiceManager((IProjectInfo)org.openspcoop2.core.transazioni.utils.ProjectInfo.getInstance());
                IDumpMessaggioService dumpMessaggioDAO = transazioniSM.getDumpMessaggioService();
                IDumpMessaggioServiceSearch dumpMessaggioSearchDAO = transazioniSM.getDumpMessaggioServiceSearch();
                IPaginatedExpression expr = dumpMessaggioSearchDAO.newPaginatedExpression();
                expr.limit(1000).equals(DumpMessaggio.model().ID_TRANSAZIONE, (Object)transaction.getIdTransazione());
                List list = dumpMessaggioSearchDAO.findAll(expr);
                for (DumpMessaggio dumpMessaggio : list) {
                    boolean update = TransactionManager.updateResources(dumpMessaggio, transaction);
                    if (!update) continue;
                    IdDumpMessaggio idDumpMsg = new IdDumpMessaggio();
                    idDumpMsg.setIdTransazione(transaction.getIdTransazione());
                    idDumpMsg.setTipoMessaggio(dumpMessaggio.getTipoMessaggio());
                    dumpMessaggioDAO.update((Object)idDumpMsg, (Object)dumpMessaggio);
                }
            }
        }
        catch (Exception e) {
            transaction.getLogger().error("TransactionManager.updateContentResources() ha generato un errore: " + e.getMessage(), (Throwable)e);
            throw new TransactionException(TransactionExceptionCode.GENERIC_ERROR, e.getMessage(), (Throwable)e);
        }
    }

    public static boolean updateResources(DumpMessaggio dumpMessaggio, Transaction transaction) throws Exception {
        boolean update = false;
        List resList = transaction.getContentResourcesByType(ContentResource.class);
        if (resList.size() != 0) {
            List lstContenuto = dumpMessaggio.getContenutoList();
            for (DumpContenuto dumpContenuto : lstContenuto) {
                String resName = dumpContenuto.getNome();
                ContentResource resource = (ContentResource)transaction.getContentResourceByName(resName);
                if (resource != null) {
                    if (!resource.getValue().equals(TransactionContentUtils.getDumpContenutoValue(dumpContenuto))) {
                        TransactionContentUtils.setDumpContenutoValue(dumpContenuto, resource.getValue());
                        update = true;
                    }
                } else {
                    lstContenuto.remove(dumpContenuto);
                    update = true;
                }
                resList.remove(resource);
            }
            for (int i = 0; i < resList.size(); ++i) {
                ContentResource cr = (ContentResource)resList.get(i);
                if (((ContentResource)resList.get(i)).getName() == null) {
                    throw new Exception("Trovata risorsa di contenuto senza nome");
                }
                if (((ContentResource)resList.get(i)).getValue() == null) {
                    throw new Exception("Trovata risorsa di contenuto con nome [" + ((ContentResource)resList.get(i)).getName() + "] con valore non definito");
                }
                DumpContenuto c = TransactionContentUtils.createDumpContenuto(((ContentResource)resList.get(i)).getName(), ((ContentResource)resList.get(i)).getValue(), DateManager.getDate());
                if (dumpMessaggio.getTipoMessaggio().equals((Object)TipoMessaggio.RICHIESTA_INGRESSO) || dumpMessaggio.getTipoMessaggio().equals((Object)TipoMessaggio.RICHIESTA_USCITA)) {
                    if (!cr.isRequest()) continue;
                    dumpMessaggio.addContenuto(c);
                    update = true;
                    continue;
                }
                if (!cr.isResponse()) continue;
                dumpMessaggio.addContenuto(c);
                update = true;
            }
        }
        TransportHeaderResource resource = null;
        resource = TipoMessaggio.RICHIESTA_INGRESSO.equals((Object)dumpMessaggio.getTipoMessaggio()) || TipoMessaggio.RICHIESTA_USCITA.equals((Object)dumpMessaggio.getTipoMessaggio()) ? (TransportHeaderResource)transaction.getContentResourceByName("request_header") : (TransportHeaderResource)transaction.getContentResourceByName("response_header");
        ArrayList keys = new ArrayList();
        if (resource != null && resource.keys() != null && resource.keys().size() > 0) {
            keys.addAll(resource.keys());
        }
        List lstHeader = dumpMessaggio.getHeaderTrasportoList();
        block2: for (DumpHeaderTrasporto dumpHeader : lstHeader) {
            String resName = dumpHeader.getNome();
            if (resource != null) {
                String valore = resource.getProperty(resName);
                if (valore != null) {
                    if (!dumpHeader.getValore().equals(valore)) {
                        dumpHeader.setValore(valore);
                        update = true;
                    }
                } else {
                    lstHeader.remove(dumpHeader);
                    update = true;
                }
            } else {
                lstHeader.remove(dumpHeader);
                update = true;
            }
            for (int i = 0; i < keys.size(); ++i) {
                if (!((String)keys.get(i)).equals(resName)) continue;
                keys.remove(i);
                continue block2;
            }
        }
        for (int i = 0; i < keys.size(); ++i) {
            DumpHeaderTrasporto c = new DumpHeaderTrasporto();
            if (keys.get(i) == null) {
                throw new Exception("Trovato header di trasporto senza nome");
            }
            if (resource.getProperty((String)keys.get(i)) == null) {
                throw new Exception("Trovato header di trasporto con nome [" + (String)keys.get(i) + "] con valore non definito");
            }
            c.setNome((String)keys.get(i));
            c.setValore(resource.getProperty((String)keys.get(i)));
            c.setDumpTimestamp(DateManager.getDate());
            dumpMessaggio.addHeaderTrasporto(c);
            update = true;
        }
        AttachmentResource attachResource = null;
        attachResource = TipoMessaggio.RICHIESTA_INGRESSO.equals((Object)dumpMessaggio.getTipoMessaggio()) || TipoMessaggio.RICHIESTA_USCITA.equals((Object)dumpMessaggio.getTipoMessaggio()) ? (AttachmentResource)transaction.getContentResourceByName("request_attachment") : (AttachmentResource)transaction.getContentResourceByName("response_attachment");
        List cids = null;
        if (attachResource != null) {
            cids = attachResource.cids();
        }
        List lstAllegati = dumpMessaggio.getAllegatoList();
        block5: for (DumpAllegato dumpAllegato : lstAllegati) {
            String cid = dumpAllegato.getContentId();
            if (attachResource != null) {
                Attachment attach = attachResource.getAttachmentByContentId(cid);
                if (attach.isUpdated()) {
                    dumpAllegato.setContentType(attach.getContentType());
                    dumpAllegato.setAllegato(attach.getContentAsByte());
                    update = true;
                }
            } else {
                lstAllegati.remove(dumpAllegato);
                update = true;
            }
            for (int i = 0; i < cids.size(); ++i) {
                if (!((String)cids.get(i)).equals(cid)) continue;
                cids.remove(i);
                continue block5;
            }
        }
        if (cids != null) {
            for (int i = 0; i < cids.size(); ++i) {
                Attachment attach = attachResource.getAttachmentByContentId((String)cids.get(i));
                DumpAllegato c = new DumpAllegato();
                c.setAllegato(attach.getContentAsByte());
                c.setContentId(attach.getContentID());
                c.setContentType(attach.getContentType());
                c.setDumpTimestamp(DateManager.getDate());
                dumpMessaggio.addAllegato(c);
                update = true;
            }
        }
        return update;
    }

    private static void addContentResource(Transaction transaction, AbstractContentResource res) {
        try {
            transaction.addContentResource(res);
        }
        catch (TransactionException e) {
            if (TransactionExceptionCode.ADD_RES_EXIST.equals((Object)e.getCode())) {
                transaction.getLogger().error(e.getMessage(), (Throwable)e);
            }
            try {
                transaction.updateContentResource(res);
            }
            catch (TransactionException e1) {
                transaction.getLogger().error(e1.getMessage(), (Throwable)e1);
            }
        }
    }

    private static void retrieveContentResources(IDumpMessaggioServiceSearch dumpMessaggioSearchDAO, Transaction transaction) throws Exception {
        IPaginatedExpression expr = dumpMessaggioSearchDAO.newPaginatedExpression();
        expr.limit(1000).equals(DumpMessaggio.model().ID_TRANSAZIONE, (Object)transaction.getIdTransazione());
        List list = dumpMessaggioSearchDAO.findAll(expr);
        for (DumpMessaggio dumpMessaggio : list) {
            TransactionManager.setContentResourcesInTransaction(transaction, dumpMessaggio);
        }
    }

    public static void setContentResourcesInTransaction(Transaction transaction, DumpMessaggio dumpMessaggio) {
        MessageType tipoMessaggio = MessageType.valueOf((String)dumpMessaggio.getTipoMessaggioRawEnumValue());
        SOAPEnvelopeResource soapEnvelope = new SOAPEnvelopeResource(tipoMessaggio);
        TransactionManager.addContentResource(transaction, (AbstractContentResource)soapEnvelope);
        for (Object dumpContenuto : dumpMessaggio.getContenutoList()) {
            ContentResource res = new ContentResource(tipoMessaggio);
            res.setName(dumpContenuto.getNome());
            res.setValue(TransactionContentUtils.getDumpContenutoValue((DumpContenuto)dumpContenuto));
            TransactionManager.addContentResource(transaction, (AbstractContentResource)res);
        }
        TransportHeaderResource res = new TransportHeaderResource(tipoMessaggio);
        for (DumpHeaderTrasporto dumpHeader : dumpMessaggio.getHeaderTrasportoList()) {
            res.setProperty(dumpHeader.getNome(), dumpHeader.getValore());
        }
        TransactionManager.addContentResource(transaction, (AbstractContentResource)res);
        AttachmentResource attRes = new AttachmentResource(tipoMessaggio);
        for (DumpAllegato dumpAllegato : dumpMessaggio.getAllegatoList()) {
            Attachment attach = new Attachment(dumpAllegato.getAllegato(), dumpAllegato.getContentId(), dumpAllegato.getContentType());
            attRes.addAttachment(attach);
        }
        TransactionManager.addContentResource(transaction, (AbstractContentResource)attRes);
    }
}

