/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.monitor.engine.utils;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import org.openspcoop2.monitor.engine.exceptions.EngineException;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.date.DateTimeFormatterWrapper;
import org.openspcoop2.utils.date.DateUtils;

public class ContentFormatter {
    private static String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";

    public static void isSupported(Object o) throws EngineException {
        if (!(o instanceof String || o instanceof Integer || o instanceof Long || o instanceof Double || o instanceof Float || o instanceof Boolean || o instanceof Date || o instanceof Calendar || o instanceof Timestamp)) {
            throw new EngineException("Tipo [" + o.getClass().getName() + "] non supportato. I tipi supportati sono: " + String.class.getName() + "," + Integer.class.getName() + "," + Long.class.getName() + "," + Double.class.getName() + "," + Float.class.getName() + "," + Boolean.class.getName() + "," + Date.class.getName() + "," + Calendar.class.getName() + "," + Timestamp.class.getName());
        }
    }

    public static void isSupported(Object ... collections) throws EngineException {
        for (int i = 0; i < collections.length; ++i) {
            ContentFormatter.isSupported(collections[i]);
        }
    }

    public static void isSupported(Collection<?> collections) throws EngineException {
        for (Object object : collections) {
            ContentFormatter.isSupported(object);
        }
    }

    public static Collection<String> toString(Object[] o) throws EngineException {
        ArrayList<String> l = new ArrayList<String>();
        for (int i = 0; i < o.length; ++i) {
            l.add(ContentFormatter.toString(o[i]));
        }
        return l;
    }

    public static String toString(Object o) throws EngineException {
        ContentFormatter.isSupported(o);
        String oClassName = o.getClass().getName();
        if (oClassName.equals(String.class.getName())) {
            return (String)o;
        }
        if (oClassName.equals(Integer.TYPE.getName()) || oClassName.equals(Integer.class.getName())) {
            return ContentFormatter.toString((Integer)o);
        }
        if (oClassName.equals(Long.TYPE.getName()) || oClassName.equals(Long.class.getName())) {
            return ContentFormatter.toString((Long)o);
        }
        if (oClassName.equals(Double.TYPE.getName()) || oClassName.equals(Double.class.getName())) {
            return ContentFormatter.toString((Double)o);
        }
        if (oClassName.equals(Float.TYPE.getName()) || oClassName.equals(Float.class.getName())) {
            return ContentFormatter.toString((Float)o);
        }
        if (oClassName.equals(Boolean.TYPE.getName()) || oClassName.equals(Boolean.class.getName())) {
            return ContentFormatter.toString((Boolean)o);
        }
        if (oClassName.equals(Date.class.getName())) {
            return ContentFormatter.toString((Date)o);
        }
        if (oClassName.equals(Calendar.class.getName())) {
            return ContentFormatter.toString((Calendar)o);
        }
        if (oClassName.equals(Timestamp.class.getName())) {
            return ContentFormatter.toString((Timestamp)o);
        }
        throw new EngineException("Tipo [" + oClassName + "] non supportato");
    }

    public static String toString(int intValue) {
        return "" + intValue;
    }

    public static String toString(Integer intValue) {
        return ContentFormatter.toString((int)intValue);
    }

    public static String toString(long longValue) {
        return "" + longValue;
    }

    public static String toString(Long longValue) {
        return ContentFormatter.toString((long)longValue);
    }

    public static String toString(double doubleValue) {
        return "" + doubleValue;
    }

    public static String toString(Double doubleValue) {
        return ContentFormatter.toString((double)doubleValue);
    }

    public static String toString(float floatValue) {
        return "" + floatValue;
    }

    public static String toString(Float floatValue) {
        return ContentFormatter.toString(floatValue.floatValue());
    }

    public static String toString(boolean b) {
        if (b) {
            return "t";
        }
        return "f";
    }

    public static String toString(Boolean b) {
        return ContentFormatter.toString((boolean)b);
    }

    public static String toString(Date date) {
        DateTimeFormatterWrapper dateformat = DateUtils.getDefaultDateTimeFormatter((String)DATE_FORMAT);
        return dateformat.format(date);
    }

    public static String toString(Calendar calendar) {
        DateTimeFormatterWrapper dateformat = DateUtils.getDefaultDateTimeFormatter((String)DATE_FORMAT);
        return dateformat.format(calendar.getTime());
    }

    public static String toString(Timestamp t) {
        DateTimeFormatterWrapper dateformat = DateUtils.getDefaultDateTimeFormatter((String)DATE_FORMAT);
        return dateformat.format(t);
    }

    public static Integer toInteger(String v) throws EngineException {
        try {
            Integer i = null;
            if (v != null) {
                i = Integer.parseInt(v);
            }
            return i;
        }
        catch (Exception e) {
            throw new EngineException("Converting error: " + e.getMessage(), e);
        }
    }

    public static int toPrimitiveInt(String v) throws EngineException {
        try {
            int i = 0;
            if (v != null) {
                i = Integer.parseInt(v);
            }
            return i;
        }
        catch (Exception e) {
            throw new EngineException("Converting error: " + e.getMessage(), e);
        }
    }

    public static Long toLong(String v) throws EngineException {
        try {
            Long l = null;
            if (v != null) {
                l = Long.parseLong(v);
            }
            return l;
        }
        catch (Exception e) {
            throw new EngineException("Converting error: " + e.getMessage(), e);
        }
    }

    public static long toPrimitiveLong(String v) throws EngineException {
        try {
            long l = 0L;
            if (v != null) {
                l = Long.parseLong(v);
            }
            return l;
        }
        catch (Exception e) {
            throw new EngineException("Converting error: " + e.getMessage(), e);
        }
    }

    public static Double toDouble(String v) throws EngineException {
        try {
            Double d = null;
            if (v != null) {
                d = Double.parseDouble(v);
            }
            return d;
        }
        catch (Exception e) {
            throw new EngineException("Converting error: " + e.getMessage(), e);
        }
    }

    public static double toPrimitiveDouble(String v) throws EngineException {
        try {
            double d = 0.0;
            if (v != null) {
                d = Double.parseDouble(v);
            }
            return d;
        }
        catch (Exception e) {
            throw new EngineException("Converting error: " + e.getMessage(), e);
        }
    }

    public static Float toFloat(String v) throws EngineException {
        try {
            Float f = null;
            if (v != null) {
                f = Float.valueOf(Float.parseFloat(v));
            }
            return f;
        }
        catch (Exception e) {
            throw new EngineException("Converting error: " + e.getMessage(), e);
        }
    }

    public static float toPrimitiveFloat(String v) throws EngineException {
        try {
            float f = 0.0f;
            if (v != null) {
                f = Float.parseFloat(v);
            }
            return f;
        }
        catch (Exception e) {
            throw new EngineException("Converting error: " + e.getMessage(), e);
        }
    }

    public static Boolean toBoolean(String v) throws EngineException {
        try {
            Boolean b = null;
            if (v != null) {
                b = Boolean.parseBoolean(v);
            }
            return b;
        }
        catch (Exception e) {
            throw new EngineException("Converting error: " + e.getMessage(), e);
        }
    }

    public static boolean toPrimitiveBoolean(String v) throws EngineException {
        try {
            boolean b = false;
            if (v != null) {
                b = Boolean.parseBoolean(v);
            }
            return b;
        }
        catch (Exception e) {
            throw new EngineException("Converting error: " + e.getMessage(), e);
        }
    }

    public static Date toDate(String v) throws EngineException {
        try {
            Date d = null;
            if (v != null) {
                DateTimeFormatterWrapper dateformat = DateUtils.getDefaultDateTimeFormatter((String)DATE_FORMAT);
                d = dateformat.parse(v);
            }
            return d;
        }
        catch (Exception e) {
            throw new EngineException("Converting error: " + e.getMessage(), e);
        }
    }

    public static Calendar toCalendar(String v) throws EngineException {
        try {
            Calendar c = null;
            if (v != null) {
                c = DateManager.getCalendar();
                c.setTime(ContentFormatter.toDate(v));
            }
            return c;
        }
        catch (Exception e) {
            throw new EngineException("Converting error: " + e.getMessage(), e);
        }
    }

    public static Timestamp toTimestamp(String v) throws EngineException {
        try {
            Timestamp t = null;
            if (v != null) {
                t = new Timestamp(ContentFormatter.toDate(v).getTime());
            }
            return t;
        }
        catch (Exception e) {
            throw new EngineException("Converting error: " + e.getMessage(), e);
        }
    }
}

