/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.lib.audit.appender;

import java.sql.Connection;
import java.util.Properties;
import javax.sql.DataSource;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.resources.GestoreJNDI;
import org.openspcoop2.web.lib.audit.AuditException;
import org.openspcoop2.web.lib.audit.DriverAuditDBAppender;
import org.openspcoop2.web.lib.audit.appender.IAuditAppender;
import org.openspcoop2.web.lib.audit.log.Operation;
import org.openspcoop2.web.lib.audit.log.constants.Stato;

public class AuditDBAppender
implements IAuditAppender {
    private DataSource ds = null;
    private String dsName = null;
    private String tipoDatabase = null;
    private String nomeAppender = null;

    @Override
    public void initAppender(String nomeAppender, Properties properties) throws AuditException {
        try {
            this.nomeAppender = nomeAppender;
            this.dsName = properties.getProperty("datasource");
            if (this.dsName == null) {
                throw new AuditException("Appender[" + this.nomeAppender + "] Proprieta' 'datasource' non definita");
            }
            this.dsName = this.dsName.trim();
            this.tipoDatabase = properties.getProperty("tipoDatabase");
            if (this.tipoDatabase == null) {
                throw new AuditException("Appender[" + this.nomeAppender + "] Proprieta' 'tipoDatabase' non definita");
            }
            this.tipoDatabase = this.tipoDatabase.trim();
            Properties ctx = Utilities.readProperties((String)"context-", (Properties)properties);
            GestoreJNDI jndi = new GestoreJNDI(ctx);
            this.ds = (DataSource)jndi.lookup(this.dsName);
        }
        catch (AuditException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AuditException("Inizializzazione appender[" + this.nomeAppender + "] non riuscita: " + e.getMessage(), e);
        }
    }

    @Override
    public Object registraOperazioneInFaseDiElaborazione(Operation operation) throws AuditException {
        Connection con = null;
        try {
            con = this.ds.getConnection();
            this.checkConnection(con);
            DriverAuditDBAppender driverDBAppender = new DriverAuditDBAppender(con, this.tipoDatabase);
            driverDBAppender.createOperation(operation);
            Long l = operation.getId();
            return l;
        }
        catch (Exception e) {
            throw new AuditException("Appender[" + this.nomeAppender + "] Errore durante la registrazione dell'operazione: " + e.getMessage(), e);
        }
        finally {
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private void checkConnection(Connection con) throws Exception {
        if (con == null) {
            throw new Exception("Connessione non fornita dal datasource [" + this.dsName + "]");
        }
    }

    @Override
    public void registraOperazioneCompletataConSuccesso(Object idOperation) throws AuditException {
        Connection con = null;
        try {
            con = this.ds.getConnection();
            this.checkConnection(con);
            DriverAuditDBAppender driverDBAppender = new DriverAuditDBAppender(con, this.tipoDatabase);
            Operation operation = driverDBAppender.getOperation((Long)idOperation);
            operation.setStato(Stato.COMPLETED);
            operation.setTimeExecute(DateManager.getDate());
            driverDBAppender.updateOperation(operation, false);
        }
        catch (Exception e) {
            throw new AuditException("Appender[" + this.nomeAppender + "] Errore durante la registrazione dell'operazione: " + e.getMessage(), e);
        }
        finally {
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void registraOperazioneTerminataConErrore(Object idOperation, String motivoErrore) throws AuditException {
        Connection con = null;
        try {
            con = this.ds.getConnection();
            this.checkConnection(con);
            DriverAuditDBAppender driverDBAppender = new DriverAuditDBAppender(con, this.tipoDatabase);
            Operation operation = driverDBAppender.getOperation((Long)idOperation);
            operation.setStato(Stato.ERROR);
            operation.setError(motivoErrore);
            operation.setTimeExecute(DateManager.getDate());
            driverDBAppender.updateOperation(operation, false);
        }
        catch (Exception e) {
            throw new AuditException("Appender[" + this.nomeAppender + "] Errore durante la registrazione dell'operazione: " + e.getMessage(), e);
        }
        finally {
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

