/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.statistiche.bean;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.controllo_traffico.AttivazionePolicy;
import org.openspcoop2.core.controllo_traffico.ConfigurazionePolicy;
import org.openspcoop2.core.controllo_traffico.constants.TipoRisorsaPolicyAttiva;
import org.openspcoop2.generic_project.exception.NotFoundException;

public class DettaglioRateLimiting
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<String> policyName = new ArrayList<String>();
    private Map<String, AttivazionePolicy> policyMap = new HashMap<String, AttivazionePolicy>();
    private Map<String, ConfigurazionePolicy> configPolicyMap = new HashMap<String, ConfigurazionePolicy>();

    public void addDetail(AttivazionePolicy ap, ConfigurazionePolicy cp) {
        this.policyName.add(ap.getIdActivePolicy());
        this.policyMap.put(ap.getIdActivePolicy(), ap);
        this.configPolicyMap.put(ap.getIdActivePolicy(), cp);
    }

    public String getAsCSVRecord() throws NotFoundException {
        StringBuilder sb = new StringBuilder("");
        if (this.policyName != null && !this.policyName.isEmpty()) {
            for (String name : this.policyName) {
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append(this.toString(name));
            }
        }
        return sb.toString();
    }

    public String toString(String policyName) throws NotFoundException {
        StringBuilder sb = new StringBuilder();
        AttivazionePolicy ap = this.policyMap.get(policyName);
        ConfigurazionePolicy cp = this.configPolicyMap.get(policyName);
        if (StringUtils.isNotEmpty((CharSequence)ap.getAlias())) {
            sb.append(ap.getAlias());
        } else {
            sb.append(policyName);
        }
        sb.append(" ");
        if (ap.getEnabled()) {
            if (ap.isWarningOnly()) {
                sb.append("warningOnly");
            } else {
                sb.append("abilitato");
            }
        } else {
            sb.append("disabilitato");
        }
        sb.append(" ");
        TipoRisorsaPolicyAttiva tipoRisorsaPolicyAttiva = TipoRisorsaPolicyAttiva.getTipo((String)cp.getRisorsa(), (boolean)cp.isSimultanee());
        sb.append(tipoRisorsaPolicyAttiva.name());
        sb.append(" ");
        if (TipoRisorsaPolicyAttiva.DIMENSIONE_MASSIMA_MESSAGGIO.equals((Object)tipoRisorsaPolicyAttiva)) {
            if (ap.isRidefinisci()) {
                sb.append(ap.getValore2());
            } else {
                sb.append(cp.getValore2());
            }
            sb.append(" ");
        }
        if (ap.isRidefinisci()) {
            sb.append(ap.getValore());
        } else {
            sb.append(cp.getValore());
        }
        return sb.toString();
    }
}

