/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.statistiche.bean;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.faces.event.ActionEvent;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.statistiche.constants.PossibiliStatiRichieste;
import org.openspcoop2.web.monitor.core.bean.BaseSearchForm;
import org.openspcoop2.web.monitor.core.constants.Costanti;
import org.openspcoop2.web.monitor.core.constants.ModalitaRicercaTransazioni;
import org.openspcoop2.web.monitor.core.core.PddMonitorProperties;
import org.openspcoop2.web.monitor.core.core.Utility;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.openspcoop2.web.monitor.core.ricerche.ModuloRicerca;
import org.openspcoop2.web.monitor.core.utils.MessageManager;
import org.openspcoop2.web.monitor.core.utils.MessageUtils;
import org.openspcoop2.web.monitor.statistiche.constants.ModalitaRicercaStatistichePdnd;
import org.slf4j.Logger;

public class StatistichePdndTracingSearchForm
extends BaseSearchForm
implements Cloneable {
    private static Logger log = LoggerManager.getPddMonitorCoreLogger();
    private String tracingId;
    private Integer tentativiPubblicazione;
    private String stato;
    private String statoPdnd;
    private static String defaultModalitaRicerca = ModalitaRicercaStatistichePdnd.ANDAMENTO_TEMPORALE.getValue();
    private String modalitaRicerca = defaultModalitaRicerca;
    private int livelloRicerca = ModalitaRicercaStatistichePdnd.getLivello(this.modalitaRicerca);
    private boolean backRicerca = false;
    private static List<String> elencoFieldsRicercaDaIgnorare = new ArrayList<String>();

    public StatistichePdndTracingSearchForm() {
        try {
            PddMonitorProperties govwayMonitorProperties = PddMonitorProperties.getInstance((Logger)log);
            this.setUseCount(govwayMonitorProperties.isAttivoUtilizzaCountStatistichePdndTracingLista());
            this.modalitaRicerca = defaultModalitaRicerca;
            this.setLivelloRicerca(ModalitaRicercaStatistichePdnd.getLivello(this.modalitaRicerca));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void initSearchListener(ActionEvent ae) {
        super.initSearchListener(ae);
        this.executeQuery = false;
        this.modalitaRicerca = defaultModalitaRicerca;
        this.stato = "--";
        this.statoPdnd = "--";
        this.tentativiPubblicazione = null;
        this.tracingId = null;
    }

    protected String ripulisciValori() {
        this.initSearchListener(null);
        return null;
    }

    protected String eseguiAggiorna() {
        return null;
    }

    protected String eseguiFiltra() {
        return this.filtraEngine();
    }

    private String filtraEngine() {
        if (this.getPeriodo().equals("Personalizzato")) {
            if (this.getDataInizio() == null) {
                MessageUtils.addErrorMsg((String)MessageManager.getInstance().getMessage("commons.search.missing_parameters.periodo.dataInizio"));
                return null;
            }
            if (this.getDataFine() == null) {
                MessageUtils.addErrorMsg((String)MessageManager.getInstance().getMessage("commons.search.missing_parameters.periodo.dataFine"));
                return null;
            }
        }
        this.setBackRicerca(false);
        ModalitaRicercaStatistichePdnd ricerca = ModalitaRicercaStatistichePdnd.getFromString(this.getModalitaRicerca());
        if (ricerca != null) {
            switch (ricerca) {
                case TRACING_ID: {
                    if (!StringUtils.isEmpty((CharSequence)this.getTracingId())) break;
                    MessageUtils.addErrorMsg((String)MessageManager.getInstance().getMessage("statistichePdndTracing.search.missing_parameters.tracingId"));
                    return null;
                }
            }
        }
        return null;
    }

    public String getTracingId() {
        return this.tracingId;
    }

    public void setTracingId(String tracingId) {
        this.tracingId = tracingId;
    }

    public Integer getTentativiPubblicazione() {
        return this.tentativiPubblicazione;
    }

    public void setTentativiPubblicazione(Integer numeroTentativi) {
        this.tentativiPubblicazione = numeroTentativi;
    }

    public String getStato() {
        return this.stato;
    }

    public void setStato(String stato) {
        this.stato = stato;
    }

    public String getStatoPdnd() {
        return this.statoPdnd;
    }

    public void setStatoPdnd(String statoPdnd) {
        this.statoPdnd = statoPdnd;
    }

    public boolean isShowFiltroSoggetto() {
        String loggedUtenteModalita = Utility.getLoggedUtenteModalita();
        return "qualsiasi".equals(loggedUtenteModalita);
    }

    public String getProtocollo() {
        return "modipa";
    }

    public int getLivelloRicerca() {
        return this.livelloRicerca;
    }

    public void setLivelloRicerca(int livelloRicerca) {
        this.livelloRicerca = livelloRicerca;
    }

    public boolean isBackRicerca() {
        return this.backRicerca;
    }

    public void setBackRicerca(boolean backRicerca) {
        this.backRicerca = backRicerca;
    }

    public String getModalitaRicerca() {
        if (this.modalitaRicerca == null || "".equals(this.modalitaRicerca)) {
            this.modalitaRicerca = defaultModalitaRicerca;
        }
        return this.modalitaRicerca;
    }

    public void setModalitaRicerca(String modalitaRicerca) {
        this.modalitaRicerca = modalitaRicerca;
        this.setLivelloRicerca(ModalitaRicercaStatistichePdnd.getLivello(this.modalitaRicerca));
    }

    public boolean isRicercaLiberaTuttiProfili() {
        return ModalitaRicercaTransazioni.RICERCA_LIBERA.getValue().equals(this.modalitaRicerca) && this.isAllProtocol();
    }

    public String getTipoRicercaLabel() {
        if (this.getModalitaRicerca() != null) {
            ModalitaRicercaStatistichePdnd t = ModalitaRicercaStatistichePdnd.getFromString(this.getModalitaRicerca());
            switch (t) {
                case ANDAMENTO_TEMPORALE: {
                    return MessageManager.getInstance().getMessage("statistichePdndTracing.search.tipoRicerca.temporale.ricercaTemporale.breadcrumb");
                }
            }
            return MessageManager.getInstance().getMessage("statistichePdndTracing.search.tipoRicerca.id.tracingId.breadcrumb");
        }
        return "Visualizza Statistiche Tracing PDND";
    }

    public boolean isShowRicercaPanel() {
        if (this.getModalitaRicerca() != null) {
            ModalitaRicercaStatistichePdnd t = ModalitaRicercaStatistichePdnd.getFromString(this.getModalitaRicerca());
            switch (t) {
                case ANDAMENTO_TEMPORALE: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public boolean isShowFiltroStatoPdnd() {
        return this.stato != null && !this.stato.equals("--") && this.stato.equals(PossibiliStatiRichieste.PUBLISHED.getValue());
    }

    public void statoListener(ActionEvent ae) {
        if (!PossibiliStatiRichieste.PUBLISHED.equals(this.stato)) {
            this.statoPdnd = "--";
        }
    }

    public ModuloRicerca getModulo() {
        return ModuloRicerca.STATISTICHE;
    }

    public boolean isVisualizzaComandoSalvaRicerca() {
        return true;
    }

    public List<String> getElencoFieldRicercaDaIgnorare() {
        return elencoFieldsRicercaDaIgnorare;
    }

    static {
        elencoFieldsRicercaDaIgnorare.addAll(Arrays.asList(Costanti.SEARCH_FORM_FIELDS_DA_NON_SALVARE));
    }
}

