/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.statistiche.bean;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.model.SelectItem;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.commons.dao.DAOFactory;
import org.openspcoop2.core.commons.search.AccordoServizioParteSpecifica;
import org.openspcoop2.core.commons.search.IdAccordoServizioParteComune;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.statistiche.constants.TipoReport;
import org.openspcoop2.core.statistiche.utils.ProjectInfo;
import org.openspcoop2.generic_project.beans.IProjectInfo;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.monitor.engine.condition.EsitoUtils;
import org.openspcoop2.monitor.engine.config.statistiche.ConfigurazioneStatistica;
import org.openspcoop2.monitor.engine.dynamic.DynamicFactory;
import org.openspcoop2.monitor.engine.dynamic.IDynamicFilter;
import org.openspcoop2.monitor.engine.dynamic.IDynamicLoader;
import org.openspcoop2.monitor.engine.dynamic.IDynamicValidator;
import org.openspcoop2.monitor.sdk.condition.Context;
import org.openspcoop2.monitor.sdk.condition.IFilter;
import org.openspcoop2.monitor.sdk.condition.StatisticsContext;
import org.openspcoop2.monitor.sdk.constants.CRUDType;
import org.openspcoop2.monitor.sdk.constants.SearchType;
import org.openspcoop2.monitor.sdk.constants.StatisticType;
import org.openspcoop2.monitor.sdk.exceptions.SearchException;
import org.openspcoop2.monitor.sdk.exceptions.ValidationException;
import org.openspcoop2.monitor.sdk.parameters.Parameter;
import org.openspcoop2.protocol.sdk.builder.EsitoTransazione;
import org.openspcoop2.protocol.utils.EsitiProperties;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.web.monitor.core.constants.Costanti;
import org.openspcoop2.web.monitor.core.core.Utility;
import org.openspcoop2.web.monitor.core.dynamic.Statistiche;
import org.openspcoop2.web.monitor.core.dynamic.components.BaseComponent;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.openspcoop2.web.monitor.core.ricerche.ModuloRicerca;
import org.openspcoop2.web.monitor.core.utils.MessageUtils;
import org.openspcoop2.web.monitor.statistiche.bean.StatsSearchForm;
import org.openspcoop2.web.monitor.statistiche.constants.StatisticheCostanti;
import org.openspcoop2.web.monitor.statistiche.dao.IStatisticaPersonalizzataService;
import org.openspcoop2.web.monitor.statistiche.mbean.StatsPersonalizzateBean;
import org.slf4j.Logger;

public class StatistichePersonalizzateSearchForm
extends StatsSearchForm
implements StatisticsContext {
    private static Logger log = LoggerManager.getPddMonitorCoreLogger();
    private IFilter filtroReport;
    private IStatisticaPersonalizzataService service;
    private Map<String, Statistiche> tabellaStatistichePersonalizzate = new HashMap<String, Statistiche>();
    private List<Parameter<?>> statisticaSelezionataParameters = new ArrayList();
    private String[] valoriRisorsa = null;
    private StatsPersonalizzateBean mBean = null;
    private static List<String> elencoFieldsRicercaDaIgnorare = new ArrayList<String>();

    @Override
    public TipiDatabase getDatabaseType() {
        return this._getTipoDatabase((IProjectInfo)ProjectInfo.getInstance());
    }

    public void setService(IStatisticaPersonalizzataService service) {
        this.service = service;
    }

    public void setFiltroReport(IFilter filtroReport) {
        this.filtroReport = filtroReport;
    }

    public IFilter getFiltroReport() {
        return this.filtroReport;
    }

    public StatistichePersonalizzateSearchForm() {
        super.setModalitaTemporale(StatisticType.GIORNALIERA);
        this.setTipoReport(TipoReport.BAR_CHART);
    }

    public void initSearchForm() {
        this.setTipoReport(TipoReport.BAR_CHART);
        this.tabellaStatistichePersonalizzate = new HashMap<String, Statistiche>();
        this.statisticaSelezionataParameters = new ArrayList();
        this.setStatistichePersonalizzate(null);
        this.setStatisticaSelezionata(null);
        this.setFiltro(null);
    }

    @Override
    public void initSearchListener(ActionEvent ae) {
        super.initSearchListener(ae);
        this.setTipoReport(TipoReport.BAR_CHART);
    }

    private Map<String, Statistiche> leggiStatistiche(IDAccordo idAccordo, String nomeServizioKey) {
        try {
            if (this.tabellaStatistichePersonalizzate != null && this.tabellaStatistichePersonalizzate.size() > 0) {
                return this.tabellaStatistichePersonalizzate;
            }
            if (this.tabellaStatistichePersonalizzate == null) {
                this.tabellaStatistichePersonalizzate = new HashMap<String, Statistiche>();
            }
            List<ConfigurazioneStatistica> stats = this.service.getStatisticheByValues(idAccordo, nomeServizioKey, this.getNomeAzione());
            Statistiche statistiche = new Statistiche();
            if (stats != null && !stats.isEmpty()) {
                for (ConfigurazioneStatistica s : stats) {
                    statistiche.addStatistica(s);
                }
                this.tabellaStatistichePersonalizzate.put(nomeServizioKey, statistiche);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return this.tabellaStatistichePersonalizzate;
    }

    @Override
    public void tipologiaRicercaListener(ActionEvent ae) {
        super.tipologiaRicercaListener(ae);
        this.setStatistichePersonalizzate(null);
        this.setStatistichePersonalizzate(null);
        this.setFiltro(null);
    }

    public void servizioSelected(ActionEvent ae) {
        try {
            super.servizioSelected(ae);
            this.setStatisticaSelezionata(null);
            this.setStatistichePersonalizzate(null);
            this.setNomeStatisticaPersonalizzata(null);
            this.statisticaSelezionataParameters = new ArrayList();
            this.setFiltro(null);
            this.tabellaStatistichePersonalizzate = null;
            String nomeServizioKey = null;
            IDAccordo idAccordo = null;
            Statistiche r = null;
            if (this.getNomeServizio() != null) {
                IDServizio idServizio = Utility.parseServizioSoggetto((String)this.getNomeServizio());
                String nomeServizio = idServizio.getNome();
                AccordoServizioParteSpecifica aspsFromValues = this.getAspsFromNomeServizio(idServizio);
                nomeServizioKey = aspsFromValues.getPortType() != null ? aspsFromValues.getPortType() : nomeServizio;
                idAccordo = this.getIDAccordoFromAsps(aspsFromValues);
                Map<String, Statistiche> ms = this.leggiStatistiche(idAccordo, nomeServizioKey);
                if (ms != null) {
                    r = ms.get(nomeServizioKey);
                }
                if (r != null) {
                    List statistiche = r.getStatistiche();
                    for (ConfigurazioneStatistica statistica : statistiche) {
                        List<Parameter<?>> params = null;
                        try {
                            params = this.service.instanceParameters(statistica, (Context)this);
                        }
                        catch (Exception e) {
                            log.error(e.getMessage(), (Throwable)e);
                        }
                        if (params == null || params.size() <= 0) continue;
                        for (Parameter<?> searchParam : params) {
                            ((BaseComponent)searchParam).setContext((Context)this);
                        }
                    }
                }
            }
            this.setStatistichePersonalizzate(r);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public List<Parameter<?>> getStatisticaSelezionataParameters() {
        if (this.statisticaSelezionataParameters != null && this.statisticaSelezionataParameters.size() > 0) {
            return this.statisticaSelezionataParameters;
        }
        try {
            if (this.getStatisticaSelezionata() != null) {
                ConfigurazioneStatistica s = this.getStatisticaSelezionata();
                this.statisticaSelezionataParameters = this.service.instanceParameters(s, (Context)this);
                if (this.statisticaSelezionataParameters != null) {
                    for (Parameter<?> searchParam : this.statisticaSelezionataParameters) {
                        ((BaseComponent)searchParam).setContext((Context)this);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return this.statisticaSelezionataParameters;
    }

    public boolean isStatisticaSelezionataParametersRequired() {
        if (this.statisticaSelezionataParameters != null && this.statisticaSelezionataParameters.size() > 0) {
            try {
                for (Parameter<?> searchParam : this.statisticaSelezionataParameters) {
                    if (!searchParam.getRendering().isRequired()) continue;
                    return true;
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return false;
    }

    public void azioneSelected(ActionEvent ae) {
        try {
            super.azioneSelected(ae);
            this.setNomeStatisticaPersonalizzata(null);
            this.setStatisticaSelezionata(null);
            this.statisticaSelezionataParameters = new ArrayList();
            this.setStatistichePersonalizzate(null);
            this.setFiltro(null);
            this.tabellaStatistichePersonalizzate = null;
            String nomeServizioKey = null;
            IDAccordo idAccordo = null;
            Statistiche r = null;
            if (this.getNomeServizio() != null) {
                IDServizio idServizio = Utility.parseServizioSoggetto((String)this.getNomeServizio());
                String nomeServizio = idServizio.getNome();
                AccordoServizioParteSpecifica aspsFromValues = this.getAspsFromNomeServizio(idServizio);
                nomeServizioKey = aspsFromValues.getPortType() != null ? aspsFromValues.getPortType() : nomeServizio;
                idAccordo = this.getIDAccordoFromAsps(aspsFromValues);
                Map<String, Statistiche> ms = this.leggiStatistiche(idAccordo, nomeServizioKey);
                if (ms != null) {
                    r = ms.get(nomeServizioKey);
                }
                if (r != null) {
                    List statistiche = r.getStatistiche();
                    for (ConfigurazioneStatistica statistica : statistiche) {
                        List<Parameter<?>> params = null;
                        try {
                            params = this.service.instanceParameters(statistica, (Context)this);
                        }
                        catch (Exception e) {
                            log.error(e.getMessage(), (Throwable)e);
                        }
                        if (params == null || params.size() <= 0) continue;
                        for (Parameter<?> searchParam : params) {
                            ((BaseComponent)searchParam).setContext((Context)this);
                        }
                    }
                }
            }
            this.setStatistichePersonalizzate(r);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void statisticaSelezionataListener(ActionEvent ae) {
        super.statisticaSelezionataListener(ae);
        this.statisticaSelezionataParameters = new ArrayList();
        this.setFiltroReport(null);
        this.tipoReportSelected(ae);
    }

    @Override
    protected String eseguiFiltra() {
        try {
            if (this.getPeriodo().equals("Personalizzato")) {
                if (this.getDataInizio() == null) {
                    MessageUtils.addErrorMsg((String)"Selezionare Data Inizio");
                    return null;
                }
                if (this.getDataFine() == null) {
                    MessageUtils.addErrorMsg((String)"Selezionare Data Fine");
                    return null;
                }
            }
            if (StringUtils.isEmpty((CharSequence)this.getNomeServizio()) || this.getNomeServizio().equals("--")) {
                MessageUtils.addErrorMsg((String)"Selezionare il Servizio.");
                return null;
            }
            boolean sezioneDatiMittente = this.validaSezioneDatiMittente();
            if (!sezioneDatiMittente) {
                return null;
            }
            if (this.getStatistichePersonalizzate() == null) {
                MessageUtils.addErrorMsg((String)"Non sono presenti statistiche personalizzate.");
                return null;
            }
            if (this.getStatistichePersonalizzate().getStatistiche() != null && this.getStatistichePersonalizzate().getStatistiche().size() > 0 && this.getStatisticaSelezionata() == null) {
                MessageUtils.addErrorMsg((String)"Selezionare una Statistica.");
                return null;
            }
            if (this.getTipoReport().equals((Object)TipoReport.ANDAMENTO_TEMPORALE) && (this.getValoriRisorsa() == null || this.getValoriRisorsa().length == 0)) {
                MessageUtils.addErrorMsg((String)"E' necessario selezionare almeno un Valore Risorsa.");
                return null;
            }
            IDynamicValidator bv = DynamicFactory.getInstance().newDynamicValidator(this.getStatisticaSelezionata().getPlugin().getTipoPlugin(), this.getStatisticaSelezionata().getPlugin().getTipo(), this.getStatisticaSelezionata().getPlugin().getClassName(), log);
            bv.validate((Context)this);
            IDynamicFilter bf = DynamicFactory.getInstance().newDynamicFilter(this.getStatisticaSelezionata().getPlugin().getTipoPlugin(), this.getStatisticaSelezionata().getPlugin().getTipo(), this.getStatisticaSelezionata().getPlugin().getClassName(), log);
            IFilter r = bf.createConditionFilter((Context)this);
            if (r != null) {
                this.setFiltroReport(r);
            }
        }
        catch (ValidationException e) {
            MessageUtils.addErrorMsg((String)e.getMessage());
            Map errors = e.getErrors();
            if (errors != null) {
                Set keys = errors.keySet();
                for (String key : keys) {
                    Parameter<?> sp = this.getParameter(key);
                    String errorMsg = (String)errors.get(key);
                    String label = sp != null ? sp.getRendering().getLabel() : key;
                    MessageUtils.addErrorMsg((String)(label + ": " + errorMsg));
                }
            }
            return null;
        }
        catch (SearchException re) {
            String msg = re.getMessage();
            MessageUtils.addErrorMsg((String)msg);
            return null;
        }
        this.dataInizioDellaRicerca = this.getDataInizio();
        this.dataFineDellaRicerca = this.getDataFine();
        this.periodoDellaRicerca = this.getPeriodo();
        return this.getAction();
    }

    public String getAzione() {
        return this.getNomeAzione();
    }

    public EsitoTransazione getEsitoTransazione() {
        Integer esitoDettaglio = this.getEsitoDettaglio();
        if (esitoDettaglio != null && EsitoUtils.ALL_VALUE.intValue() != esitoDettaglio.intValue()) {
            try {
                return EsitiProperties.getInstanceFromProtocolName((Logger)this.getLogger(), (String)this.getProtocollo()).convertToEsitoTransazione(this.getEsitoDettaglio(), this.getEsitoContesto());
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return null;
    }

    public String getInterfaccia() {
        return null;
    }

    public TipoPdD getRuolo() {
        return null;
    }

    public Date getIntervalloInferiore() {
        return this.getDataInizio();
    }

    public Date getIntervalloSuperiore() {
        return this.getDataFine();
    }

    public Parameter<?> getParameter(String paramID) {
        return this.getParameters().get(paramID);
    }

    public Map<String, Parameter<?>> getParameters() {
        TreeMap map = new TreeMap();
        if (this.getStatisticaSelezionataParameters() != null) {
            for (Parameter<?> param : this.getStatisticaSelezionataParameters()) {
                map.put(param.getId(), param);
            }
        }
        return map;
    }

    public String getTipoServizio() {
        return this.estraiTipoServizioDalServizio();
    }

    public String getServizio() {
        return this.estraiNomeServizioDalServizio();
    }

    public Integer getVersioneServizio() {
        return this.estraiVersioneServizioDalServizio();
    }

    public String getTipoSoggettoDestinatario() {
        return this.getTipoDestinatario();
    }

    public String getSoggettoDestinatario() {
        return this.getNomeDestinatario();
    }

    public String getTipoSoggettoMittente() {
        return this.getTipoMittente();
    }

    public String getSoggettoMittente() {
        return this.getNomeMittente();
    }

    public SearchType getTipoRicerca() {
        if (this.getTipologiaRicercaEnum() != null) {
            switch (this.getTipologiaRicercaEnum()) {
                case ingresso: {
                    return SearchType.EROGAZIONE;
                }
                case uscita: {
                    return SearchType.FRUIZIONE;
                }
            }
            return SearchType.ALL;
        }
        return SearchType.ALL;
    }

    public List<SelectItem> getIntervalliTemporali() {
        ArrayList<SelectItem> res = new ArrayList<SelectItem>();
        if (this.getStatisticaSelezionata() != null) {
            List listaStatisticTypes = new ArrayList();
            try {
                IDynamicLoader bl = DynamicFactory.getInstance().newDynamicLoader(this.getStatisticaSelezionata().getPlugin().getTipoPlugin(), this.getStatisticaSelezionata().getPlugin().getTipo(), this.getStatisticaSelezionata().getPlugin().getClassName(), log);
                listaStatisticTypes = bl.getEnabledStatisticType((Context)this);
            }
            catch (SearchException e) {
                log.error("Errore durante la lettura dei tipi di statistica: " + e.getMessage(), (Throwable)e);
            }
            for (StatisticType statisticType : listaStatisticTypes) {
                switch (statisticType) {
                    case GIORNALIERA: {
                        res.add(new SelectItem((Object)"giornaliera", "Giornaliera"));
                        break;
                    }
                    case MENSILE: {
                        res.add(new SelectItem((Object)"mensile", "Mensile"));
                        break;
                    }
                    case ORARIA: {
                        res.add(new SelectItem((Object)"oraria", "Oraria"));
                        break;
                    }
                    case SETTIMANALE: {
                        res.add(new SelectItem((Object)"settimanale", "Settimanale"));
                    }
                }
            }
        } else {
            res.add(new SelectItem((Object)"oraria", "Oraria"));
            res.add(new SelectItem((Object)"giornaliera", "Giornaliera"));
            res.add(new SelectItem((Object)"settimanale", "Settimanale"));
            res.add(new SelectItem((Object)"mensile", "Mensile"));
        }
        return res;
    }

    public void validateSelectedPlugin(FacesContext context, UIComponent component, Object value) {
        if (value != null) {
            String nomeStatistica = (String)value;
            ConfigurazioneStatistica r = this.getStatistichePersonalizzate().getStatisticaByLabel(nomeStatistica);
            try {
                if (r != null) {
                    DynamicFactory.getInstance().newDynamicLoader(r.getPlugin().getTipoPlugin(), r.getPlugin().getTipo(), r.getPlugin().getClassName(), log);
                }
            }
            catch (SearchException e) {
                String msg = "Impossibile selezionare la statistica (" + nomeStatistica + "). La classe indicata [" + r.getPlugin().getClassName() + "] non esiste.";
                ((UIInput)component).setValid(false);
                context.addMessage(component.getClientId(context), new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, null));
            }
        }
    }

    public void hasValideStatistichePersonalizzateByNomeServizio(FacesContext context, UIComponent component, Object value) {
        try {
            if (value == null) {
                this.setNomeServizio(null);
            }
            if (value != null) {
                String nomeServizio = (String)value;
                this.setNomeServizio(nomeServizio);
                if (this.getNomeServizio() != null) {
                    IDServizio idServizio = Utility.parseServizioSoggetto((String)this.getNomeServizio());
                    nomeServizio = idServizio.getNome();
                    AccordoServizioParteSpecifica aspsFromValues = this.getAspsFromNomeServizio(idServizio);
                    String nomeServizioKey = aspsFromValues.getPortType() != null ? aspsFromValues.getPortType() : nomeServizio;
                    IDAccordo idAccordo = this.getIDAccordoFromAsps(aspsFromValues);
                    Statistiche s = null;
                    Map<String, Statistiche> ms = this.leggiStatistiche(idAccordo, nomeServizioKey);
                    if (ms != null) {
                        s = ms.get(nomeServizioKey);
                    }
                    if (s == null || s.getStatistiche() == null || s.getStatistiche().size() < 1) {
                        String msg = "Non sono presenti statistiche personalizzate per il servizio selezionato [" + nomeServizio + "]. Provare a selezionare un'azione.";
                        ((UIInput)component).setValid(true);
                        context.addMessage("errorMessageServizio", new FacesMessage(FacesMessage.SEVERITY_WARN, msg, null));
                    }
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void hasValideStatistichePersonalizzateByNomeAzione(FacesContext context, UIComponent component, Object value) {
        if (value != null && !"--".equals(value)) {
            String nomeAzione = (String)value;
            this.setNomeAzione(nomeAzione);
            String nomeServizioKey = null;
            IDAccordo idAccordo = null;
            Statistiche s = null;
            boolean valid = true;
            try {
                if (this.getNomeServizio() != null) {
                    IDServizio idServizio = Utility.parseServizioSoggetto((String)this.getNomeServizio());
                    String nomeServizio = idServizio.getNome();
                    AccordoServizioParteSpecifica aspsFromValues = this.getAspsFromNomeServizio(idServizio);
                    nomeServizioKey = aspsFromValues.getPortType() != null ? aspsFromValues.getPortType() : nomeServizio;
                    idAccordo = this.getIDAccordoFromAsps(aspsFromValues);
                    Map<String, Statistiche> ms = this.leggiStatistiche(idAccordo, nomeServizioKey);
                    if (ms != null) {
                        s = ms.get(nomeServizioKey);
                    }
                    if (s == null || s.getStatistiche() == null || s.getStatistiche().size() < 1) {
                        valid = false;
                    }
                    Iterator it = context.getMessages("errorMessageServizio");
                    while (it.hasNext()) {
                        it.next();
                        it.remove();
                    }
                    String msg = "Non sono presenti statistiche personalizzate per l'azione selezionata [" + nomeAzione + "] del servizio [" + this.getNomeServizio() + "].";
                    ((UIInput)component).setValid(valid);
                    if (!valid) {
                        context.addMessage(component.getClientId(context), new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, null));
                    }
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public String[] getValoriRisorsa() {
        return this.valoriRisorsa;
    }

    public void setValoriRisorsa(String[] valoreRisorsa) {
        this.valoriRisorsa = valoreRisorsa;
    }

    @Override
    public void tipoReportSelected(ActionEvent ae) {
        this.valoriRisorsa = null;
        if (this.getTipoReport().equals((Object)TipoReport.ANDAMENTO_TEMPORALE) && this.getStatisticaSelezionata() != null) {
            List<String> valoriRisorse = null;
            try {
                valoriRisorse = this.mBean.getValoriRisorseAsString();
            }
            catch (ServiceException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            if (valoriRisorse != null && !valoriRisorse.isEmpty()) {
                this.valoriRisorsa = new String[1];
                this.valoriRisorsa[0] = valoriRisorse.get(0);
            }
        }
    }

    public void validateSelectedValoriRisorsa(FacesContext context, UIComponent component, Object value) {
        boolean valid = true;
        if (this.getTipoReport().equals((Object)TipoReport.ANDAMENTO_TEMPORALE) && this.getStatisticaSelezionata() != null) {
            String[] valori;
            valid = false;
            if (value != null && (valori = (String[])value).length > 0) {
                valid = true;
            }
        }
        if (!valid) {
            String msg = "E' necessario selezionare almeno un Valore Risorsa";
            ((UIInput)component).setValid(false);
            context.addMessage(component.getClientId(context), new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, null));
        }
    }

    public void setmBean(StatsPersonalizzateBean mBean) {
        this.mBean = mBean;
    }

    public StatsPersonalizzateBean getmBean() {
        return this.mBean;
    }

    private IDAccordo getIDAccordoFromAsps(AccordoServizioParteSpecifica aspsFromValues) throws DriverRegistroServiziException {
        IdAccordoServizioParteComune idAccordoServizioParteComune = aspsFromValues.getIdAccordoServizioParteComune();
        Integer ver = idAccordoServizioParteComune.getVersione();
        String nomeSoggettoReferente = null;
        String tipoSoggettoReferente = null;
        if (idAccordoServizioParteComune.getIdSoggetto() != null) {
            nomeSoggettoReferente = idAccordoServizioParteComune.getIdSoggetto().getNome();
            tipoSoggettoReferente = idAccordoServizioParteComune.getIdSoggetto().getTipo();
        }
        String nomeAS = idAccordoServizioParteComune.getNome();
        IDAccordo idAccordo = IDAccordoFactory.getInstance().getIDAccordoFromValues(nomeAS, tipoSoggettoReferente, nomeSoggettoReferente, ver);
        return idAccordo;
    }

    public Logger getLogger() {
        return LoggerManager.getPddMonitorCoreLogger();
    }

    public DAOFactory getDAOFactory() {
        try {
            return DAOFactory.getInstance((Logger)LoggerManager.getPddMonitorSqlLogger());
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public CRUDType getTipoOperazione() {
        return CRUDType.SEARCH;
    }

    @Override
    public ModuloRicerca getModulo() {
        return ModuloRicerca.STATISTICHE_PERSONALIZZATE;
    }

    @Override
    public String getModalitaRicerca() {
        return this.getTipoDistribuzione();
    }

    @Override
    public boolean isVisualizzaComandoSalvaRicerca() {
        return true;
    }

    @Override
    public List<String> getElencoFieldRicercaDaIgnorare() {
        return elencoFieldsRicercaDaIgnorare;
    }

    static {
        elencoFieldsRicercaDaIgnorare.addAll(Arrays.asList(Costanti.SEARCH_FORM_FIELDS_DA_NON_SALVARE));
        elencoFieldsRicercaDaIgnorare.addAll(Arrays.asList(StatisticheCostanti.SEARCH_FORM_FIELDS_DA_NON_SALVARE));
        elencoFieldsRicercaDaIgnorare.addAll(Arrays.asList(StatisticheCostanti.STATISTICHE_PERSONALIZZATE_SEARCH_FORM_FIELDS_DA_NON_SALVARE));
    }
}

