/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.statistiche.bean;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.event.ActionEvent;
import javax.faces.model.SelectItem;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.statistiche.constants.TipoBanda;
import org.openspcoop2.core.statistiche.constants.TipoLatenza;
import org.openspcoop2.core.statistiche.constants.TipoReport;
import org.openspcoop2.core.statistiche.constants.TipoStatistica;
import org.openspcoop2.core.statistiche.constants.TipoVisualizzazione;
import org.openspcoop2.core.statistiche.utils.ProjectInfo;
import org.openspcoop2.core.transazioni.utils.TipoCredenzialeMittente;
import org.openspcoop2.generic_project.beans.IProjectInfo;
import org.openspcoop2.generic_project.expression.SortOrder;
import org.openspcoop2.monitor.engine.condition.EsitoUtils;
import org.openspcoop2.monitor.sdk.constants.StatisticType;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.utils.EsitiProperties;
import org.openspcoop2.utils.SortedMap;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.web.monitor.core.bean.AbstractDateSearchForm;
import org.openspcoop2.web.monitor.core.bean.BaseSearchForm;
import org.openspcoop2.web.monitor.core.constants.Costanti;
import org.openspcoop2.web.monitor.core.constants.TipologiaRicerca;
import org.openspcoop2.web.monitor.core.core.PddMonitorProperties;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.openspcoop2.web.monitor.core.ricerche.ModuloRicerca;
import org.openspcoop2.web.monitor.core.utils.MessageManager;
import org.openspcoop2.web.monitor.core.utils.MessageUtils;
import org.openspcoop2.web.monitor.statistiche.bean.DimensioneCustom;
import org.openspcoop2.web.monitor.statistiche.bean.NumeroDimensioni;
import org.openspcoop2.web.monitor.statistiche.constants.StatisticheCostanti;
import org.openspcoop2.web.monitor.statistiche.utils.StatsUtils;
import org.slf4j.Logger;

public class StatsSearchForm
extends BaseSearchForm {
    private static Logger log = LoggerManager.getPddMonitorCoreLogger();
    private TipoReport tipoReport;
    protected String _value_tipoReport;
    private Boolean opened;
    private StatisticType modalitaTemporale;
    protected String _value_modalitaTemporale;
    private TipoVisualizzazione tipoVisualizzazione;
    protected String _value_tipoVisualizzazione;
    private TipoBanda tipoBanda;
    protected String _value_tipoBanda;
    private String[] tipiBanda;
    private TipoLatenza tipoLatenza;
    protected String _value_tipoLatenza;
    private String[] tipiLatenza;
    private TipoStatistica tipoStatistica;
    protected String _value_tipoStatistica;
    private NumeroDimensioni numeroDimensioni;
    protected String _value_numeroDimensioni;
    private DimensioneCustom numeroDimensioniCustom;
    protected String _value_numeroDimensioniCustom;
    private boolean distribuzionePerSoggettoRemota = true;
    private boolean andamentoTemporalePerEsiti = false;
    private boolean isMostraUnitaTempoDistribuzioneNonTemporale = false;
    private boolean isMostraUnitaTempoDistribuzioneNonTemporale_periodoPersonalizzato = false;
    private boolean distribuzionePerImplementazioneApi = true;
    private boolean statisticheLatenzaPortaEnabled = false;
    private String tipoDistribuzione = "temporale";
    private static List<String> elencoFieldsRicercaDaIgnorare = new ArrayList<String>();
    protected Date dataInizioDellaRicerca = null;
    protected Date dataFineDellaRicerca = null;
    protected String periodoDellaRicerca = null;
    private String action = null;

    public boolean isStatisticheLatenzaPortaEnabled() {
        return this.statisticheLatenzaPortaEnabled;
    }

    public void setStatisticheLatenzaPortaEnabled(boolean statisticheLatenzaPortaEnabled) {
        this.statisticheLatenzaPortaEnabled = statisticheLatenzaPortaEnabled;
    }

    public boolean isDistribuzionePerImplementazioneApi() {
        return this.distribuzionePerImplementazioneApi;
    }

    public void setDistribuzionePerImplementazioneApi(boolean distribuzionePerImplementazioneApi) {
        this.distribuzionePerImplementazioneApi = distribuzionePerImplementazioneApi;
    }

    public boolean isAndamentoTemporalePerEsiti() {
        return this.andamentoTemporalePerEsiti;
    }

    public void setAndamentoTemporalePerEsiti(boolean andamentoTemporalePerEsiti) {
        this.andamentoTemporalePerEsiti = andamentoTemporalePerEsiti;
    }

    public boolean isDistribuzionePerSoggettoRemota() {
        return this.distribuzionePerSoggettoRemota;
    }

    public void setDistribuzionePerSoggettoRemota(boolean distribuzionePerSoggettoRemota) {
        this.distribuzionePerSoggettoRemota = distribuzionePerSoggettoRemota;
    }

    public StatsSearchForm() {
        this.setPeriodo(this.getPeriodoDefault() != null ? this.getPeriodoDefault() : "Ultimo mese");
        this.tipoReport = TipoReport.BAR_CHART;
        this.numeroDimensioni = NumeroDimensioni.DIMENSIONI_2;
        this.numeroDimensioniCustom = null;
        this.setSortOrder(SortOrder.ASC);
        this.tipoVisualizzazione = TipoVisualizzazione.NUMERO_TRANSAZIONI;
        this.tipoLatenza = TipoLatenza.LATENZA_TOTALE;
        this.tipoBanda = TipoBanda.COMPLESSIVA;
        this.modalitaTemporale = StatisticType.GIORNALIERA;
        this.setTipiLatenza(new String[3]);
        try {
            PddMonitorProperties govwayMonitorProperties = PddMonitorProperties.getInstance((Logger)log);
            this.initIdClusterAndCanali(govwayMonitorProperties);
            this.isMostraUnitaTempoDistribuzioneNonTemporale = govwayMonitorProperties.isMostraUnitaTempoDistribuzioneNonTemporale();
            if (!this.isMostraUnitaTempoDistribuzioneNonTemporale) {
                this.isMostraUnitaTempoDistribuzioneNonTemporale_periodoPersonalizzato = govwayMonitorProperties.isMostraUnitaTempoDistribuzioneNonTemporale_periodoPersonalizzato();
            }
            this.statisticheLatenzaPortaEnabled = govwayMonitorProperties.isStatisticheLatenzaPortaEnabled();
        }
        catch (Exception e) {
            log.error("Errore il calcolo della proprieta' 'useDistribuzioneStatisticaGiornalieraPerElaborazioneSettimanaleMensile': " + e.getMessage(), (Throwable)e);
        }
    }

    public String getPeriodoDellaRicerca() {
        return this.periodoDellaRicerca;
    }

    public Date getDataInizioDellaRicerca() {
        return this.dataInizioDellaRicerca;
    }

    public Date getDataFineDellaRicerca() {
        return this.dataFineDellaRicerca;
    }

    public List<SelectItem> getEsitiGruppo() {
        if (this.tipoStatistica != null && this.tipoStatistica.equals((Object)TipoStatistica.DISTRIBUZIONE_ERRORI)) {
            ArrayList<SelectItem> list = new ArrayList<SelectItem>();
            try {
                EsitoUtils esitoUtils = new EsitoUtils(log, this.getSafeProtocol());
                list.add(new SelectItem((Object)EsitoUtils.ALL_ERROR_FAULT_APPLICATIVO_VALUE, esitoUtils.getEsitoLabelFromValue((Object)EsitoUtils.ALL_ERROR_FAULT_APPLICATIVO_VALUE, false)));
                list.add(new SelectItem((Object)EsitoUtils.ALL_ERROR_VALUE, esitoUtils.getEsitoLabelFromValue((Object)EsitoUtils.ALL_ERROR_VALUE, false)));
                list.add(new SelectItem((Object)EsitoUtils.ALL_FAULT_APPLICATIVO_VALUE, esitoUtils.getEsitoLabelFromValue((Object)EsitoUtils.ALL_FAULT_APPLICATIVO_VALUE, false)));
                list.add(new SelectItem((Object)EsitoUtils.ALL_ERROR_CONSEGNA_VALUE, esitoUtils.getEsitoLabelFromValue((Object)EsitoUtils.ALL_ERROR_CONSEGNA_VALUE, false)));
                list.add(new SelectItem((Object)EsitoUtils.ALL_ERROR_RICHIESTE_SCARTATE_VALUE, esitoUtils.getEsitoLabelFromValue((Object)EsitoUtils.ALL_ERROR_RICHIESTE_SCARTATE_VALUE, false)));
                list.add(new SelectItem((Object)EsitoUtils.ALL_PERSONALIZZATO_VALUE, esitoUtils.getEsitoLabelFromValue((Object)EsitoUtils.ALL_PERSONALIZZATO_VALUE, false)));
                return list;
            }
            catch (Exception e) {
                log.error("Errore durante il recupero della lista dei gruppi di esito " + e.getMessage(), (Throwable)e);
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return super.getEsitiGruppo();
    }

    public List<SelectItem> getEsitiDettaglio() {
        Integer esitoGruppo;
        if (this.tipoStatistica != null && this.tipoStatistica.equals((Object)TipoStatistica.DISTRIBUZIONE_ERRORI) && (esitoGruppo = this.getEsitoGruppo()) != null && (EsitoUtils.ALL_VALUE.intValue() == this.getEsitoGruppo().intValue() || EsitoUtils.ALL_OK_VALUE.intValue() == this.getEsitoGruppo().intValue())) {
            this.setEsitoGruppo(EsitoUtils.ALL_ERROR_FAULT_APPLICATIVO_VALUE);
        }
        return super.getEsitiDettaglio(true);
    }

    protected List<Integer> getEsitiOrderLabel() throws Exception {
        if (this.tipoStatistica != null && this.tipoStatistica.equals((Object)TipoStatistica.DISTRIBUZIONE_ERRORI)) {
            EsitiProperties esitiProperties = EsitiProperties.getInstanceFromProtocolName((Logger)log, (String)this.getSafeProtocol());
            List esiti = esitiProperties.getEsitiCodeOrderLabel();
            List esitiOk = esitiProperties.getEsitiCodeOk_senzaFaultApplicativo();
            if (esiti != null && !esiti.isEmpty()) {
                ArrayList<Integer> esitiErrori = new ArrayList<Integer>();
                for (Integer esito : esiti) {
                    boolean found = false;
                    for (Integer esitoOk : esitiOk) {
                        if (esito.intValue() != esitoOk.intValue()) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    esitiErrori.add(esito);
                }
                return esitiErrori;
            }
            return esiti;
        }
        return super.getEsitiOrderLabel();
    }

    public List<SelectItem> getEsitiDettagliPersonalizzati() {
        return super.getEsitiDettagliPersonalizzati(true);
    }

    public List<SelectItem> getListaDistribuzioneTokenClaim() {
        ArrayList<SelectItem> lst = new ArrayList<SelectItem>();
        MessageManager mm = MessageManager.getInstance();
        boolean showPDNDFilters = this.isShowPDNDFilters();
        lst.add(new SelectItem((Object)"--", "--"));
        lst.add(new SelectItem((Object)TipoCredenzialeMittente.TOKEN_ISSUER.getRawValue(), mm.getMessage("transazioni.search.sezioneFiltroRicercaLibera.tokenInfo.issuer.label")));
        lst.add(new SelectItem((Object)TipoCredenzialeMittente.TOKEN_CLIENT_ID.getRawValue(), mm.getMessage("transazioni.search.sezioneFiltroRicercaLibera.tokenInfo.clientID.label")));
        if (showPDNDFilters) {
            lst.add(new SelectItem((Object)TipoCredenzialeMittente.PDND_ORGANIZATION_NAME.getRawValue(), mm.getMessage("stats.search.claim.clientIdConPDND")));
        }
        lst.add(new SelectItem((Object)TipoCredenzialeMittente.TOKEN_SUBJECT.getRawValue(), mm.getMessage("transazioni.search.sezioneFiltroRicercaLibera.tokenInfo.subject.label")));
        lst.add(new SelectItem((Object)TipoCredenzialeMittente.TOKEN_USERNAME.getRawValue(), mm.getMessage("transazioni.search.sezioneFiltroRicercaLibera.tokenInfo.username.label")));
        lst.add(new SelectItem((Object)TipoCredenzialeMittente.TOKEN_EMAIL.getRawValue(), mm.getMessage("transazioni.search.sezioneFiltroRicercaLibera.tokenInfo.email.label")));
        return lst;
    }

    protected String eseguiFiltra() {
        if (!this.validateForm(this.tipoStatistica.equals((Object)TipoStatistica.DISTRIBUZIONE_SERVIZIO_APPLICATIVO))) {
            return null;
        }
        if (this.numeroDimensioni != null && NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.numeroDimensioni.getValue()) && this.numeroDimensioniCustom == null) {
            MessageUtils.addErrorMsg((String)MessageManager.getInstance().getMessage("commons.search.missing_parameters.3dInfo"));
            return null;
        }
        this.dataInizioDellaRicerca = this.getDataInizio();
        this.dataFineDellaRicerca = this.getDataFine();
        this.periodoDellaRicerca = this.getPeriodo();
        if (this.action != null) {
            return this.action;
        }
        return null;
    }

    public boolean validaSezioneDatiMittenteCustom() {
        if (StringUtils.isNotEmpty((CharSequence)this.getRiconoscimento())) {
            if (!this.getRiconoscimento().equals("soggetto")) {
                if (this.getRiconoscimento().equals("applicativo")) {
                    if (StringUtils.isEmpty((CharSequence)this.getIdentificazione())) {
                        MessageUtils.addErrorMsg((String)MessageManager.getInstance().getMessage("commons.search.missing_parameters.identificazione"));
                        return false;
                    }
                } else if (!this.getRiconoscimento().equals("identificativoAutenticato") && !this.getRiconoscimento().equals("ip") && StringUtils.isEmpty((CharSequence)this.getTokenClaim())) {
                    MessageUtils.addErrorMsg((String)MessageManager.getInstance().getMessage("commons.search.missing_parameters.claim"));
                    return false;
                }
            }
        } else {
            MessageUtils.addErrorMsg((String)MessageManager.getInstance().getMessage("commons.search.missing_parameters.tipo"));
            return false;
        }
        return true;
    }

    public void tipologiaRicercaListener(ActionEvent ae) {
        String oldRiconoscimento = this.getRiconoscimento();
        super.tipologiaRicercaListener(ae);
        if (this.tipoStatistica.equals((Object)TipoStatistica.DISTRIBUZIONE_SERVIZIO_APPLICATIVO)) {
            this.setRiconoscimento(oldRiconoscimento);
        }
    }

    protected boolean isTipologiaRicercaEntrambiEnabled() {
        return true;
    }

    public List<SelectItem> getListaTipiRiconoscimento() {
        boolean searchModeByApplicativo;
        ArrayList<SelectItem> lst = new ArrayList<SelectItem>();
        lst.add(new SelectItem((Object)"--", "--"));
        boolean searchModeBySoggetto = TipologiaRicerca.ingresso.equals((Object)this.getTipologiaRicercaEnum());
        boolean bl = searchModeByApplicativo = !TipologiaRicerca.ingresso.equals((Object)this.getTipologiaRicercaEnum()) || this.isProtocolloSupportaApplicativoInErogazione();
        if (!TipologiaRicerca.ingresso.equals((Object)this.getTipologiaRicercaEnum()) && !TipologiaRicerca.uscita.equals((Object)this.getTipologiaRicercaEnum())) {
            searchModeBySoggetto = false;
            searchModeByApplicativo = false;
        }
        if (searchModeBySoggetto && this.tipoStatistica != null && (this.tipoStatistica.equals((Object)TipoStatistica.DISTRIBUZIONE_SOGGETTO) || this.tipoStatistica.equals((Object)TipoStatistica.DISTRIBUZIONE_SERVIZIO_APPLICATIVO)) && this.distribuzionePerSoggettoRemota) {
            searchModeBySoggetto = false;
            searchModeByApplicativo = false;
        }
        lst.add(new SelectItem((Object)"tokenInfo", MessageManager.getInstance().getMessage("commons.tokenInfo.label")));
        if (searchModeBySoggetto) {
            lst.add(new SelectItem((Object)"soggetto", MessageManager.getInstance().getMessage("commons.soggetto.label")));
        }
        if (searchModeByApplicativo) {
            lst.add(new SelectItem((Object)"applicativo", MessageManager.getInstance().getMessage("commons.applicativo.label")));
        }
        lst.add(new SelectItem((Object)"identificativoAutenticato", MessageManager.getInstance().getMessage("commons.identificativoAutenticato.label")));
        lst.add(new SelectItem((Object)"ip", MessageManager.getInstance().getMessage("commons.indirizzoIP.label")));
        return lst;
    }

    private boolean isProtocolloSupportaApplicativoInErogazione() {
        String protocolloSelezionato = this.getProtocollo();
        boolean protocolloSupportaApplicativoinErogazione = false;
        try {
            protocolloSupportaApplicativoinErogazione = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(protocolloSelezionato).createProtocolConfiguration().isSupportoAutenticazioneApplicativiErogazioni();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return protocolloSupportaApplicativoinErogazione;
    }

    public boolean isShowTipologia() {
        if (this.tipoStatistica.equals((Object)TipoStatistica.DISTRIBUZIONE_SERVIZIO_APPLICATIVO) && this.getRiconoscimento() != null && this.getRiconoscimento().equals("applicativo")) {
            return this.isProtocolloSupportaApplicativoInErogazione();
        }
        return true;
    }

    public void setRiconoscimento(String riconoscimento) {
        super.setRiconoscimento(riconoscimento);
        if (this.tipoStatistica.equals((Object)TipoStatistica.DISTRIBUZIONE_SERVIZIO_APPLICATIVO) && this.getRiconoscimento() != null && this.getRiconoscimento().equals("applicativo") && !this.isProtocolloSupportaApplicativoInErogazione()) {
            this.setTipologiaRicerca(TipologiaRicerca.uscita);
        }
    }

    public String getPrintPeriodo() {
        Date inizio = null;
        if (this.dataInizio != null) {
            inizio = (Date)this.dataInizio.clone();
        }
        Date fine = null;
        if (this.dataFine != null) {
            fine = (Date)this.dataFine.clone();
        }
        return AbstractDateSearchForm.printPeriodo((Date)inizio, fine);
    }

    public TipiDatabase getDatabaseType() {
        return this._getTipoDatabase((IProjectInfo)ProjectInfo.getInstance());
    }

    public void periodoListener(ActionEvent ae) {
        if (!this.isShowUnitaTempo()) {
            this.modalitaTemporale = !this.isPeriodoPersonalizzato() ? (this.isPeriodoUltime12ore() ? StatisticType.ORARIA : StatisticType.GIORNALIERA) : StatisticType.ORARIA;
        }
        this._setPeriodo();
        this.dataInizioDellaRicerca = this.getDataInizio();
        this.dataFineDellaRicerca = this.getDataFine();
        this.periodoDellaRicerca = this.getPeriodo();
    }

    public void modalitaTemporaleListener(ActionEvent ae) {
        switch (this.modalitaTemporale) {
            case GIORNALIERA: {
                this.setPeriodo("Ultima settimana");
                break;
            }
            case MENSILE: {
                this.setPeriodo("Ultimo anno");
                break;
            }
            case SETTIMANALE: {
                this.setPeriodo("Ultimo mese");
                break;
            }
            case ORARIA: {
                this.setPeriodo("Ultime 12 ore");
            }
        }
        this.periodoListener(ae);
        this.dataInizioDellaRicerca = this.getDataInizio();
        this.dataFineDellaRicerca = this.getDataFine();
        this.periodoDellaRicerca = this.getPeriodo();
    }

    public void modalitaTemporaleListenerPersonalizzato(ActionEvent ae) {
        this.periodoListener(ae);
        switch (this.modalitaTemporale) {
            case ORARIA: {
                if (this.dataFine == null) break;
                Calendar fine = Calendar.getInstance();
                fine.setTime(this.dataFine);
                fine.set(11, 23);
                fine.set(12, 59);
                this.dataFine = fine.getTime();
            }
        }
        this.dataInizioDellaRicerca = this.getDataInizio();
        this.dataFineDellaRicerca = this.getDataFine();
        this.periodoDellaRicerca = this.getPeriodo();
    }

    public void initSearchListener(ActionEvent ae) {
        super.initSearchListener(ae);
        this.tipoReport = !this.tipoStatistica.equals((Object)TipoStatistica.ANDAMENTO_TEMPORALE) ? TipoReport.BAR_CHART : (this.andamentoTemporalePerEsiti ? TipoReport.BAR_CHART : TipoReport.LINE_CHART);
        this.numeroDimensioni = NumeroDimensioni.DIMENSIONI_2;
        this.numeroDimensioniCustom = null;
        this.setSortOrder(SortOrder.ASC);
        this.tipoVisualizzazione = TipoVisualizzazione.NUMERO_TRANSAZIONI;
        this.tipoLatenza = TipoLatenza.LATENZA_TOTALE;
        this.tipoBanda = TipoBanda.COMPLESSIVA;
        this.modalitaTemporale = StatisticType.GIORNALIERA;
        this.setPeriodo(this.getPeriodoDefault() != null ? this.getPeriodoDefault() : "Ultimo mese");
        this.setTipiLatenza(new String[3]);
        this.getTipiLatenza()[0] = "0";
        this.getTipiLatenza()[2] = null;
        this.getTipiLatenza()[1] = null;
        this.periodoListener(ae);
        this.dataInizioDellaRicerca = this.getDataInizio();
        this.dataFineDellaRicerca = this.getDataFine();
        this.periodoDellaRicerca = this.getPeriodo();
        if (this.tipoStatistica.equals((Object)TipoStatistica.DISTRIBUZIONE_SERVIZIO_APPLICATIVO) && this.getRiconoscimento() != null && this.getRiconoscimento().equals("applicativo") && !this.isProtocolloSupportaApplicativoInErogazione()) {
            this.setTipologiaRicerca(TipologiaRicerca.uscita);
        }
        this.setTipologiaRicerca("--");
        this.clusterId = null;
        this.canale = null;
    }

    protected String ripulisciValori() {
        this.initSearchListener(null);
        this.setTipologiaRicerca("--");
        return null;
    }

    protected String eseguiAggiorna() {
        return null;
    }

    public void tipoVisualizzazioneListener(ActionEvent ae) {
        this.tipoLatenza = TipoLatenza.LATENZA_TOTALE;
        this.setTipiLatenza(new String[3]);
        this.getTipiLatenza()[0] = "0";
        this.getTipiLatenza()[2] = null;
        this.getTipiLatenza()[1] = null;
        this.tipoBanda = TipoBanda.COMPLESSIVA;
        this.setTipiBanda(new String[3]);
        this.getTipiBanda()[0] = "0";
        this.getTipiBanda()[2] = null;
        this.getTipiBanda()[1] = null;
        this.numeroDimensioni = NumeroDimensioni.DIMENSIONI_2;
        this.numeroDimensioniCustom = null;
    }

    public void numeroDimensioniListener(ActionEvent ae) {
        this.numeroDimensioniCustom = null;
    }

    public void claimSelected(ActionEvent ae) {
        this.numeroDimensioniCustom = null;
    }

    public void identificazioneSelected(ActionEvent ae) {
        super.identificazioneSelected(ae);
        this.numeroDimensioniCustom = null;
    }

    public void tipoLatenzaListener(ActionEvent ae) {
    }

    public void tipoLatenzaCBListener(ActionEvent ae) {
        boolean ok = false;
        for (String tipoLat : this.getTipiLatenza()) {
            if (!StringUtils.isNotEmpty((CharSequence)tipoLat)) continue;
            ok = true;
            break;
        }
        if (!ok) {
            this.setTipiLatenza(new String[3]);
            this.getTipiLatenza()[0] = "0";
            this.getTipiLatenza()[2] = null;
            this.getTipiLatenza()[1] = null;
        }
    }

    public void tipoBandaListener(ActionEvent ae) {
    }

    public void tipoBandaCBListener(ActionEvent ae) {
        boolean ok = false;
        for (String tipoLat : this.getTipiBanda()) {
            if (!StringUtils.isNotEmpty((CharSequence)tipoLat)) continue;
            ok = true;
            break;
        }
        if (!ok) {
            this.setTipiBanda(new String[3]);
            this.getTipiBanda()[0] = "0";
            this.getTipiBanda()[2] = null;
            this.getTipiBanda()[1] = null;
        }
    }

    public TipoVisualizzazione getTipoVisualizzazione() {
        return this.tipoVisualizzazione;
    }

    public void setTipoVisualizzazione(TipoVisualizzazione tipoVisualizzazione) {
        this.tipoVisualizzazione = tipoVisualizzazione;
    }

    public String get_value_tipoVisualizzazione() {
        if (this.tipoVisualizzazione == null) {
            return null;
        }
        return this.tipoVisualizzazione.toString();
    }

    public void set_value_tipoVisualizzazione(String _value_tipoVisualizzazione) {
        this.tipoVisualizzazione = (TipoVisualizzazione)TipoVisualizzazione.toEnumConstantFromString((String)_value_tipoVisualizzazione);
    }

    public TipoLatenza getTipoLatenza() {
        return this.tipoLatenza;
    }

    public void setTipoLatenza(TipoLatenza tipoLatenza) {
        this.tipoLatenza = tipoLatenza;
    }

    public TipoBanda getTipoBanda() {
        return this.tipoBanda;
    }

    public void setTipoBanda(TipoBanda tipoBanda) {
        this.tipoBanda = tipoBanda;
    }

    public Boolean getOpened() {
        return this.opened;
    }

    public void setOpened(Boolean opened) {
        this.opened = opened;
    }

    public String get_value_tipoLatenza() {
        if (this.tipoLatenza == null) {
            return null;
        }
        return this.tipoLatenza.toString();
    }

    public void set_value_tipoLatenza(String _value_tipoLatenza) {
        this.tipoLatenza = (TipoLatenza)TipoLatenza.toEnumConstantFromString((String)_value_tipoLatenza);
    }

    public String[] getTipiLatenza() {
        return this.tipiLatenza;
    }

    public void setTipiLatenza(String[] tipiLatenza) {
        this.tipiLatenza = tipiLatenza;
    }

    public List<TipoLatenza> getTipiLatenzaImpostati() {
        ArrayList<TipoLatenza> lst = new ArrayList<TipoLatenza>();
        if (this.getTipiLatenza() != null) {
            for (String tipoLat : this.getTipiLatenza()) {
                if (tipoLat == null) continue;
                if (tipoLat.equals("0")) {
                    lst.add(TipoLatenza.LATENZA_TOTALE);
                }
                if (tipoLat.equals("1")) {
                    lst.add(TipoLatenza.LATENZA_SERVIZIO);
                }
                if (!tipoLat.equals("2")) continue;
                lst.add(TipoLatenza.LATENZA_PORTA);
            }
        }
        return lst;
    }

    public Map<String, String> getHeaderColonneTipiLatenzaImpostati() {
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.getTipiLatenza() != null) {
            int i = 0;
            for (String tipoLat : this.getTipiLatenza()) {
                if (tipoLat == null) continue;
                if (tipoLat.equals("0")) {
                    map.put("" + i, "Latenza Media Totale");
                }
                if (tipoLat.equals("1")) {
                    map.put("" + i, "Tempo Medio Risposta Servizio");
                }
                if (tipoLat.equals("2")) {
                    map.put("" + i, "Latenza Media Porta");
                }
                ++i;
            }
        }
        return map;
    }

    public String get_value_tipoBanda() {
        if (this.tipoBanda == null) {
            return null;
        }
        return this.tipoBanda.toString();
    }

    public void set_value_tipoBanda(String _value_tipoBanda) {
        this.tipoBanda = (TipoBanda)TipoBanda.toEnumConstantFromString((String)_value_tipoBanda);
    }

    public String[] getTipiBanda() {
        return this.tipiBanda;
    }

    public void setTipiBanda(String[] tipiBanda) {
        this.tipiBanda = tipiBanda;
    }

    public List<TipoBanda> getTipiBandaImpostati() {
        ArrayList<TipoBanda> lst = new ArrayList<TipoBanda>();
        if (this.getTipiBanda() != null) {
            for (String tipoBanda : this.getTipiBanda()) {
                if (tipoBanda == null) continue;
                if (tipoBanda.equals("0")) {
                    lst.add(TipoBanda.COMPLESSIVA);
                }
                if (tipoBanda.equals("1")) {
                    lst.add(TipoBanda.INTERNA);
                }
                if (!tipoBanda.equals("2")) continue;
                lst.add(TipoBanda.ESTERNA);
            }
        }
        return lst;
    }

    public Map<String, String> getHeaderColonneTipiBandaImpostati() {
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.getTipiBanda() != null) {
            int i = 0;
            for (String tipoBanda : this.getTipiBanda()) {
                if (tipoBanda == null) continue;
                if (tipoBanda.equals("0")) {
                    map.put("" + i, TipoBanda.COMPLESSIVA.getValue());
                }
                if (tipoBanda.equals("1")) {
                    map.put("" + i, TipoBanda.INTERNA.getValue());
                }
                if (tipoBanda.equals("2")) {
                    map.put("" + i, TipoBanda.ESTERNA.getValue());
                }
                ++i;
            }
        }
        return map;
    }

    public Map<String, String> getHeaderColonneEsiti() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("0", "Ok");
        map.put("1", "Fault Applicativo");
        map.put("2", "Fallite");
        return map;
    }

    public StatisticType getModalitaTemporale() {
        return this.modalitaTemporale;
    }

    public void setModalitaTemporale(StatisticType modalitaTemporale) {
        this.modalitaTemporale = modalitaTemporale;
    }

    public String get_value_modalitaTemporale() {
        if (this.modalitaTemporale == null) {
            return null;
        }
        return this.modalitaTemporale.toString().toLowerCase();
    }

    public void set_value_modalitaTemporale(String _value_modalitaTemporale) {
        this.modalitaTemporale = StringUtils.isNotEmpty((CharSequence)_value_modalitaTemporale) ? StatisticType.valueOf((String)_value_modalitaTemporale.toUpperCase()) : null;
    }

    public StatisticType getStatisticType() {
        return this.getModalitaTemporale();
    }

    public TipoReport getTipoReport() {
        return this.tipoReport;
    }

    public void setTipoReport(TipoReport tipoReport) {
        this.tipoReport = tipoReport;
        this.setSortOrder(SortOrder.ASC);
        boolean useCount = true;
        if (this.tipoReport != null && this.tipoReport.equals((Object)TipoReport.TABELLA)) {
            this.setSortOrder(SortOrder.DESC);
            if (TipoStatistica.DISTRIBUZIONE_SERVIZIO_APPLICATIVO.equals((Object)this.tipoStatistica)) {
                TipoCredenzialeMittente tcm;
                if ("applicativo".equals(this.getRiconoscimento()) && "commons.identificazione.token.label".equals(this.getIdentificazione())) {
                    useCount = false;
                } else if ("tokenInfo".equals(this.getRiconoscimento()) && (tcm = TipoCredenzialeMittente.toEnumConstant((String)this.getTokenClaim())) != null && TipoCredenzialeMittente.PDND_ORGANIZATION_NAME.equals((Object)tcm)) {
                    useCount = false;
                }
            }
        }
        this.setUseCount(useCount);
    }

    public String get_value_tipoReport() {
        if (this.tipoReport == null) {
            return null;
        }
        return this.tipoReport.toString();
    }

    public void set_value_tipoReport(String _value_tipoReport) {
        TipoReport tr = (TipoReport)TipoReport.toEnumConstantFromString((String)_value_tipoReport);
        this.setTipoReport(tr);
    }

    public void tipoReportSelected(ActionEvent ae) {
        if (ae != null) {
            // empty if block
        }
        this.numeroDimensioni = NumeroDimensioni.DIMENSIONI_2;
        this.numeroDimensioniCustom = null;
    }

    public TipoStatistica getTipoStatistica() {
        return this.tipoStatistica;
    }

    public void setTipoStatistica(TipoStatistica tipoStatistica) {
        this.tipoStatistica = tipoStatistica;
        if (tipoStatistica != null) {
            this.tipoReport = !this.tipoStatistica.equals((Object)TipoStatistica.ANDAMENTO_TEMPORALE) ? TipoReport.BAR_CHART : (this.andamentoTemporalePerEsiti ? TipoReport.BAR_CHART : TipoReport.LINE_CHART);
        }
    }

    public String get_value_tipoStatistica() {
        if (this.tipoStatistica == null) {
            return null;
        }
        return this.tipoStatistica.toString();
    }

    public void set_value_tipoStatistica(String _value_tipoStatistica) {
        TipoStatistica tr = (TipoStatistica)TipoStatistica.toEnumConstantFromString((String)_value_tipoStatistica);
        this.setTipoStatistica(tr);
    }

    protected void _setPeriodo() {
        super._setPeriodo();
        this._normalizeDataInizio();
        this._normalizeDataFine();
    }

    private void _normalizeDataInizio() {
        if (this.dataInizio != null) {
            Calendar inizio = Calendar.getInstance();
            inizio.setTime(this.dataInizio);
            boolean esisteCampionamentoStatisticoMinuti = false;
            if (!(esisteCampionamentoStatisticoMinuti && StatisticType.ORARIA.equals((Object)this.modalitaTemporale) && this.isPeriodoPersonalizzato() && this.isLastPeriodoPersonalizzato())) {
                inizio.clear(12);
            }
            inizio.clear(13);
            inizio.clear(14);
            if (this.modalitaTemporale != null) {
                switch (this.modalitaTemporale) {
                    case ORARIA: {
                        break;
                    }
                    case GIORNALIERA: 
                    case MENSILE: 
                    case SETTIMANALE: {
                        inizio.clear(11);
                        inizio.set(11, 0);
                    }
                }
            }
            this.dataInizio = inizio.getTime();
        }
    }

    private void _normalizeDataFine() {
        if (this.dataFine != null) {
            Calendar fine = Calendar.getInstance();
            fine.setTime(this.dataFine);
            boolean esisteCampionamentoStatisticoMinuti = false;
            if (!(esisteCampionamentoStatisticoMinuti && StatisticType.ORARIA.equals((Object)this.modalitaTemporale) && this.isPeriodoPersonalizzato() && this.isLastPeriodoPersonalizzato())) {
                fine.set(12, 59);
            }
            fine.set(13, 59);
            fine.set(14, 999);
            if (this.modalitaTemporale != null) {
                switch (this.modalitaTemporale) {
                    case ORARIA: {
                        break;
                    }
                    case GIORNALIERA: 
                    case MENSILE: 
                    case SETTIMANALE: {
                        fine.set(11, 23);
                    }
                }
            }
            this.dataFine = fine.getTime();
        }
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void tornaAiFiltri(ActionEvent ae) {
        Date dataInizioDellaRicerca = this.getDataInizioDellaRicerca();
        Date dataFineDellaRicerca = this.getDataFineDellaRicerca();
        String periodoDellaRicerca = this.getPeriodoDellaRicerca();
        this.setDataInizio(dataInizioDellaRicerca);
        this.setDataFine(dataFineDellaRicerca);
        this.setPeriodo(periodoDellaRicerca);
    }

    public String getDateFormatPeriodoPersonalizzato() {
        if (this.modalitaTemporale != null) {
            switch (this.modalitaTemporale) {
                case ORARIA: {
                    return "yyyy-MM-dd HH:mm";
                }
            }
            if (!(TipoStatistica.ANDAMENTO_TEMPORALE.equals((Object)this.tipoStatistica) || this.isMostraUnitaTempoDistribuzioneNonTemporale || this.isMostraUnitaTempoDistribuzioneNonTemporale_periodoPersonalizzato)) {
                return "yyyy-MM-dd HH:mm";
            }
            return "yyyy-MM-dd";
        }
        return "yyyy-MM-dd";
    }

    public boolean isShowGroupByDatiMittente() {
        return this.tipoStatistica.equals((Object)TipoStatistica.DISTRIBUZIONE_SERVIZIO_APPLICATIVO);
    }

    public boolean isShowUnitaTempo() {
        return TipoStatistica.ANDAMENTO_TEMPORALE.equals((Object)this.tipoStatistica) || this.isMostraUnitaTempoDistribuzioneNonTemporale;
    }

    public boolean isShowUnitaTempoPersonalizzato() {
        return !this.isShowUnitaTempo() && this.isPeriodoPersonalizzato() && this.isMostraUnitaTempoDistribuzioneNonTemporale_periodoPersonalizzato;
    }

    public boolean isShowUnitaTempoPersonalizzato_periodoPersonalizzato() {
        return this.isMostraUnitaTempoDistribuzioneNonTemporale_periodoPersonalizzato;
    }

    public List<SelectItem> getDimensioniDisponibili() {
        ArrayList<SelectItem> dimensioniDisponibili = new ArrayList<SelectItem>();
        dimensioniDisponibili.add(new SelectItem((Object)NumeroDimensioni.DIMENSIONI_2.toString(), MessageManager.getInstance().getMessage("stats.search.numeroDimensioni.2d.label")));
        dimensioniDisponibili.add(new SelectItem((Object)NumeroDimensioni.DIMENSIONI_3.toString(), MessageManager.getInstance().getMessage("stats.search.numeroDimensioni.3d.label")));
        dimensioniDisponibili.add(new SelectItem((Object)NumeroDimensioni.DIMENSIONI_3_CUSTOM.toString(), MessageManager.getInstance().getMessage("stats.search.numeroDimensioni.3dCustom.label")));
        return dimensioniDisponibili;
    }

    public String get_value_numeroDimensioni() {
        if (this.numeroDimensioni == null) {
            return null;
        }
        return this.numeroDimensioni.toString();
    }

    public void set_value_numeroDimensioni(String valueNumeroDimensioni) {
        NumeroDimensioni nd = (NumeroDimensioni)NumeroDimensioni.toEnumConstantFromString(valueNumeroDimensioni);
        this.setNumeroDimensioni(nd);
    }

    public NumeroDimensioni getNumeroDimensioni() {
        return this.numeroDimensioni;
    }

    public void setNumeroDimensioni(NumeroDimensioni numeroDimensioni) {
        this.numeroDimensioni = numeroDimensioni;
    }

    public boolean isVisualizzaNumeroDimensioni() {
        TipoReport tipoReportToCheck = this.getTipoReport();
        return tipoReportToCheck != null && (tipoReportToCheck.equals((Object)TipoReport.TABELLA) || tipoReportToCheck.equals((Object)TipoReport.BAR_CHART));
    }

    public List<SelectItem> getDimensioniCustomDisponibili() throws UtilsException {
        SortedMap<String> map = this.getDimensioniCustomDisponibiliAsMap();
        ArrayList<SelectItem> dimensioniDisponibili = new ArrayList<SelectItem>();
        dimensioniDisponibili.add(new SelectItem((Object)"--", "--"));
        for (String key : map.keys()) {
            String value = (String)map.get(key);
            dimensioniDisponibili.add(new SelectItem((Object)key, value));
        }
        return dimensioniDisponibili;
    }

    public SortedMap<String> getDimensioniCustomDisponibiliAsMap() throws UtilsException {
        SortedMap dimensioniDisponibili = new SortedMap();
        if (!this.tipoStatistica.equals((Object)TipoStatistica.DISTRIBUZIONE_SERVIZIO)) {
            dimensioniDisponibili.put(DimensioneCustom.TAG.toString(), (Object)MessageManager.getInstance().getMessage("stats.search.numeroDimensioniCustom.tag"));
            dimensioniDisponibili.put(DimensioneCustom.API.toString(), (Object)MessageManager.getInstance().getMessage("stats.search.numeroDimensioniCustom.api"));
            dimensioniDisponibili.put(DimensioneCustom.IMPLEMENTAZIONE_API.toString(), (Object)MessageManager.getInstance().getMessage("stats.search.numeroDimensioniCustom.servizio"));
        }
        if (!this.tipoStatistica.equals((Object)TipoStatistica.DISTRIBUZIONE_AZIONE)) {
            dimensioniDisponibili.put(DimensioneCustom.OPERAZIONE.toString(), (Object)MessageManager.getInstance().getMessage("stats.search.numeroDimensioniCustom.azione"));
        }
        if (!this.tipoStatistica.equals((Object)TipoStatistica.DISTRIBUZIONE_SOGGETTO)) {
            this.addDimensioniCustomSoggetto((SortedMap<String>)dimensioniDisponibili);
        }
        this.addDimensioniCustomApplicativo((SortedMap<String>)dimensioniDisponibili);
        this.addDimensioniCustomToken((SortedMap<String>)dimensioniDisponibili);
        if (!this.tipoStatistica.equals((Object)TipoStatistica.DISTRIBUZIONE_SERVIZIO_APPLICATIVO) || StringUtils.isEmpty((CharSequence)this.getRiconoscimento()) || !"identificativoAutenticato".equals(this.getRiconoscimento())) {
            dimensioniDisponibili.put(DimensioneCustom.PRINCIPAL.toString(), (Object)MessageManager.getInstance().getMessage("stats.search.numeroDimensioniCustom.principal"));
        }
        if (!this.tipoStatistica.equals((Object)TipoStatistica.DISTRIBUZIONE_SERVIZIO_APPLICATIVO) || StringUtils.isEmpty((CharSequence)this.getRiconoscimento()) || !"ip".equals(this.getRiconoscimento())) {
            dimensioniDisponibili.put(DimensioneCustom.INDIRIZZO_IP.toString(), (Object)MessageManager.getInstance().getMessage("stats.search.numeroDimensioniCustom.indirizzoIP"));
        }
        if (!this.tipoStatistica.equals((Object)TipoStatistica.DISTRIBUZIONE_ERRORI)) {
            dimensioniDisponibili.put(DimensioneCustom.ESITO.toString(), (Object)MessageManager.getInstance().getMessage("stats.search.numeroDimensioniCustom.esito"));
        }
        return dimensioniDisponibili;
    }

    private void addDimensioniCustomSoggetto(SortedMap<String> dimensioniDisponibili) throws UtilsException {
        if (TipologiaRicerca.ingresso.equals((Object)this.getTipologiaRicercaEnum()) || TipologiaRicerca.uscita.equals((Object)this.getTipologiaRicercaEnum())) {
            if (this.getSoggettoLocale() == null || StringUtils.isBlank((CharSequence)this.getSoggettoLocale())) {
                dimensioniDisponibili.put(DimensioneCustom.SOGGETTO_LOCALE.toString(), (Object)MessageManager.getInstance().getMessage("stats.search.numeroDimensioniCustom.soggettoLocale"));
            }
            if (this.getTipoNomeTrafficoPerSoggetto() == null || StringUtils.isBlank((CharSequence)this.getTipoNomeTrafficoPerSoggetto())) {
                dimensioniDisponibili.put(DimensioneCustom.SOGGETTO_REMOTO.toString(), (Object)MessageManager.getInstance().getMessage("stats.search.numeroDimensioniCustom.soggettoRemoto"));
            }
        } else {
            if (this.getTipoNomeMittente() == null || StringUtils.isBlank((CharSequence)this.getTipoNomeMittente())) {
                dimensioniDisponibili.put(DimensioneCustom.SOGGETTO_FRUITORE.toString(), (Object)MessageManager.getInstance().getMessage("stats.search.numeroDimensioniCustom.soggettoFruitore"));
            }
            if (this.getTipoNomeDestinatario() == null || StringUtils.isBlank((CharSequence)this.getTipoNomeDestinatario())) {
                dimensioniDisponibili.put(DimensioneCustom.SOGGETTO_EROGATORE.toString(), (Object)MessageManager.getInstance().getMessage("stats.search.numeroDimensioniCustom.soggettoErogatore"));
            }
        }
    }

    private void addDimensioniCustomApplicativo(SortedMap<String> dimensioniDisponibili) throws UtilsException {
        if (!this.tipoStatistica.equals((Object)TipoStatistica.DISTRIBUZIONE_SERVIZIO_APPLICATIVO) || StringUtils.isEmpty((CharSequence)this.getRiconoscimento()) || !"applicativo".equals(this.getRiconoscimento()) || !"commons.identificazione.trasporto.label".equals(this.getIdentificazione())) {
            dimensioniDisponibili.put(DimensioneCustom.APPLICATIVO_TRASPORTO.toString(), (Object)MessageManager.getInstance().getMessage("stats.search.numeroDimensioniCustom.applicativoTrasporto"));
        }
        if (!this.tipoStatistica.equals((Object)TipoStatistica.DISTRIBUZIONE_SERVIZIO_APPLICATIVO) || StringUtils.isEmpty((CharSequence)this.getRiconoscimento()) || !"applicativo".equals(this.getRiconoscimento()) || !"commons.identificazione.token.label".equals(this.getIdentificazione())) {
            dimensioniDisponibili.put(DimensioneCustom.APPLICATIVO_TOKEN.toString(), (Object)MessageManager.getInstance().getMessage("stats.search.numeroDimensioniCustom.applicativoToken"));
        }
    }

    private void addDimensioniCustomToken(SortedMap<String> dimensioniDisponibili) throws UtilsException {
        boolean showPDNDFilters;
        TipoCredenzialeMittente tcm = null;
        if (this.tipoStatistica.equals((Object)TipoStatistica.DISTRIBUZIONE_SERVIZIO_APPLICATIVO) && "tokenInfo".equals(this.getRiconoscimento())) {
            tcm = TipoCredenzialeMittente.toEnumConstant((String)this.getTokenClaim());
        }
        if (!this.tipoStatistica.equals((Object)TipoStatistica.DISTRIBUZIONE_SERVIZIO_APPLICATIVO) || StringUtils.isEmpty((CharSequence)this.getRiconoscimento()) || !"tokenInfo".equals(this.getRiconoscimento()) || !TipoCredenzialeMittente.TOKEN_CLIENT_ID.equals((Object)tcm)) {
            dimensioniDisponibili.put(DimensioneCustom.TOKEN_CLIENT_ID.toString(), (Object)MessageManager.getInstance().getMessage("stats.search.numeroDimensioniCustom.tokenInfo.clientID"));
        }
        if (!this.tipoStatistica.equals((Object)TipoStatistica.DISTRIBUZIONE_SERVIZIO_APPLICATIVO) || StringUtils.isEmpty((CharSequence)this.getRiconoscimento()) || !"tokenInfo".equals(this.getRiconoscimento()) || !TipoCredenzialeMittente.TOKEN_ISSUER.equals((Object)tcm)) {
            dimensioniDisponibili.put(DimensioneCustom.TOKEN_ISSUER.toString(), (Object)MessageManager.getInstance().getMessage("stats.search.numeroDimensioniCustom.tokenInfo.issuer"));
        }
        if (!this.tipoStatistica.equals((Object)TipoStatistica.DISTRIBUZIONE_SERVIZIO_APPLICATIVO) || StringUtils.isEmpty((CharSequence)this.getRiconoscimento()) || !"tokenInfo".equals(this.getRiconoscimento()) || !TipoCredenzialeMittente.TOKEN_SUBJECT.equals((Object)tcm)) {
            dimensioniDisponibili.put(DimensioneCustom.TOKEN_SUBJECT.toString(), (Object)MessageManager.getInstance().getMessage("stats.search.numeroDimensioniCustom.tokenInfo.subject"));
        }
        if (!this.tipoStatistica.equals((Object)TipoStatistica.DISTRIBUZIONE_SERVIZIO_APPLICATIVO) || StringUtils.isEmpty((CharSequence)this.getRiconoscimento()) || !"tokenInfo".equals(this.getRiconoscimento()) || !TipoCredenzialeMittente.TOKEN_USERNAME.equals((Object)tcm)) {
            dimensioniDisponibili.put(DimensioneCustom.TOKEN_USERNAME.toString(), (Object)MessageManager.getInstance().getMessage("stats.search.numeroDimensioniCustom.tokenInfo.username"));
        }
        if (!this.tipoStatistica.equals((Object)TipoStatistica.DISTRIBUZIONE_SERVIZIO_APPLICATIVO) || StringUtils.isEmpty((CharSequence)this.getRiconoscimento()) || !"tokenInfo".equals(this.getRiconoscimento()) || !TipoCredenzialeMittente.TOKEN_EMAIL.equals((Object)tcm)) {
            dimensioniDisponibili.put(DimensioneCustom.TOKEN_EMAIL.toString(), (Object)MessageManager.getInstance().getMessage("stats.search.numeroDimensioniCustom.tokenInfo.email"));
        }
        if (!(this.tipoStatistica.equals((Object)TipoStatistica.DISTRIBUZIONE_SERVIZIO_APPLICATIVO) && !StringUtils.isEmpty((CharSequence)this.getRiconoscimento()) && "tokenInfo".equals(this.getRiconoscimento()) && TipoCredenzialeMittente.PDND_ORGANIZATION_NAME.equals((Object)tcm) && TipoCredenzialeMittente.PDND_ORGANIZATION_EXTERNAL_ID.equals((Object)tcm) && TipoCredenzialeMittente.PDND_ORGANIZATION_CONSUMER_ID.equals((Object)tcm) || !(showPDNDFilters = this.isShowPDNDFilters()))) {
            dimensioniDisponibili.put(DimensioneCustom.TOKEN_PDND_ORGANIZATION.toString(), (Object)MessageManager.getInstance().getMessage("stats.search.numeroDimensioniCustom.tokenInfo.clientID.pdnd"));
            dimensioniDisponibili.put(DimensioneCustom.TOKEN_PDND_ORGANIZATION_EXTERNAL_ID.toString(), (Object)MessageManager.getInstance().getMessage("stats.search.numeroDimensioniCustom.tokenInfo.clientID.pdnd.externalId"));
            dimensioniDisponibili.put(DimensioneCustom.TOKEN_PDND_ORGANIZATION_CONSUMER_ID.toString(), (Object)MessageManager.getInstance().getMessage("stats.search.numeroDimensioniCustom.tokenInfo.clientID.pdnd.consumerId"));
        }
    }

    public String get_value_numeroDimensioniCustom() {
        if (this.numeroDimensioniCustom == null) {
            return null;
        }
        return this.numeroDimensioniCustom.toString();
    }

    public void set_value_numeroDimensioniCustom(String valueNumeroDimensioniCustom) {
        DimensioneCustom dc = (DimensioneCustom)DimensioneCustom.toEnumConstantFromString(valueNumeroDimensioniCustom);
        this.setNumeroDimensioniCustom(dc);
    }

    public DimensioneCustom getNumeroDimensioniCustom() {
        return this.numeroDimensioniCustom;
    }

    public void setNumeroDimensioniCustom(DimensioneCustom numeroDimensioniCustom) {
        this.numeroDimensioniCustom = numeroDimensioniCustom;
    }

    public boolean isVisualizzaNumeroDimensioniCustom() {
        NumeroDimensioni numeroDimensioniToCheck = this.getNumeroDimensioni();
        return numeroDimensioniToCheck != null && numeroDimensioniToCheck.equals(NumeroDimensioni.DIMENSIONI_3_CUSTOM);
    }

    public String getLabelNumeroDimensioniCustom() {
        if (this.numeroDimensioniCustom != null) {
            return StatsUtils.getLabel(this.numeroDimensioniCustom);
        }
        return "N.D.";
    }

    public boolean isVisualizzaGraficoBars() {
        TipoReport tipoReportToCheck = this.getTipoReport();
        NumeroDimensioni numeroDimensioniToCheck = this.getNumeroDimensioni();
        return tipoReportToCheck != null && tipoReportToCheck.equals((Object)TipoReport.BAR_CHART) && numeroDimensioniToCheck != null && numeroDimensioniToCheck.equals(NumeroDimensioni.DIMENSIONI_2);
    }

    public boolean isVisualizzaGraficoHeatmap() {
        TipoReport tipoReportToCheck = this.getTipoReport();
        NumeroDimensioni numeroDimensioniToCheck = this.getNumeroDimensioni();
        return tipoReportToCheck != null && tipoReportToCheck.equals((Object)TipoReport.BAR_CHART) && numeroDimensioniToCheck != null && (numeroDimensioniToCheck.equals(NumeroDimensioni.DIMENSIONI_3) || numeroDimensioniToCheck.equals(NumeroDimensioni.DIMENSIONI_3_CUSTOM));
    }

    public void setTipoDistribuzione(String tipoDistribuzione) {
        this.tipoDistribuzione = tipoDistribuzione;
    }

    public String getTipoDistribuzione() {
        return this.tipoDistribuzione;
    }

    public ModuloRicerca getModulo() {
        return ModuloRicerca.STATISTICHE;
    }

    public String getModalitaRicerca() {
        return this.getTipoDistribuzione();
    }

    public boolean isVisualizzaComandoSalvaRicerca() {
        return true;
    }

    public List<String> getElencoFieldRicercaDaIgnorare() {
        return elencoFieldsRicercaDaIgnorare;
    }

    static {
        elencoFieldsRicercaDaIgnorare.addAll(Arrays.asList(Costanti.SEARCH_FORM_FIELDS_DA_NON_SALVARE));
        elencoFieldsRicercaDaIgnorare.addAll(Arrays.asList(StatisticheCostanti.SEARCH_FORM_FIELDS_DA_NON_SALVARE));
    }
}

