/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.statistiche.datamodel;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.faces.context.FacesContext;
import org.ajax4jsf.model.DataVisitor;
import org.ajax4jsf.model.Range;
import org.ajax4jsf.model.SequenceRange;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.web.monitor.core.datamodel.BaseDataModel;
import org.openspcoop2.web.monitor.core.datamodel.ResDistribuzione;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.openspcoop2.web.monitor.statistiche.dao.IStatisticheGiornaliere;
import org.slf4j.Logger;

public class StatsPersonalizzateDM
extends BaseDataModel<String, ResDistribuzione, IStatisticheGiornaliere> {
    private static final long serialVersionUID = 500153520162806619L;
    private static Logger log = LoggerManager.getPddMonitorCoreLogger();
    private boolean visualizzaComandiExport = false;

    public int getRowCount() {
        try {
            this.visualizzaComandiExport = false;
            int count = ((IStatisticheGiornaliere)this.getDataProvider()).countAllDistribuzionePersonalizzata();
            if (count > 0) {
                this.visualizzaComandiExport = true;
            }
            return count;
        }
        catch (ServiceException e) {
            log.error(e.getMessage(), (Throwable)e);
            return 0;
        }
    }

    public void walk(FacesContext context, DataVisitor visitor, Range range, Object argument) throws IOException {
        block7: {
            try {
                if (this.detached) {
                    for (String key : this.wrappedKeys) {
                        this.setRowKey(key);
                        visitor.process(context, (Object)key, argument);
                    }
                    break block7;
                }
                int start = ((SequenceRange)range).getFirstRow();
                int limit = ((SequenceRange)range).getRows();
                this.wrappedKeys = new ArrayList();
                List<Object> list = new ArrayList();
                try {
                    list = ((IStatisticheGiornaliere)this.getDataProvider()).findAllDistribuzionePersonalizzata(start, limit);
                }
                catch (ServiceException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
                for (ResDistribuzione resDistribuzione : list) {
                    this.wrappedData.put(resDistribuzione.getRisultato(), resDistribuzione);
                    this.wrappedKeys.add(resDistribuzione.getRisultato());
                    visitor.process(context, (Object)resDistribuzione.getRisultato(), argument);
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public boolean isVisualizzaComandiExport() {
        return this.visualizzaComandiExport;
    }

    public void setVisualizzaComandiExport(boolean visualizzaComandiExport) {
        this.visualizzaComandiExport = visualizzaComandiExport;
    }

    public boolean isTimeoutEvent() {
        return ((IStatisticheGiornaliere)this.getDataProvider()).isTimeoutEvent();
    }
}

