/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.statistiche.mbean;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.model.SelectItem;
import org.openspcoop2.core.statistiche.constants.TipoReport;
import org.openspcoop2.web.monitor.core.bean.ApplicationBean;
import org.openspcoop2.web.monitor.core.core.Utility;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.openspcoop2.web.monitor.core.utils.MessageManager;
import org.openspcoop2.web.monitor.statistiche.bean.AnalisiStatistica;
import org.openspcoop2.web.monitor.statistiche.bean.GruppoAnalisiStatistica;
import org.openspcoop2.web.monitor.statistiche.bean.StatistichePersonalizzateSearchForm;
import org.openspcoop2.web.monitor.statistiche.bean.StatsSearchForm;
import org.openspcoop2.web.monitor.statistiche.mbean.AndamentoTemporaleBean;
import org.openspcoop2.web.monitor.statistiche.mbean.BaseStatsMBean;
import org.openspcoop2.web.monitor.statistiche.mbean.DistribuzionePerAzioneBean;
import org.openspcoop2.web.monitor.statistiche.mbean.DistribuzionePerErroriBean;
import org.openspcoop2.web.monitor.statistiche.mbean.DistribuzionePerSABean;
import org.openspcoop2.web.monitor.statistiche.mbean.DistribuzionePerServizioBean;
import org.openspcoop2.web.monitor.statistiche.mbean.DistribuzionePerSoggettoBean;
import org.openspcoop2.web.monitor.statistiche.mbean.StatsPersonalizzateBean;
import org.slf4j.Logger;

public class AnalisiStatisticaBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private BaseStatsMBean<?, ?, ?> mBean;
    private static Logger log = LoggerManager.getPddMonitorCoreLogger();
    private List<SelectItem> tipiDistribuzione;
    private List<GruppoAnalisiStatistica> tipiAnalisiStatistica;
    private String tipoDistribuzione = "temporale";
    private transient ApplicationBean applicationBean = null;

    public AnalisiStatisticaBean() {
        try {
            this.applicationBean = ApplicationBean.getInstance();
            this.applicationBean.setLoginBean(Utility.getLoginBean());
        }
        catch (Exception e) {
            log.error("Errore durante la init di AnalisiStatisticaBean: " + e.getMessage(), (Throwable)e);
        }
    }

    public void menuActionListener(ActionEvent ae) {
        this.setTipoDistribuzione("temporale");
        this.tipoDistribuzioneListener(ae);
    }

    public List<SelectItem> getTipiDistribuzione() {
        if (this.tipiDistribuzione == null) {
            this.tipiDistribuzione = new ArrayList<SelectItem>();
            this.tipiDistribuzione.add(new SelectItem((Object)"temporale", MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.temporale.label")));
            this.tipiDistribuzione.add(new SelectItem((Object)"esiti", MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.esiti.label")));
            this.tipiDistribuzione.add(new SelectItem((Object)"errori", MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.errori.label")));
            this.tipiDistribuzione.add(new SelectItem((Object)"soggetto_remoto", MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.soggettoRemoto.label")));
            this.tipiDistribuzione.add(new SelectItem((Object)"soggetto_locale", MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.soggettoLocale.label")));
            this.tipiDistribuzione.add(new SelectItem((Object)"servizio", MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.servizio.label")));
            this.tipiDistribuzione.add(new SelectItem((Object)"azione", MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.azione.label")));
            this.tipiDistribuzione.add(new SelectItem((Object)"servizio_applicativo", MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.applicativo.label")));
            if (this.applicationBean.getShowStatistichePersonalizzate()) {
                this.tipiDistribuzione.add(new SelectItem((Object)"personalizzata", MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.personalizzata.label")));
            }
        }
        return this.tipiDistribuzione;
    }

    public boolean disabilitaAnalisiStatisticaSoggettoLocale() {
        return !Utility.getLoginBean().isShowFiltroSoggettoLocale() || !Utility.isMultitenantAbilitato();
    }

    public List<GruppoAnalisiStatistica> getTipiAnalisiStatistica() {
        this.tipiAnalisiStatistica = new ArrayList<GruppoAnalisiStatistica>();
        GruppoAnalisiStatistica gruppoAndamentoTemporale = new GruppoAnalisiStatistica();
        gruppoAndamentoTemporale.setLabel(MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.temporale.label"));
        ArrayList<AnalisiStatistica> listaAnalisiGruppoAndamentoTemporale = new ArrayList<AnalisiStatistica>();
        listaAnalisiGruppoAndamentoTemporale.add(new AnalisiStatistica("temporale", "Line chart", TipoReport.LINE_CHART));
        listaAnalisiGruppoAndamentoTemporale.add(new AnalisiStatistica("temporale", "Bar chart", TipoReport.BAR_CHART));
        listaAnalisiGruppoAndamentoTemporale.add(new AnalisiStatistica("temporale", "Tabella", TipoReport.TABELLA));
        gruppoAndamentoTemporale.setListaAnalisiStatistica(listaAnalisiGruppoAndamentoTemporale);
        this.tipiAnalisiStatistica.add(gruppoAndamentoTemporale);
        GruppoAnalisiStatistica gruppoEsiti = new GruppoAnalisiStatistica();
        gruppoEsiti.setLabel(MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.esiti.label"));
        ArrayList<AnalisiStatistica> listaAnalisiGruppoEsiti = new ArrayList<AnalisiStatistica>();
        listaAnalisiGruppoEsiti.add(new AnalisiStatistica("esiti", "Bar chart", TipoReport.BAR_CHART));
        listaAnalisiGruppoEsiti.add(new AnalisiStatistica("esiti", "Line chart", TipoReport.LINE_CHART));
        listaAnalisiGruppoEsiti.add(new AnalisiStatistica("esiti", "Tabella", TipoReport.TABELLA));
        gruppoEsiti.setListaAnalisiStatistica(listaAnalisiGruppoEsiti);
        this.tipiAnalisiStatistica.add(gruppoEsiti);
        GruppoAnalisiStatistica gruppoErrori = new GruppoAnalisiStatistica();
        gruppoErrori.setLabel(MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.errori.label"));
        ArrayList<AnalisiStatistica> listaAnalisiGruppoErrori = new ArrayList<AnalisiStatistica>();
        listaAnalisiGruppoErrori.add(new AnalisiStatistica("errori", "Bar chart", TipoReport.BAR_CHART));
        listaAnalisiGruppoErrori.add(new AnalisiStatistica("errori", "Pie chart", TipoReport.PIE_CHART));
        listaAnalisiGruppoErrori.add(new AnalisiStatistica("errori", "Tabella", TipoReport.TABELLA));
        gruppoErrori.setListaAnalisiStatistica(listaAnalisiGruppoErrori);
        this.tipiAnalisiStatistica.add(gruppoErrori);
        GruppoAnalisiStatistica gruppoSoggettoRemoto = new GruppoAnalisiStatistica();
        gruppoSoggettoRemoto.setLabel(MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.soggettoRemoto.label"));
        ArrayList<AnalisiStatistica> listaAnalisiGruppoSoggettoRemoto = new ArrayList<AnalisiStatistica>();
        listaAnalisiGruppoSoggettoRemoto.add(new AnalisiStatistica("soggetto_remoto", "Bar chart", TipoReport.BAR_CHART));
        listaAnalisiGruppoSoggettoRemoto.add(new AnalisiStatistica("soggetto_remoto", "Pie chart", TipoReport.PIE_CHART));
        listaAnalisiGruppoSoggettoRemoto.add(new AnalisiStatistica("soggetto_remoto", "Tabella", TipoReport.TABELLA));
        gruppoSoggettoRemoto.setListaAnalisiStatistica(listaAnalisiGruppoSoggettoRemoto);
        this.tipiAnalisiStatistica.add(gruppoSoggettoRemoto);
        if (!this.disabilitaAnalisiStatisticaSoggettoLocale()) {
            GruppoAnalisiStatistica gruppoSoggettoLocale = new GruppoAnalisiStatistica();
            gruppoSoggettoLocale.setLabel(MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.soggettoLocale.label"));
            ArrayList<AnalisiStatistica> listaAnalisiGruppoSoggettoLocale = new ArrayList<AnalisiStatistica>();
            listaAnalisiGruppoSoggettoLocale.add(new AnalisiStatistica("soggetto_locale", "Bar chart", TipoReport.BAR_CHART));
            listaAnalisiGruppoSoggettoLocale.add(new AnalisiStatistica("soggetto_locale", "Pie chart", TipoReport.PIE_CHART));
            listaAnalisiGruppoSoggettoLocale.add(new AnalisiStatistica("soggetto_locale", "Tabella", TipoReport.TABELLA));
            gruppoSoggettoLocale.setListaAnalisiStatistica(listaAnalisiGruppoSoggettoLocale);
            this.tipiAnalisiStatistica.add(gruppoSoggettoLocale);
        }
        GruppoAnalisiStatistica gruppoServizio = new GruppoAnalisiStatistica();
        gruppoServizio.setLabel(MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.servizio.label"));
        ArrayList<AnalisiStatistica> listaAnalisiGrupposervizio = new ArrayList<AnalisiStatistica>();
        listaAnalisiGrupposervizio.add(new AnalisiStatistica("servizio", "Bar chart", TipoReport.BAR_CHART));
        listaAnalisiGrupposervizio.add(new AnalisiStatistica("servizio", "Pie chart", TipoReport.PIE_CHART));
        listaAnalisiGrupposervizio.add(new AnalisiStatistica("servizio", "Tabella", TipoReport.TABELLA));
        gruppoServizio.setListaAnalisiStatistica(listaAnalisiGrupposervizio);
        this.tipiAnalisiStatistica.add(gruppoServizio);
        GruppoAnalisiStatistica gruppoAzione = new GruppoAnalisiStatistica();
        gruppoAzione.setLabel(MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.azione.label"));
        ArrayList<AnalisiStatistica> listaAnalisiGruppoAzione = new ArrayList<AnalisiStatistica>();
        listaAnalisiGruppoAzione.add(new AnalisiStatistica("azione", "Bar chart", TipoReport.BAR_CHART));
        listaAnalisiGruppoAzione.add(new AnalisiStatistica("azione", "Pie chart", TipoReport.PIE_CHART));
        listaAnalisiGruppoAzione.add(new AnalisiStatistica("azione", "Tabella", TipoReport.TABELLA));
        gruppoAzione.setListaAnalisiStatistica(listaAnalisiGruppoAzione);
        this.tipiAnalisiStatistica.add(gruppoAzione);
        GruppoAnalisiStatistica gruppoTokeniinfo = new GruppoAnalisiStatistica();
        gruppoTokeniinfo.setLabel(MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.tokenInfo.label"));
        ArrayList<AnalisiStatistica> listaAnalisiGruppoTokeniInfo = new ArrayList<AnalisiStatistica>();
        listaAnalisiGruppoTokeniInfo.add(new AnalisiStatistica("servizio_applicativo-tokenInfo", "Bar chart", TipoReport.BAR_CHART));
        listaAnalisiGruppoTokeniInfo.add(new AnalisiStatistica("servizio_applicativo-tokenInfo", "Pie chart", TipoReport.PIE_CHART));
        listaAnalisiGruppoTokeniInfo.add(new AnalisiStatistica("servizio_applicativo-tokenInfo", "Tabella", TipoReport.TABELLA));
        gruppoTokeniinfo.setListaAnalisiStatistica(listaAnalisiGruppoTokeniInfo);
        this.tipiAnalisiStatistica.add(gruppoTokeniinfo);
        GruppoAnalisiStatistica gruppoApplicativo = new GruppoAnalisiStatistica();
        gruppoApplicativo.setLabel(MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.applicativo.label"));
        ArrayList<AnalisiStatistica> listaAnalisiGruppoApplicativo = new ArrayList<AnalisiStatistica>();
        listaAnalisiGruppoApplicativo.add(new AnalisiStatistica("servizio_applicativo-applicativo", "Bar chart", TipoReport.BAR_CHART));
        listaAnalisiGruppoApplicativo.add(new AnalisiStatistica("servizio_applicativo-applicativo", "Pie chart", TipoReport.PIE_CHART));
        listaAnalisiGruppoApplicativo.add(new AnalisiStatistica("servizio_applicativo-applicativo", "Tabella", TipoReport.TABELLA));
        gruppoApplicativo.setListaAnalisiStatistica(listaAnalisiGruppoApplicativo);
        this.tipiAnalisiStatistica.add(gruppoApplicativo);
        GruppoAnalisiStatistica gruppoIdentificativoAutenticato = new GruppoAnalisiStatistica();
        gruppoIdentificativoAutenticato.setLabel(MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.identificativoAutenticato.label"));
        ArrayList<AnalisiStatistica> listaAnalisiGruppoIdentificativoAutenticato = new ArrayList<AnalisiStatistica>();
        listaAnalisiGruppoIdentificativoAutenticato.add(new AnalisiStatistica("servizio_applicativo-identificativoAutenticato", "Bar chart", TipoReport.BAR_CHART));
        listaAnalisiGruppoIdentificativoAutenticato.add(new AnalisiStatistica("servizio_applicativo-identificativoAutenticato", "Pie chart", TipoReport.PIE_CHART));
        listaAnalisiGruppoIdentificativoAutenticato.add(new AnalisiStatistica("servizio_applicativo-identificativoAutenticato", "Tabella", TipoReport.TABELLA));
        gruppoIdentificativoAutenticato.setListaAnalisiStatistica(listaAnalisiGruppoIdentificativoAutenticato);
        this.tipiAnalisiStatistica.add(gruppoIdentificativoAutenticato);
        GruppoAnalisiStatistica gruppoIndirizzoIP = new GruppoAnalisiStatistica();
        gruppoIndirizzoIP.setLabel(MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.indirizzoIP.label"));
        ArrayList<AnalisiStatistica> listaAnalisiGruppoIndirizzoIP = new ArrayList<AnalisiStatistica>();
        listaAnalisiGruppoIndirizzoIP.add(new AnalisiStatistica("servizio_applicativo-ip", "Bar chart", TipoReport.BAR_CHART));
        listaAnalisiGruppoIndirizzoIP.add(new AnalisiStatistica("servizio_applicativo-ip", "Pie chart", TipoReport.PIE_CHART));
        listaAnalisiGruppoIndirizzoIP.add(new AnalisiStatistica("servizio_applicativo-ip", "Tabella", TipoReport.TABELLA));
        gruppoIndirizzoIP.setListaAnalisiStatistica(listaAnalisiGruppoIndirizzoIP);
        this.tipiAnalisiStatistica.add(gruppoIndirizzoIP);
        if (this.applicationBean.getShowStatistichePersonalizzate()) {
            GruppoAnalisiStatistica gruppoPersonalizzate = new GruppoAnalisiStatistica();
            gruppoPersonalizzate.setLabel(MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.personalizzata.label"));
            ArrayList<AnalisiStatistica> listaAnalisiGruppoPersonalizzate = new ArrayList<AnalisiStatistica>();
            listaAnalisiGruppoPersonalizzate.add(new AnalisiStatistica("personalizzata", "Bar chart", TipoReport.BAR_CHART));
            listaAnalisiGruppoPersonalizzate.add(new AnalisiStatistica("personalizzata", "Pie chart", TipoReport.PIE_CHART));
            listaAnalisiGruppoPersonalizzate.add(new AnalisiStatistica("personalizzata", "Andamento Temporale", TipoReport.ANDAMENTO_TEMPORALE));
            listaAnalisiGruppoPersonalizzate.add(new AnalisiStatistica("personalizzata", "Tabella", TipoReport.TABELLA));
            gruppoPersonalizzate.setListaAnalisiStatistica(listaAnalisiGruppoPersonalizzate);
            this.tipiAnalisiStatistica.add(gruppoPersonalizzate);
        }
        return this.tipiAnalisiStatistica;
    }

    public BaseStatsMBean<?, ?, ?> getmBean() {
        return this.mBean;
    }

    public void setmBean(BaseStatsMBean<?, ?, ?> mBean) {
        this.mBean = mBean;
    }

    public void tipoDistribuzioneListener(ActionEvent ae) {
        if (this.tipoDistribuzione != null && this.mBean != null) {
            if (this.tipoDistribuzione.equals("temporale")) {
                ((AndamentoTemporaleBean)this.mBean).initSearchListenerAndamentoTemporale(ae);
            } else if (this.tipoDistribuzione.equals("esiti")) {
                ((AndamentoTemporaleBean)this.mBean).initSearchListenerDistribuzionePerEsiti(ae);
            } else if (this.tipoDistribuzione.equals("errori")) {
                ((DistribuzionePerErroriBean)this.mBean).getSearch().initSearchListener(ae);
            } else if (this.tipoDistribuzione.equals("soggetto_remoto")) {
                ((DistribuzionePerSoggettoBean)this.mBean).initSearchListenerRemoto(ae);
            } else if (this.tipoDistribuzione.equals("soggetto_locale")) {
                ((DistribuzionePerSoggettoBean)this.mBean).initSearchListenerLocale(ae);
            } else if (this.tipoDistribuzione.equals("servizio")) {
                ((DistribuzionePerServizioBean)this.mBean).getSearch().initSearchListener(ae);
            } else if (this.tipoDistribuzione.equals("azione")) {
                ((DistribuzionePerAzioneBean)this.mBean).getSearch().initSearchListener(ae);
            } else if (this.tipoDistribuzione.equals("servizio_applicativo")) {
                ((DistribuzionePerSABean)this.mBean).getSearch().initSearchListener(ae);
            } else if (this.applicationBean.getShowStatistichePersonalizzate() && this.tipoDistribuzione.equals("personalizzata")) {
                ((StatsPersonalizzateBean)this.mBean).getSearch().initSearchListener(ae);
            }
        }
    }

    public String getTipoDistribuzione() {
        return this.tipoDistribuzione;
    }

    public void setTipoDistribuzione(String tipoDistribuzione) {
        this.tipoDistribuzione = tipoDistribuzione;
        if (this.tipoDistribuzione != null) {
            this.mBean = this.tipoDistribuzione.equals("temporale") ? (BaseStatsMBean)this.getBean("andamentoTemporaleBean", AndamentoTemporaleBean.class) : (this.tipoDistribuzione.equals("esiti") ? (BaseStatsMBean)this.getBean("andamentoTemporaleBean", AndamentoTemporaleBean.class) : (this.tipoDistribuzione.equals("errori") ? (BaseStatsMBean)this.getBean("distribuzionePerErroriBean", DistribuzionePerErroriBean.class) : (this.tipoDistribuzione.equals("soggetto_remoto") ? (BaseStatsMBean)this.getBean("distribuzionePerSoggettoBean", DistribuzionePerSoggettoBean.class) : (this.tipoDistribuzione.equals("soggetto_locale") ? (BaseStatsMBean)this.getBean("distribuzionePerSoggettoBean", DistribuzionePerSoggettoBean.class) : (this.tipoDistribuzione.equals("servizio") ? (BaseStatsMBean)this.getBean("distribuzionePerServizioBean", DistribuzionePerServizioBean.class) : (this.tipoDistribuzione.equals("azione") ? (BaseStatsMBean)this.getBean("distribuzionePerAzioneBean", DistribuzionePerAzioneBean.class) : (this.tipoDistribuzione.startsWith("servizio_applicativo") ? (BaseStatsMBean)this.getBean("distribuzionePerSABean", DistribuzionePerSABean.class) : (this.applicationBean.getShowStatistichePersonalizzate() && this.tipoDistribuzione.equals("personalizzata") ? (BaseStatsMBean)this.getBean("statistichePersonalizzateBean", StatsPersonalizzateBean.class) : null))))))));
        }
    }

    public void setDistribuzione(String tipoDistribuzioneTmp) {
        if (this.tipoDistribuzione != null && this.mBean != null) {
            this.mBean.setTipoDistribuzione(this.tipoDistribuzione);
            if (this.tipoDistribuzione.equals("temporale")) {
                ((AndamentoTemporaleBean)this.mBean).initSearchListenerAndamentoTemporale(null);
            } else if (this.tipoDistribuzione.equals("esiti")) {
                ((AndamentoTemporaleBean)this.mBean).initSearchListenerDistribuzionePerEsiti(null);
            } else if (this.tipoDistribuzione.equals("errori")) {
                ((DistribuzionePerErroriBean)this.mBean).getSearch().initSearchListener(null);
            } else if (this.tipoDistribuzione.equals("soggetto_remoto")) {
                ((DistribuzionePerSoggettoBean)this.mBean).initSearchListenerRemoto(null);
            } else if (this.tipoDistribuzione.equals("soggetto_locale")) {
                ((DistribuzionePerSoggettoBean)this.mBean).initSearchListenerLocale(null);
            } else if (this.tipoDistribuzione.equals("servizio")) {
                ((DistribuzionePerServizioBean)this.mBean).getSearch().initSearchListener(null);
            } else if (this.tipoDistribuzione.equals("azione")) {
                ((DistribuzionePerAzioneBean)this.mBean).getSearch().initSearchListener(null);
            } else if (this.tipoDistribuzione.startsWith("servizio_applicativo")) {
                ((DistribuzionePerSABean)this.mBean).getSearch().initSearchListener(null);
                String[] mittenteType = this.tipoDistribuzione.split("-");
                this.mBean.getSearch().setRiconoscimento(mittenteType[1]);
            } else if (this.applicationBean.getShowStatistichePersonalizzate() && this.tipoDistribuzione.equals("personalizzata")) {
                ((StatsPersonalizzateBean)this.mBean).getSearch().initSearchListener(null);
            }
        }
    }

    public void setTipoReport(String tipoReport) {
        if (tipoReport != null && this.mBean != null) {
            if (this.tipoDistribuzione.equals("personalizzata")) {
                ((StatistichePersonalizzateSearchForm)this.mBean.getSearch()).set_value_tipoReport(tipoReport);
            } else {
                ((StatsSearchForm)this.mBean.getSearch()).set_value_tipoReport(tipoReport);
            }
        }
    }

    public String submit() {
        if (this.mBean != null) {
            return this.mBean.submit();
        }
        return null;
    }

    public void setTipiDistribuzione(List<SelectItem> listaTipiDistribuzione) {
        this.tipiDistribuzione = listaTipiDistribuzione;
    }

    public String ripulisci() {
        if (this.mBean != null && this.mBean.getSearch() != null) {
            String tipoReport = null;
            tipoReport = this.tipoDistribuzione.equals("personalizzata") ? ((StatistichePersonalizzateSearchForm)this.mBean.getSearch()).get_value_tipoReport() : ((StatsSearchForm)this.mBean.getSearch()).get_value_tipoReport();
            String ripulisciOutcome = this.mBean.getSearch().ripulisci();
            if (this.tipoDistribuzione.startsWith("servizio_applicativo")) {
                String[] mittenteType = this.tipoDistribuzione.split("-");
                this.mBean.getSearch().setRiconoscimento(mittenteType[1]);
            }
            if (this.tipoDistribuzione.equals("personalizzata")) {
                ((StatistichePersonalizzateSearchForm)this.mBean.getSearch()).set_value_tipoReport(tipoReport);
            } else {
                ((StatsSearchForm)this.mBean.getSearch()).set_value_tipoReport(tipoReport);
            }
            return ripulisciOutcome;
        }
        return null;
    }

    public String filtra() {
        if (this.mBean != null && this.mBean.getSearch() != null) {
            return this.mBean.getSearch().filtra();
        }
        return null;
    }

    public String inviaFormRicerca() {
        if (this.mBean != null && this.mBean.getSearch() != null) {
            return this.mBean.getSearch().inviaFormRicerca();
        }
        return null;
    }

    private <T> T getBean(String beanName, Class<T> beanClass) {
        Object toRet = null;
        try {
            FacesContext context = FacesContext.getCurrentInstance();
            toRet = context.getApplication().getExpressionFactory().createValueExpression(context.getELContext(), "#{" + beanName + "}", beanClass).getValue(context.getELContext());
        }
        catch (Exception e) {
            log.error("Errore durante la lettura del bean [" + beanName + "]: " + e.getMessage(), (Throwable)e);
        }
        return (T)toRet;
    }

    public StatsSearchForm getSearch() {
        if (this.mBean == null && this.tipoDistribuzione != null) {
            this.setTipoDistribuzione(this.tipoDistribuzione);
        }
        if (this.mBean != null && this.mBean.getSearch() != null) {
            return (StatsSearchForm)this.mBean.getSearch();
        }
        return null;
    }

    public void setSearch(StatsSearchForm search) {
    }

    public String getLabelFiltriRicerca() {
        if (this.tipoDistribuzione != null) {
            if (this.tipoDistribuzione.equals("temporale")) {
                return MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.temporale.label");
            }
            if (this.tipoDistribuzione.equals("esiti")) {
                return MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.esiti.label");
            }
            if (this.tipoDistribuzione.equals("errori")) {
                return MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.errori.label");
            }
            if (this.tipoDistribuzione.equals("soggetto_remoto")) {
                return MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.soggettoRemoto.label");
            }
            if (this.tipoDistribuzione.equals("soggetto_locale")) {
                return MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.soggettoLocale.label");
            }
            if (this.tipoDistribuzione.equals("servizio")) {
                return MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.servizio.label");
            }
            if (this.tipoDistribuzione.equals("azione")) {
                return MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.azione.label");
            }
            if (this.tipoDistribuzione.startsWith("servizio_applicativo")) {
                String[] mittenteType = this.tipoDistribuzione.split("-");
                if (mittenteType[1].equals("applicativo")) {
                    return MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.applicativo.label");
                }
                if (mittenteType[1].equals("identificativoAutenticato")) {
                    return MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.identificativoAutenticato.label");
                }
                if (mittenteType[1].equals("ip")) {
                    return MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.indirizzoIP.label");
                }
                return MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.tokenInfo.label");
            }
            if (this.applicationBean.getShowStatistichePersonalizzate() && this.tipoDistribuzione.equals("personalizzata")) {
                return MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.personalizzata.label");
            }
        }
        return "Filtri Ricerca";
    }
}

