/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.statistiche.mbean;

import jakarta.servlet.http.HttpServletResponse;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.faces.event.ActionEvent;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB;
import org.openspcoop2.core.plugins.dao.IServiceManager;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.monitor.sdk.constants.StatisticType;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.web.monitor.core.bean.ApplicationBean;
import org.openspcoop2.web.monitor.core.bean.BaseSearchForm;
import org.openspcoop2.web.monitor.core.core.PddMonitorProperties;
import org.openspcoop2.web.monitor.core.dao.IService;
import org.openspcoop2.web.monitor.core.mbean.DynamicPdDBean;
import org.openspcoop2.web.monitor.core.utils.MessageUtils;
import org.openspcoop2.web.monitor.statistiche.bean.StatsSearchForm;
import org.slf4j.Logger;

public abstract class BaseStatsMBean<T, K, IService>
extends DynamicPdDBean<T, K, IService<T, K>> {
    private static final long serialVersionUID = 1L;
    private Boolean isVisualizzaPerDimensioneEnabled;
    private String tipoMessaggio = "Richiesta";
    private Integer slice = 12;
    private Integer minCategorie = 1;
    private Integer maxCategorie = 50;
    private Integer larghezzaGrafico = 700;
    private Integer minLarghezzaGrafico = 500;
    private Integer maxLarghezzaGrafico = 2000;
    private String direzioneLabel = "Obliquo";
    private Integer numeroLabelAsseXDistribuzioneTemporale = 13;
    private boolean nascondiComandoSelezioneNumeroLabelSeInferioreANumeroRisultati = true;
    private String data;
    private String chartId = null;
    private String dir;
    private boolean visualizzaComandiExport = false;
    private boolean visualizzaTotaleNelleCelleGraficoHeatmap = false;
    private String tipoDistribuzione = "temporale";

    public BaseStatsMBean() {
        this.init();
    }

    public BaseStatsMBean(org.openspcoop2.core.commons.search.dao.IServiceManager serviceManager, IServiceManager pluginsServiceManager, DriverRegistroServiziDB driverRegistroServiziDB, DriverConfigurazioneDB driverConfigurazioneDB) {
        super(serviceManager, pluginsServiceManager, driverRegistroServiziDB, driverConfigurazioneDB);
        this.init();
    }

    private void init() {
        try {
            PddMonitorProperties govwayMonitorProperties = PddMonitorProperties.getInstance((Logger)DynamicPdDBean.log);
            this.isVisualizzaPerDimensioneEnabled = govwayMonitorProperties.isAttivoStatisticheVisualizzazioneDimensione();
            this.direzioneLabel = govwayMonitorProperties.getOrientamentoDefaultLabelGrafici();
            this.numeroLabelAsseXDistribuzioneTemporale = govwayMonitorProperties.getNumeroLabelDefaultDistribuzioneTemporale();
            this.nascondiComandoSelezioneNumeroLabelSeInferioreANumeroRisultati = govwayMonitorProperties.isNascondiComandoNumeroLabelSeInferioreAlNumeroRisultati();
            this.visualizzaTotaleNelleCelleGraficoHeatmap = govwayMonitorProperties.isStatisticheVisualizzaValoriNelleCelleDelGraficoHeatmap();
        }
        catch (Exception e) {
            DynamicPdDBean.log.error(e.getMessage(), (Throwable)e);
        }
    }

    protected String gestioneErrore(boolean useFaceContext, Exception e) throws NotFoundException, ServiceException {
        if (useFaceContext) {
            DynamicPdDBean.log.error(e.getMessage(), (Throwable)e);
            this.addErroreDuranteRecuperoDati(e);
            return null;
        }
        DynamicPdDBean.log.debug(e.getMessage(), (Throwable)e);
        if (e instanceof NotFoundException) {
            NotFoundException notFound = (NotFoundException)((Object)e);
            throw notFound;
        }
        throw new ServiceException(e.getMessage(), (Throwable)e);
    }

    protected void addErroreDuranteRecuperoDati(Exception e) {
        MessageUtils.addErrorMsg((String)("Si e' verificato un errore durante il recupero dei dati:" + e.getMessage()));
    }

    protected void addErroroInatteso(Exception e) {
        MessageUtils.addErrorMsg((String)("Si e' verificato un errore inatteso:" + e.getMessage()));
    }

    protected NotFoundException newDatiNonTrovatiException() {
        return new NotFoundException("Dati non trovati");
    }

    public abstract String getExportFilename();

    public String getExportFilenamePng() {
        return this.getExportFilename() + ".png";
    }

    public abstract String esportaCsv();

    public abstract void esportaCsv(HttpServletResponse var1) throws Exception;

    public abstract String esportaXls();

    public abstract void esportaXls(HttpServletResponse var1) throws Exception;

    public abstract String esportaPdf();

    public abstract void esportaPdf(HttpServletResponse var1) throws Exception;

    public abstract String esportaJson();

    public abstract void esportaJson(HttpServletResponse var1) throws Exception;

    public abstract String esportaXml();

    public abstract void esportaXml(HttpServletResponse var1) throws Exception;

    public boolean isVisualizzaComandiExport() {
        return this.visualizzaComandiExport;
    }

    public void setVisualizzaComandiExport(boolean visualizzaComandiExport) {
        this.visualizzaComandiExport = visualizzaComandiExport;
    }

    public Integer getSlice() {
        return this.slice;
    }

    public void setSlice(Integer slice) {
        this.slice = slice;
    }

    public Integer getMinCategorie() {
        return this.minCategorie;
    }

    public void setMinCategorie(Integer minCategorie) {
        this.minCategorie = minCategorie;
    }

    public Integer getMaxCategorie() {
        return this.maxCategorie;
    }

    public void setMaxCategorie(Integer maxCategorie) {
        this.maxCategorie = maxCategorie;
    }

    public Integer getLarghezzaGrafico() {
        return this.larghezzaGrafico;
    }

    public void setLarghezzaGrafico(Integer larghezzaGrafico) {
        this.larghezzaGrafico = larghezzaGrafico;
    }

    public Integer getInitLarghezzaGrafico() {
        return this.larghezzaGrafico;
    }

    public void setInitLarghezzaGrafico(Integer larghezzaGrafico) {
        this.larghezzaGrafico = larghezzaGrafico;
        this.maxLarghezzaGrafico = 4 * this.larghezzaGrafico;
        this.minLarghezzaGrafico = this.maxLarghezzaGrafico / 100;
    }

    public Integer getMinLarghezzaGrafico() {
        return this.minLarghezzaGrafico;
    }

    public void setMinLarghezzaGrafico(Integer minLarghezzaGrafico) {
        this.minLarghezzaGrafico = minLarghezzaGrafico;
    }

    public Integer getMaxLarghezzaGrafico() {
        return this.maxLarghezzaGrafico;
    }

    public void setMaxLarghezzaGrafico(Integer maxLarghezzaGrafico) {
        this.maxLarghezzaGrafico = maxLarghezzaGrafico;
    }

    public String getDirezioneLabel() {
        return this.direzioneLabel;
    }

    public void setDirezioneLabel(String direzioneLabel) {
        this.direzioneLabel = direzioneLabel;
    }

    public String getDir() {
        return this.dir;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public String getTipoMessaggio() {
        return this.tipoMessaggio;
    }

    public void setTipoMessaggio(String tipoMessaggio) {
        this.tipoMessaggio = tipoMessaggio;
    }

    public Boolean getIsVisualizzaPerDimensioneEnabled() {
        return this.isVisualizzaPerDimensioneEnabled;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getChartId() {
        return this.chartId;
    }

    public void setChartId(String chartId) {
        this.chartId = chartId;
    }

    public void updateChartDateOffset(ActionEvent e) {
        this.spostaIntervalloTemporale(e, this.getDir(), this.search);
    }

    public void spostaIntervalloTemporale(ActionEvent e, String dir, BaseSearchForm search) {
        Calendar c = Calendar.getInstance();
        int amount = 0;
        int field = 0;
        boolean spostamentoPerOra = false;
        if ("prev".equals(dir)) {
            amount = -1;
        } else if ("next".equals(dir)) {
            amount = 1;
        } else {
            search.setPeriodo(search.getPeriodo());
        }
        if ("Ieri".equals(search.getPeriodo())) {
            field = 5;
        } else if ("Ultime 12 ore".equals(search.getPeriodo())) {
            field = 11;
            spostamentoPerOra = true;
        } else if ("Ultime 24 ore".equals(search.getPeriodo())) {
            field = 5;
        } else if ("Ultima settimana".equals(search.getPeriodo())) {
            field = 6;
            if (amount != 0) {
                amount = amount > 0 ? 7 : -7;
            }
        } else if ("Ultimo mese".equals(search.getPeriodo())) {
            field = 6;
            if (amount != 0) {
                amount = amount > 0 ? 30 : -30;
            }
        } else if ("Ultimo anno".equals(search.getPeriodo())) {
            field = 1;
        } else if ("Personalizzato".equals(search.getPeriodo())) {
            long dist = search.getDataFine().getTime() - search.getDataInizio().getTime() + 1L;
            float f = dist / 3600000L;
            long hour = Math.round(f);
            float fDay = hour / 24L;
            long day = Math.round(fDay);
            if (hour < 24L) {
                field = 11;
                spostamentoPerOra = true;
            }
            if (hour >= 24L && day < 7L) {
                field = 5;
            }
            if (day >= 7L && day < 30L) {
                field = 6;
                if (amount != 0) {
                    amount = amount > 0 ? 7 : -7;
                }
            }
            if (day >= 30L) {
                field = 6;
                if (amount != 0) {
                    amount = amount > 0 ? 30 : -30;
                }
            }
        }
        if (amount != 0) {
            if (spostamentoPerOra) {
                c.setTime(search.getDataInizio());
                c.add(field, amount);
                search.setDataInizio(c.getTime());
                c.setTime(search.getDataFine());
                c.add(field, amount);
                search.setDataFine(c.getTime());
            } else if (amount > 0) {
                c.setTime((Date)search.getDataFine().clone());
                c.add(14, 1);
                search.setDataInizio(c.getTime());
                c.setTime(search.getDataFine());
                c.add(field, amount);
                search.setDataFine(c.getTime());
            } else {
                c.setTime((Date)search.getDataInizio().clone());
                c.add(14, -1);
                search.setDataFine(c.getTime());
                c.setTime(search.getDataInizio());
                c.add(field, amount);
                search.setDataInizio(c.getTime());
            }
        } else {
            search.setDataInizio(((StatsSearchForm)search).getDataInizioDellaRicerca());
            search.setDataFine(((StatsSearchForm)search).getDataFineDellaRicerca());
            search.setPeriodo(((StatsSearchForm)search).getPeriodoDellaRicerca());
        }
    }

    public String btnLblPrefix(BaseSearchForm search) {
        String lbl = "";
        if ("Ieri".equals(search.getPeriodo())) {
            lbl = "Giorno ";
        } else if ("Ultime 12 ore".equals(search.getPeriodo())) {
            lbl = "Ora ";
        } else if ("Ultime 24 ore".equals(search.getPeriodo())) {
            lbl = "Giorno ";
        } else if ("Ultima settimana".equals(search.getPeriodo())) {
            lbl = "Settimana ";
        } else if ("Ultimo mese".equals(search.getPeriodo())) {
            lbl = "Mese ";
        } else if ("Ultimo anno".equals(search.getPeriodo())) {
            lbl = "Anno ";
        } else if (search.getDataInizio() != null && search.getDataFine() != null) {
            long dist = search.getDataFine().getTime() - search.getDataInizio().getTime() + 1L;
            float f = dist / 3600000L;
            long hour = Math.round(f);
            float fDay = hour / 24L;
            long day = Math.round(fDay);
            if (hour < 24L) {
                lbl = "Ora ";
            }
            if (hour >= 24L && day < 7L) {
                lbl = "Giorno ";
            }
            if (day >= 7L && day < 30L) {
                lbl = "Settimana ";
            }
            if (day >= 30L) {
                lbl = "Mese ";
            }
        } else {
            lbl = "Intervallo ";
        }
        return lbl;
    }

    public String getPrevBtnLabel() {
        return this.btnLblPrefix(this.search) + " prec.";
    }

    public String getActualBtnLabel() {
        return this.btnLblPrefix(this.search) + " attuale.";
    }

    public String getNextBtnLabel() {
        return this.btnLblPrefix(this.search) + " succ.";
    }

    public String formatDate(Date date, boolean oraMinutiObbligatori) {
        Calendar c = null;
        try {
            c = DateManager.getCalendar();
        }
        catch (Exception e) {
            c = Calendar.getInstance();
        }
        c.setTime(date);
        StringBuilder bf = new StringBuilder("");
        if (oraMinutiObbligatori) {
            bf.append(" HH:mm");
        }
        SimpleDateFormat sdf = new SimpleDateFormat("dd MMMMM yyyy" + bf.toString(), ApplicationBean.getInstance().getLocale());
        return sdf.format(date);
    }

    public String submit() {
        return null;
    }

    public StatisticType getTempo() {
        StatisticType modalita = ((StatsSearchForm)this.search).getModalitaTemporale();
        if (modalita == null) {
            return StatisticType.GIORNALIERA;
        }
        return modalita;
    }

    public String get_value_tempo() {
        StatisticType modalita = ((StatsSearchForm)this.search).getModalitaTemporale();
        if (modalita == null) {
            return StatisticType.GIORNALIERA.toString().toLowerCase();
        }
        return modalita.toString().toLowerCase();
    }

    public String getLabelPaginaReport() {
        return "Report";
    }

    public Integer getNumeroLabelAsseXDistribuzioneTemporale() {
        return this.numeroLabelAsseXDistribuzioneTemporale;
    }

    public void setNumeroLabelAsseXDistribuzioneTemporale(Integer numeroLabelAsseXDistribuzioneTemporale) {
        this.numeroLabelAsseXDistribuzioneTemporale = numeroLabelAsseXDistribuzioneTemporale;
    }

    public boolean isNascondiComandoSelezioneNumeroLabelSeInferioreANumeroRisultati() {
        return this.nascondiComandoSelezioneNumeroLabelSeInferioreANumeroRisultati;
    }

    public void setNascondiComandoSelezioneNumeroLabelSeInferioreANumeroRisultati(boolean nascondiComandoSelezioneNumeroLabelSeInferioreANumeroRisultati) {
        this.nascondiComandoSelezioneNumeroLabelSeInferioreANumeroRisultati = nascondiComandoSelezioneNumeroLabelSeInferioreANumeroRisultati;
    }

    public void updateChartDirezioneLabel(ActionEvent e) {
    }

    public void updateChartNumeroRisultati(ActionEvent e) {
    }

    public void updateChartVisualizzaTotaleNelleCelleGraficoHeatmap(ActionEvent e) {
    }

    public boolean isVisualizzaTotaleNelleCelleGraficoHeatmap() {
        return this.visualizzaTotaleNelleCelleGraficoHeatmap;
    }

    public void setVisualizzaTotaleNelleCelleGraficoHeatmap(boolean visualizzaTotaleNelleCelleGraficoHeatmap) {
        this.visualizzaTotaleNelleCelleGraficoHeatmap = visualizzaTotaleNelleCelleGraficoHeatmap;
    }

    public void setTipoDistribuzione(String tipoDistribuzione) {
        this.tipoDistribuzione = tipoDistribuzione;
        if (this.search != null) {
            ((StatsSearchForm)this.search).setTipoDistribuzione(tipoDistribuzione);
        }
    }

    public String getTipoDistribuzione() {
        return this.tipoDistribuzione;
    }
}

