/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.statistiche.mbean;

import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.transazioni.constants.PddRuolo;
import org.openspcoop2.protocol.engine.utils.NamingUtils;
import org.openspcoop2.web.monitor.core.bean.SelectItem;
import org.openspcoop2.web.monitor.core.core.Utility;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.openspcoop2.web.monitor.core.mbean.DynamicPdDBean;
import org.openspcoop2.web.monitor.core.utils.MessageUtils;
import org.openspcoop2.web.monitor.statistiche.bean.ConfigurazioneGenerale;
import org.openspcoop2.web.monitor.statistiche.bean.ConfigurazioneGeneralePK;
import org.openspcoop2.web.monitor.statistiche.bean.ConfigurazioniGeneraliSearchForm;
import org.openspcoop2.web.monitor.statistiche.dao.IConfigurazioniGeneraliService;
import org.slf4j.Logger;

public class ConfigurazioniGeneraliBean
extends DynamicPdDBean<ConfigurazioneGenerale, ConfigurazioneGeneralePK, IConfigurazioniGeneraliService> {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerManager.getPddMonitorCoreLogger();
    private String labelInformazioniGenerali = "Registro";
    private String labelInformazioniServizi = "API";
    private boolean includiInformazioniDettaglio = false;
    private ConfigurazioneGeneralePK selectedId = null;
    private String exportCsvErrorMessage = null;
    private List<javax.faces.model.SelectItem> exportDisponibili = null;
    private String tipoExport = "csv";

    public String submit() {
        return "configurazioniGenerali";
    }

    public String filtra() {
        return this.search.filtra();
    }

    public ConfigurazioneGeneralePK getSelectedId() {
        return this.selectedId;
    }

    public void setSelectedId(ConfigurazioneGeneralePK selectedId) {
        this.selectedId = selectedId;
        if (this.selectedId != null) {
            log.debug("Lettura del dettaglio per l'elemento: [{}]", (Object)this.selectedId);
            ConfigurazioneGenerale findById = (ConfigurazioneGenerale)((IConfigurazioniGeneraliService)this.service).findById(this.selectedId);
            this.setSelectedElement(findById);
        }
    }

    public boolean isAbilitaGestioneGruppiInConfigurazione() {
        return true;
    }

    public void setSelectedElement(ConfigurazioneGenerale selectedElement) {
        super.setSelectedElement((Object)selectedElement);
    }

    public List<javax.faces.model.SelectItem> getSoggetti() throws Exception {
        if (this.search == null) {
            return new ArrayList<javax.faces.model.SelectItem>();
        }
        return this._getSoggetti(true, false, null);
    }

    public List<SelectItem> soggettiErogatoreAutoComplete(Object val) throws Exception {
        ArrayList<SelectItem> listaSoggetti = new ArrayList<SelectItem>();
        List<Object> listaSoggettiTmp = new ArrayList<javax.faces.model.SelectItem>();
        if (val != null && !StringUtils.isEmpty((CharSequence)((String)val)) && this.search != null) {
            listaSoggettiTmp = this._getSoggetti(true, false, (String)val);
        }
        listaSoggettiTmp.add(0, new javax.faces.model.SelectItem((Object)"--", "--"));
        for (javax.faces.model.SelectItem selectItem : listaSoggettiTmp) {
            String label = selectItem.getLabel();
            String value = (String)selectItem.getValue();
            SelectItem newItem = new SelectItem(value, label);
            listaSoggetti.add(newItem);
        }
        return listaSoggetti;
    }

    public List<javax.faces.model.SelectItem> getTipiNomiSoggettiAssociati() throws Exception {
        return this._getTipiNomiSoggettiAssociati(true);
    }

    protected List<javax.faces.model.SelectItem> _getServizi(String input) throws Exception {
        if (this.search == null) {
            return new ArrayList<javax.faces.model.SelectItem>();
        }
        if (!this.serviziSelectItemsWidthCheck) {
            this.servizi = new ArrayList();
            String tipoSoggetto = this.search.getTipoSoggettoLocale();
            String nomeSoggetto = this.search.getSoggettoLocale();
            String tipoProtocollo = this.search.getProtocollo();
            PddRuolo ruoloReport = ((ConfigurazioniGeneraliSearchForm)this.search).getTipologiaTransazioni();
            String gruppo = this.search.getGruppo();
            IDAccordo idAccordo = null;
            String api = this.search.getApi();
            if (api != null && !"".equals(api)) {
                idAccordo = IDAccordoFactory.getInstance().getIDAccordoFromUri(api);
            }
            boolean distinct = true;
            this.servizi = ruoloReport == null || ruoloReport.equals((Object)PddRuolo.DELEGATA) ? this.dynamicUtils.getListaSelectItemsElencoConfigurazioneServiziFruizione(tipoProtocollo, gruppo, idAccordo, tipoSoggetto, nomeSoggetto, null, null, input, false, this.search.getPermessiUtenteOperatore(), distinct) : this.dynamicUtils.getListaSelectItemsElencoConfigurazioneServiziErogazione(tipoProtocollo, gruppo, idAccordo, tipoSoggetto, nomeSoggetto, input, true, this.search.getPermessiUtenteOperatore(), distinct);
            Integer lunghezzaSelectList = this.dynamicUtils.getLunghezzaSelectList(this.servizi);
            this.serviziSelectItemsWidth = Math.max(this.serviziSelectItemsWidth, lunghezzaSelectList);
        }
        return this.servizi;
    }

    public List<ConfigurazioneGenerale> getListaConfigurazioniGenerali() {
        try {
            return ((IConfigurazioniGeneraliService)this.service).findAllInformazioniGenerali();
        }
        catch (Exception e) {
            log.error("Errore durante la lettura delle configurazioni generali: " + e.getMessage(), (Throwable)e);
            return new ArrayList<ConfigurazioneGenerale>();
        }
    }

    public List<ConfigurazioneGenerale> getListaConfigurazioniServizi() {
        try {
            return ((IConfigurazioniGeneraliService)this.service).findAllInformazioniServizi();
        }
        catch (Exception e) {
            log.error("Errore durante la lettura delle configurazioni servizi: " + e.getMessage(), (Throwable)e);
            return new ArrayList<ConfigurazioneGenerale>();
        }
    }

    public String getLabelInformazioniGenerali() {
        return this.labelInformazioniGenerali;
    }

    public void setLabelInformazioniGenerali(String labelInformazioniGenerali) {
        this.labelInformazioniGenerali = labelInformazioniGenerali;
    }

    public String getLabelInformazioniServizi() throws Exception {
        if (this.getSearch() != null) {
            String tipoProtocollo = this.getSearch().getProtocollo();
            if (StringUtils.isNotBlank((CharSequence)this.getSearch().getNomeServizio())) {
                IDServizio idServizio = Utility.parseServizioSoggetto((String)this.getSearch().getNomeServizio());
                String label = tipoProtocollo != null ? NamingUtils.getLabelAccordoServizioParteSpecifica((String)tipoProtocollo, (IDServizio)idServizio) : NamingUtils.getLabelAccordoServizioParteSpecifica((IDServizio)idServizio);
                this.labelInformazioniServizi = MessageFormat.format("API {0}", label);
            } else if (this.getSearch().getTipoNomeSoggettoLocale() != null && !StringUtils.isEmpty((CharSequence)this.getSearch().getTipoNomeSoggettoLocale()) && !"--".equals(this.getSearch().getTipoNomeSoggettoLocale())) {
                String tipoSoggetto = this.getSearch().getTipoSoggettoLocale();
                String nomeSoggetto = this.getSearch().getSoggettoLocale();
                if (nomeSoggetto != null && !"qualsiasi".equals(nomeSoggetto)) {
                    IDSoggetto idSoggetto = new IDSoggetto(tipoSoggetto, nomeSoggetto);
                    String label = tipoProtocollo != null ? NamingUtils.getLabelSoggetto((String)tipoProtocollo, (IDSoggetto)idSoggetto) : NamingUtils.getLabelSoggetto((IDSoggetto)idSoggetto);
                    this.labelInformazioniServizi = MessageFormat.format("API del Soggetto {0}", label);
                } else {
                    this.labelInformazioniServizi = "API";
                }
            } else {
                this.labelInformazioniServizi = "API";
            }
        }
        return this.labelInformazioniServizi;
    }

    public void setLabelInformazioniServizi(String labelInformazioniServizi) {
        this.labelInformazioniServizi = labelInformazioniServizi;
    }

    public boolean isIncludiInformazioniDettaglio() {
        return this.includiInformazioniDettaglio;
    }

    public void setIncludiInformazioniDettaglio(boolean includiInformazioniDettaglio) {
        this.includiInformazioniDettaglio = includiInformazioniDettaglio;
    }

    public void initExportListener(ActionEvent ae) {
        super.initExportListener(ae);
        this.includiInformazioniDettaglio = false;
        this.tipoExport = "csv";
    }

    public String exportSelected() {
        try {
            String formatoExport = this.getTipoExport();
            ArrayList idReport = new ArrayList();
            if (this.elencoID != null && this.elencoID.length() > 0) {
                String[] split = this.elencoID.split(",");
                ArrayList<String> orderFix = new ArrayList<String>();
                for (String idString : split) {
                    String tmpId = idString.substring(0, idString.lastIndexOf(":"));
                    tmpId = tmpId.substring(tmpId.lastIndexOf(":") + 1);
                    orderFix.add(tmpId);
                }
                idReport.addAll(orderFix);
            }
            FacesContext context = FacesContext.getCurrentInstance();
            HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
            HttpSession sessione = (HttpSession)context.getExternalContext().getSession(false);
            sessione.setAttribute("idsOriginali", (Object)StringUtils.join(idReport, (String)","));
            sessione.setAttribute("isAllOriginale", (Object)this.isSelectedAll());
            sessione.setAttribute("ruoloOriginale", (Object)((ConfigurazioniGeneraliSearchForm)this.search).get_value_tipologiaTransazioni());
            sessione.setAttribute("fExOriginali", (Object)formatoExport);
            response.sendRedirect(context.getExternalContext().getRequestContextPath() + "/configurazioniexporter?isAll=" + this.isSelectedAll() + "&ids=" + StringUtils.join(idReport, (String)",") + "&ruolo=" + ((ConfigurazioniGeneraliSearchForm)this.search).get_value_tipologiaTransazioni() + "&formatoConfigurazione=" + formatoExport);
            context.responseComplete();
        }
        catch (Exception e) {
            FacesContext.getCurrentInstance().responseComplete();
            log.error(e.getMessage(), (Throwable)e);
            MessageUtils.addErrorMsg((String)"Si e' verificato un errore durante l'esportazione delle configurazioni selezionate.");
        }
        return null;
    }

    public boolean isShowFiltroSoggetti() {
        return Utility.isMultitenantAbilitato();
    }

    public void esportazioneSelectListener(ActionEvent ae) {
    }

    public String visualizzaExportCsv() {
        return null;
    }

    public String getExportCsvErrorMessage() {
        return this.exportCsvErrorMessage;
    }

    public void setExportCsvErrorMessage(String exportCsvErrorMessage) {
        this.exportCsvErrorMessage = exportCsvErrorMessage;
    }

    public List<javax.faces.model.SelectItem> getExportDisponibili() {
        if (this.exportDisponibili == null) {
            this.exportDisponibili = new ArrayList<javax.faces.model.SelectItem>();
            this.exportDisponibili.add(new javax.faces.model.SelectItem((Object)"csv", "csv".toUpperCase()));
            this.exportDisponibili.add(new javax.faces.model.SelectItem((Object)"xls", "xls".toUpperCase()));
        }
        return this.exportDisponibili;
    }

    public void setExportDisponibili(List<javax.faces.model.SelectItem> exportDisponibili) {
        this.exportDisponibili = exportDisponibili;
    }

    public String getTipoExport() {
        return this.tipoExport;
    }

    public void setTipoExport(String tipoExport) {
        this.tipoExport = tipoExport;
    }
}

