/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.statistiche.servlet;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.statistiche.dao.jdbc.JDBCStream;
import org.openspcoop2.utils.CopyStream;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.date.DateUtils;
import org.openspcoop2.utils.transport.http.HttpUtilities;
import org.openspcoop2.web.lib.users.dao.User;
import org.openspcoop2.web.monitor.core.bean.AbstractCoreSearchForm;
import org.openspcoop2.web.monitor.core.bean.LoginBean;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.openspcoop2.web.monitor.statistiche.bean.StatistichePdndTracingBean;
import org.openspcoop2.web.monitor.statistiche.bean.StatistichePdndTracingSearchForm;
import org.openspcoop2.web.monitor.statistiche.dao.IStatistichePdndTracingService;
import org.openspcoop2.web.monitor.statistiche.dao.StatistichePdndTracingService;
import org.slf4j.Logger;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class StatistichePdndTracingExporter
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerManager.getPddMonitorCoreLogger();

    private static void logError(String msg, Exception e) {
        if (log != null) {
            if (e != null) {
                log.error(msg, (Throwable)e);
            } else {
                log.error(msg);
            }
        }
    }

    public void init() throws ServletException {
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.processRequest(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.processRequest(req, resp);
    }

    private void processRequest(HttpServletRequest req, HttpServletResponse resp) {
        try {
            boolean exportConsentito;
            WebApplicationContext context = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
            if (context == null) {
                throw new CoreException("Param context is null");
            }
            IStatistichePdndTracingService service = (IStatistichePdndTracingService)context.getBean("statistichePdndTracingService");
            StatistichePdndTracingSearchForm sfInSession = (StatistichePdndTracingSearchForm)context.getBean("statistichePdndTracingSearchForm");
            StatistichePdndTracingSearchForm searchForm = (StatistichePdndTracingSearchForm)sfInSession.clone();
            User utente = null;
            String modalita = null;
            LoginBean lbInSession = (LoginBean)context.getBean("loginBean");
            if (lbInSession != null && lbInSession.isLoggedIn()) {
                utente = lbInSession.getUtente();
                modalita = lbInSession.getModalita();
            }
            searchForm.setUser(utente);
            searchForm.setModalita(modalita);
            searchForm.saveProtocollo();
            service.setSearch((AbstractCoreSearchForm)searchForm);
            HttpServletResponse response = resp;
            String isAllString = req.getParameter("isAll");
            Boolean isAll = Boolean.parseBoolean(isAllString);
            String idtransazioni = req.getParameter("ids");
            String[] ids = StringUtils.split((String)idtransazioni, (String)",");
            HttpSession sessione = req.getSession();
            Boolean isAllFromSession = (Boolean)sessione.getAttribute("isAllOriginale");
            String idTransazioniFromSession = (String)sessione.getAttribute("idsOriginali");
            sessione.removeAttribute("isAllOriginale");
            sessione.removeAttribute("idsOriginali");
            String[] idsFromSession = StringUtils.split((String)idTransazioniFromSession, (String)",");
            boolean bl = exportConsentito = StatistichePdndTracingExporter.checkParametroIsAll(isAll, isAllFromSession) && StatistichePdndTracingExporter.checkParametroIds(isAll, ids, idsFromSession);
            if (!exportConsentito) {
                String msgErrore = "L'utente non dispone dei permessi necessari per effettuare l'export dei csv.";
                String redirectUrl = req.getContextPath() + "/public/error.jsf?msg_errore=" + msgErrore;
                response.sendRedirect(redirectUrl);
                return;
            }
            StatistichePdndTracingExporter.export(response, isAllFromSession, service, idsFromSession);
        }
        catch (Exception e) {
            StatistichePdndTracingExporter.logError(e.getMessage(), e);
        }
    }

    public static void export(HttpServletResponse response, Boolean isAll, IStatistichePdndTracingService service, String[] ids) throws ServletException, IOException {
        try {
            List<StatistichePdndTracingBean> lst = StatistichePdndTracingExporter.leggiCsvDaEsportare(isAll, service, ids);
            if (!lst.isEmpty()) {
                StatistichePdndTracingExporter.esportaRisultati(lst, response, service);
            } else {
                String fileName = "Errors.txt";
                HttpUtilities.setOutputFile((HttpServletResponse)response, (boolean)true, (String)fileName);
                response.setStatus(200);
                response.flushBuffer();
                String msgErrore = "La configurazione di export selezionata non ha prodotto nessun csv valido";
                response.getWriter().write(msgErrore);
            }
        }
        catch (IOException | UtilsException e) {
            StatistichePdndTracingExporter.logError(e.getMessage(), (Exception)e);
            throw new ServletException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void esportaRisultati(List<StatistichePdndTracingBean> lst, HttpServletResponse response, IStatistichePdndTracingService service) throws IOException, UtilsException {
        String fileName = "StatisticheTracingPdnd.zip";
        String contentType = "text/csv";
        String rootDir = "StatisticheTracingPdnd" + File.separatorChar;
        StatistichePdndTracingService pdndService = (StatistichePdndTracingService)service;
        try {
            HttpUtilities.setOutputFile((HttpServletResponse)response, (boolean)true, (String)fileName, (String)contentType);
            ZipOutputStream zip = new ZipOutputStream((OutputStream)response.getOutputStream());
            for (StatistichePdndTracingBean statistichePdndTracingBean : lst) {
                JDBCStream jdbcStream = null;
                try {
                    jdbcStream = pdndService.getCsvInputStream(statistichePdndTracingBean.getId());
                    InputStream csvStream = jdbcStream.getIs();
                    try {
                        if (csvStream == null) continue;
                        String entryFileName = StatistichePdndTracingExporter.getCsvFileName(statistichePdndTracingBean);
                        String soggettoDirName = StatistichePdndTracingExporter.getNomeDirectorySoggetto(statistichePdndTracingBean);
                        String nomeEntry = rootDir + soggettoDirName + File.separatorChar + entryFileName;
                        zip.putNextEntry(new ZipEntry(nomeEntry));
                        CopyStream.copy((InputStream)csvStream, (OutputStream)zip);
                        zip.flush();
                        zip.closeEntry();
                    }
                    finally {
                        if (csvStream == null) continue;
                        csvStream.close();
                    }
                }
                finally {
                    if (jdbcStream == null) continue;
                    jdbcStream.closeJdbcResources();
                }
            }
            zip.flush();
            zip.close();
            response.setStatus(200);
            response.flushBuffer();
        }
        catch (IOException | UtilsException e) {
            StatistichePdndTracingExporter.logError(e.getMessage(), (Exception)e);
            throw e;
        }
    }

    private static List<StatistichePdndTracingBean> leggiCsvDaEsportare(Boolean isAll, IStatistichePdndTracingService service, String[] ids) {
        ArrayList<StatistichePdndTracingBean> lst = new ArrayList<StatistichePdndTracingBean>();
        if (isAll != null && isAll.booleanValue()) {
            int offset = 0;
            int letti = 0;
            int limit = 25;
            List lstTmp = null;
            do {
                if ((letti = (lstTmp = service.findAll(offset, limit)).size()) <= 0) continue;
                lst.addAll(lstTmp);
                ++offset;
            } while (letti > 0);
        } else {
            for (String idString : ids) {
                StatistichePdndTracingBean findById = (StatistichePdndTracingBean)((Object)service.findById(Long.parseLong(idString)));
                lst.add(findById);
            }
        }
        return lst;
    }

    private static boolean checkParametroIsAll(Boolean isAll, Boolean isAllFromSession) {
        return isAll != null && isAllFromSession != null && isAll.booleanValue() == isAllFromSession.booleanValue();
    }

    private static boolean checkParametroIds(Boolean isAll, String[] ids, String[] idsFromSession) {
        if (!(ids != null && ids.length != 0 && idsFromSession != null && idsFromSession.length != 0 || isAll.booleanValue())) {
            return false;
        }
        if (ids != null && idsFromSession != null && ids.length != idsFromSession.length) {
            return false;
        }
        return StatistichePdndTracingExporter.checkMatchParametroIds(ids, idsFromSession);
    }

    private static boolean checkMatchParametroIds(String[] ids, String[] idsFromSession) {
        if (ids != null) {
            for (String id : ids) {
                boolean found = false;
                for (String idFromSession : idsFromSession) {
                    if (!id.equals(idFromSession)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
        }
        return true;
    }

    public static String getNomeDirectorySoggetto(StatistichePdndTracingBean statistichePdndTracingBean) {
        return statistichePdndTracingBean.getSoggettoReadable().replace("/", "_");
    }

    public static String getCsvFileName(StatistichePdndTracingBean statistichePdndTracingBean) {
        String dataTracciamentoAsString = DateUtils.getDefaultDateTimeFormatterDay().format(statistichePdndTracingBean.getDataTracciamento());
        Object tracingId = StringUtils.isNotEmpty((CharSequence)statistichePdndTracingBean.getTracingId()) ? statistichePdndTracingBean.getTracingId() : "csv_" + statistichePdndTracingBean.getId();
        return dataTracciamentoAsString + "_" + (String)tracingId + ".csv";
    }
}

