/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.statistiche.utils;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.commons.search.AccordoServizioParteComune;
import org.openspcoop2.core.commons.search.AccordoServizioParteComuneAzione;
import org.openspcoop2.core.commons.search.AccordoServizioParteSpecifica;
import org.openspcoop2.core.commons.search.Fruitore;
import org.openspcoop2.core.commons.search.IdAccordoServizioParteComune;
import org.openspcoop2.core.commons.search.IdAccordoServizioParteSpecifica;
import org.openspcoop2.core.commons.search.IdFruitore;
import org.openspcoop2.core.commons.search.IdPortType;
import org.openspcoop2.core.commons.search.IdSoggetto;
import org.openspcoop2.core.commons.search.Operation;
import org.openspcoop2.core.commons.search.PortType;
import org.openspcoop2.core.commons.search.PortaApplicativa;
import org.openspcoop2.core.commons.search.Resource;
import org.openspcoop2.core.commons.search.dao.IServiceManager;
import org.openspcoop2.core.config.Connettore;
import org.openspcoop2.core.config.InvocazioneCredenziali;
import org.openspcoop2.core.config.PortaApplicativaAzione;
import org.openspcoop2.core.config.PortaApplicativaServizioApplicativo;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.PortaDelegataAzione;
import org.openspcoop2.core.config.PortaDelegataServizioApplicativo;
import org.openspcoop2.core.config.Property;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.config.constants.TipoAutorizzazione;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB;
import org.openspcoop2.core.constants.TipiConnettore;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDRuolo;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.registry.ConfigurazioneServizioAzione;
import org.openspcoop2.core.registry.Ruolo;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB;
import org.openspcoop2.generic_project.exception.ExpressionException;
import org.openspcoop2.generic_project.exception.ExpressionNotImplementedException;
import org.openspcoop2.generic_project.exception.MultipleResultException;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.generic_project.exception.NotImplementedException;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.generic_project.expression.IPaginatedExpression;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.web.monitor.statistiche.bean.DettaglioPA;
import org.openspcoop2.web.monitor.statistiche.bean.DettaglioPD;

public class ConfigurazioniUtils {
    private ConfigurazioniUtils() {
    }

    public static void fillAzioniPD(DettaglioPD dettaglioPD, IServiceManager serviceManager) throws ServiceException, NotFoundException, MultipleResultException, NotImplementedException, ExpressionNotImplementedException, ExpressionException {
        AccordoServizioParteSpecifica asps = ConfigurazioniUtils.getAspsFromValues(dettaglioPD.getPortaDelegata().getTipoSoggettoErogatore(), dettaglioPD.getPortaDelegata().getNomeSoggettoErogatore(), dettaglioPD.getPortaDelegata().getTipoServizio(), dettaglioPD.getPortaDelegata().getNomeServizio(), dettaglioPD.getPortaDelegata().getVersioneServizio(), serviceManager);
        dettaglioPD.setIdAccordoServizioParteComune(asps.getIdAccordoServizioParteComune());
        dettaglioPD.setPortType(asps.getPortType());
        ConfigurazioniUtils.fillAzioni(dettaglioPD.getAzioni(), serviceManager, asps, "rest".equalsIgnoreCase(asps.getIdAccordoServizioParteComune().getServiceBinding()));
    }

    public static ServiceBinding getServiceBindingFromValues(String tipoSoggettoErogatore, String nomeSoggettoErogatore, String tipoServizio, String nomeServizio, Integer versioneServizio, IServiceManager serviceManager) throws ServiceException, NotFoundException, MultipleResultException, NotImplementedException {
        IdAccordoServizioParteSpecifica idAPS = new IdAccordoServizioParteSpecifica();
        IdSoggetto idErogatore = new IdSoggetto();
        idErogatore.setTipo(tipoSoggettoErogatore);
        idErogatore.setNome(nomeSoggettoErogatore);
        idAPS.setIdErogatore(idErogatore);
        idAPS.setTipo(tipoServizio);
        idAPS.setNome(nomeServizio);
        idAPS.setVersione(versioneServizio);
        AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)serviceManager.getAccordoServizioParteSpecificaServiceSearch().get((Object)idAPS);
        AccordoServizioParteComune aspc = (AccordoServizioParteComune)serviceManager.getAccordoServizioParteComuneServiceSearch().get((Object)asps.getIdAccordoServizioParteComune());
        return ServiceBinding.valueOf((String)aspc.getServiceBinding().toUpperCase());
    }

    private static AccordoServizioParteSpecifica getAspsFromValues(String tipoSoggettoErogatore, String nomeSoggettoErogatore, String tipoServizio, String nomeServizio, Integer versioneServizio, IServiceManager serviceManager) throws ServiceException, NotFoundException, MultipleResultException, NotImplementedException {
        IdAccordoServizioParteSpecifica idAPS = new IdAccordoServizioParteSpecifica();
        IdSoggetto idErogatore = new IdSoggetto();
        idErogatore.setTipo(tipoSoggettoErogatore);
        idErogatore.setNome(nomeSoggettoErogatore);
        idAPS.setIdErogatore(idErogatore);
        idAPS.setTipo(tipoServizio);
        idAPS.setNome(nomeServizio);
        idAPS.setVersione(versioneServizio);
        return (AccordoServizioParteSpecifica)serviceManager.getAccordoServizioParteSpecificaServiceSearch().get((Object)idAPS);
    }

    public static void fillAzioniPA(DettaglioPA dettaglioPA, IServiceManager serviceManager) throws ServiceException, NotFoundException, MultipleResultException, NotImplementedException, ExpressionNotImplementedException, ExpressionException {
        AccordoServizioParteSpecifica asps = ConfigurazioniUtils.getAspsFromValues(dettaglioPA.getPortaApplicativa().getIdSoggetto().getTipo(), dettaglioPA.getPortaApplicativa().getIdSoggetto().getNome(), dettaglioPA.getPortaApplicativa().getTipoServizio(), dettaglioPA.getPortaApplicativa().getNomeServizio(), dettaglioPA.getPortaApplicativa().getVersioneServizio(), serviceManager);
        dettaglioPA.setIdAccordoServizioParteComune(asps.getIdAccordoServizioParteComune());
        dettaglioPA.setPortType(asps.getPortType());
        ConfigurazioniUtils.fillAzioni(dettaglioPA.getAzioni(), serviceManager, asps, "rest".equalsIgnoreCase(asps.getIdAccordoServizioParteComune().getServiceBinding()));
    }

    private static void fillAzioni(List<String> azioni, IServiceManager serviceManager, AccordoServizioParteSpecifica asps, boolean rest) throws ServiceException, NotFoundException, MultipleResultException, NotImplementedException, ExpressionNotImplementedException, ExpressionException {
        block4: {
            block5: {
                block3: {
                    if (!rest) break block3;
                    IPaginatedExpression expr = serviceManager.getResourceServiceSearch().newPaginatedExpression();
                    expr.and();
                    expr.equals(Resource.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.NOME, (Object)asps.getIdAccordoServizioParteComune().getNome());
                    expr.equals(Resource.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.VERSIONE, (Object)asps.getIdAccordoServizioParteComune().getVersione());
                    expr.equals(Resource.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.ID_SOGGETTO.TIPO, (Object)asps.getIdAccordoServizioParteComune().getIdSoggetto().getTipo());
                    expr.equals(Resource.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.ID_SOGGETTO.NOME, (Object)asps.getIdAccordoServizioParteComune().getIdSoggetto().getNome());
                    List listAz = serviceManager.getResourceServiceSearch().findAll(expr);
                    for (Resource accordoServizioParteComuneAzione : listAz) {
                        azioni.add(accordoServizioParteComuneAzione.getHttpMethod() + " " + accordoServizioParteComuneAzione.getPath());
                    }
                    break block4;
                }
                if (asps.getPortType() == null) break block5;
                IdPortType idPT = new IdPortType();
                idPT.setIdAccordoServizioParteComune(asps.getIdAccordoServizioParteComune());
                idPT.setNome(asps.getPortType());
                PortType pt = (PortType)serviceManager.getPortTypeServiceSearch().get((Object)idPT);
                if (pt == null) break block4;
                IPaginatedExpression expr = serviceManager.getOperationServiceSearch().newPaginatedExpression();
                expr.and();
                expr.equals(Operation.model().ID_PORT_TYPE.NOME, (Object)pt.getNome());
                expr.equals(Operation.model().ID_PORT_TYPE.ID_ACCORDO_SERVIZIO_PARTE_COMUNE.NOME, (Object)asps.getIdAccordoServizioParteComune().getNome());
                expr.equals(Operation.model().ID_PORT_TYPE.ID_ACCORDO_SERVIZIO_PARTE_COMUNE.VERSIONE, (Object)asps.getIdAccordoServizioParteComune().getVersione());
                expr.equals(Operation.model().ID_PORT_TYPE.ID_ACCORDO_SERVIZIO_PARTE_COMUNE.ID_SOGGETTO.TIPO, (Object)asps.getIdAccordoServizioParteComune().getIdSoggetto().getTipo());
                expr.equals(Operation.model().ID_PORT_TYPE.ID_ACCORDO_SERVIZIO_PARTE_COMUNE.ID_SOGGETTO.NOME, (Object)asps.getIdAccordoServizioParteComune().getIdSoggetto().getNome());
                List listAz = serviceManager.getOperationServiceSearch().findAll(expr);
                for (Operation accordoServizioParteComuneAzione : listAz) {
                    azioni.add(accordoServizioParteComuneAzione.getNome());
                }
                break block4;
            }
            IPaginatedExpression expr = serviceManager.getAccordoServizioParteComuneAzioneServiceSearch().newPaginatedExpression();
            expr.and();
            expr.equals(AccordoServizioParteComuneAzione.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.NOME, (Object)asps.getIdAccordoServizioParteComune().getNome());
            expr.equals(AccordoServizioParteComuneAzione.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.VERSIONE, (Object)asps.getIdAccordoServizioParteComune().getVersione());
            expr.equals(AccordoServizioParteComuneAzione.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.ID_SOGGETTO.TIPO, (Object)asps.getIdAccordoServizioParteComune().getIdSoggetto().getTipo());
            expr.equals(AccordoServizioParteComuneAzione.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.ID_SOGGETTO.NOME, (Object)asps.getIdAccordoServizioParteComune().getIdSoggetto().getNome());
            List listAz = serviceManager.getAccordoServizioParteComuneAzioneServiceSearch().findAll(expr);
            for (AccordoServizioParteComuneAzione accordoServizioParteComuneAzione : listAz) {
                azioni.add(accordoServizioParteComuneAzione.getNome());
            }
        }
    }

    public static void fillFruitori(String tipoSoggettoErogatore, String nomeSoggettoErogatore, String tipoServizio, String nomeServizio, List<String> fruitori, IServiceManager serviceManager) throws ServiceException, NotImplementedException, ExpressionNotImplementedException, ExpressionException {
        IPaginatedExpression expr = serviceManager.getFruitoreServiceSearch().newPaginatedExpression();
        expr.and();
        expr.equals(Fruitore.model().ID_ACCORDO_SERVIZIO_PARTE_SPECIFICA.ID_EROGATORE.TIPO, (Object)tipoSoggettoErogatore);
        expr.equals(Fruitore.model().ID_ACCORDO_SERVIZIO_PARTE_SPECIFICA.ID_EROGATORE.NOME, (Object)nomeSoggettoErogatore);
        expr.equals(Fruitore.model().ID_ACCORDO_SERVIZIO_PARTE_SPECIFICA.TIPO, (Object)tipoServizio);
        expr.equals(Fruitore.model().ID_ACCORDO_SERVIZIO_PARTE_SPECIFICA.NOME, (Object)nomeServizio);
        List ids = serviceManager.getFruitoreServiceSearch().findAllIds(expr);
        for (IdFruitore idFruitore : ids) {
            fruitori.add(idFruitore.getIdFruitore().getTipo() + "/" + idFruitore.getIdFruitore().getNome());
        }
    }

    public static Connettore getConnettore(String tipoFruitore, String nomeFruitore, String tipoSoggettoErogatore, String nomeSoggettoErogatore, String tipoServizio, String nomeServizio, Integer versioneServizio, List<String> azioniGruppo, DriverRegistroServiziDB driverRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        IDServizio idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(tipoServizio, nomeServizio, tipoSoggettoErogatore, nomeSoggettoErogatore, versioneServizio.intValue());
        org.openspcoop2.core.registry.AccordoServizioParteSpecifica aspsOp2 = driverRegistro.getAccordoServizioParteSpecifica(idServizio);
        for (org.openspcoop2.core.registry.Fruitore frOp2 : aspsOp2.getFruitoreList()) {
            if (!frOp2.getTipo().equals(tipoFruitore) || !frOp2.getNome().equals(nomeFruitore)) continue;
            if (azioniGruppo != null && !azioniGruppo.isEmpty()) {
                if (frOp2.sizeConfigurazioneAzioneList() <= 0) break;
                for (ConfigurazioneServizioAzione az : frOp2.getConfigurazioneAzioneList()) {
                    boolean find = false;
                    if (az.getAzioneList() != null && !az.getAzioneList().isEmpty()) {
                        for (String azCheck : azioniGruppo) {
                            if (!az.getAzioneList().contains(azCheck)) continue;
                            find = true;
                            break;
                        }
                    }
                    if (!find || az.getConnettore() == null || TipiConnettore.DISABILITATO.getNome().equals(az.getConnettore().getTipo())) continue;
                    return az.getConnettore().mappingIntoConnettoreConfigurazione();
                }
                break;
            }
            if (frOp2.getConnettore() == null || TipiConnettore.DISABILITATO.getNome().equals(frOp2.getConnettore().getTipo())) break;
            return frOp2.getConnettore().mappingIntoConnettoreConfigurazione();
        }
        if (aspsOp2.getConfigurazioneServizio() != null && aspsOp2.getConfigurazioneServizio().getConnettore() != null && !TipiConnettore.DISABILITATO.getNome().equals(aspsOp2.getConfigurazioneServizio().getConnettore().getTipo())) {
            return aspsOp2.getConfigurazioneServizio().getConnettore().mappingIntoConnettoreConfigurazione();
        }
        return driverRegistro.getSoggetto(idServizio.getSoggettoErogatore()).getConnettore().mappingIntoConnettoreConfigurazione();
    }

    public static List<Property> printConnettore(Connettore connettore, String labelTipoConnettore, InvocazioneCredenziali invCredenziali) {
        Property p;
        long idx;
        ArrayList<Property> lst;
        block24: {
            block25: {
                block26: {
                    block23: {
                        String proxy;
                        lst = new ArrayList<Property>();
                        idx = 0L;
                        p = new Property();
                        p.setId(Long.valueOf(idx++));
                        p.setNome(labelTipoConnettore);
                        p.setValore(connettore.getTipo());
                        lst.add(p);
                        if (!TipiConnettore.HTTP.getNome().equals(connettore.getTipo()) && !TipiConnettore.HTTPS.getNome().equals(connettore.getTipo())) break block23;
                        p = new Property();
                        p.setId(Long.valueOf(idx++));
                        p.setNome("URL");
                        p.setValore(ConfigurazioniUtils.getProperty("location", connettore.getPropertyList()));
                        lst.add(p);
                        if (invCredenziali != null) {
                            p = new Property();
                            p.setId(Long.valueOf(idx++));
                            p.setNome("HttpBasic Username");
                            p.setValore(invCredenziali.getUser());
                            lst.add(p);
                        } else {
                            String username = ConfigurazioniUtils.getProperty("user", connettore.getPropertyList());
                            if (username != null) {
                                p = new Property();
                                p.setId(Long.valueOf(idx++));
                                p.setNome("HttpBasic Username");
                                p.setValore(username);
                                lst.add(p);
                            }
                        }
                        if (TipiConnettore.HTTPS.getNome().equals(connettore.getTipo())) {
                            String v;
                            p = new Property();
                            p.setId(Long.valueOf(idx++));
                            p.setNome("SSL Type");
                            p.setValore(ConfigurazioniUtils.getProperty("sslType", connettore.getPropertyList()));
                            lst.add(p);
                            p = new Property();
                            p.setId(Long.valueOf(idx++));
                            p.setNome("Hostname Verifier");
                            p.setValore(ConfigurazioniUtils.getProperty("hostnameVerifier", connettore.getPropertyList()));
                            lst.add(p);
                            p = new Property();
                            p.setId(Long.valueOf(idx++));
                            boolean trustAllCerts = false;
                            if (connettore.getProperties().containsKey("trustAllCerts") && "true".equalsIgnoreCase(v = ConfigurazioniUtils.getProperty("trustAllCerts", connettore.getPropertyList()))) {
                                trustAllCerts = true;
                            }
                            if (trustAllCerts) {
                                p.setNome("TrustStore");
                                p.setValore("Trust all certificates");
                            } else {
                                p.setNome("TrustStore (" + ConfigurazioniUtils.getProperty("trustStoreType", connettore.getPropertyList()) + ")");
                                p.setValore(ConfigurazioniUtils.getProperty("trustStoreLocation", connettore.getPropertyList()));
                            }
                            lst.add(p);
                            boolean invioCertificatoClient = false;
                            String cert = ConfigurazioniUtils.getProperty("keyStoreLocation", connettore.getPropertyList());
                            if (cert != null) {
                                invioCertificatoClient = true;
                            }
                            p = new Property();
                            p.setId(Long.valueOf(idx++));
                            p.setNome("Client Certificate");
                            p.setValore("" + invioCertificatoClient);
                            lst.add(p);
                            if (invioCertificatoClient) {
                                p = new Property();
                                p.setId(Long.valueOf(idx++));
                                p.setNome("KeyStore (" + ConfigurazioniUtils.getProperty("keyStoreType", connettore.getPropertyList()) + ")");
                                p.setValore(ConfigurazioniUtils.getProperty("keyStoreLocation", connettore.getPropertyList()));
                                lst.add(p);
                            }
                        }
                        if ((proxy = ConfigurazioniUtils.getProperty("proxyType", connettore.getPropertyList())) == null) break block24;
                        p = new Property();
                        p.setNome("Proxy");
                        p.setId(Long.valueOf(idx++));
                        p.setValore(ConfigurazioniUtils.getProperty("proxyHostname", connettore.getPropertyList()) + ":" + ConfigurazioniUtils.getProperty("proxyPort", connettore.getPropertyList()));
                        lst.add(p);
                        String username = ConfigurazioniUtils.getProperty("proxyUsername", connettore.getPropertyList());
                        if (username == null) break block24;
                        p = new Property();
                        p.setId(Long.valueOf(idx++));
                        p.setNome("Proxy Username");
                        p.setValore(username);
                        lst.add(p);
                        break block24;
                    }
                    if (!TipiConnettore.JMS.getNome().equals(connettore.getTipo())) break block25;
                    String tipoCoda = ConfigurazioniUtils.getProperty("tipo", connettore.getPropertyList());
                    p = new Property();
                    p.setId(Long.valueOf(idx++));
                    p.setNome("Nome (" + tipoCoda + ")");
                    p.setValore(ConfigurazioniUtils.getProperty("location", connettore.getPropertyList()));
                    lst.add(p);
                    p = new Property();
                    p.setId(Long.valueOf(idx++));
                    p.setNome("Connection Factory");
                    p.setValore(ConfigurazioniUtils.getProperty("connection-factory", connettore.getPropertyList()));
                    lst.add(p);
                    p = new Property();
                    p.setId(Long.valueOf(idx++));
                    p.setNome("SendAs");
                    p.setValore(ConfigurazioniUtils.getProperty("send-as", connettore.getPropertyList()));
                    lst.add(p);
                    if (invCredenziali == null) break block26;
                    p = new Property();
                    p.setId(Long.valueOf(idx++));
                    p.setNome("Username");
                    p.setValore(invCredenziali.getUser());
                    lst.add(p);
                    break block24;
                }
                String username = ConfigurazioniUtils.getProperty("user", connettore.getPropertyList());
                if (username == null) break block24;
                p = new Property();
                p.setId(Long.valueOf(idx++));
                p.setNome("Username");
                p.setValore(username);
                lst.add(p);
                break block24;
            }
            if (TipiConnettore.FILE.getNome().equals(connettore.getTipo())) {
                p = new Property();
                p.setId(Long.valueOf(idx++));
                p.setNome("OutputFile");
                p.setValore(ConfigurazioniUtils.getProperty("outputFile", connettore.getPropertyList()));
                lst.add(p);
                p = new Property();
                p.setId(Long.valueOf(idx++));
                p.setNome("OutputFile (Header)");
                p.setValore(ConfigurazioniUtils.getProperty("outputFileHeaders", connettore.getPropertyList()));
                lst.add(p);
                String risposta = ConfigurazioniUtils.getProperty("response", connettore.getPropertyList());
                if (risposta != null) {
                    p = new Property();
                    p.setId(Long.valueOf(idx++));
                    p.setNome("InputFile");
                    p.setValore(ConfigurazioniUtils.getProperty("inputFile", connettore.getPropertyList()));
                    lst.add(p);
                    p = new Property();
                    p.setId(Long.valueOf(idx++));
                    p.setNome("InputFile (Header)");
                    p.setValore(ConfigurazioniUtils.getProperty("inputFileHeaders", connettore.getPropertyList()));
                    lst.add(p);
                }
            } else if (TipiConnettore.NULL.getNome().equals(connettore.getTipo())) {
                p = new Property();
                p.setId(Long.valueOf(idx++));
                p.setNome("URL");
                p.setValore("govway://dev/null");
                lst.add(p);
            } else if (TipiConnettore.NULLECHO.getNome().equals(connettore.getTipo())) {
                p = new Property();
                p.setId(Long.valueOf(idx++));
                p.setNome("URL");
                p.setValore("govway://echo");
                lst.add(p);
            } else if (TipiConnettore.STATUS.getNome().equals(connettore.getTipo())) {
                p = new Property();
                p.setId(Long.valueOf(idx++));
                p.setNome("Tipo Risposta");
                p.setValore(ConfigurazioniUtils.getProperty("statusResponseType", connettore.getPropertyList()));
                lst.add(p);
                p = new Property();
                p.setId(Long.valueOf(idx++));
                p.setNome("Verifica Connettivit\u00e0");
                p.setValore(ConfigurazioniUtils.getProperty("testConnectivity", connettore.getPropertyList()));
                lst.add(p);
                if (ConfigurazioniUtils.getProperty("period", connettore.getPropertyList()) != null) {
                    p = new Property();
                    p.setId(Long.valueOf(idx++));
                    p.setNome("Verifica Statistica");
                    p.setValore(ConfigurazioniUtils.getProperty("period", connettore.getPropertyList()));
                    lst.add(p);
                    p = new Property();
                    p.setId(Long.valueOf(idx++));
                    p.setNome("Intervallo Osservazione");
                    p.setValore(ConfigurazioniUtils.getProperty("periodValue", connettore.getPropertyList()));
                    lst.add(p);
                }
                if (ConfigurazioniUtils.getProperty("statLifetime", connettore.getPropertyList()) != null) {
                    p = new Property();
                    p.setId(Long.valueOf(idx++));
                    p.setNome("Cache Life Time");
                    p.setValore(ConfigurazioniUtils.getProperty("statLifetime", connettore.getPropertyList()));
                    lst.add(p);
                }
            } else {
                List list = connettore.getPropertyList();
                if (list != null && !list.isEmpty()) {
                    for (Property property : list) {
                        p = new Property();
                        p.setId(Long.valueOf(idx++));
                        p.setNome(property.getNome());
                        p.setValore(property.getValore());
                        lst.add(p);
                    }
                }
            }
        }
        String debug = "false";
        if (ConfigurazioniUtils.getProperty("debug", connettore.getPropertyList()) != null) {
            debug = ConfigurazioniUtils.getProperty("debug", connettore.getPropertyList());
        }
        p = new Property();
        p.setId(Long.valueOf(idx));
        p.setNome("Debug");
        p.setValore(debug);
        lst.add(p);
        return lst;
    }

    public static String getProperty(String nome, List<Property> list) {
        if (list != null && !list.isEmpty()) {
            for (Property property : list) {
                if (!property.getNome().equals(nome)) continue;
                return property.getValore();
            }
        }
        return null;
    }

    public static List<Property> getPropertiesAutenticazionePD(DettaglioPD dettaglioPD) {
        PortaDelegata pdOp2 = dettaglioPD.getPortaDelegataOp2();
        ArrayList<Property> lst = new ArrayList<Property>();
        long idx = 0L;
        Property p = null;
        if ("none".equals(pdOp2.getAutenticazione())) {
            p = new Property();
            p.setId(Long.valueOf(idx++));
            p.setNome("Stato");
            p.setValore(CostantiConfigurazione.DISABILITATO.getValue());
            lst.add(p);
        } else {
            p = new Property();
            p.setId(Long.valueOf(idx++));
            p.setNome("Stato");
            p.setValore(pdOp2.getAutenticazione());
            lst.add(p);
        }
        if (CostantiConfigurazione.ABILITATO.equals((Object)pdOp2.getAutenticazioneOpzionale())) {
            p = new Property();
            p.setId(Long.valueOf(idx));
            p.setNome("Opzionale");
            p.setValore(CostantiConfigurazione.ABILITATO.getValue());
            lst.add(p);
        } else {
            p = new Property();
            p.setId(Long.valueOf(idx));
            p.setNome("Opzionale");
            p.setValore(CostantiConfigurazione.DISABILITATO.getValue());
            lst.add(p);
        }
        return lst;
    }

    public static List<Property> getPropertiesAutorizzazionePD(DettaglioPD dettaglioPD, IDPortaDelegata idPD, DriverConfigurazioneDB driverConfigDB, DriverRegistroServiziDB driverRegistroDB) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (driverConfigDB != null) {
            // empty if block
        }
        PortaDelegata pdOp2 = dettaglioPD.getPortaDelegataOp2();
        ArrayList<Property> lst = new ArrayList<Property>();
        long idx = 0L;
        Property p = null;
        String autorizzazione = pdOp2.getAutorizzazione();
        if ("none".equals(autorizzazione)) {
            p = new Property();
            p.setId(Long.valueOf(idx++));
            p.setNome("Stato");
            p.setValore(CostantiConfigurazione.DISABILITATO.getValue());
            lst.add(p);
        } else if (autorizzazione.toLowerCase().contains(TipoAutorizzazione.XACML_POLICY.getValue().toLowerCase())) {
            p = new Property();
            p.setId(Long.valueOf(idx++));
            p.setNome("Stato");
            p.setValore(TipoAutorizzazione.XACML_POLICY.getValue());
            lst.add(p);
        } else if (autorizzazione.toLowerCase().contains(TipoAutorizzazione.ROLES.getValue().toLowerCase()) || autorizzazione.toLowerCase().contains(TipoAutorizzazione.AUTHENTICATED.getValue().toLowerCase())) {
            Object valore = "";
            valore = autorizzazione.toLowerCase().contains(TipoAutorizzazione.ROLES.getValue().toLowerCase()) && autorizzazione.toLowerCase().contains(TipoAutorizzazione.AUTHENTICATED.getValue().toLowerCase()) ? CostantiConfigurazione.ABILITATO.getValue() + " (Ruoli o Applicativi Autorizzati)" : (autorizzazione.toLowerCase().contains(TipoAutorizzazione.ROLES.getValue().toLowerCase()) ? CostantiConfigurazione.ABILITATO.getValue() + " (Ruoli)" : CostantiConfigurazione.ABILITATO.getValue() + " (Applicativi Autorizzati)");
            p = new Property();
            p.setId(Long.valueOf(idx++));
            p.setNome("Stato");
            p.setValore((String)valore);
            lst.add(p);
        } else {
            p = new Property();
            p.setId(Long.valueOf(idx++));
            p.setNome("Stato");
            p.setValore(autorizzazione);
            lst.add(p);
        }
        if (autorizzazione.toLowerCase().contains(TipoAutorizzazione.AUTHENTICATED.getValue().toLowerCase())) {
            ArrayList<String> sa = new ArrayList<String>();
            boolean first = true;
            for (PortaDelegataServizioApplicativo pdSA : pdOp2.getServizioApplicativoList()) {
                p = new Property();
                p.setId(Long.valueOf(idx++));
                if (first) {
                    p.setNome("Applicativi Autorizzati");
                } else {
                    p.setNome("");
                }
                first = false;
                String saNome = pdSA.getNome();
                IDServizioApplicativo idServizioApplicativo = new IDServizioApplicativo();
                idServizioApplicativo.setIdSoggettoProprietario(idPD.getIdentificativiFruizione().getSoggettoFruitore());
                idServizioApplicativo.setNome(saNome);
                sa.add(saNome);
                p.setValore(saNome);
                lst.add(p);
            }
            if (sa.isEmpty()) {
                p = new Property();
                p.setId(Long.valueOf(idx++));
                p.setNome("Applicativi Autorizzati");
                p.setValore("-");
                lst.add(p);
            }
            dettaglioPD.setSa(sa);
        }
        if (autorizzazione.toLowerCase().contains(TipoAutorizzazione.ROLES.getValue().toLowerCase())) {
            ArrayList<String> ruoli = new ArrayList<String>();
            String match = "-";
            if (pdOp2.getRuoli() != null) {
                boolean first = true;
                if (pdOp2.getRuoli().getMatch() != null) {
                    switch (pdOp2.getRuoli().getMatch()) {
                        case ALL: {
                            match = "tutti";
                            break;
                        }
                        case ANY: {
                            match = "almeno uno";
                        }
                    }
                }
                for (org.openspcoop2.core.config.Ruolo pdRuolo : pdOp2.getRuoli().getRuoloList()) {
                    p = new Property();
                    p.setId(Long.valueOf(idx++));
                    if (first) {
                        p.setNome("Ruoli (" + match + ")");
                    } else {
                        p.setNome("");
                    }
                    first = false;
                    String ruoloName = pdRuolo.getNome();
                    IDRuolo idRuolo = new IDRuolo(ruoloName);
                    Ruolo ruoloReg = driverRegistroDB.getRuolo(idRuolo);
                    String fonte = null;
                    switch (ruoloReg.getTipologia()) {
                        case INTERNO: {
                            fonte = "fonte: interna";
                            break;
                        }
                        case ESTERNO: {
                            fonte = "fonte: esterna";
                            break;
                        }
                        case QUALSIASI: {
                            fonte = "fonte: qualisiasi";
                        }
                    }
                    ruoli.add(ruoloName + " (" + fonte + ")");
                    p.setValore(ruoloName + " (" + fonte + ")");
                    lst.add(p);
                }
            }
            dettaglioPD.setRuoli(ruoli);
            dettaglioPD.setMatchRuoli(match);
            if (ruoli.isEmpty()) {
                p = new Property();
                p.setId(Long.valueOf(idx));
                if (StringUtils.isEmpty((CharSequence)match)) {
                    p.setNome("Ruoli");
                } else {
                    p.setNome("Ruoli (" + match + ")");
                }
                p.setValore("-");
                lst.add(p);
            }
        }
        return lst;
    }

    public static List<Property> getPropertiesIntegrazionePD(DettaglioPD dettaglioPD) {
        ArrayList<Property> lst = new ArrayList<Property>();
        long idx = 0L;
        Property p = null;
        PortaDelegataAzione pdAzione = dettaglioPD.getPortaDelegataOp2().getAzione();
        if (dettaglioPD.getPortaDelegata().getNomeAzione() != null && pdAzione != null && CostantiConfigurazione.PORTA_DELEGATA_AZIONE_STATIC.equals((Object)pdAzione.getIdentificazione())) {
            p = new Property();
            p.setId(Long.valueOf(idx++));
            p.setNome("Azione");
            p.setValore(dettaglioPD.getPortaDelegata().getNomeAzione());
            lst.add(p);
            p = new Property();
            p.setId(Long.valueOf(idx));
            p.setNome("URL di Invocazione");
            p.setValore(dettaglioPD.getUrlInvocazione());
            lst.add(p);
        } else {
            List<String> azioni = dettaglioPD.getAzioni();
            if (pdAzione == null && (azioni == null || azioni.isEmpty())) {
                p = new Property();
                p.setId(Long.valueOf(idx));
                p.setNome("Utilizzo del Servizio senza azione");
                p.setValore("");
                lst.add(p);
            } else {
                if (azioni != null && !azioni.isEmpty()) {
                    boolean first = true;
                    for (String azione : azioni) {
                        p = new Property();
                        p.setId(Long.valueOf(idx++));
                        if (first) {
                            p.setNome("Azioni");
                        } else {
                            p.setNome("");
                        }
                        first = false;
                        p.setValore(azione);
                        lst.add(p);
                    }
                }
                p = new Property();
                p.setId(Long.valueOf(idx++));
                p.setNome("URL di Invocazione");
                p.setValore(dettaglioPD.getUrlInvocazione());
                lst.add(p);
                Object suffix = "";
                if (pdAzione != null && CostantiConfigurazione.ABILITATO.equals((Object)pdAzione.getForceInterfaceBased())) {
                    suffix = "/" + CostantiConfigurazione.PORTA_DELEGATA_AZIONE_WSDL_BASED.getValue();
                }
                if (pdAzione != null) {
                    p = new Property();
                    p.setId(Long.valueOf(idx++));
                    p.setNome("Modalit\u00e0 Identificazione Azione");
                    p.setValore(pdAzione.getIdentificazione().getValue() + (String)suffix);
                    lst.add(p);
                }
                if (pdAzione != null && CostantiConfigurazione.PORTA_DELEGATA_AZIONE_CONTENT_BASED.equals((Object)pdAzione.getIdentificazione())) {
                    p = new Property();
                    p.setId(Long.valueOf(idx));
                    p.setNome("Expressione XPath");
                    p.setValore(pdAzione.getPattern());
                    lst.add(p);
                } else if (pdAzione != null && CostantiConfigurazione.PORTA_DELEGATA_AZIONE_URL_BASED.equals((Object)pdAzione.getIdentificazione())) {
                    String exprDefaultOld1 = ".*" + dettaglioPD.getPortaDelegata().getNome() + "/([^/|^?]*).*";
                    String exprDefaultOld2 = ".*/" + dettaglioPD.getPortaDelegata().getNome() + "/([^/|^?]*).*";
                    String exprDefaultNew = "/" + dettaglioPD.getPortaDelegata().getNome() + "/([^/?]*).*";
                    if (!(exprDefaultOld1.equals(pdAzione.getPattern()) || exprDefaultOld2.equals(pdAzione.getPattern()) || exprDefaultNew.equals(pdAzione.getPattern()))) {
                        p = new Property();
                        p.setId(Long.valueOf(idx));
                        p.setNome("Expressione Regolare");
                        p.setValore(pdAzione.getPattern());
                        lst.add(p);
                    }
                }
            }
        }
        return lst;
    }

    public static List<Property> getPropertiesIntegrazionePA(DettaglioPA dettaglioPA) {
        ArrayList<Property> lst = new ArrayList<Property>();
        long idx = 0L;
        Property p = null;
        if (dettaglioPA.getPortaApplicativa().getNomeAzione() != null) {
            p = new Property();
            p.setId(Long.valueOf(idx++));
            p.setNome("Azione");
            p.setValore(dettaglioPA.getPortaApplicativa().getNomeAzione());
            lst.add(p);
            p = new Property();
            p.setId(Long.valueOf(idx));
            p.setNome("URL di Invocazione");
            p.setValore(dettaglioPA.getUrlInvocazione());
            lst.add(p);
        } else {
            List<String> azioni = dettaglioPA.getAzioni();
            if (azioni != null && !azioni.isEmpty()) {
                boolean first = true;
                for (String azione : azioni) {
                    p = new Property();
                    p.setId(Long.valueOf(idx++));
                    if (first) {
                        p.setNome("Azioni");
                    } else {
                        p.setNome("");
                    }
                    first = false;
                    p.setValore(azione);
                    lst.add(p);
                }
            }
            p = new Property();
            p.setId(Long.valueOf(idx++));
            p.setNome("URL di Invocazione");
            p.setValore(dettaglioPA.getUrlInvocazione());
            lst.add(p);
            String value = CostantiConfigurazione.PORTA_DELEGATA_AZIONE_URL_BASED.getValue() + "/" + CostantiConfigurazione.PORTA_DELEGATA_AZIONE_WSDL_BASED.getValue();
            p = new Property();
            p.setId(Long.valueOf(idx));
            p.setNome("Modalit\u00e0 Identificazione Azione");
            p.setValore(value);
            lst.add(p);
        }
        return lst;
    }

    public static List<Property> getPropertiesGeneraliPA(DettaglioPA dettaglioPA) throws DriverRegistroServiziException {
        ArrayList<Property> lst = new ArrayList<Property>();
        long idx = 0L;
        Property p = null;
        PortaApplicativa portaApplicativa = dettaglioPA.getPortaApplicativa();
        org.openspcoop2.core.config.PortaApplicativa paOp2 = dettaglioPA.getPortaApplicativaOp2();
        p = new Property();
        p.setId(Long.valueOf(idx++));
        p.setNome("Porta Applicativa");
        p.setValore(portaApplicativa.getNome());
        lst.add(p);
        p = new Property();
        p.setId(Long.valueOf(idx++));
        p.setNome("Stato");
        p.setValore(portaApplicativa.getStato());
        lst.add(p);
        IdAccordoServizioParteComune aspc = dettaglioPA.getIdAccordoServizioParteComune();
        p = new Property();
        p.setId(Long.valueOf(idx++));
        p.setNome("Tipo API");
        p.setValore(aspc.getServiceBinding());
        lst.add(p);
        p = new Property();
        p.setId(Long.valueOf(idx++));
        p.setNome("API");
        String nomeAspc = aspc.getNome();
        Integer versioneAspc = aspc.getVersione();
        String nomeReferenteAspc = aspc.getIdSoggetto() != null ? aspc.getIdSoggetto().getNome() : null;
        String tipoReferenteAspc = aspc.getIdSoggetto() != null ? aspc.getIdSoggetto().getTipo() : null;
        p.setValore(IDAccordoFactory.getInstance().getUriFromValues(nomeAspc, tipoReferenteAspc, nomeReferenteAspc, versioneAspc));
        lst.add(p);
        p = new Property();
        p.setId(Long.valueOf(idx++));
        p.setNome("PortType");
        p.setValore(dettaglioPA.getPortType());
        lst.add(p);
        p = new Property();
        p.setId(Long.valueOf(idx++));
        p.setNome("Erogatore");
        p.setValore(portaApplicativa.getIdSoggetto().getTipo() + "/" + portaApplicativa.getIdSoggetto().getNome());
        lst.add(p);
        p = new Property();
        p.setId(Long.valueOf(idx++));
        p.setNome("Implementazione API");
        p.setValore(portaApplicativa.getTipoServizio() + "/" + portaApplicativa.getNomeServizio());
        lst.add(p);
        if (!dettaglioPA.isTrasparente()) {
            if (portaApplicativa.getNomeAzione() != null) {
                p = new Property();
                p.setId(Long.valueOf(idx));
                p.setNome("Azione");
                p.setValore(portaApplicativa.getNomeAzione());
                lst.add(p);
            } else {
                PortaApplicativaAzione paAzione = paOp2.getAzione();
                List<String> azioni = dettaglioPA.getAzioni();
                if (paAzione == null && (azioni == null || azioni.isEmpty())) {
                    p = new Property();
                    p.setId(Long.valueOf(idx));
                    p.setNome("Azione");
                    p.setValore("Utilizzo del Servizio senza azione");
                    lst.add(p);
                } else if (azioni != null && !azioni.isEmpty()) {
                    boolean first = true;
                    for (String azione : azioni) {
                        p = new Property();
                        p.setId(Long.valueOf(idx++));
                        if (first) {
                            p.setNome("Azioni");
                        } else {
                            p.setNome("");
                        }
                        first = false;
                        p.setValore(azione);
                        lst.add(p);
                    }
                }
            }
        }
        return lst;
    }

    public static List<Property> getPropertiesGeneraliPD(DettaglioPD dettaglioPD) throws DriverRegistroServiziException {
        ArrayList<Property> lst = new ArrayList<Property>();
        long idx = 0L;
        Property p = null;
        org.openspcoop2.core.commons.search.PortaDelegata portaDelegata = dettaglioPD.getPortaDelegata();
        p = new Property();
        p.setId(Long.valueOf(idx++));
        p.setNome("Porta Delegata");
        p.setValore(portaDelegata.getNome());
        lst.add(p);
        p = new Property();
        p.setId(Long.valueOf(idx++));
        p.setNome("Stato");
        p.setValore(portaDelegata.getStato());
        lst.add(p);
        IdAccordoServizioParteComune aspc = dettaglioPD.getIdAccordoServizioParteComune();
        p = new Property();
        p.setId(Long.valueOf(idx++));
        p.setNome("Tipo API");
        p.setValore(aspc.getServiceBinding());
        lst.add(p);
        p = new Property();
        p.setId(Long.valueOf(idx++));
        p.setNome("API");
        String nomeAspc = aspc.getNome();
        Integer versioneAspc = aspc.getVersione();
        String nomeReferenteAspc = aspc.getIdSoggetto() != null ? aspc.getIdSoggetto().getNome() : null;
        String tipoReferenteAspc = aspc.getIdSoggetto() != null ? aspc.getIdSoggetto().getTipo() : null;
        p.setValore(IDAccordoFactory.getInstance().getUriFromValues(nomeAspc, tipoReferenteAspc, nomeReferenteAspc, versioneAspc));
        lst.add(p);
        p = new Property();
        p.setId(Long.valueOf(idx++));
        p.setNome("PortType");
        p.setValore(dettaglioPD.getPortType());
        lst.add(p);
        p = new Property();
        p.setId(Long.valueOf(idx++));
        p.setNome("Fruitore");
        p.setValore(portaDelegata.getIdSoggetto().getTipo() + "/" + portaDelegata.getIdSoggetto().getNome());
        lst.add(p);
        p = new Property();
        p.setId(Long.valueOf(idx++));
        p.setNome("Erogatore");
        p.setValore(portaDelegata.getIdSoggetto().getTipo() + "/" + portaDelegata.getIdSoggetto().getNome());
        lst.add(p);
        p = new Property();
        p.setId(Long.valueOf(idx));
        p.setNome("Implementazione API");
        p.setValore(portaDelegata.getTipoServizio() + "/" + portaDelegata.getNomeServizio());
        lst.add(p);
        return lst;
    }

    public static List<Property> getPropertiesAutenticazionePA(DettaglioPA dettaglioPA) {
        org.openspcoop2.core.config.PortaApplicativa paOp2 = dettaglioPA.getPortaApplicativaOp2();
        ArrayList<Property> lst = new ArrayList<Property>();
        long idx = 0L;
        Property p = null;
        if (dettaglioPA.isSupportatoAutenticazione()) {
            if ("none".equals(paOp2.getAutenticazione())) {
                p = new Property();
                p.setId(Long.valueOf(idx++));
                p.setNome("Stato");
                p.setValore(CostantiConfigurazione.DISABILITATO.getValue());
                lst.add(p);
            } else {
                p = new Property();
                p.setId(Long.valueOf(idx++));
                p.setNome("Stato");
                p.setValore(paOp2.getAutenticazione());
                lst.add(p);
            }
            if (CostantiConfigurazione.ABILITATO.equals((Object)paOp2.getAutenticazioneOpzionale())) {
                p = new Property();
                p.setId(Long.valueOf(idx));
                p.setNome("Opzionale");
                p.setValore(CostantiConfigurazione.ABILITATO.getValue());
                lst.add(p);
            } else {
                p = new Property();
                p.setId(Long.valueOf(idx));
                p.setNome("Opzionale");
                p.setValore(CostantiConfigurazione.DISABILITATO.getValue());
                lst.add(p);
            }
        }
        return lst;
    }

    public static List<Property> getPropertiesAutorizzazionePA(DettaglioPA dettaglioPA, IServiceManager utilsServiceManager, DriverRegistroServiziDB driverRegistroDB) throws ServiceException, NotImplementedException, ExpressionNotImplementedException, ExpressionException, DriverRegistroServiziException, DriverRegistroServiziNotFound {
        PortaApplicativa portaApplicativa = dettaglioPA.getPortaApplicativa();
        org.openspcoop2.core.config.PortaApplicativa paOp2 = dettaglioPA.getPortaApplicativaOp2();
        ArrayList<Property> lst = new ArrayList<Property>();
        long idx = 0L;
        Property p = null;
        String autorizzazione = paOp2.getAutorizzazione();
        if ("none".equals(autorizzazione)) {
            p = new Property();
            p.setId(Long.valueOf(idx++));
            p.setNome("Stato");
            p.setValore(CostantiConfigurazione.DISABILITATO.getValue());
            lst.add(p);
        } else if (autorizzazione.toLowerCase().contains(TipoAutorizzazione.XACML_POLICY.getValue().toLowerCase())) {
            p = new Property();
            p.setId(Long.valueOf(idx++));
            p.setNome("Stato");
            p.setValore(TipoAutorizzazione.XACML_POLICY.getValue());
            lst.add(p);
        } else if (autorizzazione.toLowerCase().contains(TipoAutorizzazione.ROLES.getValue().toLowerCase()) || autorizzazione.toLowerCase().contains(TipoAutorizzazione.AUTHENTICATED.getValue().toLowerCase())) {
            Object valore = "";
            valore = autorizzazione.toLowerCase().contains(TipoAutorizzazione.ROLES.getValue().toLowerCase()) && autorizzazione.toLowerCase().contains(TipoAutorizzazione.AUTHENTICATED.getValue().toLowerCase()) ? CostantiConfigurazione.ABILITATO.getValue() + " (Ruoli o Soggetti Autorizzati)" : (autorizzazione.toLowerCase().contains(TipoAutorizzazione.ROLES.getValue().toLowerCase()) ? CostantiConfigurazione.ABILITATO.getValue() + " (Ruoli)" : CostantiConfigurazione.ABILITATO.getValue() + " (Soggetti Autorizzati)");
            p = new Property();
            p.setId(Long.valueOf(idx++));
            p.setNome("Stato");
            p.setValore((String)valore);
            lst.add(p);
        } else {
            p = new Property();
            p.setId(Long.valueOf(idx++));
            p.setNome("Stato");
            p.setValore(autorizzazione);
            lst.add(p);
        }
        if (autorizzazione.toLowerCase().contains(TipoAutorizzazione.AUTHENTICATED.getValue().toLowerCase())) {
            ArrayList<String> fruitori = new ArrayList<String>();
            ConfigurazioniUtils.fillFruitori(portaApplicativa.getIdSoggetto().getTipo(), portaApplicativa.getIdSoggetto().getNome(), portaApplicativa.getTipoServizio(), portaApplicativa.getNomeServizio(), fruitori, utilsServiceManager);
            dettaglioPA.setFruitori(fruitori);
            if (fruitori != null && !fruitori.isEmpty()) {
                boolean first = true;
                for (String fruitore : fruitori) {
                    p = new Property();
                    p.setId(Long.valueOf(idx++));
                    if (first) {
                        p.setNome("Soggetti Autorizzati");
                    } else {
                        p.setNome("");
                    }
                    first = false;
                    p.setValore(fruitore);
                    lst.add(p);
                }
            } else {
                p = new Property();
                p.setId(Long.valueOf(idx++));
                p.setNome("Soggetti Autorizzati");
                p.setValore("-");
                lst.add(p);
            }
        }
        if (autorizzazione.toLowerCase().contains(TipoAutorizzazione.ROLES.getValue().toLowerCase())) {
            ArrayList<String> ruoli = new ArrayList<String>();
            String match = "-";
            if (paOp2.getRuoli() != null) {
                if (paOp2.getRuoli().getMatch() != null) {
                    switch (paOp2.getRuoli().getMatch()) {
                        case ALL: {
                            match = "tutti";
                            break;
                        }
                        case ANY: {
                            match = "almeno uno";
                        }
                    }
                }
                boolean first = true;
                for (org.openspcoop2.core.config.Ruolo pdRuolo : paOp2.getRuoli().getRuoloList()) {
                    p = new Property();
                    p.setId(Long.valueOf(idx++));
                    if (first) {
                        p.setNome("Ruoli (" + match + ")");
                    } else {
                        p.setNome("");
                    }
                    first = false;
                    String ruoloName = pdRuolo.getNome();
                    IDRuolo idRuolo = new IDRuolo(ruoloName);
                    Ruolo ruoloReg = driverRegistroDB.getRuolo(idRuolo);
                    String fonte = null;
                    switch (ruoloReg.getTipologia()) {
                        case INTERNO: {
                            fonte = "fonte: interna";
                            break;
                        }
                        case ESTERNO: {
                            fonte = "fonte: esterna";
                            break;
                        }
                        case QUALSIASI: {
                            fonte = "fonte: qualisiasi";
                        }
                    }
                    ruoli.add(ruoloName + " (" + fonte + ")");
                    p.setValore(ruoloName + " (" + fonte + ")");
                    lst.add(p);
                }
            }
            dettaglioPA.setRuoli(ruoli);
            dettaglioPA.setMatchRuoli(match);
            if (ruoli.isEmpty()) {
                p = new Property();
                p.setId(Long.valueOf(idx));
                if (StringUtils.isEmpty((CharSequence)match)) {
                    p.setNome("Ruoli");
                } else {
                    p.setNome("Ruoli (" + match + ")");
                }
                p.setValore("-");
                lst.add(p);
            }
        }
        return lst;
    }

    public static List<DettaglioPA.DettaglioSA> getPropertiesServiziApplicativiPA(DettaglioPA dettaglioPA, DriverConfigurazioneDB driverConfigDB, IDPortaApplicativa idPA) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        org.openspcoop2.core.config.PortaApplicativa paOp2 = dettaglioPA.getPortaApplicativaOp2();
        ArrayList<DettaglioPA.DettaglioSA> listaSA = new ArrayList<DettaglioPA.DettaglioSA>();
        for (PortaApplicativaServizioApplicativo saOp : paOp2.getServizioApplicativoList()) {
            DettaglioPA.DettaglioSA sa = new DettaglioPA().new DettaglioPA.DettaglioSA();
            ArrayList<Property> lstPropertySA = new ArrayList<Property>();
            long idx = 0L;
            Property p = null;
            String saNome = saOp.getNome();
            p = new Property();
            p.setId(Long.valueOf(idx++));
            p.setNome("Applicativo");
            p.setValore(saOp.getNome());
            lstPropertySA.add(p);
            IDServizioApplicativo idServizioApplicativo = new IDServizioApplicativo();
            idServizioApplicativo.setIdSoggettoProprietario(idPA.getIdentificativiErogazione().getIdServizio().getSoggettoErogatore());
            idServizioApplicativo.setNome(saNome);
            ServizioApplicativo saOp2 = driverConfigDB.getServizioApplicativo(idServizioApplicativo);
            sa.setSaOp2(saOp2);
            if (saOp2.getInvocazioneServizio() != null) {
                p = new Property();
                p.setId(Long.valueOf(idx++));
                p.setNome("MessageBox");
                p.setValore(saOp2.getInvocazioneServizio().getGetMessage().getValue());
                lstPropertySA.add(p);
                p = new Property();
                p.setId(Long.valueOf(idx++));
                p.setNome("Sbustamento SOAP");
                p.setValore(saOp2.getInvocazioneServizio().getSbustamentoSoap().getValue());
                lstPropertySA.add(p);
                p = new Property();
                p.setId(Long.valueOf(idx));
                p.setNome("Sbustamento Protocollo");
                p.setValore(saOp2.getInvocazioneServizio().getSbustamentoInformazioniProtocollo().getValue());
                lstPropertySA.add(p);
                if (saOp2.getInvocazioneServizio().getConnettore() != null) {
                    Connettore connettore = saOp2.getInvocazioneServizio().getConnettore();
                    sa.setPropertyConnettore(ConfigurazioniUtils.printConnettore(connettore, "Tipo", saOp2.getInvocazioneServizio().getCredenziali()));
                }
            }
            sa.setPropertySA(lstPropertySA);
            listaSA.add(sa);
        }
        return listaSA;
    }
}

