/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.security.keystore;

import org.openspcoop2.security.keystore.StoreUtils;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.byok.BYOKRequestParams;
import org.openspcoop2.utils.transport.http.IBYOKUnwrapManager;

public class BYOKUnwrapManager
implements IBYOKUnwrapManager {
    private String kmsId;
    private BYOKRequestParams byokParams;

    public BYOKUnwrapManager(String kmsId, BYOKRequestParams byokParams) {
        this.kmsId = kmsId;
        this.byokParams = byokParams;
    }

    public byte[] unwrap(byte[] archive) throws UtilsException {
        try {
            return StoreUtils.unwrapBYOK(archive, this.byokParams);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), (Throwable)e);
        }
    }

    public String getPolicy() {
        return this.kmsId;
    }
}

