/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.security.keystore;

import java.io.Serializable;
import java.security.PublicKey;
import java.util.UUID;
import org.openspcoop2.security.SecurityException;
import org.openspcoop2.security.keystore.StoreUtils;
import org.openspcoop2.utils.certificate.JWKPublicKeyConverter;
import org.openspcoop2.utils.certificate.JWKSet;
import org.openspcoop2.utils.certificate.KeyUtils;

public class PublicKeyStore
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String publicKeyPath;
    private byte[] publicKeyContent;
    private transient PublicKey publicKey;
    private String algorithm;
    private String jwkSetContent;
    private String jwkSetKid;
    private transient JWKSet jwkSet;

    public String toString() {
        StringBuilder bf = new StringBuilder();
        bf.append("PublicKeyStore (public:").append(this.publicKeyPath).append(")");
        return bf.toString();
    }

    public PublicKeyStore(String publicKeyPath, String algorithm) throws SecurityException {
        this.publicKeyPath = publicKeyPath;
        this.algorithm = algorithm == null ? "RSA" : algorithm;
        this.publicKeyContent = StoreUtils.readContent("PublicKey", this.publicKeyPath);
    }

    public PublicKeyStore(byte[] publicKey, String algorithm) throws SecurityException {
        try {
            if (publicKey == null) {
                throw new SecurityException("Store publicKey non indicato");
            }
            this.publicKeyContent = publicKey;
            this.algorithm = algorithm == null ? "RSA" : algorithm;
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage(), e);
        }
    }

    public PublicKey getPublicKey() throws SecurityException {
        if (this.publicKey == null) {
            this.initializePublicKey();
        }
        return this.publicKey;
    }

    private synchronized void initializePublicKey() throws SecurityException {
        if (this.publicKey == null) {
            try {
                this.publicKey = KeyUtils.getInstance((String)this.algorithm).getPublicKey(this.publicKeyContent);
            }
            catch (Exception e) {
                throw new SecurityException("Load public key failed: " + e.getMessage(), e);
            }
        }
    }

    public JWKSet getJwkSet() throws SecurityException {
        if (this.jwkSet == null) {
            this.initializeJwkSet();
        }
        return this.jwkSet;
    }

    private synchronized void initializeJwkSet() throws SecurityException {
        if (this.jwkSet == null) {
            if (this.jwkSetContent == null) {
                this.jwkSetKid = UUID.randomUUID().toString();
                try {
                    this.jwkSetContent = JWKPublicKeyConverter.convert((PublicKey)this.getPublicKey(), (String)this.jwkSetKid, (boolean)true, (boolean)false);
                }
                catch (Exception e) {
                    throw new SecurityException(e.getMessage(), e);
                }
            }
            this.jwkSet = new JWKSet(this.jwkSetContent);
        }
    }

    public String getJwkSetKid() {
        return this.jwkSetKid;
    }
}

