/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.security.keystore.cache;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.openspcoop2.security.SecurityException;
import org.openspcoop2.security.keystore.cache.KeystoreCacheEntry;
import org.openspcoop2.utils.Semaphore;
import org.openspcoop2.utils.SemaphoreLock;
import org.openspcoop2.utils.cache.Cache;
import org.openspcoop2.utils.date.DateManager;

public abstract class AbstractKeystoreCache<T extends Serializable> {
    private int cacheLifeSecond = -1;
    private int cacheSize = -1;
    private Map<String, KeystoreCacheEntry<T>> cacheMap = new ConcurrentHashMap<String, KeystoreCacheEntry<T>>();
    private Cache cacheJCS = null;
    private final Semaphore lockCache = new Semaphore(this.getClass().getSimpleName());

    public void setKeystoreCacheParameters(int cacheLifeSecond, int cacheSize) {
        this.cacheLifeSecond = cacheLifeSecond;
        this.cacheSize = cacheSize;
    }

    public void setCacheJCS(int cacheLifeSecond, Cache cacheJCS) {
        this.cacheLifeSecond = cacheLifeSecond;
        this.cacheJCS = cacheJCS;
    }

    public void updateCacheLifeSecond(int cacheLifeSecond) {
        this.cacheLifeSecond = cacheLifeSecond;
    }

    public T getKeystore(String keyParam) throws SecurityException {
        KeystoreCacheEntry<T> o = this.getObjectFromCache(keyParam);
        if (o == null) {
            throw new SecurityException("Keystore with key [" + keyParam + "] not found");
        }
        return this.estraiKeystore(o);
    }

    public T getKeystoreAndCreateIfNotExists(String keyParam, Object ... params) throws SecurityException {
        KeystoreCacheEntry<T> o = this.getObjectFromCache(keyParam);
        if (o == null) {
            return this.initKeystore(keyParam, params);
        }
        return this.estraiKeystore(o);
    }

    public T getKeystore(byte[] keystore) throws SecurityException {
        String keyParam = AbstractKeystoreCache.buildKeyCacheFromBytes(keystore);
        return this.getKeystore(keyParam);
    }

    public T getKeystoreAndCreateIfNotExists(byte[] keystore, Object ... params) throws SecurityException {
        String keyParam = AbstractKeystoreCache.buildKeyCacheFromBytes(keystore);
        ArrayList<Object> lArgs = new ArrayList<Object>();
        lArgs.add(keystore);
        if (params != null && params.length > 0) {
            lArgs.addAll(Arrays.asList(params));
        }
        return this.getKeystoreAndCreateIfNotExists(keyParam, lArgs.toArray());
    }

    public abstract T createKeystore(String var1, Object ... var2) throws SecurityException;

    public abstract String getPrefixKey();

    public static String buildKeyCacheFromBytes(byte[] keystore) throws SecurityException {
        if (keystore == null) {
            throw new SecurityException("Keystore undefined");
        }
        return DigestUtils.sha256Hex((byte[])keystore);
    }

    private KeystoreCacheEntry<T> getObjectFromCache(String keyParam) {
        String keyCache = this.getPrefixKey() + keyParam;
        KeystoreCacheEntry o = null;
        if (this.cacheJCS != null) {
            Object object = this.cacheJCS.get(keyCache);
            if (object != null) {
                o = (KeystoreCacheEntry)object;
            }
        } else {
            o = this.cacheMap.get(keyCache);
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T initKeystore(String keyParam, Object ... params) throws SecurityException {
        SemaphoreLock lock = this.lockCache.acquireThrowRuntime("initKeystore");
        try {
            String keyCache = this.getPrefixKey() + keyParam;
            KeystoreCacheEntry<T> o = this.getObjectFromCache(keyCache);
            if (o == null) {
                T keystore = this.createKeystore(keyParam, params);
                KeystoreCacheEntry<T> cacheEntry = new KeystoreCacheEntry<T>();
                cacheEntry.setKey(keyCache);
                cacheEntry.setKeystore(keystore);
                cacheEntry.setDate(DateManager.getDate());
                if (this.cacheJCS != null) {
                    try {
                        this.cacheJCS.put(keyCache, cacheEntry);
                    }
                    catch (Exception e) {
                        throw new SecurityException(e.getMessage(), e);
                    }
                } else {
                    this.cacheMap.put(keyCache, cacheEntry);
                }
                T t = keystore;
                return t;
            }
            T t = this.estraiKeystore(o);
            return t;
        }
        finally {
            this.lockCache.release(lock, "initKeystore");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeKeystore(String key) throws SecurityException {
        block6: {
            SemaphoreLock lock = this.lockCache.acquireThrowRuntime("removeKeystore");
            try {
                if (this.cacheJCS != null) {
                    try {
                        this.cacheJCS.remove(key);
                        break block6;
                    }
                    catch (Exception e) {
                        throw new SecurityException(e.getMessage(), e);
                    }
                }
                this.cacheMap.remove(key);
            }
            finally {
                this.lockCache.release(lock, "removeKeystore");
            }
        }
    }

    public void removeObjectFromCache(String keyParam) throws SecurityException {
        String keyCache = this.getPrefixKey() + keyParam;
        this.removeKeystore(keyCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> keys() throws SecurityException {
        ArrayList<String> keys;
        block8: {
            keys = new ArrayList<String>();
            SemaphoreLock lock = this.lockCache.acquireThrowRuntime("keys");
            try {
                if (this.cacheJCS != null) {
                    try {
                        List l = this.cacheJCS.keys();
                        if (l != null && !l.isEmpty()) {
                            keys.addAll(l);
                        }
                        break block8;
                    }
                    catch (Exception e) {
                        throw new SecurityException(e.getMessage(), e);
                    }
                }
                if (!this.cacheMap.isEmpty()) {
                    keys.addAll(this.cacheMap.keySet());
                }
            }
            finally {
                this.lockCache.release(lock, "keys");
            }
        }
        return keys;
    }

    private T estraiKeystore(KeystoreCacheEntry<T> entry) throws SecurityException {
        long now;
        long scadenza;
        T keystore = entry.getKeystore();
        if (this.cacheLifeSecond > -1 && (scadenza = entry.getDate().getTime() + (long)this.cacheLifeSecond * 1000L) < (now = DateManager.getTimeMillis())) {
            this.removeKeystore(entry.getKey());
        }
        if (this.cacheJCS == null && this.cacheSize > -1 && this.cacheMap.size() > this.cacheSize) {
            this.clearCacheMap();
        }
        return keystore;
    }

    private void clearCacheMap() {
        SemaphoreLock lock = this.lockCache.acquireThrowRuntime("clearCacheMap");
        try {
            this.cacheMap.clear();
        }
        finally {
            this.lockCache.release(lock, "clearCacheMap");
        }
    }
}

